<?php
namespace zin;

global $lang;

$fields = defineFieldList('repo.createrule', 'repo');

$fields->field('name')->control('input')->width('1/2')->required();
$fields->field('desc')->control('input')->width('1/2');

$fields->field('include')->wrapBefore()->width('full')
    ->label($lang->repo->rule->pattern)
    ->checkbox(array('name' => 'default', 'text' => $lang->repo->rule->defaultPattern, 'value' => 1, 'checked' => false))
    ->control(array
    (
        'control' => 'inputGroup',
        'items' => array
        (
            $lang->repo->rule->include,
            array('control' => 'input', 'name' => 'include')
        )
    ));

$fields->field('exclude')
    ->control(array
    (
        'control' => 'inputGroup',
        'items' => array
        (
            $lang->repo->rule->exclude,
            array('control' => 'input', 'name' => 'exclude')
        )
    ))
    ->width('full')
    ->tip($lang->repo->rule->patternTip);

$fields->field('user')
    ->label($lang->repo->rule->switchUser)
    ->className(data('hasSystem') ? '' : 'hidden')
    ->checkbox(array('name' => 'bypass', 'text' => $lang->repo->rule->byPassRuleTip, 'value' => 1, 'checked' => false))
    ->control('picker')
    ->multiple(true)
    ->items(data('users'))
    ->width('1/2');

$hiddenRule = array('require_minimum_count', 'require_code_owners', 'require_latest_commit', 'require_no_change_request', 'require_resolve_all', 'require_identifiers', 'strategies_allowed');
foreach($lang->repo->rule->ruleList as $ruleType => $rules)
{
    foreach($rules as $rule => $name)
    {
        $fields->field($rule)
            ->wrapBefore()
            ->label($rule == 'update_forbidden' ? $lang->repo->rule->allRule : null)
            ->className(in_array($rule, $hiddenRule) ? 'hidden' : '')
            ->control(array('type' => 'checkbox', 'name' => $rule, 'text' => $name, 'checked' => false))
            ->id($rule)
            ->value(1)
            ->tip($lang->repo->rule->ruleListTip[$rule])
            ->width('1/2');

        if($rule == 'require_minimum_count')
        {
            $fields->field('require_minimum_count_number')
                ->wrapBefore()
                ->label($lang->repo->rule->minRequireCount)
                ->className('hidden')
                ->controlBegin('input')
                ->id('require_minimum_count_number')
                ->type('number')
                ->value(1)
                ->min(1)
                ->controlEnd()
                ->width('1/2');
        }

        if($rule == 'require_identifiers')
        {
            $fields->field('pipeline')
                ->wrapBefore()
                ->label($lang->repo->rule->checkStatus)
                ->control('picker')
                ->id('pipeline')
                ->className('hidden')
                ->multiple(true)
                ->items(data('pipelineList'))
                ->width('1/2');
        }

        if($rule == 'strategies_allowed')
        {
            $fields->field('mergeType')
                ->wrapBefore()
                ->control('picker')
                ->id('mergeType')
                ->className('hidden')
                ->multiple(true)
                ->items($lang->repo->rule->mergeList)
                ->width('1/2');
        }
    }
}
