<?php
/**
 * The browse webhooks view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;
jsVar('ruleLang', $lang->repo->rule);
$module = $app->tab == 'devops' ? 'repo' : $app->tab;
dropmenu
(
    set::module($module),
    set::tab($module),
    set::url(createLink($module, 'ajaxGetDropMenu', "objectID=0&module={$app->rawModule}&method={$app->rawMethod}"))
);

featureBar();

$createRuleItem = array('text' => $lang->repo->createRule, 'url' => createLink('repo', 'createRule', "repoID={$repo->id}"));
toolBar
(
    hasPriv('repo', 'createRule') ? item(set($createRuleItem + array
    (
        'icon'  => 'plus',
        'class' => 'btn primary',
    )),
    set('data-app', 'devops')) : null
);

$ruleList = initTableData($rules, $config->repo->dtable->rule->fieldList);
$urlParams = array(
    'repoID'     => $repo->id,
    'orderBy'    => '{name}_{sortType}',
    'recPerPage' => $pager->recPerPage,
    'pageID'     => $pager->pageID
);

if(!empty($ruleList))
{
    foreach ($ruleList as $rule)
    {
        if(!empty($rule->actions))
        {
            foreach ($rule->actions as $key => $action) if($rule->status == 'active' && $action['name'] == 'enable') $rule->actions[$key]['name'] = 'disable';
        }
    }
}
$confirm = $lang->repo->rule->confirmRuleDelete;
dtable
(
    set::actionItemCreator(jsRaw(<<<JS
    (item, info) => {
        if(item.url)
        {
            if(typeof item.url == 'string') item.url = zui.formatString(item.url, info.row.data);
            else item.url.params = zui.formatString(item.url.params, info.row.data);
        }
        if(item.icon == 'trash')
        {
            const confirm = "{$confirm}";
            item['data-confirm']['message'] = confirm.replace('%s', info.row.data.name);
            Object.assign(item, item);
            return item;
        }
        return item;
    }
JS
)),
    set::cols($config->repo->dtable->rule->fieldList),
    set::data($ruleList),
    set::sortLink(createLink('repo', 'browserule', $urlParams)),
    set::orderBy($orderBy),
    set::footPager(usePager()),
    set::onRenderCell(jsRaw('window.renderRuleList'))
);
