window.renderRuleList = function (result, {col, row, value})
{
    if(col.name == 'name' && row.data.name == 'enforced-review')
    {
        result[0] = {html: '<span class="mr-1">' + result[0] + '</span><span class="label gray-pale lg"> '+ ruleLang.builtIn +'</span>'};
        const action = row.data.actions;
        action.forEach((item, index) => {
            if(item.name == 'delete') item.disabled = true;
            if(item.name == 'enable') item.disabled = true;
            if(item.name == 'disable') item.disabled = true;
        })
    }

    if(col.name == 'pattern')
    {
        const pattern     = result[0];
        if(pattern == 'unidentified unidentified unidentified')
        {
            result = [];
            return result;
        }
        const patternList = pattern.split(' ');
        let patternLabel = '';
        let patternTitle = '';
        if(patternList.length > 0)
        {
            patternList.forEach((item, index) => {
                if(index == 0)
                {
                    if(item != 'unidentified')
                    {
                        patternLabel += '<span class="label gray-pale mr-1">' + item + '</span>';
                        patternTitle = item;
                    }
                }
                if(index == 1)
                {
                    if(item != 'unidentified')
                    {
                        includeList = item.split(',');
                        if(patternTitle) patternTitle += '\n';
                        patternTitle += ruleLang.include + ': ' + item;
                        includeList.forEach((item, index) => {
                            patternLabel += '<span class="label success-pale mr-1">' + item + '</span>';
                        })
                    }
                }
                if(index == 2)
                {
                    if(item != 'unidentified')
                    {
                        excludeList = item.split(',');
                        if(patternTitle) patternTitle += '\n';
                        patternTitle += ruleLang.exclude + ': ' + item;
                        excludeList.forEach((item, index) => {
                            patternLabel += '<span class="label danger-pale mr-1">' + item + '</span>';
                        })
                    }
                }
            })
        }
        result[0] = {html: patternLabel};
        result[1].attrs.title = patternTitle;

    }
    return result;
}
