/*
 * Check sonarqube linked.
 */
window.setPipeline = function()
{
    if($('[name=engine]').val() != 'gitfox') $('.gitfox-pipeline').addClass('hidden');
    const $pipeline = $('[name=gitfoxpipeline]').zui('picker');
    if(!$pipeline) return;
    $pipeline.$.clear();

    const engine = $('[name=engine]').val();
    if(engine != 'gitfox') return;

    const repoID = $('[name=repo]').val();
    if(!repoID) return;
    $.getJSON($.createLink('job', 'ajaxGetPipelines', 'repoID=' + repoID), function(result)
    {
        let pipelines = [];
        if(result.data.length > 0) pipelines = result.data;

        $pipeline.render({items: pipelines});
        const pipeline = JSON.parse(job.pipeline).name;
        if(repoID == job.repo && pipeline) $pipeline.$.setValue(pipeline);
        $('.gitfox-pipeline').removeClass('hidden');
    })
}

const engineChange = window.changeEngine;
window.changeEngine = function(event)
{
    $('.gitfox-pipeline').addClass('hidden');
    engineChange(event);

    const engine = $(event.target).val();
    if(engine == 'gitfox') $('.gitfox-pipeline').removeClass('hidden');
}

const repoChange = window.changeRepo;
window.changeRepo = function()
{
    repoChange();
    window.setPipeline();
}

window.updateYamlPath = function (event)
{
    const name = $(event.target).val();
    $('input[name="yamlPath"]').val(`.gitfox/${name}.yaml`);
}
