<?php
/**
 * The edit view file of env module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     env
 * @link        https://www.zentao.net
 */
namespace zin;

formPanel
(
    set::id('envEditForm'),
    set::title($lang->env->edit),
    set::submitBtnText($lang->save),
    formGroup
    (
        set::name('name'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::required(true),
        set::label($lang->env->name),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::value($env->name)

    ),
    formGroup
    (
        set::name('code'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::label($lang->env->code),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::required(true),
        set::placeholder($lang->env->codePlaceholder),
        set::value($env->code)
    ),
    formGroup
    (
        set::name('system'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::label($lang->env->system),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::control('picker'),
        set::disabled(true),
        set::items($lang->env->systemList),
        set::value($env->system)
    ),
    formGroup
    (
        set::name('type'),
        set::width(common::checkNotCN() ? '3/4' : '1/2'),
        set::required(true),
        set::label($lang->env->type),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::control('picker'),
        set::items($lang->env->typeList),
        set::value($env->type)
    ),
    formGroup
    (
        set::name('desc'),
        set::label($lang->env->desc),
        set::labelWidth(common::checkNotCN() ? '160px' : '100px'),
        set::control(array('type' => 'textarea', 'rows' => '4')),
        set::value($env->desc)
    )
);

