<?php
namespace zin;

global $lang;

$envList      = data('envList');
$hosts        = data('hosts');
$hasFlow      = data('hasFlow');
$deploy       = data('deploy');
$releaseGroup = data('releaseGroup');

$hostsJS = array();
$envJS   = array();
if(!empty($hosts)) foreach($hosts as $hostID => $host) $hostsJS[] = array('value' => $hostID, 'text' => $host);
if(!empty($envList)) foreach($envList as $envID => $env) $envJS[] = array('value' => $envID, 'text' => $env);
jsVar('hosts', json_encode($hostsJS));
jsVar('envs', json_encode($envJS));
jsVar('deploy', $deploy);
jsVar('release', $releaseGroup);

query('#name')->before
(
    formGroup
    (
        set::width('1/2'),
        set::label($lang->deploy->type),
        set::name('type'),
        set::items($lang->deploy->typeList),
        set::disabled(true),
        set::required(true),
        set::value($deploy->type)
    )
);

query('#host')->before
(
    formGroup
    (
        setID('releaseTPL'),
        setClass('hidden'),
        set::width('1/2'),
        set::label($lang->deploy->releaseTPL),
        set::name('releaseTPL'),
        set::required(true),
        set::items(array()),
        on::change()->call('changeTPL')
    ),
    formGroup
    (
        setID('env'),
        set::width('1/2'),
        set::label($lang->deploy->env),
        set::name('env'),
        set::items($envList)
    )
);

query('#owner')->before
(
    formGroup
    (
        setID('systemVersion'),
        setClass('hidden'),
        set::width('1/2'),
        set::label($lang->deploy->systemVersion),
        set::name('systemVersion'),
        set::items(array()),
        set::required(true),
        on::change()->call('loadArtifact')
    ),
    formGroup
    (
        setID('artifact'),
        setClass('hidden'),
        set::width('1/2'),
        set::label($lang->deploy->artifact),
        set::name('artifact'),
        set::items(array()),
        set::required(true)
    )
);

jsVar('deployID', $deploy->id);
if($hasFlow)
{
    query('#desc')->before
    (
        formGroup
        (
            set::label($lang->deploy->reviewer),
            div(setID('reviewerBox'))
        )
    );
    pageJS(<<<JAVASCRIPT
    $(function()
    {
        var link = $.createLink('deploy', 'ajaxGetNodes', 'deployID=' + deployID);
        loadCurrentPage({url: link, selector: '#reviewerBox', partial: true});
    });
JAVASCRIPT
    );
}
