<?php
namespace zin;

global $app, $config, $lang;
$app->loadLang('artifactrepo');

jsVar('type', data('type'));
jsVar('copyMessage', $lang->artifactrepo->copied);
jsVar('artifacts', data('artifactList'));
jsVar('files', data('build')->files);

$build       = data('build');
$buildModule = $app->tab == 'project' ? 'projectbuild' : 'build';

if(common::hasPriv('build', 'view')) $config->build->artifact->dtable->fieldList['actions']['menu'][] = 'download|copyCommand';
if(common::hasPriv('build', 'edit')) $config->build->artifact->dtable->fieldList['actions']['menu'][] = 'unlinkArtifact';
if(!empty(data('childBuilds')))
{
    $builds = array();
    $builds[data('build')->id] = data('build')->name;
    foreach(data('childBuilds') as $childBuild)
    {
        $builds[$childBuild->id] = $childBuild->name;
    }
    $config->build->artifact->dtable->fieldList['build']['title']    = $lang->build->common;
    $config->build->artifact->dtable->fieldList['build']['name']     = 'build';
    $config->build->artifact->dtable->fieldList['build']['type']     = 'text';
    $config->build->artifact->dtable->fieldList['build']['order']    = '40';
    $config->build->artifact->dtable->fieldList['build']['map']      = $builds;
    $config->build->artifact->dtable->fieldList['build']['sortType'] = true;
}

$data = empty(data('artifactList')) ? array() : initTableData(data('artifactList'), $config->build->artifact->dtable->fieldList);

query('#buildTabs')->append
(
    tabPane
    (
        to::prefix(icon('stack')),
        set::key('artifacts'),
        set::title($lang->artifactrepo->artifact),
        set::active(data('type') == 'artifacts'),
        dtable
        (
            set::style(array('min-width' => '100%')),
            set::userMap(data('users')),
            set::cols($config->build->artifact->dtable->fieldList),
            set::data($data),
            set::rowKey('rowKey'),
            set::sortLink(createLink($buildModule, 'view', "buildID={$build->id}&type=artifacts&link=false&param=&orderBy={name}_{sortType}")),
            set::onRenderCell(jsRaw('window.renderArtifactsCell'))
        )
    ),
    h::css
    (
    <<<CSS
      #buildTabs .nav-tabs .nav-item[data-key="artifacts"] {order: 4}
      #buildTabs .nav-tabs .nav-item[data-key="buildInfo"] {order: 5}
CSS
    )
);
