<?php
/**
 * The linkArtifact view file of build module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     build
 * @link        https://www.zentao.net
 */
namespace zin;

global $app, $lang;
$app->loadLang('artifactrepo');
jsVar('buildLang', $lang->build->artifactRepo);

modalHeader(set::title(''), set::entityText($lang->build->artifactRepo->linkArtifact));
reset($linkArtifactRepos);
reset($linkArtifactRepos);

formPanel
(
    set::formID('linkArtifact'),
    on::change('[name=artifactRepo]')->call('window.loadArtifact'),
    on::init('#linkArtifact')->call('window.loadArtifact', key($linkArtifactRepos)),
    set::ajax(array('beforeSubmit' => jsRaw("window.clickOnLinkArtifact"))),
    formGroup
    (
        set::label($lang->artifactrepo->common),
        set::labelWidth(common::checkNotCN() ? '80px' : '50px'),
        picker(set::name('artifactRepo'), set::items($linkArtifactRepos), set::value(key($linkArtifactRepos)))
    ),
    div(setID('artifactTree'))
);
