<?php
namespace zin;

global $app, $lang;
$app->loadLang('artifactrepo');
jsVar('repos', data('repos'));
jsVar('buildLang', $lang->build->artifactRepo);

query('#buildDate')->after
(
    btn
    (
        set::className('btn primary-Outline artifactrepo hidden ml-2'),
        $lang->build->artifactRepo->selectArtifact,
        on::click()->call('window.selectArtifact')
    )
);

query('#buildDateRow')->after
(
    formRow
    (
        set::id('artifactList'),
        formGroup
        (
            set::label($lang->artifactrepo->artifact),
            set::width('1/2'),
            on::mouseenter('.artifact-link-list')->call('window.mouseEvent', 'enter', jsRaw('this')),
            on::mouseleave('.artifact-link-list')->call('window.mouseEvent', 'leave', jsRaw('this')),
            on::click('#artifactList .unlink-btn')->call('window.unlinkArtifact', jsRaw('this')),
            h::table
            (
                setClass('table table-hover table-fixed condensed borderless'),
                h::tbody()
            )
        )
    )
);
