<?php
/**
 * The artifacttree view file of build module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     build
 * @link        https://www.zentao.net
 */
namespace zin;
jsVar('buildLang', $lang->build->artifactRepo);

empty($tree) ? div
(
    setClass('dtable-empty-tip empty-artifact-tree'),
    on::init()->do('$("#linkArtifact .toolbar button").attr("disabled", true)'),
    div
    (
        setClass('text-gray'),
        $lang->build->artifactRepo->emptyArtifact
    )
) :
div
(
    on::init()->do('$("#linkArtifact .toolbar button").removeAttr("disabled")'),
    treeEditor
    (
        set::id('filesTree'),
        set::items($tree),
        set::canSplit(false),
        set::collapsedIcon('folder text-warning'),
        set::expandedIcon('folder-open text-warning'),
        set::normalIcon('stack'),
        set::preserve(false),
        set::expanded(false),
        set::checkOnClick('any'),
        set::onClickItem(jsRaw('window.treeClick'))
    )
);
