<?php
$bug = parent::extractObjectFromExtras($bug, $output);
if(!empty($output) && !empty($output['from']) && $output['from'] == 'codescan')
{
    $issueID  = zget($output, 'fromID', 0);
    $gitfoxID = zget($output, 'fromServerID', 0);
    $issue    = $this->loadModel('codescan')->getScanIssue($gitfoxID, $issueID);
    if(!empty($issue))
    {
        $severityList = $this->config->bug->scanSeverityList;
        $typeList     = $this->config->bug->scanTypeList;

        $bug->title    = zget($issue, 'content', '');
        $bug->severity = zget($severityList, $issue->priority, 3);
        $bug->pri      = zget($severityList, $issue->priority, 3);
        $bug->type     = zget($typeList, $issue->type, 'codeerror');

        $step = zget($issue, 'file');
        if(!empty($issue->line)) $step .= ' +' . $issue->line;
        $result       = $bug->title;
        $expectations = zget($issue, 'recommend', '');
        $bug->steps = sprintf($this->lang->bug->scanIssueTemplate, $step, $result, $expectations);
    }
}
