<?php
namespace zin;
$issueList = data('issueList');
$users     = data('users');
global $lang, $config;

if(!empty($issueList))
{
    $severityList = $config->bug->scanSeverityList;
    $typeList     = $config->bug->scanTypeList;

    $issueData = array();
    foreach($issueList as $issue)
    {
        $committer = '';
        if(!empty($issue->payload->location) || !empty($issue->payload->location->commit) || !empty($issue->payload->location->commit->author))
        {
            $committer = $issue->payload->location->commit->author;
        }
        $step = zget($issue, 'file');
        if(!empty($issue->line)) $step .= ' +' . $issue->line;
        $result       = zget($issue, 'content', '');
        $expectations = zget($issue, 'recommend', '');

        $issueData[] = array
        (
            'title'      => $result,
            'issueKey'   => $issue->id,
            'repo'       => data('repo'),
            'severity'   => zget($severityList, $issue->priority, 3),
            'pri'        => zget($severityList, $issue->priority, 3),
            'type'       => zget($typeList, $issue->type, 'codeerror'),
            'steps'      => sprintf($lang->bug->scanIssueTemplate, $step, $result, $expectations),
            'assignedTo' => in_array($committer, array_keys($users)) && !empty($users) && !$committer ? $committer : ''
        );
    }

    query('formBatchPanel')->each(function($node) use($issueList, $issueData, $lang, $users)
    {
        $node->setProp('maxRows', count($issueList));
        $node->setProp('back', 'codescan-taskview,codescan-issue');
        $items = $node->prop('items');
        foreach($items as &$item)
        {
            if(in_array($item['name'], array('type', 'pri'))) $item['ditto'] = false;
            if(in_array($item['name'], array('steps', 'os', 'browser'))) $item['hidden'] = true;
        }
        $items[] = array('name' => 'issueKey', 'label' => '', 'control' => 'hidden', 'hidden' => true);
        $items[] = array('name' => 'ass', 'label' => '', 'control' => 'hidden', 'hidden' => true);
        $items[] = array('name' => 'repo', 'label' => '', 'control' => 'hidden', 'hidden' => true);
        $items[] = array('name' => 'assignedTo', 'label' => $lang->bug->assignedTo, 'control' => 'picker', 'items' => $users, 'ditto' => true, 'width' => '200px');
        $node->setProp('items', $items);
        $node->setProp('data', $issueData);
    });
}
