CREATE TABLE IF NOT EXISTS `zt_template` (
    `id` int unsigned NOT NULL AUTO_INCREMENT,
    `system` varchar(64)  NOT NULL DEFAULT '',
    `remoteID` mediumint(8) unsigned NOT NULL DEFAULT 0,
    `systemID` mediumint(8) unsigned NOT NULL DEFAULT 0,
    `clusterID` int unsigned NOT NULL DEFAULT 0,
    `settings` text NULL,
    `name` varchar(255) NOT NULL DEFAULT '',
    `hosts` varchar(50)  NOT NULL DEFAULT '',
    `envID` mediumint(8) unsigned NOT NULL DEFAULT 0,
    `desc` varchar(255) NOT NULL DEFAULT '',
    `createdBy` varchar(30)  NOT NULL DEFAULT '',
    `createdDate` datetime DEFAULT NULL,
    `editedBy` varchar(30)  NOT NULL DEFAULT '',
    `editedDate` datetime DEFAULT NULL,
    `deleted` enum('0','1') NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE `zt_system` ADD COLUMN `appKey` varchar(64) NOT NULL DEFAULT '' AFTER `name`;
ALTER TABLE `zt_system` ADD COLUMN `remoteAppID` varchar(32) NOT NULL DEFAULT '' AFTER `name`;

CREATE TABLE IF NOT EXISTS `zt_cluster` (
  `id` INT UNSIGNED AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL DEFAULT '',
  `apiUrl` VARCHAR(255) NOT NULL DEFAULT '',
  `token` VARCHAR(255) NOT NULL DEFAULT '',
  `env` INT NOT NULL DEFAULT 0,
  `desc` TEXT NULL,
  `createdBy` VARCHAR(30) NOT NULL DEFAULT '',
  `createdDate` DATETIME NULL,
  `editedBy` VARCHAR(30) NOT NULL DEFAULT '',
  `editedDate` DATETIME NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE `zt_deploy` DROP `app`;
ALTER TABLE `zt_deploy` ADD `artifact` TEXT NULL AFTER `releaseTPL`;
