<?php
/**
 * 按系统统计Gitfox制品总数
 * Count of gitfox artifact.
 *
 * 范围：system
 * 对象：artifact
 * 目的：scale
 * 度量名称：按系统统计Gitfox制品总数
 * 单位：个
 * 描述：按系统统计的Gitfox制品总数是指在禅道中GitFox类型制品库的全部制品总数。
 * 定义：所有的Gitfox制品求和
 *
 * @copyright Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @author    liyang <liyang@easycorp.ltd>
 * @package
 * @uses      func
 * @license   ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @Link      https://www.zentao.net
 */
class count_of_gitfox_artifact extends baseCalc
{
    public $useSCM = true;

    public $dataset = 'getArtifactRepos';

    public $fieldList = array('repoName');

    public $rows = array();

    public function calculate($row)
    {
        $this->rows[] = $row->repoName;
    }

    public function getResult($options = array())
    {
        $count = 0;

        if(!empty($this->repos) && !empty($this->scm))
        {
            $artifact = current($this->repos);
            $artifact->client   = '';
            $artifact->account  = '';
            $artifact->encoding = 'utf-8';
            $artifact->password = $artifact->token;
            $artifact->apiPath  = $artifact->serverUrl . '/api/v1';
            $artifact->SCM      = 'GitFox';
            $this->scm->setEngine($artifact);

            $result = $this->scm->engine->countArtifacts();
            if(!empty($result) && !empty($result->space))
            {
                $spaceList = $result->space;
                foreach($spaceList as $space => $spaceStatistic)
                {
                    if(in_array($space, $this->rows))
                    $count += $spaceStatistic->total;
                }
            }
        }

        $records = array(array('value' => $count));
        return $this->filterByOptions($records, $options);
    }
}
