<?php
/**
 * The setting view file of instance module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2025 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      ZhangXiquan<zhangxiquan@chandao.com>
 * @package     instance
 * @link        https://www.zentao.net
 */

namespace zin;

$warning = zget($setting, 'warning', new stdClass());
$danger  = zget($setting, 'danger', new stdClass());
formPanel
(
    set::id('monitorSetting'),
    set::title($title),
    on::click('#installOrStart')->call('installOrStart'),
    on::click('#resetMonitorSetting')->call('resetMonitorSetting', $this->lang->space->monitor->resetConfirm),
    set::actions(array(
        hasPriv('instance', 'manage') ? (
        isset($code) ? array(
            'text'  => $btnText,
            'id'    => 'installOrStart',
            'class' => 'btn secondary',
        ) : null) : null,
        isset($code) ? null : array(
            'text'  => $this->lang->space->monitor->resetBtn,
            'id'    => 'resetMonitorSetting',
            'class' => 'btn secondary',
        ),
        isset($code) ? null : 'submit',
        array('text' => $this->lang->cancel, 'data-type' => 'submit', 'data-dismiss' => 'modal')
    )),
    set::submitBtnText($btnText),
    setClass('w-full'),
    isset($code) ? formRow
    (
        input(setClass('hidden'), set::name('code'), set::value($code)),
        span(
            ($code == $this->config->space->monitorNotStart) ? $this->lang->space->monitor->unStart : $this->lang->space->monitor->unInstall
        )
    ) : h::table
    (
        setClass('table bordered'),
        h::thead
        (
            h::tr(setClass('text-center'),
            h::td(setClass('w-24')),
            h::td($lang->space->monitor->warningTitle),
            h::td($lang->space->monitor->dangerTitle))
        ),
        h::tr
        (
            h::td($lang->space->monitor->cpu),
            h::td
            (
                formRow
                (
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->used, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('warning[cpu][threshold]'),
                                set::value(empty($warning->cpu->threshold) ? 80 : $warning->cpu->threshold)
                            ),
                            span(setClass('input-group-addon ghost'), '%')
                        )
                    ),
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->duration, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('warning[cpu][duration]'),
                                set::value(empty($warning->cpu->duration) ? 5 : $warning->cpu->duration)
                            ),
                            span(setClass('input-group-addon ghost'), $lang->space->monitor->minutes)
                        )
                    )
                )
            ),
            h::td
            (
                formRow
                (
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->used, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('danger[cpu][threshold]'),
                                set::value(empty($danger->cpu->threshold) ? 90 : $danger->cpu->threshold)
                            ),
                            span(setClass('input-group-addon ghost'), '%')
                        )
                    ),
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->duration, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('danger[cpu][duration]'),
                                set::value(empty($danger->cpu->duration) ? 10 : $danger->cpu->duration)
                            ),
                            span(setClass('input-group-addon ghost'), $lang->space->monitor->minutes)
                        )
                    )
                )
            )
        ),
        h::tr
        (
            h::td($lang->space->monitor->memory),
            h::td
            (
                formRow
                (
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->over, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('warning[memory][threshold]'),
                                set::value(zget(empty($warning->memory) ? new stdClass() : $warning->memory, 'threshold', 80))
                            ),
                            span(setClass('input-group-addon ghost'), '%')
                        )
                    )
                )
            ),
            h::td
            (
                formRow
                (
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->over, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('danger[memory][threshold]'),
                                set::value(empty($danger->memory->threshold) ? 90 : $danger->memory->threshold)
                            ),
                            span(setClass('input-group-addon ghost'), '%')
                        )
                    )
                )
            )
        ),
        h::tr
        (
            h::td($lang->space->monitor->disk),
            h::td
            (
                formRow
                (
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->over, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('warning[disk][threshold]'),
                                set::value(empty($warning->disk->threshold) ? 80 : $warning->disk->threshold)
                            ),
                            span(setClass('input-group-addon ghost'), '%')
                        )
                    )
                )
            ),
            h::td
            (
                formRow
                (
                    formGroup
                    (
                        inputGroup
                        (
                            span($lang->space->monitor->over, setClass('input-group-addon ghost')),
                            input
                            (
                                set::name('danger[disk][threshold]'),
                                set::value(empty($danger->disk->threshold) ? 90 : $danger->disk->threshold)
                            ),
                            span(setClass('input-group-addon ghost'), '%')
                        )
                    )
                )
            )
        )
    )
);
