<?php include $app->getModuleRoot() . 'common/view/header.lite.html.php';?>
<?php include $app->getModuleRoot() . 'common/view/chosen.html.php';?>
<?php js::import($jsRoot . 'echarts/echarts.common.min.js'); ?>
<?php js::import($jsRoot . 'echarts/timeline.min.js'); ?>
<?php js::import($jsRoot . 'html2canvas/min.js'); ?>
<?php js::set('beginDate',     $begin);?>
<?php js::set('endDate',       $end);?>
<?php js::set('begin',         strtotime($begin));?>
<?php js::set('end',           strtotime($end));?>
<?php js::set('screenID',      $screenID);?>
<?php js::set('issueChart',    $issueChart);?>
<?php js::set('pipelineChart', $pipelineChart);?>
<?php js::set('commitStat',    $commitStat);?>
<?php js::set('userStat',      $userStat);?>
<?php js::set('minDate', date('Y-m-d', strtotime('-1 year'))); ?>
<?php js::set('maxDate', helper::today()); ?>

<?php $devopsLang = $lang->report->devopsScreen;?>
<?php js::set('devopsLang', $devopsLang);?>
<div id='container' style='background-image: url(<?php echo $config->webRoot . 'theme/default/images/main/annual_data_bg.png'?>)'>
  <main id='main' style='background: url(<?php echo $config->webRoot . 'theme/default/images/main/annual_layout_header.png'?>) top no-repeat'>
    <header id='header'>
      <h1 class='text-holder' data-id='title'><?php echo $title;?></h1>
    </header>
    <div id='toolbar'>
      <div class='pull-left'>
        <span><?php echo $devopsLang->scope;?></span>
        <?php echo html::input('begin', $begin, "class='form-control form-date' placeholder='{$devopsLang->start}'");?>
        <?php echo html::input('end',   $end,   "class='form-control form-date' placeholder='{$devopsLang->end}'");?>
      </div>
    </div>
    <section class="border-none">
      <div class='base-info'>
        <header>
          <h2><?php echo $devopsLang->repoTitle;?></h2>
          <i class='icon icon-help' data-toggle='popover' data-html=true data-trigger='focus hover' data-placement='right' data-tip-class='text-muted popover-sm' data-content="<?php echo $devopsLang->tips->repo;?>"></i>
          <div class="flex title-tail">
            <img width="14" height="11" src="static/images/line_left.png" loading="eager" data-error="false" data-preview-src="static/images/line_left.png" data-group-id="" style="object-fit: fill;">
            <img width="500" height="17" src="static/images/line_right.png" loading="eager" data-error="false" data-preview-src="static/images/line_right.png" data-group-id="" style="object-fit: none;">
          </div>
        </header>
        <div>
          <div class='info-list'>
            <div class="flex-content">
              <strong><?php echo $activeRepoData['count'];?></strong>
              <?php echo $devopsLang->repoCount;?>
            </div>
            <div class="flex-content mx-20">
              <strong><?php echo $activeRepoData['userCount'];?></strong>
              <?php echo $devopsLang->contributorCount;?>
            </div>
            <div class="flex-content">
              <strong><?php echo $activeRepoData['commitCount'];?></strong>
              <?php echo $devopsLang->commitCount;?>
            </div>
          </div>
        </div>
      </div>
      <div class='base-info mt-4'>
        <header>
          <h2 class='text-holder'><?php echo $devopsLang->codeQuality;?></h2>
          <div class="flex title-tail">
            <img width="14" height="11" src="static/images/line_left.png" loading="eager" data-error="false" data-preview-src="static/images/line_left.png" data-group-id="" style="object-fit: fill;">
            <img width="500" height="17" src="static/images/line_right.png" loading="eager" data-error="false" data-preview-src="static/images/line_right.png" data-group-id="" style="object-fit: none;">
          </div>
        </header>
        <div>
          <div class='info-list'>
            <div class="flex-content">
              <strong><?php echo $codeQualityData['mrSuccessRate']*100 . '%';?></strong>
              <?php echo $devopsLang->mergeRate;?>
            </div>
            <div class="flex-content mx-20">
              <strong><?php echo $codeQualityData['newIssue'];?></strong>
              <?php echo $devopsLang->issueCount;?>
            </div>
            <div class="flex-content">
              <strong><?php echo $codeQualityData['activeIssue'];?></strong>
              <?php echo $devopsLang->solvedIssue;?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section id='actionData'>
      <div>
        <header>
          <h2 class='text-holder'><?php echo $devopsLang->summary;?></h2>
          <i class='icon icon-help' data-toggle='popover' data-html=true data-trigger='focus hover' data-placement='right' data-tip-class='text-muted popover-sm' data-content="<?php echo $devopsLang->tips->stat;?>"></i>
          <div class="flex title-tail">
            <img width="14" height="11" src="static/images/line_left.png" loading="eager" data-error="false" data-preview-src="static/images/line_left.png" data-group-id="" style="object-fit: fill;">
            <img width="500" height="17" src="static/images/line_right.png" loading="eager" data-error="false" data-preview-src="static/images/line_right.png" data-group-id="" style="object-fit: none;">
          </div>
        </header>
        <div class='info-list summary-block'>
          <div class="flex-content">
            <strong><?php echo $repoCount;?></strong>
            <?php echo $devopsLang->repoTotal;?>
          </div>
          <div class="flex-content">
            <strong><?php echo zget($pipelineCountData, 'count', 0);?></strong>
            <?php echo $devopsLang->pipelineTotal;?>
          </div>
          <div class="flex-content">
            <strong><?php echo $artifactCount;?></strong>
            <?php echo $devopsLang->artifactTotal;?>
          </div>
          <div class="flex-content">
            <strong><?php echo $successDeployCount;?></strong>
            <?php echo $devopsLang->successCount;?>
          </div>
          <div class="flex-content">
            <strong><?php echo zget($cneInfo, 'nodeCount', 0);?></strong>
            <?php echo $devopsLang->nodeCount;?>
          </div>
          <div class="flex-content">
            <strong><?php echo zget($cneInfo, 'serviceCount', 0);?></strong>
            <?php echo $devopsLang->serviceCount;?>
          </div>
        </div>
      </div>
    </section>
    <section class="border-none" id='pipeline'>
      <div class='base-info'>
        <header>
          <h2 class='text-holder'><?php echo $devopsLang->pipelineHealth;?></h2>
          <div class="flex title-tail">
            <img width="14" height="11" src="static/images/line_left.png" loading="eager" data-error="false" data-preview-src="static/images/line_left.png" data-group-id="" style="object-fit: fill;">
            <img width="500" height="17" src="static/images/line_right.png" loading="eager" data-error="false" data-preview-src="static/images/line_right.png" data-group-id="" style="object-fit: none;">
          </div>
        </header>
        <div>
          <div class='info-list'>
            <div class="flex-content">
              <strong><?php echo zget($pipelineCountData, 'execCount', 0);?></strong>
              <?php echo $devopsLang->pipelineCount;?>
            </div>
            <div class="flex-content mx-20">
              <strong><?php echo zget($pipelineCountData, 'execSuccess', 0)*100 . '%';?></strong>
              <?php echo $devopsLang->pipelineSuccess;?>
            </div>
            <div class="flex-content">
              <strong><?php echo zget($pipelineCountData, 'execAvgTime', 0);?></strong>
              <?php echo $devopsLang->avgDuration;?>
            </div>
          </div>
        </div>
      </div>
      <div class='base-info mt-4'>
        <header>
          <h2 class='text-holder'><?php echo $devopsLang->deploy;?></h2>
          <i class='icon icon-help' data-toggle='popover' data-html=true data-trigger='focus hover' data-placement='right' data-tip-class='text-muted popover-sm' data-content="<?php echo $devopsLang->tips->deploy;?>"></i>
          <div class="flex title-tail">
            <img width="14" height="11" src="static/images/line_left.png" loading="eager" data-error="false" data-preview-src="static/images/line_left.png" data-group-id="" style="object-fit: fill;">
            <img width="500" height="17" src="static/images/line_right.png" loading="eager" data-error="false" data-preview-src="static/images/line_right.png" data-group-id="" style="object-fit: none;">
          </div>
        </header>
        <div>
          <div class='info-list'>
            <div class="flex-content">
              <strong><?php echo zget($deployCountData, 'count', 0);?></strong>
              <?php echo $devopsLang->deployCount;?>
            </div>
            <div class="flex-content mx-20">
              <strong><?php echo zget($deployCountData, 'successRate', 0)*100 . '%';?></strong>
              <?php echo $devopsLang->deploySuccess;?>
            </div>
            <div class="flex-content">
              <strong><?php echo zget($deployCountData, 'avgReadyTime', 0);?></strong>
              <?php echo $devopsLang->deployDuration;?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section id='repoData'>
      <header>
        <h2 class='text-holder'><?php echo $devopsLang->repoData;?></h2>
        <div class="flex title-tail" style="padding-right: 10px;">
          <img width="14" height="11" src="static/images/line_left.png" loading="eager" data-error="false" data-preview-src="static/images/line_left.png" data-group-id="" style="object-fit: fill;">
          <div class='bottom-line' >
        </div>
      </header>
      <div class='has-table'>
        <table class='table table-hover table-fixed table-borderless table-condensed'>
          <thead class='hidden'>
            <tr>
              <?php foreach($devopsLang->repoTable as $field => $name):?>
              <th class='c-<?php echo $field;?>'><?php echo $name;?></th>
              <?php endforeach?>
            </tr>
          </thead>
          <tbody>
            <?php foreach($topRepos as $repo):?>
            <tr>
              <td class='<?php echo "c-repo";?>' title='<?php echo $repo->name;?>'><?php echo $repo->name;?></td>
              <td class='<?php echo "c-actions";?>' title='<?php echo $repo->commit_count;?>'><?php echo $repo->commit_count;?></td>
              <td class='<?php echo "c-branches";?>' title='<?php echo $repo->branch_count;?>'><?php echo $repo->branch_count;?></td>
              <td class='<?php echo "c-tags";?>' title='<?php echo $repo->tag_count;?>'><?php echo $repo->tag_count;?></td>
              <td class='<?php echo "c-pushes";?>' title='<?php echo $repo->push_req_count;?>'><?php echo $repo->push_req_count;?></td>
              <td class='<?php echo "c-merges";?>' title='<?php echo zget($mrStat, $repo->id, $repo->pull_req_count);?>'><?php echo zget($mrStat, $repo->id, $repo->pull_req_count);?></td>
              <td class='<?php echo "c-pipelines";?>' title='<?php echo zget($pipelineStat, $repo->id, 0);?>'><?php echo zget($pipelineStat, $repo->id, 0);?></td>
              <td class='<?php echo "c-todos";?>' title='<?php echo zget($issueStat, $repo->id, 0);?>'><?php echo zget($issueStat, $repo->id, 0);?></td>
            </tr>
            <?php endforeach;?>
          </tbody>
        </table>
      </div>
      <div class='table-header-fixed'>
        <table class='table table-hover table-fixed table-borderless table-condensed'>
          <thead>
            <tr>
              <?php foreach($devopsLang->repoTable as $field => $name):?>
              <th class='<?php echo "c-$field";?>'><?php echo $name;?></th>
              <?php endforeach?>
            </tr>
          </thead>
        </table>
      </div>
    </section>

    <div id='sectionToolbar'>
      <div class='pull-left mt-60'>
        <span><?php echo $devopsLang->repoTable->repo;?></span>
        <?php echo html::select('repo', $repoPairs, $repoID, "class='form-control chosen'");?>
      </div>
    </div>
    <section id='repoChart' class="border-none">
      <div class="mt-2 flex">
        <div class='canvas' id='repoCommit'></div>
        <div class='canvas' id='repoRank'></div>
      </div>
      <div class="mt-60 flex">
        <div class='canvas' id='repoTrend'></div>
        <div class='canvas' id='pipelineTrend'></div>
      </div>
    </section>
  </main>
  <div id='loadIndicator' class='load-indicator'></div>
</div>
<?php include $app->getModuleRoot() . 'common/view/footer.lite.html.php';?>
