<?php
/**
 * The set commit rule view file of repo module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     repo
 * @link        https://www.zentao.net
 */
namespace zin;
include 'sidebar.html.php';

form
(
    setClass('flex-auto canvas panel-body pb-8'),
    set::actionsClass('w-1/2'),
    set::actions(array('submit')),
    span
    (
        setClass('text-md font-bold'),
        $lang->repo->commitRule->rules['safe']
    ),
    formGroup
    (
        set::width('1/3'),
        set::label($lang->repo->rule->keyScan),
        radioList
        (
            set::name('keyScan'),
            set::items($lang->repo->rule->setkeyScanList),
            set::value($ztFlowEnabled),
            set::inline(true)
        )
    ),
    formRow
    (
        setClass('percent-tip'),
        formGroup
        (
            set::label(''),
            span
            (
                icon('info text-warning mr-2'),
                $lang->repo->rule->keyScanNotice
            )
        )
    )
);
