<?php
namespace zin;

global $lang, $app;
$users = data('users');

$hasGitfox   = false;
$serverPairs = $app->control->loadModel('pipeline')->getPairs('gitfox', true);
if($serverPairs) $hasGitfox = true;

$serverPairs += $app->control->loadModel('pipeline')->getPairs('gitlab', true);

$serviceList = array();
foreach ($serverPairs as $server => $name) $serviceList[] = array('text' => $name, 'value' => $server);
$server = $serverPairs ? key($serverPairs) : '';

$serverDom = picker
(
    set::items($serviceList),
    set::name('serviceHost'),
    set::required(true),
    set::id('serviceHost'),
    set::value($server)
);

query('#serviceHost')->replaceWith($serverDom);

if($hasGitfox)
{
    $repoGroups   = $app->control->loadModel('repo')->getGroups($server);
    $systemServer = $app->control->loadModel('instance')->getSystemServer();
    $namespaceDom = picker
    (
        set::id("namespace"),
        set::name("namespace"),
        set::required(true),
        set::items($repoGroups)
    );

    query('#namespace')->replaceWith($namespaceDom);
    if(!empty($systemServer) && $systemServer->id == $server) query('#namespace')->closest('.form-group')->addClass('hidden');

    $committerDom = formRow
    (
        setID("committer"),
        !empty($systemServer) && $systemServer->id == $server ? null : set::className('hidden'),
        formGroup
        (
            set::width('1/2'),
            set::name("committer"),
            set::label($lang->repo->committer),
            set::control('picker'),
            set::multiple(true),
            set::items($users)
        ),
        span
        (
            icon('help'),
            setClass('ml-2 mt-2'),
            toggle::tooltip(array('title' => $lang->repo->committerTip)),
            setData(array(
                'type'       => 'white',
                'placement'  => 'right',
                'class-name' => 'text-gray border border-light'
            ))
        )
    );
    query('#aclList')->before($committerDom);
}
