<?php
/**
 * The control file of publishtemplate module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Xiquan Zhang<zhangxiquan@chandao.com>
 * @link        https://www.zentao.net
 */
namespace zin;
jsVar('templateLang', $lang->publishtemplate);

$canCreate  = hasPriv('publishtemplate', 'create');
$createLink = $this->createLink('publishtemplate', 'create', "&type=$type");
$createItem = array('text' => $lang->publishtemplate->create, 'url' => $createLink, 'class' => 'primary', 'icon' => 'plus', 'data-toggle' => 'modal');

$config->publishtemplate->featureBar[$type]['active'] = true;
$config->publishtemplate->featureBar[$type]['badge']  = $pager->recTotal != '' ? array('text' => $pager->recTotal, 'class' => 'size-sm rounded-full white') : null;

featureBar
(
    set::current($type),
    set::linkParams("type={key}"),
    set::queryMenuLinkCallback(array(function ($key) use ($queryMenuLink) {
        return str_replace('{queryID}', (string)$key, $queryMenuLink);
    })),
    btn
    (
        setClass('text-gray ghost'),
        set::icon('help'),
        set::url($config->publishtemplate->helpURL),
        set::target('_blank'),
        set::hint($lang->publishtemplate->helpTip),
        $lang->help
    )
);

toolbar($canCreate ? item(set($createItem)) : null);

$config->publishtemplate->dtable->spug->fieldList['systemID']['map'] = $systemPairs;
$config->publishtemplate->dtable->spug->fieldList['envID']['map']    = $envPairs;

$config->publishtemplate->dtable->cne->fieldList['systemID']['map'] = $systemPairs;
// $config->publishtemplate->dtable->cne->fieldList['envID']['map']     = $envPairs;
// $config->publishtemplate->dtable->cne->fieldList['clusterID']['map'] = $clusterPairs;

$tableData = initTableData($lists, $config->publishtemplate->dtable->{$type}->fieldList, $this->publishtemplate);

dtable
(
    set::cols($config->publishtemplate->dtable->{$type}->fieldList),
    set::data($tableData),
    set::sortLink(createLink('publishtemplate', 'browse', "type={$type}&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}")),
    set::orderBy($orderBy),
    set::actionItemCreator(jsRaw('window.renderActions')),
    set::footPager(usePager())
);
