<?php
if(isset($jobQuery))
{
    $jobList = parent::getJobList($repoID, $jobQuery, $orderBy, $pager);
}
else
{
    $jobList = parent::getJobList($repoID, $orderBy, $pager);
}

$this->loadModel('repo');
$hasSystemServer = false;
$hasCommitter    = $this->app->user->admin;
$systemServer    = $this->loadModel('instance')->getSystemServer();
if($repoID)
{
    $repo = $this->repo->fetchByID($repoID);
    if($repo->SCM == 'GitFox')
    {
        $hasSystemServer = !empty($systemServer) && $systemServer->id == $repo->serviceHost;
        if(!$hasCommitter)
        {
            $repoMembers  = $this->loadModel('gitfox')->getRepoMembers($repo);
            $hasCommitter = !empty($repoMembers) && isset($repoMembers[$this->app->user->account]);
        }

        if($hasCommitter) array_splice($this->config->job->dtable->fieldList['actions']['menu'], 2, 0, 'arrange');
    }
}

$this->view->hasSystemServer = $hasSystemServer;
if(empty($jobList)) return $jobList;

$systemRepos = array();
if(!empty($systemServer))
{
    $repos = $this->repo->getList();
    foreach($repos as $repo)
    {
        if($repo->serviceHost == $systemServer->id) $systemRepos[] = $repo->id;
    }
}

foreach($jobList as $job) $job->hasSystem = !empty($systemRepos) && in_array($job->repo, $systemRepos);
return $jobList;
