<?php
/**
 * The create pipeline view file of job module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@chandao.com>
 * @package     job
 * @link        https://www.zentao.net
 */
namespace zin;

modalHeader
(
    set::title($lang->job->editPipeline),
    set::titleClass('panel-title text-lg')
);

formPanel
(
    formGroup
    (
        setID('pipelineName'),
        set::label($lang->job->pipelineName),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        set::required(true),
        set::name('pipelineName'),
        set::value($job->name)
    ),
    formGroup
    (
        setID('repo'),
        set::label($lang->job->repo),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        set::name('repo'),
        set::value($repo->name),
        set::disabled(true)
    ),
    formGroup
    (
        set::label($lang->job->repoBranch),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        picker
        (
            set::name('branch'),
            set::items($branchList),
            set::value(zget($pipeline, 'reference', '')),
            set::disabled(true),
            set::required(true)
        )
    ),
    formGroup
    (
        setID('yamlPath'),
        set::label($lang->job->yamlPath),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        set::required(true),
        set::name('yamlPath'),
        set::value(zget($pipeline, 'configPath', ''))
    ),
    formGroup
    (
        set::label($lang->job->product),
        set::labelWidth(common::checkNotCN() ? '120px' : '100px'),
        picker
        (
            set::name('product'),
            set::items($products),
            set::value(zget($job, 'product', 0))
        )
    )
);
