$(function()
{
    setTimeout(changeType, 50);
});

window.changeType = function ()
{
    const type = $('[name=type]').val();
    if(typeof type === 'undefined') return;

    const hostPicker       = $('[name^=host]').zui('picker');
    const envPicker        = $('[name=env]').zui('picker');
    const releaseTPLPicker = $('[name=releaseTPL]').zui('picker');
    const systemPicker     = $('[name=systemVersion]').zui('picker');
    const artifactPicker   = $('[name=artifact]').zui('picker');

    hostPicker.$.clear();
    envPicker.$.clear();
    systemPicker.$.clear();
    artifactPicker.$.clear();
    releaseTPLPicker.$.clear();

    releaseTPLPicker.render({items: []});
    envPicker.render({items: [], required: false});
    systemPicker.render({items: []});
    artifactPicker.render({items: []});

    $('#artifact').addClass('hidden');
    $('[name=env]').closest('.form-group').find('.form-label').removeClass('required');
    $('[name^=host]').closest('.form-group').find('.form-label').removeClass('required');

    if(type == 'spug')
    {
        $('#releaseTPL').removeClass('hidden');
        $('#systemVersion').removeClass('hidden');
        $('#productRow').addClass('hidden');
        $('#env').addClass('hidden');
        $('#host').removeClass('hidden');
        $('[name=host]').closest('.form-group').find('.form-label').addClass('required');
        hostPicker.render({items: [], multiple: true});

    }
    else if(type == 'cne')
    {
        $('#releaseTPL').removeClass('hidden');
        $('#systemVersion').removeClass('hidden');
        $('#productRow').addClass('hidden');
        $('#host').addClass('hidden');
        $('#env').addClass('hidden');
        $('#artifact').removeClass('hidden');
    }
    else
    {
        $('#releaseTPL').addClass('hidden');
        $('#systemVersion').addClass('hidden');
        $('#env').removeClass('hidden');
        $('#host').removeClass('hidden');
        $('#productRow').removeClass('hidden');

        hostPicker.render({items: JSON.parse(hosts), multiple: false});
        envPicker.render({items: JSON.parse(envs)});
        if(typeof deploy != 'undefined')
        {
            envPicker.$.setValue(deploy.env);
            hostPicker.$.setValue(deploy.host);
        }
    }

    initTPL();
};

window.initTPL = function ()
{
    const type = $('[name=type]').val();
    if(typeof type === 'undefined' || type == 'manual') return;

    toggleLoading('#releaseTPL', true);
    const $picker = $('[name=releaseTPL]').zui('picker');
    $picker.$.clear();

    $.getJSON($.createLink('deploy', 'ajaxGetTPL', 'type=' + type), function(items)
    {
        $picker.render({items: items});
        if(typeof(deploy) != 'undefined') $picker.$.setValue(deploy.releaseTPL);
        toggleLoading('#releaseTPL', false);
    });
};

window.changeTPL = function ()
{
    const type = $('[name=type]').val();
    if(typeof type === 'undefined' || type == 'manual') return;
    const templateID = $('[name=releaseTPL]').val();
    if(typeof templateID === 'undefined' || !templateID) return;

    if(type == 'spug') toggleLoading('#host', true);
    toggleLoading('#systemVersion', true);

    const $hostPicker    = $('[name^=host]').zui('picker');
    const $envPicker     = $('[name=env]').zui('picker');
    const $systemPicker  = $('[name=systemVersion]').zui('picker');
    $hostPicker.$.clear();
    $systemPicker.$.clear();
    $envPicker.$.clear();

    $.getJSON($.createLink('deploy', 'ajaxGetTemplateInfo', 'templateID=' + templateID), function(data)
    {
        if(data)
        {
            if(type == 'spug')
            {
                $hostPicker.render({items: data.hostList});
                if(data.hostList.length > 0)
                {
                    setTimeout(function () {$hostPicker.$.setValue(data.hostList.map(element => element.value))}, 50);
                }
                toggleLoading('#host', false);
            }

            $systemPicker.render({items: data.releaseList});
            toggleLoading('#systemVersion', false);
            if(typeof(deploy) != 'undefined')
            {
                $hostPicker.$.setValue(deploy.host);
                $systemPicker.$.setValue(deploy.products[0].release);
            }

            $('[name=env]').val(data.template.envID);
        }
    });
};

window.loadArtifact = function ()
{
    const releaseID = $('[name=systemVersion]').val();
    const type      = $('[name=type]').val();
    if(typeof type === 'undefined' || type != 'cne' || typeof releaseID === 'undefined') return;

    toggleLoading('#artifact', true);
    const $picker = $('[name=artifact]').zui('picker');
    $picker.$.clear();
    $picker.render({items: []});
    $.getJSON($.createLink('deploy', 'ajaxGetArtifact', 'releaseID=' + releaseID), function(data)
    {
        if(data.artifactList.length > 0)
        {
            $picker.render({items: data.artifactList});
            if(typeof(deploy) != 'undefined') $picker.$.setValue(deploy.artifact);
        }
        toggleLoading('#artifact', false);
    });
};
