<?php
namespace zin;

formPanel
(
    set::title($lang->deliverable->edit),
    set::grid(true),
    set::layout('grid'),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->deliverable->name),
        set::name('name'),
        set::value($deliverable->name)
    ),
    formGroup(set::width('1/2')),
    formGroup
    (
        set::width('1/3'),
        set::label($lang->deliverable->module),
        picker
        (
            on::change('changeModule'),
            set::name('module'),
            set::required(true),
            set::items($lang->deliverable->moduleList),
            set::value($deliverable->module)
        )
    ),
    formGroup
    (
        set::width('1/6'),
        set::label($lang->deliverable->method),
        picker
        (
            set::name('method'),
            set::required(true),
            set::items($lang->deliverable->methodList),
            set::disabled(true),
            set::value($deliverable->method)
        )
    ),
    formGroup(set::width('1/2')),
    formGroup
    (
        set::className('modelBox'),
        set::width('1/2'),
        set::label($lang->deliverable->model),
        picker
        (
            set::name('model'),
            set::multiple(true),
            set::items($modelList),
            set::value($deliverable->model)
        )
    ),
    formGroup
    (
        set::width('full'),
        set::label($lang->deliverable->desc),
        editor
        (
            set::name('desc'),
            set::value($deliverable->desc)
        )
    ),
    formGroup
    (
        set::width('full'),
        set::label($lang->deliverable->files),
        fileselector
        (
            set::name('files'),
            set::maxFileCount(1),
            set::exceededCountTip($lang->deliverable->exceededCountTip),
            $deliverable->files ? set::defaultFiles(array_values($deliverable->files)) : null
        )
    )
);
