window.insertToDoc = function(blockID, insertLink)
{
    const docID     = getDocApp()?.docID;
    const blockType = 'gantt';

    const url = $.createLink('doc', 'buildZentaoList', `docID=${docID}&type=${blockType}&blockID=${blockID}`);
    const formData = new FormData();
    formData.append('ganttOptions', JSON.stringify(ganttOptions));
    formData.append('ganttFields', JSON.stringify(ganttFields));
    formData.append('showFields',  JSON.stringify(showFields));
    formData.append('url', insertLink);

    $.post(url, formData, function(resp)
    {
        resp = JSON.parse(resp);
        if(resp.result == 'success')
        {
            const oldBlockID = resp.oldBlockID;
            const newBlockID = resp.newBlockID;
            zui.Modal.hide();
            window.insertZentaoList && window.insertZentaoList(blockType, newBlockID, null, oldBlockID);
        }
    });
}
