<?php
$now   = helper::now();
$today = helper::today();

global $app, $lang;
$config->demand->form = new stdclass();
$config->demand->form->create = array();
$config->demand->form->create['pool']         = array('type' => 'int',    'default' => 0);
$config->demand->form->create['product']      = array('type' => 'array',  'default' => array(), 'filter' => 'join');
$config->demand->form->create['parent']       = array('type' => 'int',    'default' => 0);
$config->demand->form->create['title']        = array('type' => 'string', 'filter'  => 'trim');
$config->demand->form->create['color']        = array('type' => 'string', 'default' => '');
$config->demand->form->create['spec']         = array('type' => 'string', 'default' => '', 'control' => 'editor');
$config->demand->form->create['verify']       = array('type' => 'string', 'default' => '', 'control' => 'editor');
$config->demand->form->create['duration']     = array('type' => 'string', 'default' => '', 'options' => $lang->demand->durationList);
$config->demand->form->create['BSA']          = array('type' => 'string', 'default' => '', 'options' => $lang->demand->bsaList);
$config->demand->form->create['source']       = array('type' => 'string', 'default' => '', 'options' => $lang->demand->sourceList);
$config->demand->form->create['sourceNote']   = array('type' => 'string', 'filter'  => 'trim');
$config->demand->form->create['category']     = array('type' => 'string', 'default' => 'feature', 'options' => $lang->demand->categoryList);
$config->demand->form->create['pri']          = array('type' => 'int',    'default' => 3);
$config->demand->form->create['version']      = array('type' => 'int',    'default' => 1);
$config->demand->form->create['feedback']     = array('type' => 'int',    'default' => 0);
$config->demand->form->create['feedbackedBy'] = array('type' => 'string', 'filter'  => 'trim');
$config->demand->form->create['email']        = array('type' => 'string', 'filter'  => 'trim');
$config->demand->form->create['keywords']     = array('type' => 'string', 'default' => '');
$config->demand->form->create['mailto']       = array('type' => 'array',  'default' => array(), 'filter' => 'join', 'options' => 'users');
$config->demand->form->create['reviewer']     = array('type' => 'array',  'default' => array(), 'options' => 'users');
$config->demand->form->create['status']       = array('type' => 'string', 'default' => 'active');
$config->demand->form->create['assignedTo']   = array('type' => 'string', 'default' => '', 'options' => 'users');
$config->demand->form->create['createdBy']    = array('type' => 'string', 'default' => isset($app->user->account) ? $app->user->account : '');
$config->demand->form->create['createdDate']  = array('type' => 'date',   'default' => helper::now());

$config->demand->form->edit = array();
$config->demand->form->edit['pool']           = array('type' => 'int',     'control' => 'select',       'default' => 0,  'options' => array());
$config->demand->form->edit['product']        = array('type' => 'array',   'control' => 'multi-select', 'default' => array(), 'filter' => 'join', 'options' => array());
$config->demand->form->edit['parent']         = array('type' => 'int',     'control' => 'select',       'default' => 0,  'options' => array());
$config->demand->form->edit['title']          = array('type' => 'string',  'control' => 'text',         'default' => '', 'filter'  => 'trim');
$config->demand->form->edit['color']          = array('type' => 'string',  'control' => 'color',        'default' => '');
$config->demand->form->edit['spec']           = array('type' => 'string',  'control' => 'editor',       'default' => '');
$config->demand->form->edit['verify']         = array('type' => 'string',  'control' => 'editor',       'default' => '');
$config->demand->form->edit['duration']       = array('type' => 'string',  'control' => 'select',       'default' => '', 'options' => $lang->demand->durationList);
$config->demand->form->edit['BSA']            = array('type' => 'string',  'control' => 'select',       'default' => '', 'options' => $lang->demand->bsaList);
$config->demand->form->edit['source']         = array('type' => 'string',  'control' => 'select',       'default' => '', 'options' => $lang->demand->sourceList);
$config->demand->form->edit['sourceNote']     = array('type' => 'string',  'control' => 'text',         'default' => '', 'filter'  => 'trim');
$config->demand->form->edit['category']       = array('type' => 'string',  'control' => 'select',       'default' => 'feature', 'options' => $lang->demand->categoryList);
$config->demand->form->edit['pri']            = array('type' => 'int',     'control' => 'select',       'default' => $config->demand->defaultPriority, 'options' => array_filter($lang->demand->priList));
$config->demand->form->edit['feedbackedBy']   = array('type' => 'string',  'control' => 'text',         'default' => '', 'filter'  => 'trim');
$config->demand->form->edit['email']          = array('type' => 'string',  'control' => 'text',         'default' => '', 'filter'  => 'trim');
$config->demand->form->edit['keywords']       = array('type' => 'string',  'control' => 'text',         'default' => '');
$config->demand->form->edit['mailto']         = array('type' => 'array',   'control' => 'multi-select', 'default' => array(), 'filter' => 'join', 'options' => 'users');
$config->demand->form->edit['reviewer']       = array('type' => 'array',   'control' => 'multi-select', 'default' => array(), 'options' => 'users');
$config->demand->form->edit['status']         = array('type' => 'string',  'control' => 'hidden',       'default' => 'active');
$config->demand->form->edit['assignedTo']     = array('type' => 'string',  'control' => 'select',       'default' => '', 'options' => 'users');
$config->demand->form->edit['closedBy']       = array('type' => 'string',  'control' => 'select',       'default' => '', 'options' => 'users');
$config->demand->form->edit['closedReason']   = array('type' => 'string',  'control' => 'select',       'default' => '', 'options' => $lang->demand->reasonList);
$config->demand->form->edit['uid']            = array('type' => 'string',  'default' => '');

$config->demand->form->assignTo = array();
$config->demand->form->assignTo['assignedTo']   = array('type' => 'string',   'default' => '');
$config->demand->form->assignTo['assignedDate'] = array('type' => 'datetime', 'default' => $now);
$config->demand->form->assignTo['comment']      = array('type' => 'string',   'default' => '', 'control' => 'editor');

$config->demand->form->close = array();
$config->demand->form->close['closedReason']    = array('type' => 'string',   'default' => 'done');
$config->demand->form->close['duplicateDemand'] = array('type' => 'int',      'default' => 0);
$config->demand->form->close['status']          = array('type' => 'string',   'default' => 'closed');
$config->demand->form->close['assignedTo']      = array('type' => 'string',   'default' => 'closed');
$config->demand->form->close['assignedDate']    = array('type' => 'datetime', 'default' => $now);
$config->demand->form->close['lastEditedDate']  = array('type' => 'datetime', 'default' => $now);
$config->demand->form->close['closedDate']      = array('type' => 'datetime', 'default' => $now);
$config->demand->form->close['comment']         = array('type' => 'string',   'default' => '', 'control' => 'editor');

$config->demand->form->activate = array();
$config->demand->form->activate['assignedTo']     = array('type' => 'string',   'default' => '');
$config->demand->form->activate['assignedDate']   = array('type' => 'datetime', 'default' => $now);
$config->demand->form->activate['closedBy']       = array('type' => 'string',   'default' => '');
$config->demand->form->activate['closedDate']     = array('type' => 'datetime', 'default' => null);
$config->demand->form->activate['closedReason']   = array('type' => 'string',   'default' => '');
$config->demand->form->activate['lastEditedDate'] = array('type' => 'datetime', 'default' => $now);
$config->demand->form->activate['activatedDate']  = array('type' => 'datetime', 'default' => $now);
$config->demand->form->activate['comment']        = array('type' => 'string',   'default' => '', 'control' => 'editor');

$config->demand->form->distribute = array();
$config->demand->form->distribute['product']     = array('type' => 'array',  'control' => 'select', 'default' => array(), 'options' => array());
$config->demand->form->distribute['productName'] = array('type' => 'string', 'control' => '',       'default' => '');
$config->demand->form->distribute['branch']      = array('type' => 'array',  'control' => 'select', 'default' => array(), 'options' => array());
$config->demand->form->distribute['roadmap']     = array('type' => 'array',  'control' => 'select', 'default' => array(), 'options' => array());
$config->demand->form->distribute['roadmapName'] = array('type' => 'string', 'control' => '',       'default' => '');
$config->demand->form->distribute['comment']     = array('type' => 'string', 'control' => 'editor', 'default' => '');
$config->demand->form->distribute['uid']         = array('type' => 'string', 'default' => '');
