<?php

namespace Spiral\Logger;

use Psr\Log\LoggerInterface;
use Psr\Log\LoggerTrait;

/**
 * Simply forwards debug messages into various locations.
 */
final class NullLogger implements LoggerInterface
{
    use LoggerTrait;

    /**
     * @readonly
     * @var \Closure
     */
    private $receptor;
    /**
     * @var string
     */
    private $channel;

    /**
     * @param callable $receptor
     * @param string $channel
     */
    public function __construct(
        $receptor,
        $channel
    ) {
        $this->channel = $channel;
        $callable = $receptor;
        $this->receptor = function () use ($callable) {
            return $callable(...func_get_args());
        };
    }

    /**
     * @param mixed $level
     * @param mixed[] $context
     * @return void
     */
    public function log($level, $message, $context = [])
    {
        \call_user_func($this->receptor, $this->channel, $level, $message, $context);
    }
}
