<?php
/**
 * The relation view file of execution module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.cnezsoft.com)
 * @license     business(商业软件)
 * @author      Qiyu Xie <xieqiyu@chandao.com>
 * @package     execution
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('typeHintList', $lang->execution->relation->typeHintList);
jsVar('confirmBatchDelete', $lang->execution->gantt->confirmBatchDelete);

featureBar(set::current('all'), set::linkParams("executionID=$executionID"));

toolbar
(
    common::hasPriv('execution', 'createRelation') ? btn
    (
        setClass('btn secondary'),
        set::icon('plus'),
        set::url($this->createLink('execution', 'createRelation', "executionID=$executionID")),
        setData(array('app' => $this->app->tab)),
        $lang->execution->createRelation
    ) : null,
    common::hasPriv('task', 'create') && !$isLimited ? btn
    (
        setClass('btn primary'),
        set::icon('plus'),
        set::url($this->createLink('task', 'create', "execution=$executionID")),
        setData(array('toggle' => 'modal', 'size' => 'lg')),
        $lang->task->create
    ) : null
);

$cols      = $this->loadModel('datatable')->getSetting('execution');
$relations = initTableData($relations, $cols, $this->execution);

$cols['task']['map']    = $tasks;
$cols['pretask']['map'] = $tasks;

$canBatchEdit   = common::hasPriv('execution', 'batchEditRelation');
$canBatchDelete = common::hasPriv('execution', 'batchDeleteRelation');
$canBatchAction = $canBatchEdit || $canBatchDelete;

$footToolbar = array();
if($canBatchAction)
{
    $footToolbar['items'] = array();
    if($canBatchEdit)   $footToolbar['items'][] = array('text' => $lang->execution->maintain, 'className' => 'batch-btn',                'btnType' => 'secondary', 'data-url' => createLink('execution', 'batchEditRelation', "executionID=$executionID"));
    if($canBatchDelete) $footToolbar['items'][] = array('text' => $lang->delete,              'className' => 'batch-btn batchDeleteBtn', 'btnType' => 'secondary', 'data-url' => createLink('execution', 'batchDeleteRelation', "executionID=$executionID"));
}

dtable
(
    set::cols($cols),
    set::data(array_values($relations)),
    set::onRenderCell(jsRaw('window.renderCell')),
    set::footPager(usePager(array
    (
        'recPerPage'  => $pager->recPerPage,
        'recTotal'    => $pager->recTotal,
        'linkCreator' => helper::createLink('execution', 'relation', "executionID={$executionID}&recTotal={$pager->recTotal}&recPerPage={recPerPage}&page={page}")
    ))),
    set::checkable($canBatchAction),
    set::footToolbar($footToolbar)
);
