<?php
namespace zin;

class formItemDropdown extends wg
{
    /**
     * @var mixed[]
     */
    protected static $defineProps = array(
        'items?:array',
        'value?:array',
        'method?: string',
        'url?: string',
        'actions?: array',
        'target?: string'
    );

    /**
     * @return string|null
     */
    public static function getPageCSS()
    {
        return file_get_contents(__DIR__ . DS . 'css' . DS . 'v1.css');
    }

    private function buildFormPanel()
    {
        global $lang;

        $props = $this->prop(['method', 'url', 'actions', 'target']);

        return form
        (
            p
            (
                $lang->customField,
                setClass('text-base font-bold mb-1')
            ),
            set($props),
            setID('custom'),
            setClass('dropdown-menu p-5 bg-white'),
            formGroup
            (
                setClass('not-hide-menu w-20 mb-1'),
                checkList
                (
                    set
                    (
                        array(
                            'class'   => 'h-full flex-wrap gap-y-5',
                            'primary' => true,
                            'inline'  => true,
                            'value'   => $this->prop('value'),
                            'items'   => $this->prop('items')
                        )
                    )
                )
            ),
            set::actions
            (
                array(
                    array('text' => $lang->save, 'class' => 'primary'),
                    array('text' => $lang->cancel),
                    array('text' => $lang->restore, 'class' => 'ghost text-primary', 'btnType' => 'reset')
                )
            )
        );
    }

    protected function build()
    {
        return div
        (
            setClass('form-item-dropdown'),
            btn
            (
                set
                (
                    array(
                       'class'       => 'ghost',
                       'icon'        => 'cog',
                       'data-target' => 'custom',
                       'data-toggle' => 'dropdown'
                    )
                )
            ),
            $this->buildFormPanel()
        );
    }
}
