<?php

namespace Spiral\Core\Exception\Scope;

use Spiral\Core\Exception\Container\ContainerException;

/**
 * @internal
 */
abstract class ScopeException extends ContainerException
{
    /**
     * @var string|null
     */
    protected $scope;
    /**
     * @param string|null $scope
     * @param \Throwable|null $previous
     * @param string $message
     * @param int $code
     */
    public function __construct($scope, $message = '', $code = 0, $previous = null)
    {
        $this->scope = $scope;
        parent::__construct($message, $code, $previous);
    }
    /**
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
}
