<?php
namespace zin;

$workflowGroups = data('workflowGroups');
$copyProject    = data('copyProject');
$workflowGroup  = isset($copyProject->workflowGroup) && isset($workflowGroups[$copyProject->workflowGroup]) ? $copyProject->workflowGroup : '';
query('formGridPanel')->each(function($node) use($workflowGroups, $workflowGroup)
{
    $lang   = data('lang');
    $model  = data('model');
    $fields = $node->prop('fields');

    if($model != 'kanban')
    {
        $fields->field('workflowGroup')
               ->label($lang->project->workflowGroup)
               ->control('picker')
               ->required(true)
               ->value($workflowGroup)
               ->items($workflowGroups);

        $fields->field('workflowGroup')->width('1/4');
        $fields->field('hasProduct')->width('1/4');

        $fields->moveAfter('workflowGroup', 'hasProduct');
    }

    $fields->fullModeOrders('hasProduct,workflowGroup');
    $fields->orders('hasProduct,workflowGroup');

    $node->setProp('fields', $fields);
});
