$(document).ready(function()
{
    $panelHeadingHeight = $('.panel-heading').outerHeight(true);
    $panelMarginBottom  = $('.panel').css('margin-bottom').replace('px', '');
    $editorNavHeight    = $('#editorNav').outerHeight(true);
    $editorMenuHeight   = $('#editorMenu').outerHeight();
    $spaceHeight        = $('.space.space-sm').outerHeight(true);

    $maxHeight = $(window).height() - $panelHeadingHeight - $panelMarginBottom - $editorNavHeight - $editorMenuHeight - $spaceHeight;
    $('.panel-body').css('max-height', $maxHeight + 'px');

    $('.confirmer').click(function()
    {
        const url     = $(this).attr('href');
        const message = $(this).data('confirm');
        bootbox.confirm(message, function(result)
        {
            if(!result) return;

            $.getJSON(url, function(data)
            {
                if(data.result == 'fail') bootbox.alert(data.message);

                return location.reload();
            })
        });
        return false;
    });
});
