<?php
/**
 * The admin view file of ticket module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     ticket
 * @link        https://www.zentao.net
 */
namespace zin;

jsVar('feedbackLang', $lang->feedback->common);

if($browseType == 'byProduct' || $browseType == 'byModule') $browseType = $this->session->ticketBrowseType;
$closeLink = createLink('ticket', 'browse', "browseType=byProduct&param=" . ($productID == $this->session->ticketObjectID ? '0' : $productID) . "&orderBy={$orderBy}&recTotal=0");

$cols      = $this->loadModel('datatable')->getSetting('ticket');
$tickets = initTableData($tickets, $cols, $this->ticket);
if(!empty($cols['product']))  $cols['product']['map']  = $products;
if(!empty($cols['module']))   $cols['module']['map']   = $modules;
if(!empty($cols['dept']))     $cols['dept']['map']     = $depts;
if(!empty($cols['feedback'])) $cols['feedback']['map'] = $feedbacks;

dropmenu(set::text($productID == 'all' ? $lang->product->allProduct : ''), set::tab('feedback'));

sidebar
(
    moduleMenu(set(array
    (
        'modules'     => $moduleTree,
        'activeKey'   => $this->session->ticketObjectID,
        'closeLink'   => $closeLink,
        'settingLink' => hasPriv('tree', 'browse') && $productID != 'all' && $config->vision == 'rnd' ? createLink('tree', 'browse', "productID={$productID}&view=ticket") : '',
        'settingApp'  => $app->tab,
        'showDisplay' => false
    )))
);

featureBar
(
    set::current($browseType),
    set::linkParams("browseType={key}"),
    li(searchToggle(set::open($browseType == 'bysearch')))
);

$canExport          = hasPriv('ticket', 'export');
$canExportTemplate  = hasPriv('ticket', 'exportTemplate');
$exportItem         = array('text' => $lang->ticket->export,         'data-toggle' => 'modal', 'data-size' => 'sm','url' => createLink('ticket', 'export', "browseType=$browseType&orderBy=$orderBy"));
$exportTemplateItem = array('text' => $lang->ticket->exportTemplate, 'data-toggle' => 'modal', 'data-size' => 'sm','url' => createLink('ticket', 'exportTemplate'));

$canBatchEdit     = common::hasPriv('ticket', 'batchEdit');
$canBatchAssignTo = common::hasPriv('ticket', 'batchAssignTo');
$canBatchFinish   = common::hasPriv('ticket', 'batchFinish');
$canBatchActivate = common::hasPriv('ticket', 'batchActivate');
$canBatchAction   = ($canBatchEdit || $canBatchAssignTo || $canBatchFinish || $canBatchActivate || $canExport);

$assignedToItems = array();
foreach ($users as $key => $value)
{
    if(!empty($key)) $assignedToItems[] = array('text' => $value, 'innerClass' => 'batch-btn ajax-btn not-open-url', 'data-url' => helper::createLink('ticket', 'batchAssignTo', "assignedTo={$key}"));
}

$footToolbar = array();
if($canBatchAction)
{
    $footToolbar['items'] = array();
    if($canBatchEdit)
    {
        $footToolbar['items'][] = array('text' => $lang->edit, 'className' => 'primary batch-btn not-open-url', 'data-url' => createLink('ticket', 'batchEdit'));
    }
    if($canBatchAssignTo)
    {
        $footToolbar['items'][] = array('caret' => 'up', 'text' => $lang->ticket->assignedTo, 'type' => 'dropdown', 'data-placement' => 'top-start', 'items' => $assignedToItems, 'data-menu' => array('searchBox' => true));
    }
    if($canBatchFinish)
    {
        $footToolbar['items'][] = array('text' => $lang->ticket->finish, 'className' => 'primary batch-btn not-open-url', 'data-url' => createLink('ticket', 'batchFinish'));
    }
    if($canBatchActivate)
    {
        $footToolbar['items'][] = array('text' => $lang->ticket->activate, 'className' => 'primary batch-btn not-open-url', 'data-url' => createLink('ticket', 'batchActivate'));
    }
    $footToolbar['btnProps'] = array('size' => 'sm', 'btnType' => 'secondary');
}

$createLink      = createLink('ticket', 'create', "productID={$productID}&extras=moduleID={$moduleID}");
$batchCreateLink = createLink('ticket', 'batchCreate', "productID={$productID}&moduleID={$moduleID}");
$createItems     = array();
if(hasPriv('ticket', 'create')) $createItems[] = array('text' => $lang->ticket->create, 'url' => $createLink);
if(hasPriv('ticket', 'batchCreate') && $product && $product->status == 'normal') $createItems[] = array('text' => $lang->ticket->batchCreate, 'url' => $batchCreateLink);

toolbar
(
    $canExport && $canExportTemplate ? dropdown
    (
        btn
        (
            setClass('btn ghost dropdown-toggle'),
            set::icon('export'),
            $lang->export
        ),
        set::items(array($exportItem, $exportTemplateItem)),
        set::placement('bottom-end'),
    ) : null,
    $canExport && !$canExportTemplate ? item(set($exportItem         + array('class' => 'btn ghost', 'icon' => 'export'))) : null,
    $canExportTemplate && !$canExport ? item(set($exportTemplateItem + array('class' => 'btn ghost', 'icon' => 'export'))) : null,
    hasPriv('ticket', 'import') ? item
    (
        setClass('ghost'),
        set::icon('import'),
        set::url(createLink('ticket', 'import')),
        setData(array('toggle' => 'modal')),
        set::text($lang->ticket->import)
    ) : null,
    count($createItems) > 1 ? btnGroup
    (
        btn(setClass('btn primary create-bug-btn'), set::icon('plus'), set::url($createLink), $lang->ticket->create),
        dropdown
        (
            btn(setClass('btn primary dropdown-toggle'), setStyle(array('padding' => '6px', 'border-radius' => '0 2px 2px 0'))),
            set::items($createItems),
            set::placement('bottom-end')
        )
    ) : null,
    count($createItems) == 1 ? item(set(current($createItems)), setClass('primary'), set::icon('plus')) : null

);

dtable
(
    set::cols(array_values($cols)),
    set::data(array_values($tickets)),
    set::checkable($canBatchAction),
    set::userMap($users),
    set::orderBy($orderBy),
    set::customCols(true),
    set::sortLink(createLink('ticket', 'browse', "browseType={$browseType}&param={$param}&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}")),
    set::onRenderCell(jsRaw('window.onRenderCell')),
    set::footToolbar($footToolbar),
    set::footPager(usePager())
);

render();
