window.getCol = function(col)
{
    if(col.cards) col.subtitle = {html: "<span class='text-gray ml-1'>" + col.cards + "</span>"};
}

window.itemRender = function(info)
{
    info.item.icon       = 'delay';
    info.item.titleUrl   = canViewPlan ? $.createLink('deploy', 'steps', `id=${info.item.id}`) : '';
    info.item.titleAttrs = {'class': 'card-title clip', 'title' : info.item.title};

    let content;
    if(info.item.status == 'done')
    {
        let resultIcon = info.item.result == 'success' ? 'icon-check' : 'icon-close';
        let resultText = info.item.result == 'success' ? 'text-success' : 'text-danger';
        content = `
        <div class='flex items-center justify-between'>
          <span class='text-gray mr-1'>${info.item.owner}</span>
          <span class='date ml-1 right ` + resultText + `'><i class='icon ` + resultIcon + `'></i> ` + deployLang.resultList[info.item.result] + `</span>
        </div> `;
    }
    else
    {
        const beginTime = info.item.begin.substr(5, 11);
        content = `
        <div class='flex items-center justify-between'>
          <span class='text-gray mr-1'>${info.item.owner}</span>
          <span class='date ml-1 right'>${beginTime}</span>
        </div> `;
    }

    info.item.content = {html: content};
}

window.getItem = function(info)
{
    info.item.titleAttrs = {'class': 'text-black clip', 'title' : info.item.title};
}

window.getItemActions = function(item)
{
    if(!canModify) return [];
    return [{
        type: 'dropdown',
        icon: 'ellipsis-v',
        caret: false,
        items: buildCardActions(item),
    }];
}

window.buildCardActions = function(item)
{
    let actions = [];

    if(canFinish && item.status != 'done') actions.push({text: deployLang.finish, url: $.createLink('deploy', 'Finish', `id=${item.id}`), 'data-toggle': 'modal'});
    if(canActivate && item.status == 'done') actions.push({text: deployLang.activate, url: $.createLink('deploy', 'Activate', `id=${item.id}`), 'data-toggle': 'modal'});
    if(canEdit) actions.push({text: deployLang.edit, url: $.createLink('deploy', 'edit', `id=${item.id}`), 'data-toggle': 'modal'});
    if(canDelete) actions.push({text: deployLang.delete, url: $.createLink('deploy', 'delete', `id=${item.id}`), 'innerClass': 'ajax-submit', 'data-confirm' : deployLang.confirmDelete});
    return actions;
}

window.canDrop = function(dragInfo, dropInfo)
{
    if(!dragInfo) return false;

    const column = this.getCol(dragInfo.col);

    if(dropInfo.col != 'done' && column.name != 'done' && canFinish) return false;
    if(dropInfo.col == 'done' && column.name == 'done' && canActivate) return false;
    if(!column) return false;
}

window.onDrop = function(changes, dropInfo)
{
    const item  = dropInfo['drag']['item'];

    if(item.status == 'wait') methodName = 'finish';
    if(item.status == 'done') methodName = 'activate';
    zui.Modal.open({url: $.createLink('deploy', methodName, 'deployID=' + item.id), size: 'lg'});
    return false;
}
