<?php
/**
 * The browse view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

list($currentYear, $currentMonth) = explode('-', $date);
$dataItems = array();
foreach($dateList as $year => $months)
{
    $monthsItems = array();
    foreach($months as $monthKey => $monthName)
    {
        $isAction = $monthKey == $currentMonth ? 'active' : '';
        $monthKey = sprintf('%02d', $monthKey);
        $monthsItems[] = array('text' => $lang->datepicker->monthNames[$monthName] , 'innerClass' => "$isAction", 'url' => helper::createLink('deploy', 'browse', "product=$product&date={$year}{$monthKey}"));
    }
    $dataItems[] = array('text' => $year, 'caret' => 'right', 'data-placement' => 'bottom-end', 'items' => $monthsItems);
}

row
(
    setClass('items-center justify-between mb-3'),
    cell
    (
        setClass('flex'),
        dropDown
        (
            btn(date($lang->deploy->monthFormat, strtotime($date))),
            set::items($dataItems)
        )
    ),
    cell
    (
        setClass('flex toolbar'),
        common::hasPriv('ops', 'stage') ? btn
        (
            set::url(createLink('ops', 'stage')),
            set::className('ghost'),
            set::icon('waterfall'),
            set('data-app', $app->tab),
            $this->lang->deploy->stage
        ) : null,
        common::hasPriv('deploy', 'create') ? btn
        (
            set::type('primary'),
            set::url(createLink('deploy', 'create')),
            set::icon('plus'),
            $this->lang->deploy->create
        ) : null
    )
);

jsVar('deployLang', $this->lang->deploy);
jsVar('canViewPlan', common::hasPriv('deploy', 'steps'));
jsVar('canFinish', common::hasPriv('deploy', 'finish'));
jsVar('canActivate', common::hasPriv('deploy', 'activate'));
jsVar('canEdit', common::hasPriv('deploy', 'edit'));
jsVar('canDelete', common::hasPriv('deploy', 'delete'));
jsVar('canModify', common::hasPriv('deploy', 'delete') || common::hasPriv('deploy', 'edit') || common::hasPriv('deploy', 'finish') || common::hasPriv('deploy', 'activate'));

foreach($plans as $current => $region)
{
    foreach($region['items'] as $index => $group)
    {
        $group['draggable']  = true;
        $group['colWidth']   = 'auto';
        $group['getCol']     = jsRaw('window.getCol');
        $group['getItem']    = jsRaw('window.getItem');
        $group['itemProps']  = array('actions' => jsRaw('window.getItemActions'));
        $group['itemRender'] = jsRaw('window.itemRender');
        $group['canDrop']    = jsRaw('window.canDrop');
        $group['onDrop']     = jsRaw('window.onDrop');
        $plans[$current]['items'][$index] = $group;
    }
}

div
(
    set::id('kanbanList'),
    setClass('bg-white'),
    zui::kanbanList
    (
        set::key('kanban'),
        set::items($plans),
        set::height('calc(100vh - 120px)')
    )
);
