$(document).off('click', '.batch-btn').on('click', '.batch-btn', function()
{
    const dtable = zui.DTable.query($(this).target);
    const checkedList = dtable.$.getChecks();
    if(!checkedList.length) return;

    const url  = $(this).data('url');
    const form = new FormData();
    checkedList.forEach((id) => form.append('ticketIDList[]', id));

    if($(this).hasClass('ajax-btn'))
    {
        $.ajaxSubmit({url, data:form});
    }
    else
    {
        postAndLoadPage(url, form);
    }
});

/**
 * 来源列显示额外的内容。
 * Display extra content in the title column.
 *
 * @param  object result
 * @param  object info
 * @access public
 * @return object
 */
window.onRenderCell = function(result, {row, col})
{
    if(result && col.name == 'feedbackTip' && row.data.feedbackTip != '')
    {
        if(typeof result[0].props != 'undefined') result[0].props.className = 'overflow-hidden';
        result.push({html: '<span class="label primary-pale whitespace-nowrap w-auto">' + feedbackLang + '</span>'}); // 添加反馈标签
    }
    return result;
}
