<?php
/**
 * The create view file of service module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     service
 * @link        https://www.zentao.net
 */
namespace zin;

if(empty($parent)) unset($lang->service->typeList['component']);
formPanel
(
    set::title($lang->service->create),
    set::actionsClass('w-2/3'),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->service->name),
        set::required(true),
        inputGroup
        (
            input
            (
                set::name('name'),
            ),
            span
            (
                setClass('input-group-addon'),
                $lang->service->version
            ),
            input
            (
                set::name('version'),
                setClass('w-1/3')
            )
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->service->softName),
        set::required(true),
        inputGroup
        (
            input
            (
                set::name('softName'),
            ),
            span
            (
                setClass('input-group-addon'),
                $lang->service->softVersion
            ),
            input
            (
                set::name('softVersion'),
                setClass('w-1/3')
            )
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('entry'),
        set::label($lang->service->entry)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('deploy'),
        set::label($lang->service->deploy)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('port'),
        set::label($lang->service->port)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('external'),
        set::label($lang->service->external),
        set::required(true),
        set::items($lang->service->externalList)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('dept'),
        set::label($lang->service->dept),
        set::items($depts)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('devel'),
        set::label($lang->service->devel),
        set::items($users)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('qa'),
        set::label($lang->service->qa),
        set::items($users)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('ops'),
        set::label($lang->service->ops),
        set::items($users)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('type'),
        set::label($lang->service->type),
        set::value($type),
        set::control('radioListInline'),
        set::items($lang->service->typeList)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('group[]'),
        set::label($lang->host->group),
        on::change('changeHostGroup'),
        set::control(array('control' => 'picker','multiple' => true)),
        set::items($hostGroup)
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('hosts[]'),
        set::label($lang->service->host),
        set::control(array('control' => 'picker','multiple' => true)),
        set::items($hosts)
    ),
    formGroup
    (
        set::width('2/3'),
        set::name('desc'),
        set::label($lang->service->desc),
        set::control('editor')
    )
);
