<?php
declare(strict_types=1);
/**
 * The test class file of service module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     service
 * @link        https://www.zentao.net
 */
class serviceTest
{
    private $objectModel;

    public function __construct()
    {
        su('admin');

        global $tester;
        $this->objectModel = $tester->loadModel('service');
    }

    /**
     * Test create a service.
     *
     * @param  array   $params
     * @access public
     * @return object|array
     */
    public function createTest(array $params = array()): object|array
    {
        $data = new stdclass();
        foreach($params as $field => $value) $data->$field = $value;

        if(!isset($data->name)) $data->name = '';
        $this->objectModel->create($data);
        if(dao::isError()) return dao::getError();

        return $this->objectModel->dao->select('*')->from(TABLE_SERVICE)->orderBy('id desc')->limit(1)->fetch();
    }

    /**
     *  Test update a service.
     *
     *  @param  int     $oldServiceID
     *  @param  array   $newServiceData
     *  @access public
     *  @return object|array|false
     */
    public function updateTest(int $oldServiceID, array $newServiceData = array()): object|array|false
    {
        $oldService = $this->objectModel->fetchById($oldServiceID);
        if(!$oldService) return false;

        $newService = clone $oldService;
        foreach($newServiceData as $field => $value) $newService->$field = $value;

        $change = $this->objectModel->update($oldServiceID, $newService);
        return dao::isError() ? dao::getError() : $change;
    }
}
