<?php
/**
 * The edit view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

$linkProducts = array();
if(!empty($deploy->products))
{
    foreach($deploy->products as $key => $product)
    {
        $linkProducts[] =
            formRow
            (
                set::className('flex-wrap'),
                formGroup
                (
                    set::label($key > 0 ? '' : $lang->deploy->lblProduct),
                    set::className('product-box w-full'),
                    inputGroup
                    (
                        $lang->deploy->product,
                        picker
                        (
                            set::name('products[]'),
                            set::items($products),
                            set::value($product->product),
                            set::className('linkProduct'),
                        ),
                        span
                        (
                            $lang->deploy->release,
                            set::className('input-group-addon')
                        ),
                        picker
                        (
                            set::name('release[]'),
                            set::className('releases'),
                            set::items(zget($releaseGroup, $product->product, array())),
                            set::value($product->release),
                        ),
                        span
                        (
                            $lang->deploy->package,
                            set::className('input-group-addon')
                        ),
                        input
                        (
                            set::name('package[]'),
                            set::value($product->package),
                        ),
                        div
                        (
                            $key > 0 ? set::className('c-action flex') : set::className('c-action first-action flex'),
                            span
                            (
                                setClass('input-group-addon'),
                                h::a
                                (
                                    setClass('add-item'),
                                    set::href('javascript:void(0)'),
                                    icon('plus')
                                )
                            ),
                            span
                            (
                                setClass('input-group-addon'),
                                a
                                (
                                    setClass('delete-item'),
                                    set::href('javascript:void(0)'),
                                    icon('close')
                                )
                            )
                        )
                    )
                )
            );
    }
}

formPanel
(
    on::click('.add-item', 'window.addItem'),
    on::click('.delete-item', 'window.removeItem'),
    on::change('[name^="products"]', 'window.loadRelease'),
    setID('editPanel'),
    set::title($lang->deploy->edit),
    set::submitBtnText($lang->save),
    formGroup
    (
        set::className('items-center'),
        set::label($lang->deploy->name),
        set::name('name'),
        set::value($deploy->name),
        set::required(true)
    ),
    formGroup
    (
        set::className('items-center'),
        set::name('desc'),
        set::label($lang->deploy->desc),
        set::control('editor'),
        set::value($deploy->desc),
        set::rows(10),
    ),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->deploy->owner),
        set::required(true),
        picker
        (
            set::name('owner'),
            set::items($users),
            set::value($deploy->owner)
        )
    ),
    formRow
    (
        formGroup
        (
            set::label($lang->deploy->lblBeginEnd),
            set::required(true),
            inputGroup
            (
                datetimePicker(set::name('begin'), set::value($deploy->begin), set::placeholder($lang->deploy->begin)),
                span('~', set::className('input-group-addon')),
                datetimePicker(set::name('end'), set::value($deploy->end), set::placeholder($lang->deploy->end))
            )
        )
    ),
    formGroup
    (
        set::label($lang->deploy->status),
        picker
        (
            set::name('status'),
            set::items($lang->deploy->statusList),
            set::value($deploy->status),
        )
    ),
    formGroup
    (
        set::label($lang->deploy->members),
        picker
        (
            set::name('members[]'),
            set::items($users),
            set::value($deploy->members),
            set::multiple(true)
        )
    ),
    $linkProducts ? $linkProducts :
    formRow
    (
        set::className('flex-wrap'),
        formGroup
        (
            set::label($lang->deploy->lblProduct),
            set::className('product-box w-full'),
            inputGroup
            (
                $lang->deploy->product,
                picker
                (
                    set::name('products[]'),
                    set::items($products),
                    set::className('linkProduct'),
                ),
                span
                (
                    $lang->deploy->release,
                    set::className('input-group-addon')
                ),
                picker
                (
                    set::name('release[]'),
                    set::className('releases'),
                    set::items(array()),
                ),
                span
                (
                    $lang->deploy->package,
                    set::className('input-group-addon')
                ),
                input
                (
                    set::name('package[]'),
                ),
                div
                (
                    set::className('c-action first-action flex'),
                    span
                    (
                        setClass('input-group-addon'),
                        h::a
                        (
                            setClass('add-item'),
                            set::href('javascript:void(0)'),
                            icon('plus')
                        )
                    ),
                    span
                    (
                        setClass('input-group-addon'),
                        a
                        (
                            setClass('delete-item'),
                            set::href('javascript:void(0)'),
                            icon('close')
                        )
                    )
                )
            )
        )
    )
);
