DELETE FROM `zt_chart` where id = '1048';
DROP TABLE IF EXISTS `zt_dimension`;
CREATE TABLE IF NOT EXISTS `zt_dimension` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `zt_pivot`  (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `group` varchar(255) NOT NULL,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `sql` mediumtext NOT NULL,
  `fields` mediumtext NULL,
  `langs` mediumtext NULL,
  `vars` mediumtext NOT NULL,
  `objects` mediumtext NULL,
  `settings` mediumtext NOT NULL,
  `filters` mediumtext NOT NULL,
  `step` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stage` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `dimension` (`dimension`),
  KEY `group` (`group`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE zt_pivot ADD dataset varchar(30) NOT NULL DEFAULT '';

ALTER TABLE zt_case ADD scene int(11) DEFAULT 0;
ALTER TABLE zt_case ADD sort int(11) DEFAULT 0;

CREATE TABLE IF NOT EXISTS `zt_scene` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `sort` int(11) unsigned NOT NULL DEFAULT 0,
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `parent` int(11) DEFAULT NULL,
  `grade` tinyint(3) DEFAULT NULL,
  `path` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE OR REPLACE VIEW `ztv_scenecase` AS SELECT
  `zt_case`.`id` AS `id`,
  `zt_case`.`title` AS `title`,
  `zt_case`.`project` AS `project`,
  `zt_case`.`product` AS `product`,
  `zt_case`.`execution` AS `execution`,
  `zt_case`.`branch` AS `branch`,
  `zt_case`.`lib` AS `lib`,
  `zt_case`.`module` AS `module`,
  `zt_case`.`story` AS `story`,
  `zt_case`.`storyVersion` AS `storyVersion`,
  `zt_case`.`precondition` AS `precondition`,
  `zt_case`.`keywords` AS `keywords`,
  `zt_case`.`pri` AS `pri`,
  `zt_case`.`type` AS `type`,
  `zt_case`.`auto` AS `auto`,
  `zt_case`.`frame` AS `frame`,
  `zt_case`.`stage` AS `stage`,
  `zt_case`.`howRun` AS `howRun`,
  `zt_case`.`scriptedBy` AS `scriptedBy`,
  `zt_case`.`scriptedDate` AS `scriptedDate`,
  `zt_case`.`scriptStatus` AS `scriptStatus`,
  `zt_case`.`scriptLocation` AS `scriptLocation`,
  `zt_case`.`status` AS `status`,
  `zt_case`.`subStatus` AS `subStatus`,
  `zt_case`.`color` AS `color`,
  `zt_case`.`frequency` AS `frequency`,
  IF(`zt_case`.`sort` = 0, `zt_case`.`id`, `zt_case`.`sort`) AS `sort`,
  `zt_case`.`openedBy` AS `openedBy`,
  `zt_case`.`openedDate` AS `openedDate`,
  `zt_case`.`reviewedBy` AS `reviewedBy`,
  `zt_case`.`reviewedDate` AS `reviewedDate`,
  `zt_case`.`lastEditedBy` AS `lastEditedBy`,
  `zt_case`.`lastEditedDate` AS `lastEditedDate`,
  `zt_case`.`version` AS `version`,
  `zt_case`.`linkCase` AS `linkCase`,
  `zt_case`.`fromBug` AS `fromBug`,
  `zt_case`.`fromCaseID` AS `fromCaseID`,
  `zt_case`.`fromCaseVersion` AS `fromCaseVersion`,
  `zt_case`.`deleted` AS `deleted`,
  `zt_case`.`lastRunner` AS `lastRunner`,
  `zt_case`.`lastRunDate` AS `lastRunDate`,
  `zt_case`.`lastRunResult` AS `lastRunResult`,
  `zt_case`.`scene` AS `parent`,
  `zt_case`.`scene` AS `scene`,
  ifnull(`zt_scene`.`grade` + 1 , 1) AS `grade`,
  ifnull(
    concat(
      `zt_scene`.`path`,
      `zt_case`.`id`,
      ','
    ),
    CONVERT(
      concat(',' , `zt_case`.`id` , ',') USING utf8
    )
  ) AS `path`,
  1 AS `isCase`
FROM (`zt_case` LEFT JOIN `zt_scene` ON( `zt_case`.`scene` = `zt_scene`.`id`+100000000))
UNION
  SELECT
    `zt_scene`.`id`+ 100000000 AS `id`,
    `zt_scene`.`title` AS `title`,
    0 AS `project`,
    `zt_scene`.`product` AS `product`,
    0 AS `execution`,
    `zt_scene`.`branch` AS `branch`,
    0 AS `lib`,
    `zt_scene`.`module` AS `module`,
    0 AS `story`,
    0 AS `storyVersion`,
    '' AS `precondition`,
    '' AS `keywords`,
    0 AS `pri`,
    '' AS `type`,
    '' AS `auto`,
    '' AS `frame`,
    '' AS `stage`,
    '' AS `howRun`,
    '' AS `scriptedBy`,
    '' AS `scriptedDate`,
    '' AS `scriptStatus`,
    '' AS `scriptLocation`,
    '' AS `status`,
    '' AS `subStatus`,
    '' AS `color`,
    '' AS `frequency`,
    `zt_scene`.`sort` AS `sort`,
    `zt_scene`.`openedBy` AS `openedBy`,
    `zt_scene`.`openedDate` AS `openedDate`,
    '' AS `reviewedBy`,
    '' AS `reviewedDate`,
    `zt_scene`.`lastEditedBy` AS `lastEditedBy`,
    `zt_scene`.`lastEditedDate` AS `lastEditedDate`,
    0 AS `version`,
    '' AS `linkCase`,
    0 AS `fromBug`,
    0 AS `fromCaseID`,
    '' AS `fromCaseVersion`,
    `zt_scene`.`deleted` AS `deleted`,
    '' AS `lastRunner`,
    '' AS `lastRunDate`,
    '' AS `lastRunResult`,
    `zt_scene`.`parent` AS `parent`,
    `zt_scene`.`parent` AS `scene`,
    `zt_scene`.`grade` AS `grade`,
    `zt_scene`.`path` AS `path`,
    2 AS `isCase`
  FROM `zt_scene`;

-- DROP TABLE IF EXISTS `zt_priv`;
CREATE TABLE IF NOT EXISTS `zt_priv` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL,
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `system` enum('0','1') NOT NULL DEFAULT '0',
  `order` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `priv` (`module`,`method`)
) ENGINE=InnoDB AUTO_INCREMENT=1768 DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_privmanager`;
CREATE TABLE IF NOT EXISTS `zt_privmanager` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) unsigned NOT NULL,
  `code` varchar(100) NOT NULL,
  `type` enum('view','module','package') NOT NULL DEFAULT 'package',
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `order` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_privlang`;
CREATE TABLE IF NOT EXISTS `zt_privlang` (
  `objectID` mediumint(8) unsigned NOT NULL,
  `objectType` enum('priv','manager') NOT NULL DEFAULT 'priv',
  `lang` varchar(30) NOT NULL,
  `key` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  UNIQUE KEY `objectlang` (`objectID`,`objectType`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_privrelation`;
CREATE TABLE IF NOT EXISTS `zt_privrelation` (
  `priv` mediumint(8) unsigned NOT NULL,
  `type` varchar(30) NOT NULL,
  `relationPriv` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `privrelation`(`priv`, `type`, `relationPriv`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `zt_chart_back` SELECT * FROM `zt_chart`;

ALTER TABLE `zt_chart` MODIFY `fields` mediumtext NULL;
ALTER TABLE `zt_chart` MODIFY `group` varchar(255) NOT NULL;
ALTER TABLE `zt_chart` ADD `stage` enum('draft','published') NOT NULL DEFAULT 'draft' AFTER `sql`;
ALTER TABLE `zt_chart` ADD `langs` text NULL AFTER `fields`;
ALTER TABLE `zt_chart` ADD `step` tinyint(1) unsigned NOT NULL DEFAULT '0' AFTER `filters`;

ALTER TABLE `zt_dataview` ADD `langs` text NULL AFTER `fields`;

ALTER TABLE `zt_screen` ADD `status` enum('draft','published') NOT NULL DEFAULT 'draft' AFTER `scheme`;
ALTER TABLE `zt_screen` ADD `builtin` enum('0', '1') NOT NULL DEFAULT '0' AFTER `status`;

REPLACE INTO `zt_screen`(`id`, `dimension`, `name`, `desc`, `cover`, `scheme`, `status`, `builtin`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(1, 1, '宏观数据盘点大屏', '从宏观的角度快速的了解公司的现状', 'static/images/screen1.png', '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8f\\u89c2\\u6570\\u636e\\u76d8\\u70b9\\u5927\\u5c4f\",\"fontSize\":26,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":124,\"w\":1000,\"h\":480,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":800,\"h\":120,\"x\":0,\"y\":128,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":287,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u7ea7\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":33,\"w\":800,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1018,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1019,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1020,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1021,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1022,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1023,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1024,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1025,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"Bug\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1026,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1027,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1028,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1029,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3v5jz5hzz0c000\",\"isGroup\":true,\"attr\":{\"w\":211,\"h\":150,\"x\":500,\"y\":133,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4f7f\\u7528\\u65f6\\u957f\",\"image\":\"\"},\"groupList\":[{\"id\":\"1hxm2jtfh3y800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":380,\"h\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4f7f\\u7528\\u65f6\\u957f\\u8fb9\\u6846\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#6586ec00\",\"#2cf7fe00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"3aekp6a7tag000\",\"isGroup\":false,\"attr\":{\"x\":60,\"y\":25,\"w\":200,\"h\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4f7f\\u7528\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7985\\u9053\\u4f7f\\u7528\\u65f6\\u957f\\uff1a\",\"fontSize\":19,\"fontColor\":\"#9abdcd\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"right\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4u5rgs0pf34000\",\"sourceID\":1030,\"isGroup\":false,\"attr\":{\"x\":265,\"y\":25,\"w\":252,\"h\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\",\"fontSize\":19,\"fontColor\":\"#9abdcd\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":963,\"y\":139,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387=\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570\\/(\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570+\\u672a\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u4e2a\\u6570)\\uff1b\\nBug\\u4fee\\u590d\\u7387=\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\u4e14\\u72b6\\u6001\\u4e3a\\u5df2\\u5173\\u95ed\\u7684Bug\\u6570\\/(\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\u7684Bug\\u6570+\\u65b9\\u6848\\u4e3a\\u5ef6\\u671f\\u5904\\u7406\\u7684Bug\\u6570+\\u6fc0\\u6d3b\\u7684Bug\\u6570)\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"17sqdjuu74ik00\",\"sourceID\":1031,\"isGroup\":false,\"attr\":{\"x\":460,\"y\":253,\"w\":280,\"h\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCircle\",\"chartConfig\":{\"key\":\"PieCircle\",\"chartKey\":\"VPieCircle\",\"conKey\":\"VPieCircle\",\"title\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/pie-circle-258fcce7.png\"},\"option\":{\"legend\":{\"show\":true,\"top\":\"15%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"title\":{\"text\":\"30.00%\",\"x\":\"center\",\"y\":\"center\",\"textStyle\":{\"color\":\"#FFF\",\"fontSize\":20}},\"type\":\"nomal\",\"tooltip\":{\"show\":false,\"trigger\":\"item\",\"formatter\":\"{d}%\"},\"dataset\":0.25,\"series\":[{\"type\":\"pie\",\"radius\":[\"63%\",\"70%\"],\"label\":{\"show\":false},\"center\":[\"50%\",\"50%\"],\"data\":[{\"value\":[30],\"itemStyle\":{\"color\":\"#03a9f4\",\"shadowBlur\":10,\"shadowColor\":\"#97e2f5\"}},{\"value\":[70],\"itemStyle\":{\"color\":\"#00bcd44a\",\"shadowBlur\":0,\"shadowColor\":\"#00bcd44a\"}}]}]}},{\"id\":\"4u5rgs0pf34000\",\"isGroup\":false,\"attr\":{\"x\":475,\"y\":488,\"w\":250,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"fontSize\":16,\"fontColor\":\"#c6d3d9\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4xgico362ww000\",\"sourceID\":1032,\"isGroup\":false,\"attr\":{\"x\":720,\"y\":253,\"w\":280,\"h\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCircle\",\"chartConfig\":{\"key\":\"PieCircle\",\"chartKey\":\"VPieCircle\",\"conKey\":\"VPieCircle\",\"title\":\"Bug\\u4fee\\u590d\\u7387\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/pie-circle-258fcce7.png\"},\"option\":{\"legend\":{\"show\":true,\"top\":\"15%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"title\":{\"text\":\"30.00%\",\"x\":\"center\",\"y\":\"center\",\"textStyle\":{\"color\":\"#FFF\",\"fontSize\":20}},\"type\":\"nomal\",\"tooltip\":{\"show\":false,\"trigger\":\"item\",\"formatter\":\"{d}%\"},\"dataset\":0.25,\"series\":[{\"type\":\"pie\",\"radius\":[\"63%\",\"70%\"],\"label\":{\"show\":false},\"center\":[\"50%\",\"50%\"],\"data\":[{\"value\":[30],\"itemStyle\":{\"color\":\"#C29160\",\"shadowBlur\":10,\"shadowColor\":\"#eed045\"}},{\"value\":[70],\"itemStyle\":{\"color\":\"#00bcd44a\",\"shadowBlur\":0,\"shadowColor\":\"#00bcd44a\"}}]}]}},{\"id\":\"4u5rgs0pf34000\",\"isGroup\":false,\"attr\":{\"x\":735,\"y\":488,\"w\":250,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u4fee\\u590d\\u7387\",\"fontSize\":16,\"fontColor\":\"#c6d3d9\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":1010,\"y\":124,\"w\":290,\"h\":480,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":400,\"h\":120,\"x\":1010,\"y\":128,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":400,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u7ea7\\u672a\\u5b8c\\u6210\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":235,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":235,\"y\":34,\"w\":41,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1033,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1034,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1035,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1036,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u8ba1\\u5212\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1037,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u8ba1\\u5212\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1038,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6267\\u884c\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"Bug\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1039,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1040,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4efb\\u52a1\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1260,\"y\":139,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u672a\\u5b8c\\u6210\\u7684\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u4ea7\\u54c1\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u4ea7\\u54c1\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u9879\\u76ee\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u9879\\u76ee\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u8ba1\\u5212\\u4e2a\\u6570=\\u672a\\u5b8c\\u6210\\u7684\\u8ba1\\u5212\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u6267\\u884c\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u6267\\u884c\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u4e2a\\u6570=\\u672a\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684Bug\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684Bug\\u4e2a\\u6570\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":618,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":618,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":212,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":212,\"y\":33,\"w\":1065,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1041,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":1153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1042,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":380,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"2%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"10\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}},{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[2]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":5,\"maxValueSpan\":5,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path:\\/\\/M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":-10,\"y\":0,\"w\":378,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\\u4fee\\u590d\\u7387\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":349,\"y\":33,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":350,\"y\":35,\"w\":55,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1xih6tzmmssg00\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":1153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"image\":\"\"},\"groupList\":[{\"id\":\"2bnelf1diy8000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"1351cy224nb400\",\"isGroup\":false,\"attr\":{\"x\":10,\"y\":0,\"w\":240,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":247,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":248,\"y\":32,\"w\":160,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"4ocyn7hip9k000\",\"sourceID\":1043,\"isGroup\":false,\"attr\":{\"x\":10,\"y\":67,\"w\":400,\"h\":410,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"\\u997c\\u56fe\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"30%\",\"30%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":5},\"center\":[\"50%\",\"50%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"2js0ncv6kpc000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":865,\"x\":874,\"y\":1153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"image\":\"\"},\"groupList\":[{\"id\":\"4d4pumofn5g000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"50qj95gt8fs000\",\"sourceID\":1044,\"isGroup\":false,\"attr\":{\"x\":10,\"y\":76,\"w\":400,\"h\":400,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"\\u997c\\u56fe\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"30%\",\"30%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":5},\"center\":[\"50%\",\"50%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}},{\"id\":\"36zg35ree9q000\",\"isGroup\":false,\"attr\":{\"x\":8,\"y\":0,\"w\":180,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":186,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":188,\"y\":32,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1663,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"vwvqtuc6lyo00\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1663,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"5l0cps9x0z0000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":161,\"y\":33,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":163,\"y\":35,\"w\":1105,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1045,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"sl2d95i1hz400\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":2203,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"image\":\"\"},\"groupList\":[{\"id\":\"57zre1am96c000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"42ae8w3dgeg000\",\"sourceID\":1046,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":530,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"15%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"item\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path:\\/\\/M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"579jc04cfps000\",\"isGroup\":false,\"attr\":{\"x\":10,\"y\":0,\"w\":170,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":33,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":35,\"w\":445,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"nr1mfqoyuwg00\",\"isGroup\":true,\"attr\":{\"w\":645,\"h\":500,\"x\":655,\"y\":2203,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"2ta7xcd152i000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":645,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4ea7\\u54c1Bug\\u4fee\\u590d\\u7387\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"4o7ep6z91ii000\",\"sourceID\":1047,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":540,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"15%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path:\\/\\/M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"4vcyxy305n6000\",\"isGroup\":false,\"attr\":{\"x\":12,\"y\":0,\"w\":160,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1Bug\\u4fee\\u590d\\u7387\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1Bug\\u4fee\\u590d\\u7387\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":171,\"y\":34,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":172,\"y\":36,\"w\":445,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"45ao1xz9kzu000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":2717,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1ncdmrlvzjy800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"v3d9spa59dc00\",\"sourceID\":1049,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":50,\"w\":380,\"h\":426,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"15%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path:\\/\\/M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"wam6ydb8zqo00\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":160,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":32,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":34,\"w\":235,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"2dg0t90atgg000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":2717,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"53ynqk2kzh8000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"1knkjcb65rwg00\",\"isGroup\":false,\"attr\":{\"x\":7,\"y\":0,\"w\":170,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"mblj8ow100000\",\"sourceID\":1050,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":60,\"w\":400,\"h\":420,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"40%\",\"40%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":5},\"center\":[\"50%\",\"45%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":168,\"y\":32,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":169,\"y\":34,\"w\":235,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1j55da3c41vk00\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":2717,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1xqnm37nva8w00\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"5ll028fasrw000\",\"sourceID\":1051,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":50,\"w\":380,\"h\":426,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"20%\",\"top\":\"20\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"4887ix47ule000\",\"isGroup\":false,\"attr\":{\"x\":7,\"y\":0,\"w\":170,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":170,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":171,\"y\":33,\"w\":235,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}}]', 'published', '1', 'admin', '2022-11-18 10:46:18', 'admin', '2023-03-23 15:01:00', '0'),
(2, 1, '公司年度汇总数据大屏', '从不同的年份了解公司汇总数据的情况', 'static/images/screen2.png', '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\" \\u516c\\u53f8\\u5e74\\u5ea6\\u6c47\\u603b\\u6570\\u636e\\u5927\\u5c4f\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":300,\"h\":120,\"x\":0,\"y\":95,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"type\":\"year\",\"filterCharts\":[{\"chart\":1055,\"field\":\"t1.`year`\"},{\"chart\":1056,\"field\":\"t1.`year`\"},{\"chart\":1057,\"field\":\"t1.`year`\"},{\"chart\":1058,\"field\":\"t1.`year`\"},{\"chart\":1059,\"field\":\"t1.`year`\"},{\"chart\":1060,\"field\":\"t1.`year`\"},{\"chart\":1061,\"field\":\"t1.`year`\"},{\"chart\":1062,\"field\":\"t1.`year`\"},{\"chart\":1063,\"field\":\"t1.`year`\"},{\"chart\":1064,\"field\":\"t1.`year`\"},{\"chart\":1065,\"field\":\"t1.`year`\"},{\"chart\":1066,\"field\":\"t1.`year`\"},{\"chart\":1067,\"field\":\"t1.`year`\"},{\"chart\":1068,\"field\":\"t1.`year`\"},{\"chart\":1069,\"field\":\"t1.`year`\"},{\"chart\":1070,\"field\":\"t1.`year`\"},{\"chart\":1071,\"field\":\"t1.`year`\"},{\"chart\":1072,\"field\":\"t1.`year`\"},{\"chart\":1073,\"field\":\"t1.`year`\"},{\"chart\":1074,\"field\":\"t1.`year`\"},{\"chart\":1075,\"field\":\"t1.`year`\"},{\"chart\":1076,\"field\":\"t1.`year`\"},{\"chart\":1077,\"field\":\"t1.`year`\"},{\"chart\":1078,\"field\":\"t1.`year`\"},{\"chart\":1079,\"field\":\"t1.`year`\"},{\"chart\":1080,\"field\":\"t1.`year`\"},{\"chart\":1081,\"field\":\"t1.`year`\"},{\"chart\":1082,\"field\":\"t1.`year`\"},{\"chart\":1083,\"field\":\"t1.`year`\"}],\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"\\u9009\\u62e9\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"\\u8bf7\\u9009\\u62e9\",\"value\":\"\"},{\"label\":\"\\u6cb3\\u5317\",\"value\":\"18700\"},{\"label\":\"\\u5f90\\u5dde\",\"value\":\"17800\"}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"console.log(value)\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":149,\"w\":750,\"h\":300,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":750,\"h\":120,\"x\":0,\"y\":153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u5e74\\u5ea6\\u65b0\\u589e\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":225,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":225,\"y\":32,\"w\":500,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":770,\"y\":149,\"w\":530,\"h\":300,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":820,\"h\":120,\"x\":770,\"y\":153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u5e74\\u5ea6\\u5b8c\\u6210\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":220,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":220,\"y\":32,\"w\":290,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":25,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1055,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":145,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1056,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":265,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1057,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":385,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1058,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":505,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1059,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":25,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1060,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":145,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1061,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":265,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1062,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":385,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1063,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":505,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1064,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":250,\"x\":625,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":190,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1065,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":60,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7528\\u6237\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":78,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7528\\u6237\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7528\\u6237\\u4e2a\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":800,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1066,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":920,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1067,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":1040,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1068,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u53d1\\u5e03\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u53d1\\u5e03\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u53d1\\u5e03\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":800,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1069,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":920,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1070,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u89e3\\u51b3Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u89e3\\u51b3Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u89e3\\u51b3Bug\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":100,\"x\":1040,\"y\":339,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1071,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":100,\"h\":200,\"x\":1160,\"y\":229,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":190,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1072,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":54,\"w\":100,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6295\\u5165\\u5de5\\u65f6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"100\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":78,\"w\":100,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6295\\u5165\\u5de5\\u65f6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6295\\u5165\\u5de5\\u65f6\\u6570\",\"fontSize\":9,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1260,\"y\":165,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u5b8c\\u6210\\u7684\\u9879\\u76ee\\u4e2a\\u6570=\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\\u4e2a\\u6570\\uff1b\\n\\u5b8c\\u6210\\u6267\\u884c\\u6570=\\u5df2\\u5173\\u95ed\\u7684\\u6267\\u884c\\u6570\\uff1b\\n\\u5b8c\\u6210\\u53d1\\u5e03\\u6570=\\u5168\\u90e8\\u53d1\\u5e03\\u6570\\uff1b\\n\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u6570=\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570\\uff1b\\n\\u4fee\\u590d\\u7684Bug\\u6570=Bug\\u72b6\\u6001\\u4e3a\\u5df2\\u5173\\u95ed\\u4e14\\u89e3\\u51b3\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\u7684Bug\\u4e2a\\u6570\\uff1b\\n\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570=\\u4efb\\u52a1\\u72b6\\u6001\\u4e3a\\u5df2\\u5b8c\\u6210+\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":479,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":479,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u96c6\\u5e74\\u5ea6\\u65b0\\u589e\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":1015,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1073,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1029,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1029,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u96c6\\u5e74\\u5ea6\\u5b8c\\u6210\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":33,\"w\":1035,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1074,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1579,\"w\":640,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":120,\"x\":0,\"y\":1579,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u5e74\\u5ea6\\u65b0\\u589e\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":244,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":32,\"w\":370,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1075,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":57,\"w\":600,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":660,\"y\":1579,\"w\":640,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":120,\"x\":660,\"y\":1579,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u5e74\\u5ea6\\u5b8c\\u6210\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":244,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":32,\"w\":370,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1076,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":57,\"w\":600,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":2129,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1077,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":32,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":34,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":660,\"y\":2129,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1078,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":10,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"BUG\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u89e3\\u51b3\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":269,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":270,\"y\":32,\"w\":340,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":2654,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1079,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon \",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4efb\\u52a1\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":660,\"y\":2654,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1080,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":3179,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1081,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6267\\u884c\\u5e74\\u5ea6\\u65b0\\u589e\\u548c\\u5b8c\\u6210\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":259,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":260,\"y\":32,\"w\":350,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":660,\"y\":3179,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1082,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":600,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u6708\\u4efd)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":230,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6b21\\u6570\\u5e74\\u5ea6\\u8d8b\\u52bf\\u56fe\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":239,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":240,\"y\":32,\"w\":370,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":3709,\"w\":1300,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":500,\"x\":0,\"y\":3709,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"image\":\"\"},\"option\":{},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":155,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1083,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":1300,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":[{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"right\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"}],\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"20\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"yAxisIndex\":1,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"bar\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"bar\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":155,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5e74\\u5ea6\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":164,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":165,\"y\":32,\"w\":1080,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}}],\"key\":\"group\"},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1245,\"y\":3726,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"\\/static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u6295\\u5165\\u4ea7\\u51fa\\u6bd4=\\u9700\\u6c42\\u4ea4\\u4ed8\\u6545\\u4e8b\\u70b9\\u6570\\/\\u5de5\\u65f6\\u6d88\\u8017\\uff1b\\n\\u9700\\u6c42\\u4ea4\\u4ed8\\u6545\\u4e8b\\u70b9\\u6570=\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u7684\\u6545\\u4e8b\\u70b9\\u6570\u003b\\n\\u5de5\\u65f6\\u6d88\\u8017=\\u4efb\\u52a1\\u6d88\\u8017\\u7684\\u5de5\\u65f6\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}}]', 'published', '1', 'admin', '2022-11-18 10:46:18', 'admin', '2023-03-23 15:01:00', '0'),
(3, 1, '年度总结大屏', '从年份、部门、个人的角度快速了解年度工作总结的情况', 'static/images/screen3.png', '[\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 0, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/screen_header.png\", \"borderRadius\": 10 }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 360, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"年度总结大屏\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 300, \"h\": 120, \"x\": 0, \"y\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"year\",\n                \"filterCharts\": [\n                    {\"chart\": 1001, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1002, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1003, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1004, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1005, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1006, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1007, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1008, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1009, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1010, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1011, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1012, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1013, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1014, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1015, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1016, \"field\": \"t1.`year`\"},\n                    {\"chart\": 1017, \"field\": \"t1.`year`\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 100, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"dept\",\n                \"filterCharts\": [\n                    {\"chart\": 1001, \"field\": \"\"},\n                    {\"chart\": 1002, \"field\": \"\"},\n                    {\"chart\": 1003, \"field\": \"\"},\n                    {\"chart\": 1004, \"field\": \"\"},\n                    {\"chart\": 1005, \"field\": \"\"},\n                    {\"chart\": 1006, \"field\": \"\"},\n                    {\"chart\": 1007, \"field\": \"\"},\n                    {\"chart\": 1008, \"field\": \"\"},\n                    {\"chart\": 1009, \"field\": \"\"},\n                    {\"chart\": 1010, \"field\": \"\"},\n                    {\"chart\": 1011, \"field\": \"\"},\n                    {\"chart\": 1012, \"field\": \"\"},\n                    {\"chart\": 1013, \"field\": \"\"},\n                    {\"chart\": 1014, \"field\": \"\"},\n                    {\"chart\": 1015, \"field\": \"\"},\n                    {\"chart\": 1016, \"field\": \"\"},\n                    {\"chart\": 1017, \"field\": \"\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 110, \"y\": 0, \"w\": 120, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"type\": \"account\",\n                \"filterCharts\": [\n                    {\"chart\": 1001, \"field\": \"t1.account\"},\n                    {\"chart\": 1002, \"field\": \"t1.account\"},\n                    {\"chart\": 1003, \"field\": \"t1.account\"},\n                    {\"chart\": 1004, \"field\": \"t1.account\"},\n                    {\"chart\": 1005, \"field\": \"t1.account\"},\n                    {\"chart\": 1006, \"field\": \"t1.account\"},\n                    {\"chart\": 1007, \"field\": \"t1.account\"},\n                    {\"chart\": 1008, \"field\": \"t1.account\"},\n                    {\"chart\": 1009, \"field\": \"t1.account\"},\n                    {\"chart\": 1010, \"field\": \"t1.account\"},\n                    {\"chart\": 1011, \"field\": \"t1.account\"},\n                    {\"chart\": 1012, \"field\": \"t1.account\"},\n                    {\"chart\": 1013, \"field\": \"t1.account\"},\n                    {\"chart\": 1014, \"field\": \"t1.account\"},\n                    {\"chart\": 1015, \"field\": \"t1.account\"},\n                    {\"chart\": 1016, \"field\": \"t1.account\"},\n                    {\"chart\": 1017, \"field\": \"t1.account\"}\n                ],\n                \"isGroup\": false,\n                \"attr\": { \"x\": 240, \"y\": 0, \"w\": 120, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Select\",\n                \"chartConfig\": { \"key\": \"Select\", \"chartKey\": \"VSelect\", \"conKey\": \"VCSelect\", \"title\": \"选择\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/select-c616737a.png\" },\n                \"option\": { \"dataset\": [ { \"label\": \"请选择\", \"value\": \"\" }, { \"label\": \"河北\", \"value\": \"18700\" }, { \"label\": \"徐州\", \"value\": \"17800\" } ], \"value\": \"\", \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"background\": \"none\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"center\", \"fontWeight\": \"normal\", \"backgroundColor\": \"transparent\", \"fontSize\": 20, \"onChange\": \"console.log(value)\"}\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 350, \"h\": 380, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 100, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"基础数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 30, \"w\": 200, \"h\": 8.5, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 195, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 150, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"登录次数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1001,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 245, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"操作次数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1002,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 295, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"消耗工时\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1003,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 345, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"待办数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1004,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 0, \"y\": 395, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 40, \"y\": 36, \"w\": 130, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"贡献数\", \"fontSize\": 12, \"fontColor\": \"#ebf3f6\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"sourceID\": 1005,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 200, \"y\": 34, \"w\": 110, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 560, \"h\": 120, \"x\": 370, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 560, \"h\": 380, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 100, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"贡献数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 30, \"w\": 410, \"h\": 8.5, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1006,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 10, \"w\": 500, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": {\n                        \"show\": false, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": false, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": false, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"8%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\", \"containLabel\": true },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [\n                        { \"type\": \"bar\", \"barWidth\": null, \"stack\": \"totoal\", \"emphasis\": {\"focus\": \"series\"}, \"label\": { \"show\": false, \"formatter\": \"{@[1]}\", \"position\": \"center\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } },\n                        { \"type\": \"bar\", \"barWidth\": null, \"stack\": \"totoal\", \"emphasis\": {\"focus\": \"series\"}, \"label\": { \"show\": false, \"formatter\": \"{@[2]}\", \"position\": \"center\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 350, \"h\": 120, \"x\": 950, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 350, \"h\": 380, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 100, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"贡献数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 115, \"y\": 30, \"w\": 200, \"h\": 8.5, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                  \"id\": \"5k6jxu8g200000\",\n                  \"sourceID\": 1007,\n                  \"isGroup\": false,\n                  \"attr\": { \"x\": 0, \"y\": 30, \"w\": 350, \"h\": 300, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                  \"key\": \"Radar\",\n                  \"chartConfig\": { \"key\": \"Radar\", \"chartKey\": \"VRadar\", \"conKey\": \"VCRadar\", \"title\": \"雷达图\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Charts\", \"chartFrame\": \"common\", \"image\": \"static/png/radar.png\" },\n                  \"option\": {\n                    \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" }, \"data\": [ \"data1\" ] },\n                    \"tooltip\": { \"show\": true },\n                    \"dataset\": { \"radarIndicator\": [ { \"name\": \"数据1\", \"max\": 6500 }, { \"name\": \"数据2\", \"max\": 16000 }, { \"name\": \"数据3\", \"max\": 30000 }, { \"name\": \"数据4\", \"max\": 38000 }, { \"name\": \"数据5\", \"max\": 52000 }, { \"name\": \"数据6\", \"max\": 25000 } ], \"seriesData\": [ { \"name\": \"data1\", \"value\": [ 4200, 3000, 20000, 35000, 50000, 18000 ] } ] },\n                    \"radar\": { \"shape\": \"polygon\", \"radius\": [ \"0%\", \"60%\" ], \"center\": [ \"50%\", \"55%\" ], \"splitArea\": { \"show\": true }, \"splitLine\": { \"show\": true }, \"axisName\": { \"show\": true, \"color\": \"#eee\", \"fontSize\": 12 }, \"axisLine\": { \"show\": true }, \"axisTick\": { \"show\": true }, \"indicator\": [ { \"name\": \"数据1\", \"max\": 6500 }, { \"name\": \"数据2\", \"max\": 16000 }, { \"name\": \"数据3\", \"max\": 30000 }, { \"name\": \"数据4\", \"max\": 38000 }, { \"name\": \"数据5\", \"max\": 52000 }, { \"name\": \"数据6\", \"max\": 25000 } ] },\n                    \"series\": [ { \"name\": \"radar\", \"type\": \"radar\", \"areaStyle\": { \"opacity\": 0.1 }, \"data\": [ { \"name\": \"data1\", \"value\": [ 4200, 3000, 20000, 35000, 50000, 18000 ] } ] } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                  }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 120, \"x\": 0, \"y\": 570, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"迭代数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 31, \"w\": 495, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1008,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 590, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 120, \"x\": 660, \"y\": 570, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 31, \"w\": 495, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1009,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 590, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 1110, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务状态分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1010,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月任务操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1011,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 1525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求状态分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1012,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月需求操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1013,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 1935, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug状态分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1014,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月Bug操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1015,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 400, \"x\": 0, \"y\": 2350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1cfwp95aiif400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"用例数据\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 120, \"y\": 30, \"w\": 1150, \"h\": 9, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 57, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"用例结果分布\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1016,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 70, \"w\": 380, \"h\": 280, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"65%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\" }, \"center\": [ \"50%\", \"60%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 38, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"每月用例操作情况\", \"fontSize\": 12, \"fontColor\": \"#d7e0e4\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2mxz8pdw932000\",\n                \"sourceID\": 1017,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 520, \"y\": 70, \"w\": 780, \"h\": 350, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCommon\",\n                \"chartConfig\": { \"key\": \"BarCommon\", \"chartKey\": \"VBarCommon\", \"conKey\": \"VCBarCommon\", \"title\": \"柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_x.png\" },\n                \"option\": {\n                    \"legend\": { \"show\": true, \"top\": \"5%\", \"left\": 5, \"textStyle\": { \"color\": \"#B9B8CE\" } },\n                    \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": true, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" },\n                    \"grid\": { \"show\": false, \"left\": \"5%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": {\n                        \"dimensions\": [ \"product\", \"data1\", \"data2\" ],\n                        \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } }, { \"type\": \"bar\", \"barWidth\": 15, \"stack\": \"total\", \"label\": { \"show\": false, \"position\": \"top\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 2 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\"\n                }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    }\n]\n', 'published', '1', 'admin', '2022-11-18 10:46:18', 'admin', '2022-11-18 10:46:18', '0'),
(4, 1, '年度排行榜大屏', '从项目集、项目、产品、个人的角度快速了解进度、投入、产出的排行榜', 'static/images/screen4.png', '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5e74\\u5ea6\\u6392\\u884c\\u699c\\u5927\\u5c4f\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":300,\"h\":120,\"x\":0,\"y\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"type\":\"year\",\"filterCharts\":[{\"chart\":1085,\"field\":\"t1.`year`\"},{\"chart\":1086,\"field\":\"t1.`year`\"},{\"chart\":1087,\"field\":\"t1.`year`\"},{\"chart\":1088,\"field\":\"t1.`year`\"},{\"chart\":1089,\"field\":\"t1.`year`\"},{\"chart\":1090,\"field\":\"t1.`year`\"},{\"chart\":1091,\"field\":\"t1.`year`\"},{\"chart\":1092,\"field\":\"t1.`year`\"},{\"chart\":1093,\"field\":\"t1.`year`\"},{\"chart\":1094,\"field\":\"t1.`year`\"},{\"chart\":1096,\"field\":\"t1.`year`\"},{\"chart\":1097,\"field\":\"t1.`year`\"},{\"chart\":1098,\"field\":\"t1.`year`\"},{\"chart\":1099,\"field\":\"t1.`year`\"},{\"chart\":1100,\"field\":\"t1.`year`\"},{\"chart\":1101,\"field\":\"t1.`year`\"},{\"chart\":1102,\"field\":\"t1.`year`\"},{\"chart\":1103,\"field\":\"t1.`year`\"},{\"chart\":1104,\"field\":\"t1.`year`\"},{\"chart\":1105,\"field\":\"t1.`year`\"},{\"chart\":1106,\"field\":\"t1.`year`\"},{\"chart\":1107,\"field\":\"t1.`year`\"},{\"chart\":1108,\"field\":\"t1.`year`\"},{\"chart\":1109,\"field\":\"t1.`year`\"},{\"chart\":1110,\"field\":\"t1.`year`\"}],\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"\\u9009\\u62e9\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"\\u8bf7\\u9009\\u62e9\",\"value\":\"\"},{\"label\":\"\\u6cb3\\u5317\",\"value\":\"18700\"},{\"label\":\"\\u5f90\\u5dde\",\"value\":\"17800\"}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"console.log(value)\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":100,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":525,\"y\":33,\"w\":250,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Decorates06\",\"chartConfig\":{\"key\":\"Decorates06\",\"chartKey\":\"VDecorates06\",\"conKey\":\"VCDecorates06\",\"title\":\"\\u88c5\\u9970-06\",\"category\":\"Decorates\",\"categoryName\":\"\\u88c5\\u9970\",\"package\":\"Decorates\",\"chartFrame\":\"static\",\"image\":\"decorates06.png\"},\"option\":{\"colors\":[\"#1DC1F533\",\"#1A77A5\"],\"dataset\":\"\\u9879\\u76ee\\u96c6\",\"textColor\":\"#b2d5e5\",\"textSize\":20}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":200,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":200,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9884\\u7b97\\u6295\\u5165\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":140,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9884\\u7b97\\u6295\\u5165(\\u4e07\\u5143)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1085,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":200,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":200,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4eba\\u5458\\u6295\\u5165\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4eba\\u5458\\u6295\\u5165(\\u4eba)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1086,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":835,\"y\":220,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u67d0\\u9879\\u76ee\\u96c6\\u67d0\\u5e74\\u7684\\u4eba\\u5458\\u6295\\u5165=\\u67d0\\u5e74\\u5185\\u67d0\\u9879\\u76ee\\u96c6\\u4e2d\\u8fdb\\u884c\\u8fc7\\u7684\\u9879\\u76ee\\uff0c\\u5176\\u56e2\\u961f\\u6210\\u5458\\u52a0\\u76df\\u65e5\\u671f\\u4e3a\\u67d0\\u5e74\\u7684\\u6700\\u540e\\u4e00\\u5929\\u4ee5\\u53ca\\u6700\\u540e\\u4e00\\u5929\\u4e4b\\u524d\\u7684\\u6210\\u5458\\u4eba\\u6570\\u4e4b\\u548c\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":200,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":200,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u65f6\\u6d88\\u8017\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u65f6\\u6d88\\u8017(h)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1087,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1272,\"y\":220,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u67d0\\u9879\\u76ee\\u96c6\\u5e74\\u5ea6\\u5de5\\u65f6\\u6d88\\u8017=\\u67d0\\u5e74\\u67d0\\u9879\\u76ee\\u96c6\\u4e2d\\u8fdb\\u884c\\u8fc7\\u7684\\u9879\\u76ee\\u7684\\u7d2f\\u8ba1\\u5de5\\u65f6\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":710,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":710,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":153,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1088,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":710,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":710,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u65b0\\u589e\\u9700\\u6c42\\u89c4\\u6a21\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u89c4\\u6a21(sp)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1089,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":710,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":710,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u65b0\\u589eBug\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":177,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":178,\"y\":28,\"w\":208,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1090,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1220,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":1220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":170,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1091,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":1220,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":1220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\" \\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u89c4\\u6a21(sp)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1092,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":1220,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":1220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4fee\\u590dBug\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":177,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":178,\"y\":28,\"w\":208,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1093,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1700,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":525,\"y\":36,\"w\":250,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Decorates06\",\"chartConfig\":{\"key\":\"Decorates06\",\"chartKey\":\"VDecorates06\",\"conKey\":\"VCDecorates06\",\"title\":\"\\u88c5\\u9970-06\",\"category\":\"Decorates\",\"categoryName\":\"\\u88c5\\u9970\",\"package\":\"Decorates\",\"chartFrame\":\"static\",\"image\":\"decorates06.png\"},\"option\":{\"colors\":[\"#1DC1F533\",\"#1A77A5\"],\"dataset\":\"\\u9879\\u76ee\",\"textColor\":\"#b2d5e5\",\"textSize\":20}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1800,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":1800,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u671f\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":170,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u671f(\\u5929)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":95,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":96,\"y\":28,\"w\":290,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1094,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":395,\"y\":1825,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u672a\\u7ed3\\u675f\\u9879\\u76ee\\u7684\\u5de5\\u671f=\\u5f53\\u524d\\u65e5\\u671f-\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\\uff1b\\n\\u5df2\\u7ed3\\u675f\\u9879\\u76ee\\u7684\\u5de5\\u671f=\\u5b9e\\u9645\\u7ed3\\u675f\\u65e5\\u671f-\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":1800,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":1800,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u671f\\u504f\\u5dee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1096,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":835,\"y\":1825,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u5df2\\u5b8c\\u6210\\u9879\\u76ee\\u7684\\u5de5\\u671f\\u504f\\u5dee\\u7387=\\uff08\\u5b9e\\u9645\\u5de5\\u671f-\\u8ba1\\u5212\\u5de5\\u671f\\uff09\\/\\u8ba1\\u5212\\u5de5\\u671f*100%\\uff1b\\n\\u5df2\\u8d85\\u671f\\u9879\\u76ee\\u7684\\u5de5\\u671f\\u504f\\u5dee\\u7387=\\uff08\\uff08\\u5f53\\u524d\\u65e5\\u671f-\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\\uff09-\\u8ba1\\u5212\\u5de5\\u671f\\uff09\\/\\u8ba1\\u5212\\u5de5\\u671f*100%\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":1800,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":1800,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4eba\\u5458\\u6295\\u5165\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4eba\\u5458\\u6295\\u5165(\\u4eba)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1097,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1272,\"y\":1825,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u67d0\\u9879\\u76ee\\u67d0\\u5e74\\u7684\\u4eba\\u5458\\u6295\\u5165=\\u67d0\\u5e74\\u8fdb\\u884c\\u8fc7\\u7684\\u9879\\u76ee\\uff0c\\u5176\\u56e2\\u961f\\u6210\\u5458\\u52a0\\u76df\\u65e5\\u671f\\u4e3a\\u67d0\\u5e74\\u7684\\u6700\\u540e\\u4e00\\u5929\\u4ee5\\u53ca\\u6700\\u540e\\u4e00\\u5929\\u4e4b\\u524d\\u7684\\u6210\\u5458\\u4eba\\u6570\\u4e4b\\u548c\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":2310,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":2310,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u65f6\\u6d88\\u8017\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u65f6\\u6d88\\u8017(h)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1098,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":2310,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":2310,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":153,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1099,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":2310,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":2310,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u89c4\\u6a21(sp)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1100,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":2790,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":525,\"y\":36,\"w\":250,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Decorates06\",\"chartConfig\":{\"key\":\"Decorates06\",\"chartKey\":\"VDecorates06\",\"conKey\":\"VCDecorates06\",\"title\":\"\\u88c5\\u9970-06\",\"category\":\"Decorates\",\"categoryName\":\"\\u88c5\\u9970\",\"package\":\"Decorates\",\"chartFrame\":\"static\",\"image\":\"decorates06.png\"},\"option\":{\"colors\":[\"#1DC1F533\",\"#1A77A5\"],\"dataset\":\"\\u4ea7\\u54c1\",\"textColor\":\"#b2d5e5\",\"textSize\":20}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":2890,\"w\":645,\"h\":580,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":600,\"h\":500,\"x\":0,\"y\":2890,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":250,\"y\":515,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":400,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1101,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":530,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":655,\"y\":2890,\"w\":645,\"h\":580,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":600,\"h\":580,\"x\":655,\"y\":2890,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":515,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u89c4\\u6a21(sp)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":400,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1102,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":530,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":3480,\"w\":645,\"h\":580,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":600,\"h\":500,\"x\":0,\"y\":3480,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u65b0\\u589eBug\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":250,\"y\":515,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":177,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":178,\"y\":28,\"w\":400,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1103,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":530,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":655,\"y\":3480,\"w\":645,\"h\":580,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":600,\"h\":580,\"x\":655,\"y\":3480,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4fee\\u590dBug\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":250,\"y\":515,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":400,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1104,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":530,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":4040,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":525,\"y\":36,\"w\":250,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Decorates06\",\"chartConfig\":{\"key\":\"Decorates06\",\"chartKey\":\"VDecorates06\",\"conKey\":\"VCDecorates06\",\"title\":\"\\u88c5\\u9970-06\",\"category\":\"Decorates\",\"categoryName\":\"\\u88c5\\u9970\",\"package\":\"Decorates\",\"chartFrame\":\"static\",\"image\":\"decorates06.png\"},\"option\":{\"colors\":[\"#1DC1F533\",\"#1A77A5\"],\"dataset\":\"\\u4e2a\\u4eba\",\"textColor\":\"#b2d5e5\",\"textSize\":20}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":4140,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":4140,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u521b\\u5efa\\u9700\\u6c42\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":153,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9700\\u6c42\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1105,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":4140,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":4140,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u521b\\u5efa\\u7528\\u4f8b\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":153,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7528\\u4f8b\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1106,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":4140,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":4140,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u521b\\u5efaBug\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":177,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":178,\"y\":28,\"w\":208,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1107,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":4650,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":4650,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4fee\\u590dBug\\u6761\\u76ee\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":150,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"Bug\\u6761\\u76ee(\\u4e2a)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1108,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":437,\"y\":4650,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":4650,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u65f6\\u6d88\\u8017\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u5de5\\u65f6\\u6d88\\u8017(h)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":135,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":136,\"y\":28,\"w\":250,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1109,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":874,\"y\":4650,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":4650,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7985\\u9053\\u64cd\\u4f5c\\u6b21\\u6570\\u699c\",\"fontSize\":16,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":153,\"y\":430,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u64cd\\u4f5c\\u6b21\\u6570(\\u6b21)\",\"fontSize\":10,\"fontColor\":\"#fafafb\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":28,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1110,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":40,\"w\":380,\"h\":440,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"backgroundColor\":\"#cfcfcf00\",\"handleSize\":0,\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}}],\"key\":\"group\",\"option\":{}}]', 'published', '1', 'admin', '2022-11-18 10:46:18', 'admin', '2023-03-23 15:01:00', '0'),
(5, 1, '迭代燃尽图大屏', '快速查看公司全部未关闭迭代的燃尽图', 'static/images/screen5.png', '', 'published', '1', 'admin', '2022-11-18 10:46:18', 'admin', '2022-11-18 10:46:18', '0'),
(6, 2, '年度完成项目过程数据大屏', '了解已完成项目的生产效率', 'static/images/screen1.png', '{\"editCanvasConfig\":{\"projectName\":\"2\",\"width\":1366,\"height\":\"3600\",\"size\":0,\"lockScale\":false,\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"background\":null,\"backgroundImage\":null,\"selectColor\":true,\"chartThemeColor\":\"3wvajowr6l8000\",\"chartThemeSetting\":{\"title\":{\"text\":\"\",\"show\":true,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"dataset\":null,\"renderer\":\"svg\"},\"previewScaleType\":\"scrollY\",\"globalFilter\":[],\"chartCustomThemeColorInfo\":[{\"id\":\"3wvajowr6l8000\",\"name\":\"未命名\",\"color\":[\"#6ae5bb\",\"#69e3de\",\"#5ac5ee\",\"#6FB6F1FF\",\"#4498ec\",\"#3c7ddf\",\"#1E6AEBFF\"]}]},\"componentList\":[{\"id\":\"owvo5wyad9c00\",\"isGroup\":false,\"attr\":{\"x\":1142,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3as8najk6hg00\",\"isGroup\":false,\"attr\":{\"x\":1142,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5d6bo6dfzf4000\",\"isGroup\":false,\"attr\":{\"x\":962,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"26hlsg2c15vk00\",\"isGroup\":false,\"attr\":{\"x\":962,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5niqhm817gw000\",\"isGroup\":false,\"attr\":{\"x\":782,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5rjfkvfw4i8000\",\"isGroup\":false,\"attr\":{\"x\":782,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"ffvurro4h4w00\",\"isGroup\":false,\"attr\":{\"x\":603,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"51idc736a5s000\",\"isGroup\":false,\"attr\":{\"x\":602,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"rdnf6i797pc00\",\"isGroup\":false,\"attr\":{\"x\":421,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089ff12\"}},{\"id\":\"2klk0oo8kj8000\",\"isGroup\":false,\"attr\":{\"x\":421,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"48zdrnjvl0c000\",\"isGroup\":false,\"attr\":{\"x\":242,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4q65e0gqmlg000\",\"isGroup\":false,\"attr\":{\"x\":61,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"17bvssn39zuk00\",\"isGroup\":false,\"attr\":{\"x\":242,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5irrkthvdhc000\",\"isGroup\":false,\"attr\":{\"x\":61,\"y\":\"208\",\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"vgfp0juvuf400\",\"isGroup\":false,\"attr\":{\"x\":416,\"y\":339,\"w\":161,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"延期完成执行数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#E1E5EA00\"}},{\"id\":\"2uqxi3e1y3u000\",\"isGroup\":false,\"attr\":{\"x\":424,\"y\":303,\"w\":144,\"h\":81,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-延期完成执行数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"1326\",\"sourceID\":\"10009\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"1326\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10009\",\"title\":\"延期完成执行数\",\"type\":\"card\"},{\"id\":\"5nyrxc5w010000\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":726,\"w\":653,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":true,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"2uws0ytah1s000\",\"isGroup\":false,\"attr\":{\"x\":693,\"y\":726,\"w\":653,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":true,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3mnttqgyc4o000\",\"isGroup\":false,\"attr\":{\"x\":253,\"y\":46,\"w\":860,\"h\":32,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1089FF42\",\"#1089FF00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"4nir9d6n138000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":106,\"w\":1326,\"h\":600,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":true,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3sdxo2ffqi0000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\" 完成项目数 \",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":37,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4nyo2dxv5yi000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成项目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"91\",\"sourceID\":\"10000\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"91\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10000\",\"title\":\"完成项目数\",\"type\":\"card\"},{\"id\":\"2ev27p00xbpc00\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"按时完成项目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"lzaj0yorolc00\",\"isGroup\":false,\"attr\":{\"x\":410,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"延期完成项目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4jogna07yk8000\",\"isGroup\":false,\"attr\":{\"x\":771,\"y\":229,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成需求规模数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"15j805dkq4ik00\",\"isGroup\":false,\"attr\":{\"x\":951,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成发布数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":36,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4q15hg06540000\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"解决bug数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":36,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4l83s1sqlek000\",\"isGroup\":false,\"attr\":{\"x\":591,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成需求条目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"5f6dr2y034w000\",\"isGroup\":false,\"attr\":{\"x\":231,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-按时完成项目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"3\",\"sourceID\":\"10001\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"3\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10001\",\"title\":\"按时完成项目数\",\"type\":\"card\"},{\"id\":\"1gw11ho3ev4w00\",\"isGroup\":false,\"attr\":{\"x\":410,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-延期完成项目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"88\",\"sourceID\":\"10002\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"88\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10002\",\"title\":\"延期完成项目数\",\"type\":\"card\"},{\"id\":\"4ljohxdlzfs000\",\"isGroup\":false,\"attr\":{\"x\":591,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成需求条目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"17954\",\"sourceID\":\"10003\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"17954\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10003\",\"title\":\"完成需求条目数\",\"type\":\"card\"},{\"id\":\"2dsxvobrqdes00\",\"isGroup\":false,\"attr\":{\"x\":771,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成需求规模数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"57370\",\"sourceID\":\"10004\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"57370\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10004\",\"title\":\"完成需求规模数\",\"type\":\"card\"},{\"id\":\"25j01jdzmrts00\",\"isGroup\":false,\"attr\":{\"x\":951,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成发布数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"602\",\"sourceID\":\"10005\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"602\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10005\",\"title\":\"完成发布数\",\"type\":\"card\"},{\"id\":\"poh8lbo2qc000\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-解决bug数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"13886\",\"sourceID\":\"10006\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"13886\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10006\",\"title\":\"解决bug数\",\"type\":\"card\"},{\"id\":\"4nkffa1hzc0000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成执行数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":34,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"43q8d7h9nlk000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成执行数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"1567\",\"sourceID\":\"10007\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"1567\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10007\",\"title\":\"完成执行数\",\"type\":\"card\"},{\"id\":\"5jexl1ycymg000\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"按时完成执行数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"3362s9jdoko000\",\"isGroup\":false,\"attr\":{\"x\":605,\"y\":338,\"w\":166,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成任务条目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"5l9fr10ck94000\",\"isGroup\":false,\"attr\":{\"x\":772,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成任务预计工时数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":8,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"1zxjse36amv400\",\"isGroup\":false,\"attr\":{\"x\":952,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成任务消耗工时数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":8,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"29iw7qg73bbw00\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"投入的总人天\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":28,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"1r8qfow1e45c00\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-按时完成执行数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"241\",\"sourceID\":\"10008\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"241\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10008\",\"title\":\"按时完成执行数\",\"type\":\"card\"},{\"id\":\"2bnzdjpcesg000\",\"isGroup\":false,\"attr\":{\"x\":591,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成任务条目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"38661\",\"sourceID\":\"10010\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"38661\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10010\",\"title\":\"完成任务条目数\",\"type\":\"card\"},{\"id\":\"5rwyxojtmnw000\",\"isGroup\":false,\"attr\":{\"x\":772,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成任务预计工时数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"109341\",\"sourceID\":\"10011\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"109341\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10011\",\"title\":\"完成任务预计工时数\",\"type\":\"card\"},{\"id\":\"1ook02lf4ns000\",\"isGroup\":false,\"attr\":{\"x\":951,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成任务消耗工时数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"101601\",\"sourceID\":\"10012\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"101601\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10012\",\"title\":\"完成任务消耗工时数\",\"type\":\"card\"},{\"id\":\"3c1qy9alml2000\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-投入的总人天\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"12339\",\"sourceID\":\"10013\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"12339\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10013\",\"title\":\"投入的总人天\",\"type\":\"card\"},{\"id\":\"4v411wy0jam000\",\"isGroup\":false,\"attr\":{\"x\":68,\"y\":439,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"PieCircle\",\"chartConfig\":{\"key\":\"PieCircle\",\"chartKey\":\"VPieCircle\",\"conKey\":\"VCPieCircle\",\"title\":\"项目过程-项目按期完成率\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie-circle.png\",\"sourceID\":\"10014\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"legend\":{\"show\":true},\"dataset\":0,\"title\":{\"text\":\"0.00%\",\"x\":\"center\",\"y\":\"center\",\"textStyle\":{\"color\":\"#4498ECFF\",\"fontSize\":30}},\"series\":[{\"type\":\"pie\",\"radius\":[\"75%\",\"80%\"],\"center\":[\"50%\",\"50%\"],\"hoverAnimation\":true,\"color\":[\"#00bcd44a\",\"transparent\"],\"label\":{\"show\":false},\"data\":[{\"value\":[0],\"itemStyle\":{\"color\":\"#4498ECFF\",\"shadowBlur\":10,\"shadowColor\":\"#6FB6F1FF\"}},{\"value\":[100],\"itemStyle\":{\"color\":\"#6FB6F130\",\"shadowBlur\":0,\"shadowColor\":\"#00bcd44a\"}}]}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10014\",\"title\":\"项目过程-项目按期完成率\",\"type\":\"piecircle\"},{\"id\":\"455e6v96m36000\",\"isGroup\":false,\"attr\":{\"x\":347,\"y\":440,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"PieCircle\",\"chartConfig\":{\"key\":\"PieCircle\",\"chartKey\":\"VPieCircle\",\"conKey\":\"VCPieCircle\",\"title\":\"项目过程-执行按期完成率\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie-circle.png\",\"sourceID\":\"10015\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"legend\":{\"show\":true},\"dataset\":0,\"title\":{\"text\":\"0.00%\",\"x\":\"center\",\"y\":\"center\",\"textStyle\":{\"color\":\"#4498ECFF\",\"fontSize\":30}},\"series\":[{\"type\":\"pie\",\"radius\":[\"75%\",\"80%\"],\"center\":[\"50%\",\"50%\"],\"hoverAnimation\":true,\"color\":[\"#00bcd44a\",\"transparent\"],\"label\":{\"show\":false},\"data\":[{\"value\":[0],\"itemStyle\":{\"color\":\"#4498ECFF\",\"shadowBlur\":10,\"shadowColor\":\"#6FB6F1FF\"}},{\"value\":[100],\"itemStyle\":{\"color\":\"#6FB6F130\",\"shadowBlur\":0,\"shadowColor\":\"#00bcd44a\"}}]}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10015\",\"title\":\"项目过程-执行按期完成率\",\"type\":\"piecircle\"},{\"id\":\"1357hi74tghs00\",\"isGroup\":false,\"attr\":{\"x\":680,\"y\":439,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"PieCircle\",\"chartConfig\":{\"key\":\"PieCircle\",\"chartKey\":\"VPieCircle\",\"conKey\":\"VCPieCircle\",\"title\":\"项目过程-项目延期率\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie-circle.png\",\"sourceID\":\"10016\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"legend\":{\"show\":true},\"dataset\":0,\"title\":{\"text\":\"0.00%\",\"x\":\"center\",\"y\":\"center\",\"textStyle\":{\"color\":\"#69E3DEE0\",\"fontSize\":30}},\"series\":[{\"type\":\"pie\",\"radius\":[\"75%\",\"80%\"],\"center\":[\"50%\",\"50%\"],\"hoverAnimation\":true,\"color\":[\"#00bcd44a\",\"transparent\"],\"label\":{\"show\":false},\"data\":[{\"value\":[0],\"itemStyle\":{\"color\":\"#69E3DEA1\",\"shadowBlur\":10,\"shadowColor\":\"#69E3DEE0\"}},{\"value\":[100],\"itemStyle\":{\"color\":\"#69E3DE21\",\"shadowBlur\":0,\"shadowColor\":\"#FFCE97FF\"}}]}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10016\",\"title\":\"项目过程-项目延期率\",\"type\":\"piecircle\"},{\"id\":\"5czvzl4a3qs000\",\"isGroup\":false,\"attr\":{\"x\":959,\"y\":439,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"PieCircle\",\"chartConfig\":{\"key\":\"PieCircle\",\"chartKey\":\"VPieCircle\",\"conKey\":\"VCPieCircle\",\"title\":\"项目过程-执行延期率\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie-circle.png\",\"sourceID\":\"10017\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"legend\":{\"show\":true},\"dataset\":0,\"title\":{\"text\":\"0.00%\",\"x\":\"center\",\"y\":\"center\",\"textStyle\":{\"color\":\"#69E3DEE0\",\"fontSize\":30}},\"series\":[{\"type\":\"pie\",\"radius\":[\"75%\",\"80%\"],\"center\":[\"50%\",\"50%\"],\"hoverAnimation\":true,\"color\":[\"#00bcd44a\",\"transparent\"],\"label\":{\"show\":false},\"data\":[{\"value\":[0],\"itemStyle\":{\"color\":\"#69E3DEA1\",\"shadowBlur\":10,\"shadowColor\":\"#69E3DEE0\"}},{\"value\":[100],\"itemStyle\":{\"color\":\"#69E3DE21\",\"shadowBlur\":0,\"shadowColor\":\"#6AE5BBFF\"}}]}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10017\",\"title\":\"项目过程-执行延期率\",\"type\":\"piecircle\"},{\"id\":\"3rrf13x8aig000\",\"isGroup\":false,\"attr\":{\"x\":68,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目按期完成率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2fj8shp4iww000\",\"isGroup\":false,\"attr\":{\"x\":349,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"执行按期完成率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"7c0kw504pfo00\",\"isGroup\":false,\"attr\":{\"x\":680,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目延期率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3tdqudx15lm000\",\"isGroup\":false,\"attr\":{\"x\":959,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"执行延期率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"15v07f9mllz400\",\"isGroup\":false,\"attr\":{\"x\":\"27\",\"y\":120,\"w\":242,\"h\":\"58\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"年度完成项目数据盘点\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5rscm33a7a0000\",\"isGroup\":false,\"attr\":{\"x\":916,\"y\":8,\"w\":450,\"h\":75,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates04\",\"chartConfig\":{\"key\":\"Decorates04\",\"chartKey\":\"VDecorates04\",\"conKey\":\"VCDecorates04\",\"title\":\"装饰-04\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates04.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1dc1f5\",\"#1dc1f5\"],\"reverse\":false}},{\"id\":\"48vgwd3xywc000\",\"isGroup\":false,\"attr\":{\"x\":2,\"y\":8,\"w\":450,\"h\":75,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates04\",\"chartConfig\":{\"key\":\"Decorates04\",\"chartKey\":\"VDecorates04\",\"conKey\":\"VCDecorates04\",\"title\":\"装饰-04\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates04.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1dc1f5\",\"#1dc1f5\"],\"reverse\":true}},{\"id\":\"34gsoca72ak000\",\"isGroup\":false,\"attr\":{\"x\":450,\"y\":55,\"w\":466,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates05\",\"chartConfig\":{\"key\":\"Decorates05\",\"chartKey\":\"VDecorates05\",\"conKey\":\"VCDecorates05\",\"title\":\"装饰-05\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates05.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00c2ff\",\"#00c2ff4d\"],\"dur\":3}},{\"id\":\"5emz0hdi03k000\",\"isGroup\":false,\"attr\":{\"x\":1,\"y\":-2,\"w\":1365,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1089FF42\",\"#1089FF00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"afw1xcxn3ug00\",\"isGroup\":false,\"attr\":{\"x\":433,\"y\":7,\"w\":500,\"h\":64,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"年度完成项目过程数据大屏\",\"fontSize\":28,\"fontColor\":\"#b2d5e5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2v5j91if94k000\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":1236,\"w\":1326,\"h\":528,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3h6cqs958r6000\",\"isGroup\":false,\"attr\":{\"x\":\"272\",\"y\":\"1240\",\"w\":\"1040\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4p2d6bkzx2m000\",\"isGroup\":false,\"attr\":{\"x\":\"40\",\"y\":\"1240\",\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工期透视表\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"53verjpnwh8000\",\"isGroup\":false,\"attr\":{\"x\":22,\"y\":2347,\"w\":653,\"h\":619,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5rg2qtyfzno000\",\"isGroup\":false,\"attr\":{\"x\":691,\"y\":2347,\"w\":653,\"h\":617,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4gf68m6chq4000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":2991,\"w\":1326,\"h\":580,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"1t16zb563uzk00\",\"isGroup\":false,\"attr\":{\"x\":53,\"y\":1312,\"w\":1263,\"h\":420,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TableMergeCell\",\"chartConfig\":{\"key\":\"TableMergeCell\",\"chartKey\":\"VTableMergeCell\",\"conKey\":\"VCTableMergeCell\",\"title\":\"完成项目工期透视表\",\"category\":\"Tables\",\"categoryName\":\"列表\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"table_scrollboard.png\",\"sourceID\":\"1000\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":[],\"tableInfo\":{}},\"option\":{\"dataset\":[],\"header\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"columnWidth\":[],\"rowspan\":{},\"colspan\":[],\"evenRowBGC\":\"#FFFFFF00\",\"oddRowBGC\":\"#1089FF1A\",\"headerBGC\":\"#4498EC85\"},\"sourceID\":\"1000\",\"title\":\"完成项目工期透视表\",\"type\":\"table\"},{\"id\":\"12km9ka7t40g00\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":1788,\"w\":1326,\"h\":528,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4wxuogwx6he000\",\"isGroup\":false,\"attr\":{\"x\":236,\"y\":726,\"w\":242,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目完成分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5n8bpai3kcw000\",\"isGroup\":false,\"attr\":{\"x\":\"60\",\"y\":\"2440\",\"w\":\"580\",\"h\":\"500\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"项目过程-完成项目工期偏差条形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_y.png\",\"sourceID\":\"10018\",\"fields\":{},\"filters\":[{\"field\":\"name\",\"type\":\"input\",\"name\":\"项目名称\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":70,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"项目过程-完成项目工期偏差条形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10018\",\"title\":\"完成项目工期偏差条形图\",\"type\":\"cluBarY\"},{\"id\":\"5q7zvaotgyo000\",\"isGroup\":false,\"attr\":{\"x\":724,\"y\":\"2440\",\"w\":\"580\",\"h\":\"500\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"项目过程-完成项目工期偏差条形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_y.png\",\"sourceID\":\"10022\",\"fields\":{},\"filters\":[{\"field\":\"name\",\"type\":\"input\",\"name\":\"项目名称\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":70,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"项目过程-完成项目工期偏差条形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10022\",\"title\":\"完成项目工期偏差条形图\",\"type\":\"cluBarY\"},{\"id\":\"37kkzy05o6u000\",\"isGroup\":false,\"attr\":{\"x\":\"48\",\"y\":\"3100\",\"w\":1265,\"h\":\"420\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCommon\",\"chartConfig\":{\"key\":\"BarCommon\",\"chartKey\":\"VBarCommon\",\"conKey\":\"VCBarCommon\",\"title\":\"项目过程-单位工时交付需求规模数对比图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_x.png\",\"sourceID\":\"10019\",\"fields\":{},\"filters\":[{\"field\":\"project\",\"type\":\"input\",\"name\":\"所属项目\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":90,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"项目过程-单位工时交付需求规模数对比图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":15,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":2}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10019\",\"title\":\"单位工时交付需求规模数对比图\",\"type\":\"cluBarX\"},{\"id\":\"58diyfly21g000\",\"isGroup\":false,\"attr\":{\"x\":900,\"y\":726,\"w\":242,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"执行完成分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4y4a1x55hh4000\",\"isGroup\":false,\"attr\":{\"x\":\"60\",\"y\":\"734\",\"w\":\"182\",\"h\":\"40\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5txcqlq213g000\",\"isGroup\":false,\"attr\":{\"x\":\"460\",\"y\":\"734\",\"w\":\"182\",\"h\":\"40\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5oxxiekui1c000\",\"isGroup\":false,\"attr\":{\"x\":\"724\",\"y\":\"734\",\"w\":\"182\",\"h\":\"33\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"3u3w3sejwiu000\",\"isGroup\":false,\"attr\":{\"x\":1134,\"y\":\"734\",\"w\":182,\"h\":\"40\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"579d65hwr6c00\",\"isGroup\":false,\"attr\":{\"x\":\"64\",\"y\":\"790\",\"w\":\"560\",\"h\":400,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"项目过程-项目完成分布图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10020\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":30,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"title\":{\"text\":\"项目过程-项目完成分布图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"grid\":{\"top\":70},\"dataset\":{},\"series\":[{\"type\":\"pie\",\"radius\":\"70%\",\"center\":[\"50%\",\"60%\"],\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10020\",\"title\":\"项目完成分布图\",\"type\":\"pie\"},{\"id\":\"1ei55qri4gu800\",\"isGroup\":false,\"attr\":{\"x\":\"736\",\"y\":\"790\",\"w\":\"560\",\"h\":\"400\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"项目过程-执行完成分布图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10021\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":30,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"title\":{\"text\":\"项目过程-执行完成分布图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"grid\":{\"top\":70},\"dataset\":{},\"series\":[{\"type\":\"pie\",\"radius\":\"70%\",\"center\":[\"50%\",\"60%\"],\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\": \"#fff\",\"shadowColor\": \"transparent\"},\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10021\",\"title\":\"执行完成分布图\",\"type\":\"pie\"},{\"id\":\"2flxymehju8000\",\"isGroup\":false,\"attr\":{\"x\":\"272\",\"y\":\"1794\",\"w\":\"1036\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":300,\"h\":120,\"x\":277,\"y\":133,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1,\"lockScale\":false},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"u6807u9898\",\"image\":\"\",\"dataset\":[]},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"u9009u62e9\",\"category\":\"Mores\",\"categoryName\":\"u66f4u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"2023\",\"value\":\"2023\"},{\"label\":2022,\"value\":2022},{\"label\":2021,\"value\":2021},{\"label\":2020,\"value\":2020},{\"label\":2019,\"value\":2019},{\"label\":2018,\"value\":2018},{\"label\":2017,\"value\":2017},{\"label\":2016,\"value\":2016},{\"label\":2015,\"value\":2015},{\"label\":2014,\"value\":2014},{\"label\":2013,\"value\":2013},{\"label\":2012,\"value\":2012},{\"label\":2011,\"value\":2011},{\"label\":2010,\"value\":2010},{\"label\":2009,\"value\":2009}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"window.location.href = createLink(\'screen\', \'view\', \'screenID=6&year=\' + value + \'&dept=&account=\')\"},\"type\":\"year\",\"filterCharts\":[{\"chart\":10000,\"field\":\"t1.`year`\"},{\"chart\":10001,\"field\":\"t1.`year`\"},{\"chart\":10002,\"field\":\"t1.`year`\"},{\"chart\":10003,\"field\":\"t1.`year`\"},{\"chart\":10004,\"field\":\"t1.`year`\"},{\"chart\":10005,\"field\":\"t1.`year`\"},{\"chart\":10006,\"field\":\"t1.`year`\"},{\"chart\":10007,\"field\":\"t1.`year`\"},{\"chart\":10008,\"field\":\"t1.`year`\"},{\"chart\":10009,\"field\":\"t1.`year`\"},{\"chart\":10010,\"field\":\"t1.`year`\"},{\"chart\":10011,\"field\":\"t1.`year`\"},{\"chart\":10012,\"field\":\"t1.`year`\"},{\"chart\":10013,\"field\":\"t1.`year`\"},{\"chart\":10014,\"field\":\"t1.`year`\"},{\"chart\":10015,\"field\":\"t1.`year`\"},{\"chart\":10016,\"field\":\"t1.`year`\"},{\"chart\":10017,\"field\":\"t1.`year`\"}]}],\"key\":\"group\",\"option\":{}},{\"id\":\"12pr64gobork00\",\"isGroup\":false,\"attr\":{\"x\":424,\"y\":120,\"w\":882,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"436oj64jvca000\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":2362,\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工期偏差\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1ahevk1yw0tc00\",\"isGroup\":false,\"attr\":{\"x\":\"268\",\"y\":\"2362\",\"w\":\"376\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4kcpsj6i5q8000\",\"isGroup\":false,\"attr\":{\"x\":698,\"y\":\"2362\",\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工时偏差\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5dijh3989bg000\",\"isGroup\":false,\"attr\":{\"x\":\"940\",\"y\":\"2362\",\"w\":\"376\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"17o4abp7p68w00\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":3014,\"w\":\"460\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目单位工时交付需求规模数对比\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4f1dpys6drq000\",\"isGroup\":false,\"attr\":{\"x\":\"500\",\"y\":\"3014\",\"w\":\"820\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#ffffff4d\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4dhr11orgts000\",\"isGroup\":false,\"attr\":{\"x\":\"40\",\"y\":\"1794\",\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工时透视表\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3j6atjdm7co000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":1861,\"w\":1257,\"h\":428,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TableMergeCell\",\"chartConfig\":{\"key\":\"TableMergeCell\",\"chartKey\":\"VTableMergeCell\",\"conKey\":\"VCTableMergeCell\",\"title\":\"完成项目工时透视表\",\"category\":\"Tables\",\"categoryName\":\"列表\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"table_scrollboard.png\",\"sourceID\":\"1001\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":[],\"tableInfo\":{}},\"option\":{\"dataset\":[],\"header\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"columnWidth\":[],\"rowspan\":{},\"colspan\":[],\"oddRowBGC\":\"#1089FF1A\",\"headerBGC\":\"#4498EC85\",\"evenRowBGC\":\"#00000000\"},\"sourceID\":\"1001\",\"title\":\"完成项目工时透视表\",\"type\":\"table\"}],\"requestGlobalConfig\":{\"requestDataPond\":[],\"requestOriginUrl\":\"\",\"requestInterval\":30,\"requestIntervalUnit\":\"second\",\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}}}', 'published', '1', 'admin', '2022-11-18 10:46:18', 'admin', '2023-03-23 15:01:00', '0'),
(7, 2, '年度进行中项目过程跟踪大屏', '从宏观的角度跟踪年度进行中项目的过程数据情况', 'static/images/screen6.png', '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"标题\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\" 年度进行中项目过程跟踪大屏\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":171,\"w\":1300,\"h\":385,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":175,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"标题\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目进度概览\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":145,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":165,\"y\":28,\"w\":1097,\"h\":10,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"fill\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":25,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10101,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"一级项目集个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"一级项目集个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"进行中项目数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":206,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10103,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"产品个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"产品个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"进展顺利项目数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":387,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10105,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"需求个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"需求个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"进度滞后项目数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":568,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10107,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"已延期项目数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":749,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10109,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"计划个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":42,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"计划个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"未完成\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":58,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"计划个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"需求条目数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":930,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10111,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"计划个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":42,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"计划个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"未完成\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":58,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"计划个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"需求规模数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":25,\"y\":390,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10102,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"进行中迭代数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":206,\"y\":390,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10104,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"执行个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"执行个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"进展顺利迭代数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":387,\"y\":390,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10106,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"任务个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"任务个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"进度滞后迭代数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":568,\"y\":390,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10108,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"发布个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文档个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"已延期迭代数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":749,\"y\":390,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10110,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"发布个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"发布个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"未完成任务数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":169,\"h\":159,\"x\":930,\"y\":390,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":169,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10112,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"发布个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"发布个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"剩余工时数\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":159,\"h\":370,\"x\":1111,\"y\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"文档个数\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":159,\"h\":267,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":10113,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":80,\"w\":159,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"用户个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":25,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":130,\"w\":159,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"用户个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"投入的\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":150,\"w\":159,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"用户个数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"总人次\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1260,\"y\":186,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"提示\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"顺利：进度百分比  ≥ （当前日期-计划开始日期）/（计划工期）或者 长期项目\\n滞后：进度百分比 ＜（当前日期-计划开始日期）/（计划工期）\\n延期：计划结束日期 ＜ 当前日期\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":647,\"h\":500,\"x\":0,\"y\":562,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"需求年度新增和完成趋势图\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":647,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"需求年度新增和完成趋势图\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"4ocyn7hip9k000\",\"sourceID\":10114,\"isGroup\":false,\"attr\":{\"x\":10,\"y\":50,\"w\":600,\"h\":410,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"饼图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"30%\",\"30%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":\"10%\"},\"center\":[\"50%\",\"55%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":22,\"w\":600,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"需求年度新增和完成趋势图\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目进度分布图\",\"fontSize\":14,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":647,\"h\":500,\"x\":653,\"y\":562,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"BUG年度新增和解决趋势图\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":647,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"BUG年度新增和解决趋势图\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"4ocyn7hip9k000\",\"sourceID\":10115,\"isGroup\":false,\"attr\":{\"x\":10,\"y\":50,\"w\":600,\"h\":410,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"饼图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"30%\",\"30%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":\"10%\"},\"center\":[\"50%\",\"55%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":22,\"w\":600,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"BUG年度新增和解决趋势图\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"迭代进度分布图\",\"fontSize\":14,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1068,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1068,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"标题\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目进度透视图\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":167,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":187,\"y\":28,\"w\":1083,\"h\":10,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"fill\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":10116,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"轮播列表\",\"category\":\"Tables\",\"categoryName\":\"表格\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static/png/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"列1\",\"列2\",\"列3\"],\"dataset\":[[\"行1列1\",\"行1列2\",\"行1列3\"],[\"行2列1\",\"行2列2\",\"行2列3\"],[\"行3列1\",\"行3列2\",\"行3列3\"],[\"行4列1\",\"行4列2\",\"行4列3\"],[\"行5列1\",\"行5列2\",\"行5列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1597,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1597,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"标题\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"迭代进度透视表\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":165,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":185,\"y\":28,\"w\":1090,\"h\":10,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"fill\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":10117,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"轮播列表\",\"category\":\"Tables\",\"categoryName\":\"表格\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static/png/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"列1\",\"列2\",\"列3\"],\"dataset\":[[\"行1列1\",\"行1列2\",\"行1列3\"],[\"行2列1\",\"行2列2\",\"行2列3\"],[\"行3列1\",\"行3列2\",\"行3列3\"],[\"行4列1\",\"行4列2\",\"行4列3\"],[\"行5列1\",\"行5列2\",\"行5列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":2129,\"w\":647,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":647,\"h\":120,\"x\":0,\"y\":2129,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"标题\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目剩余工作量透视表\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":225,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":28,\"w\":380,\"h\":8,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"fill\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":10118,\"isGroup\":false,\"attr\":{\"x\":17,\"y\":57,\"w\":610,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"轮播列表\",\"category\":\"Tables\",\"categoryName\":\"表格\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static/png/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"列1\",\"列2\",\"列3\"],\"dataset\":[[\"行1列1\",\"行1列2\",\"行1列3\"],[\"行2列1\",\"行2列2\",\"行2列3\"],[\"行3列1\",\"行3列2\",\"行3列3\"],[\"行4列1\",\"行4列2\",\"行4列3\"],[\"行5列1\",\"行5列2\",\"行5列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"]],\"index\":false,\"columnWidth\":[\"120\",\"100\",\"90\",\"130\",\"80\",\"90\"],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":653,\"y\":2129,\"w\":647,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":647,\"h\":120,\"x\":653,\"y\":2129,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"标题\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"迭代剩余工作量透视表\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":225,\"y\":26,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":245,\"y\":28,\"w\":380,\"h\":8,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"fill\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":10119,\"isGroup\":false,\"attr\":{\"x\":17,\"y\":57,\"w\":610,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"轮播列表\",\"category\":\"Tables\",\"categoryName\":\"表格\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static/png/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"列1\",\"列2\",\"列3\"],\"dataset\":[[\"行1列1\",\"行1列2\",\"行1列3\"],[\"行2列1\",\"行2列2\",\"行2列3\"],[\"行3列1\",\"行3列2\",\"行3列3\"],[\"行4列1\",\"行4列2\",\"行4列3\"],[\"行5列1\",\"行5列2\",\"行5列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"],[\"行6列1\",\"行6列2\",\"行6列3\"]],\"index\":false,\"columnWidth\":[\"140\",\"120\",\"90\",\"130\",\"80\",\"90\"],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}}]', 'published', '1', 'admin', '2022-12-07 14:59:41', 'admin', '2022-12-07 14:59:41', '0'),
(8, 3, '公司质量数据盘点大屏', '关于公司质量数据的大屏,整体把握公司生产质量', 'static/images/screen6.png', '{\"editCanvasConfig\":{\"projectName\":\"2\",\"width\":1366,\"height\":3740,\"size\":0,\"lockScale\":false,\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"background\":\"#0B0F18FF\",\"backgroundImage\":null,\"selectColor\":true,\"chartThemeColor\":\"3wvajowr6l8000\",\"chartThemeSetting\":{\"title\":{\"text\":\"\",\"show\":true,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"dataset\":null,\"renderer\":\"svg\"},\"previewScaleType\":\"scrollY\",\"globalFilter\":[],\"chartCustomThemeColorInfo\":[{\"id\":\"3wvajowr6l8000\",\"name\":\"未命名\",\"color\":[\"#6ae5bb\",\"#69e3de\",\"#5ac5ee\",\"#6FB6F1FF\",\"#4498ec\",\"#3c7ddf\",\"#1E6AEBFF\"]}]},\"componentList\":[{\"id\":\"55ojhdng6xc00\",\"isGroup\":false,\"attr\":{\"x\":1128,\"y\":\"202\",\"w\":180,\"h\":102,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3frl1vyqmta000\",\"isGroup\":false,\"attr\":{\"x\":932,\"y\":\"202\",\"w\":180,\"h\":102,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"2ags77k2ww7w00\",\"isGroup\":false,\"attr\":{\"x\":734,\"y\":\"202\",\"w\":180,\"h\":102,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"50nt2l84n38000\",\"isGroup\":false,\"attr\":{\"x\":516,\"y\":202,\"w\":180,\"h\":102,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5mc1lzqkgtg00\",\"isGroup\":false,\"attr\":{\"x\":284,\"y\":202,\"w\":180,\"h\":102,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"1i58n5kxophc00\",\"isGroup\":false,\"attr\":{\"x\":60,\"y\":202,\"w\":180,\"h\":102,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3mnttqgyc4o000\",\"isGroup\":false,\"attr\":{\"x\":253,\"y\":46,\"w\":860,\"h\":32,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1089FF42\",\"#1089FF00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"4nir9d6n138000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":106,\"w\":1326,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3sdxo2ffqi0000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":226,\"w\":200,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"研发完成需求数 \",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":34,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4nyo2dxv5yi000\",\"isGroup\":false,\"attr\":{\"x\":60,\"y\":192,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"质量数据-研发完成需求数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"19033\",\"sourceID\":\"10201\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"19033\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10201\",\"title\":\"质量数据-研发完成需求数\",\"type\":\"card\"},{\"id\":\"2ev27p00xbpc00\",\"isGroup\":false,\"attr\":{\"x\":274,\"y\":226,\"w\":200,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"研发完成需求规模数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":12,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"lzaj0yorolc00\",\"isGroup\":false,\"attr\":{\"x\":506,\"y\":226,\"w\":200,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"研发完成需求用例数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":12,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4jogna07yk8000\",\"isGroup\":false,\"attr\":{\"x\":922,\"y\":226,\"w\":200,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"有效Bug数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":40,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"15j805dkq4ik00\",\"isGroup\":false,\"attr\":{\"x\":1118,\"y\":226,\"w\":200,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"修复Bug数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":48,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"ltddmmh5kkw00\",\"isGroup\":false,\"attr\":{\"x\":-1232,\"y\":613,\"w\":153,\"h\":84,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目数\",\"fontSize\":12,\"fontColor\":\"#ffffff\",\"paddingX\":20,\"paddingY\":20,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"6p4ckgbvmx400\",\"isGroup\":false,\"attr\":{\"x\":-1232,\"y\":613,\"w\":153,\"h\":84,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目数\",\"fontSize\":12,\"fontColor\":\"#ffffff\",\"paddingX\":20,\"paddingY\":20,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5nkv71g8l9o000\",\"isGroup\":false,\"attr\":{\"x\":-1232,\"y\":613,\"w\":153,\"h\":84,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目数\",\"fontSize\":12,\"fontColor\":\"#ffffff\",\"paddingX\":20,\"paddingY\":20,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4l83s1sqlek000\",\"isGroup\":false,\"attr\":{\"x\":724,\"y\":226,\"w\":200,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug总数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":54,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"5f6dr2y034w000\",\"isGroup\":false,\"attr\":{\"x\":284,\"y\":192,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"质量数据-研发完成需求规模数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"62482\",\"sourceID\":\"10202\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"62482\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10202\",\"title\":\"质量数据-研发完成需求规模数\",\"type\":\"card\"},{\"id\":\"1gw11ho3ev4w00\",\"isGroup\":false,\"attr\":{\"x\":516,\"y\":192,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"质量数据-研发完成需求用例数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"2208\",\"sourceID\":\"10203\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"2208\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10203\",\"title\":\"质量数据-研发完成需求用例数\",\"type\":\"card\"},{\"id\":\"4ljohxdlzfs000\",\"isGroup\":false,\"attr\":{\"x\":734,\"y\":192,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"质量数据-Bug总数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"19799\",\"sourceID\":\"10204\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"19799\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10204\",\"title\":\"质量数据-Bug总数\",\"type\":\"card\"},{\"id\":\"2dsxvobrqdes00\",\"isGroup\":false,\"attr\":{\"x\":931,\"y\":191,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"质量数据-有效Bug数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"17341\",\"sourceID\":\"10205\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"17341\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10205\",\"title\":\"质量数据-有效Bug数\",\"type\":\"card\"},{\"id\":\"25j01jdzmrts00\",\"isGroup\":false,\"attr\":{\"x\":1128,\"y\":192,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"质量数据-修复Bug数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"13886\",\"sourceID\":\"10206\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"13886\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10206\",\"title\":\"质量数据-修复Bug数\",\"type\":\"card\"},{\"id\":\"3rrf13x8aig000\",\"isGroup\":false,\"attr\":{\"x\":58,\"y\":528,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"研发完成需求用例覆盖率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2fj8shp4iww000\",\"isGroup\":false,\"attr\":{\"x\":352,\"y\":528,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"研发完成需求用例密度\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"7c0kw504pfo00\",\"isGroup\":false,\"attr\":{\"x\":660,\"y\":528,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug密度\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3tdqudx15lm000\",\"isGroup\":false,\"attr\":{\"x\":972,\"y\":528,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug修复率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"15v07f9mllz400\",\"isGroup\":false,\"attr\":{\"x\":\"23\",\"y\":120,\"w\":201,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"质量数据盘点\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"12pr64gobork00\",\"isGroup\":false,\"attr\":{\"x\":\"232\",\"y\":120,\"w\":1075,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5rscm33a7a0000\",\"isGroup\":false,\"attr\":{\"x\":916,\"y\":8,\"w\":450,\"h\":75,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates04\",\"chartConfig\":{\"key\":\"Decorates04\",\"chartKey\":\"VDecorates04\",\"conKey\":\"VCDecorates04\",\"title\":\"装饰-04\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates04.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1dc1f5\",\"#1dc1f5\"],\"reverse\":false}},{\"id\":\"48vgwd3xywc000\",\"isGroup\":false,\"attr\":{\"x\":2,\"y\":8,\"w\":450,\"h\":75,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates04\",\"chartConfig\":{\"key\":\"Decorates04\",\"chartKey\":\"VDecorates04\",\"conKey\":\"VCDecorates04\",\"title\":\"装饰-04\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates04.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1dc1f5\",\"#1dc1f5\"],\"reverse\":true}},{\"id\":\"34gsoca72ak000\",\"isGroup\":false,\"attr\":{\"x\":450,\"y\":55,\"w\":466,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates05\",\"chartConfig\":{\"key\":\"Decorates05\",\"chartKey\":\"VDecorates05\",\"conKey\":\"VCDecorates05\",\"title\":\"装饰-05\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates05.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00c2ff\",\"#00c2ff4d\"],\"dur\":3}},{\"id\":\"5emz0hdi03k000\",\"isGroup\":false,\"attr\":{\"x\":1,\"y\":1,\"w\":1365,\"h\":45,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1089FF42\",\"#1089FF00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"afw1xcxn3ug00\",\"isGroup\":false,\"attr\":{\"x\":456,\"y\":4,\"w\":454,\"h\":64,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"公司质量数据盘点大屏\",\"fontSize\":28,\"fontColor\":\"#b2d5e5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"58c9hdcwi5s000\",\"isGroup\":false,\"attr\":{\"x\":660,\"y\":348,\"w\":332,\"h\":180,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"质量数据-Bug密度\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Charts\",\"chartFrame\":\"common\",\"image\":\"water_WaterPolo.png\",\"dataset\":\"0.04\",\"sourceID\":\"10209\",\"fields\":null,\"filters\":[]},\"option\":{\"dataset\":\"0.04\",\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"90%\",\"data\":[0.04],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10209\",\"title\":\"质量数据-Bug密度\",\"type\":\"waterpolo\"},{\"id\":\"172yoxa90vb400\",\"isGroup\":false,\"attr\":{\"x\":972,\"y\":348,\"w\":332,\"h\":180,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"质量数据-Bug修复率\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Charts\",\"chartFrame\":\"common\",\"image\":\"water_WaterPolo.png\",\"dataset\":\"0.10\",\"sourceID\":\"10210\",\"fields\":null,\"filters\":[]},\"option\":{\"dataset\":\"0.10\",\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"90%\",\"data\":[0.1],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10210\",\"title\":\"质量数据-Bug修复率\",\"type\":\"waterpolo\"},{\"id\":\"3w4daidjqdi000\",\"isGroup\":false,\"attr\":{\"x\":58,\"y\":348,\"w\":332,\"h\":180,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"质量数据-研发完成需求用例覆盖率\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Charts\",\"chartFrame\":\"common\",\"image\":\"water_WaterPolo.png\",\"dataset\":\"0.309625\",\"sourceID\":\"10207\",\"fields\":null,\"filters\":[]},\"option\":{\"dataset\":\"0.309625\",\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"90%\",\"data\":[0.31],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10207\",\"title\":\"质量数据-研发完成需求用例覆盖率\",\"type\":\"waterpolo\"},{\"id\":\"4bn4v0qaocw000\",\"isGroup\":false,\"attr\":{\"x\":352,\"y\":348,\"w\":332,\"h\":180,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"质量数据-研发完成需求用例密度\",\"category\":\"Mores\",\"categoryName\":\"更多\",\"package\":\"Charts\",\"chartFrame\":\"common\",\"image\":\"water_WaterPolo.png\",\"dataset\":\"0.7013\",\"sourceID\":\"10208\",\"fields\":null,\"filters\":[]},\"option\":{\"dataset\":\"0.7013\",\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"90%\",\"data\":[0.7],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10208\",\"title\":\"质量数据-研发完成需求用例密度\",\"type\":\"waterpolo\"},{\"id\":\"27f0de7xfqfw00\",\"isGroup\":false,\"attr\":{\"x\":510,\"y\":1646,\"w\":833,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"kp909j6ffg000\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":1645,\"w\":477,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3vsciuh0hrs000\",\"isGroup\":false,\"attr\":{\"x\":\"154\",\"y\":\"1648\",\"w\":200,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug类型分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2mqp7xv959400\",\"isGroup\":false,\"attr\":{\"x\":\"354\",\"y\":\"1648\",\"w\":\"120\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4n4yq7lcev4000\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":\"1648\",\"w\":\"120\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"1d271h0v8mqo00\",\"isGroup\":false,\"attr\":{\"x\":\"782\",\"y\":\"1648\",\"w\":280,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug严重程度堆积图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5mrgc6eqt90000\",\"isGroup\":false,\"attr\":{\"x\":1057,\"y\":\"1648\",\"w\":260,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"254g36lcv2io00\",\"isGroup\":false,\"attr\":{\"x\":539,\"y\":\"1648\",\"w\":254,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5ip3xc3pes0000\",\"isGroup\":false,\"attr\":{\"x\":511,\"y\":2156,\"w\":835,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"p5v6om0y7gg00\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":2156,\"w\":472,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"ktbwgyibuz400\",\"isGroup\":false,\"attr\":{\"x\":\"136\",\"y\":\"2160\",\"w\":240,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug解决方案分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"517812ddp18000\",\"isGroup\":false,\"attr\":{\"x\":\"374\",\"y\":\"2160\",\"w\":\"102\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"2ubeu8arz66000\",\"isGroup\":false,\"attr\":{\"x\":\"40\",\"y\":\"2160\",\"w\":\"102\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"dwud1obtioo00\",\"isGroup\":false,\"attr\":{\"x\":\"778\",\"y\":\"2160\",\"w\":280,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug密度年度趋势图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2zef39rtski000\",\"isGroup\":false,\"attr\":{\"x\":1048,\"y\":\"2160\",\"w\":266,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"44fwuqancr0000\",\"isGroup\":false,\"attr\":{\"x\":533,\"y\":\"2160\",\"w\":260,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"2uws0ytah1s000\",\"isGroup\":false,\"attr\":{\"x\":512,\"y\":626,\"w\":834,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5nyrxc5w010000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":626,\"w\":475,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5jlquwudqjc000\",\"isGroup\":false,\"attr\":{\"x\":\"154\",\"y\":\"632\",\"w\":200,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug状态分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"gpiyfioye2800\",\"isGroup\":false,\"attr\":{\"x\":\"354\",\"y\":\"632\",\"w\":\"120\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"54c0xx57r24000\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":\"632\",\"w\":\"120\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"2sphsycadhc000\",\"isGroup\":false,\"attr\":{\"x\":\"664\",\"y\":\"632\",\"w\":512,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug总数、有效Bug数与修复Bug数近30天统计图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1k6hl6r7tygw00\",\"isGroup\":false,\"attr\":{\"x\":1188,\"y\":\"632\",\"w\":\"120\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4hnhyvnfq5g000\",\"isGroup\":false,\"attr\":{\"x\":536,\"y\":\"632\",\"w\":120,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"1jeaitz0lrr400\",\"isGroup\":false,\"attr\":{\"x\":512,\"y\":1136,\"w\":834,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"1hwn0jcj6uio00\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":1136,\"w\":475,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"pw93bwp425c00\",\"isGroup\":false,\"attr\":{\"x\":\"136\",\"y\":\"1140\",\"w\":240,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug严重程度分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4zzvvpybfdc000\",\"isGroup\":false,\"attr\":{\"x\":\"374\",\"y\":\"1140\",\"w\":\"102\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"2my1y33oe22000\",\"isGroup\":false,\"attr\":{\"x\":40,\"y\":\"1140\",\"w\":\"102\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"53axbaefjh8000\",\"isGroup\":false,\"attr\":{\"x\":\"784\",\"y\":\"1140\",\"w\":280,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"有效Bug率年度趋势图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3dn99i3ync4000\",\"isGroup\":false,\"attr\":{\"x\":1062,\"y\":\"1140\",\"w\":\"260\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4nwwxcg1bt4000\",\"isGroup\":false,\"attr\":{\"x\":533,\"y\":\"1140\",\"w\":260,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4ogg3298z1q000\",\"isGroup\":false,\"attr\":{\"x\":\"528\",\"y\":\"708\",\"w\":798,\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCommon\",\"chartConfig\":{\"key\":\"BarCommon\",\"chartKey\":\"VBarCommon\",\"conKey\":\"VCBarCommon\",\"title\":\"Bug总数、有效Bug与解决Bug数近30天统计柱形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_x.png\",\"sourceID\":\"10211\",\"fields\":{},\"filters\":[{\"field\":\"日期\",\"type\":\"date\",\"name\":\"日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":90,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"Bug总数、有效Bug与解决Bug数近30天统计柱形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":15,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":2}},{\"type\":\"bar\",\"barWidth\":15,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":2}},{\"type\":\"bar\",\"barWidth\":15,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":2}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10211\",\"title\":\"Bug总数、有效Bug与解决Bug数近30天统计柱形图\",\"type\":\"cluBarX\"},{\"id\":\"3g6xki3tayi000\",\"isGroup\":false,\"attr\":{\"x\":\"528\",\"y\":\"1216\",\"w\":\"798\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"有效Bug率年度趋势图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"line.png\",\"sourceID\":\"10212\",\"fields\":{},\"filters\":[{\"field\":\"年份\",\"type\":\"date\",\"name\":\"年份\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":90,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"有效Bug率年度趋势图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10212\",\"title\":\"有效Bug率年度趋势图\",\"type\":\"line\"},{\"id\":\"1lk7rgc6je5c00\",\"isGroup\":false,\"attr\":{\"x\":\"528\",\"y\":\"1720\",\"w\":\"798\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarStacked\",\"chartConfig\":{\"key\":\"BarStacked\",\"chartKey\":\"VBarStacked\",\"conKey\":\"VCBarStacked\",\"title\":\"Bug严重程度堆积柱状图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_stacked_x.png\",\"sourceID\":\"10214\",\"fields\":{},\"filters\":[{\"field\":\"年份\",\"type\":\"date\",\"name\":\"年份\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":90,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"Bug严重程度堆积柱状图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"series\":[{\"type\":\"bar\",\"stack\":\"total\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}},{\"type\":\"bar\",\"stack\":\"total\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}},{\"type\":\"bar\",\"stack\":\"total\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataset\":{}},\"sourceID\":\"10214\",\"title\":\"Bug严重程度堆积柱状图\",\"type\":\"stackedBar\"},{\"id\":\"25mmk8o5duo000\",\"isGroup\":false,\"attr\":{\"x\":\"528\",\"y\":\"2236\",\"w\":\"798\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"Bug密度年度趋势图\",\"category\":\"Lines\",\"categoryName\":\"折线图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"line.png\",\"sourceID\":\"10213\",\"fields\":{},\"filters\":[{\"field\":\"年份\",\"type\":\"select\",\"name\":\"年份\",\"options\":[{\"label\":\"0000\",\"value\":\"0000\"},{\"label\":\"2004\",\"value\":2004},{\"label\":\"2005\",\"value\":2005},{\"label\":\"2006\",\"value\":2006},{\"label\":\"2007\",\"value\":2007},{\"label\":\"2009\",\"value\":2009},{\"label\":\"2010\",\"value\":2010},{\"label\":\"2011\",\"value\":2011},{\"label\":\"2012\",\"value\":2012},{\"label\":\"2013\",\"value\":2013},{\"label\":\"2014\",\"value\":2014},{\"label\":\"2015\",\"value\":2015},{\"label\":\"2016\",\"value\":2016},{\"label\":\"2017\",\"value\":2017},{\"label\":\"2018\",\"value\":2018},{\"label\":\"2019\",\"value\":2019},{\"label\":\"2020\",\"value\":2020},{\"label\":\"2021\",\"value\":2021},{\"label\":\"2022\",\"value\":2022},{\"label\":\"2023\",\"value\":2023}]}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":90,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"Bug密度年度趋势图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10213\",\"title\":\"Bug密度年度趋势图\",\"type\":\"line\"},{\"id\":\"53verjpnwh8000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":3214,\"w\":653,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5rg2qtyfzno000\",\"isGroup\":false,\"attr\":{\"x\":693,\"y\":3216,\"w\":653,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"1j96xfpflgw000\",\"isGroup\":false,\"attr\":{\"x\":1152,\"y\":\"3230\",\"w\":\"160\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"d47gaf5trhk00\",\"isGroup\":false,\"attr\":{\"x\":734,\"y\":\"3230\",\"w\":\"160\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"50iv7knqqtk000\",\"isGroup\":false,\"attr\":{\"x\":\"920\",\"y\":\"3230\",\"w\":200,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"产品Bug数量统计\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4xtycre64bw000\",\"isGroup\":false,\"attr\":{\"x\":\"220\",\"y\":\"3230\",\"w\":240,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"产品用例数量统计\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2o3vh7bn0k6000\",\"isGroup\":false,\"attr\":{\"x\":465,\"y\":\"3230\",\"w\":160,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"gkc4fwuus2o0\",\"isGroup\":false,\"attr\":{\"x\":60,\"y\":\"3230\",\"w\":160,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"penzroyxpao00\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":2666,\"w\":1326,\"h\":528,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3kx9bltlzts000\",\"isGroup\":false,\"attr\":{\"x\":\"2800\",\"y\":\"26800\",\"w\":1023,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"1igpxgk2mv6o00\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":\"2680\",\"w\":242,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"产品缺陷数据汇总表\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3oqvmqrcqfg000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":2750,\"w\":1262,\"h\":413,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TableMergeCell\",\"chartConfig\":{\"key\":\"TableMergeCell\",\"chartKey\":\"VTableMergeCell\",\"conKey\":\"VCTableMergeCell\",\"title\":\"产品缺陷数据汇总表\",\"category\":\"Tables\",\"categoryName\":\"列表\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"table_scrollboard.png\",\"sourceID\":\"1002\",\"fields\":{},\"filters\":[],\"dataset\":[],\"tableInfo\":{}},\"option\":{\"header\":[],\"dataset\":[],\"index\":true,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":5,\"waitTime\":2,\"headerHeight\":35,\"carousel\":\"single\",\"headerBGC\":\"#4498EC85\",\"oddRowBGC\":\"#1089FF1A\",\"evenRowBGC\":\"#FFFFFF00\",\"rowspan\":{},\"colspan\":[]},\"sourceID\":\"1002\",\"title\":\"产品缺陷数据汇总表\",\"type\":\"table\"},{\"id\":\"23hxn88hrwm800\",\"isGroup\":false,\"attr\":{\"x\":56,\"y\":\"3300\",\"w\":574,\"h\":\"380\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"产品用例数量统计条形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_y.png\",\"sourceID\":\"10215\",\"fields\":{},\"filters\":[{\"field\":\"name\",\"type\":\"input\",\"name\":\"产品\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":70,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"产品用例数量统计条形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10215\",\"title\":\"产品用例数量统计条形图\",\"type\":\"cluBarY\"},{\"id\":\"zu2vtfsd1z400\",\"isGroup\":false,\"attr\":{\"x\":\"732\",\"y\":\"3300\",\"w\":\"574\",\"h\":\"380\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"产品Bug数量统计条形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_y.png\",\"sourceID\":\"10216\",\"fields\":{},\"filters\":[{\"field\":\"name\",\"type\":\"input\",\"name\":\"产品\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":70,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"产品Bug数量统计条形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10216\",\"title\":\"产品Bug数量统计条形图\",\"type\":\"cluBarY\"},{\"id\":\"38a8owutx4m000\",\"isGroup\":false,\"attr\":{\"x\":\"280\",\"y\":2680,\"w\":\"1030\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"p8d55xj3za800\",\"isGroup\":false,\"attr\":{\"x\":\"34\",\"y\":\"708\",\"w\":\"446\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"Bug状态分布图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10217\",\"fields\":{},\"filters\":[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"创建日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":false,\"top\":30,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"title\":{\"text\":\"Bug状态分布图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"formatter\":\"{b} {d}%\"},\"grid\":{\"top\":70},\"dataset\":{},\"series\":[{\"type\":\"pie\",\"radius\":\"70%\",\"center\":[\"50%\",\"60%\"],\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10217\",\"title\":\"Bug状态分布图\",\"type\":\"pie\"},{\"id\":\"11322hw5hcf40\",\"isGroup\":false,\"attr\":{\"x\":\"34\",\"y\":\"1216\",\"w\":\"446\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"Bug严重程度分布\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10219\",\"fields\":{},\"filters\":[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"创建日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":false,\"top\":30,\"textStyle\":{\"color\":\"#fff\"},\"left\":\"center\",\"type\":\"scroll\"},\"title\":{\"text\":\"Bug严重程度分布\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"formatter\":\"{b} {d}%\"},\"grid\":{\"top\":70},\"series\":[{\"type\":\"pie\",\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"radius\":\"70%\",\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataset\":{}},\"sourceID\":\"10219\",\"title\":\"Bug严重程度分布\",\"type\":\"pie\"},{\"id\":\"1bw4mu8kjfi800\",\"isGroup\":false,\"attr\":{\"x\":\"34\",\"y\":\"1720\",\"w\":\"446\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"Bug类型分布\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10218\",\"fields\":{},\"filters\":[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"创建日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":false,\"top\":30,\"textStyle\":{\"color\":\"#fff\"},\"left\":\"center\",\"type\":\"scroll\"},\"title\":{\"text\":\"Bug类型分布\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"formatter\":\"{b} {d}%\"},\"grid\":{\"top\":70},\"series\":[{\"type\":\"pie\",\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"radius\":\"70%\",\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataset\":{}},\"sourceID\":\"10218\",\"title\":\"Bug类型分布\",\"type\":\"pie\"},{\"id\":\"14ns3t0es7k000\",\"isGroup\":false,\"attr\":{\"x\":\"34\",\"y\":\"2236\",\"w\":\"446\",\"h\":\"392\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"Bug解决方案分布\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10220\",\"fields\":{},\"filters\":[{\"field\":\"resolvedDate\",\"type\":\"date\",\"name\":\"解决日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":false,\"top\":30,\"textStyle\":{\"color\":\"#fff\"},\"left\":\"center\",\"type\":\"scroll\"},\"title\":{\"text\":\"Bug解决方案分布\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\",\"formatter\":\"{b} {d}%\"},\"grid\":{\"top\":70},\"series\":[{\"type\":\"pie\",\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"radius\":\"70%\",\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataset\":{}},\"sourceID\":\"10220\",\"title\":\"Bug解决方案分布\",\"type\":\"pie\"}],\"requestGlobalConfig\":{\"requestDataPond\":[],\"requestOriginUrl\":\"\",\"requestInterval\":30,\"requestIntervalUnit\":\"second\",\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}}}', 'published', '1', 'admin', '2022-12-07 14:59:41', 'admin', '2022-12-07 14:59:41', '0');

REPLACE INTO `zt_chart` (`id`, `name`, `dimension`, `type`, `group`, `stage`, `desc`, `settings`, `filters`, `fields`, `langs`, `sql`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(10000,'年度完成项目-完成项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_project WHERE type=\'project\' AND status=\'closed\' AND deleted=\'0\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10001,'年度完成项目-按时完成项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) as \'year\' FROM (SELECT id, begin, end, IF(left(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd,closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'project\' AND status=\'closed\') t1 WHERE t1.realEnd<=end GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10002,'年度完成项目-延期完成项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(left(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd,closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'project\' AND status=\'closed\') t1 WHERE t1.realEnd>end GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10003,'年度完成项目-完成需求条目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_story WHERE deleted=\'0\' AND status=\'closed\' AND closedReason=\'done\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10004,'年度完成项目-完成需求规模数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT ROUND(SUM(estimate),2) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_story WHERE deleted=\'0\' AND status=\'closed\' AND closedReason=\'done\'  GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10005,'年度完成项目-完成发布数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`date`) AS \'year\' FROM zt_release WHERE deleted=\'0\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10006,'年度完成项目-解决bug数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT SUM(CASE WHEN resolution=\'fixed\' THEN 1 ELSE 0 END) AS number,YEAR(`resolvedDate`) AS \'year\' FROM zt_bug WHERE deleted=\'0\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10007,'年度完成项目-完成执行数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_project WHERE type=\'sprint\' AND status=\'closed\' AND deleted=\'0\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10008,'年度完成项目-按时完成执行数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(LEFT(realEnd,4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd,closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'sprint\' AND status=\'closed\') t1 WHERE t1.realEnd<=end GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10009,'年度完成项目-延期完成执行数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'sprint\' AND status=\'closed\') t1 WHERE t1.realEnd>end GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10010,'年度完成项目-完成任务条目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT COUNT(1) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_task WHERE deleted=\'0\' AND status=\'closed\' AND closedReason=\'done\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10011,'年度完成项目-完成任务预计工时数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT ROUND(SUM(estimate),2) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_task WHERE deleted=\'0\' AND status=\'closed\' AND closedReason=\'done\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10012,'年度完成项目-完成任务消耗工时数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT ROUND(SUM(consumed),2) AS number,YEAR(`closedDate`) AS \'year\' FROM zt_task WHERE deleted=\'0\' AND status=\'closed\' AND closedReason=\'done\' GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10013,'年度完成项目-投入的总人天',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','[]','','','SELECT SUM(t2.people*DATEDIFF(t1.realEnd,t1.realBegan)) AS number,YEAR(`closedDate`) AS \'year\' FROM (SELECT id, realBegan, IF(LEFT(realEnd, 4) = \'0000\', closedDate, realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' AND status=\'closed\' AND type=\'project\' AND realBegan != \'0000-00-00\') t1 LEFT JOIN (SELECT root, COUNT(id) people FROM zt_team WHERE type=\'project\' GROUP BY `root`) t2 ON t1.id=t2.root GROUP BY `year`','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10014,'年度完成项目-项目按期完成率',2,'piecircle',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT t1.id,IF(t1.realEnd<=t1.end,\'done\',\'undone\') AS \'status\', YEAR(`closedDate`) AS \'year\' FROM(SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'project\' AND status=\'closed\') t1','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10015,'年度完成项目-执行按期完成率',2,'piecircle',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT IF(t1.realEnd<=t1.end,\'done\',\'undone\') AS \'status\', YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(LEFT(realEnd,4)=\'0000\',LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' and type=\'sprint\' and status=\'closed\') t1','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10016,'年度完成项目-项目延期率',2,'piecircle',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT IF(t1.realEnd>t1.end ,\'done\',\'undone\') AS \'status\', YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'project\' AND status=\'closed\') t1','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10017,'年度完成项目-执行延期率',2,'piecircle',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT IF(t1.realEnd>t1.end,\'done\',\'undone\') AS \'status\', YEAR(`closedDate`) AS \'year\' FROM(SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' and type=\'sprint\' and status=\'closed\') t1','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10018,'年度完成项目-完成项目工期偏差条形图',2,'pie',0,'published','','[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"daterate\",\"name\":\"daterate\",\"valOrAgg\":\"sum\"}]}]','[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"},\"daterate\":{\"name\":\"daterate\",\"object\":\"project\",\"field\":\"daterate\",\"type\":\"number\"}}','{\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"daterate\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\\u7387\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}','select\nt1.name,\nt1.closedDate,\nround(t1.realduration-t1.planduration)/t1.planduration as daterate\nfrom(\nselect\nname,\nid,\nclosedDate,\nbegin,\nend,\ndatediff(`end`,`begin`) planduration,\nrealBegan,\nrealEnd,\nifnull(if(left(realEnd,4) != \'0000\',datediff(`realEnd`,`realBegan`),datediff(`closedDate`,`realBegan`)),0) realduration\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'project\'\n) t1','1','','admin','2023-04-06 12:18:07','admin','2023-04-06 12:18:07','0'),
(10019,'年度完成项目-单位工时交付需求规模数对比图',2,'pie',0,'published','','[{\"type\":\"cluBarX\",\"xaxis\":[{\"field\":\"project\",\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"name\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"valOrAgg\":\"sum\"}]}]','[{\"field\":\"project\",\"type\":\"input\",\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"default\":\"\"}]','{\"project\":{\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"project\",\"type\":\"string\"},\"\\u6545\\u4e8b\\u70b9\":{\"name\":\"\\u6545\\u4e8b\\u70b9\",\"object\":\"project\",\"field\":\"\\u6545\\u4e8b\\u70b9\",\"type\":\"number\"},\"\\u5de5\\u65f6\":{\"name\":\"\\u5de5\\u65f6\",\"object\":\"project\",\"field\":\"\\u5de5\\u65f6\",\"type\":\"number\"},\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\":{\"name\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"object\":\"project\",\"field\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"type\":\"number\"}}','','select tt.*,\ntt.`故事点` / tt.`工时` as \'单位时间交付需求规模数\'\nfrom (\nselect\nt1.name as project, \n(\n	select round(sum(t3.estimate), 1) from zt_projectstory t2\n	left join zt_story t3 on t3.id= t2.story and t3.status=\'closed\' and t3.closedReason = \'done\'\n	where t2.project = t1.id\n) as \'故事点\',\n(\n	select round(sum(t5.consumed), 1) from zt_project t4\n	left join zt_task t5 on t5.execution = t4.id and t5.deleted = \'0\' and t5.parent in (0, -1)\n  where t4.project = t1.id and t4.type = \'sprint\'\n) as \'工时\'\nfrom zt_project t1\nwhere t1.status = \'closed\'\nand t1.deleted = \'0\'\nand t1.type = \'project\'\ngroup by t1.id) tt','1','','admin','2023-04-06 13:41:05','admin','2023-04-06 13:41:05','0'),
(10020,'年度完成项目-项目完成分布图',2,'pie',0,'published','','[{\"type\":\"pie\",\"group\":[{\"field\":\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\",\"name\":\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]','[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\":{\"name\":\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\",\"object\":\"project\",\"field\":\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}','','select\nt1.id,\n(case when t1.realEnd<t1.end then \'提前完成项目\' when t1.realEnd=t1.end then \'正常完成项目\' else \'延期完成项目\' end) \'项目完成情况\',\nt1.closedDate\nfrom(\nselect\nid,\nclosedDate,\nend,\nif(left(realEnd, 4) = \'0000\', closedDate, realEnd) as realEnd\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'project\') t1','1','','admin','2023-04-06 12:22:34','admin','2023-04-06 12:22:34','0'),
(10021,'年度完成项目-执行完成分布图',2,'pie',0,'published','','[{\"type\":\"pie\",\"group\":[{\"field\":\"\\u6267\\u884c\\u5b8c\\u6210\\u60c5\\u51b5\",\"name\":\"\\u6267\\u884c\\u5b8c\\u6210\\u60c5\\u51b5\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]','[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"\\u6267\\u884c\\u5b8c\\u6210\\u60c5\\u51b5\":{\"name\":\"\\u6267\\u884c\\u5b8c\\u6210\\u60c5\\u51b5\",\"object\":\"project\",\"field\":\"\\u6267\\u884c\\u5b8c\\u6210\\u60c5\\u51b5\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}','','select\nt1.id,\n(case when t1.realEnd<t1.end then \'提前完成执行\' when t1.realEnd=t1.end then \'正常完成执行\' else \'延期完成执行\' end) \'执行完成情况\',\nt1.closedDate\nfrom(\nselect\nid,\nclosedDate,\nend,\nif(left(realEnd, 4) = \'0000\', closedDate, realEnd) as realEnd\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'sprint\') t1','1','','admin','2023-04-06 12:19:58','admin','2023-04-06 12:22:34','0'),
(10022,'年度完成项目-完成项目工时偏差条形图',2,'cluBarY',0,'published','','[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"rate\",\"name\":\"rate\",\"valOrAgg\":\"sum\"}]}]','[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"name\":{\"name\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"object\":\"task\",\"field\":\"name\",\"type\":\"string\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"task\",\"field\":\"id\",\"type\":\"number\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"object\":\"task\",\"field\":\"closedDate\",\"type\":\"date\"},\"estimate\":{\"name\":\"\\u6700\\u521d\\u9884\\u8ba1\",\"object\":\"task\",\"field\":\"estimate\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"},\"left\":{\"name\":\"\\u9884\\u8ba1\\u5269\\u4f59\",\"object\":\"task\",\"field\":\"left\",\"type\":\"string\"},\"deviation\":{\"name\":\"deviation\",\"object\":\"task\",\"field\":\"deviation\",\"type\":\"number\"},\"rate\":{\"name\":\"rate\",\"object\":\"task\",\"field\":\"rate\",\"type\":\"number\"}}','{\"name\":{\"zh-cn\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"estimate\":{\"zh-cn\":\"\\u6700\\u521d\\u9884\\u8ba1\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"left\":{\"zh-cn\":\"\\u9884\\u8ba1\\u5269\\u4f59\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"deviation\":{\"zh-cn\":\"deviation\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"rate\":{\"zh-cn\":\"\\u5de5\\u65f6\\u504f\\u5dee\\u7387\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}','select\n*,\nround(tt.deviation/tt.estimate,3) rate\nfrom(\nselect\nt1.name,\nt1.id,\nt1.closedDate,\nt2.estimate estimate,\nt2.consumed consumed,\nt2.`left`,\nt2.consumed-t2.estimate deviation\nfrom\nzt_project t1\nleft join\n(select\nproject,\nsum(estimate) estimate,\nsum(consumed) consumed,\nsum(`left`) `left`\nfrom\nzt_task\ngroup by project) t2\non t1.id=t2.project\nwhere t1.deleted=\'0\'\nand t1.status=\'closed\'\nand t1.type=\'project\') tt','1','','admin','2023-04-06 12:16:04','admin','2023-04-06 12:16:04','0'),
(10101,'年度进行中项目-进行中的项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT id FROM zt_project WHERE deleted = \'0\' AND status = \'doing\' AND type = \'project\'','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10102,'年度进行中项目-进行中的迭代数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT id,type FROM zt_project WHERE deleted = \'0\' AND status = \'doing\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10103,'年度进行中项目-进展顺利项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT t1.id, t1.name, IFNULL(prograss, 0) AS prograss, ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2)  AS planPrograss,LEFT(t1.`end`, 4) AS endYear\nFROM zt_project AS t1\nLEFT JOIN (\n    SELECT t22.project,\n    ROUND(IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))), 0) * 100, 2) AS prograss\n    FROM zt_project AS t21\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'kanban\')\n    AND t22.deleted = \'0\' AND t22.parent < 1\n    GROUP BY t22.project\n    UNION\n    SELECT  t.project, ROUND(SUM(t.prograss * (t.percent / 100)), 2) as prograss\n    FROM (\n        SELECT t21.id,t21.percent, t22.project,\n        IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, ROUND(SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))) * 1000 / 1000 * 100, 2), 0)  AS prograss\n        FROM zt_project AS t21\n        LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n        WHERE t21.deleted = \'0\' AND t21.type = \'stage\'\n        AND t22.deleted = \'0\' AND t22.parent < 1\n        AND t22.id IS NOT NULL\n        GROUP BY t21.id, t21.percent, t22.project\n    ) t\n    GROUP BY t.project\n) AS t2 ON t1.id = t2.project \nWHERE t1.deleted = \'0\'\nAND t1.status = \'doing\' \nAND t1.type = \'project\'\nAND ((IFNULL(prograss, 0) >= (DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100) AND LEFT(t1.`end`, 4) != \'2059\' AND DATEDIFF(`end`, NOW()) >= 0) OR LEFT(t1.`end`, 4) = \'2059\' )','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10104,'年度进行中项目-进展顺利迭代数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT id, prograss, planPrograss, `end`\nFROM (\nSELECT t1.id,ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2) AS planPrograss,t1.`end`,\nROUND(IF(SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0)) > 0, SUM(t2.consumed) / (SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0))), 0) * 100, 2) AS prograss\nFROM zt_project AS t1\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\nAND t2.deleted = \'0\' AND t2.parent < 1\nGROUP BY t1.id\n) AS t\nWHERE prograss >= planPrograss AND DATEDIFF(`end`, NOW()) >= 0','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10105,'年度进行中项目-进度滞后项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT t1.id, t1.name, IFNULL(prograss, 0) AS prograss, ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2)  AS planPrograss\n, LEFT(t1.`end`, 4) AS endYear\nFROM zt_project AS t1\nLEFT JOIN (\n    SELECT t22.project,\n    ROUND(IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))), 0) * 100, 2) AS prograss\n    FROM zt_project AS t21\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'kanban\')\n    AND t22.deleted = \'0\' AND t22.parent < 1\n    GROUP BY t22.project\n    UNION\n    SELECT  t.project, ROUND(SUM(t.prograss * (t.percent / 100)), 2) as prograss\n    FROM (\n        SELECT t21.id,t21.percent, t22.project,\n        IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, ROUND(SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))) * 1000 / 1000 * 100, 2), 0)  AS prograss\n        FROM zt_project AS t21\n        LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n        WHERE t21.deleted = \'0\' AND t21.type = \'stage\'\n        AND t22.deleted = \'0\' AND t22.parent < 1\n        AND t22.id IS NOT NULL\n        GROUP BY t21.id, t21.percent, t22.project\n    ) t\n    GROUP BY t.project\n) AS t2 ON t1.id = t2.project \nWHERE t1.deleted = \'0\'\nAND t1.status = \'doing\' \nAND t1.type = \'project\'\nAND LEFT(t1.`end`, 4) != \'2059\'\nAND IFNULL(prograss, 0) < (DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100)  AND DATEDIFF(`end`, NOW()) >= 0','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10106,'年度进行中项目-进度滞后迭代数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT id, prograss, planPrograss\nFROM (\nSELECT t1.id,ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2) AS planPrograss,\nROUND(IF(SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0)) > 0, SUM(t2.consumed) / (SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0))), 0) * 100, 2) AS prograss\nFROM zt_project AS t1\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\' AND DATEDIFF(t1.`end`, NOW()) >= 0\nAND t2.deleted = \'0\' AND t2.parent < 1\nGROUP BY t1.id\n) AS t\nWHERE prograss < planPrograss','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10107,'年度进行中项目-已延期项目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT id, name FROM zt_project WHERE deleted = \'0\' AND status = \'doing\' AND type = \'project\' AND LEFT(`end`, 4) != \'2059\' AND DATEDIFF(`end`, NOW()) < 0','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10108,'年度进行中项目-已延期迭代数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT id, name FROM zt_project WHERE deleted = \'0\' AND status = \'doing\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND DATEDIFF(`end`, NOW()) < 0 AND multiple = \'1\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10109,'年度进行中项目-未完成需求条目数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT DISTINCT t3.id, t3.estimate\nFROM zt_project AS t1\nLEFT JOIN zt_projectstory AS t2 ON t1.id = t2.project\nLEFT JOIN zt_story AS t3 ON t2.story = t3.id\nWHERE t1.deleted = \'0\' AND t1.status = \'doing\' AND t1.type = \'project\'\nAND t3.deleted = \'0\' AND t3.stage NOT IN (\'verified\', \'released\', \'closed\')','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10110,'年度进行中项目-未完成任务数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT DISTINCT t2.id\nFROM zt_project AS t1\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\nWHERE t1.deleted = \'0\' AND t1.status = \'doing\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\')\nAND t2.deleted = \'0\' AND t2.status IN (\'wait\', \'doing\', \'pause\') AND t2.id IS NOT NULL','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10111,'年度进行中项目-未完成需求规模数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"estimate\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT DISTINCT t3.id, t3.estimate\nFROM zt_project AS t1\nLEFT JOIN zt_projectstory AS t2 ON t1.id = t2.project\nLEFT JOIN zt_story AS t3 ON t2.story = t3.id\nWHERE t1.deleted = \'0\' AND t1.status = \'doing\' AND t1.type = \'project\'\nAND t3.deleted = \'0\' AND t3.stage NOT IN (\'verified\', \'released\', \'closed\')','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10112,'年度进行中项目-剩余工时数',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"left\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT t1.id, t1.name, `left`\nFROM zt_project AS t1\nLEFT JOIN (\n    SELECT t22.project,\n    ROUND(SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)), 2) AS `left`\n    FROM zt_project AS t21\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'stage\', \'kanban\')\n    AND t22.deleted = \'0\' AND t22.parent < 1\n    GROUP BY t22.project\n) AS t2 ON t1.id = t2.project \nWHERE t1.deleted = \'0\'\nAND t1.status = \'doing\' \nAND t1.type = \'project\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10113,'年度进行中项目-投入总人次',2,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT t1.id,t1.type,t1.account\nFROM zt_team AS t1\nLEFT JOIN zt_user AS t2 on t1.account = t2.account\nWHERE t1.type = \'project\' AND t2.deleted = \'0\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10114,'年度进行中项目-项目进度分布图',2,'pie',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"进度\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"项目数\",\"valOrAgg\":\"count\"}]}','[]','','','\r\nSELECT t1.id, t1.name, \r\nIF(\r\n    DATEDIFF(t1.`end`, NOW()) < 0, \r\n    \'延期\', \r\n    (IF(\r\n        (IFNULL(prograss, 0) >= (DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100) AND LEFT(t1.`end`, 4) != \'2059\') \r\n        OR LEFT(t1.`end`, 4) = \'2059\' ,\r\n        \'顺利\',\r\n        \'滞后\'\r\n    ))) AS \'status\',\r\nIFNULL(prograss, 0) AS prograss, ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2)  AS planPrograss,LEFT(t1.`end`, 4) AS endYear\r\nFROM zt_project AS t1\r\nLEFT JOIN (\r\n    SELECT t22.project,\r\n    ROUND(IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))), 0) * 100, 2) AS prograss\r\n    FROM zt_project AS t21\r\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\r\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'kanban\')\r\n    AND t22.deleted = \'0\' AND t22.parent < 1\r\n    GROUP BY t22.project\r\n    UNION\r\n    SELECT  t.project, ROUND(SUM(t.prograss * (t.percent / 100)), 2) as prograss\r\n    FROM (\r\n        SELECT t21.id,t21.percent, t22.project,\r\n        IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, ROUND(SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))) * 1000 / 1000 * 100, 2), 0)  AS prograss\r\n        FROM zt_project AS t21\r\n        LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\r\n        WHERE t21.deleted = \'0\' AND t21.type = \'stage\'\r\n        AND t22.deleted = \'0\' AND t22.parent < 1\r\n        AND t22.id IS NOT NULL\r\n        GROUP BY t21.id, t21.percent, t22.project\r\n    ) t\r\n    GROUP BY t.project\r\n) AS t2 ON t1.id = t2.project \r\nWHERE t1.deleted = \'0\'\r\nAND t1.status = \'doing\' \r\nAND t1.type = \'project\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10115,'年度进行中项目-迭代进度分布图',2,'pie',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"进度\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"迭代数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT id, name,IF(\r\n    DATEDIFF(`end`, NOW()) < 0,\r\n    \'延期\',\r\n    (IF(\r\n        prograss >= planPrograss,\r\n        \'顺利\',\r\n        \'滞后\'\r\n    ))\r\n) AS status,\r\nprograss, planPrograss, `end`\r\nFROM (\r\nSELECT t1.id,t1.name,ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2) AS planPrograss,t1.`end`,\r\nROUND(IF(SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0)) > 0, SUM(t2.consumed) / (SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0))), 0) * 100, 2) AS prograss\r\nFROM zt_project AS t1\r\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\r\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\r\nAND ((t2.deleted = \'0\' AND t2.parent < 1) OR t2.id IS NULL)\r\nGROUP BY t1.id\r\n) AS t','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10116,'年度进行中项目-项目进度透视表',2,'table',0,'published','','{\"group\":[],\"column\":[{\"field\":\"program\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"begin\",\"valOrAgg\":\"value\",\"name\":\"计划开始日期\"},{\"field\":\"end\",\"valOrAgg\":\"value\",\"name\":\"计划完成日期\"},{\"field\":\"planDuration\",\"valOrAgg\":\"value\",\"name\":\"计划工期\"},{\"field\":\"realBegan\",\"valOrAgg\":\"value\",\"name\":\"实际开始日期\"},{\"field\":\"realDuration\",\"valOrAgg\":\"value\",\"name\":\"剩余工期天数\"},{\"field\":\"prograss\",\"valOrAgg\":\"value\",\"name\":\"工期进度\"},{\"field\":\"status\",\"valOrAgg\":\"value\",\"name\":\"进度状态\"}],\"filter\":[]}','[]','','','SELECT t1.id, t1.name, IFNULL(t3.name, \'/\') AS program,t1.`begin`, IF(YEAR(t1.`end`) = \'2059\', \'长期\', t1.`end`) AS `end`, IF(YEAR(t1.`end`) = \'2059\', \'长期\', DATEDIFF(t1.`end`, t1.`begin`) + 1) AS planDuration,\r\nIF(LEFT(t1.realBegan, 4) = \'0000\', \'/\', t1.realBegan) AS realBegan, IF(YEAR(t1.`end`) = \'2059\', \'长期\', IF(DATEDIFF(t1.`end`, NOW()) >= 0, DATEDIFF(t1.`end`, NOW()) + 1, 0)) AS realDuration,\r\nIF(\r\n    DATEDIFF(t1.`end`, NOW()) < 0, \r\n    \'延期\', \r\n    (IF(\r\n        (IFNULL(prograss, 0) >= (DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100) AND LEFT(t1.`end`, 4) != \'2059\') \r\n        OR LEFT(t1.`end`, 4) = \'2059\' ,\r\n        \'顺利\',\r\n        \'滞后\'\r\n    ))) AS \'status\',\r\nCONCAT(IFNULL(prograss, 0), \'%\') AS prograss\r\nFROM zt_project AS t1\r\nLEFT JOIN (\r\n    SELECT t22.project,\r\n    ROUND(IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))), 0) * 100, 2) AS prograss\r\n    FROM zt_project AS t21\r\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\r\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'kanban\')\r\n    AND t22.deleted = \'0\' AND t22.parent < 1\r\n    GROUP BY t22.project\r\n    UNION\r\n    SELECT  t.project, ROUND(SUM(t.prograss * (t.percent / 100)), 2) as prograss\r\n    FROM (\r\n        SELECT t21.id,t21.percent, t22.project,\r\n        IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, ROUND(SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))) * 1000 / 1000 * 100, 2), 0)  AS prograss\r\n        FROM zt_project AS t21\r\n        LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\r\n        WHERE t21.deleted = \'0\' AND t21.type = \'stage\'\r\n        AND t22.deleted = \'0\' AND t22.parent < 1\r\n        AND t22.id IS NOT NULL\r\n        GROUP BY t21.id, t21.percent, t22.project\r\n    ) t\r\n    GROUP BY t.project\r\n) AS t2 ON t1.id = t2.project \r\nLEFT JOIN zt_project AS t3 ON SUBSTR(t1.path, 2, POSITION(\',\' IN SUBSTR(t1.path, 2)) -1) = t3.id AND t3.type = \'program\' AND t3.deleted = \'0\'\r\nWHERE t1.deleted = \'0\'\r\nAND t1.status = \'doing\' \r\nAND t1.type = \'project\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10117,'年度进行中项目-迭代进度透视表',2,'table',0,'published','','{\"group\":[],\"column\":[{\"field\":\"project\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"迭代\"},{\"field\":\"begin\",\"valOrAgg\":\"value\",\"name\":\"计划开始日期\"},{\"field\":\"end\",\"valOrAgg\":\"value\",\"name\":\"计划完成日期\"},{\"field\":\"planDuration\",\"valOrAgg\":\"value\",\"name\":\"计划工期\"},{\"field\":\"realBegan\",\"valOrAgg\":\"value\",\"name\":\"实际开始日期\"},{\"field\":\"realDuration\",\"valOrAgg\":\"value\",\"name\":\"剩余工期天数\"},{\"field\":\"prograss\",\"valOrAgg\":\"value\",\"name\":\"工期进度\"},{\"field\":\"status\",\"valOrAgg\":\"value\",\"name\":\"进度状态\"}],\"filter\":[]}','[]','','','SELECT id, name,project,`begin`, `end`, planDuration, IF(LEFT(realBegan, 4) = \'0000\', \'/\', realBegan) as realBegan, realDuration, CONCAT(prograss, \'%\') as prograss,\r\nIF(\r\n    DATEDIFF(`end`, NOW()) < 0,\r\n    \'延期\',\r\n    (IF(\r\n        prograss >= planPrograss,\r\n        \'顺利\',\r\n        \'滞后\'\r\n    ))\r\n) AS status\r\nFROM (\r\nSELECT t1.id,t1.name,t1.`begin`,t1.`end`,t1.`realBegan`,IFNULL(t3.name, \'/\') AS project,t3.id AS projectID,\r\nDATEDIFF(t1.`end`, t1.`begin`) + 1 AS planDuration, IF(DATEDIFF(t1.`end`, NOW()) >= 0, DATEDIFF(t1.`end`, NOW()) + 1, 0) AS realDuration,\r\nROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2) AS planPrograss,\r\nROUND(IF(SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0)) > 0, SUM(t2.consumed) / (SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0))), 0) * 100, 2) AS prograss\r\nFROM zt_project AS t1\r\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\r\nLEFT JOIN zt_project AS t3 on t1.project = t3.id AND t3.type = \'project\' AND t3.deleted = \'0\'\r\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\r\nAND t2.deleted = \'0\' AND t2.parent < 1\r\nGROUP BY t1.id\r\n) AS t\r\nORDER BY projectID ASC, id ASC','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10118,'年度进行中项目-项目剩余工作量透视表',2,'table',0,'published','','{\"group\":[],\"column\":[{\"field\":\"program\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},{\"field\":\"project\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"剩余需求数\"},{\"field\":\"estimate\",\"valOrAgg\":\"value\",\"name\":\"剩余需求规模数\"},{\"field\":\"execution\",\"valOrAgg\":\"value\",\"name\":\"剩余执行数\"},{\"field\":\"workhour\",\"valOrAgg\":\"value\",\"name\":\"剩余工时\"}],\"filter\":[]}','[]','','','SELECT\r\n  t1.id,\r\n  t1.name AS project,\r\n  IFNULL(t2.name, \'/\') AS program,\r\n  IFNULL(t3.story, 0) AS story,\r\n  IFNULL(t3.estimate, 0) AS estimate,\r\n  IFNULL(t4.execution, 0) AS execution,  \r\n  IFNULL(t5.workhour, 0) AS workhour\r\nFROM zt_project AS t1\r\nLEFT JOIN zt_project AS t2 ON FIND_IN_SET(t2.id, t1.path) AND t2.deleted = \'0\' AND t2.type = \'program\' AND t2.grade = 1\r\nLEFT JOIN (\r\n  SELECT t1.parent AS project, COUNT(1) AS story, ROUND(SUM(t1.estimate), 1) AS estimate\r\n  FROM (\r\n    SELECT DISTINCT t1.parent, t3.id, t3.estimate\r\n    FROM zt_project AS t1\r\n    LEFT JOIN zt_projectstory AS t2 ON t1.id = t2.project\r\n    LEFT JOIN zt_story AS t3 ON t2.story = t3.id AND t3.deleted = \'0\' AND t3.stage NOT IN (\'verified\', \'released\', \'closed\')\r\n    WHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t3.id IS NOT NULL\r\n  ) AS t1 GROUP BY project\r\n) AS t3 ON t1.id = t3.project\r\nLEFT JOIN (SELECT parent AS project, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status NOT IN (\'done\', \'closed\') GROUP BY project) AS t4 ON t1.id = t4.project\r\nLEFT JOIN (\r\n  SELECT t1.parent AS project, ROUND(SUM(t2.left), 1) AS workhour\r\n  FROM zt_project AS t1\r\n  LEFT JOIN zt_task AS t2 ON t1.id = t2.execution AND t2.deleted = \'0\' AND t2.parent < 1\r\n  WHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status NOT IN (\'done\', \'closed\') AND t2.id IS NOT NULL\r\n  GROUP BY project\r\n) AS t5 ON t1.id = t5.project\r\nWHERE t1.deleted = \'0\' AND t1.type = \'project\' AND t1.status = \'doing\'','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10119,'年度进行中项目-迭代剩余工作量透视表',2,'table',0,'published','','{\"group\":[],\"column\":[{\"field\":\"project\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"execution\",\"valOrAgg\":\"value\",\"name\":\"迭代\"},{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"剩余需求数\"},{\"field\":\"estimate\",\"valOrAgg\":\"value\",\"name\":\"剩余需求规模数\"},{\"field\":\"task\",\"valOrAgg\":\"value\",\"name\":\"剩余任务数\"},{\"field\":\"workhour\",\"valOrAgg\":\"value\",\"name\":\"剩余工时\"}],\"filter\":[]}','[]','','','SELECT\r\n  t1.id,\r\n  t1.name AS execution,\r\n  IFNULL(t2.name, \'/\') AS project,\r\n  IFNULL(t3.story, 0) AS story,\r\n  IFNULL(t3.estimate, 0) AS estimate,\r\n  IFNULL(t4.task, 0) AS task,  \r\n  IFNULL(t4.workhour, 0) AS workhour\r\nFROM zt_project AS t1\r\nLEFT JOIN zt_project AS t2 ON t1.project = t2.id AND t2.type = \'project\'\r\nLEFT JOIN (\r\n  SELECT t1.id AS execution, COUNT(1) AS story, ROUND(SUM(t3.estimate), 1) AS estimate\r\n  FROM zt_project AS t1\r\n  LEFT JOIN zt_projectstory AS t2 ON t1.id = t2.project\r\n  LEFT JOIN zt_story AS t3 ON t2.story = t3.id AND t3.deleted = \'0\' AND t3.stage NOT IN (\'verified\', \'released\', \'closed\')\r\n  WHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\r\n  GROUP BY execution\r\n) AS t3 ON t1.id = t3.execution\r\nLEFT JOIN (\r\n  SELECT t1.id AS execution, SUM(IF(t2.status IN (\'wait\', \'doing\'), 1, 0)) AS task, ROUND(SUM(IF(t2.status IN (\'wait\', \'doing\', \'pause\'), t2.left, 0)), 1) AS workhour\r\n  FROM zt_project AS t1\r\n  LEFT JOIN zt_task AS t2 ON t1.id = t2.execution AND t2.deleted = \'0\' AND t2.parent < 1\r\n  WHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\r\n  GROUP BY execution\r\n) AS t4 ON t1.id = t4.execution\r\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\r\nORDER BY t2.id ASC, t1.id ASC','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10201,'质量数据-研发完成需求数',3,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT COUNT(id) AS number FROM zt_story WHERE deleted=\'0\' AND (stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (status=\'closed\' AND closedReason=\'done\'))','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10202,'质量数据-研发完成需求规模数',3,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT ROUND(SUM(estimate),2) AS number FROM zt_story WHERE deleted=\'0\' AND (stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (status=\'closed\' AND closedReason=\'done\'))','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10203,'质量数据-研发完成需求用例数',3,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT SUM(t2.cases) AS number FROM (SELECT t1.story story, COUNT(t1.id) cases FROM (SELECT story,id FROM zt_case WHERE deleted=\'0\') t1 GROUP BY t1.story) t2 LEFT JOIN (SELECT id,stage,status,closedReason,deleted FROM zt_story) t3 ON t2.story=t3.id WHERE t3.deleted=\'0\' AND (t3.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (t3.status=\'closed\' AND t3.closedReason=\'done\'))','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10204,'质量数据-Bug总数',3,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT COUNT(id) AS number FROM zt_bug WHERE deleted=\'0\'','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10205,'质量数据-有效Bug数',3,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT SUM(CASE WHEN resolution IN (\'fixed\',\'postponed\') OR status=\'active\' THEN 1 ELSE 0 END) AS number FROM zt_bug WHERE deleted=\'0\'','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10206,'质量数据-修复Bug数',3,'card',0,'published','','{\"value\": {\"type\": \"agg\", \"field\": \"number\", \"agg\": \"sum\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}','[]','','','SELECT SUM(CASE WHEN resolution=\'fixed\' THEN 1 ELSE 0 END) AS number FROM zt_bug WHERE deleted=\'0\'','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10207,'质量数据-研发完成需求用例覆盖率',3,'waterpolo',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT ROUND(SUM(t3.havecasefixstory)/COUNT(t3.fixstory),2) AS status FROM (SELECT t2.storyid \'fixstory\', (CASE WHEN t2.cases=0 THEN 0 ELSE 1 END) \'havecasefixstory\' FROM (SELECT t1.storyid, SUM(t1.iscase) cases FROM (SELECT zt_story.id storyid, (CASE WHEN zt_case.id is null THEN 0 ELSE 1 END) iscase FROM zt_story LEFT JOIN zt_case ON zt_story.id=zt_case.story WHERE zt_story.deleted=\'0\' AND (zt_story.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (zt_story.status=\'closed\' AND zt_story.closedReason=\'done\'))) t1 GROUP BY t1.storyid ORDER BY cases DESC) t2) t3','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10208,'质量数据-研发完成需求用例密度',3,'waterpolo',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT ROUND(SUM(t2.cases)/SUM(t2.estimate),2) AS status FROM (SELECT t1.storyid, t1.estimate, SUM(t1.iscase) cases FROM (SELECT zt_story.id storyid, zt_story.estimate, (CASE WHEN zt_case.id is null THEN 0 ELSE 1 END) iscase FROM zt_story LEFT JOIN zt_case ON zt_story.id=zt_case.story WHERE zt_story.deleted=\'0\' AND (zt_story.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (zt_story.status=\'closed\' AND zt_story.closedReason=\'done\'))) t1 GROUP BY t1.storyid ORDER BY cases DESC) t2','1','','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41','0'),
(10209,'质量数据-Bug密度',3,'waterpolo',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT SUM(t3.bug)/SUM(t3.estimate) AS status FROM (SELECT t1.product product, IFNULL(t1.estimate,0) estimate, IFNULL(t2.bug,0) bug FROM (SELECT product, ROUND(SUM(estimate),2) estimate FROM zt_story WHERE deleted=\'0\' AND (stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (status=\'closed\' AND closedReason=\'done\')) GROUP BY product) t1 LEFT JOIN (SELECT product, COUNT(id) bug FROM zt_bug WHERE deleted=\'0\' GROUP BY product) t2 ON t1.product=t2.product) t3','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10210,'质量数据-Bug修复率',3,'waterpolo',0,'published','','{\"group\":[{\"field\":\"status\",\"name\":\"状态\"}],\"metric\":[{\"type\":\"agg\",\"field\":\"id\",\"agg\":\"count\",\"name\":\"需求数\",\"valOrAgg\":\"count\"}]}','[]','','','SELECT SUM(CASE WHEN resolution=\'fixed\' THEN 1 ELSE 0 END)/COUNT(id) AS status FROM zt_bug WHERE deleted = \'0\' ','1','','admin','2022-12-07 14:59:41','admin','2022-12-07 14:59:41','0'),
(10217,'质量数据-Bug状态分布图',3,'pie',0,'published','','[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"Bug\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]','[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"object\":\"bug\",\"field\":\"project\",\"type\":\"string\"},\"company\":{\"name\":\"company\",\"object\":\"bug\",\"field\":\"company\",\"type\":\"number\"},\"product\":{\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"object\":\"bug\",\"field\":\"product\",\"type\":\"string\"},\"injection\":{\"name\":\"\\u6ce8\\u5165\\u9636\\u6bb5\",\"object\":\"bug\",\"field\":\"injection\",\"type\":\"number\"},\"identify\":{\"name\":\"\\u73af\\u8282\",\"object\":\"bug\",\"field\":\"identify\",\"type\":\"number\"},\"branch\":{\"name\":\"\\u5e73\\u53f0\\/\\u5206\\u652f\",\"object\":\"bug\",\"field\":\"branch\",\"type\":\"number\"},\"module\":{\"name\":\"\\u6240\\u5c5e\\u6a21\\u5757\",\"object\":\"bug\",\"field\":\"module\",\"type\":\"number\"},\"execution\":{\"name\":\"\\u6240\\u5c5e\\u6267\\u884c\",\"object\":\"bug\",\"field\":\"execution\",\"type\":\"number\"},\"plan\":{\"name\":\"\\u6240\\u5c5e\\u8ba1\\u5212\",\"object\":\"bug\",\"field\":\"plan\",\"type\":\"number\"},\"story\":{\"name\":\"\\u76f8\\u5173\\u9700\\u6c42\",\"object\":\"bug\",\"field\":\"story\",\"type\":\"string\"},\"storyVersion\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u7248\\u672c\",\"object\":\"bug\",\"field\":\"storyVersion\",\"type\":\"number\"},\"task\":{\"name\":\"\\u76f8\\u5173\\u4efb\\u52a1\",\"object\":\"bug\",\"field\":\"task\",\"type\":\"number\"},\"toTask\":{\"name\":\"\\u8f6c\\u4efb\\u52a1\",\"object\":\"bug\",\"field\":\"toTask\",\"type\":\"number\"},\"toStory\":{\"name\":\"\\u8f6c\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"bug\",\"field\":\"toStory\",\"type\":\"number\"},\"title\":{\"name\":\"Bug\\u6807\\u9898\",\"object\":\"bug\",\"field\":\"title\",\"type\":\"string\"},\"keywords\":{\"name\":\"\\u5173\\u952e\\u8bcd\",\"object\":\"bug\",\"field\":\"keywords\",\"type\":\"string\"},\"severity\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"object\":\"bug\",\"field\":\"severity\",\"type\":\"option\"},\"pri\":{\"name\":\"\\u4f18\\u5148\\u7ea7\",\"object\":\"bug\",\"field\":\"pri\",\"type\":\"option\"},\"type\":{\"name\":\"Bug\\u7c7b\\u578b\",\"object\":\"bug\",\"field\":\"type\",\"type\":\"string\"},\"os\":{\"name\":\"\\u64cd\\u4f5c\\u7cfb\\u7edf\",\"object\":\"bug\",\"field\":\"os\",\"type\":\"string\"},\"browser\":{\"name\":\"\\u6d4f\\u89c8\\u5668\",\"object\":\"bug\",\"field\":\"browser\",\"type\":\"string\"},\"hardware\":{\"name\":\"\\u786c\\u4ef6\",\"object\":\"bug\",\"field\":\"hardware\",\"type\":\"string\"},\"found\":{\"name\":\"\\u53d1\\u73b0\\u8005\",\"object\":\"bug\",\"field\":\"found\",\"type\":\"string\"},\"steps\":{\"name\":\"\\u91cd\\u73b0\\u6b65\\u9aa4\",\"object\":\"bug\",\"field\":\"steps\",\"type\":\"text\"},\"status\":{\"name\":\"Bug\\u72b6\\u6001\",\"object\":\"bug\",\"field\":\"status\",\"type\":\"option\"},\"subStatus\":{\"name\":\"\\u5b50\\u72b6\\u6001\",\"object\":\"bug\",\"field\":\"subStatus\",\"type\":\"string\"},\"color\":{\"name\":\"\\u6807\\u9898\\u989c\\u8272\",\"object\":\"bug\",\"field\":\"color\",\"type\":\"string\"},\"confirmed\":{\"name\":\"\\u662f\\u5426\\u786e\\u8ba4\",\"object\":\"bug\",\"field\":\"confirmed\",\"type\":\"option\"},\"activatedCount\":{\"name\":\"\\u6fc0\\u6d3b\\u6b21\\u6570\",\"object\":\"bug\",\"field\":\"activatedCount\",\"type\":\"number\"},\"activatedDate\":{\"name\":\"\\u6fc0\\u6d3b\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"activatedDate\",\"type\":\"date\"},\"feedbackBy\":{\"name\":\"\\u53cd\\u9988\\u8005\",\"object\":\"bug\",\"field\":\"feedbackBy\",\"type\":\"string\"},\"notifyEmail\":{\"name\":\"\\u901a\\u77e5\\u90ae\\u7bb1\",\"object\":\"bug\",\"field\":\"notifyEmail\",\"type\":\"string\"},\"mailto\":{\"name\":\"\\u6284\\u9001\\u7ed9\",\"object\":\"bug\",\"field\":\"mailto\",\"type\":\"string\"},\"openedBy\":{\"name\":\"\\u7531\\u8c01\\u521b\\u5efa\",\"object\":\"bug\",\"field\":\"openedBy\",\"type\":\"user\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"},\"openedBuild\":{\"name\":\"\\u5f71\\u54cd\\u7248\\u672c\",\"object\":\"bug\",\"field\":\"openedBuild\",\"type\":\"string\"},\"assignedTo\":{\"name\":\"\\u6307\\u6d3e\\u7ed9\",\"object\":\"bug\",\"field\":\"assignedTo\",\"type\":\"string\"},\"assignedDate\":{\"name\":\"\\u6307\\u6d3e\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"assignedDate\",\"type\":\"date\"},\"deadline\":{\"name\":\"\\u622a\\u6b62\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"deadline\",\"type\":\"date\"},\"resolvedBy\":{\"name\":\"\\u89e3\\u51b3\\u8005\",\"object\":\"bug\",\"field\":\"resolvedBy\",\"type\":\"user\"},\"resolution\":{\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"object\":\"bug\",\"field\":\"resolution\",\"type\":\"option\"},\"resolvedBuild\":{\"name\":\"\\u89e3\\u51b3\\u7248\\u672c\",\"object\":\"bug\",\"field\":\"resolvedBuild\",\"type\":\"string\"},\"resolvedDate\":{\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"resolvedDate\",\"type\":\"date\"},\"closedBy\":{\"name\":\"\\u7531\\u8c01\\u5173\\u95ed\",\"object\":\"bug\",\"field\":\"closedBy\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"closedDate\",\"type\":\"date\"},\"duplicateBug\":{\"name\":\"\\u91cd\\u590dBug\",\"object\":\"bug\",\"field\":\"duplicateBug\",\"type\":\"number\"},\"linkBug\":{\"name\":\"\\u76f8\\u5173Bug\",\"object\":\"bug\",\"field\":\"linkBug\",\"type\":\"string\"},\"case\":{\"name\":\"\\u76f8\\u5173\\u7528\\u4f8b\",\"object\":\"bug\",\"field\":\"case\",\"type\":\"number\"},\"caseVersion\":{\"name\":\"\\u7528\\u4f8b\\u7248\\u672c\",\"object\":\"bug\",\"field\":\"caseVersion\",\"type\":\"number\"},\"feedback\":{\"name\":\"\\u53cd\\u9988\",\"object\":\"bug\",\"field\":\"feedback\",\"type\":\"number\"},\"result\":{\"name\":\"\\u7ed3\\u679c\",\"object\":\"bug\",\"field\":\"result\",\"type\":\"number\"},\"testtask\":{\"name\":\"\\u6d4b\\u8bd5\\u5355\",\"object\":\"bug\",\"field\":\"testtask\",\"type\":\"number\"},\"repo\":{\"name\":\"\\u6240\\u5c5e\\u7248\\u672c\\u5e93\",\"object\":\"bug\",\"field\":\"repo\",\"type\":\"number\"},\"mr\":{\"name\":\"\\u5408\\u5e76\\u8bf7\\u6c42\",\"object\":\"bug\",\"field\":\"mr\",\"type\":\"number\"},\"entry\":{\"name\":\"\\u4ee3\\u7801\\u8def\\u5f84\",\"object\":\"bug\",\"field\":\"entry\",\"type\":\"string\"},\"lines\":{\"name\":\"\\u4ee3\\u7801\\u884c\",\"object\":\"bug\",\"field\":\"lines\",\"type\":\"string\"},\"v1\":{\"name\":\"\\u7248\\u672c1\",\"object\":\"bug\",\"field\":\"v1\",\"type\":\"string\"},\"v2\":{\"name\":\"\\u7248\\u672c2\",\"object\":\"bug\",\"field\":\"v2\",\"type\":\"string\"},\"repoType\":{\"name\":\"\\u7248\\u672c\\u5e93\\u7c7b\\u578b\",\"object\":\"bug\",\"field\":\"repoType\",\"type\":\"string\"},\"issueKey\":{\"name\":\"Sonarqube\\u95ee\\u9898\\u952e\\u503c\",\"object\":\"bug\",\"field\":\"issueKey\",\"type\":\"string\"},\"lastEditedBy\":{\"name\":\"\\u6700\\u540e\\u4fee\\u6539\\u8005\",\"object\":\"bug\",\"field\":\"lastEditedBy\",\"type\":\"string\"},\"lastEditedDate\":{\"name\":\"\\u4fee\\u6539\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"lastEditedDate\",\"type\":\"date\"},\"deleted\":{\"name\":\"\\u5df2\\u5220\\u9664\",\"object\":\"bug\",\"field\":\"deleted\",\"type\":\"string\"}}','','select * from zt_bug\nwhere deleted=\'0\'','1','','admin','2023-04-06 12:25:00','admin','2023-04-06 12:25:00','0'),
(10218,'质量数据-Bug类型分布',3,'pie',0,'published','','[{\"type\":\"pie\",\"group\":[{\"field\":\"type\",\"name\":\"Bug\\u7c7b\\u578b\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]','[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"type\":{\"name\":\"Bug\\u7c7b\\u578b\",\"object\":\"bug\",\"field\":\"type\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}','','select\nid,type,openedDate\nfrom\nzt_bug\nwhere deleted=\'0\'','1','','admin','2023-04-18 13:34:46','admin','2023-04-18 13:34:46','0'),
(10219,'质量数据-Bug严重程度分布',3,'pie',0,'published','','[{\"type\":\"pie\",\"group\":[{\"field\":\"severity\",\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]','[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"severity\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"object\":\"bug\",\"field\":\"severity\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}','','select\nid,severity,openedDate\nfrom\nzt_bug\nwhere deleted=\'0\'','1','','admin','2023-04-18 13:36:37','admin','2023-04-18 13:36:37','0'),
(10220,'质量数据-Bug解决方案分布',3,'pie',0,'published','','[{\"type\":\"pie\",\"group\":[{\"field\":\"resolution\",\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]','[{\"field\":\"resolvedDate\",\"type\":\"date\",\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]','{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"resolution\":{\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"object\":\"bug\",\"field\":\"resolution\",\"type\":\"option\"},\"resolvedDate\":{\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"resolvedDate\",\"type\":\"date\"}}','','select id,resolution,resolvedDate from zt_bug\nwhere deleted=\'0\' and resolution!=\' \'','1','','admin','2023-04-18 13:37:24','','2023-04-18 13:37:24','0');

REPLACE INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `dataset`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(10211, '质量数据-Bug总数、有效Bug与解决Bug数近30天统计柱形图', 3, 'cluBarX', '91', '0', '', '[{\"type\":\"cluBarX\",\"xaxis\":[{\"field\":\"\\u65e5\\u671f\",\"name\":\"\\u65e5\\u671f\",\"group\":\"day\"}],\"yaxis\":[{\"field\":\"Bug\\u603b\\u6570\",\"name\":\"Bug\\u603b\\u6570\",\"valOrAgg\":\"count\"},{\"field\":\"\\u6709\\u6548Bug\",\"name\":\"\\u6709\\u6548Bug\",\"valOrAgg\":\"sum\"},{\"field\":\"\\u5df2\\u89e3\\u51b3Bug\",\"name\":\"\\u5df2\\u89e3\\u51b3Bug\",\"valOrAgg\":\"sum\"}]}]', '[]', 4, '{\"Bug\\u603b\\u6570\":{\"name\":\"Bug\\u603b\\u6570\",\"object\":\"bug\",\"field\":\"Bug\\u603b\\u6570\",\"type\":\"number\"},\"\\u6709\\u6548Bug\":{\"name\":\"\\u6709\\u6548Bug\",\"object\":\"bug\",\"field\":\"\\u6709\\u6548Bug\",\"type\":\"string\"},\"\\u5df2\\u89e3\\u51b3Bug\":{\"name\":\"\\u5df2\\u89e3\\u51b3Bug\",\"object\":\"bug\",\"field\":\"\\u5df2\\u89e3\\u51b3Bug\",\"type\":\"string\"},\"\\u65e5\\u671f\":{\"name\":\"\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"\\u65e5\\u671f\",\"type\":\"date\"}}', '', 'select \nid \'Bug总数\',\n(case when  resolution in (\'fixed\',\'postponed\') or status=\'active\' then 1 else 0 end) \'有效Bug\',\n(case when  resolution=\'fixed\' then 1 else 0 end) \'已解决Bug\',\nopenedDate \'日期\'\nfrom zt_bug\nwhere left(openedDate,10) > (select DATE_sub(MAX(NOW()), INTERVAL 30 DAY)) \nand left(openedDate,10) < NOW()\nand deleted=\'0\'', 'published', 1, '', 'admin', '2023-04-06 12:51:56', 'admin', '2023-04-06 12:51:56', 0),
(10212, '质量数据-有效Bug率年度趋势图', 3, 'line', '91', '0', '', '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"\\u5e74\\u4efd\",\"name\":\"\\u5e74\\u4efd\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"\\u6709\\u6548Bug\\u7387\",\"name\":\"\\u6709\\u6548Bug\\u7387\",\"valOrAgg\":\"sum\"}]}]', '[{\"field\":\"\\u5e74\\u4efd\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', 4, '{\"\\u5e74\\u4efd\":{\"name\":\"\\u5e74\\u4efd\",\"object\":\"bug\",\"field\":\"\\u5e74\\u4efd\",\"type\":\"string\"},\"\\u6240\\u6709Bug\\u6570\":{\"name\":\"\\u6240\\u6709Bug\\u6570\",\"object\":\"bug\",\"field\":\"\\u6240\\u6709Bug\\u6570\",\"type\":\"string\"},\"\\u6709\\u6548Bug\\u6570\":{\"name\":\"\\u6709\\u6548Bug\\u6570\",\"object\":\"bug\",\"field\":\"\\u6709\\u6548Bug\\u6570\",\"type\":\"number\"},\"\\u6709\\u6548Bug\\u7387\":{\"name\":\"\\u6709\\u6548Bug\\u7387\",\"object\":\"bug\",\"field\":\"\\u6709\\u6548Bug\\u7387\",\"type\":\"number\"}}', '', 'select\nyear \'年份\',\ncount(a.id) \'所有Bug数\',\nsum(a.effectivebug) \'有效Bug数\',\nsum(a.effectivebug)/count(a.id) \'有效Bug率\'\nfrom(\nselect \nleft(openedDate,4) year,\nid,\n(case when  resolution in (\'fixed\',\'postponed\') or status=\'active\' then 1 else 0 end) effectivebug,\n(case when  resolution=\'fixed\' then 1 else 0 end) fixedBug\nfrom zt_bug\nwhere zt_bug.deleted=\'0\'\n) a\ngroup by a.year\norder by  a.year', 'published', 1, '', 'admin', '2023-04-06 13:00:04', 'admin', '0000-00-00 00:00:00', 0),
(10213, '质量数据-Bug密度年度趋势图', 3, 'line', '91', '0', '', '[{\"type\":\"line\",\"yaxis\":[{\"field\":\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684bug\\u6570\",\"name\":\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684bug\\u6570\",\"valOrAgg\":\"sum\"}],\"xaxis\":[{\"field\":\"\\u5e74\\u4efd\",\"name\":\"\\u5e74\\u4efd\",\"group\":\"\"}]}]', '[{\"field\":\"\\u5e74\\u4efd\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', 4, '{\"\\u5e74\\u4efd\":{\"name\":\"\\u5e74\\u4efd\",\"object\":\"story\",\"field\":\"\\u5e74\\u4efd\",\"type\":\"string\"},\"\\u4ea7\\u751fBug\":{\"name\":\"\\u4ea7\\u751fBug\",\"object\":\"story\",\"field\":\"\\u4ea7\\u751fBug\",\"type\":\"string\"},\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\":{\"name\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"object\":\"story\",\"field\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"type\":\"number\"},\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684bug\\u6570\":{\"name\":\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684bug\\u6570\",\"object\":\"story\",\"field\":\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684bug\\u6570\",\"type\":\"number\"}}', '', 'select\nbug.year \'年份\',\ncreatbugs \'产生Bug\', \nexfixedstoryestimate \'完成需求数\',\nround(creatbugs/exfixedstoryestimate,2) \'单位完成需求规模产生的bug数\'\nfrom\n(select \nleft(openedDate,4) year,\ncount(id) creatbugs\nfrom zt_bug\nwhere zt_bug.deleted=\'0\'\ngroup by year\n) bug\nleft join\n(select\nsum(estimate) exfixedstoryestimate,\nleft(closedDate,4) year\nfrom\nzt_story\nwhere zt_story.deleted=\'0\' and zt_story.status=\'closed\' and zt_story.closedReason=\'done\'\ngroup by year\n) story\non story.year=bug.year\norder by bug.year', 'published', 1, '', 'admin', '2023-04-06 13:05:10', 'admin', '2023-04-06 13:05:10', 0),
(10214, '质量数据-Bug严重程度年度堆积柱状图', 3, 'stackedBar', '91', '0', '', '[{\"type\":\"stackedBar\",\"xaxis\":[{\"field\":\"\\u5e74\\u4efd\",\"name\":\"\\u5e74\\u4efd\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a1\\u7ea7\\u7684Bug\",\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a1\\u7ea7\\u7684Bug\",\"valOrAgg\":\"sum\"},{\"field\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a2\\u7ea7\\u7684Bug\",\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a2\\u7ea7\\u7684Bug\",\"valOrAgg\":\"sum\"},{\"field\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4f4e\\u4e8e2\\u7ea7\\u7684Bug\",\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4f4e\\u4e8e2\\u7ea7\\u7684Bug\",\"valOrAgg\":\"sum\"}]}]', '[{\"field\":\"\\u5e74\\u4efd\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', 4, '{\"\\u6240\\u6709Bug\\u6570\":{\"name\":\"\\u6240\\u6709Bug\\u6570\",\"object\":\"bug\",\"field\":\"\\u6240\\u6709Bug\\u6570\",\"type\":\"string\"},\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a1\\u7ea7\\u7684Bug\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a1\\u7ea7\\u7684Bug\",\"object\":\"bug\",\"field\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a1\\u7ea7\\u7684Bug\",\"type\":\"number\"},\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a2\\u7ea7\\u7684Bug\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a2\\u7ea7\\u7684Bug\",\"object\":\"bug\",\"field\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e3a2\\u7ea7\\u7684Bug\",\"type\":\"number\"},\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4f4e\\u4e8e2\\u7ea7\\u7684Bug\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4f4e\\u4e8e2\\u7ea7\\u7684Bug\",\"object\":\"bug\",\"field\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4f4e\\u4e8e2\\u7ea7\\u7684Bug\",\"type\":\"number\"},\"\\u5e74\\u4efd\":{\"name\":\"\\u5e74\\u4efd\",\"object\":\"bug\",\"field\":\"\\u5e74\\u4efd\",\"type\":\"string\"}}', '', 'select\ncount(id) \'所有Bug数\',\nsum(case when severity=1 then 1 else 0 end) \'严重程度为1级的Bug\',\nsum(case when severity=2 then 1 else 0 end) \'严重程度为2级的Bug\',\nsum(case when severity not in (1,2) then 1 else 0 end) \'严重程度低于2级的Bug\',\nleft(openedDate,4) \'年份\'\nfrom\nzt_bug\nwhere deleted=\'0\'\ngroup by left(openedDate,4)\norder by left(openedDate,4)', 'published', 1, '', 'admin', '2023-04-06 13:12:34', 'admin', '2023-04-06 13:12:34', 0),
(10215, '质量数据-产品用例数量统计条形图', 3, 'cluBarY', '91', '0', '', '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"name\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"\\u7528\\u4f8b\",\"name\":\"\\u7528\\u4f8b\",\"valOrAgg\":\"sum\"}]}]', '[{\"field\":\"name\",\"type\":\"select\",\"name\":\"\\u4ea7\\u54c1\"}]', 4, '{\"name\":{\"name\":\"name\",\"object\":\"testcase\",\"field\":\"name\",\"type\":\"string\"},\"\\u7528\\u4f8b\":{\"name\":\"\\u7528\\u4f8b\",\"object\":\"testcase\",\"field\":\"\\u7528\\u4f8b\",\"type\":\"string\"}}', '', 'select \nt1.name,\nifnull(t2.cases,0) \'用例\'\nfrom\nzt_product t1\nleft join\n(\nselect\nproduct,\ncount(id) cases \nfrom\nzt_case\nwhere deleted=\'0\'\ngroup by product )\nt2 on t1.id=t2.product', 'published', 1, '', 'admin', '2023-04-06 13:33:48', 'admin', '2023-04-06 13:33:48', 0),
(10216, '质量数据-产品Bug数量统计条形图', 3, 'cluBarY', '91', '0', '', '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"name\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}]}]', '[{\"field\":\"name\",\"type\":\"select\",\"name\":\"\\u4ea7\\u54c1\"}]', 4, '{\"name\":{\"name\":\"name\",\"object\":\"bug\",\"field\":\"name\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"bug\",\"type\":\"string\"}}', '', 'select \nt1.name,\nifnull(t2.bugs,0) bug\nfrom\nzt_product t1\nleft join\n(\nselect\nproduct,\ncount(id) bugs \nfrom\nzt_bug\nwhere zt_bug.deleted=\'0\'\ngroup by product )\nt2 on t1.id=t2.product', 'published', 1, '', 'admin', '2023-04-06 13:35:24', 'admin', '2023-04-06 13:35:24', 0);

REPLACE INTO `zt_pivot`(`id`, `dimension`, `group`, `name`, `desc`, `sql`, `fields`, `langs`, `vars`, `objects`, `settings`, `filters`, `step`, `stage`, `builtin`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(1000, 2, '0', '{\"zh-cn\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u5de5\\u671f\\u900f\\u89c6\\u8868\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}', '', 'select\nt1.name,\nt2.1program,\nt1.begin,\nt1.end,\nt1.realBegan,\nt1.realEnd,\nt1.closedDate,\nt1.realduration,\nt1.realduration-t1.planduration duration_deviation,\nround((t1.realduration-t1.planduration)/t1.planduration,3) rate\nfrom\n(select \nname,\nsubstr(`path`,2,4) 1program,\nbegin,\nend,\nrealBegan,\nrealEnd,\nleft(closedDate,10) closedDate,\ndatediff(`end`,`begin`) planduration,\nifnull(if(left(`realEnd`,4) != \'0000\',datediff(`realEnd`,`realBegan`),datediff(`closedDate`,`realBegan`)),0) realduration\nfrom\nzt_project\nwhere type=\'project\' and status=\'closed\' and deleted=\'0\') t1\nleft join\n(select\nid programid,\nname 1program\nfrom\nzt_project\nwhere type=\'program\' and grade=1) t2\non t1.1program=t2.programid', '{\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"1program\":{\"name\":\"1program\",\"object\":\"project\",\"field\":\"1program\",\"type\":\"string\"},\"begin\":{\"name\":\"\\u8ba1\\u5212\\u5f00\\u59cb\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"begin\",\"type\":\"date\"},\"end\":{\"name\":\"\\u8ba1\\u5212\\u5b8c\\u6210\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"end\",\"type\":\"date\"},\"realBegan\":{\"name\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realBegan\",\"type\":\"date\"},\"realEnd\":{\"name\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realEnd\",\"type\":\"date\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"},\"realduration\":{\"name\":\"realduration\",\"object\":\"project\",\"field\":\"realduration\",\"type\":\"number\"},\"duration_deviation\":{\"name\":\"duration_deviation\",\"object\":\"project\",\"field\":\"duration_deviation\",\"type\":\"number\"},\"rate\":{\"name\":\"rate\",\"object\":\"project\",\"field\":\"rate\",\"type\":\"number\"}}', '{\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"1program\":{\"zh-cn\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"begin\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5f00\\u59cb\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"end\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5b8c\\u6210\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"realBegan\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"realEnd\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"realduration\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5de5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"duration_deviation\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"rate\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\\u7387\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', '', '', '{\"columns\":[{\"field\":\"begin\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"end\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"realBegan\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"realEnd\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"closedDate\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"realduration\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"duration_deviation\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"rate\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"}],\"group3\":\"1program\",\"group6\":\"name\",\"lastStep\":\"4\"}', '[]', 0, 'published', '1', 'admin', '2023-04-06 14:07:26', 'admin', '2023-04-06 14:07:26', '0'),
(1001, 2, '0', '{\"zh-cn\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u5de5\\u65f6\\u900f\\u89c6\\u8868\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}', '', 'select\nt1.name \'项目名称\',\nt4.1program \'一级项目集\',\nround(t2.estimate,2) \'预计工时\',\nround(t2.consumed,2) \'消耗工时\',\nround(t2.consumed-t2.estimate,2) \'工时偏差\',\nround((t2.consumed-t2.estimate)/t2.estimate,2) \'工时偏差率\',\nifnull(t3.storys,0) \'完成需求数\',\nifnull(t3.storyestimate,0) \'完成需求规模数\',\nround(ifnull(t3.storyestimate,0)/ifnull(t2.consumed,0),2) \'单位时间交付需求规模数\',\nt1.closedDate closedDate\nfrom(\nselect\nid,\nname,\nsubstr(`path`,2,4) 1program,\nclosedDate\nfrom\nzt_project\nwhere deleted=\'0\' and type=\'project\' and status=\'closed\') t1\nleft join(\nselect\nproject,\nsum(estimate) estimate,\nsum(consumed) consumed\nfrom\nzt_task\nwhere deleted=\'0\' and project !=0\ngroup by project) t2\non t1.id=t2.project\nleft join (\nselect\ntt3.project,\ncount(tt3.id) storys,\nsum(estimate) storyestimate\nfrom(\nselect\ntt1.id,\ntt1.estimate,\ntt2.project\nfrom\nzt_story tt1\nleft join\nzt_projectstory tt2\non tt1.id=tt2.story\nwhere tt1.deleted=\'0\' and tt1.status=\'closed\' and tt1.closedReason=\'done\') tt3\ngroup by tt3.project) t3\non t1.id=t3.project\nleft join\n(select\nid programid,\nname 1program\nfrom\nzt_project\nwhere type=\'program\' and grade=1) t4\non t1.1program=t4.programid', '{\"\\u9879\\u76ee\\u540d\\u79f0\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"type\":\"string\"},\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\":{\"name\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"object\":\"project\",\"field\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"type\":\"string\"},\"\\u9884\\u8ba1\\u5de5\\u65f6\":{\"name\":\"\\u9884\\u8ba1\\u5de5\\u65f6\",\"object\":\"project\",\"field\":\"\\u9884\\u8ba1\\u5de5\\u65f6\",\"type\":\"number\"},\"\\u6d88\\u8017\\u5de5\\u65f6\":{\"name\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"object\":\"project\",\"field\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"type\":\"number\"},\"\\u5de5\\u65f6\\u504f\\u5dee\":{\"name\":\"\\u5de5\\u65f6\\u504f\\u5dee\",\"object\":\"project\",\"field\":\"\\u5de5\\u65f6\\u504f\\u5dee\",\"type\":\"number\"},\"\\u5de5\\u65f6\\u504f\\u5dee\\u7387\":{\"name\":\"\\u5de5\\u65f6\\u504f\\u5dee\\u7387\",\"object\":\"project\",\"field\":\"\\u5de5\\u65f6\\u504f\\u5dee\\u7387\",\"type\":\"number\"},\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\":{\"name\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"object\":\"project\",\"field\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"type\":\"string\"},\"\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\":{\"name\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"object\":\"project\",\"field\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"type\":\"number\"},\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\":{\"name\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"object\":\"project\",\"field\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"type\":\"number\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}', '', '', '', '{\"columns\":[{\"field\":\"\\u9884\\u8ba1\\u5de5\\u65f6\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u5de5\\u65f6\\u504f\\u5dee\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u5de5\\u65f6\\u504f\\u5dee\\u7387\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u5355\\u4f4d\\u65f6\\u95f4\\u4ea4\\u4ed8\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"}],\"columnTotal\":\"noShow\",\"group1\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"group2\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"lastStep\":\"4\"}', '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', 0, 'published', '1', 'admin', '2023-04-11 13:14:37', 'admin', '2023-04-11 13:14:37', '0'),
(1002, 3, '0', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f3a\\u9677\\u6570\\u636e\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}', '', 'SELECT \n  t1.name AS  \'产品\', \n  IFNULL(t2.name, \'/\') AS \'一级项目集\', \n  IFNULL(t3.name, \'/\') AS \'产品线\', \n  IFNULL(t6.exfixedstorys, 0) AS \'研发完成需求数\', \n  round(IFNULL(t6.exfixedstorysmate, 0),3) AS \'研发完成需求规模数\',\n  IFNULL(t8.storycases, 0) AS \'需求用例数\',\n  round(storycases/exfixedstorysmate,3) AS \'用例密度\',\n  round(IFNULL(t10.casestorys/t6.exfixedstorys,0),3) AS \'用例覆盖率\',\n  IFNULL(t7.bug, 0) AS \'Bug数\',\n  IFNULL(t7.effbugs, 0) AS \'有效Bug数\',\n  IFNULL(t7.pri12bugs, 0) AS \'优先级为1，2的Bug数\',\n  round(bug/exfixedstorysmate,3) AS \'Bug密度\',\n  IFNULL(t7.fixedbugs, 0) AS \'修复Bug数\',\n  round(fixedbugs/bug,3) \'Bug修复率\'\nFROM \n  zt_product AS t1 \n  LEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1 \n  LEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\' \n  LEFT JOIN (\n  SELECT\n  product, \n  count(id) exfixedstorys, \n  sum(estimate) exfixedstorysmate\n  FROM zt_story \n  WHERE deleted = \'0\'  and (stage in (\'developed\',\'testing\',\'verfied\',\'released\') or (status=\'closed\' and closedReason=\'done\'))\n  GROUP BY product) AS t6 ON t1.id = t6.product \n  LEFT JOIN (SELECT product, COUNT(id)  AS bug,\n  SUM(case when  resolution in (\'fixed\',\'postponed\') or status=\'active\' then 1 else 0 end) effbugs, \n  SUM(CASE WHEN  resolution=\'fixed\' then 1 else 0 end) fixedbugs,\n  SUM(CASE WHEN severity in (1,2) then 1 else 0 end) pri12bugs\n  FROM zt_bug WHERE deleted = \'0\' GROUP BY product) AS t7 ON t1.id = t7.product \n  LEFT JOIN (SELECT product, COUNT(id) AS storycases FROM zt_case WHERE deleted=\'0\' GROUP BY product) AS t8 ON t1.id=t8.product\n  LEFT JOIN (\n   select \n   t9.product, \n   count(t9.story) casestorys\n   from(\n     SELECT \n     zt_case.product,zt_case.story \n     FROM zt_case \n     left join zt_story\n     on zt_case.story=zt_story.id\n     WHERE zt_case.deleted=\'0\' and zt_case.story !=\'0\' and zt_story.deleted=\'0\' and  (zt_story.stage in (\'developed\',\'testing\',\'verfied\',\'released\') or (zt_story.status=\'closed\' and zt_story.closedReason=\'done\'))\n     GROUP BY product, story) t9\n     group by product) t10\n     on t1.id=t10.product\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'AND t1.vision = \'rnd\'\nORDER BY t1.order', '{\"\\u4ea7\\u54c1\":{\"name\":\"\\u4ea7\\u54c1\",\"object\":\"story\",\"field\":\"\\u4ea7\\u54c1\",\"type\":\"string\"},\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\":{\"name\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"object\":\"story\",\"field\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"type\":\"string\"},\"\\u4ea7\\u54c1\\u7ebf\":{\"name\":\"\\u4ea7\\u54c1\\u7ebf\",\"object\":\"story\",\"field\":\"\\u4ea7\\u54c1\\u7ebf\",\"type\":\"string\"},\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u6570\":{\"name\":\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"object\":\"story\",\"field\":\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"type\":\"string\"},\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\":{\"name\":\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"object\":\"story\",\"field\":\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"type\":\"number\"},\"\\u9700\\u6c42\\u7528\\u4f8b\\u6570\":{\"name\":\"\\u9700\\u6c42\\u7528\\u4f8b\\u6570\",\"object\":\"story\",\"field\":\"\\u9700\\u6c42\\u7528\\u4f8b\\u6570\",\"type\":\"string\"},\"\\u7528\\u4f8b\\u5bc6\\u5ea6\":{\"name\":\"\\u7528\\u4f8b\\u5bc6\\u5ea6\",\"object\":\"story\",\"field\":\"\\u7528\\u4f8b\\u5bc6\\u5ea6\",\"type\":\"number\"},\"\\u7528\\u4f8b\\u8986\\u76d6\\u7387\":{\"name\":\"\\u7528\\u4f8b\\u8986\\u76d6\\u7387\",\"object\":\"story\",\"field\":\"\\u7528\\u4f8b\\u8986\\u76d6\\u7387\",\"type\":\"number\"},\"Bug\\u6570\":{\"name\":\"Bug\\u6570\",\"object\":\"story\",\"field\":\"Bug\\u6570\",\"type\":\"string\"},\"\\u6709\\u6548Bug\\u6570\":{\"name\":\"\\u6709\\u6548Bug\\u6570\",\"object\":\"story\",\"field\":\"\\u6709\\u6548Bug\\u6570\",\"type\":\"number\"},\"\\u4f18\\u5148\\u7ea7\\u4e3a1\\uff0c2\\u7684Bug\\u6570\":{\"name\":\"\\u4f18\\u5148\\u7ea7\\u4e3a1\\uff0c2\\u7684Bug\\u6570\",\"object\":\"story\",\"field\":\"\\u4f18\\u5148\\u7ea7\\u4e3a1\\uff0c2\\u7684Bug\\u6570\",\"type\":\"number\"},\"Bug\\u5bc6\\u5ea6\":{\"name\":\"Bug\\u5bc6\\u5ea6\",\"object\":\"story\",\"field\":\"Bug\\u5bc6\\u5ea6\",\"type\":\"number\"},\"\\u4fee\\u590dBug\\u6570\":{\"name\":\"\\u4fee\\u590dBug\\u6570\",\"object\":\"story\",\"field\":\"\\u4fee\\u590dBug\\u6570\",\"type\":\"number\"},\"Bug\\u4fee\\u590d\\u7387\":{\"name\":\"Bug\\u4fee\\u590d\\u7387\",\"object\":\"story\",\"field\":\"Bug\\u4fee\\u590d\\u7387\",\"type\":\"number\"}}', '', '', '', '{\"columns\":[{\"field\":\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u7814\\u53d1\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u9700\\u6c42\\u7528\\u4f8b\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u7528\\u4f8b\\u5bc6\\u5ea6\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u7528\\u4f8b\\u8986\\u76d6\\u7387\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"Bug\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u6709\\u6548Bug\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u4f18\\u5148\\u7ea7\\u4e3a1\\uff0c2\\u7684Bug\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"Bug\\u5bc6\\u5ea6\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"\\u4fee\\u590dBug\\u6570\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"},{\"field\":\"Bug\\u4fee\\u590d\\u7387\",\"stat\":\"sum\",\"slice\":\"noSlice\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"noShow\"}],\"columnTotal\":\"noShow\",\"group1\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"group3\":\"\\u4ea7\\u54c1\\u7ebf\",\"group2\":\"\\u4ea7\\u54c1\",\"lastStep\":\"4\"}', '[]', 0, 'published', '1', 'admin', '2023-04-06 13:16:52', 'admin', '2023-04-06 13:16:52', '0');

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) SELECT `group`, 'projectbuild', 'browse' FROM `zt_grouppriv` WHERE `module` = 'project' AND `method` = 'build';

REPLACE INTO `zt_priv` (`id`, `module`, `method`, `parent`, `edition`, `vision`, `system`, `order`) VALUES (1,'index','index',349,',open,biz,max,',',rnd,lite,','1',5),(2,'my','index',18,',open,biz,max,',',rnd,lite,','1',0),(3,'my','todo',4,',open,biz,max,',',rnd,lite,','1',1),(4,'my','work',18,',open,biz,max,',',rnd,lite,','1',2),(5,'my','contribute',18,',open,biz,max,',',rnd,lite,','1',3),(6,'my','project',18,',open,biz,max,',',rnd,lite,','1',4),(7,'my','profile',9,',open,biz,max,',',rnd,lite,','1',0),(8,'my','uploadAvatar',9,',open,biz,max,',',rnd,lite,','1',2),(9,'my','preference',10,',open,biz,max,',',rnd,','1',40),(10,'my','dynamic',18,',open,biz,max,',',rnd,lite,','1',6),(11,'my','editProfile',9,',open,biz,max,',',rnd,lite,','1',1),(12,'my','changePassword',9,',open,biz,max,',',rnd,lite,','1',3),(13,'my','manageContacts',8,',open,biz,max,',',rnd,lite,','1',60),(14,'my','deleteContacts',8,',open,biz,max,',',rnd,lite,','1',65),(15,'my','score',18,',open,biz,max,',',rnd,lite,','1',70),(16,'my','team',165,',open,biz,max,',',rnd,lite,','1',0),(17,'my','execution',18,',open,biz,max,',',rnd,lite,','1',5),(18,'my','doc',18,',open,biz,max,',',rnd,lite,','1',55),(19,'my','audit',18,',open,biz,max,',',rnd,','1',7),(20,'my','meeting',18,',max,',',rnd,','1',8),(21,'my','calendar',4,',open,biz,max,',',rnd,lite,','1',0),(22,'my','effort',291,',biz,max,',',rnd,lite,','1',1),(23,'my','review',18,',biz,max,',',rnd,lite,','1',9),(24,'todo','create',5,',open,biz,max,',',rnd,lite,','1',0),(25,'todo','createcycle',5,',open,biz,max,',',rnd,lite,','1',1),(26,'todo','batchCreate',5,',open,biz,max,',',rnd,lite,','1',2),(27,'todo','edit',5,',open,biz,max,',',rnd,lite,','1',3),(28,'todo','batchEdit',5,',open,biz,max,',',rnd,lite,','1',4),(29,'todo','view',4,',open,biz,max,',',rnd,lite,','1',5),(30,'todo','delete',6,',open,biz,max,',',rnd,lite,','1',35),(31,'todo','export',7,',open,biz,max,',',rnd,lite,','1',40),(32,'todo','start',5,',open,biz,max,',',rnd,lite,','1',5),(33,'todo','finish',5,',open,biz,max,',',rnd,lite,','1',7),(34,'todo','batchFinish',5,',open,biz,max,',',rnd,lite,','1',8),(35,'todo','import2Today',5,',open,biz,max,',',rnd,lite,','1',12),(36,'todo','assignTo',5,',open,biz,max,',',rnd,lite,','1',6),(37,'todo','activate',5,',open,biz,max,',',rnd,lite,','1',10),(38,'todo','close',5,',open,biz,max,',',rnd,lite,','1',9),(39,'todo','batchClose',5,',open,biz,max,',',rnd,lite,','1',11),(40,'todo','calendar',4,',biz,max,',',rnd,lite,','1',85),(41,'program','browse',11,',open,biz,max,',',rnd,','1',0),(42,'program','kanban',11,',open,biz,max,',',rnd,','1',1),(43,'program','view',11,',open,biz,max,',',rnd,','1',2),(44,'program','product',11,',open,biz,max,',',rnd,','1',3),(45,'program','create',12,',open,biz,max,',',rnd,','1',25),(46,'program','edit',12,',open,biz,max,',',rnd,','1',30),(47,'program','start',12,',open,biz,max,',',rnd,','1',35),(48,'program','suspend',12,',open,biz,max,',',rnd,','1',40),(49,'program','activate',12,',open,biz,max,',',rnd,','1',45),(50,'program','close',12,',open,biz,max,',',rnd,','1',50),(51,'program','delete',13,',open,biz,max,',',rnd,','1',55),(52,'program','project',11,',open,biz,max,',',rnd,','1',4),(53,'program','stakeholder',17,',open,biz,max,',',rnd,','1',65),(54,'program','createStakeholder',17,',open,biz,max,',',rnd,','1',70),(55,'program','unlinkStakeholder',17,',open,biz,max,',',rnd,','1',75),(56,'program','batchUnlinkStakeholders',17,',open,biz,max,',',rnd,','1',80),(57,'program','unbindWhitelist',16,',open,biz,max,',',rnd,','1',85),(58,'program','updateOrder',12,',open,biz,max,',',rnd,','1',90),(59,'personnel','accessible',15,',open,biz,max,',',rnd,lite,','1',5),(60,'personnel','invest',14,',open,biz,max,',',rnd,lite,','1',10),(61,'personnel','whitelist',16,',open,biz,max,',',rnd,lite,','1',15),(62,'personnel','addWhitelist',16,',open,biz,max,',',rnd,lite,','1',20),(63,'product','index',19,',open,biz,max,',',rnd,','1',0),(64,'product','browse',25,',open,biz,max,',',rnd,','1',10),(65,'product','requirement',31,',open,biz,max,',',rnd,','1',15),(66,'product','create',21,',open,biz,max,',',rnd,','1',20),(67,'product','view',19,',open,biz,max,',',rnd,','1',4),(68,'product','edit',21,',open,biz,max,',',rnd,','1',30),(69,'product','batchEdit',21,',open,biz,max,',',rnd,','1',35),(70,'product','delete',30,',open,biz,max,',',rnd,','1',40),(71,'product','roadmap',19,',open,biz,max,',',rnd,','1',5),(72,'product','track',19,',open,biz,max,',',rnd,','1',6),(73,'product','dynamic',19,',open,biz,max,',',rnd,','1',7),(74,'product','project',19,',open,biz,max,',',rnd,','1',8),(75,'product','dashboard',19,',open,biz,max,',',rnd,','1',3),(76,'product','close',21,',open,biz,max,',',rnd,','1',70),(77,'product','updateOrder',21,',open,biz,max,',',rnd,','1',75),(78,'product','all',19,',open,biz,max,',',rnd,','1',1),(79,'product','kanban',19,',open,biz,max,',',rnd,','1',2),(80,'product','manageLine',20,',open,biz,max,',',rnd,','1',90),(82,'product','export',22,',open,biz,max,',',rnd,','1',100),(83,'product','whitelist',23,',open,biz,max,',',rnd,','1',105),(84,'product','addWhitelist',23,',open,biz,max,',',rnd,','1',110),(85,'product','unbindWhitelist',23,',open,biz,max,',',rnd,','1',115),(86,'story','create',26,',open,biz,max,',',rnd,lite,','1',0),(87,'story','batchCreate',26,',open,biz,max,',',rnd,lite,','1',1),(88,'story','edit',26,',open,biz,max,',',rnd,lite,','1',2),(89,'story','export',27,',open,biz,max,',',rnd,lite,','1',0),(90,'story','delete',28,',open,biz,max,',',rnd,lite,','1',25),(91,'story','view',25,',open,biz,max,',',rnd,lite,','1',30),(92,'story','change',26,',open,biz,max,',',rnd,lite,','1',4),(93,'story','review',29,',open,biz,max,',',rnd,lite,','1',40),(94,'story','submitReview',26,',open,biz,max,',',rnd,lite,','1',5),(95,'story','batchReview',29,',open,biz,max,',',rnd,lite,','1',50),(96,'story','recall',26,',open,biz,max,',',rnd,lite,','1',6),(97,'story','close',26,',open,biz,max,',',rnd,lite,','1',7),(98,'story','batchClose',26,',open,biz,max,',',rnd,lite,','1',8),(99,'story','batchChangePlan',26,',open,biz,max,',',rnd,lite,','1',9),(100,'story','batchChangeStage',26,',open,biz,max,',',rnd,lite,','1',10),(101,'story','assignTo',26,',open,biz,max,',',rnd,lite,','1',11),(102,'story','batchAssignTo',26,',open,biz,max,',',rnd,lite,','1',12),(103,'story','activate',26,',open,biz,max,',',rnd,lite,','1',13),(104,'story','tasks',25,',open,biz,max,',',rnd,lite,','1',95),(105,'story','bugs',25,',open,biz,max,',',rnd,','1',100),(106,'story','cases',25,',open,biz,max,',',rnd,','1',105),(107,'story','report',25,',open,biz,max,',',rnd,lite,','1',110),(108,'story','linkStory',26,',open,biz,max,',',rnd,lite,','1',14),(109,'story','batchChangeBranch',26,',open,biz,max,',',rnd,lite,','1',15),(110,'story','batchChangeModule',26,',open,biz,max,',',rnd,lite,','1',16),(111,'story','batchToTask',45,',open,biz,max,',',rnd,lite,','1',130),(112,'story','processStoryChange',26,',open,biz,max,',',rnd,lite,','1',17),(113,'story','linkStories',26,',open,biz,max,',',rnd,','1',18),(114,'story','relieved',26,',open,biz,max,',',rnd,','1',20),(115,'story','batchEdit',26,',open,biz,max,',',rnd,lite,','1',3),(116,'story','import',27,',biz,max,',',rnd,','1',2),(117,'story','exportTemplate',27,',biz,max,',',rnd,','1',1),(118,'story','importToLib',263,',max,',',rnd,','1',165),(119,'story','batchImportToLib',263,',max,',',rnd,','1',170),(120,'story','relation',26,',max,',',rnd,','1',19),(121,'requirement','create',32,',open,biz,max,',',rnd,','1',5),(122,'requirement','batchCreate',32,',open,biz,max,',',rnd,','1',10),(123,'requirement','edit',32,',open,biz,max,',',rnd,','1',15),(124,'requirement','export',33,',open,biz,max,',',rnd,','1',20),(125,'requirement','delete',32,',open,biz,max,',',rnd,','1',25),(126,'requirement','view',31,',open,biz,max,',',rnd,','1',30),(127,'requirement','change',32,',open,biz,max,',',rnd,','1',35),(128,'requirement','review',35,',open,biz,max,',',rnd,','1',40),(129,'requirement','submitReview',32,',open,biz,max,',',rnd,','1',45),(130,'requirement','batchReview',35,',open,biz,max,',',rnd,','1',50),(131,'requirement','recall',32,',open,biz,max,',',rnd,','1',55),(132,'requirement','close',32,',open,biz,max,',',rnd,','1',60),(133,'requirement','batchClose',32,',open,biz,max,',',rnd,','1',65),(134,'requirement','assignTo',32,',open,biz,max,',',rnd,','1',70),(135,'requirement','batchAssignTo',32,',open,biz,max,',',rnd,','1',75),(136,'requirement','activate',32,',open,biz,max,',',rnd,','1',80),(137,'requirement','report',31,',open,biz,max,',',rnd,','1',85),(138,'requirement','linkStory',32,',open,biz,max,',',rnd,','1',90),(139,'requirement','batchChangeBranch',32,',open,biz,max,',',rnd,','1',95),(140,'requirement','batchChangeModule',32,',open,biz,max,',',rnd,','1',100),(141,'requirement','linkRequirements',32,',open,biz,max,',',rnd,','1',105),(142,'requirement','batchEdit',32,',open,biz,max,',',rnd,','1',110),(143,'requirement','import',33,',max,',',rnd,','1',115),(144,'requirement','exportTemplate',33,',max,',',rnd,','1',120),(145,'productplan','browse',36,',open,biz,max,',',rnd,','1',5),(146,'productplan','create',37,',open,biz,max,',',rnd,','1',10),(147,'productplan','edit',37,',open,biz,max,',',rnd,','1',15),(148,'productplan','delete',38,',open,biz,max,',',rnd,','1',20),(149,'productplan','view',36,',open,biz,max,',',rnd,','1',25),(150,'productplan','linkStory',37,',open,biz,max,',',rnd,','1',30),(151,'productplan','unlinkStory',37,',open,biz,max,',',rnd,','1',35),(152,'productplan','batchUnlinkStory',37,',open,biz,max,',',rnd,','1',40),(153,'productplan','linkBug',37,',open,biz,max,',',rnd,','1',45),(154,'productplan','unlinkBug',37,',open,biz,max,',',rnd,','1',50),(155,'productplan','batchUnlinkBug',37,',open,biz,max,',',rnd,','1',55),(156,'productplan','batchEdit',37,',open,biz,max,',',rnd,','1',60),(157,'productplan','start',37,',open,biz,max,',',rnd,','1',65),(158,'productplan','finish',37,',open,biz,max,',',rnd,','1',70),(159,'productplan','close',37,',open,biz,max,',',rnd,','1',75),(160,'productplan','activate',37,',open,biz,max,',',rnd,','1',80),(161,'productplan','batchChangeStatus',37,',open,biz,max,',',rnd,','1',85),(162,'release','browse',39,',open,biz,max,',',rnd,','1',5),(163,'release','create',40,',open,biz,max,',',rnd,','1',10),(164,'release','edit',40,',open,biz,max,',',rnd,','1',15),(165,'release','delete',42,',open,biz,max,',',rnd,','1',20),(166,'release','view',39,',open,biz,max,',',rnd,','1',25),(167,'release','export',41,',open,biz,max,',',rnd,','1',30),(168,'release','linkStory',40,',open,biz,max,',',rnd,','1',35),(169,'release','unlinkStory',40,',open,biz,max,',',rnd,','1',40),(170,'release','batchUnlinkStory',40,',open,biz,max,',',rnd,','1',45),(171,'release','linkBug',40,',open,biz,max,',',rnd,','1',50),(172,'release','unlinkBug',40,',open,biz,max,',',rnd,','1',55),(173,'release','batchUnlinkBug',40,',open,biz,max,',',rnd,','1',60),(174,'release','changeStatus',40,',open,biz,max,',',rnd,','1',65),(175,'release','notify',43,',open,biz,max,',',rnd,','1',70),(176,'project','index',46,',open,biz,max,',',rnd,lite,','1',5),(177,'project','browse',46,',open,biz,max,',',rnd,lite,','1',40),(178,'project','kanban',46,',open,biz,max,',',rnd,lite,','1',15),(179,'project','create',47,',open,biz,max,',',rnd,lite,','1',0),(180,'project','edit',47,',open,biz,max,',',rnd,lite,','1',1),(181,'project','batchEdit',47,',open,biz,max,',',rnd,lite,','1',2),(182,'project','group',50,',open,biz,max,',',rnd,lite,','1',0),(183,'project','createGroup',50,',open,biz,max,',',rnd,lite,','1',1),(184,'project','managePriv',50,',open,biz,max,',',rnd,lite,','1',3),(185,'project','manageMembers',50,',open,biz,max,',',rnd,lite,','1',6),(186,'project','manageGroupMember',50,',open,biz,max,',',rnd,lite,','1',4),(187,'project','copyGroup',50,',open,biz,max,',',rnd,lite,','1',5),(188,'project','editGroup',50,',open,biz,max,',',rnd,lite,','1',2),(189,'project','start',47,',open,biz,max,',',rnd,lite,','1',3),(190,'project','suspend',47,',open,biz,max,',',rnd,lite,','1',4),(191,'project','close',47,',open,biz,max,',',rnd,lite,','1',6),(192,'project','activate',47,',open,biz,max,',',rnd,lite,','1',5),(193,'project','updateOrder',47,',open,biz,max,',',rnd,lite,','1',7),(194,'project','delete',51,',open,biz,max,',',rnd,lite,','1',95),(195,'project','view',46,',open,biz,max,',',rnd,lite,','1',100),(196,'project','whitelist',52,',open,biz,max,',',rnd,lite,','1',105),(197,'project','addWhitelist',52,',open,biz,max,',',rnd,lite,','1',110),(198,'project','unbindWhitelist',52,',open,biz,max,',',rnd,lite,','1',115),(199,'project','manageProducts',47,',open,biz,max,',',rnd,','1',8),(200,'project','dynamic',46,',open,biz,max,',',rnd,lite,','1',125),(203,'project','bug',292,',open,biz,max,',',rnd,','1',140),(204,'project','testcase',292,',open,biz,max,',',rnd,','1',145),(205,'project','testtask',292,',open,biz,max,',',rnd,','1',150),(206,'project','testreport',292,',open,biz,max,',',rnd,','1',155),(207,'project','execution',46,',open,biz,max,',',rnd,lite,','1',160),(208,'project','export',48,',open,biz,max,',',rnd,lite,','1',165),(209,'project','team',50,',open,biz,max,',',rnd,lite,','1',7),(210,'project','unlinkMember',50,',open,biz,max,',',rnd,lite,','1',8),(212,'project','programTitle',47,',open,biz,max,',',rnd,','1',9),(213,'project','approval',302,',max,',',rnd,','1',5),(214,'projectplan','browse',44,',open,biz,max,',',rnd,','1',0),(215,'projectplan','create',44,',open,biz,max,',',rnd,','1',2),(216,'projectplan','edit',44,',open,biz,max,',',rnd,','1',3),(217,'projectplan','view',44,',open,biz,max,',',rnd,','1',1),(218,'projectstory','story',313,',open,biz,max,',',rnd,lite,','1',5),(219,'projectstory','track',293,',max,',',rnd,','1',10),(220,'projectstory','view',313,',open,biz,max,',',rnd,lite,','1',15),(221,'projectstory','linkStory',45,',open,biz,max,',',rnd,lite,','1',20),(222,'projectstory','importplanstories',45,',open,biz,max,',',rnd,','1',25),(223,'projectstory','unlinkStory',45,',open,biz,max,',',rnd,lite,','1',30),(224,'projectstory','batchUnlinkStory',45,',open,biz,max,',',rnd,lite,','1',35),(225,'projectstory','importFromLib',45,',max,',',rnd,','1',40),(226,'execution','view',53,',open,biz,max,',',rnd,lite,','1',2),(228,'execution','create',54,',open,biz,max,',',rnd,lite,','1',0),(229,'execution','edit',54,',open,biz,max,',',rnd,lite,','1',2),(230,'execution','batchedit',54,',open,biz,max,',',rnd,lite,','1',3),(231,'execution','batchchangestatus',54,',open,biz,max,',',rnd,','1',4),(232,'execution','start',54,',open,biz,max,',',rnd,lite,','1',5),(233,'execution','activate',54,',open,biz,max,',',rnd,lite,','1',6),(234,'execution','putoff',54,',open,biz,max,',',rnd,lite,','1',7),(235,'execution','suspend',54,',open,biz,max,',',rnd,lite,','1',8),(236,'execution','close',54,',open,biz,max,',',rnd,lite,','1',9),(237,'execution','delete',55,',open,biz,max,',',rnd,lite,','1',60),(238,'execution','task',60,',open,biz,max,',',rnd,lite,','1',65),(239,'execution','grouptask',66,',open,biz,max,',',rnd,lite,','1',0),(240,'execution','importtask',61,',open,biz,max,',',rnd,lite,','1',15),(241,'execution','importplanstories',61,',open,biz,max,',',rnd,','1',16),(242,'execution','importBug',61,',open,biz,max,',',rnd,','1',17),(243,'execution','story',311,',open,biz,max,',',rnd,lite,','1',0),(244,'execution','build',309,',open,biz,max,',',rnd,','1',0),(245,'execution','testcase',290,',open,biz,max,',',rnd,','1',1),(246,'execution','bug',290,',open,biz,max,',',rnd,','1',0),(247,'execution','testtask',290,',open,biz,max,',',rnd,','1',2),(248,'execution','testreport',290,',open,biz,max,',',rnd,','1',3),(249,'execution','burn',67,',open,biz,max,',',rnd,','1',120),(250,'execution','computeBurn',67,',open,biz,max,',',rnd,','1',125),(251,'execution','cfd',68,',open,biz,max,',',rnd,','1',130),(252,'execution','computeCFD',68,',open,biz,max,',',rnd,','1',135),(253,'execution','fixFirst',67,',open,biz,max,',',rnd,','1',140),(255,'execution','team',64,',open,biz,max,',',rnd,lite,','1',0),(256,'execution','dynamic',53,',open,biz,max,',',rnd,lite,','1',5),(257,'execution','manageProducts',54,',open,biz,max,',',rnd,','1',1),(258,'execution','manageMembers',64,',open,biz,max,',',rnd,lite,','1',1),(259,'execution','unlinkMember',64,',open,biz,max,',',rnd,lite,','1',2),(260,'execution','linkStory',69,',open,biz,max,',',rnd,lite,','1',3),(261,'execution','unlinkStory',69,',open,biz,max,',',rnd,lite,','1',4),(262,'execution','batchUnlinkStory',69,',open,biz,max,',',rnd,lite,','1',5),(263,'execution','updateOrder',53,',open,biz,max,',',rnd,lite,','1',1),(264,'execution','taskKanban',65,',open,biz,max,',',rnd,lite,','1',2),(265,'execution','printKanban',65,',open,biz,max,',',rnd,','1',4),(266,'execution','tree',345,',open,biz,max,',',rnd,lite,','1',1),(267,'execution','treeTask',345,',open,biz,max,',',rnd,lite,','1',2),(268,'execution','treeStory',345,',open,biz,max,',',rnd,lite,','1',3),(269,'execution','all',53,',open,biz,max,',',rnd,lite,','1',0),(270,'execution','export',56,',open,biz,max,',',rnd,lite,','1',225),(271,'execution','storyKanban',311,',open,biz,max,',',rnd,lite,','1',1),(272,'execution','storySort',69,',open,biz,max,',',rnd,lite,','1',6),(273,'execution','whitelist',57,',open,biz,max,',',rnd,lite,','1',240),(274,'execution','addWhitelist',57,',open,biz,max,',',rnd,lite,','1',245),(275,'execution','unbindWhitelist',57,',open,biz,max,',',rnd,lite,','1',250),(276,'execution','storyEstimate',69,',open,biz,max,',',rnd,','1',7),(277,'execution','executionkanban',65,',open,biz,max,',',rnd,','1',0),(278,'execution','kanban',65,',open,biz,max,',',rnd,lite,','1',1),(279,'execution','setKanban',65,',open,biz,max,',',rnd,','1',3),(280,'execution','doc',53,',open,biz,max,',',rnd,lite,','1',4),(281,'execution','storyView',311,',open,biz,max,',',rnd,','1',2),(282,'execution','calendar',347,',biz,max,',',rnd,lite,','1',6),(283,'execution','effortCalendar',53,',biz,max,',',rnd,','1',0),(284,'execution','effort',71,',biz,max,',',rnd,','1',255),(285,'execution','taskEffort',346,',biz,max,',',rnd,','1',4),(286,'execution','computeTaskEffort',346,',biz,max,',',rnd,','1',5),(287,'execution','deleterelation',308,',biz,max,',',rnd,','1',5),(288,'execution','maintainrelation',308,',biz,max,',',rnd,','1',3),(289,'execution','relation',308,',biz,max,',',rnd,','1',4),(290,'execution','gantt',58,',biz,max,',',rnd,lite,','1',0),(291,'execution','ganttsetting',58,',biz,max,',',rnd,','1',2),(292,'execution','ganttEdit',58,',biz,max,',',rnd,','1',1),(293,'kanban','space',283,',open,biz,max,',',rnd,lite,','1',0),(294,'kanban','createSpace',283,',open,biz,max,',',rnd,lite,','1',1),(295,'kanban','editSpace',283,',open,biz,max,',',rnd,lite,','1',2),(296,'kanban','closeSpace',283,',open,biz,max,',',rnd,lite,','1',4),(297,'kanban','deleteSpace',284,',open,biz,max,',',rnd,lite,','1',25),(299,'kanban','create',286,',open,biz,max,',',rnd,lite,','1',0),(300,'kanban','edit',286,',open,biz,max,',',rnd,lite,','1',1),(301,'kanban','view',285,',open,biz,max,',',rnd,lite,','1',45),(302,'kanban','close',286,',open,biz,max,',',rnd,lite,','1',3),(303,'kanban','delete',287,',open,biz,max,',',rnd,lite,','1',55),(304,'kanban','createRegion',286,',open,biz,max,',',rnd,lite,','1',14),(305,'kanban','editRegion',286,',open,biz,max,',',rnd,lite,','1',15),(306,'kanban','sortRegion',286,',open,biz,max,',',rnd,lite,','