SET global log_bin_trust_function_creators = 1;
SET global sql_mode = '';
USE `__TABLE__`;

-- DROP TABLE IF EXISTS `zt_acl`;
CREATE TABLE IF NOT EXISTS `zt_acl` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `type` char(40) NOT NULL DEFAULT 'whitelist',
  `source` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` text NULL,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime NULL,
  `comment` text NULL,
  `extra` text NULL,
  `read` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `efforted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_api_lib_release`;
CREATE TABLE IF NOT EXISTS `zt_api_lib_release` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `lib` int UNSIGNED NOT NULL DEFAULT 0,
  `desc` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `snap` mediumtext NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_api`;
CREATE TABLE IF NOT EXISTS `zt_api` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `lib` int UNSIGNED NOT NULL DEFAULT 0,
  `module` int UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10)  NOT NULL DEFAULT '',
  `method` varchar(10)  NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20)  NOT NULL DEFAULT '',
  `owner` varchar(30)  NOT NULl DEFAULT 0,
  `desc` mediumtext NULL,
  `version` smallint UNSIGNED NOT NULL DEFAULT 0,
  `params` text NULL,
  `paramsExample` text NUll,
  `responseExample` text NUll,
  `response` text NULL,
  `commonParams` text NULL,
  `addedBy` varchar(30)  NOT NULL DEFAULT 0,
  `addedDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum ('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apispec`;
CREATE TABLE IF NOT EXISTS `zt_apispec` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `doc` int UNSIGNED NOT NULL DEFAULT 0,
  `module` int UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10)  NOT NULL DEFAULT '',
  `method` varchar(10)  NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20)  NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULl DEFAULT 0,
  `desc` mediumtext NULL,
  `version` smallint UNSIGNED NOT NULL DEFAULT 0,
  `params` text NULL,
  `paramsExample` text NUll,
  `responseExample` text NUll,
  `response` text NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apistruct`;
CREATE TABLE IF NOT EXISTS `zt_apistruct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lib` int UNSIGNED NOT NULL DEFAULT 0,
  `name` varchar(30)  NOT NULL DEFAULT '',
  `type` varchar(50)  NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `version` smallint unsigned NOT NULL DEFAULT 0,
  `attribute` text NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum ('0', '1') NOT NULL DEFAULT '0',
  primary key (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apistruct_spec`;
CREATE TABLE IF NOT EXISTS `zt_apistruct_spec` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50)  NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `attribute` text NULL,
  `version` smallint unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NULL,
  primary key (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approval`;
CREATE TABLE IF NOT EXISTS `zt_approval` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL DEFAULT '0',
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `nodes` mediumtext NULL,
  `version` mediumint(9) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL DEFAULT 'doing',
  `result` varchar(20) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalflow`;
CREATE TABLE IF NOT EXISTS `zt_approvalflow` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `version` mediumint(8) NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalflowobject`;
CREATE TABLE IF NOT EXISTS `zt_approvalflowobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `root` int(8) NOT NULL DEFAULT '0',
  `flow` int(8) NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalflowspec`;
CREATE TABLE IF NOT EXISTS `zt_approvalflowspec` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL DEFAULT '0',
  `version` mediumint(8) NOT NULL DEFAULT '0',
  `nodes` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalnode`;
CREATE TABLE IF NOT EXISTS `zt_approvalnode` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `approval` mediumint(8) NOT NULL DEFAULT '0',
  `type` enum('review','cc') NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `account` char(30) NOT NULL DEFAULT '',
  `node` varchar(100) NOT NULL DEFAULT '',
  `reviewType` varchar(100)  NOT NULL DEFAULT 'manual',
  `multipleType` enum('and','or') NOT NULL DEFAULT 'and',
  `prev` mediumtext NULL,
  `next` mediumtext NULL,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  `result` varchar(10) NOT NULL DEFAULT '',
  `date` date NULL,
  `opinion` mediumtext NULL,
  `extra` mediumtext NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `idx_reviewed_date` (`reviewedDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalobject`;
CREATE TABLE IF NOT EXISTS `zt_approvalobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `approval` int(8) NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) NOT NULL DEFAULT '0',
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalrole`;
CREATE TABLE IF NOT EXISTS `zt_approvalrole` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `code` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` text NULL,
  `users` longtext NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_block`;
CREATE TABLE IF NOT EXISTS `zt_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `module` varchar(20) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `source` varchar(20) NOT NULL DEFAULT '',
  `block` varchar(30) NOT NULL DEFAULT '',
  `params` text NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `grid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `account_vision_module_type_order` ON `zt_block`(`account`,`vision`,`module`,`type`,`order`);
-- DROP TABLE IF EXISTS `zt_branch`;
CREATE TABLE IF NOT EXISTS `zt_branch` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `default` enum ('0', '1') NOT NULL DEFAULT '0',
  `status` enum ('active', 'closed') NOT NULL DEFAULT 'active',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `createdDate` date NULL,
  `closedDate` date NULL,
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `injection` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `identify` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `plan` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `story` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `storyVersion` smallint(6) NOT NULL DEFAULT '1',
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `toTask` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `toStory` mediumint(8) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `severity` tinyint(4) NOT NULL DEFAULT '0',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT '',
  `os` varchar(255) NOT NULL DEFAULT '',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `hardware` varchar(30) NOT NULL DEFAULT '',
  `found` varchar(30) NOT NULL DEFAULT '',
  `steps` mediumtext NULL,
  `status` enum('active','resolved','closed') NOT NULL DEFAULT 'active',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `activatedCount` smallint(6) NOT NULL DEFAULT '0',
  `activatedDate` datetime NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `mailto` text NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `deadline` date NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolvedBuild` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `linkBug` varchar(255) NOT NULL DEFAULT '',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `caseVersion` smallint(6) NOT NULL DEFAULT '1',
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `result` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `repo` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `mr` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry` text NULL,
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(40) NOT NULL DEFAULT '',
  `v2` varchar(40) NOT NULL DEFAULT '',
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `issueKey` varchar(50) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `builds` varchar(255) NOT NULL DEFAULT '',
  `name` char(150) NOT NULL DEFAULT '',
  `scmPath` char(255) NOT NULL DEFAULT '',
  `filePath` char(255) NOT NULL DEFAULT '',
  `date` date NULL,
  `stories` text NULL,
  `bugs` text NULL,
  `builder` char(30) NOT NULL default '',
  `desc` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `estimate` float NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `storyPoint` float NOT NULL DEFAULT '0',
  PRIMARY KEY  (`execution`,`date`,`task`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `lib` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL DEFAULT '',
  `precondition` text NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `type` char(30) NOT NULL default '1',
  `auto` varchar(10) NOT NULL default 'no',
  `frame` varchar(10) NOT NULL DEFAULT '',
  `stage` varchar(255) NOT NULL DEFAULT '',
  `howRun` varchar(30) NOT NULL DEFAULT '',
  `script` longtext NULL,
  `scriptedBy` varchar(30) NOT NULL DEFAULT '',
  `scriptedDate` date NULL,
  `scriptStatus` varchar(30) NOT NULL DEFAULT '',
  `scriptLocation` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL default '1',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL DEFAULT '',
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` date NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL DEFAULT '',
  `fromBug` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromCaseID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromCaseVersion` mediumint(8) unsigned NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime NULL,
  `lastRunResult` char(30) NOT NULL DEFAULT '',
  `scene` int(11) NOT NULL default '0',
  `sort` int(11) NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_casestep`;
CREATE TABLE IF NOT EXISTS `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text NULL,
  `expect` text NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_cfd`;
CREATE TABLE IF NOT EXISTS `zt_cfd` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `execution` int(8) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `count` smallint NOT NULL DEFAULT '0',
  `date` date NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `execution_type_name_date` ON `zt_cfd`(`execution`,`type`,`name`,`date`);
-- DROP TABLE IF EXISTS `zt_chart`;
CREATE TABLE IF NOT EXISTS `zt_chart` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `dimension` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT '',
  `group` varchar(255) NOT NULL DEFAULT '',
  `dataset` varchar(30) NOT NULL DEFAULT '0',
  `desc` text NULL,
  `settings` mediumtext NULL,
  `filters` mediumtext NULL,
  `step` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `fields` mediumtext NULL,
  `langs` text NULL,
  `sql` mediumtext NULL,
  `stage` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `objects` mediumtext NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_screen`;
CREATE TABLE IF NOT EXISTS `zt_screen` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `cover` mediumtext NULL,
  `scheme` mediumtext NULL,
  `status` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dimension`;
CREATE TABLE IF NOT EXISTS `zt_dimension` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `desc` text NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_compile`;
CREATE TABLE IF NOT EXISTS `zt_compile` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `job` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `queue` mediumint(8) NOT NULL DEFAULT '0',
  `status` varchar(255) NOT NULL DEFAULT '',
  `logs` text NULL,
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(255) NOT NULL DEFAULT '',
  `times` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `updateDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `vision` varchar(10) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL default '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` longtext NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `unique` ON `zt_config`(`vision`,`owner`,`module`,`section`,`key`);
-- DROP TABLE IF EXISTS `zt_cron`;
CREATE TABLE IF NOT EXISTS `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL DEFAULT '',
  `h` varchar(20) NOT NULL DEFAULT '',
  `dom` varchar(20) NOT NULL DEFAULT '',
  `mon` varchar(20) NOT NULL DEFAULT '',
  `dow` varchar(20) NOT NULL DEFAULT '',
  `command` text NULL,
  `remark` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL DEFAULT '',
  `lastTime` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dashboard`;
CREATE TABLE `zt_dashboard` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `dimension` int(8) NOT NULL default 0,
  `module` mediumint NOT NULL DEFAULT '0',
  `desc` mediumtext NULL,
  `layout` mediumtext NULL,
  `filters` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dataset`;
CREATE TABLE `zt_dataset` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(155) NOT NULL DEFAULT '',
  `sql` text NULL,
  `fields` mediumtext NULL,
  `objects` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dataview`;
CREATE TABLE IF NOT EXISTS `zt_dataview` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(155) NOT NULL DEFAULT '',
  `code` varchar(50) NOT NULL DEFAULT '',
  `view` varchar(57) NOT NULL DEFAULT '',
  `sql` text NULL,
  `fields` mediumtext NULL,
  `langs` text NULL,
  `objects` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(60) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(4) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_design`;
CREATE TABLE IF NOT EXISTS `zt_design` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '',
  `product` varchar(255) NOT NULL DEFAULT '',
  `commit` text NULL,
  `commitedBy` varchar(30) NOT NULL DEFAULT '',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `story` char(30) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `version` smallint(6) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_designspec`;
CREATE TABLE IF NOT EXISTS `zt_designspec` (
  `design` mediumint(8) NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `files` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `design` ON `zt_designspec`(`design`,`version`);
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lib` varchar(30) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `templateType` varchar(30) NOT NULL DEFAULT '',
  `chapterType` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) COLLATE 'utf8_general_ci' NOT NULL DEFAULT 'normal',
  `parent` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `views` smallint(5) unsigned NOT NULL DEFAULT '0',
  `assetLib` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `assetLibType` varchar(30) NOT NULL DEFAULT '',
  `from` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fromVersion` smallint(6) NOT NULL DEFAULT '1',
  `draft` longtext NULL,
  `collects` smallint(5) unsigned NOT NULL DEFAULT '0',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `approvedDate` date NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `editingDate` text NULL,
  `mailto` text NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text NULL,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_docaction`;
CREATE TABLE IF NOT EXISTS `zt_docaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `action` varchar(80) NOT NULL DEFAULT '',
  `actor` char(30) NOT NULL DEFAULT '',
  `date` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `doc` (`doc`),
  KEY `actor` (`actor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doccontent`;
CREATE TABLE IF NOT EXISTS `zt_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `digest` varchar(255) NOT NULL DEFAULT '',
  `content` longtext NULL,
  `files` text NULL,
  `type` varchar(10) NOT NULL DEFAULT '',
  `version` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `doc_version` ON `zt_doccontent`(`doc`,`version`);
-- DROP TABLE IF EXISTS `zt_doclib`;
CREATE TABLE IF NOT EXISTS `zt_doclib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `type` varchar(30) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(60) NOT NULL DEFAULT '',
  `baseUrl` varchar(255) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text NULL,
  `main` enum('0','1') NOT NULL DEFAULT '0',
  `collector` text NULL,
  `desc` mediumtext NULL,
  `order` tinyint(5) unsigned NOT NULL DEFAULT '0',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` text NULL,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `account` varchar(30) NOT NULL DEFAULT '',
  `work` text NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `date` date NULL,
  `left` float NOT NULL DEFAULT '0',
  `consumed` float NOT NULL DEFAULT '0',
  `begin` smallint(4) unsigned zerofill NOT NULL DEFAULT '0',
  `end` smallint(4) unsigned zerofill NOT NULL DEFAULT '0',
  `extra` text NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `objectID` (`objectID`),
  KEY `date` (`date`),
  KEY `account` (`account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_entry`;
CREATE TABLE IF NOT EXISTS `zt_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL DEFAULT '',
  `key` varchar(32) NOT NULL DEFAULT '',
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `calledTime` int(10) unsigned NOT NULL DEFAULT '0',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_expect`;
CREATE TABLE IF NOT EXISTS `zt_expect` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `userID` mediumint(8) NOT NULL DEFAULT '0',
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `expect` text NULL,
  `progress` text NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `author` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `license` text NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL DEFAULT '',
  `zentaoCompatible` varchar(100) NOT NULL DEFAULT '',
  `installedTime` datetime NULL,
  `depends` varchar(100) NOT NULL DEFAULT '',
  `dirs` mediumtext NULL,
  `files` mediumtext NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY  (`id`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `code` ON `zt_extension`(`code`);
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pathname` char(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `extension` char(30) NOT NULL DEFAULT '',
  `size` int(10) unsigned NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime NULL,
  `downloads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `extra` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `name` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `desc` char(255) NOT NULL DEFAULT '',
  `acl` text NULL,
  `developer` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_grouppriv`;
CREATE TABLE IF NOT EXISTS `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `group` ON `zt_grouppriv`(`group`,`module`,`method`);
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` mediumtext NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` int(9) unsigned NOT NULL auto_increment,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NULL,
  `new` text NULL,
  `diff` mediumtext NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_job`;
CREATE TABLE IF NOT EXISTS `zt_job` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `repo` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `frame` varchar(20) NOT NULL DEFAULT '',
  `engine` varchar(20) NOT NULL DEFAULT '',
  `server` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pipeline` varchar(500) NOT NULL DEFAULT '',
  `triggerType` varchar(255) NOT NULL DEFAULT '',
  `sonarqubeServer` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `projectKey` varchar(255) NOT NULL DEFAULT '',
  `svnDir` varchar(255) NOT NULL DEFAULT '',
  `atDay` varchar(255) NOT NULL DEFAULT '',
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `customParam` text NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `lastExec` datetime NULL,
  `lastStatus` varchar(255) NOT NULL DEFAULT '',
  `lastTag` varchar(255) NOT NULL DEFAULT '',
  `lastSyncDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbanspace`;
CREATE TABLE IF NOT EXISTS `zt_kanbanspace` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text NULL,
  `desc` mediumtext NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NULL,
  `status` enum('active','closed') NOT NULL default 'active',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanban`;
CREATE TABLE IF NOT EXISTS `zt_kanban` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text NULL,
  `desc` mediumtext NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NULL,
  `archived` enum('0', '1') NOT NULL DEFAULT '1',
  `performable` enum ('0', '1') NOT NULL DEFAULT '0',
  `status` enum('active','closed') NOT NULL default 'active',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `displayCards` smallint(6) NOT NULL default '0',
  `showWIP` enum('0','1') NOT NULL DEFAULT '1',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `colWidth` smallint(4) NOT NULL DEFAULT '264',
  `minColWidth` smallint(4) NOT NULL DEFAULT '200',
  `maxColWidth` smallint(4) NOT NULL DEFAULT '384',
  `object` varchar(255) NOT NULL DEFAULT '',
  `alignment` varchar(10) NOT NULL default 'center',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbanregion`;
CREATE TABLE IF NOT EXISTS `zt_kanbanregion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `kanban` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbancard`;
CREATE TABLE IF NOT EXISTS `zt_kanbancard` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `region` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `group` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fromID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fromType` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'doing',
  `pri` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `assignedTo` text NULL,
  `desc` mediumtext NULL,
  `begin` date NULL,
  `end` date NULL,
  `estimate` float unsigned NOT NULL DEFAULT '0',
  `progress` float unsigned NOT NULL DEFAULT '0',
  `color` char(7) NOT NULL DEFAULT '',
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NULL,
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `archived` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `archivedBy` char(30) NOT NULL DEFAULT '',
  `archivedDate` datetime NULL,
  `assignedBy` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbancell`;
CREATE TABLE IF NOT EXISTS `zt_kanbancell` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) NOT NULL DEFAULT '0',
  `lane` mediumint(8) NOT NULL DEFAULT '0',
  `column` mediumint(8) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `cards` text NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `card_group` ON `zt_kanbancell`(`kanban`,`type`,`lane`,`column`);

-- DROP TABLE IF EXISTS `zt_kanbangroup`;
CREATE TABLE IF NOT EXISTS `zt_kanbangroup` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `region` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `order` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbanlane`;
CREATE TABLE IF NOT EXISTS `zt_kanbanlane` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `execution` mediumint(8) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `region` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `group` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `groupby` char(30) NOT NULL DEFAULT '',
  `extra` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL DEFAULT '',
  `order` smallint(6) NOT NULL DEFAULT '0',
  `lastEditedTime` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbancolumn`;
CREATE TABLE IF NOT EXISTS `zt_kanbancolumn` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT '',
  `region` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `group` mediumint(8) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL DEFAULT '',
  `limit` smallint(6) NOT NULL DEFAULT '-1',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `archived` enum('0', '1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lang`;
CREATE TABLE IF NOT EXISTS `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `lang` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(60) NOT NULL DEFAULT '',
  `value` text NULL,
  `system` enum('0','1') NOT NULL default '1',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `lang` ON `zt_lang`(`lang`,`module`,`section`,`key`,`vision`);

-- DROP TABLE IF EXISTS `zt_log`;
CREATE TABLE IF NOT EXISTS `zt_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `action` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` datetime NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT '',
  `data` text NULL,
  `result` text  NOT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL DEFAULT '',
  `from` mediumint(8) unsigned NOT NULL default '0',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `collector` text NULL,
  `short` varchar(30) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_mr`;
CREATE TABLE IF NOT EXISTS `zt_mr` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `hostID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `sourceProject` varchar(50) NOT NULL DEFAULT '',
  `sourceBranch` varchar(100) NOT NULL DEFAULT '',
  `targetProject` varchar(50) NOT NULL DEFAULT '',
  `targetBranch` varchar(100) NOT NULL DEFAULT '',
  `mriid` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NULL,
  `assignee` varchar(255) NOT NULL DEFAULT '',
  `reviewer` varchar(255) NOT NULL DEFAULT '',
  `approver` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `status` char(30) NOT NULL DEFAULT '',
  `mergeStatus` char(30) NOT NULL DEFAULT '',
  `approvalStatus` char(30) NOT NULL DEFAULT '',
  `needApproved` enum('0','1') NOT NULL DEFAULT '0',
  `needCI` enum('0','1') NOT NULL DEFAULT '0',
  `repoID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `jobID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `compileID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `compileStatus` char(30) NOT NULL DEFAULT '',
  `removeSourceBranch` enum('0','1') NOT NULL DEFAULT '0',
  `squash` enum('0','1') NOT NULL DEFAULT '0',
  `synced` enum('0','1') COLLATE 'utf8_general_ci' NOT NULL DEFAULT '1',
  `syncError` varchar(255) NOT NULL DEFAULT '',
  `hasNoConflict` enum('0','1') COLLATE 'utf8_general_ci' NOT NULL DEFAULT '0',
  `diffs` longtext COLLATE 'utf8_general_ci' NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_mrapproval`;
CREATE TABLE IF NOT EXISTS `zt_mrapproval` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mrID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `account` varchar(255) NOT NULL DEFAULT '',
  `date` datetime NULL,
  `action` char(30) NOT NULL DEFAULT '',
  `comment` text NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_notify`;
CREATE TABLE IF NOT EXISTS `zt_notify` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL DEFAULT '',
  `objectID` mediumint unsigned NOT NULL DEFAULT '0',
  `action` mediumint NOT NULL DEFAULT '0',
  `toList` varchar(255) NOT NULL DEFAULT '',
  `ccList` text NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `data` text NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `sendTime` datetime NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text NULL,
  PRIMARY KEY (`id`),
  KEY `objectType_toList_status` (`objectType`,`toList`,`status`)
) ENGINE='InnoDB' COLLATE 'utf8_general_ci';
-- DROP TABLE IF EXISTS `zt_oauth`;
CREATE TABLE IF NOT EXISTS `zt_oauth` (
  `account` varchar(30) NOT NULL DEFAULT '',
  `openID` varchar(255) NOT NULL DEFAULT '',
  `providerType` varchar(30) NOT NULL DEFAULT '',
  `providerID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_pipeline`;
CREATE TABLE IF NOT EXISTS `zt_pipeline` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) NULL,
  `account` varchar(30) NULL,
  `password` varchar(255) NULL,
  `token` varchar(255) NULL,
  `private` char(32) NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_planstory`;
CREATE TABLE IF NOT EXISTS `zt_planstory` (
  `plan` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `story` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `order` mediumint(9) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `plan_story` ON `zt_planstory`(`plan`,`story`);
-- DROP TABLE IF EXISTS `zt_priv`;
CREATE TABLE IF NOT EXISTS `zt_priv` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL,
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `system` enum('0','1') NOT NULL DEFAULT '0',
  `order` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `priv` (`module`,`method`)
) ENGINE=InnoDB AUTO_INCREMENT=1768 DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_privmanager`;
CREATE TABLE IF NOT EXISTS `zt_privmanager` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) unsigned NOT NULL,
  `code` varchar(100) NOT NULL,
  `type` enum('view','module','package') NOT NULL DEFAULT 'package',
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `order` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_privlang`;
CREATE TABLE IF NOT EXISTS `zt_privlang` (
  `objectID` mediumint(8) unsigned NOT NULL,
  `objectType` enum('priv','manager') NOT NULL DEFAULT 'priv',
  `lang` varchar(30) NOT NULL,
  `key` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  `desc` text NULL,
  UNIQUE KEY `objectlang` (`objectID`,`objectType`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_privrelation`;
CREATE TABLE IF NOT EXISTS `zt_privrelation` (
  `priv` mediumint(8) unsigned NOT NULL,
  `type` varchar(30) NOT NULL,
  `relationPriv` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `privrelation`(`priv`, `type`, `relationPriv`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `program` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(110) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `shadow` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `bind` enum('0','1') NOT NULL DEFAULT '0',
  `line` mediumint(8) NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `feedback` varchar(30) NOT NULL DEFAULT '',
  `ticket` varchar(30) NOT NULL DEFAULT '',
  `acl` enum('open','private','custom') NOT NULL DEFAULT 'open',
  `whitelist` text NULL,
  `reviewer` text NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `createdVersion` varchar(20) NOT NULL DEFAULT '',
  `order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productplan`;
CREATE TABLE IF NOT EXISTS `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `parent` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(90) NOT NULL DEFAULT '',
  `status` enum('wait','doing','done','closed') NOT NULL default 'wait',
  `desc` mediumtext NULL,
  `begin` date NULL,
  `end` date NULL,
  `order` text NULL,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `model` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT 'sprint',
  `lifetime` char(30) NOT NULL DEFAULT '',
  `budget` varchar(30) NOT NULL DEFAULT '0',
  `budgetUnit` char(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` float unsigned NOT NULL DEFAULT '0',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `output` text NULL,
  `auth` char(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `hasProduct` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `begin` date NULL,
  `end` date NULL,
  `realBegan` date NULL,
  `realEnd` date NULL,
  `days` smallint(5) unsigned NOT NULL DEFAULT 0,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `pri` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `desc` mediumtext NULL,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `parentVersion` smallint(6) NOT NULL DEFAULT 0,
  `planDuration` int(11) NOT NULL DEFAULT 0,
  `realDuration` int(11) NOT NULL DEFAULT 0,
  `progress` decimal(5,2) NOT NULL DEFAULT '0',
  `estimate` float NOT NULL DEFAULT '0',
  `left` float NOT NULL DEFAULT '0',
  `consumed` float NOT NULL DEFAULT '0',
  `teamCount` int NOT NULL DEFAULT '0',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `openedVersion` varchar(20) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime NULL,
  `suspendedDate` date NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL DEFAULT '',
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `division` enum('0','1') NOT NULL DEFAULT '1',
  `displayCards` smallint(6) NOT NULL default '0',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `multiple` enum('0','1') NOT NULL DEFAULT '1',
  `colWidth` smallint(4) NOT NULL DEFAULT '264',
  `minColWidth` smallint(4) NOT NULL DEFAULT '200',
  `maxColWidth` smallint(4) NOT NULL DEFAULT '384',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectadmin`;
CREATE TABLE IF NOT EXISTS `zt_projectadmin` (
  `group` smallint(6) NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `programs` text NULL,
  `projects` text NULL,
  `products` text NULL,
  `executions` text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `group_account` ON `zt_projectadmin`(`group`, `account`);
-- DROP TABLE IF EXISTS `zt_projectcase`;
CREATE TABLE IF NOT EXISTS `zt_projectcase` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `version` smallint(6) NOT NULL DEFAULT '1',
  `order` smallint(6) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `project` ON `zt_projectcase`(`project`,`case`);
-- DROP TABLE IF EXISTS `zt_projectproduct`;
CREATE TABLE IF NOT EXISTS `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `plan` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY  (`project`, `product`, `branch`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectspec`;
CREATE TABLE IF NOT EXISTS `zt_projectspec` (
  `project` mediumint(8) NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `begin` date NULL,
  `end` date NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `project` ON `zt_projectspec`(`project`,`version`);
-- DROP TABLE IF EXISTS `zt_projectstory`;
CREATE TABLE IF NOT EXISTS `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  `order` smallint(6) unsigned NOT NULL DEFAULT '0',
  KEY `story` (`story`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `project` ON `zt_projectstory`(`project`,`story`);
-- DROP TABLE IF EXISTS `zt_relation`;
CREATE TABLE IF NOT EXISTS `zt_relation` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT '0',
  `product` mediumint(8) NOT NULL DEFAULT '0',
  `execution` mediumint(8) NOT NULL DEFAULT '0',
  `AType` char(30) NOT NULL DEFAULT '',
  `AID` mediumint(8) NOT NULL DEFAULT '0',
  `AVersion` char(30) NOT NULL DEFAULT '',
  `relation` char(30) NOT NULL DEFAULT '',
  `BType` char(30) NOT NULL DEFAULT '',
  `BID` mediumint(8) NOT NULL DEFAULT '0',
  `BVersion` char(30) NOT NULL DEFAULT '',
  `extra` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE='InnoDB' DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `relation` ON `zt_relation`(`product`,`relation`,`AType`,`BType`, `AID`, `BID`);
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` varchar(255) NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` varchar(255) NOT NULL default '0',
  `shadow` mediumint(8) unsigned NOT NULL default '0',
  `build` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL default '',
  `marker` enum('0','1') NOT NULL default '0',
  `date` date NULL,
  `stories` text NULL,
  `bugs` text NULL,
  `leftBugs` text NULL,
  `desc` mediumtext NULL,
  `mailto` text NULL,
  `notify` varchar(255) NOT NULL default '',
  `status` varchar(20) NOT NULL default 'normal',
  `subStatus` varchar(30) NOT NULL default '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `projects` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `prefix` varchar(100) NOT NULL DEFAULT '',
  `encoding` varchar(20) NOT NULL DEFAULT '',
  `SCM` varchar(10) NOT NULL DEFAULT '',
  `client` varchar(100) NOT NULL DEFAULT '',
  `serviceHost` varchar(50) NOT NULL DEFAULT '',
  `serviceProject` varchar(100) NOT NULL DEFAULT '',
  `commits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `account` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(30) NOT NULL DEFAULT '',
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NULL,
  `desc` text NULL,
  `extra` char(30) NOT NULL DEFAULT '',
  `preMerge` enum('0','1') COLLATE 'utf8_general_ci' NOT NULL DEFAULT '0',
  `job` mediumint unsigned NOT NULL DEFAULT '0',
  `fileServerUrl` text COLLATE 'utf8_general_ci' NULL,
  `fileServerAccount` varchar(40) NOT NULL default '',
  `fileServerPassword` varchar(100) NOT NULL default '',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repobranch`;
CREATE TABLE IF NOT EXISTS `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `revision` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` varchar(255) NOT NULL DEFAULT '',
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `repo_revision_branch` ON `zt_repobranch`(`repo`,`revision`,`branch`);
-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE IF NOT EXISTS `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `revision` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `oldPath` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `action` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL DEFAULT '0',
  `revision` varchar(40) NOT NULL DEFAULT '',
  `commit` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment` text NULL,
  `committer` varchar(100) NOT NULL DEFAULT '',
  `time` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_score`;
CREATE TABLE IF NOT EXISTS `zt_score` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `after` int(11) NOT NULL DEFAULT '0',
  `time` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `model` (`module`),
  KEY `method` (`method`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_searchdict`;
CREATE TABLE IF NOT EXISTS `zt_searchdict` (
  `key` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_searchindex`;
CREATE TABLE IF NOT EXISTS `zt_searchindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `objectType` char(20) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `title` text NULL,
  `content` text NULL,
  `addedDate` datetime NULL,
  `editedDate` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `title_content` (`title`, `content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `object` ON `zt_searchindex`(`objectType`,`objectID`);
-- DROP TABLE IF EXISTS `zt_stage`;
CREATE TABLE IF NOT EXISTS `zt_stage` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `percent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_stakeholder`;
CREATE TABLE IF NOT EXISTS `zt_stakeholder` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `objectID` mediumint(8) NOT NULL DEFAULT '0',
  `objectType` char(30) NOT NULL DEFAULT '',
  `user` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `key` enum('0','1') NOT NULL,
  `from` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` date NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `parent` mediumint(9) NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `plan` text NULL,
  `source` varchar(20) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `fromBug` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'story',
  `category` varchar(30) NOT NULL DEFAULT 'feature',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT '3',
  `estimate` float unsigned NOT NULL,
  `status` enum('','changing','active','draft','reviewing','closed') NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `stage` enum('','wait','planned','projected','developing','developed','testing','tested','verified','released','closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL DEFAULT '',
  `mailto` text NULL,
  `lib` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fromStory` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fromVersion` smallint(6) NOT NULL DEFAULT '1',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `approvedDate` date NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `changedBy` varchar(30) NOT NULL DEFAULT '',
  `changedDate` datetime NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime NULL,
  `toBug` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `childStories` varchar(255) NOT NULL DEFAULT '',
  `linkStories` varchar(255) NOT NULL DEFAULT '',
  `linkRequirements` varchar(255) NOT NULL DEFAULT '',
  `twins` varchar(255) NOT NULL DEFAULT '',
  `duplicateStory` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '1',
  `storyChanged` enum('0','1') NOT NULL DEFAULT '0',
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `URChanged` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyreview`;
CREATE TABLE IF NOT EXISTS `zt_storyreview` (
  `story` mediumint(9) NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '0',
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `story` ON `zt_storyreview`(`story`,`version`,`reviewer`);
-- DROP TABLE IF EXISTS `zt_storyestimate`;
CREATE TABLE IF NOT EXISTS `zt_storyestimate` (
  `story` mediumint(9) NOT NULL DEFAULT '0',
  `round` smallint(6) NOT NULL DEFAULT '0',
  `estimate` text NULL,
  `average` float NOT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `story` ON `zt_storyestimate`(`story`,`round`);
-- DROP TABLE IF EXISTS `zt_storyspec`;
CREATE TABLE IF NOT EXISTS `zt_storyspec` (
  `story` mediumint(9) NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext NULL,
  `verify` mediumtext NULL,
  `files` text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `story` ON `zt_storyspec`(`story`,`version`);
-- DROP TABLE IF EXISTS `zt_storystage`;
CREATE TABLE IF NOT EXISTS `zt_storystage` (
  `story` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `branch` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `stage` varchar(50) NOT NULL DEFAULT '',
  `stagedBy` char(30) NOT NULL DEFAULT '',
  KEY `story` (`story`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `story_branch` ON `zt_storystage`(`story`,`branch`);
-- DROP TABLE IF EXISTS `zt_suitecase`;
CREATE TABLE IF NOT EXISTS `zt_suitecase` (
  `suite` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `version` smallint(5) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `suitecase` ON `zt_suitecase`(`suite`,`case`);
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `design` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `story` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `storyVersion` smallint(6) NOT NULL DEFAULT '1',
  `designVersion` smallint(6) unsigned NOT NULL DEFAULT '1',
  `fromBug` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `fromIssue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `mode` varchar(10) NOT NULL DEFAULT '',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL DEFAULT '0',
  `left` float unsigned NOT NULL,
  `deadline` date NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL DEFAULT 'wait',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `mailto` text NULL,
  `desc` mediumtext NULL,
  `version` smallint(6) NOT NULL DEFAULT '0',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `estStarted` date NULL,
  `realStarted` datetime NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NULL,
  `finishedList` text NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `planDuration` int(11) NOT NULL DEFAULT '0',
  `realDuration` int(11) NOT NULL DEFAULT '0',
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `activatedDate` datetime NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `repo` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `mr` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry` varchar(255) NOT NULL DEFAULT '',
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(40) NOT NULL DEFAULT '',
  `v2` varchar(40) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `assignedTo` (`assignedTo`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskestimate`;
CREATE TABLE IF NOT EXISTS `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` date NULL,
  `left` float unsigned NOT NULL default '0',
  `consumed` float unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `work` text NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskspec`;
CREATE TABLE IF NOT EXISTS `zt_taskspec` (
  `task` mediumint(8) NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `estStarted` date NULL,
  `deadline` date NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `task` ON `zt_taskspec`(`task`,`version`);
-- DROP TABLE IF EXISTS `zt_taskteam`;
CREATE TABLE `zt_taskteam` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `estimate` decimal(12,2) NOT NULL DEFAULT '0.00',
  `consumed` decimal(12,2) NOT NULL DEFAULT '0.00',
  `left` decimal(12,2) NOT NULL DEFAULT '0.00',
  `transfer` char(30) NOT NULL DEFAULT '',
  `status` enum('wait','doing','done') NOT NULL DEFAULT 'wait',
  `order` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `root` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` enum('project','task','execution') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `limited` char(8) NOT NULL DEFAULT 'no',
  `join` date NULL,
  `days` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hours` float(3,1) unsigned NOT NULL DEFAULT '0.0',
  `estimate` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `consumed` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `left` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `order` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `team` ON `zt_team`(`root`,`type`,`account`);
-- DROP TABLE IF EXISTS `zt_testreport`;
CREATE TABLE IF NOT EXISTS `zt_testreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `tasks` varchar(255) NOT NULL DEFAULT '',
  `builds` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  `owner` char(30) NOT NULL DEFAULT '',
  `members` text NULL,
  `stories` text NULL,
  `bugs` text NULL,
  `cases` text NULL,
  `report` text NULL,
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testresult`;
CREATE TABLE IF NOT EXISTS `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `run` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `version` smallint(5) unsigned NOT NULL DEFAULT '0',
  `job` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `compile` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `caseResult` char(30) NOT NULL DEFAULT '',
  `stepResults` text NULL,
  `ZTFResult` text NULL,
  `node` int(8) unsigned NOT NULL DEFAULT '0',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NULL,
  `duration` float NOT NULL DEFAULT '0',
  `xml` text NULL,
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testrun`;
CREATE TABLE IF NOT EXISTS `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime NULL,
  `lastRunResult` char(30) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `task` ON `zt_testrun`(`task`,`case`);
-- DROP TABLE IF EXISTS `zt_testsuite`;
CREATE TABLE IF NOT EXISTS `zt_testsuite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `order` smallint unsigned NOT NULL DEFAULT '0',
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testtask`;
CREATE TABLE IF NOT EXISTS `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` char(90) NOT NULL DEFAULT '',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `begin` date NULL,
  `end` date NULL,
  `realFinishedDate` datetime NULL,
  `mailto` text NULL,
  `desc` mediumtext NULL,
  `report` text NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `testreport` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL default '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `date` date NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL DEFAULT '0',
  `end` smallint(4) unsigned zerofill NOT NULL DEFAULT '0',
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` char(15) NOT NULL DEFAULT '',
  `cycle` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `idvalue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `name` char(150) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `config` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `company` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL DEFAULT 'inside',
  `dept` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `role` char(10) NOT NULL DEFAULT '',
  `realname` varchar(100) NOT NULL DEFAULT '',
  `pinyin` varchar(255) NOT NULL DEFAULT '',
  `nickname` char(60) NOT NULL DEFAULT '',
  `commiter` varchar(100) NOT NULL DEFAULT '',
  `avatar` text NULL,
  `birthday` date NULL,
  `gender` enum('f','m') NOT NULL DEFAULT 'f',
  `email` char(90) NOT NULL DEFAULT '',
  `skype` char(90) NOT NULL DEFAULT '',
  `qq` char(20) NOT NULL DEFAULT '',
  `mobile` char(11) NOT NULL DEFAULT '',
  `phone` char(20) NOT NULL DEFAULT '',
  `weixin` varchar(90) NOT NULL DEFAULT '',
  `dingding` varchar(90) NOT NULL DEFAULT '',
  `slack` varchar(90) NOT NULL DEFAULT '',
  `whatsapp` varchar(90) NOT NULL DEFAULT '',
  `address` char(120) NOT NULL DEFAULT '',
  `zipcode` char(10) NOT NULL DEFAULT '',
  `nature` text NULL,
  `analysis` text NULL,
  `strategy` text NULL,
  `join` date NULL,
  `visits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `visions` varchar(20) NOT NULL DEFAULT 'rnd,lite',
  `ip` char(15) NOT NULL DEFAULT '',
  `last` int(10) unsigned NOT NULL DEFAULT '0',
  `fails` tinyint(5) NOT NULL DEFAULT '0',
  `locked` datetime NULL,
  `feedback` enum('0','1') NOT NULL DEFAULT '0',
  `ranzhi` char(30) NOT NULL DEFAULT '',
  `ldap` char(30) NOT NULL DEFAULT '',
  `score` int(11) NOT NULL DEFAULT '0',
  `scoreLevel` int(11) NOT NULL DEFAULT '0',
  `resetToken` varchar(50) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `clientStatus` enum('online','away','busy','offline','meeting') NOT NULL DEFAULT 'offline',
  `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn',
  PRIMARY KEY (`id`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `account` ON `zt_user`(`account`);
-- DROP TABLE IF EXISTS `zt_usercontact`;
CREATE TABLE IF NOT EXISTS `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL DEFAULT '',
  `listName` varchar(60) NOT NULL DEFAULT '',
  `userList` text NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usergroup`;
CREATE TABLE IF NOT EXISTS `zt_usergroup` (
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  `project` text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `account` ON `zt_usergroup`(`account`,`group`);
-- DROP TABLE IF EXISTS `zt_userquery`;
CREATE TABLE IF NOT EXISTS `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(90) NOT NULL DEFAULT '',
  `form` text NULL,
  `sql` text NULL,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  `common` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usertpl`;
CREATE TABLE IF NOT EXISTS `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `title` varchar(150) NOT NULL DEFAULT '',
  `content` text NULL,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userview`;
CREATE TABLE IF NOT EXISTS `zt_userview` (
  `account` char(30) NOT NULL DEFAULT '',
  `programs` mediumtext NULL,
  `products` mediumtext NULL,
  `projects` mediumtext NULL,
  `sprints` mediumtext NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `account` ON `zt_userview`(`account`);
-- DROP TABLE IF EXISTS `zt_weeklyreport`;
CREATE TABLE IF NOT EXISTS `zt_weeklyreport`(
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `weekStart` date NULL,
  `pv` float(9,2) NOT NULL,
  `ev` float(9,2) NOT NULL,
  `ac` float(9,2) NOT NULL,
  `sv` float(9,2) NOT NULL,
  `cv` float(9,2) NOT NULL,
  `staff` smallint(5) unsigned NOT NULL DEFAULT '0',
  `progress` varchar(255) NOT NULL DEFAULT '',
  `workload` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `week` ON `zt_weeklyreport`(`project`,`weekStart`);
-- DROP TABLE IF EXISTS `zt_webhook`;
CREATE TABLE IF NOT EXISTS `zt_webhook` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `secret` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text NULL,
  `executions` text NULL,
  `params` varchar(100) NOT NULL DEFAULT '',
  `actions` text NULL,
  `desc` text NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`) VALUES
('*',    '*',    '*',    '*',    '*',    '', '监控定时任务', 'zentao', 1, 'normal'),
('30',   '23',   '*',    '*',    '*',    'moduleName=execution&methodName=computeburn', '更新燃尽图',    'zentao', 1, 'normal'),
('30',   '23',   '*',    '*',    '*',    'moduleName=execution&methodName=computecfd', '更新累积流图',   'zentao', 1, 'normal'),
('0',    '8',    '*',    '*',    '*',    'moduleName=report&methodName=remind',       '每日任务提醒',    'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=svn&methodName=run',             '同步SVN',         'zentao', 1, 'stop'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=git&methodName=run',             '同步GIT',         'zentao', 1, 'stop'),
('30',   '0',    '*',    '*',    '*',    'moduleName=backup&methodName=backup',       '备份数据和附件',  'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mail&methodName=asyncSend',      '异步发信',        'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=webhook&methodName=asyncSend',   '异步发送Webhook', 'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=admin&methodName=deleteLog',     '删除过期日志',    'zentao', 1, 'normal'),
('1',    '1',    '*',    '*',    '*',    'moduleName=todo&methodName=createCycle',    '生成周期性待办',  'zentao', 1, 'normal'),
('1',    '0',    '*',    '*',    '*',    'moduleName=ci&methodName=initQueue', '创建周期性任务', 'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=checkCompileStatus', '同步DevOps构建任务状态', 'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=exec', '执行DevOps构建任务', 'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mr&methodName=syncMR', '定时同步GitLab合并数据到禅道数据库', 'zentao', 1, 'normal'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=compile&methodName=syncCompile', '定时同步构建记录', 'zentao', 1, 'normal');

INSERT INTO `zt_group` (`vision`, `name`, `role`, `desc`) VALUES
('rnd', 'ADMIN', 'admin', 'for administrator'),
('rnd', 'DEV', 'dev', 'for developers.'),
('rnd', 'QA', 'qa', 'for testers.'),
('rnd', 'PM', 'pm', 'for project managers.'),
('rnd', 'PO', 'po', 'for product owners.'),
('rnd', 'TD', 'td', 'for technical director.'),
('rnd', 'PD', 'pd', 'for product director.'),
('rnd', 'QD', 'qd', 'for quality director.'),
('rnd', 'TOP', 'top', 'for top manager.'),
('rnd', 'OTHERS', 'others', 'for others.'),
('rnd', 'guest', 'guest', 'For guest'),
('rnd', 'LIMITED', 'limited', 'For limited user'),
('rnd', 'PROJECTADMIN', 'projectAdmin', 'Project Admins manage project privileges'),
('lite', 'LITEADMIN', 'liteAdmin', 'for lite administrator'),
('lite', 'LITEPROJECT', 'liteProject', 'for lite project managers.'),
('lite', 'LITETEAM', 'liteTeam', 'for lite team.');

REPLACE INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('zh-cn', 'custom', 'URSRList', '1', '{\"SRName\":\"\\u8f6f\\u4ef6\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-cn', 'custom', 'URSRList', '2', '{\"SRName\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-cn', 'custom', 'URSRList', '3', '{\"SRName\":\"\\u8f6f\\u9700\",\"URName\":\"\\u7528\\u9700\"}', '1'),
('zh-cn', 'custom', 'URSRList', '4', '{\"SRName\":\"\\u6545\\u4e8b\",\"URName\":\"\\u53f2\\u8bd7\"}', '1'),
('zh-cn', 'custom', 'URSRList', '5', '{\"SRName\":\"\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-tw', 'custom', 'URSRList', '1', '{"SRName":"\\u8edf\\u4ef6\\u9700\\u6c42","URName":"\\u7528\\u6236\\u9700\\u6c42"}', '0'),
('zh-tw', 'custom', 'URSRList', '2', '{"SRName":"\\u7814\\u767c\\u9700\\u6c42","URName":"\\u7528\\u6236\\u9700\\u6c42"}', '0'),
('zh-tw', 'custom', 'URSRList', '3', '{"SRName":"\\u8edf\\u9700","URName":"\\u7528\\u9700"}', '0'),
('zh-tw', 'custom', 'URSRList', '4', '{"SRName":"\\u6545\\u4e8b","URName":"\\u53f2\\u8a69"}', '0'),
('zh-tw', 'custom', 'URSRList', '5', '{"SRName":"\\u9700\\u6c42","URName":"\\u7528\\u6236\\u9700\\u6c42"}', '0'),
('en', 'custom', 'URSRList', '1', '{\"SRName\":\"Story\",\"URName\":\"Epic\"}', '0'),
('en', 'custom', 'URSRList', '2', '{\"SRName\":\"Software Requirement\",\"URName\":\"User Requirement\"}', '0'),
('fr', 'custom', 'URSRList', '1', '{\"SRName\":\"Story\",\"URName\":\"Epic\"}', '0'),
('fr', 'custom', 'URSRList', '2', '{\"SRName\":\"Software Requirement\",\"URName\":\"User Requirement\"}', '0'),
('de', 'custom', 'URSRList', '1', '{\"SRName\":\"Story\",\"URName\":\"Epic\"}', '0'),
('de', 'custom', 'URSRList', '2', '{\"SRName\":\"Software Requirement\",\"URName\":\"User Requirement\"}', '0');

REPLACE INTO `zt_stage` (`name`,`percent`,`type`,`projectType`,`createdBy`,`createdDate`,`editedBy`,`editedDate`,`deleted`) VALUES
('需求','10','request','waterfall','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('设计','10','design','waterfall','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('开发','50','dev','waterfall','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('测试','15','qa','waterfall','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('发布','10','release','waterfall','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('总结评审','5','review','waterfall','admin','2020-02-08 21:08:45','admin','2020-02-12 13:50:27','0'),
('需求','10','request','waterfallplus','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('设计','10','design','waterfallplus','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('开发','50','dev','waterfallplus','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('测试','15','qa','waterfallplus','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('发布','10','release','waterfallplus','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('总结评审','5','review','waterfallplus','admin','2020-02-08 21:08:45','admin','2020-02-12 13:50:27','0');

REPLACE INTO `zt_priv` (`id`, `module`, `method`, `parent`, `edition`, `vision`, `system`, `order`) VALUES (1,'index','index',349,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(2,'my','index',18,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(3,'my','todo',4,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(4,'my','work',18,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(5,'my','contribute',18,',open,biz,max,ipd,',',rnd,lite,','1',3),(6,'my','project',18,',open,biz,max,ipd,',',rnd,lite,','1',4),(7,'my','profile',9,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(8,'my','uploadAvatar',9,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(9,'my','preference',10,',open,biz,max,ipd,',',rnd,','1',40),(10,'my','dynamic',18,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(11,'my','editProfile',9,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(12,'my','changePassword',9,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(13,'my','manageContacts',8,',open,biz,max,ipd,',',rnd,lite,or,','1',60),(14,'my','deleteContacts',8,',open,biz,max,ipd,',',rnd,lite,or,','1',65),(15,'my','score',18,',open,biz,max,ipd,',',rnd,lite,','1',70),(16,'my','team',165,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(17,'my','execution',18,',open,biz,max,ipd,',',rnd,lite,','1',5),(18,'my','doc',18,',open,biz,max,ipd,',',rnd,lite,','1',55),(19,'my','audit',18,',open,biz,max,ipd,',',rnd,or,','1',7),(20,'my','meeting',18,',max,ipd,',',rnd,','1',8),(21,'my','calendar',4,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(22,'my','effort',291,',biz,max,ipd,',',rnd,lite,','1',1),(23,'my','review',18,',biz,max,ipd,',',rnd,lite,','1',9),(24,'todo','create',5,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(25,'todo','createcycle',5,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(26,'todo','batchCreate',5,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(27,'todo','edit',5,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(28,'todo','batchEdit',5,',open,biz,max,ipd,',',rnd,lite,or,','1',4),(29,'todo','view',4,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(30,'todo','delete',6,',open,biz,max,ipd,',',rnd,lite,or,','1',35),(31,'todo','export',7,',open,biz,max,ipd,',',rnd,lite,or,','1',40),(32,'todo','start',5,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(33,'todo','finish',5,',open,biz,max,ipd,',',rnd,lite,or,','1',7),(34,'todo','batchFinish',5,',open,biz,max,ipd,',',rnd,lite,or,','1',8),(35,'todo','import2Today',5,',open,biz,max,ipd,',',rnd,lite,or,','1',12),(36,'todo','assignTo',5,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(37,'todo','activate',5,',open,biz,max,ipd,',',rnd,lite,or,','1',10),(38,'todo','close',5,',open,biz,max,ipd,',',rnd,lite,or,','1',9),(39,'todo','batchClose',5,',open,biz,max,ipd,',',rnd,lite,or,','1',11),(40,'todo','calendar',4,',biz,max,ipd,',',rnd,lite,','1',85),(41,'program','browse',11,',open,biz,max,ipd,',',rnd,','1',0),(42,'program','kanban',11,',open,biz,max,ipd,',',rnd,','1',1),(43,'program','view',11,',open,biz,max,ipd,',',rnd,','1',2),(44,'program','product',11,',open,biz,max,ipd,',',rnd,','1',3),(45,'program','create',12,',open,biz,max,ipd,',',rnd,','1',25),(46,'program','edit',12,',open,biz,max,ipd,',',rnd,','1',30),(47,'program','start',12,',open,biz,max,ipd,',',rnd,','1',35),(48,'program','suspend',12,',open,biz,max,ipd,',',rnd,','1',40),(49,'program','activate',12,',open,biz,max,ipd,',',rnd,','1',45),(50,'program','close',12,',open,biz,max,ipd,',',rnd,','1',50),(51,'program','delete',13,',open,biz,max,ipd,',',rnd,','1',55),(52,'program','project',11,',open,biz,max,ipd,',',rnd,','1',4),(53,'program','stakeholder',17,',open,biz,max,ipd,',',rnd,','1',65),(54,'program','createStakeholder',17,',open,biz,max,ipd,',',rnd,','1',70),(55,'program','unlinkStakeholder',17,',open,biz,max,ipd,',',rnd,','1',75),(56,'program','batchUnlinkStakeholders',17,',open,biz,max,ipd,',',rnd,','1',80),(57,'program','unbindWhitelist',16,',open,biz,max,ipd,',',rnd,','1',85),(58,'program','updateOrder',12,',open,biz,max,ipd,',',rnd,','1',90),(59,'personnel','accessible',15,',open,biz,max,ipd,',',rnd,lite,','1',5),(60,'personnel','invest',14,',open,biz,max,ipd,',',rnd,lite,','1',10),(61,'personnel','whitelist',16,',open,biz,max,ipd,',',rnd,lite,','1',15),(62,'personnel','addWhitelist',16,',open,biz,max,ipd,',',rnd,lite,','1',20),(63,'product','index',19,',open,biz,max,ipd,',',rnd,','1',0),(64,'product','browse',25,',open,biz,max,ipd,',',rnd,or,','1',10),(65,'product','requirement',31,',open,biz,max,ipd,',',rnd,or,','1',15),(66,'product','create',21,',open,biz,max,ipd,',',rnd,or,','1',20),(67,'product','view',19,',open,biz,max,ipd,',',rnd,or,','1',4),(68,'product','edit',21,',open,biz,max,ipd,',',rnd,or,','1',30),(69,'product','batchEdit',21,',open,biz,max,ipd,',',rnd,or,','1',35),(70,'product','delete',30,',open,biz,max,ipd,',',rnd,or,','1',40),(71,'product','roadmap',19,',open,biz,max,ipd,',',rnd,','1',5),(72,'product','track',19,',open,biz,max,ipd,',',rnd,','1',6),(73,'product','dynamic',19,',open,biz,max,ipd,',',rnd,or,','1',7),(74,'product','project',19,',open,biz,max,ipd,',',rnd,','1',8),(75,'product','dashboard',19,',open,biz,max,ipd,',',rnd,or,','1',3),(76,'product','close',21,',open,biz,max,ipd,',',rnd,or,','1',70),(77,'product','updateOrder',21,',open,biz,max,ipd,',',rnd,or,','1',75),(78,'product','all',19,',open,biz,max,ipd,',',rnd,or,','1',1),(79,'product','kanban',19,',open,biz,max,ipd,',',rnd,','1',2),(80,'product','manageLine',20,',open,biz,max,ipd,',',rnd,','1',90),(82,'product','export',22,',open,biz,max,ipd,',',rnd,or,','1',100),(83,'product','whitelist',23,',open,biz,max,ipd,',',rnd,or,','1',105),(84,'product','addWhitelist',23,',open,biz,max,ipd,',',rnd,or,','1',110),(85,'product','unbindWhitelist',23,',open,biz,max,ipd,',',rnd,or,','1',115),(86,'story','create',26,',open,biz,max,ipd,',',rnd,lite,','1',0),(87,'story','batchCreate',26,',open,biz,max,ipd,',',rnd,lite,','1',1),(88,'story','edit',26,',open,biz,max,ipd,',',rnd,lite,','1',2),(89,'story','export',27,',open,biz,max,ipd,',',rnd,lite,','1',0),(90,'story','delete',28,',open,biz,max,ipd,',',rnd,lite,','1',25),(91,'story','view',25,',open,biz,max,ipd,',',rnd,lite,','1',30),(92,'story','change',26,',open,biz,max,ipd,',',rnd,lite,','1',4),(93,'story','review',29,',open,biz,max,ipd,',',rnd,lite,','1',40),(94,'story','submitReview',26,',open,biz,max,ipd,',',rnd,lite,','1',5),(95,'story','batchReview',29,',open,biz,max,ipd,',',rnd,lite,','1',50),(96,'story','recall',26,',open,biz,max,ipd,',',rnd,lite,','1',6),(97,'story','close',26,',open,biz,max,ipd,',',rnd,lite,','1',7),(98,'story','batchClose',26,',open,biz,max,ipd,',',rnd,lite,','1',8),(99,'story','batchChangePlan',26,',open,biz,max,ipd,',',rnd,lite,','1',9),(100,'story','batchChangeStage',26,',open,biz,max,ipd,',',rnd,lite,','1',10),(101,'story','assignTo',26,',open,biz,max,ipd,',',rnd,lite,','1',11),(102,'story','batchAssignTo',26,',open,biz,max,ipd,',',rnd,lite,','1',12),(103,'story','activate',26,',open,biz,max,ipd,',',rnd,lite,','1',13),(104,'story','tasks',25,',open,biz,max,ipd,',',rnd,lite,','1',95),(105,'story','bugs',25,',open,biz,max,ipd,',',rnd,','1',100),(106,'story','cases',25,',open,biz,max,ipd,',',rnd,','1',105),(107,'story','report',25,',open,biz,max,ipd,',',rnd,lite,','1',110),(108,'story','linkStory',26,',open,biz,max,ipd,',',rnd,lite,','1',14),(109,'story','batchChangeBranch',26,',open,biz,max,ipd,',',rnd,lite,','1',15),(110,'story','batchChangeModule',26,',open,biz,max,ipd,',',rnd,lite,','1',16),(111,'story','batchToTask',45,',open,biz,max,ipd,',',rnd,lite,','1',130),(112,'story','processStoryChange',26,',open,biz,max,ipd,',',rnd,lite,','1',17),(113,'story','linkStories',26,',open,biz,max,ipd,',',rnd,','1',18),(114,'story','relieved',26,',open,biz,max,ipd,',',rnd,','1',20),(115,'story','batchEdit',26,',open,biz,max,ipd,',',rnd,lite,','1',3),(116,'story','import',27,',biz,max,ipd,',',rnd,','1',2),(117,'story','exportTemplate',27,',biz,max,ipd,',',rnd,','1',1),(118,'story','importToLib',263,',max,ipd,',',rnd,','1',165),(119,'story','batchImportToLib',263,',max,ipd,',',rnd,','1',170),(120,'story','relation',26,',max,ipd,',',rnd,','1',19),(121,'requirement','create',32,',open,biz,max,ipd,',',rnd,or,','1',5),(122,'requirement','batchCreate',32,',open,biz,max,ipd,',',rnd,or,','1',10),(123,'requirement','edit',32,',open,biz,max,ipd,',',rnd,or,','1',15),(124,'requirement','export',33,',open,biz,max,ipd,',',rnd,or,','1',20),(125,'requirement','delete',32,',open,biz,max,ipd,',',rnd,or,','1',25),(126,'requirement','view',31,',open,biz,max,ipd,',',rnd,or,','1',30),(127,'requirement','change',32,',open,biz,max,ipd,',',rnd,or,','1',35),(128,'requirement','review',35,',open,biz,max,ipd,',',rnd,or,','1',40),(129,'requirement','submitReview',32,',open,biz,max,ipd,',',rnd,or,','1',45),(130,'requirement','batchReview',35,',open,biz,max,ipd,',',rnd,or,','1',50),(131,'requirement','recall',32,',open,biz,max,ipd,',',rnd,or,','1',55),(132,'requirement','close',32,',open,biz,max,ipd,',',rnd,or,','1',60),(133,'requirement','batchClose',32,',open,biz,max,ipd,',',rnd,or,','1',65),(134,'requirement','assignTo',32,',open,biz,max,ipd,',',rnd,or,','1',70),(135,'requirement','batchAssignTo',32,',open,biz,max,ipd,',',rnd,or,','1',75),(136,'requirement','activate',32,',open,biz,max,ipd,',',rnd,or,','1',80),(137,'requirement','report',31,',open,biz,max,ipd,',',rnd,or,','1',85),(138,'requirement','linkStory',32,',open,biz,max,ipd,',',rnd,or,','1',90),(139,'requirement','batchChangeBranch',32,',open,biz,max,ipd,',',rnd,or,','1',95),(140,'requirement','batchChangeModule',32,',open,biz,max,ipd,',',rnd,or,','1',100),(141,'requirement','linkRequirements',32,',open,biz,max,ipd,',',rnd,or,','1',105),(142,'requirement','batchEdit',32,',open,biz,max,ipd,',',rnd,or,','1',110),(143,'requirement','import',33,',max,ipd,',',rnd,','1',115),(144,'requirement','exportTemplate',33,',max,ipd,',',rnd,','1',120),(145,'productplan','browse',36,',open,biz,max,ipd,',',rnd,','1',5),(146,'productplan','create',37,',open,biz,max,ipd,',',rnd,','1',10),(147,'productplan','edit',37,',open,biz,max,ipd,',',rnd,','1',15),(148,'productplan','delete',38,',open,biz,max,ipd,',',rnd,','1',20),(149,'productplan','view',36,',open,biz,max,ipd,',',rnd,','1',25),(150,'productplan','linkStory',37,',open,biz,max,ipd,',',rnd,','1',30),(151,'productplan','unlinkStory',37,',open,biz,max,ipd,',',rnd,','1',35),(152,'productplan','batchUnlinkStory',37,',open,biz,max,ipd,',',rnd,','1',40),(153,'productplan','linkBug',37,',open,biz,max,ipd,',',rnd,','1',45),(154,'productplan','unlinkBug',37,',open,biz,max,ipd,',',rnd,','1',50),(155,'productplan','batchUnlinkBug',37,',open,biz,max,ipd,',',rnd,','1',55),(156,'productplan','batchEdit',37,',open,biz,max,ipd,',',rnd,','1',60),(157,'productplan','start',37,',open,biz,max,ipd,',',rnd,','1',65),(158,'productplan','finish',37,',open,biz,max,ipd,',',rnd,','1',70),(159,'productplan','close',37,',open,biz,max,ipd,',',rnd,','1',75),(160,'productplan','activate',37,',open,biz,max,ipd,',',rnd,','1',80),(161,'productplan','batchChangeStatus',37,',open,biz,max,ipd,',',rnd,','1',85),(162,'release','browse',39,',open,biz,max,ipd,',',rnd,','1',5),(163,'release','create',40,',open,biz,max,ipd,',',rnd,','1',10),(164,'release','edit',40,',open,biz,max,ipd,',',rnd,','1',15),(165,'release','delete',42,',open,biz,max,ipd,',',rnd,','1',20),(166,'release','view',39,',open,biz,max,ipd,',',rnd,','1',25),(167,'release','export',41,',open,biz,max,ipd,',',rnd,','1',30),(168,'release','linkStory',40,',open,biz,max,ipd,',',rnd,','1',35),(169,'release','unlinkStory',40,',open,biz,max,ipd,',',rnd,','1',40),(170,'release','batchUnlinkStory',40,',open,biz,max,ipd,',',rnd,','1',45),(171,'release','linkBug',40,',open,biz,max,ipd,',',rnd,','1',50),(172,'release','unlinkBug',40,',open,biz,max,ipd,',',rnd,','1',55),(173,'release','batchUnlinkBug',40,',open,biz,max,ipd,',',rnd,','1',60),(174,'release','changeStatus',40,',open,biz,max,ipd,',',rnd,','1',65),(175,'release','notify',43,',open,biz,max,ipd,',',rnd,','1',70),(176,'project','index',46,',open,biz,max,ipd,',',rnd,lite,','1',5),(177,'project','browse',46,',open,biz,max,ipd,',',rnd,lite,','1',40),(178,'project','kanban',46,',open,biz,max,ipd,',',rnd,lite,','1',15),(179,'project','create',47,',open,biz,max,ipd,',',rnd,lite,','1',0),(180,'project','edit',47,',open,biz,max,ipd,',',rnd,lite,','1',1),(181,'project','batchEdit',47,',open,biz,max,ipd,',',rnd,lite,','1',2),(182,'project','group',50,',open,biz,max,ipd,',',rnd,lite,','1',0),(183,'project','createGroup',50,',open,biz,max,ipd,',',rnd,lite,','1',1),(184,'project','managePriv',50,',open,biz,max,ipd,',',rnd,lite,','1',3),(185,'project','manageMembers',50,',open,biz,max,ipd,',',rnd,lite,','1',6),(186,'project','manageGroupMember',50,',open,biz,max,ipd,',',rnd,lite,','1',4),(187,'project','copyGroup',50,',open,biz,max,ipd,',',rnd,lite,','1',5),(188,'project','editGroup',50,',open,biz,max,ipd,',',rnd,lite,','1',2),(189,'project','start',47,',open,biz,max,ipd,',',rnd,lite,','1',3),(190,'project','suspend',47,',open,biz,max,ipd,',',rnd,lite,','1',4),(191,'project','close',47,',open,biz,max,ipd,',',rnd,lite,','1',6),(192,'project','activate',47,',open,biz,max,ipd,',',rnd,lite,','1',5),(193,'project','updateOrder',47,',open,biz,max,ipd,',',rnd,lite,','1',7),(194,'project','delete',51,',open,biz,max,ipd,',',rnd,lite,','1',95),(195,'project','view',46,',open,biz,max,ipd,',',rnd,lite,','1',100),(196,'project','whitelist',52,',open,biz,max,ipd,',',rnd,lite,','1',105),(197,'project','addWhitelist',52,',open,biz,max,ipd,',',rnd,lite,','1',110),(198,'project','unbindWhitelist',52,',open,biz,max,ipd,',',rnd,lite,','1',115),(199,'project','manageProducts',47,',open,biz,max,ipd,',',rnd,','1',8),(200,'project','dynamic',46,',open,biz,max,ipd,',',rnd,lite,','1',125),(203,'project','bug',292,',open,biz,max,ipd,',',rnd,','1',140),(204,'project','testcase',292,',open,biz,max,ipd,',',rnd,','1',145),(205,'project','testtask',292,',open,biz,max,ipd,',',rnd,','1',150),(206,'project','testreport',292,',open,biz,max,ipd,',',rnd,','1',155),(207,'project','execution',46,',open,biz,max,ipd,',',rnd,lite,','1',160),(208,'project','export',48,',open,biz,max,ipd,',',rnd,lite,','1',165),(209,'project','team',50,',open,biz,max,ipd,',',rnd,lite,','1',7),(210,'project','unlinkMember',50,',open,biz,max,ipd,',',rnd,lite,','1',8),(212,'project','programTitle',47,',open,biz,max,ipd,',',rnd,','1',9),(213,'project','approval',302,',max,ipd,',',rnd,','1',5),(214,'projectplan','browse',44,',open,biz,max,ipd,',',rnd,','1',0),(215,'projectplan','create',44,',open,biz,max,ipd,',',rnd,','1',2),(216,'projectplan','edit',44,',open,biz,max,ipd,',',rnd,','1',3),(217,'projectplan','view',44,',open,biz,max,ipd,',',rnd,','1',1),(218,'projectstory','story',313,',open,biz,max,ipd,',',rnd,lite,','1',5),(219,'projectstory','track',293,',max,',',rnd,','1',10),(220,'projectstory','view',313,',open,biz,max,ipd,',',rnd,lite,','1',15),(221,'projectstory','linkStory',45,',open,biz,max,ipd,',',rnd,lite,','1',20),(222,'projectstory','importplanstories',45,',open,biz,max,ipd,',',rnd,','1',25),(223,'projectstory','unlinkStory',45,',open,biz,max,ipd,',',rnd,lite,','1',30),(224,'projectstory','batchUnlinkStory',45,',open,biz,max,ipd,',',rnd,lite,','1',35),(225,'projectstory','importFromLib',45,',max,ipd,',',rnd,','1',40),(226,'execution','view',53,',open,biz,max,ipd,',',rnd,lite,','1',2),(228,'execution','create',54,',open,biz,max,ipd,',',rnd,lite,','1',0),(229,'execution','edit',54,',open,biz,max,ipd,',',rnd,lite,','1',2),(230,'execution','batchedit',54,',open,biz,max,ipd,',',rnd,lite,','1',3),(231,'execution','batchchangestatus',54,',open,biz,max,ipd,',',rnd,','1',4),(232,'execution','start',54,',open,biz,max,ipd,',',rnd,lite,','1',5),(233,'execution','activate',54,',open,biz,max,ipd,',',rnd,lite,','1',6),(234,'execution','putoff',54,',open,biz,max,ipd,',',rnd,lite,','1',7),(235,'execution','suspend',54,',open,biz,max,ipd,',',rnd,lite,','1',8),(236,'execution','close',54,',open,biz,max,ipd,',',rnd,lite,','1',9),(237,'execution','delete',55,',open,biz,max,ipd,',',rnd,lite,','1',60),(238,'execution','task',60,',open,biz,max,ipd,',',rnd,lite,','1',65),(239,'execution','grouptask',66,',open,biz,max,ipd,',',rnd,lite,','1',0),(240,'execution','importtask',61,',open,biz,max,ipd,',',rnd,lite,','1',15),(241,'execution','importplanstories',61,',open,biz,max,ipd,',',rnd,','1',16),(242,'execution','importBug',61,',open,biz,max,ipd,',',rnd,','1',17),(243,'execution','story',311,',open,biz,max,ipd,',',rnd,lite,','1',0),(244,'execution','build',309,',open,biz,max,ipd,',',rnd,','1',0),(245,'execution','testcase',290,',open,biz,max,ipd,',',rnd,','1',1),(246,'execution','bug',290,',open,biz,max,ipd,',',rnd,','1',0),(247,'execution','testtask',290,',open,biz,max,ipd,',',rnd,','1',2),(248,'execution','testreport',290,',open,biz,max,ipd,',',rnd,','1',3),(249,'execution','burn',67,',open,biz,max,ipd,',',rnd,','1',120),(250,'execution','computeBurn',67,',open,biz,max,ipd,',',rnd,','1',125),(251,'execution','cfd',68,',open,biz,max,ipd,',',rnd,','1',130),(252,'execution','computeCFD',68,',open,biz,max,ipd,',',rnd,','1',135),(253,'execution','fixFirst',67,',open,biz,max,ipd,',',rnd,','1',140),(255,'execution','team',64,',open,biz,max,ipd,',',rnd,lite,','1',0),(256,'execution','dynamic',53,',open,biz,max,ipd,',',rnd,lite,','1',5),(257,'execution','manageProducts',54,',open,biz,max,ipd,',',rnd,','1',1),(258,'execution','manageMembers',64,',open,biz,max,ipd,',',rnd,lite,','1',1),(259,'execution','unlinkMember',64,',open,biz,max,ipd,',',rnd,lite,','1',2),(260,'execution','linkStory',69,',open,biz,max,ipd,',',rnd,lite,','1',3),(261,'execution','unlinkStory',69,',open,biz,max,ipd,',',rnd,lite,','1',4),(262,'execution','batchUnlinkStory',69,',open,biz,max,ipd,',',rnd,lite,','1',5),(263,'execution','updateOrder',53,',open,biz,max,ipd,',',rnd,lite,','1',1),(264,'execution','taskKanban',65,',open,biz,max,ipd,',',rnd,lite,','1',2),(265,'execution','printKanban',65,',open,biz,max,ipd,',',rnd,','1',4),(266,'execution','tree',345,',open,biz,max,ipd,',',rnd,lite,','1',1),(267,'execution','treeTask',345,',open,biz,max,ipd,',',rnd,lite,','1',2),(268,'execution','treeStory',345,',open,biz,max,ipd,',',rnd,lite,','1',3),(269,'execution','all',53,',open,biz,max,ipd,',',rnd,lite,','1',0),(270,'execution','export',56,',open,biz,max,ipd,',',rnd,lite,','1',225),(271,'execution','storyKanban',311,',open,biz,max,ipd,',',rnd,lite,','1',1),(272,'execution','storySort',69,',open,biz,max,ipd,',',rnd,lite,','1',6),(273,'execution','whitelist',57,',open,biz,max,ipd,',',rnd,lite,','1',240),(274,'execution','addWhitelist',57,',open,biz,max,ipd,',',rnd,lite,','1',245),(275,'execution','unbindWhitelist',57,',open,biz,max,ipd,',',rnd,lite,','1',250),(276,'execution','storyEstimate',69,',open,biz,max,ipd,',',rnd,','1',7),(277,'execution','executionkanban',65,',open,biz,max,ipd,',',rnd,','1',0),(278,'execution','kanban',65,',open,biz,max,ipd,',',rnd,lite,','1',1),(279,'execution','setKanban',65,',open,biz,max,ipd,',',rnd,','1',3),(280,'execution','doc',53,',open,biz,max,ipd,',',rnd,lite,','1',4),(281,'execution','storyView',311,',open,biz,max,ipd,',',rnd,','1',2),(282,'execution','calendar',347,',biz,max,ipd,',',rnd,lite,','1',6),(283,'execution','effortCalendar',53,',biz,max,ipd,',',rnd,','1',0),(284,'execution','effort',71,',biz,max,ipd,',',rnd,','1',255),(285,'execution','taskEffort',346,',biz,max,ipd,',',rnd,','1',4),(286,'execution','computeTaskEffort',346,',biz,max,ipd,',',rnd,','1',5),(287,'execution','deleterelation',308,',biz,max,ipd,',',rnd,','1',5),(288,'execution','maintainrelation',308,',biz,max,ipd,',',rnd,','1',3),(289,'execution','relation',308,',biz,max,ipd,',',rnd,','1',4),(290,'execution','gantt',58,',biz,max,ipd,',',rnd,lite,','1',0),(291,'execution','ganttsetting',58,',biz,max,ipd,',',rnd,','1',2),(292,'execution','ganttEdit',58,',biz,max,ipd,',',rnd,','1',1),(293,'kanban','space',283,',open,biz,max,ipd,',',rnd,lite,','1',0),(294,'kanban','createSpace',283,',open,biz,max,ipd,',',rnd,lite,','1',1),(295,'kanban','editSpace',283,',open,biz,max,ipd,',',rnd,lite,','1',2),(296,'kanban','closeSpace',283,',open,biz,max,ipd,',',rnd,lite,','1',4),(297,'kanban','deleteSpace',284,',open,biz,max,ipd,',',rnd,lite,','1',25),(299,'kanban','create',286,',open,biz,max,ipd,',',rnd,lite,','1',0),(300,'kanban','edit',286,',open,biz,max,ipd,',',rnd,lite,','1',1),(301,'kanban','view',285,',open,biz,max,ipd,',',rnd,lite,','1',45),(302,'kanban','close',286,',open,biz,max,ipd,',',rnd,lite,','1',3),(303,'kanban','delete',287,',open,biz,max,ipd,',',rnd,lite,','1',55),(304,'kanban','createRegion',286,',open,biz,max,ipd,',',rnd,lite,','1',14),(305,'kanban','editRegion',286,',open,biz,max,ipd,',',rnd,lite,','1',15),(306,'kanban','sortRegion',286,',open,biz,max,ipd,',',rnd,lite,','1',16),(307,'kanban','sortGroup',286,',open,biz,max,ipd,',',rnd,lite,','1',22),(308,'kanban','deleteRegion',286,',open,biz,max,ipd,',',rnd,lite,','1',17),(309,'kanban','createLane',286,',open,biz,max,ipd,',',rnd,lite,','1',18),(310,'kanban','sortLane',286,',open,biz,max,ipd,',',rnd,lite,','1',21),(311,'kanban','deleteLane',286,',open,biz,max,ipd,',',rnd,lite,','1',23),(312,'kanban','createColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',5),(313,'kanban','setColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',7),(314,'kanban','setWIP',286,',open,biz,max,ipd,',',rnd,lite,','1',19),(315,'kanban','sortColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',9),(316,'kanban','deleteColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',13),(317,'kanban','createCard',312,',open,biz,max,ipd,',',rnd,lite,','1',0),(318,'kanban','editCard',312,',open,biz,max,ipd,',',rnd,lite,','1',2),(319,'kanban','viewCard',312,',open,biz,max,ipd,',',rnd,lite,','1',5),(320,'kanban','sortCard',312,',open,biz,max,ipd,',',rnd,lite,','1',7),(321,'kanban','deleteCard',312,',open,biz,max,ipd,',',rnd,lite,','1',8),(322,'kanban','assigntoCard',312,',open,biz,max,ipd,',',rnd,lite,','1',4),(323,'kanban','moveCard',312,',open,biz,max,ipd,',',rnd,lite,','1',6),(324,'kanban','setCardColor',312,',open,biz,max,ipd,',',rnd,lite,','1',3),(326,'kanban','viewArchivedColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',11),(327,'kanban','batchCreateCard',312,',open,biz,max,ipd,',',rnd,lite,','1',1),(328,'kanban','activateSpace',283,',open,biz,max,ipd,',',rnd,','1',5),(329,'kanban','setting',286,',open,biz,max,ipd,',',rnd,','1',2),(330,'kanban','activate',286,',open,biz,max,ipd,',',rnd,','1',4),(331,'kanban','editLaneColor',286,',open,biz,max,ipd,',',rnd,lite,','1',8),(332,'kanban','editLaneName',286,',open,biz,max,ipd,',',rnd,lite,','1',20),(333,'kanban','splitColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',6),(334,'kanban','archiveColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',10),(335,'kanban','restoreColumn',286,',open,biz,max,ipd,',',rnd,lite,','1',12),(336,'kanban','archiveCard',312,',open,biz,max,ipd,',',rnd,lite,','1',9),(337,'kanban','viewArchivedCard',312,',open,biz,max,ipd,',',rnd,lite,','1',10),(338,'kanban','restoreCard',312,',open,biz,max,ipd,',',rnd,lite,','1',11),(339,'programplan','create',171,',open,biz,max,ipd,',',rnd,','1',5),(340,'programplan','edit',171,',open,biz,max,ipd,',',rnd,','1',10),(341,'programplan','browse',307,',max,ipd,',',rnd,','1',15),(342,'programplan','ganttEdit',307,',max,ipd,',',rnd,','1',20),(343,'task','create',61,',open,biz,max,ipd,',',rnd,lite,','1',0),(344,'task','batchCreate',61,',open,biz,max,ipd,',',rnd,lite,','1',1),(345,'task','batchEdit',61,',open,biz,max,ipd,',',rnd,lite,','1',3),(346,'task','edit',61,',open,biz,max,ipd,',',rnd,lite,','1',2),(347,'task','assignTo',61,',open,biz,max,ipd,',',rnd,lite,','1',4),(348,'task','batchAssignTo',61,',open,biz,max,ipd,',',rnd,lite,','1',5),(349,'task','start',61,',open,biz,max,ipd,',',rnd,lite,','1',6),(350,'task','pause',61,',open,biz,max,ipd,',',rnd,lite,','1',7),(351,'task','restart',61,',open,biz,max,ipd,',',rnd,lite,','1',8),(352,'task','finish',61,',open,biz,max,ipd,',',rnd,lite,','1',9),(353,'task','cancel',61,',open,biz,max,ipd,',',rnd,lite,','1',10),(354,'task','close',61,',open,biz,max,ipd,',',rnd,lite,','1',12),(355,'task','batchClose',61,',open,biz,max,ipd,',',rnd,lite,','1',13),(356,'task','activate',61,',open,biz,max,ipd,',',rnd,lite,','1',14),(357,'task','delete',62,',open,biz,max,ipd,',',rnd,lite,','1',75),(358,'task','view',60,',open,biz,max,ipd,',',rnd,lite,','1',80),(359,'task','export',63,',open,biz,max,ipd,',',rnd,lite,','1',0),(360,'task','confirmStoryChange',61,',open,biz,max,ipd,',',rnd,lite,','1',18),(361,'task','recordEstimate',61,',open,biz,max,ipd,',',rnd,lite,','1',20),(362,'task','editEstimate',61,',open,biz,max,ipd,',',rnd,lite,','1',21),(363,'task','deleteEstimate',61,',open,biz,max,ipd,',',rnd,lite,','1',22),(364,'task','report',60,',open,biz,max,ipd,',',rnd,lite,','1',110),(365,'task','batchChangeModule',61,',open,biz,max,ipd,',',rnd,lite,','1',23),(366,'task','batchCancel',61,',open,biz,max,ipd,',',rnd,lite,','1',11),(367,'task','import',63,',biz,max,ipd,',',rnd,lite,','1',2),(368,'task','exportTemplate',63,',biz,max,ipd,',',rnd,lite,','1',1),(369,'task','confirmdesignchange',61,',max,ipd,',',rnd,','1',19),(370,'build','create',72,',open,biz,max,ipd,',',rnd,','1',2),(371,'build','edit',72,',open,biz,max,ipd,',',rnd,','1',3),(372,'build','delete',73,',open,biz,max,ipd,',',rnd,','1',15),(373,'build','view',309,',open,biz,max,ipd,',',rnd,','1',1),(374,'build','linkStory',72,',open,biz,max,ipd,',',rnd,','1',4),(375,'build','unlinkStory',72,',open,biz,max,ipd,',',rnd,','1',5),(376,'build','batchUnlinkStory',72,',open,biz,max,ipd,',',rnd,','1',6),(377,'build','linkBug',72,',open,biz,max,ipd,',',rnd,','1',7),(378,'build','unlinkBug',72,',open,biz,max,ipd,',',rnd,','1',8),(379,'build','batchUnlinkBug',72,',open,biz,max,ipd,',',rnd,','1',9),(380,'design','browse',175,',open,biz,max,ipd,',',rnd,','1',5),(381,'design','view',175,',open,biz,max,ipd,',',rnd,','1',10),(382,'design','create',176,',open,biz,max,ipd,',',rnd,','1',0),(383,'design','batchCreate',176,',open,biz,max,ipd,',',rnd,','1',1),(384,'design','edit',176,',open,biz,max,ipd,',',rnd,','1',3),(385,'design','assignTo',176,',open,biz,max,ipd,',',rnd,','1',2),(386,'design','delete',177,',open,biz,max,ipd,',',rnd,','1',35),(387,'design','linkCommit',176,',open,biz,max,ipd,',',rnd,','1',4),(388,'design','viewCommit',176,',open,biz,max,ipd,',',rnd,','1',6),(389,'design','unlinkCommit',176,',open,biz,max,ipd,',',rnd,','1',5),(390,'design','revision',176,',open,biz,max,ipd,',',rnd,','1',45),(391,'design','submit',176,',max,ipd,',',rnd,','1',7),(392,'design','setType',282,',max,ipd,',',rnd,','1',65),(393,'design','setPlusType',282,',max,ipd,',',rnd,','1',70),(394,'qa','index',136,',open,biz,max,ipd,',',rnd,','1',5),(395,'bug','browse',137,',open,biz,max,ipd,',',rnd,','1',5),(396,'bug','create',138,',open,biz,max,ipd,',',rnd,','1',0),(397,'bug','batchCreate',138,',open,biz,max,ipd,',',rnd,','1',1),(398,'bug','batchEdit',138,',open,biz,max,ipd,',',rnd,','1',3),(399,'bug','confirmBug',138,',open,biz,max,ipd,',',rnd,','1',4),(400,'bug','batchConfirm',138,',open,biz,max,ipd,',',rnd,','1',5),(401,'bug','view',137,',open,biz,max,ipd,',',rnd,','1',35),(402,'bug','edit',138,',open,biz,max,ipd,',',rnd,','1',2),(403,'bug','assignTo',138,',open,biz,max,ipd,',',rnd,','1',6),(404,'bug','batchAssignTo',138,',open,biz,max,ipd,',',rnd,','1',7),(405,'bug','resolve',138,',open,biz,max,ipd,',',rnd,','1',8),(406,'bug','batchResolve',138,',open,biz,max,ipd,',',rnd,','1',9),(407,'bug','batchClose',138,',open,biz,max,ipd,',',rnd,','1',11),(408,'bug','batchActivate',138,',open,biz,max,ipd,',',rnd,','1',13),(409,'bug','activate',138,',open,biz,max,ipd,',',rnd,','1',12),(410,'bug','close',138,',open,biz,max,ipd,',',rnd,','1',10),(411,'bug','report',137,',open,biz,max,ipd,',',rnd,','1',85),(412,'bug','export',140,',open,biz,max,ipd,',',rnd,','1',90),(413,'bug','confirmStoryChange',138,',open,biz,max,ipd,',',rnd,','1',14),(414,'bug','delete',139,',open,biz,max,ipd,',',rnd,','1',100),(415,'bug','linkBugs',138,',open,biz,max,ipd,',',rnd,','1',15),(416,'bug','batchChangeModule',138,',open,biz,max,ipd,',',rnd,','1',16),(417,'bug','batchChangeBranch',138,',open,biz,max,ipd,',',rnd,','1',17),(418,'bug','batchChangePlan',138,',open,biz,max,ipd,',',rnd,','1',18),(419,'bug','import',140,',biz,max,ipd,',',rnd,','1',125),(420,'bug','exportTemplate',140,',biz,max,ipd,',',rnd,','1',130),(421,'testcase','browse',141,',open,biz,max,ipd,',',rnd,','1',5),(422,'testcase','groupCase',141,',open,biz,max,ipd,',',rnd,','1',10),(423,'testcase','zeroCase',141,',open,biz,max,ipd,',',rnd,','1',15),(424,'testcase','create',142,',open,biz,max,ipd,',',rnd,','1',0),(425,'testcase','batchCreate',142,',open,biz,max,ipd,',',rnd,','1',1),(426,'testcase','createBug',142,',open,biz,max,ipd,',',rnd,','1',5),(427,'testcase','view',141,',open,biz,max,ipd,',',rnd,','1',35),(428,'testcase','edit',142,',open,biz,max,ipd,',',rnd,','1',2),(429,'testcase','delete',144,',open,biz,max,ipd,',',rnd,','1',45),(430,'testcase','export',143,',open,biz,max,ipd,',',rnd,','1',0),(431,'testcase','confirmChange',142,',open,biz,max,ipd,',',rnd,','1',6),(432,'testcase','confirmStoryChange',142,',open,biz,max,ipd,',',rnd,','1',7),(433,'testcase','batchEdit',142,',open,biz,max,ipd,',',rnd,','1',3),(434,'testcase','batchDelete',144,',open,biz,max,ipd,',',rnd,','1',70),(435,'testcase','batchChangeModule',142,',open,biz,max,ipd,',',rnd,','1',9),(436,'testcase','batchChangeBranch',142,',open,biz,max,ipd,',',rnd,','1',10),(437,'testcase','linkCases',142,',open,biz,max,ipd,',',rnd,','1',12),(438,'testcase','linkBugs',142,',open,biz,max,ipd,',',rnd,','1',13),(439,'testcase','bugs',141,',open,biz,max,ipd,',',rnd,','1',95),(440,'testcase','review',145,',open,biz,max,ipd,',',rnd,','1',100),(441,'testcase','batchReview',145,',open,biz,max,ipd,',',rnd,','1',105),(442,'testcase','batchConfirmStoryChange',142,',open,biz,max,ipd,',',rnd,','1',8),(443,'testcase','importFromLib',143,',open,biz,max,ipd,',',rnd,','1',5),(444,'testcase','batchCaseTypeChange',142,',open,biz,max,ipd,',',rnd,','1',11),(445,'testcase','confirmLibcaseChange',142,',open,biz,max,ipd,',',rnd,','1',14),(446,'testcase','ignoreLibcaseChange',142,',open,biz,max,ipd,',',rnd,','1',15),(447,'testcase','importToLib',266,',open,biz,max,ipd,',',rnd,','1',135),(448,'testcase','automation',289,',open,biz,max,ipd,',',rnd,','1',140),(449,'testcase','showScript',289,',open,biz,max,ipd,',',rnd,','1',145),(450,'testcase','exportTemplate',143,',open,biz,max,ipd,',',rnd,','1',1),(451,'testcase','import',143,',open,biz,max,ipd,',',rnd,','1',3),(453,'testcase','submit',142,',max,ipd,',',rnd,','1',4),(454,'testtask','create',147,',open,biz,max,ipd,',',rnd,','1',0),(455,'testtask','browse',146,',open,biz,max,ipd,',',rnd,','1',10),(456,'testtask','view',146,',open,biz,max,ipd,',',rnd,','1',15),(457,'testtask','cases',146,',open,biz,max,ipd,',',rnd,','1',20),(458,'testtask','groupCase',146,',open,biz,max,ipd,',',rnd,','1',25),(459,'testtask','edit',147,',open,biz,max,ipd,',',rnd,','1',1),(460,'testtask','start',147,',open,biz,max,ipd,',',rnd,','1',2),(461,'testtask','activate',147,',open,biz,max,ipd,',',rnd,','1',3),(462,'testtask','block',147,',open,biz,max,ipd,',',rnd,','1',4),(463,'testtask','close',147,',open,biz,max,ipd,',',rnd,','1',5),(464,'testtask','delete',148,',open,biz,max,ipd,',',rnd,','1',55),(465,'testtask','batchAssign',147,',open,biz,max,ipd,',',rnd,','1',12),(466,'testtask','linkcase',147,',open,biz,max,ipd,',',rnd,','1',6),(467,'testtask','unlinkcase',147,',open,biz,max,ipd,',',rnd,','1',7),(468,'testtask','runcase',147,',open,biz,max,ipd,',',rnd,','1',9),(469,'testtask','results',147,',open,biz,max,ipd,',',rnd,','1',11),(470,'testtask','batchUnlinkCases',147,',open,biz,max,ipd,',',rnd,','1',8),(471,'testtask','report',146,',open,biz,max,ipd,',',rnd,','1',90),(472,'testtask','browseUnits',149,',open,biz,max,ipd,',',rnd,','1',0),(473,'testtask','unitCases',149,',open,biz,max,ipd,',',rnd,','1',1),(474,'testtask','importUnitResult',149,',open,biz,max,ipd,',',rnd,','1',2),(475,'testtask','batchRun',147,',open,biz,max,ipd,',',rnd,','1',10),(476,'testtask','runDeployCase',134,',biz,max,ipd,',',rnd,','1',6),(477,'testtask','deployCaseResults',134,',biz,max,ipd,',',rnd,','1',7),(479,'testsuite','browse',150,',open,biz,max,ipd,',',rnd,','1',0),(480,'testsuite','create',151,',open,biz,max,ipd,',',rnd,','1',15),(481,'testsuite','view',150,',open,biz,max,ipd,',',rnd,','1',2),(482,'testsuite','edit',151,',open,biz,max,ipd,',',rnd,','1',25),(483,'testsuite','delete',152,',open,biz,max,ipd,',',rnd,','1',30),(484,'testsuite','linkCase',151,',open,biz,max,ipd,',',rnd,','1',35),(485,'testsuite','unlinkCase',151,',open,biz,max,ipd,',',rnd,','1',40),(486,'testsuite','batchUnlinkCases',151,',open,biz,max,ipd,',',rnd,','1',45),(487,'testreport','browse',153,',open,biz,max,ipd,',',rnd,','1',5),(488,'testreport','create',154,',open,biz,max,ipd,',',rnd,','1',10),(489,'testreport','view',153,',open,biz,max,ipd,',',rnd,','1',15),(490,'testreport','delete',155,',open,biz,max,ipd,',',rnd,','1',20),(491,'testreport','edit',154,',open,biz,max,ipd,',',rnd,','1',25),(492,'testreport','export',156,',biz,max,ipd,',',rnd,','1',30),(493,'milestone','index',183,',max,ipd,',',rnd,','1',5),(494,'milestone','saveOtherProblem',183,',max,ipd,',',rnd,','1',10),(496,'caselib','browse',98,',open,biz,max,ipd,',',rnd,','1',2),(497,'caselib','create',99,',open,biz,max,ipd,',',rnd,','1',0),(498,'caselib','edit',99,',open,biz,max,ipd,',',rnd,','1',1),(499,'caselib','delete',100,',open,biz,max,ipd,',',rnd,','1',25),(500,'caselib','view',98,',open,biz,max,ipd,',',rnd,','1',3),(501,'caselib','createCase',99,',open,biz,max,ipd,',',rnd,','1',3),(502,'caselib','batchCreateCase',99,',open,biz,max,ipd,',',rnd,','1',4),(503,'caselib','exportTemplate',101,',open,biz,max,ipd,',',rnd,','1',45),(504,'caselib','import',101,',open,biz,max,ipd,',',rnd,','1',50),(505,'caselib','showImport',101,',open,biz,max,ipd,',',rnd,','1',55),(506,'zahost','browse',157,',open,biz,max,ipd,',',rnd,','1',5),(507,'zahost','create',158,',open,biz,max,ipd,',',rnd,','1',10),(508,'zahost','edit',158,',open,biz,max,ipd,',',rnd,','1',15),(509,'zahost','delete',159,',open,biz,max,ipd,',',rnd,','1',20),(510,'zahost','view',157,',open,biz,max,ipd,',',rnd,','1',25),(511,'zahost','browseImage',160,',open,biz,max,ipd,',',rnd,','1',30),(512,'zahost','downloadImage',160,',open,biz,max,ipd,',',rnd,','1',35),(513,'zahost','cancelDownload',160,',open,biz,max,ipd,',',rnd,','1',40),(514,'zanode','browse',161,',open,biz,max,ipd,',',rnd,','1',5),(515,'zanode','create',162,',open,biz,max,ipd,',',rnd,','1',10),(516,'zanode','edit',162,',open,biz,max,ipd,',',rnd,','1',15),(517,'zanode','destroy',288,',open,biz,max,ipd,',',rnd,','1',20),(518,'zanode','reboot',162,',open,biz,max,ipd,',',rnd,','1',25),(519,'zanode','resume',162,',open,biz,max,ipd,',',rnd,','1',30),(520,'zanode','getVNC',162,',open,biz,max,ipd,',',rnd,','1',35),(521,'zanode','start',162,',open,biz,max,ipd,',',rnd,','1',40),(522,'zanode','close',162,',open,biz,max,ipd,',',rnd,','1',45),(523,'zanode','view',161,',open,biz,max,ipd,',',rnd,','1',50),(524,'zanode','createImage',163,',open,biz,max,ipd,',',rnd,','1',55),(525,'zanode','browseSnapshot',164,',open,biz,max,ipd,',',rnd,','1',60),(526,'zanode','createSnapshot',164,',open,biz,max,ipd,',',rnd,','1',65),(527,'zanode','editSnapshot',164,',open,biz,max,ipd,',',rnd,','1',70),(528,'zanode','restoreSnapshot',164,',open,biz,max,ipd,',',rnd,','1',75),(529,'zanode','deleteSnapshot',164,',open,biz,max,ipd,',',rnd,','1',80),(530,'zanode','suspend',162,',open,biz,max,ipd,',',rnd,','1',85),(558,'screen','browse',318,',open,biz,max,ipd,',',rnd,','1',5),(559,'screen','view',318,',open,biz,max,ipd,',',rnd,','1',10),(595,'company','browse',234,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(596,'company','edit',169,',open,biz,max,ipd,',',rnd,lite,or,','1',15),(597,'company','dynamic',168,',open,biz,max,ipd,',',rnd,lite,or,','1',20),(598,'company','view',169,',open,biz,max,ipd,',',rnd,lite,or,','1',25),(599,'company','todo',166,',biz,max,ipd,',',rnd,lite,','1',30),(600,'company','calendar',167,',biz,max,ipd,',',rnd,lite,','1',10),(601,'company','allTodo',170,',biz,max,ipd,',',rnd,lite,','1',40),(602,'company','effort',167,',biz,max,ipd,',',rnd,lite,','1',45),(603,'company','alleffort',170,',biz,max,ipd,',',rnd,lite,','1',50),(604,'dept','browse',232,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(605,'dept','updateOrder',232,',open,biz,max,ipd,',',rnd,lite,or,','1',10),(606,'dept','manageChild',232,',open,biz,max,ipd,',',rnd,lite,or,','1',15),(607,'dept','edit',232,',open,biz,max,ipd,',',rnd,lite,or,','1',20),(608,'dept','delete',232,',open,biz,max,ipd,',',rnd,lite,or,','1',25),(609,'group','browse',233,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(610,'group','create',233,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(611,'group','edit',233,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(612,'group','copy',233,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(613,'group','delete',233,',open,biz,max,ipd,',',rnd,lite,or,','1',4),(614,'group','managePriv',231,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(615,'group','manageMember',233,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(616,'group','manageProjectAdmin',233,',open,biz,max,ipd,',',rnd,lite,or,','1',8),(618,'group','manageView',233,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(624,'user','create',234,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(625,'user','batchCreate',234,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(626,'user','view',234,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(627,'user','edit',234,',open,biz,max,ipd,',',rnd,lite,or,','1',4),(628,'user','unlock',234,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(629,'user','delete',234,',open,biz,max,ipd,',',rnd,lite,or,','1',7),(630,'user','todo',165,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(631,'user','task',165,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(632,'user','bug',165,',open,biz,max,ipd,',',rnd,or,','1',7),(633,'user','dynamic',165,',open,biz,max,ipd,',',rnd,lite,or,','1',13),(635,'user','profile',165,',open,biz,max,ipd,',',rnd,lite,or,','1',14),(636,'user','batchEdit',234,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(637,'user','unbind',234,',open,biz,max,ipd,',',rnd,lite,','1',8),(638,'user','setPublicTemplate',296,',open,biz,max,ipd,',',rnd,lite,or,','1',10),(639,'user','export',234,',biz,max,ipd,',',rnd,','1',9),(640,'user','exportTemplate',234,',biz,max,ipd,',',rnd,','1',10),(641,'user','story',165,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(642,'user','testTask',165,',open,biz,max,ipd,',',rnd,or,','1',8),(643,'user','testCase',165,',open,biz,max,ipd,',',rnd,or,','1',9),(644,'user','execution',165,',open,biz,max,ipd,',',rnd,lite,or,','1',10),(645,'user','effortcalendar',165,',biz,max,ipd,',',rnd,','1',3),(646,'user','todocalendar',165,',biz,max,ipd,',',rnd,','1',4),(647,'user','effort',165,',biz,max,ipd,',',rnd,','1',1),(648,'user','import',234,',biz,max,ipd,',',rnd,','1',11),(649,'user','importldap',253,',biz,max,ipd,',',rnd,','1',15),(650,'user','issue',165,',max,ipd,',',rnd,','1',11),(651,'user','risk',165,',max,ipd,',',rnd,','1',12),(652,'admin','index',645,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(654,'admin','checkWeak',251,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(655,'admin','sso',234,',open,biz,max,ipd,',',rnd,lite,','1',65),(656,'admin','register',645,',open,biz,max,ipd,',',rnd,lite,or,','1',25),(657,'admin','xuanxuan',254,',open,biz,max,ipd,',',rnd,lite,','1',8),(659,'admin','resetPWDSetting',251,',open,biz,max,ipd,',',rnd,or,','1',2),(660,'admin','tableEngine',256,',open,biz,max,ipd,',',rnd,or,','1',45),(661,'admin','safe',251,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(662,'stage','browse',268,',open,biz,max,ipd,',',rnd,','1',0),(663,'stage','create',268,',open,biz,max,ipd,',',rnd,','1',2),(664,'stage','batchCreate',268,',open,biz,max,ipd,',',rnd,','1',3),(665,'stage','edit',268,',open,biz,max,ipd,',',rnd,','1',4),(666,'stage','setType',267,',open,biz,max,ipd,',',rnd,','1',25),(667,'stage','delete',268,',open,biz,max,ipd,',',rnd,','1',5),(668,'stage','plusBrowse',268,',open,biz,max,ipd,',',rnd,','1',1),(669,'extension','browse',235,',open,biz,max,ipd,',',rnd,lite,','1',0),(670,'extension','obtain',235,',open,biz,max,ipd,',',rnd,lite,','1',2),(671,'extension','structure',235,',open,biz,max,ipd,',',rnd,lite,','1',3),(672,'extension','install',235,',open,biz,max,ipd,',',rnd,lite,','1',4),(673,'extension','uninstall',235,',open,biz,max,ipd,',',rnd,lite,','1',5),(674,'extension','activate',235,',open,biz,max,ipd,',',rnd,lite,','1',6),(675,'extension','deactivate',235,',open,biz,max,ipd,',',rnd,lite,','1',7),(676,'extension','upload',235,',open,biz,max,ipd,',',rnd,lite,','1',1),(677,'extension','erase',235,',open,biz,max,ipd,',',rnd,lite,','1',8),(678,'extension','upgrade',235,',open,biz,max,ipd,',',rnd,lite,','1',9),(680,'custom','set',276,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(681,'custom','product',276,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(682,'custom','execution',276,',open,biz,max,ipd,',',rnd,lite,','1',9),(683,'custom','required',276,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(684,'custom','restore',276,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(685,'custom','flow',267,',open,biz,max,ipd,',',rnd,lite,or,','1',35),(687,'custom','timezone',256,',open,biz,max,ipd,',',rnd,lite,or,','1',45),(688,'custom','estimate',267,',max,ipd,',',rnd,','1',50),(689,'custom','editStoryConcept',276,',open,biz,max,ipd,',',rnd,lite,or,','1',7),(690,'custom','browseStoryConcept',276,',open,biz,max,ipd,',',rnd,lite,or,','1',4),(691,'custom','setDefaultConcept',276,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(692,'custom','deleteStoryConcept',276,',open,biz,max,ipd,',',rnd,lite,or,','1',8),(693,'custom','kanban',276,',open,biz,max,ipd,',',rnd,','1',11),(694,'custom','code',267,',open,biz,max,ipd,',',rnd,or,','1',80),(695,'custom','hours',267,',open,biz,max,ipd,',',rnd,or,','1',85),(696,'custom','percent',267,',open,biz,max,ipd,',',rnd,or,','1',90),(697,'custom','setStoryConcept',276,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(698,'custom','libreoffice',256,',biz,max,ipd,',',rnd,lite,','1',100),(699,'action','trash',250,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(700,'action','undelete',250,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(701,'action','hideOne',250,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(702,'action','hideAll',250,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(703,'action','comment',258,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(704,'action','editComment',258,',open,biz,max,ipd,',',rnd,lite,or,','1',10),(705,'mail','index',237,',open,biz,max,ipd,',',lite,rnd,or,','1',0),(706,'mail','detect',237,',open,biz,max,ipd,',',lite,rnd,or,','1',5),(707,'mail','edit',237,',open,biz,max,ipd,',',lite,rnd,or,','1',1),(708,'mail','save',237,',open,biz,max,ipd,',',lite,rnd,or,','1',3),(709,'mail','test',237,',open,biz,max,ipd,',',lite,rnd,or,','1',2),(710,'mail','reset',237,',open,biz,max,ipd,',',lite,rnd,or,','1',4),(711,'mail','browse',237,',open,biz,max,ipd,',',lite,rnd,or,','1',6),(712,'mail','delete',237,',open,biz,max,ipd,',',lite,rnd,or,','1',7),(713,'mail','batchDelete',237,',open,biz,max,ipd,',',lite,rnd,or,','1',8),(714,'mail','resend',237,',open,biz,max,ipd,',',lite,rnd,or,','1',9),(715,'sms','index',241,',biz,max,ipd,',',lite,rnd,or,','1',5),(716,'sms','test',241,',biz,max,ipd,',',lite,rnd,or,','1',10),(717,'sms','reset',241,',biz,max,ipd,',',lite,rnd,or,','1',15),(718,'svn','diff',300,',open,biz,max,ipd,',',rnd,','1',5),(719,'svn','cat',300,',open,biz,max,ipd,',',rnd,','1',10),(720,'svn','apiSync',300,',open,biz,max,ipd,',',rnd,','1',15),(721,'git','diff',299,',open,biz,max,ipd,',',rnd,','1',5),(722,'git','cat',299,',open,biz,max,ipd,',',rnd,','1',10),(723,'git','apiSync',299,',open,biz,max,ipd,',',rnd,','1',15),(724,'search','buildForm',257,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(725,'search','buildQuery',257,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(726,'search','saveQuery',257,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(727,'search','deleteQuery',257,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(728,'search','select',257,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(729,'search','index',257,',open,biz,max,ipd,',',rnd,lite,or,','1',4),(730,'search','buildIndex',256,',open,biz,max,ipd,',',rnd,lite,or,','1',35),(731,'tree','browse',259,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(732,'tree','browseTask',259,',open,biz,max,ipd,',',rnd,lite,','1',1),(733,'tree','updateOrder',259,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(734,'tree','manageChild',259,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(735,'tree','edit',259,',open,biz,max,ipd,',',rnd,lite,or,','1',7),(736,'tree','delete',259,',open,biz,max,ipd,',',rnd,lite,or,','1',8),(737,'tree','editHost',259,',biz,max,ipd,',',rnd,lite,','1',4),(738,'tree','fix',259,',open,biz,max,ipd,',',rnd,lite,or,','1',9),(739,'tree','browsehost',259,',biz,max,ipd,',',rnd,lite,','1',3),(758,'file','download',260,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(759,'file','edit',260,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(760,'file','delete',260,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(761,'file','uploadImages',260,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(762,'file','setPublic',260,',open,biz,max,ipd,',',rnd,lite,or,','1',25),(763,'misc','ping',301,',open,biz,max,ipd,',',rnd,lite,','1',5),(764,'backup','index',249,',open,biz,max,ipd,',',lite,rnd,or,','1',0),(765,'backup','backup',249,',open,biz,max,ipd,',',lite,rnd,or,','1',2),(766,'backup','restore',249,',open,biz,max,ipd,',',lite,rnd,or,','1',3),(767,'backup','delete',249,',open,biz,max,ipd,',',lite,rnd,or,','1',4),(768,'backup','setting',249,',open,biz,max,ipd,',',lite,rnd,or,','1',1),(769,'backup','rmPHPHeader',249,',open,biz,max,ipd,',',lite,rnd,or,','1',5),(770,'backup','change',249,',open,biz,max,ipd,',',lite,rnd,or,','1',6),(771,'cron','index',252,',open,biz,max,ipd,',',rnd,lite,','1',0),(772,'cron','turnon',252,',open,biz,max,ipd,',',rnd,lite,','1',1),(773,'cron','create',252,',open,biz,max,ipd,',',rnd,lite,','1',3),(774,'cron','edit',252,',open,biz,max,ipd,',',rnd,lite,','1',5),(775,'cron','toggle',252,',open,biz,max,ipd,',',rnd,lite,','1',4),(776,'cron','delete',252,',open,biz,max,ipd,',',rnd,lite,','1',6),(777,'cron','openProcess',252,',open,biz,max,ipd,',',rnd,lite,','1',2),(778,'dev','api',226,',open,biz,max,ipd,',',rnd,','1',5),(779,'dev','db',226,',open,biz,max,ipd,',',rnd,','1',10),(781,'editor','index',228,',open,biz,max,ipd,',',rnd,','1',5),(782,'editor','extend',228,',open,biz,max,ipd,',',rnd,','1',10),(783,'editor','edit',228,',open,biz,max,ipd,',',rnd,','1',15),(784,'editor','newPage',228,',open,biz,max,ipd,',',rnd,','1',20),(785,'editor','save',228,',open,biz,max,ipd,',',rnd,','1',25),(786,'editor','delete',228,',open,biz,max,ipd,',',rnd,','1',30),(787,'issue','browse',189,',max,ipd,',',rnd,','1',5),(788,'issue','create',190,',max,ipd,',',rnd,','1',10),(789,'issue','batchCreate',190,',max,ipd,',',rnd,','1',15),(790,'issue','delete',192,',max,ipd,',',rnd,','1',20),(791,'issue','edit',190,',max,ipd,',',rnd,','1',25),(792,'issue','confirm',190,',max,ipd,',',rnd,','1',30),(793,'issue','assignTo',190,',max,ipd,',',rnd,','1',35),(794,'issue','close',190,',max,ipd,',',rnd,','1',40),(795,'issue','cancel',190,',max,ipd,',',rnd,','1',45),(796,'issue','activate',190,',max,ipd,',',rnd,','1',50),(797,'issue','resolve',190,',max,ipd,',',rnd,','1',55),(798,'issue','view',189,',max,ipd,',',rnd,','1',60),(799,'issue','export',191,',max,ipd,',',rnd,','1',65),(800,'issue','importToLib',193,',max,ipd,',',rnd,','1',70),(801,'issue','batchImportToLib',193,',max,ipd,',',rnd,','1',75),(802,'issue','importFromLib',191,',max,ipd,',',rnd,','1',80),(803,'risk','browse',194,',max,ipd,',',rnd,','1',5),(804,'risk','create',195,',max,ipd,',',rnd,','1',0),(805,'risk','edit',195,',max,ipd,',',rnd,','1',2),(806,'risk','delete',197,',max,ipd,',',rnd,','1',20),(807,'risk','activate',195,',max,ipd,',',rnd,','1',3),(808,'risk','close',195,',max,ipd,',',rnd,','1',8),(809,'risk','hangup',195,',max,ipd,',',rnd,','1',6),(810,'risk','batchCreate',195,',max,ipd,',',rnd,','1',1),(811,'risk','cancel',195,',max,ipd,',',rnd,','1',7),(812,'risk','track',195,',max,ipd,',',rnd,','1',5),(813,'risk','view',194,',max,ipd,',',rnd,','1',55),(814,'risk','assignTo',195,',max,ipd,',',rnd,','1',4),(815,'risk','importToLib',198,',max,ipd,',',rnd,','1',65),(816,'risk','batchImportToLib',198,',max,ipd,',',rnd,','1',70),(817,'risk','importFromLib',196,',max,ipd,',',rnd,','1',1),(818,'risk','export',196,',max,ipd,',',rnd,','1',0),(819,'mr','create',230,',open,biz,max,ipd,',',rnd,','1',2),(820,'mr','browse',230,',open,biz,max,ipd,',',rnd,','1',1),(821,'mr','edit',230,',open,biz,max,ipd,',',rnd,','1',3),(822,'mr','delete',230,',open,biz,max,ipd,',',rnd,','1',4),(823,'mr','view',230,',open,biz,max,ipd,',',rnd,','1',5),(824,'mr','accept',230,',open,biz,max,ipd,',',rnd,','1',0),(825,'mr','diff',230,',open,biz,max,ipd,',',rnd,','1',6),(826,'mr','link',230,',open,biz,max,ipd,',',rnd,','1',7),(827,'mr','linkStory',230,',open,biz,max,ipd,',',rnd,','1',8),(828,'mr','linkBug',230,',open,biz,max,ipd,',',rnd,','1',9),(829,'mr','linkTask',230,',open,biz,max,ipd,',',rnd,','1',10),(830,'mr','unlink',230,',open,biz,max,ipd,',',rnd,','1',11),(831,'mr','approval',230,',open,biz,max,ipd,',',rnd,','1',13),(832,'mr','close',230,',open,biz,max,ipd,',',rnd,','1',14),(833,'mr','reopen',230,',open,biz,max,ipd,',',rnd,','1',15),(834,'mr','addReview',230,',open,biz,max,ipd,',',rnd,','1',12),(835,'budget','browse',186,',max,ipd,',',rnd,','1',5),(836,'budget','summary',186,',max,ipd,',',rnd,','1',10),(837,'budget','create',186,',max,ipd,',',rnd,','1',15),(838,'budget','batchCreate',186,',max,ipd,',',rnd,','1',20),(839,'budget','edit',186,',max,ipd,',',rnd,','1',25),(840,'budget','view',186,',max,ipd,',',rnd,','1',30),(841,'budget','delete',186,',max,ipd,',',rnd,','1',35),(842,'workestimation','index',187,',max,ipd,',',rnd,','1',5),(843,'durationestimation','index',188,',max,ipd,',',rnd,','1',5),(844,'durationestimation','create',188,',max,ipd,',',rnd,','1',10),(845,'holiday','browse',110,',open,biz,max,ipd,',',rnd,','1',5),(846,'holiday','create',110,',open,biz,max,ipd,',',rnd,','1',10),(847,'holiday','edit',110,',open,biz,max,ipd,',',rnd,','1',15),(848,'holiday','delete',110,',open,biz,max,ipd,',',rnd,','1',20),(849,'holiday','import',110,',open,biz,max,ipd,',',rnd,','1',25),(850,'weekly','index',182,',max,ipd,',',rnd,','1',5),(851,'weekly','exportweeklyreport',182,',max,ipd,',',rnd,','1',10),(852,'opportunity','browse',199,',max,ipd,',',rnd,','1',5),(853,'opportunity','create',200,',max,ipd,',',rnd,','1',0),(854,'opportunity','edit',200,',max,ipd,',',rnd,','1',2),(855,'opportunity','delete',201,',max,ipd,',',rnd,','1',20),(856,'opportunity','activate',200,',max,ipd,',',rnd,','1',4),(857,'opportunity','close',200,',max,ipd,',',rnd,','1',10),(858,'opportunity','hangup',200,',max,ipd,',',rnd,','1',8),(859,'opportunity','cancel',200,',max,ipd,',',rnd,','1',13),(860,'opportunity','track',200,',max,ipd,',',rnd,','1',12),(861,'opportunity','view',199,',max,ipd,',',rnd,','1',50),(862,'opportunity','assignTo',200,',max,ipd,',',rnd,','1',6),(863,'opportunity','batchCreate',200,',max,ipd,',',rnd,','1',1),(864,'opportunity','batchEdit',200,',max,ipd,',',rnd,','1',3),(865,'opportunity','batchAssignTo',200,',max,ipd,',',rnd,','1',7),(866,'opportunity','batchClose',200,',max,ipd,',',rnd,','1',11),(867,'opportunity','batchCancel',200,',max,ipd,',',rnd,','1',14),(868,'opportunity','batchHangup',200,',max,ipd,',',rnd,','1',9),(869,'opportunity','batchActivate',200,',max,ipd,',',rnd,','1',5),(870,'opportunity','importToLib',202,',max,ipd,',',rnd,','1',95),(871,'opportunity','batchImportToLib',202,',max,ipd,',',rnd,','1',100),(872,'opportunity','importFromLib',203,',max,ipd,',',rnd,','1',105),(873,'opportunity','export',203,',max,ipd,',',rnd,','1',110),(874,'trainplan','browse',209,',max,ipd,',',rnd,','1',0),(875,'trainplan','create',209,',max,ipd,',',rnd,','1',2),(876,'trainplan','edit',209,',max,ipd,',',rnd,','1',4),(877,'trainplan','batchCreate',209,',max,ipd,',',rnd,','1',3),(878,'trainplan','batchEdit',209,',max,ipd,',',rnd,','1',5),(879,'trainplan','batchFinish',209,',max,ipd,',',rnd,','1',7),(880,'trainplan','delete',209,',max,ipd,',',rnd,','1',8),(881,'trainplan','finish',209,',max,ipd,',',rnd,','1',6),(882,'trainplan','summary',209,',max,ipd,',',rnd,','1',9),(883,'trainplan','view',209,',max,ipd,',',rnd,','1',1),(884,'nc','browse',207,',max,ipd,',',rnd,','1',0),(885,'nc','create',207,',max,ipd,',',rnd,','1',2),(886,'nc','edit',207,',max,ipd,',',rnd,','1',3),(887,'nc','resolve',207,',max,ipd,',',rnd,','1',4),(888,'nc','view',207,',max,ipd,',',rnd,','1',1),(889,'nc','close',207,',max,ipd,',',rnd,','1',5),(890,'nc','delete',207,',max,ipd,',',rnd,','1',6),(891,'nc','assignTo',207,',max,ipd,',',rnd,','1',7),(892,'nc','activate',207,',max,ipd,',',rnd,','1',8),(893,'nc','export',207,',max,ipd,',',rnd,','1',9),(894,'gapanalysis','browse',210,',max,ipd,',',rnd,','1',0),(895,'gapanalysis','create',210,',max,ipd,',',rnd,','1',2),(896,'gapanalysis','edit',210,',max,ipd,',',rnd,','1',4),(897,'gapanalysis','batchCreate',210,',max,ipd,',',rnd,','1',3),(898,'gapanalysis','batchEdit',210,',max,ipd,',',rnd,','1',5),(899,'gapanalysis','delete',210,',max,ipd,',',rnd,','1',6),(900,'gapanalysis','view',210,',max,ipd,',',rnd,','1',1),(901,'researchplan','browse',184,',max,ipd,',',rnd,','1',0),(902,'researchplan','create',184,',max,ipd,',',rnd,','1',2),(903,'researchplan','edit',184,',max,ipd,',',rnd,','1',3),(904,'researchplan','delete',184,',max,ipd,',',rnd,','1',4),(905,'researchplan','view',184,',max,ipd,',',rnd,','1',1),(906,'researchreport','browse',185,',max,ipd,',',rnd,','1',0),(907,'researchreport','create',185,',max,ipd,',',rnd,','1',2),(908,'researchreport','edit',185,',max,ipd,',',rnd,','1',3),(909,'researchreport','delete',185,',max,ipd,',',rnd,','1',4),(910,'researchreport','view',185,',max,ipd,',',rnd,','1',1),(911,'meeting','browse',208,',max,ipd,',',rnd,','1',0),(912,'meeting','create',208,',max,ipd,',',rnd,','1',2),(913,'meeting','edit',208,',max,ipd,',',rnd,','1',3),(914,'meeting','delete',208,',max,ipd,',',rnd,','1',4),(915,'meeting','view',208,',max,ipd,',',rnd,','1',1),(916,'meeting','minutes',208,',max,ipd,',',rnd,','1',5),(917,'meetingroom','browse',280,',max,ipd,',',rnd,','1',0),(918,'meetingroom','create',280,',max,ipd,',',rnd,','1',2),(919,'meetingroom','edit',280,',max,ipd,',',rnd,','1',4),(920,'meetingroom','delete',280,',max,ipd,',',rnd,','1',6),(921,'meetingroom','view',280,',max,ipd,',',rnd,','1',1),(922,'meetingroom','batchCreate',280,',max,ipd,',',rnd,','1',3),(923,'meetingroom','batchEdit',280,',max,ipd,',',rnd,','1',5),(924,'approval','progress',277,',max,ipd,',',rnd,','1',10),(925,'workflow','browseFlow',223,',biz,max,ipd,',',rnd,lite,','1',5),(926,'workflow','browseDB',223,',biz,max,ipd,',',rnd,lite,','1',10),(927,'workflow','create',223,',biz,max,ipd,',',rnd,lite,','1',15),(928,'workflow','copy',223,',biz,max,ipd,',',rnd,lite,','1',20),(929,'workflow','edit',223,',biz,max,ipd,',',rnd,lite,','1',25),(930,'workflow','backup',223,',biz,max,ipd,',',rnd,lite,','1',30),(931,'workflow','upgrade',223,',biz,max,ipd,',',rnd,lite,','1',35),(932,'workflow','view',223,',biz,max,ipd,',',rnd,lite,','1',40),(933,'workflow','delete',223,',biz,max,ipd,',',rnd,lite,','1',45),(934,'workflow','flowchart',223,',biz,max,ipd,',',rnd,lite,','1',50),(935,'workflow','ui',223,',biz,max,ipd,',',rnd,lite,','1',55),(936,'workflow','release',223,',biz,max,ipd,',',rnd,lite,','1',60),(937,'workflow','deactivate',223,',biz,max,ipd,',',rnd,lite,','1',65),(938,'workflow','activate',223,',biz,max,ipd,',',rnd,lite,','1',70),(939,'workflow','setApproval',223,',max,',',rnd,','1',75),(940,'workflow','setJS',223,',biz,max,ipd,',',rnd,lite,','1',80),(941,'workflow','setCSS',223,',biz,max,ipd,',',rnd,lite,','1',85),(942,'workflowfield','browse',211,',biz,max,ipd,',',rnd,lite,','1',5),(943,'workflowfield','create',211,',biz,max,ipd,',',rnd,lite,','1',10),(944,'workflowfield','edit',211,',biz,max,ipd,',',rnd,lite,','1',15),(945,'workflowfield','delete',211,',biz,max,ipd,',',rnd,lite,','1',20),(946,'workflowfield','sort',211,',biz,max,ipd,',',rnd,lite,','1',25),(947,'workflowfield','import',211,',biz,max,ipd,',',rnd,lite,','1',30),(948,'workflowfield','showImport',211,',biz,max,ipd,',',rnd,lite,','1',35),(949,'workflowfield','exportTemplate',211,',biz,max,ipd,',',rnd,lite,','1',40),(950,'workflowfield','setValue',211,',biz,max,ipd,',',rnd,lite,','1',45),(951,'workflowfield','setExport',211,',biz,max,ipd,',',rnd,lite,','1',50),(952,'workflowfield','setSearch',211,',biz,max,ipd,',',rnd,lite,','1',55),(953,'workflowaction','browse',212,',biz,max,ipd,',',rnd,lite,','1',5),(954,'workflowaction','create',212,',biz,max,ipd,',',rnd,lite,','1',10),(955,'workflowaction','edit',212,',biz,max,ipd,',',rnd,lite,','1',15),(956,'workflowaction','view',212,',biz,max,ipd,',',rnd,lite,','1',20),(957,'workflowaction','delete',212,',biz,max,ipd,',',rnd,lite,','1',25),(958,'workflowaction','sort',212,',biz,max,ipd,',',rnd,lite,','1',30),(959,'workflowaction','setVerification',212,',biz,max,ipd,',',rnd,lite,','1',35),(960,'workflowaction','setNotice',212,',biz,max,ipd,',',rnd,lite,','1',40),(961,'workflowaction','setJS',212,',biz,max,ipd,',',rnd,lite,','1',45),(962,'workflowaction','setCSS',212,',biz,max,ipd,',',rnd,lite,','1',50),(963,'workflowlayout','admin',213,',biz,max,ipd,',',rnd,lite,','1',5),(964,'workflowlayout','block',213,',biz,max,ipd,',',rnd,lite,','1',10),(965,'workflowcondition','browse',214,',biz,max,ipd,',',rnd,lite,','1',5),(966,'workflowcondition','create',214,',biz,max,ipd,',',rnd,lite,','1',10),(967,'workflowcondition','edit',214,',biz,max,ipd,',',rnd,lite,','1',15),(968,'workflowcondition','delete',214,',biz,max,ipd,',',rnd,lite,','1',20),(969,'workflowlinkage','browse',215,',biz,max,ipd,',',rnd,lite,','1',5),(970,'workflowlinkage','create',215,',biz,max,ipd,',',rnd,lite,','1',10),(971,'workflowlinkage','edit',215,',biz,max,ipd,',',rnd,lite,','1',15),(972,'workflowlinkage','delete',215,',biz,max,ipd,',',rnd,lite,','1',20),(973,'workflowhook','browse',216,',biz,max,ipd,',',rnd,lite,','1',5),(974,'workflowhook','create',216,',biz,max,ipd,',',rnd,lite,','1',10),(975,'workflowhook','edit',216,',biz,max,ipd,',',rnd,lite,','1',15),(976,'workflowhook','delete',216,',biz,max,ipd,',',rnd,lite,','1',20),(977,'workflowlabel','browse',217,',biz,max,ipd,',',rnd,lite,','1',5),(978,'workflowlabel','create',217,',biz,max,ipd,',',rnd,lite,','1',10),(979,'workflowlabel','edit',217,',biz,max,ipd,',',rnd,lite,','1',15),(980,'workflowlabel','delete',217,',biz,max,ipd,',',rnd,lite,','1',20),(981,'workflowlabel','sort',217,',biz,max,ipd,',',rnd,lite,','1',25),(982,'workflowrelation','admin',295,',biz,max,ipd,',',rnd,lite,','1',5),(983,'workflowreport','browse',220,',biz,max,ipd,',',rnd,lite,','1',5),(984,'workflowreport','create',220,',biz,max,ipd,',',rnd,lite,','1',10),(985,'workflowreport','edit',220,',biz,max,ipd,',',rnd,lite,','1',15),(986,'workflowreport','delete',220,',biz,max,ipd,',',rnd,lite,','1',20),(987,'workflowreport','sort',220,',biz,max,ipd,',',rnd,lite,','1',25),(988,'workflowdatasource','browse',221,',biz,max,ipd,',',rnd,lite,','1',5),(989,'workflowdatasource','create',221,',biz,max,ipd,',',rnd,lite,','1',10),(990,'workflowdatasource','edit',221,',biz,max,ipd,',',rnd,lite,','1',15),(991,'workflowdatasource','delete',221,',biz,max,ipd,',',rnd,lite,','1',20),(992,'workflowrule','browse',222,',biz,max,ipd,',',rnd,lite,','1',5),(993,'workflowrule','create',222,',biz,max,ipd,',',rnd,lite,','1',10),(994,'workflowrule','edit',222,',biz,max,ipd,',',rnd,lite,','1',15),(995,'workflowrule','view',222,',biz,max,ipd,',',rnd,lite,','1',20),(996,'workflowrule','delete',222,',biz,max,ipd,',',rnd,lite,','1',25),(997,'projectbuild','browse',265,',open,biz,max,ipd,',',rnd,','1',0),(998,'projectbuild','create',265,',open,biz,max,ipd,',',rnd,','1',2),(999,'projectbuild','edit',265,',open,biz,max,ipd,',',rnd,','1',3),(1000,'projectbuild','view',265,',open,biz,max,ipd,',',rnd,','1',1),(1001,'projectbuild','delete',265,',open,biz,max,ipd,',',rnd,','1',4),(1002,'projectbuild','linkStory',265,',open,biz,max,ipd,',',rnd,','1',5),(1003,'projectbuild','unlinkStory',265,',open,biz,max,ipd,',',rnd,','1',6),(1004,'projectbuild','batchUnlinkStory',265,',open,biz,max,ipd,',',rnd,','1',7),(1005,'projectbuild','linkBug',265,',open,biz,max,ipd,',',rnd,','1',8),(1006,'projectbuild','unlinkBug',265,',open,biz,max,ipd,',',rnd,','1',9),(1007,'projectbuild','batchUnlinkBug',265,',open,biz,max,ipd,',',rnd,','1',10),(1008,'projectrelease','browse',181,',open,biz,max,ipd,',',rnd,','1',0),(1009,'projectrelease','create',303,',open,biz,max,ipd,',',rnd,','1',2),(1010,'projectrelease','edit',303,',open,biz,max,ipd,',',rnd,','1',3),(1011,'projectrelease','delete',304,',open,biz,max,ipd,',',rnd,','1',4),(1012,'projectrelease','view',181,',open,biz,max,ipd,',',rnd,','1',1),(1013,'projectrelease','export',305,',open,biz,max,ipd,',',rnd,','1',12),(1014,'projectrelease','linkStory',303,',open,biz,max,ipd,',',rnd,','1',5),(1015,'projectrelease','unlinkStory',303,',open,biz,max,ipd,',',rnd,','1',6),(1016,'projectrelease','batchUnlinkStory',303,',open,biz,max,ipd,',',rnd,','1',7),(1017,'projectrelease','linkBug',303,',open,biz,max,ipd,',',rnd,','1',8),(1018,'projectrelease','unlinkBug',303,',open,biz,max,ipd,',',rnd,','1',9),(1019,'projectrelease','batchUnlinkBug',303,',open,biz,max,ipd,',',rnd,','1',10),(1020,'projectrelease','changeStatus',303,',open,biz,max,ipd,',',rnd,','1',11),(1021,'projectrelease','notify',306,',open,biz,max,ipd,',',rnd,','1',13),(1022,'stakeholder','browse',264,',open,biz,max,ipd,',',rnd,','1',0),(1023,'stakeholder','create',264,',open,biz,max,ipd,',',rnd,','1',2),(1024,'stakeholder','batchCreate',264,',open,biz,max,ipd,',',rnd,','1',3),(1025,'stakeholder','edit',264,',open,biz,max,ipd,',',rnd,','1',4),(1027,'stakeholder','delete',264,',open,biz,max,ipd,',',rnd,','1',5),(1028,'stakeholder','view',264,',open,biz,max,ipd,',',rnd,','1',1),(1031,'stakeholder','communicate',264,',open,biz,max,ipd,',',rnd,','1',6),(1032,'stakeholder','expect',264,',open,biz,max,ipd,',',rnd,','1',7),(1038,'stakeholder','userIssue',264,',open,biz,max,ipd,',',rnd,','1',8),(1039,'branch','manage',24,',open,biz,max,ipd,',',rnd,or,','1',0),(1040,'branch','create',24,',open,biz,max,ipd,',',rnd,or,','1',1),(1041,'branch','edit',24,',open,biz,max,ipd,',',rnd,or,','1',2),(1042,'branch','close',24,',open,biz,max,ipd,',',rnd,or,','1',7),(1043,'branch','activate',24,',open,biz,max,ipd,',',rnd,or,','1',4),(1044,'branch','sort',24,',open,biz,max,ipd,',',rnd,or,','1',5),(1045,'branch','batchEdit',24,',open,biz,max,ipd,',',rnd,or,','1',3),(1046,'branch','mergeBranch',24,',open,biz,max,ipd,',',rnd,or,','1',6),(1047,'repo','create',239,',open,biz,max,ipd,',',rnd,','1',2),(1048,'repo','edit',239,',open,biz,max,ipd,',',rnd,','1',4),(1049,'repo','delete',239,',open,biz,max,ipd,',',rnd,','1',5),(1050,'repo','showSyncCommit',224,',open,biz,max,ipd,',',rnd,','1',0),(1051,'repo','maintain',239,',open,biz,max,ipd,',',rnd,','1',0),(1052,'repo','browse',239,',open,biz,max,ipd,',',rnd,','1',1),(1053,'repo','view',224,',open,biz,max,ipd,',',rnd,','1',1),(1054,'repo','diff',227,',open,biz,max,ipd,',',rnd,','1',0),(1055,'repo','log',224,',open,biz,max,ipd,',',rnd,','1',3),(1056,'repo','revision',224,',open,biz,max,ipd,',',rnd,','1',4),(1057,'repo','blame',224,',open,biz,max,ipd,',',rnd,','1',2),(1058,'repo','download',225,',open,biz,max,ipd,',',rnd,','1',1),(1059,'repo','setRules',245,',open,biz,max,ipd,',',rnd,','1',5),(1060,'repo','apiGetRepoByUrl',239,',open,biz,max,ipd,',',rnd,','1',6),(1061,'repo','downloadCode',225,',open,biz,max,ipd,',',rnd,','1',0),(1062,'repo','linkStory',224,',open,biz,max,ipd,',',rnd,','1',5),(1063,'repo','linkBug',224,',open,biz,max,ipd,',',rnd,','1',6),(1064,'repo','linkTask',224,',open,biz,max,ipd,',',rnd,','1',7),(1065,'repo','unlink',224,',open,biz,max,ipd,',',rnd,','1',8),(1066,'repo','review',227,',biz,max,ipd,',',rnd,','1',1),(1067,'repo','addBug',227,',biz,max,ipd,',',rnd,','1',2),(1068,'repo','editBug',227,',biz,max,ipd,',',rnd,','1',3),(1069,'repo','deleteBug',227,',biz,max,ipd,',',rnd,','1',4),(1070,'repo','addComment',227,',biz,max,ipd,',',rnd,','1',5),(1071,'repo','editComment',227,',biz,max,ipd,',',rnd,','1',6),(1072,'repo','deleteComment',227,',biz,max,ipd,',',rnd,','1',7),(1073,'ci','commitResult',298,',open,biz,max,ipd,',',rnd,','1',5),(1074,'ci','checkCompileStatus',298,',open,biz,max,ipd,',',rnd,','1',10),(1075,'compile','browse',246,',open,biz,max,ipd,',',rnd,','1',5),(1076,'compile','logs',246,',open,biz,max,ipd,',',rnd,','1',7),(1077,'compile','syncCompile',246,',open,biz,max,ipd,',',rnd,','1',8),(1078,'jenkins','browse',255,',open,biz,max,ipd,',',rnd,','1',5),(1079,'jenkins','create',255,',open,biz,max,ipd,',',rnd,','1',10),(1080,'jenkins','edit',255,',open,biz,max,ipd,',',rnd,','1',15),(1081,'jenkins','delete',255,',open,biz,max,ipd,',',rnd,','1',20),(1082,'job','browse',246,',open,biz,max,ipd,',',rnd,','1',0),(1083,'job','create',246,',open,biz,max,ipd,',',rnd,','1',1),(1084,'job','edit',246,',open,biz,max,ipd,',',rnd,','1',2),(1085,'job','delete',246,',open,biz,max,ipd,',',rnd,','1',3),(1086,'job','exec',246,',open,biz,max,ipd,',',rnd,','1',4),(1087,'job','view',246,',open,biz,max,ipd,',',rnd,','1',6),(1088,'datatable','setGlobal',296,',open,biz,max,ipd,',',rnd,lite,','1',5),(1089,'gitlab','browse',240,',open,biz,max,ipd,',',rnd,','1',0),(1090,'gitlab','create',240,',open,biz,max,ipd,',',rnd,','1',2),(1091,'gitlab','edit',240,',open,biz,max,ipd,',',rnd,','1',3),(1092,'gitlab','view',240,',open,biz,max,ipd,',',rnd,','1',1),(1093,'gitlab','importIssue',240,',open,biz,max,ipd,',',rnd,','1',7),(1094,'gitlab','delete',240,',open,biz,max,ipd,',',rnd,','1',4),(1095,'gitlab','bindUser',240,',open,biz,max,ipd,',',rnd,','1',6),(1096,'gitlab','browseProject',240,',open,biz,max,ipd,',',rnd,','1',9),(1097,'gitlab','createProject',240,',open,biz,max,ipd,',',rnd,','1',10),(1098,'gitlab','editProject',240,',open,biz,max,ipd,',',rnd,','1',11),(1099,'gitlab','deleteProject',240,',open,biz,max,ipd,',',rnd,','1',12),(1100,'gitlab','browseGroup',240,',open,biz,max,ipd,',',rnd,','1',14),(1101,'gitlab','createGroup',240,',open,biz,max,ipd,',',rnd,','1',15),(1102,'gitlab','editGroup',240,',open,biz,max,ipd,',',rnd,','1',16),(1103,'gitlab','deleteGroup',240,',open,biz,max,ipd,',',rnd,','1',17),(1104,'gitlab','manageGroupMembers',240,',open,biz,max,ipd,',',rnd,','1',18),(1105,'gitlab','browseUser',240,',open,biz,max,ipd,',',rnd,','1',19),(1106,'gitlab','createUser',240,',open,biz,max,ipd,',',rnd,','1',20),(1107,'gitlab','editUser',240,',open,biz,max,ipd,',',rnd,','1',21),(1108,'gitlab','deleteUser',240,',open,biz,max,ipd,',',rnd,','1',22),(1109,'gitlab','createBranch',240,',open,biz,max,ipd,',',rnd,','1',28),(1110,'gitlab','browseBranch',240,',open,biz,max,ipd,',',rnd,','1',27),(1111,'gitlab','webhook',240,',open,biz,max,ipd,',',rnd,','1',30),(1112,'gitlab','createWebhook',240,',open,biz,max,ipd,',',rnd,','1',8),(1113,'gitlab','manageProjectMembers',240,',open,biz,max,ipd,',',rnd,','1',13),(1114,'gitlab','manageBranchPriv',240,',open,biz,max,ipd,',',rnd,','1',29),(1115,'gitlab','manageTagPriv',240,',open,biz,max,ipd,',',rnd,','1',26),(1116,'gitlab','browseTag',240,',open,biz,max,ipd,',',rnd,','1',23),(1117,'gitlab','createTag',240,',open,biz,max,ipd,',',rnd,','1',24),(1118,'gitlab','deleteTag',240,',open,biz,max,ipd,',',rnd,','1',25),(1120,'gogs','browse',242,',open,biz,max,ipd,',',rnd,','1',0),(1121,'gogs','create',242,',open,biz,max,ipd,',',rnd,','1',2),(1122,'gogs','edit',242,',open,biz,max,ipd,',',rnd,','1',3),(1123,'gogs','view',242,',open,biz,max,ipd,',',rnd,','1',1),(1124,'gogs','delete',242,',open,biz,max,ipd,',',rnd,','1',4),(1125,'gogs','bindUser',242,',open,biz,max,ipd,',',rnd,','1',5),(1126,'gitea','browse',243,',open,biz,max,ipd,',',rnd,','1',0),(1127,'gitea','create',243,',open,biz,max,ipd,',',rnd,','1',2),(1128,'gitea','edit',243,',open,biz,max,ipd,',',rnd,','1',3),(1129,'gitea','view',243,',open,biz,max,ipd,',',rnd,','1',1),(1130,'gitea','delete',243,',open,biz,max,ipd,',',rnd,','1',4),(1131,'gitea','bindUser',243,',open,biz,max,ipd,',',rnd,','1',5),(1132,'sonarqube','browse',244,',open,biz,max,ipd,',',rnd,','1',0),(1133,'sonarqube','create',244,',open,biz,max,ipd,',',rnd,','1',1),(1134,'sonarqube','edit',244,',open,biz,max,ipd,',',rnd,','1',2),(1135,'sonarqube','delete',244,',open,biz,max,ipd,',',rnd,','1',3),(1136,'sonarqube','browseProject',244,',open,biz,max,ipd,',',rnd,','1',4),(1137,'sonarqube','createProject',244,',open,biz,max,ipd,',',rnd,','1',5),(1138,'sonarqube','deleteProject',244,',open,biz,max,ipd,',',rnd,','1',6),(1139,'sonarqube','execJob',244,',open,biz,max,ipd,',',rnd,','1',7),(1140,'sonarqube','reportView',244,',open,biz,max,ipd,',',rnd,','1',8),(1141,'sonarqube','browseIssue',244,',open,biz,max,ipd,',',rnd,','1',9),(1142,'app','serverlink',229,',open,biz,max,ipd,',',rnd,','1',5),(1143,'webhook','browse',238,',open,biz,max,ipd,',',lite,rnd,or,','1',5),(1144,'webhook','create',238,',open,biz,max,ipd,',',lite,rnd,or,','1',10),(1145,'webhook','edit',238,',open,biz,max,ipd,',',lite,rnd,or,','1',15),(1146,'webhook','delete',238,',open,biz,max,ipd,',',lite,rnd,or,','1',20),(1147,'webhook','log',238,',open,biz,max,ipd,',',lite,rnd,or,','1',25),(1148,'webhook','bind',238,',open,biz,max,ipd,',',lite,rnd,or,','1',30),(1149,'webhook','chooseDept',238,',open,biz,max,ipd,',',lite,rnd,or,','1',35),(1150,'message','index',236,',open,biz,max,ipd,',',lite,rnd,or,','1',5),(1151,'message','browser',236,',open,biz,max,ipd,',',lite,rnd,or,','1',10),(1152,'message','setting',236,',open,biz,max,ipd,',',lite,rnd,or,','1',15),(1153,'effort','calendar',291,',biz,max,ipd,',',rnd,lite,or,','1',0),(1154,'effort','batchCreate',291,',biz,max,ipd,',',rnd,lite,or,','1',3),(1155,'effort','createForObject',261,',biz,max,ipd,',',rnd,lite,or,','1',3),(1156,'effort','edit',291,',biz,max,ipd,',',rnd,lite,or,','1',4),(1157,'effort','batchEdit',291,',biz,max,ipd,',',rnd,lite,or,','1',5),(1158,'effort','view',291,',biz,max,ipd,',',rnd,lite,or,','1',2),(1159,'effort','delete',291,',biz,max,ipd,',',rnd,lite,or,','1',6),(1160,'effort','export',291,',biz,max,ipd,',',rnd,lite,or,','1',7),(1162,'ldap','set',253,',biz,max,ipd,',',rnd,','1',10),(1163,'sqlbuilder','browseSQLView',281,',max,ipd,',',rnd,','1',5),(1164,'sqlbuilder','createSQLView',281,',max,ipd,',',rnd,','1',10),(1165,'sqlbuilder','editSQLView',281,',max,ipd,',',rnd,','1',15),(1166,'sqlbuilder','deleteSQLView',281,',max,ipd,',',rnd,','1',20),(1168,'feedback','create',113,',biz,max,ipd,',',rnd,lite,','1',0),(1169,'feedback','edit',113,',biz,max,ipd,',',rnd,lite,','1',1),(1170,'feedback','editOthers',115,',biz,max,ipd,',',rnd,','1',10),(1171,'feedback','adminView',112,',biz,max,ipd,',',rnd,','1',25),(1172,'feedback','admin',112,',biz,max,ipd,',',rnd,','1',30),(1173,'feedback','assignTo',113,',biz,max,ipd,',',rnd,lite,','1',4),(1174,'feedback','toTask',115,',biz,max,ipd,',',rnd,','1',5),(1175,'feedback','toTodo',115,',biz,max,ipd,',',rnd,','1',7),(1176,'feedback','toBug',115,',biz,max,ipd,',',rnd,','1',6),(1177,'feedback','toStory',115,',biz,max,ipd,',',rnd,','1',3),(1178,'feedback','toTicket',115,',biz,max,ipd,',',rnd,','1',8),(1179,'feedback','toUserStory',115,',max,ipd,',',rnd,','1',4),(1180,'feedback','review',115,',biz,max,ipd,',',rnd,','1',0),(1181,'feedback','comment',113,',biz,max,ipd,',',rnd,lite,','1',5),(1182,'feedback','reply',115,',biz,max,ipd,',',rnd,','1',2),(1183,'feedback','ask',113,',biz,max,ipd,',',rnd,','1',6),(1184,'feedback','close',113,',biz,max,ipd,',',rnd,lite,','1',8),(1185,'feedback','delete',121,',biz,max,ipd,',',rnd,lite,','1',95),(1186,'feedback','activate',113,',biz,max,ipd,',',rnd,','1',3),(1187,'feedback','export',114,',biz,max,ipd,',',rnd,lite,','1',0),(1188,'feedback','batchEdit',113,',biz,max,ipd,',',rnd,','1',2),(1189,'feedback','batchClose',113,',biz,max,ipd,',',rnd,','1',9),(1190,'feedback','batchReview',115,',biz,max,ipd,',',rnd,','1',1),(1191,'feedback','batchAssignTo',113,',biz,max,ipd,',',rnd,','1',7),(1193,'feedback','products',123,',biz,max,ipd,',',rnd,','1',135),(1194,'feedback','manageProduct',123,',biz,max,ipd,',',rnd,','1',140),(1195,'feedback','import',114,',biz,max,ipd,',',rnd,','1',2),(1196,'feedback','exportTemplate',114,',biz,max,ipd,',',rnd,','1',1),(1197,'feedback','syncProduct',115,',biz,max,ipd,',',rnd,','1',9),(1198,'feedback','productSetting',123,',biz,max,ipd,',',rnd,','1',160),(1199,'faq','browse',116,',biz,max,ipd,',',rnd,lite,','1',5),(1200,'faq','create',116,',biz,max,ipd,',',rnd,','1',10),(1201,'faq','edit',116,',biz,max,ipd,',',rnd,','1',15),(1202,'faq','delete',116,',biz,max,ipd,',',rnd,','1',20),(1204,'ticket','create',118,',biz,max,ipd,',',rnd,lite,','1',0),(1205,'ticket','edit',118,',biz,max,ipd,',',rnd,lite,','1',1),(1206,'ticket','view',117,',biz,max,ipd,',',rnd,lite,','1',20),(1207,'ticket','browse',117,',biz,max,ipd,',',rnd,lite,','1',25),(1208,'ticket','assignTo',118,',biz,max,ipd,',',rnd,lite,','1',3),(1209,'ticket','createBug',118,',biz,max,ipd,',',rnd,','1',5),(1210,'ticket','createStory',118,',biz,max,ipd,',',rnd,','1',6),(1211,'ticket','start',118,',biz,max,ipd,',',rnd,','1',7),(1212,'ticket','finish',118,',biz,max,ipd,',',rnd,','1',8),(1213,'ticket','close',118,',biz,max,ipd,',',rnd,lite,','1',10),(1214,'ticket','activate',118,',biz,max,ipd,',',rnd,lite,','1',12),(1215,'ticket','delete',122,',biz,max,ipd,',',rnd,lite,','1',65),(1216,'ticket','exportTemplate',119,',biz,max,ipd,',',rnd,lite,','1',1),(1217,'ticket','import',119,',biz,max,ipd,',',rnd,lite,','1',2),(1218,'ticket','export',119,',biz,max,ipd,',',rnd,lite,','1',0),(1219,'ticket','batchEdit',118,',biz,max,ipd,',',rnd,','1',2),(1220,'ticket','batchClose',118,',biz,max,ipd,',',rnd,','1',11),(1221,'ticket','batchActivate',118,',biz,max,ipd,',',rnd,','1',13),(1222,'ticket','batchFinish',118,',biz,max,ipd,',',rnd,','1',9),(1223,'ticket','batchAssignTo',118,',biz,max,ipd,',',rnd,','1',4),(1224,'ticket','syncProduct',118,',biz,max,ipd,',',rnd,','1',14),(1225,'attend','department',105,',biz,max,ipd,',',rnd,lite,','1',25),(1226,'attend','company',105,',biz,max,ipd,',',rnd,lite,','1',30),(1227,'attend','browseReview',103,',biz,max,ipd,',',rnd,lite,','1',5),(1228,'attend','review',102,',biz,max,ipd,',',rnd,lite,','1',3),(1229,'attend','export',111,',biz,max,ipd,',',rnd,lite,','1',0),(1230,'attend','stat',105,',biz,max,ipd,',',rnd,lite,','1',35),(1231,'attend','saveStat',105,',biz,max,ipd,',',rnd,lite,','1',40),(1232,'attend','exportStat',111,',biz,max,ipd,',',rnd,lite,','1',2),(1233,'attend','detail',103,',biz,max,ipd,',',rnd,lite,','1',4),(1234,'attend','exportDetail',111,',biz,max,ipd,',',rnd,lite,','1',1),(1235,'attend','settings',104,',biz,max,ipd,',',rnd,lite,','1',0),(1236,'attend','personalSettings',104,',biz,max,ipd,',',rnd,lite,','1',1),(1237,'attend','setManager',104,',biz,max,ipd,',',rnd,lite,','1',2),(1238,'attend','personal',103,',biz,max,ipd,',',rnd,lite,','1',0),(1239,'attend','edit',103,',biz,max,ipd,',',rnd,lite,','1',1),(1240,'leave','browseReview',102,',biz,max,ipd,',',rnd,lite,','1',0),(1241,'leave','company',105,',biz,max,ipd,',',rnd,lite,','1',0),(1242,'leave','review',102,',biz,max,ipd,',',rnd,lite,','1',1),(1243,'leave','export',111,',biz,max,ipd,',',rnd,lite,','1',3),(1244,'leave','setReviewer',104,',biz,max,ipd,',',rnd,lite,','1',3),(1245,'leave','personalAnnual',104,',biz,max,ipd,',',rnd,lite,','1',4),(1246,'leave','personal',106,',biz,max,ipd,',',rnd,lite,','1',0),(1247,'leave','create',106,',biz,max,ipd,',',rnd,lite,','1',2),(1248,'leave','edit',106,',biz,max,ipd,',',rnd,lite,','1',3),(1249,'leave','delete',106,',biz,max,ipd,',',rnd,lite,','1',4),(1250,'leave','view',106,',biz,max,ipd,',',rnd,lite,','1',1),(1251,'leave','switchstatus',106,',biz,max,ipd,',',rnd,lite,','1',5),(1252,'leave','back',102,',biz,max,ipd,',',rnd,lite,','1',2),(1253,'makeup','browseReview',102,',biz,max,ipd,',',rnd,lite,','1',4),(1254,'makeup','company',105,',biz,max,ipd,',',rnd,lite,','1',1),(1255,'makeup','review',102,',biz,max,ipd,',',rnd,lite,','1',5),(1256,'makeup','export',111,',biz,max,ipd,',',rnd,lite,','1',5),(1257,'makeup','setReviewer',104,',biz,max,ipd,',',rnd,lite,','1',5),(1258,'makeup','personal',107,',biz,max,ipd,',',rnd,lite,','1',30),(1259,'makeup','create',107,',biz,max,ipd,',',rnd,lite,','1',35),(1260,'makeup','edit',107,',biz,max,ipd,',',rnd,lite,','1',40),(1261,'makeup','view',107,',biz,max,ipd,',',rnd,lite,','1',45),(1262,'makeup','delete',107,',biz,max,ipd,',',rnd,lite,','1',50),(1263,'makeup','switchstatus',107,',biz,max,ipd,',',rnd,lite,','1',55),(1264,'overtime','browseReview',102,',biz,max,ipd,',',rnd,lite,','1',6),(1265,'overtime','company',105,',biz,max,ipd,',',rnd,lite,','1',2),(1266,'overtime','review',102,',biz,max,ipd,',',rnd,lite,','1',7),(1267,'overtime','export',111,',biz,max,ipd,',',rnd,lite,','1',4),(1268,'overtime','setReviewer',104,',biz,max,ipd,',',rnd,lite,','1',6),(1269,'overtime','personal',108,',biz,max,ipd,',',rnd,lite,','1',30),(1270,'overtime','create',108,',biz,max,ipd,',',rnd,lite,','1',35),(1271,'overtime','edit',108,',biz,max,ipd,',',rnd,lite,','1',40),(1272,'overtime','view',108,',biz,max,ipd,',',rnd,lite,','1',45),(1273,'overtime','delete',108,',biz,max,ipd,',',rnd,lite,','1',50),(1274,'overtime','switchstatus',108,',biz,max,ipd,',',rnd,lite,','1',55),(1275,'lieu','company',105,',biz,max,ipd,',',rnd,lite,','1',3),(1276,'lieu','browseReview',102,',biz,max,ipd,',',rnd,lite,','1',8),(1277,'lieu','review',102,',biz,max,ipd,',',rnd,lite,','1',9),(1278,'lieu','setReviewer',104,',biz,max,ipd,',',rnd,lite,','1',7),(1279,'lieu','personal',109,',biz,max,ipd,',',rnd,lite,','1',25),(1280,'lieu','create',109,',biz,max,ipd,',',rnd,lite,','1',30),(1281,'lieu','edit',109,',biz,max,ipd,',',rnd,lite,','1',35),(1282,'lieu','delete',109,',biz,max,ipd,',',rnd,lite,','1',40),(1283,'lieu','view',109,',biz,max,ipd,',',rnd,lite,','1',45),(1284,'lieu','switchstatus',109,',biz,max,ipd,',',rnd,lite,','1',50),(1285,'ops','index',126,',biz,max,ipd,',',rnd,','1',5),(1286,'ops','setting',126,',biz,max,ipd,',',rnd,','1',10),(1287,'host','browse',127,',biz,max,ipd,',',rnd,','1',5),(1288,'host','create',127,',biz,max,ipd,',',rnd,','1',10),(1289,'host','edit',127,',biz,max,ipd,',',rnd,','1',15),(1290,'host','view',127,',biz,max,ipd,',',rnd,','1',20),(1291,'host','delete',127,',biz,max,ipd,',',rnd,','1',25),(1292,'host','changeStatus',127,',biz,max,ipd,',',rnd,','1',30),(1293,'host','treemap',127,',biz,max,ipd,',',rnd,','1',35),(1294,'serverroom','browse',128,',biz,max,ipd,',',rnd,','1',0),(1295,'serverroom','create',128,',biz,max,ipd,',',rnd,','1',2),(1296,'serverroom','edit',128,',biz,max,ipd,',',rnd,','1',3),(1297,'serverroom','view',128,',biz,max,ipd,',',rnd,','1',1),(1298,'serverroom','delete',128,',biz,max,ipd,',',rnd,','1',4),(1299,'account','browse',129,',biz,max,ipd,',',rnd,','1',0),(1300,'account','create',129,',biz,max,ipd,',',rnd,','1',2),(1301,'account','edit',129,',biz,max,ipd,',',rnd,','1',3),(1302,'account','view',129,',biz,max,ipd,',',rnd,','1',1),(1303,'account','delete',129,',biz,max,ipd,',',rnd,','1',4),(1304,'domain','browse',130,',biz,max,ipd,',',rnd,','1',0),(1305,'domain','create',130,',biz,max,ipd,',',rnd,','1',2),(1306,'domain','edit',130,',biz,max,ipd,',',rnd,','1',3),(1307,'domain','view',130,',biz,max,ipd,',',rnd,','1',1),(1308,'domain','delete',130,',biz,max,ipd,',',rnd,','1',4),(1309,'service','browse',131,',biz,max,ipd,',',rnd,','1',0),(1310,'service','create',131,',biz,max,ipd,',',rnd,','1',2),(1311,'service','edit',131,',biz,max,ipd,',',rnd,','1',3),(1312,'service','delete',131,',biz,max,ipd,',',rnd,','1',5),(1313,'service','view',131,',biz,max,ipd,',',rnd,','1',1),(1315,'service','manage',131,',biz,max,ipd,',',rnd,','1',4),(1316,'deploy','browse',132,',biz,max,ipd,',',rnd,','1',0),(1317,'deploy','create',132,',biz,max,ipd,',',rnd,','1',2),(1318,'deploy','edit',132,',biz,max,ipd,',',rnd,','1',3),(1319,'deploy','delete',132,',biz,max,ipd,',',rnd,','1',6),(1320,'deploy','activate',132,',biz,max,ipd,',',rnd,','1',4),(1321,'deploy','finish',132,',biz,max,ipd,',',rnd,','1',5),(1322,'deploy','scope',133,',biz,max,ipd,',',rnd,','1',35),(1323,'deploy','manageScope',133,',biz,max,ipd,',',rnd,','1',40),(1324,'deploy','view',132,',biz,max,ipd,',',rnd,','1',1),(1325,'deploy','cases',135,',biz,max,ipd,',',rnd,','1',50),(1326,'deploy','linkCases',135,',biz,max,ipd,',',rnd,','1',55),(1327,'deploy','unlinkCase',135,',biz,max,ipd,',',rnd,','1',60),(1328,'deploy','batchUnlinkCases',135,',biz,max,ipd,',',rnd,','1',65),(1329,'deploy','steps',134,',biz,max,ipd,',',rnd,','1',0),(1330,'deploy','manageStep',134,',biz,max,ipd,',',rnd,','1',2),(1331,'deploy','finishStep',134,',biz,max,ipd,',',rnd,','1',5),(1332,'deploy','assignTo',134,',biz,max,ipd,',',rnd,','1',4),(1333,'deploy','viewStep',134,',biz,max,ipd,',',rnd,','1',1),(1334,'deploy','editStep',134,',biz,max,ipd,',',rnd,','1',3),(1335,'deploy','deleteStep',134,',biz,max,ipd,',',rnd,','1',8),(1336,'conference','admin',254,',biz,max,ipd,',',rnd,','1',3),(1337,'traincourse','browse',124,',biz,max,ipd,',',rnd,','1',5),(1338,'traincourse','admin',125,',biz,max,ipd,',',rnd,','1',0),(1339,'traincourse','deleteCourse',125,',biz,max,ipd,',',rnd,','1',1),(1340,'traincourse','changeStatus',125,',biz,max,ipd,',',rnd,','1',2),(1341,'traincourse','uploadCourse',125,',biz,max,ipd,',',rnd,','1',3),(1342,'traincourse','viewCourse',124,',biz,max,ipd,',',rnd,','1',30),(1343,'traincourse','viewChapter',124,',biz,max,ipd,',',rnd,','1',35),(1344,'chart','browse',327,',biz,max,ipd,',',rnd,','1',5),(1345,'chart','create',327,',biz,max,ipd,',',rnd,','1',10),(1346,'chart','edit',327,',biz,max,ipd,',',rnd,','1',15),(1347,'chart','design',327,',biz,max,ipd,',',rnd,','1',20),(1348,'chart','delete',327,',biz,max,ipd,',',rnd,','1',25),(1360,'pssp','browse',204,',max,ipd,',',rnd,','1',5),(1361,'pssp','update',204,',max,ipd,',',rnd,','1',10),(1362,'baseline','templateType',262,',max,ipd,',',rnd,','1',0),(1363,'baseline','template',262,',max,ipd,',',rnd,','1',1),(1364,'baseline','createTemplate',262,',max,ipd,',',rnd,','1',3),(1365,'baseline','view',262,',max,ipd,',',rnd,','1',2),(1366,'baseline','editTemplate',262,',max,ipd,',',rnd,','1',4),(1367,'baseline','editBook',262,',max,ipd,',',rnd,','1',5),(1369,'baseline','manageBook',262,',max,ipd,',',rnd,','1',7),(1370,'baseline','delete',262,',max,ipd,',',rnd,','1',6),(1371,'classify','browse',269,',max,ipd,',',rnd,','1',5),(1372,'cm','create',180,',max,ipd,',',rnd,','1',2),(1373,'cm','delete',180,',max,ipd,',',rnd,','1',4),(1374,'cm','edit',180,',max,ipd,',',rnd,','1',3),(1375,'cm','browse',180,',max,ipd,',',rnd,','1',0),(1376,'cm','view',180,',max,ipd,',',rnd,','1',1),(1377,'cm','report',180,',max,ipd,',',rnd,','1',5),(1378,'cmcl','batchCreate',270,',max,ipd,',',rnd,','1',3),(1379,'cmcl','delete',270,',max,ipd,',',rnd,','1',5),(1380,'cmcl','edit',270,',max,ipd,',',rnd,','1',4),(1381,'cmcl','browse',270,',max,ipd,',',rnd,','1',0),(1382,'cmcl','view',270,',max,ipd,',',rnd,','1',2),(1383,'cmcl','waterfallplusBrowse',270,',max,ipd,',',rnd,','1',1),(1384,'auditcl','batchCreate',271,',max,ipd,',',rnd,','1',5),(1385,'auditcl','batchEdit',271,',max,ipd,',',rnd,','1',7),(1386,'auditcl','delete',271,',max,ipd,',',rnd,','1',8),(1387,'auditcl','edit',271,',max,ipd,',',rnd,','1',6),(1389,'auditcl','scrumBrowse',271,',max,ipd,',',rnd,','1',0),(1390,'auditcl','browse',271,',max,ipd,',',rnd,','1',1),(1391,'auditcl','agilePlusBrowse',271,',max,ipd,',',rnd,','1',2),(1392,'auditcl','waterfallplusBrowse',271,',max,ipd,',',rnd,','1',3),(1393,'reviewcl','browse',272,',max,ipd,',',rnd,','1',0),(1394,'reviewcl','create',272,',max,ipd,',',rnd,','1',5),(1395,'reviewcl','batchCreate',272,',max,ipd,',',rnd,','1',6),(1396,'reviewcl','delete',272,',max,ipd,',',rnd,','1',8),(1397,'reviewcl','edit',272,',max,ipd,',',rnd,','1',7),(1398,'reviewcl','view',272,',max,ipd,',',rnd,','1',4),(1399,'reviewcl','waterfallplusBrowse',272,',max,ipd,',',rnd,','1',1),(1400,'process','create',273,',max,ipd,',',rnd,','1',5),(1401,'process','batchCreate',273,',max,ipd,',',rnd,','1',6),(1402,'process','delete',273,',max,ipd,',',rnd,','1',8),(1403,'process','edit',273,',max,ipd,',',rnd,','1',7),(1404,'process','view',273,',max,ipd,',',rnd,','1',4),(1405,'process','updateOrder',273,',max,ipd,',',rnd,','1',9),(1406,'process','activityList',273,',max,ipd,',',rnd,','1',10),(1407,'process','scrumBrowse',273,',max,ipd,',',rnd,','1',0),(1408,'process','browse',273,',max,ipd,',',rnd,','1',1),(1409,'process','agilePlusBrowse',273,',max,ipd,',',rnd,','1',2),(1410,'process','waterfallPlusBrowse',273,',max,ipd,',',rnd,','1',3),(1411,'activity','browse',274,',max,ipd,',',rnd,','1',0),(1412,'activity','create',274,',max,ipd,',',rnd,','1',2),(1413,'activity','batchCreate',274,',max,ipd,',',rnd,','1',3),(1414,'activity','delete',274,',max,ipd,',',rnd,','1',4),(1415,'activity','edit',274,',max,ipd,',',rnd,','1',5),(1416,'activity','view',274,',max,ipd,',',rnd,','1',1),(1417,'activity','assignTo',274,',max,ipd,',',rnd,','1',6),(1418,'activity','outputList',274,',max,ipd,',',rnd,','1',8),(1419,'activity','updateOrder',274,',max,ipd,',',rnd,','1',7),(1420,'zoutput','browse',275,',max,ipd,',',rnd,','1',0),(1421,'zoutput','create',275,',max,ipd,',',rnd,','1',2),(1422,'zoutput','edit',275,',max,ipd,',',rnd,','1',4),(1423,'zoutput','batchCreate',275,',max,ipd,',',rnd,','1',3),(1424,'zoutput','batchEdit',275,',max,ipd,',',rnd,','1',5),(1425,'zoutput','delete',275,',max,ipd,',',rnd,','1',6),(1426,'zoutput','view',275,',max,ipd,',',rnd,','1',1),(1427,'zoutput','updateOrder',275,',max,ipd,',',rnd,','1',7),(1428,'auditplan','browse',206,',max,ipd,',',rnd,','1',0),(1429,'auditplan','create',206,',max,ipd,',',rnd,','1',1),(1430,'auditplan','edit',206,',max,ipd,',',rnd,','1',3),(1431,'auditplan','batchCreate',206,',max,ipd,',',rnd,','1',2),(1432,'auditplan','batchEdit',206,',max,ipd,',',rnd,','1',4),(1433,'auditplan','batchCheck',314,',max,ipd,',',rnd,','1',6),(1434,'auditplan','check',314,',max,ipd,',',rnd,','1',5),(1435,'auditplan','nc',206,',max,ipd,',',rnd,','1',8),(1436,'auditplan','result',206,',max,ipd,',',rnd,','1',7),(1437,'auditplan','delete',206,',max,ipd,',',rnd,','1',10),(1438,'auditplan','assignTo',206,',max,ipd,',',rnd,','1',9),(1439,'subject','browse',267,',max,ipd,',',rnd,','1',35),(1440,'approvalflow','browse',277,',max,ipd,',',rnd,','1',4),(1441,'approvalflow','create',277,',max,ipd,',',rnd,','1',6),(1442,'approvalflow','edit',277,',max,ipd,',',rnd,','1',7),(1443,'approvalflow','view',277,',max,ipd,',',rnd,','1',5),(1444,'approvalflow','design',277,',max,ipd,',',rnd,','1',8),(1445,'approvalflow','delete',277,',max,ipd,',',rnd,','1',9),(1446,'approvalflow','role',277,',max,ipd,',',rnd,','1',0),(1447,'approvalflow','createRole',277,',max,ipd,',',rnd,','1',1),(1448,'approvalflow','editRole',277,',max,ipd,',',rnd,','1',2),(1449,'approvalflow','deleteRole',277,',max,ipd,',',rnd,','1',3),(1450,'reviewissue','issue',179,',max,ipd,',',rnd,','1',0),(1451,'reviewissue','updateStatus',179,',max,ipd,',',rnd,','1',5),(1452,'reviewissue','resolved',179,',max,ipd,',',rnd,','1',3),(1453,'reviewissue','create',179,',max,ipd,',',rnd,','1',2),(1454,'reviewissue','edit',179,',max,ipd,',',rnd,','1',4),(1455,'reviewissue','view',179,',max,ipd,',',rnd,','1',1),(1456,'reviewissue','delete',179,',max,ipd,',',rnd,','1',6),(1457,'reviewsetting','version',272,',max,ipd,',',rnd,','1',2),(1459,'reviewsetting','waterfallplusVersion',272,',max,ipd,',',rnd,','1',3),(1460,'review','browse',178,',max,ipd,',',rnd,','1',0),(1461,'review','assess',315,',max,ipd,',',rnd,','1',4),(1462,'review','create',178,',max,ipd,',',rnd,','1',2),(1463,'review','edit',178,',max,ipd,',',rnd,','1',5),(1464,'review','view',178,',max,ipd,',',rnd,','1',1),(1465,'review','submit',178,',max,ipd,',',rnd,','1',3),(1466,'review','recall',178,',max,ipd,',',rnd,','1',6),(1467,'review','report',178,',max,ipd,',',rnd,','1',7),(1468,'review','toAudit',178,',max,ipd,',',rnd,','1',8),(1469,'review','audit',316,',max,ipd,',',rnd,','1',9),(1470,'review','delete',178,',max,ipd,',',rnd,','1',10),(1471,'measurement','settips',278,',max,ipd,',',rnd,','1',0),(1472,'measurement','setSQL',278,',max,ipd,',',rnd,','1',3),(1473,'measurement','browse',278,',max,ipd,',',rnd,','1',1),(1474,'measurement','createBasic',278,',max,ipd,',',rnd,','1',2),(1475,'measurement','delete',278,',max,ipd,',',rnd,','1',6),(1477,'measurement','editBasic',278,',max,ipd,',',rnd,','1',4),(1478,'measurement','searchMeas',278,',max,ipd,',',rnd,','1',14),(1479,'measurement','template',278,',max,ipd,',',rnd,','1',7),(1480,'measurement','createTemplate',278,',max,ipd,',',rnd,','1',23),(1481,'measurement','editTemplate',278,',max,ipd,',',rnd,','1',9),(1482,'measurement','viewTemplate',278,',max,ipd,',',rnd,','1',8),(1488,'measurement','batchEdit',278,',max,ipd,',',rnd,','1',5),(1489,'measurement','saveReport',278,',max,ipd,',',rnd,','1',24),(1490,'measrecord','browse',205,',max,ipd,',',rnd,','1',0),(1491,'assetlib','caselib',98,',max,ipd,',',rnd,','1',0),(1492,'assetlib','storylib',74,',max,ipd,',',rnd,','1',0),(1493,'assetlib','createStorylib',75,',max,ipd,',',rnd,','1',0),(1494,'assetlib','editStorylib',75,',max,ipd,',',rnd,','1',1),(1495,'assetlib','deleteStorylib',76,',max,ipd,',',rnd,','1',25),(1496,'assetlib','storyLibView',74,',max,ipd,',',rnd,','1',1),(1497,'assetlib','story',74,',max,ipd,',',rnd,','1',2),(1498,'assetlib','importStory',75,',max,ipd,',',rnd,','1',3),(1499,'assetlib','assignToStory',75,',max,ipd,',',rnd,','1',6),(1500,'assetlib','batchAssignToStory',75,',max,ipd,',',rnd,','1',7),(1501,'assetlib','approveStory',77,',max,ipd,',',rnd,','1',55),(1502,'assetlib','batchApproveStory',77,',max,ipd,',',rnd,','1',60),(1503,'assetlib','editStory',75,',max,ipd,',',rnd,','1',5),(1504,'assetlib','removeStory',75,',max,ipd,',',rnd,','1',8),(1505,'assetlib','batchRemoveStory',75,',max,ipd,',',rnd,','1',9),(1506,'assetlib','storyView',74,',max,ipd,',',rnd,','1',3),(1507,'assetlib','issuelib',78,',max,ipd,',',rnd,','1',0),(1508,'assetlib','createIssuelib',79,',max,ipd,',',rnd,','1',0),(1509,'assetlib','editIssuelib',79,',max,ipd,',',rnd,','1',1),(1510,'assetlib','deleteIssuelib',80,',max,ipd,',',rnd,','1',100),(1511,'assetlib','issueLibView',78,',max,ipd,',',rnd,','1',2),(1512,'assetlib','issue',78,',max,ipd,',',rnd,','1',1),(1513,'assetlib','importIssue',79,',max,ipd,',',rnd,','1',3),(1514,'assetlib','assignToIssue',79,',max,ipd,',',rnd,','1',5),(1515,'assetlib','batchAssignToIssue',79,',max,ipd,',',rnd,','1',6),(1516,'assetlib','approveIssue',81,',max,ipd,',',rnd,','1',130),(1517,'assetlib','batchApproveIssue',81,',max,ipd,',',rnd,','1',135),(1518,'assetlib','editIssue',79,',max,ipd,',',rnd,','1',4),(1519,'assetlib','removeIssue',79,',max,ipd,',',rnd,','1',7),(1520,'assetlib','batchRemoveIssue',79,',max,ipd,',',rnd,','1',8),(1521,'assetlib','issueView',78,',max,ipd,',',rnd,','1',3),(1522,'assetlib','risklib',82,',max,ipd,',',rnd,','1',160),(1523,'assetlib','createRisklib',83,',max,ipd,',',rnd,','1',0),(1524,'assetlib','editRisklib',83,',max,ipd,',',rnd,','1',1),(1525,'assetlib','deleteRisklib',84,',max,ipd,',',rnd,','1',175),(1526,'assetlib','riskLibView',82,',max,ipd,',',rnd,','1',180),(1527,'assetlib','risk',82,',max,ipd,',',rnd,','1',185),(1528,'assetlib','importRisk',83,',max,ipd,',',rnd,','1',3),(1529,'assetlib','assignToRisk',83,',max,ipd,',',rnd,','1',5),(1530,'assetlib','batchAssignToRisk',83,',max,ipd,',',rnd,','1',6),(1531,'assetlib','approveRisk',85,',max,ipd,',',rnd,','1',205),(1532,'assetlib','batchApproveRisk',85,',max,ipd,',',rnd,','1',210),(1533,'assetlib','editRisk',83,',max,ipd,',',rnd,','1',4),(1534,'assetlib','removeRisk',83,',max,ipd,',',rnd,','1',7),(1535,'assetlib','batchRemoveRisk',83,',max,ipd,',',rnd,','1',8),(1536,'assetlib','riskView',82,',max,ipd,',',rnd,','1',230),(1537,'assetlib','opportunitylib',86,',max,ipd,',',rnd,','1',235),(1538,'assetlib','createOpportunitylib',87,',max,ipd,',',rnd,','1',0),(1539,'assetlib','editOpportunitylib',87,',max,ipd,',',rnd,','1',1),(1540,'assetlib','deleteOpportunitylib',88,',max,ipd,',',rnd,','1',250),(1541,'assetlib','opportunityLibView',86,',max,ipd,',',rnd,','1',255),(1542,'assetlib','opportunity',86,',max,ipd,',',rnd,','1',255),(1543,'assetlib','importOpportunity',87,',max,ipd,',',rnd,','1',3),(1544,'assetlib','assignToOpportunity',87,',max,ipd,',',rnd,','1',5),(1545,'assetlib','batchAssignToOpportunity',87,',max,ipd,',',rnd,','1',6),(1546,'assetlib','approveOpportunity',89,',max,ipd,',',rnd,','1',255),(1547,'assetlib','batchApproveOpportunity',89,',max,ipd,',',rnd,','1',255),(1548,'assetlib','editOpportunity',87,',max,ipd,',',rnd,','1',4),(1549,'assetlib','removeOpportunity',87,',max,ipd,',',rnd,','1',7),(1550,'assetlib','batchRemoveOpportunity',87,',max,ipd,',',rnd,','1',8),(1551,'assetlib','opportunityView',86,',max,ipd,',',rnd,','1',255),(1552,'assetlib','practicelib',90,',max,ipd,',',rnd,','1',255),(1553,'assetlib','createPracticelib',91,',max,ipd,',',rnd,','1',0),(1554,'assetlib','editPracticelib',91,',max,ipd,',',rnd,','1',1),(1555,'assetlib','deletePracticelib',92,',max,ipd,',',rnd,','1',255),(1556,'assetlib','practiceLibView',90,',max,ipd,',',rnd,','1',255),(1557,'assetlib','practice',90,',max,ipd,',',rnd,','1',255),(1558,'assetlib','importPractice',91,',max,ipd,',',rnd,','1',3),(1559,'assetlib','assignToPractice',91,',max,ipd,',',rnd,','1',5),(1560,'assetlib','batchAssignToPractice',91,',max,ipd,',',rnd,','1',6),(1561,'assetlib','approvePractice',93,',max,ipd,',',rnd,','1',255),(1562,'assetlib','batchApprovePractice',93,',max,ipd,',',rnd,','1',255),(1563,'assetlib','editPractice',91,',max,ipd,',',rnd,','1',4),(1564,'assetlib','removePractice',91,',max,ipd,',',rnd,','1',7),(1565,'assetlib','batchRemovePractice',91,',max,ipd,',',rnd,','1',8),(1566,'assetlib','practiceView',90,',max,ipd,',',rnd,','1',255),(1567,'assetlib','componentlib',94,',max,ipd,',',rnd,','1',255),(1568,'assetlib','createComponentlib',95,',max,ipd,',',rnd,','1',0),(1569,'assetlib','editComponentlib',95,',max,ipd,',',rnd,','1',1),(1570,'assetlib','deleteComponentlib',96,',max,ipd,',',rnd,','1',255),(1571,'assetlib','componentLibView',94,',max,ipd,',',rnd,','1',255),(1572,'assetlib','component',94,',max,ipd,',',rnd,','1',255),(1573,'assetlib','importComponent',95,',max,ipd,',',rnd,','1',3),(1574,'assetlib','assignToComponent',95,',max,ipd,',',rnd,','1',5),(1575,'assetlib','batchAssignToComponent',95,',max,ipd,',',rnd,','1',6),(1576,'assetlib','approveComponent',97,',max,ipd,',',rnd,','1',255),(1577,'assetlib','batchApproveComponent',97,',max,ipd,',',rnd,','1',255),(1578,'assetlib','editComponent',95,',max,ipd,',',rnd,','1',4),(1579,'assetlib','removeComponent',95,',max,ipd,',',rnd,','1',7),(1580,'assetlib','batchRemoveComponent',95,',max,ipd,',',rnd,','1',8),(1581,'assetlib','componentView',94,',max,ipd,',',rnd,','1',255),(1583,'assetlib','storylibSort',75,',max,ipd,',',rnd,','1',2),(1584,'assetlib','caselibSort',99,',max,ipd,',',rnd,','1',2),(1585,'assetlib','issuelibSort',79,',max,ipd,',',rnd,','1',2),(1586,'assetlib','risklibSort',83,',max,ipd,',',rnd,','1',2),(1587,'assetlib','opportunitylibSort',87,',max,ipd,',',rnd,','1',2),(1588,'assetlib','practicelibSort',91,',max,ipd,',',rnd,','1',2),(1589,'assetlib','componentlibSort',95,',max,ipd,',',rnd,','1',2),(1590,'setting','xuanxuan',254,',open,biz,max,ipd,',',rnd,lite,','1',0),(1596,'im','downloadXxdPackage',254,',open,biz,max,ipd,',',rnd,lite,','1',2),(1597,'im','debug',254,',open,biz,max,ipd,',',rnd,lite,','1',1),(1598,'client','browse',254,',open,biz,max,ipd,',',rnd,lite,','1',4),(1599,'client','create',254,',open,biz,max,ipd,',',rnd,lite,','1',5),(1600,'client','edit',254,',open,biz,max,ipd,',',rnd,lite,','1',6),(1601,'client','delete',254,',open,biz,max,ipd,',',rnd,lite,','1',7),(1615,'screen','create',319,',biz,max,ipd,',',rnd,','1',5),(1616,'screen','edit',319,',biz,max,ipd,',',rnd,','1',10),(1617,'screen','design',319,',biz,max,ipd,',',rnd,','1',15),(1618,'screen','publish',319,',biz,max,ipd,',',rnd,','1',20),(1619,'screen','delete',320,',biz,max,ipd,',',rnd,','1',25),(1620,'screen','annualData',318,',open,biz,max,ipd,',',rnd,','1',30),(1621,'screen','allAnnualData',321,',open,biz,max,ipd,',',rnd,','1',35),(1622,'pivot','browse',323,',biz,max,ipd,',',rnd,','1',5),(1623,'pivot','preview',322,',open,biz,max,ipd,',',rnd,','1',0),(1624,'pivot','create',323,',biz,max,ipd,',',rnd,','1',15),(1625,'pivot','edit',323,',biz,max,ipd,',',rnd,','1',20),(1626,'pivot','design',323,',biz,max,ipd,',',rnd,','1',25),(1627,'pivot','delete',323,',biz,max,ipd,',',rnd,','1',30),(1628,'pivot','export',324,',biz,max,ipd,',',rnd,','1',35),(1629,'pivot','showProduct',325,',biz,max,ipd,',',rnd,','1',40),(1630,'pivot','showProject',325,',biz,max,ipd,',',rnd,','1',45),(1631,'pivot','projectDeviation',322,',open,biz,max,ipd,',',rnd,','1',4),(1632,'pivot','productSummary',322,',open,biz,max,ipd,',',rnd,','1',1),(1633,'pivot','bugCreate',322,',open,biz,max,ipd,',',rnd,','1',5),(1634,'pivot','bugAssign',322,',open,biz,max,ipd,',',rnd,','1',6),(1635,'pivot','workload',322,',open,biz,max,ipd,',',rnd,','1',11),(1636,'pivot','casesrun',322,',biz,max,ipd,',',rnd,','1',8),(1637,'pivot','storyLinkedBug',322,',biz,max,ipd,',',rnd,','1',10),(1638,'pivot','testcase',322,',biz,max,ipd,',',rnd,','1',7),(1639,'pivot','build',322,',biz,max,ipd,',',rnd,','1',9),(1640,'pivot','workSummary',322,',biz,max,ipd,',',rnd,','1',12),(1641,'pivot','roadmap',322,',max,ipd,',',rnd,','1',2),(1642,'pivot','productInvest',322,',biz,max,ipd,',',rnd,','1',3),(1643,'pivot','bugSummary',322,',biz,max,ipd,',',rnd,','1',14),(1644,'pivot','bugAssignSummary',322,',biz,max,ipd,',',rnd,','1',15),(1645,'pivot','workAssignSummary',322,',biz,max,ipd,',',rnd,','1',13),(1646,'chart','preview',326,',open,biz,max,ipd,',',rnd,','1',5),(1648,'dataview','browse',329,',biz,max,ipd,',',rnd,','1',5),(1649,'dataview','create',330,',biz,max,ipd,',',rnd,','1',10),(1650,'dataview','edit',330,',biz,max,ipd,',',rnd,','1',15),(1651,'dataview','query',330,',biz,max,ipd,',',rnd,','1',20),(1652,'dataview','delete',331,',biz,max,ipd,',',rnd,','1',25),(1653,'dimension','browse',317,',biz,max,ipd,',',rnd,','1',5),(1654,'dimension','create',317,',biz,max,ipd,',',rnd,','1',10),(1655,'dimension','edit',317,',biz,max,ipd,',',rnd,','1',15),(1656,'dimension','delete',317,',biz,max,ipd,',',rnd,','1',20),(1664,'custom','limitTaskDate',276,',open,biz,max,ipd,',',rnd,','1',10),(1665,'tree','browsegroup',259,',biz,max,ipd,',',rnd,','1',2),(1673,'testcase','createScene',344,',open,biz,max,ipd,',',rnd,','1',5),(1674,'testcase','editScene',344,',open,biz,max,ipd,',',rnd,','1',10),(1675,'testcase','deleteScene',344,',open,biz,max,ipd,',',rnd,','1',15),(1676,'testcase','changeScene',344,',open,biz,max,ipd,',',rnd,','1',20),(1677,'testcase','batchChangeScene',344,',open,biz,max,ipd,',',rnd,','1',25),(1678,'testcase','updateOrder',142,',open,biz,max,ipd,',',rnd,','1',30),(1679,'testcase','importXmind',143,',open,biz,max,ipd,',',rnd,','1',6),(1682,'testcase','exportXmind',143,',open,biz,max,ipd,',',rnd,','1',2),(1694,'repo','import',239,',open,biz,max,ipd,',',rnd,','1',3),(1695,'chart','export',328,',biz,max,ipd,',',rnd,','1',5),(1701,'doc','index',333,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(1702,'doc','mySpace',333,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(1703,'doc','myView',333,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(1704,'doc','myCollection',333,',open,biz,max,ipd,',',rnd,lite,or,','1',7),(1705,'doc','myCreation',333,',open,biz,max,ipd,',',rnd,lite,or,','1',8),(1706,'doc','createLib',334,',open,biz,max,ipd,',',rnd,lite,or,','1',0),(1707,'doc','editLib',334,',open,biz,max,ipd,',',rnd,lite,or,','1',1),(1708,'doc','deleteLib',335,',open,biz,max,ipd,',',rnd,lite,or,','1',40),(1709,'doc','create',334,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(1710,'doc','edit',334,',open,biz,max,ipd,',',rnd,lite,or,','1',4),(1711,'doc','view',333,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(1712,'doc','delete',335,',open,biz,max,ipd,',',rnd,lite,or,','1',60),(1713,'doc','deleteFile',335,',open,biz,max,ipd,',',rnd,lite,or,','1',65),(1714,'doc','collect',334,',open,biz,max,ipd,',',rnd,lite,or,','1',8),(1715,'doc','productSpace',333,',open,biz,max,ipd,',',rnd,or,','1',2),(1716,'doc','projectSpace',333,',open,biz,max,ipd,',',rnd,lite,or,','1',3),(1717,'doc','teamSpace',333,',open,biz,max,ipd,',',rnd,or,','1',4),(1718,'doc','showFiles',334,',open,biz,max,ipd,',',rnd,lite,or,','1',2),(1719,'doc','addCatalog',334,',open,biz,max,ipd,',',rnd,lite,or,','1',5),(1720,'doc','editCatalog',334,',open,biz,max,ipd,',',rnd,lite,or,','1',6),(1721,'doc','sortCatalog',334,',open,biz,max,ipd,',',rnd,or,','1',7),(1722,'doc','deleteCatalog',335,',open,biz,max,ipd,',',rnd,lite,or,','1',110),(1723,'doc','displaySetting',333,',open,biz,max,ipd,',',rnd,lite,or,','1',10),(1724,'doc','diff',333,',biz,max,ipd,',',rnd,lite,','1',11),(1725,'doc','mine2export',336,',biz,max,ipd,',',rnd,lite,','1',125),(1726,'doc','product2export',336,',biz,max,ipd,',',rnd,lite,','1',130),(1727,'doc','project2export',336,',biz,max,ipd,',',rnd,lite,','1',135),(1728,'doc','custom2export',336,',biz,max,ipd,',',rnd,lite,','1',140),(1729,'doc','execution2export',56,',biz,max,ipd,',',rnd,lite,','1',145),(1730,'doc','importToPracticeLib',48,',max,ipd,',',rnd,','1',150),(1731,'doc','importToComponentLib',48,',max,ipd,',',rnd,','1',155),(1732,'report','show',205,',max,ipd,',',rnd,','1',3),(1733,'report','custom',278,',max,ipd,',',rnd,','1',17),(1734,'report','editReport',278,',max,ipd,',',rnd,','1',18),(1735,'report','useReport',278,',max,ipd,',',rnd,','1',19),(1736,'report','deleteReport',278,',max,ipd,',',rnd,','1',20),(1737,'report','saveReport',278,',max,ipd,',',rnd,','1',21),(1738,'report','crystalExport',278,',max,ipd,',',rnd,','1',22),(1739,'report','customeredReport',205,',max,ipd,',',rnd,','1',4),(1740,'report','viewReport',205,',max,ipd,',',rnd,','1',5),(1741,'report','projectSummary',205,',max,ipd,',',rnd,','1',1),(1742,'report','projectWorkload',205,',max,ipd,',',rnd,','1',2),(1743,'report','export',278,',biz,max,ipd,',',rnd,','1',25),(1744,'api','index',338,',open,biz,max,ipd,',',rnd,','1',5),(1745,'api','createLib',339,',open,biz,max,ipd,',',rnd,','1',0),(1746,'api','editLib',339,',open,biz,max,ipd,',',rnd,','1',1),(1747,'api','deleteLib',341,',open,biz,max,ipd,',',rnd,','1',0),(1748,'api','createRelease',339,',open,biz,max,ipd,',',rnd,','1',4),(1749,'api','releases',339,',open,biz,max,ipd,',',rnd,','1',5),(1750,'api','deleteRelease',341,',open,biz,max,ipd,',',rnd,','1',3),(1751,'api','struct',339,',open,biz,max,ipd,',',rnd,','1',8),(1752,'api','createStruct',339,',open,biz,max,ipd,',',rnd,','1',6),(1753,'api','editStruct',339,',open,biz,max,ipd,',',rnd,','1',7),(1754,'api','deleteStruct',341,',open,biz,max,ipd,',',rnd,','1',2),(1755,'api','create',339,',open,biz,max,ipd,',',rnd,','1',2),(1756,'api','edit',339,',open,biz,max,ipd,',',rnd,','1',3),(1757,'api','delete',341,',open,biz,max,ipd,',',rnd,','1',1),(1758,'api','addCatalog',339,',open,biz,max,ipd,',',rnd,','1',9),(1759,'api','editCatalog',339,',open,biz,max,ipd,',',rnd,','1',10),(1760,'api','sortCatalog',339,',open,biz,max,ipd,',',rnd,','1',60),(1761,'api','deleteCatalog',341,',open,biz,max,ipd,',',rnd,','1',4),(1762,'api','getModel',342,',open,biz,max,ipd,',',rnd,','1',5),(1763,'api','debug',228,',open,biz,max,ipd,',',rnd,','1',35),(1764,'api','sql',342,',open,biz,max,ipd,',',rnd,','1',105),(1765,'api','export',340,',biz,max,ipd,',',rnd,','1',110),(1766,'doc','myEdited',333,',open,biz,max,ipd,',',rnd,or,','1',9),(1767,'traincourse','batchImport',125,',biz,max,ipd,',',rnd,','1',4),(2060,'product','activate',21,',ipd,',',or,rnd,','1',10),(2061,'charter','browse',636,',ipd,',',or,','1',10),(2062,'charter','create',638,',ipd,',',or,','1',20),(2063,'charter','edit',638,',ipd,',',or,','1',30),(2064,'charter','view',636,',ipd,',',or,','1',40),(2065,'charter','delete',638,',ipd,',',or,','1',50),(2066,'charter','review',639,',ipd,',',or,','1',60),(2067,'charter','loadRoadmapStories',636,',ipd,',',or,','1',70),(2068,'demandpool','browse',635,',ipd,',',or,','1',10),(2069,'demandpool','create',637,',ipd,',',or,','1',20),(2070,'demandpool','edit',637,',ipd,',',or,','1',30),(2071,'demandpool','view',635,',ipd,',',or,','1',40),(2072,'demandpool','close',637,',ipd,',',or,','1',50),(2073,'demandpool','activate',637,',ipd,',',or,','1',60),(2074,'demandpool','delete',649,',ipd,',',or,','1',70),(2075,'demand','browse',640,',ipd,',',or,','1',10),(2076,'demand','create',641,',ipd,',',or,','1',20),(2077,'demand','batchCreate',641,',ipd,',',or,','1',30),(2078,'demand','edit',641,',ipd,',',or,','1',40),(2079,'demand','view',640,',ipd,',',or,','1',50),(2080,'demand','assignTo',641,',ipd,',',or,','1',60),(2081,'demand','change',641,',ipd,',',or,','1',70),(2082,'demand','review',642,',ipd,',',or,','1',80),(2083,'demand','submitReview',642,',ipd,',',or,','1',90),(2084,'demand','recall',642,',ipd,',',or,','1',100),(2085,'demand','track',640,',ipd,',',or,','1',110),(2086,'demand','manageTree',641,',ipd,',',or,','1',120),(2091,'demand','delete',644,',ipd,',',or,','1',170),(2092,'demand','close',641,',ipd,',',or,','1',180),(2093,'demand','activate',641,',ipd,',',or,','1',190),(2094,'demand','distribute',641,',ipd,',',or,','1',200),(2095,'roadmap','browse',646,',ipd,',',or,rnd,','1',10),(2096,'roadmap','view',646,',ipd,',',or,rnd,','1',20),(2097,'roadmap','linkUR',647,',ipd,',',or,','1',30),(2098,'roadmap','create',647,',ipd,',',or,','1',40),(2099,'roadmap','edit',647,',ipd,',',or,','1',50),(2100,'roadmap','close',647,',ipd,',',or,','1',60),(2101,'roadmap','delete',648,',ipd,',',or,','1',70),(2102,'roadmap','activate',647,',ipd,',',or,','1',80),(2103,'roadmap','unlinkUR',647,',ipd,',',or,','1',90),(2104,'roadmap','batchUnlinkUR',647,',ipd,',',or,','1',100),(2105,'my','story',351,',ipd,',',lite,','1',10),(2106,'my','task',351,',ipd,',',lite,','1',20);
REPLACE INTO `zt_privmanager` (`id`, `parent`, `code`, `type`, `edition`, `vision`, `order`) VALUES (4,352,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(5,352,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(6,352,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(7,352,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(8,353,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(9,354,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(10,354,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(11,357,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(12,357,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(13,357,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(14,358,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(15,358,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(16,358,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(17,359,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(18,351,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(19,361,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(20,361,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(21,361,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(22,361,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(23,367,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(24,367,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(25,362,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(26,362,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(27,362,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(28,362,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(29,362,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(30,361,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(31,363,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(32,363,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(33,363,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(34,363,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(35,363,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(36,364,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(37,364,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(38,364,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(39,365,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(40,365,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(41,365,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(42,365,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(43,365,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(44,370,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(45,371,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(46,369,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(47,369,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(48,369,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(50,391,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(51,369,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(52,391,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(53,406,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(54,406,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(55,406,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(56,406,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(57,416,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(58,409,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(60,407,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(61,407,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(62,407,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(63,407,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(64,416,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(65,411,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(66,409,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(67,412,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(68,413,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(69,414,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(71,406,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(72,408,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(73,408,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(74,432,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(75,432,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(76,432,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(77,432,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(78,433,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(79,433,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(80,433,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(81,433,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(82,434,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(83,434,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(84,434,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(85,434,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(86,435,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(87,435,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(88,435,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(89,435,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(90,436,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(91,436,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(92,436,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(93,436,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(94,437,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(95,437,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(96,437,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(97,437,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(98,430,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(99,430,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(100,430,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(101,430,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(102,552,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(103,547,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(104,553,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(105,554,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(106,548,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(107,549,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(108,550,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(109,551,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(110,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(111,555,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(112,542,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(113,542,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(114,542,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(115,542,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(116,543,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(117,544,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(118,544,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(119,544,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(121,542,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(122,544,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(123,545,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(124,566,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(125,566,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(126,557,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(127,558,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(128,559,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(129,560,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(130,561,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(131,562,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(132,563,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(133,563,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(134,563,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(135,563,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(136,421,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(137,422,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(138,422,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(139,422,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(140,422,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(141,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(142,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(143,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(144,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(145,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(146,424,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(147,424,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(148,424,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(149,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',40),(150,425,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(151,425,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(152,425,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(153,426,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(154,426,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(155,426,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(156,426,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(157,427,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(158,427,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(159,427,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(160,427,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(161,428,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(162,428,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(163,428,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(164,428,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(165,451,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(166,452,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(167,453,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(168,454,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(169,455,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(170,456,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(171,372,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(175,373,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(176,373,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(177,373,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(178,392,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(179,392,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(180,396,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(181,389,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(182,401,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(183,401,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(184,402,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(185,402,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(186,378,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(187,378,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(188,378,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(189,375,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(190,375,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(191,375,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(192,375,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(193,375,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(194,376,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(195,376,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(196,376,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(197,376,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(198,376,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(199,381,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(200,381,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(201,381,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(202,381,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(203,381,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(204,395,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(205,400,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(206,403,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(207,403,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(208,387,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(209,404,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(210,404,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(211,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(212,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(213,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(214,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(215,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(216,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',35),(217,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',40),(218,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',45),(220,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',50),(221,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',55),(222,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',60),(223,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(224,506,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(225,506,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(226,470,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(227,506,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(228,470,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(229,470,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(230,505,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(231,479,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(232,479,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(233,479,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(234,479,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(235,463,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(236,483,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(237,483,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(238,483,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(239,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(240,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(241,483,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(242,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(243,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(244,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(245,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',35),(246,516,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(247,516,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(248,505,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(249,461,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(250,478,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(251,478,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(252,478,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(253,478,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(254,478,'','package',',open,biz,max,ipd,',',rnd,lite,or,',35),(255,517,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(256,478,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(257,518,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(258,537,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(259,519,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(260,520,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(261,540,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(262,482,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(263,362,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(264,391,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(265,388,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(266,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',35),(267,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(268,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(269,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(270,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',50),(271,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(272,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',45),(273,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(274,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',35),(275,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',40),(276,481,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(277,481,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(278,481,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(279,481,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(280,481,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(281,481,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(282,480,'','package',',open,biz,max,ipd,',',rnd,lite,or,',55),(283,419,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(284,419,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(285,418,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(286,418,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(287,418,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(288,428,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(289,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',45),(290,415,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(291,355,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(292,394,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(293,393,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(295,524,'','package',',open,biz,max,ipd,',',rnd,lite,or,',65),(296,539,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(297,536,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(298,507,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(299,504,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(300,503,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(301,538,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(302,391,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(303,389,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(304,389,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(305,389,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(306,389,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(307,372,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(308,409,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(309,408,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(311,414,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(312,418,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(313,371,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(314,403,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(315,392,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(316,392,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(317,446,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(318,442,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(319,442,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(320,442,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(321,442,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(322,443,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(323,443,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(324,443,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(325,443,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(326,444,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(327,444,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(328,444,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(329,445,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(330,445,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(331,445,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(333,439,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(334,439,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(335,439,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(336,439,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(338,440,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(339,440,'','package',',open,biz,max,ipd,',',rnd,lite,or,',10),(340,440,'','package',',open,biz,max,ipd,',',rnd,lite,or,',15),(341,440,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(342,440,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(344,423,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(345,409,'','package',',open,biz,max,ipd,',',rnd,lite,or,',20),(346,409,'','package',',open,biz,max,ipd,',',rnd,lite,or,',25),(347,409,'','package',',open,biz,max,ipd,',',rnd,lite,or,',30),(348,0,'index','view',',open,biz,max,',',rnd,',10),(349,348,'index','module',',open,biz,max,ipd,',',rnd,lite,or,',10),(350,0,'my','view',',open,biz,max,ipd,',',rnd,lite,or,',5),(351,350,'my','module',',open,biz,max,ipd,',',rnd,lite,or,',20),(352,350,'todo','module',',open,biz,max,ipd,',',rnd,lite,or,',30),(353,350,'contact','module',',open,biz,max,ipd,',',rnd,lite,or,',40),(354,350,'personalsettings','module',',open,biz,max,ipd,',',rnd,lite,or,',50),(355,350,'effort','module',',biz,max,ipd,',',rnd,lite,or,',60),(356,0,'program','view',',open,biz,max,ipd,',',rnd,',30),(357,356,'program','module',',open,biz,max,ipd,',',rnd,',70),(358,356,'personnel','module',',open,biz,max,ipd,',',rnd,lite,',80),(359,356,'programstakeholder','module',',open,biz,max,ipd,',',rnd,lite,or,',90),(360,0,'product','view',',open,biz,max,ipd,',',rnd,or,',15),(361,360,'product','module',',open,biz,max,ipd,',',rnd,or,',100),(362,360,'story','module',',open,biz,max,ipd,',',rnd,lite,',110),(363,360,'requirement','module',',open,biz,max,ipd,',',rnd,or,',120),(364,360,'productplan','module',',open,biz,max,ipd,',',rnd,',130),(365,360,'release','module',',open,biz,max,ipd,',',rnd,',140),(366,360,'branch','module',',open,biz,max,ipd,',',rnd,or,',150),(367,360,'productsettings','module',',open,biz,max,ipd,',',rnd,lite,or,',160),(368,0,'project','view',',open,biz,max,ipd,',',rnd,lite,',50),(369,368,'project','module',',open,biz,max,ipd,',',rnd,lite,',170),(370,368,'projectplan','module',',open,biz,max,ipd,',',rnd,',180),(371,368,'projectstory','module',',open,biz,max,ipd,',',rnd,lite,',190),(372,368,'programplan','module',',open,biz,max,ipd,',',rnd,',200),(373,368,'design','module',',open,biz,max,ipd,',',rnd,',210),(374,368,'milestone','module',',max,ipd,',',rnd,',220),(375,368,'issue','module',',max,ipd,',',rnd,',230),(376,368,'risk','module',',max,ipd,',',rnd,',240),(377,368,'budget','module',',max,ipd,',',rnd,',250),(378,368,'workestimation','module',',open,biz,max,ipd,',',rnd,lite,or,',260),(379,368,'durationestimation','module',',max,ipd,',',rnd,',270),(380,368,'weekly','module',',max,ipd,',',rnd,',280),(381,368,'opportunity','module',',max,ipd,',',rnd,',290),(382,368,'trainplan','module',',max,ipd,',',rnd,',300),(383,368,'nc','module',',max,ipd,',',rnd,',310),(384,368,'gapanalysis','module',',open,biz,max,ipd,',',rnd,lite,or,',320),(385,368,'researchplan','module',',open,biz,max,ipd,',',rnd,lite,or,',330),(386,368,'researchreport','module',',max,ipd,',',rnd,',340),(387,368,'meeting','module',',max,ipd,',',rnd,',350),(388,368,'projectbuild','module',',open,biz,max,ipd,',',rnd,',360),(389,368,'projectrelease','module',',open,biz,max,ipd,',',rnd,',370),(390,368,'stakeholder','module',',open,biz,max,ipd,',',rnd,',380),(391,368,'projectsettings','module',',open,biz,max,ipd,',',rnd,lite,or,',390),(392,368,'projectreview','module',',open,biz,max,ipd,',',rnd,lite,or,',400),(393,368,'projecttrack','module',',open,biz,max,ipd,',',rnd,lite,or,',410),(394,368,'projectqa','module',',open,biz,max,ipd,',',rnd,lite,or,',420),(395,368,'pssp','module',',max,ipd,',',rnd,',430),(396,368,'cm','module',',max,ipd,',',rnd,',440),(397,368,'auditplan','module',',max,ipd,',',rnd,',450),(398,368,'reviewissue','module',',max,ipd,',',rnd,',460),(399,368,'review','module',',max,ipd,',',rnd,',470),(400,368,'measrecord','module',',max,ipd,',',rnd,',480),(401,368,'projectreport','module',',max,ipd,',',rnd,',490),(402,368,'projectresearch','module',',max,ipd,',',rnd,',500),(403,368,'projectauditplan','module',',max,ipd,',',rnd,',510),(404,368,'projectgapanalysis','module',',max,ipd,',',rnd,',520),(405,0,'execution','view',',open,biz,max,ipd,',',rnd,lite,',60),(406,405,'execution','module',',open,biz,max,ipd,',',rnd,lite,',530),(407,405,'task','module',',open,biz,max,ipd,',',rnd,lite,',540),(408,405,'build','module',',open,biz,max,ipd,',',rnd,',550),(409,405,'executionview','module',',open,biz,max,ipd,',',rnd,lite,or,',560),(410,405,'executiongantt','module',',open,biz,max,ipd,',',rnd,lite,or,',570),(411,405,'executionkanban','module',',open,biz,max,ipd,',',rnd,lite,or,',580),(412,405,'executionburn','module',',open,biz,max,ipd,',',rnd,lite,or,',590),(413,405,'executioncfd','module',',open,biz,max,ipd,',',rnd,lite,or,',600),(414,405,'executionstory','module',',open,biz,max,ipd,',',rnd,lite,or,',610),(415,405,'executionqa','module',',open,biz,max,ipd,',',rnd,lite,or,',620),(416,405,'executionsettings','module',',open,biz,max,ipd,',',rnd,lite,or,',630),(417,0,'kanban','view',',open,biz,max,ipd,',',rnd,lite,',70),(418,417,'kanban','module',',open,biz,max,ipd,',',rnd,lite,',640),(419,417,'managespace','module',',open,biz,max,ipd,',',rnd,lite,or,',650),(420,0,'qa','view',',open,biz,max,ipd,',',rnd,',80),(421,420,'qa','module',',open,biz,max,ipd,',',rnd,',660),(422,420,'bug','module',',open,biz,max,ipd,',',rnd,',670),(423,420,'testcase','module',',open,biz,max,ipd,',',rnd,',680),(424,420,'testtask','module',',open,biz,max,ipd,',',rnd,',690),(425,420,'testsuite','module',',open,biz,max,ipd,',',rnd,',700),(426,420,'testreport','module',',open,biz,max,ipd,',',rnd,',710),(427,420,'zahost','module',',open,biz,max,ipd,',',rnd,',720),(428,420,'zanode','module',',open,biz,max,ipd,',',rnd,',730),(429,0,'assetlib','view',',max,ipd,',',rnd,',90),(430,429,'caselib','module',',open,biz,max,ipd,',',rnd,',740),(431,429,'assetlib','module',',max,ipd,',',rnd,',750),(432,429,'storylib','module',',max,ipd,',',rnd,',760),(433,429,'issuelib','module',',max,ipd,',',rnd,',770),(434,429,'risklib','module',',max,ipd,',',rnd,',780),(435,429,'opportunitylib','module',',max,ipd,',',rnd,',790),(436,429,'practicelib','module',',max,ipd,',',rnd,',800),(437,429,'componentlib','module',',max,ipd,',',rnd,',810),(438,0,'doc','view',',open,biz,max,ipd,',',rnd,lite,or,',25),(439,438,'doc','module',',open,biz,max,ipd,',',rnd,lite,or,',820),(440,438,'api','module',',open,biz,max,ipd,',',rnd,',830),(441,0,'bi','view',',open,biz,max,ipd,',',rnd,',110),(442,441,'screen','module',',open,biz,max,ipd,',',rnd,',840),(443,441,'pivot','module',',open,biz,max,ipd,',',rnd,',850),(444,441,'chart','module',',open,biz,max,ipd,',',rnd,',860),(445,441,'dataview','module',',biz,max,ipd,',',rnd,',870),(446,441,'dimension','module',',biz,max,ipd,',',rnd,',880),(447,441,'report','module',',open,biz,max,ipd,',',rnd,',890),(448,441,'bidesign','module',',open,biz,max,ipd,',',rnd,lite,or,',900),(449,0,'system','view',',open,biz,max,ipd,',',rnd,lite,',120),(450,449,'company','module',',open,biz,max,ipd,',',rnd,lite,or,',910),(451,449,'systemteam','module',',open,biz,max,ipd,',',rnd,lite,or,',920),(452,449,'systemschedule','module',',open,biz,max,ipd,',',rnd,lite,or,',930),(453,449,'systemeffort','module',',open,biz,max,ipd,',',rnd,lite,or,',940),(454,449,'systemdynamic','module',',open,biz,max,ipd,',',rnd,lite,or,',950),(455,449,'systemcompany','module',',open,biz,max,ipd,',',rnd,lite,or,',960),(456,449,'dataaccess','module',',open,biz,max,ipd,',',rnd,lite,or,',970),(457,0,'admin','view',',open,biz,max,ipd,',',rnd,lite,or,',30),(458,457,'dept','module',',open,biz,max,ipd,',',rnd,lite,or,',980),(459,457,'group','module',',open,biz,max,ipd,',',rnd,lite,or,',990),(460,457,'user','module',',open,biz,max,ipd,',',rnd,lite,or,',1000),(461,457,'admin','module',',open,biz,max,ipd,',',rnd,lite,or,',1010),(462,457,'stage','module',',open,biz,max,ipd,',',rnd,',1020),(463,457,'extension','module',',open,biz,max,ipd,',',rnd,lite,',1030),(464,457,'custom','module',',open,biz,max,ipd,',',rnd,lite,or,',1040),(465,457,'action','module',',open,biz,max,ipd,',',rnd,lite,or,',1050),(466,457,'mail','module',',open,biz,max,ipd,',',lite,rnd,or,',1060),(467,457,'sms','module',',biz,max,ipd,',',lite,rnd,or,',1070),(468,457,'backup','module',',open,biz,max,ipd,',',lite,rnd,or,',1080),(469,457,'cron','module',',open,biz,max,ipd,',',rnd,lite,',1090),(470,457,'dev','module',',open,biz,max,ipd,',',rnd,',1100),(471,457,'editor','module',',open,biz,max,ipd,',',rnd,',1110),(472,457,'holiday','module',',open,biz,max,ipd,',',rnd,',1120),(473,457,'meetingroom','module',',max,ipd,',',rnd,',1130),(474,457,'webhook','module',',open,biz,max,ipd,',',lite,rnd,or,',1140),(475,457,'message','module',',open,biz,max,ipd,',',lite,rnd,or,',1150),(476,457,'featureswitch','module',',open,biz,max,ipd,',',rnd,lite,or,',1160),(477,457,'importdata','module',',open,biz,max,ipd,',',rnd,lite,or,',1170),(478,457,'systemsetting','module',',open,biz,max,ipd,',',rnd,lite,or,',1180),(479,457,'staffmanage','module',',open,biz,max,ipd,',',rnd,lite,or,',1190),(480,457,'modelconfig','module',',open,biz,max,ipd,',',rnd,lite,or,',1200),(481,457,'featureconfig','module',',open,biz,max,ipd,',',rnd,lite,or,',1210),(482,457,'doctemplate','module',',open,biz,max,ipd,',',rnd,lite,or,',1220),(483,457,'notifysetting','module',',open,biz,max,ipd,',',rnd,lite,or,',1230),(484,457,'ldap','module',',biz,max,ipd,',',rnd,',1240),(485,457,'sqlbuilder','module',',max,ipd,',',rnd,',1250),(486,457,'holidayseason','module',',open,biz,max,',',rnd,',1260),(487,457,'baseline','module',',max,ipd,',',rnd,',1270),(488,457,'classify','module',',max,ipd,',',rnd,',1280),(489,457,'cmcl','module',',max,ipd,',',rnd,',1290),(490,457,'auditcl','module',',max,ipd,',',rnd,',1300),(491,457,'reviewcl','module',',max,ipd,',',rnd,',1310),(492,457,'process','module',',max,ipd,',',rnd,',1320),(493,457,'activity','module',',max,ipd,',',rnd,',1330),(494,457,'zoutput','module',',max,ipd,',',rnd,',1340),(495,457,'subject','module',',max,ipd,',',rnd,',1350),(496,457,'approvalflow','module',',max,ipd,',',rnd,',1360),(497,457,'reviewsetting','module',',max,ipd,',',rnd,',1370),(498,457,'measurement','module',',max,ipd,',',rnd,',1380),(499,457,'setting','module',',open,biz,max,ipd,',',rnd,lite,',1390),(500,457,'im','module',',open,biz,max,ipd,',',rnd,lite,',1400),(501,457,'client','module',',open,biz,max,ipd,',',rnd,lite,',1410),(502,0,'devops','view',',open,biz,max,ipd,',',rnd,',140),(503,502,'svn','module',',open,biz,max,ipd,',',rnd,',1420),(504,502,'git','module',',open,biz,max,ipd,',',rnd,',1430),(505,502,'mr','module',',open,biz,max,ipd,',',rnd,',1440),(506,502,'repo','module',',open,biz,max,ipd,',',rnd,',1450),(507,502,'ci','module',',open,biz,max,ipd,',',rnd,',1460),(508,502,'compile','module',',open,biz,max,ipd,',',rnd,',1470),(509,502,'jenkins','module',',open,biz,max,ipd,',',rnd,',1480),(510,502,'job','module',',open,biz,max,ipd,',',rnd,',1490),(511,502,'gitlab','module',',open,biz,max,ipd,',',rnd,',1500),(512,502,'gogs','module',',open,biz,max,ipd,',',rnd,',1510),(513,502,'gitea','module',',open,biz,max,ipd,',',rnd,',1520),(514,502,'sonarqube','module',',open,biz,max,ipd,',',rnd,',1530),(515,502,'app','module',',open,biz,max,ipd,',',rnd,',1540),(516,502,'pipeline','module',',open,biz,max,ipd,',',rnd,lite,or,',1550),(517,502,'devopssetting','module',',open,biz,max,ipd,',',rnd,lite,or,',1560),(518,0,'search','module',',open,biz,max,ipd,',',rnd,lite,or,',1570),(519,0,'tree','module',',open,biz,max,ipd,',',rnd,lite,or,',1580),(520,0,'file','module',',open,biz,max,ipd,',',rnd,lite,or,',1590),(521,0,'misc','module',',open,biz,max,ipd,',',rnd,lite,',1600),(522,0,'approval','module',',max,ipd,',',rnd,',1610),(523,0,'workflow','view',',biz,max,ipd,',',rnd,lite,',150),(524,523,'workflow','module',',biz,max,ipd,',',rnd,lite,',1620),(525,523,'workflowfield','module',',biz,max,ipd,',',rnd,lite,',1630),(526,523,'workflowaction','module',',biz,max,ipd,',',rnd,lite,',1640),(527,523,'workflowlayout','module',',biz,max,ipd,',',rnd,lite,',1650),(528,523,'workflowcondition','module',',biz,max,ipd,',',rnd,lite,',1660),(529,523,'workflowlinkage','module',',biz,max,ipd,',',rnd,lite,',1670),(530,523,'workflowhook','module',',biz,max,ipd,',',rnd,lite,',1680),(531,523,'workflowlabel','module',',biz,max,ipd,',',rnd,lite,',1690),(532,523,'workflowrelation','module',',biz,max,ipd,',',rnd,lite,',1700),(533,523,'workflowreport','module',',biz,max,ipd,',',rnd,lite,',1710),(534,523,'workflowdatasource','module',',biz,max,ipd,',',rnd,lite,',1720),(535,523,'workflowrule','module',',biz,max,ipd,',',rnd,lite,',1730),(536,0,'datatable','module',',open,biz,max,ipd,',',rnd,lite,',1740),(537,0,'generalcomment','module',',open,biz,max,ipd,',',rnd,lite,or,',1750),(538,0,'generalping','module',',open,biz,max,ipd,',',rnd,lite,or,',1760),(539,0,'generaltemplate','module',',open,biz,max,ipd,',',rnd,lite,or,',1770),(540,0,'generaleffort','module',',open,biz,max,ipd,',',rnd,lite,or,',1780),(541,0,'feedback','view',',biz,max,ipd,',',rnd,lite,',160),(542,541,'feedback','module',',biz,max,ipd,',',rnd,lite,',1790),(543,541,'faq','module',',biz,max,ipd,',',rnd,lite,',1800),(544,541,'ticket','module',',biz,max,ipd,',',rnd,lite,',1810),(545,541,'feedbackpriv','module',',biz,max,ipd,',',rnd,',1820),(546,0,'oa','view',',biz,max,ipd,',',rnd,lite,',170),(547,546,'attend','module',',biz,max,ipd,',',rnd,lite,',1830),(548,546,'leave','module',',biz,max,ipd,',',rnd,lite,',1840),(549,546,'makeup','module',',biz,max,ipd,',',rnd,lite,',1850),(550,546,'overtime','module',',biz,max,ipd,',',rnd,lite,',1860),(551,546,'lieu','module',',biz,max,ipd,',',rnd,lite,',1870),(552,546,'officeapproval','module',',biz,max,ipd,',',rnd,',1880),(553,546,'officesetting','module',',biz,max,ipd,',',rnd,',1890),(554,546,'datapermission','module',',biz,max,ipd,',',rnd,',1900),(555,546,'officeexport','module',',biz,max,ipd,',',rnd,',1910),(556,0,'ops','view',',biz,max,ipd,',',rnd,',180),(557,556,'ops','module',',biz,max,ipd,',',rnd,',1920),(558,556,'host','module',',biz,max,ipd,',',rnd,',1930),(559,556,'serverroom','module',',biz,max,ipd,',',rnd,',1940),(560,556,'account','module',',biz,max,ipd,',',rnd,',1950),(561,556,'domain','module',',biz,max,ipd,',',rnd,',1960),(562,556,'service','module',',biz,max,ipd,',',rnd,',1970),(563,556,'deploy','module',',biz,max,ipd,',',rnd,',1980),(564,0,'conference','module',',biz,max,ipd,',',rnd,',1990),(565,0,'traincourse','view',',biz,max,ipd,',',rnd,',190),(566,565,'traincourse','module',',biz,max,ipd,',',rnd,',2000),(607,0,'demandpool','view',',ipd,',',or,',10),(608,0,'charter','view',',ipd,',',or,',20),(609,608,'charter','module',',ipd,',',or,',165),(610,607,'demandpool','module',',ipd,',',or,',55),(611,607,'demand','module',',ipd,',',or,',56),(612,360,'roadmap','module',',ipd,',',or,rnd,',125),(635,610,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(636,609,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(637,610,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(638,609,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(639,609,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(640,611,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(641,611,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(642,611,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(643,611,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(644,611,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(645,461,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(646,612,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(647,612,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(648,612,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5),(649,610,'','package',',open,biz,max,ipd,',',rnd,lite,or,',5);
REPLACE INTO `zt_privlang` (`objectID`, `objectType`, `lang`, `key`, `value`, `desc`) VALUES (1,'priv','de','index-index','',''),(1,'priv','en','index-index','',''),(1,'priv','fr','index-index','',''),(1,'priv','zh-cn','index-index','',''),(1,'priv','zh-tw','index-index','',''),(2,'priv','de','my-indexAction','',''),(2,'priv','en','my-indexAction','',''),(2,'priv','fr','my-indexAction','',''),(2,'priv','zh-cn','my-indexAction','',''),(2,'priv','zh-tw','my-indexAction','',''),(3,'priv','de','my-todoAction','',''),(3,'priv','en','my-todoAction','',''),(3,'priv','fr','my-todoAction','',''),(3,'priv','zh-cn','my-todoAction','',''),(3,'priv','zh-tw','my-todoAction','',''),(4,'priv','de','my-workAction','',''),(4,'priv','en','my-workAction','',''),(4,'priv','fr','my-workAction','',''),(4,'priv','zh-cn','my-workAction','',''),(4,'priv','zh-tw','my-workAction','',''),(4,'manager','zh-cn','','浏览待办',''),(5,'priv','de','my-contributeAction','',''),(5,'priv','en','my-contributeAction','',''),(5,'priv','fr','my-contributeAction','',''),(5,'priv','zh-cn','my-contributeAction','',''),(5,'priv','zh-tw','my-contributeAction','',''),(5,'manager','zh-cn','','创建维护待办',''),(6,'priv','de','my-project','',''),(6,'priv','en','my-project','',''),(6,'priv','fr','my-project','',''),(6,'priv','zh-cn','my-project','',''),(6,'priv','zh-tw','my-project','',''),(6,'manager','zh-cn','','删除待办',''),(7,'priv','de','my-profileAction','',''),(7,'priv','en','my-profileAction','',''),(7,'priv','fr','my-profileAction','',''),(7,'priv','zh-cn','my-profileAction','',''),(7,'priv','zh-tw','my-profileAction','',''),(7,'manager','zh-cn','','导入导出待办',''),(8,'priv','de','my-uploadAvatar','',''),(8,'priv','en','my-uploadAvatar','',''),(8,'priv','fr','my-uploadAvatar','',''),(8,'priv','zh-cn','my-uploadAvatar','',''),(8,'priv','zh-tw','my-uploadAvatar','',''),(8,'manager','zh-cn','','维护联系人',''),(9,'priv','de','my-preference','',''),(9,'priv','en','my-preference','',''),(9,'priv','fr','my-preference','',''),(9,'priv','zh-cn','my-preference','',''),(9,'priv','zh-tw','my-preference','',''),(9,'manager','zh-cn','','个人档案',''),(10,'priv','de','my-dynamicAction','',''),(10,'priv','en','my-dynamicAction','',''),(10,'priv','fr','my-dynamicAction','',''),(10,'priv','zh-cn','my-dynamicAction','',''),(10,'priv','zh-tw','my-dynamicAction','',''),(10,'manager','zh-cn','','个性化设置',''),(11,'priv','de','my-editProfile','',''),(11,'priv','en','my-editProfile','',''),(11,'priv','fr','my-editProfile','',''),(11,'priv','zh-cn','my-editProfile','',''),(11,'priv','zh-tw','my-editProfile','',''),(11,'manager','zh-cn','','浏览项目集',''),(12,'priv','de','my-changePassword','',''),(12,'priv','en','my-changePassword','',''),(12,'priv','fr','my-changePassword','',''),(12,'priv','zh-cn','my-changePassword','',''),(12,'priv','zh-tw','my-changePassword','',''),(12,'manager','zh-cn','','创建维护项目集',''),(13,'priv','de','my-manageContacts','',''),(13,'priv','en','my-manageContacts','',''),(13,'priv','fr','my-manageContacts','',''),(13,'priv','zh-cn','my-manageContacts','',''),(13,'priv','zh-tw','my-manageContacts','',''),(13,'manager','zh-cn','','删除项目集',''),(14,'priv','de','my-deleteContacts','',''),(14,'priv','en','my-deleteContacts','',''),(14,'priv','fr','my-deleteContacts','',''),(14,'priv','zh-cn','my-deleteContacts','',''),(14,'priv','zh-tw','my-deleteContacts','',''),(14,'manager','zh-cn','','投入人员',''),(15,'priv','de','my-score','',''),(15,'priv','en','my-score','',''),(15,'priv','fr','my-score','',''),(15,'priv','zh-cn','my-score','',''),(15,'priv','zh-tw','my-score','',''),(15,'manager','zh-cn','','可访问人员',''),(16,'priv','de','my-team','',''),(16,'priv','en','my-team','',''),(16,'priv','fr','my-team','',''),(16,'priv','zh-cn','my-team','',''),(16,'priv','zh-tw','my-team','',''),(16,'manager','zh-cn','','维护白名单',''),(17,'priv','de','my-execution','',''),(17,'priv','en','my-execution','',''),(17,'priv','fr','my-execution','',''),(17,'priv','zh-cn','my-execution','',''),(17,'priv','zh-tw','my-execution','',''),(17,'manager','zh-cn','','维护干系人',''),(18,'priv','de','my-doc','',''),(18,'priv','en','my-doc','',''),(18,'priv','fr','my-doc','',''),(18,'priv','zh-cn','my-doc','',''),(18,'priv','zh-tw','my-doc','',''),(18,'manager','zh-cn','','浏览地盘',''),(19,'priv','de','my-audit','',''),(19,'priv','en','my-audit','',''),(19,'priv','fr','my-audit','',''),(19,'priv','zh-cn','my-audit','',''),(19,'priv','zh-tw','my-audit','',''),(19,'manager','zh-cn','','浏览产品',''),(20,'priv','de','my-meeting','',''),(20,'priv','en','my-meeting','',''),(20,'priv','fr','my-meeting','',''),(20,'priv','zh-cn','my-meeting','',''),(20,'priv','zh-tw','my-meeting','',''),(20,'manager','zh-cn','','创建维护产品线',''),(21,'priv','de','my-calendarAction','',''),(21,'priv','en','my-calendarAction','',''),(21,'priv','fr','my-calendarAction','',''),(21,'priv','zh-cn','my-calendarAction','',''),(21,'priv','zh-tw','my-calendarAction','',''),(21,'manager','zh-cn','','创建维护产品',''),(22,'priv','de','my-effortAction','',''),(22,'priv','en','my-effortAction','',''),(22,'priv','fr','my-effortAction','',''),(22,'priv','zh-cn','my-effortAction','',''),(22,'priv','zh-tw','my-effortAction','',''),(22,'manager','zh-cn','','导入导出产品',''),(23,'priv','de','my-review','',''),(23,'priv','en','my-review','',''),(23,'priv','fr','my-review','',''),(23,'priv','zh-cn','my-review','',''),(23,'priv','zh-tw','my-review','',''),(23,'manager','zh-cn','','白名单管理',''),(24,'priv','de','todo-create','',''),(24,'priv','en','todo-create','',''),(24,'priv','fr','todo-create','',''),(24,'priv','zh-cn','todo-create','',''),(24,'priv','zh-tw','todo-create','',''),(24,'manager','zh-cn','','分支管理',''),(25,'priv','de','todo-createCycle','',''),(25,'priv','en','todo-createCycle','',''),(25,'priv','fr','todo-createCycle','',''),(25,'priv','zh-cn','todo-createCycle','',''),(25,'priv','zh-tw','todo-createCycle','',''),(25,'manager','zh-cn','','浏览研发需求',''),(26,'priv','de','todo-batchCreate','',''),(26,'priv','en','todo-batchCreate','',''),(26,'priv','fr','todo-batchCreate','',''),(26,'priv','zh-cn','todo-batchCreate','',''),(26,'priv','zh-tw','todo-batchCreate','',''),(26,'manager','zh-cn','','创建维护研发需求',''),(27,'priv','de','todo-edit','',''),(27,'priv','en','todo-edit','',''),(27,'priv','fr','todo-edit','',''),(27,'priv','zh-cn','todo-edit','',''),(27,'priv','zh-tw','todo-edit','',''),(27,'manager','zh-cn','','导入导出研发需求',''),(28,'priv','de','todo-batchEdit','',''),(28,'priv','en','todo-batchEdit','',''),(28,'priv','fr','todo-batchEdit','',''),(28,'priv','zh-cn','todo-batchEdit','',''),(28,'priv','zh-tw','todo-batchEdit','',''),(28,'manager','zh-cn','','删除研发需求',''),(29,'priv','de','todo-view','',''),(29,'priv','en','todo-view','',''),(29,'priv','fr','todo-view','',''),(29,'priv','zh-cn','todo-view','',''),(29,'priv','zh-tw','todo-view','',''),(29,'manager','zh-cn','','评审研发需求',''),(30,'priv','de','todo-delete','',''),(30,'priv','en','todo-delete','',''),(30,'priv','fr','todo-delete','',''),(30,'priv','zh-cn','todo-delete','',''),(30,'priv','zh-tw','todo-delete','',''),(30,'manager','zh-cn','','删除产品',''),(31,'priv','de','todo-export','',''),(31,'priv','en','todo-export','',''),(31,'priv','fr','todo-export','',''),(31,'priv','zh-cn','todo-export','',''),(31,'priv','zh-tw','todo-export','',''),(31,'manager','zh-cn','','浏览用户需求',''),(32,'priv','de','todo-start','',''),(32,'priv','en','todo-start','',''),(32,'priv','fr','todo-start','',''),(32,'priv','zh-cn','todo-start','',''),(32,'priv','zh-tw','todo-start','',''),(32,'manager','zh-cn','','创建维护用户需求',''),(33,'priv','de','todo-finish','',''),(33,'priv','en','todo-finish','',''),(33,'priv','fr','todo-finish','',''),(33,'priv','zh-cn','todo-finish','',''),(33,'priv','zh-tw','todo-finish','',''),(33,'manager','zh-cn','','导入导出用户需求',''),(34,'priv','de','todo-batchFinish','',''),(34,'priv','en','todo-batchFinish','',''),(34,'priv','fr','todo-batchFinish','',''),(34,'priv','zh-cn','todo-batchFinish','',''),(34,'priv','zh-tw','todo-batchFinish','',''),(34,'manager','zh-cn','','删除用户需求',''),(35,'priv','de','todo-import2Today','',''),(35,'priv','en','todo-import2Today','',''),(35,'priv','fr','todo-import2Today','',''),(35,'priv','zh-cn','todo-import2Today','',''),(35,'priv','zh-tw','todo-import2Today','',''),(35,'manager','zh-cn','','评审用户需求',''),(36,'priv','de','todo-assignAction','',''),(36,'priv','en','todo-assignAction','',''),(36,'priv','fr','todo-assignAction','',''),(36,'priv','zh-cn','todo-assignAction','',''),(36,'priv','zh-tw','todo-assignAction','',''),(36,'manager','zh-cn','','浏览产品计划',''),(37,'priv','de','todo-activate','',''),(37,'priv','en','todo-activate','',''),(37,'priv','fr','todo-activate','',''),(37,'priv','zh-cn','todo-activate','',''),(37,'priv','zh-tw','todo-activate','',''),(37,'manager','zh-cn','','创建维护产品计划',''),(38,'priv','de','todo-close','',''),(38,'priv','en','todo-close','',''),(38,'priv','fr','todo-close','',''),(38,'priv','zh-cn','todo-close','',''),(38,'priv','zh-tw','todo-close','',''),(38,'manager','zh-cn','','删除产品计划',''),(39,'priv','de','todo-batchClose','',''),(39,'priv','en','todo-batchClose','',''),(39,'priv','fr','todo-batchClose','',''),(39,'priv','zh-cn','todo-batchClose','',''),(39,'priv','zh-tw','todo-batchClose','',''),(39,'manager','zh-cn','','浏览发布',''),(40,'priv','de','todo-calendar','',''),(40,'priv','en','todo-calendar','',''),(40,'priv','fr','todo-calendar','',''),(40,'priv','zh-cn','todo-calendar','',''),(40,'priv','zh-tw','todo-calendar','',''),(40,'manager','zh-cn','','创建维护发布',''),(41,'priv','de','program-browse','',''),(41,'priv','en','program-browse','',''),(41,'priv','fr','program-browse','',''),(41,'priv','zh-cn','program-browse','',''),(41,'priv','zh-tw','program-browse','',''),(41,'manager','zh-cn','','导入导出发布',''),(42,'priv','de','program-kanbanAction','',''),(42,'priv','en','program-kanbanAction','',''),(42,'priv','fr','program-kanbanAction','',''),(42,'priv','zh-cn','program-kanbanAction','',''),(42,'priv','zh-tw','program-kanbanAction','',''),(42,'manager','zh-cn','','删除发布',''),(43,'priv','de','program-view','',''),(43,'priv','en','program-view','',''),(43,'priv','fr','program-view','',''),(43,'priv','zh-cn','program-view','',''),(43,'priv','zh-tw','program-view','',''),(43,'manager','zh-cn','','发布通知',''),(44,'priv','de','program-product','',''),(44,'priv','en','program-product','',''),(44,'priv','fr','program-product','',''),(44,'priv','zh-cn','program-product','',''),(44,'priv','zh-tw','program-product','',''),(44,'manager','zh-cn','','项目计划',''),(45,'priv','de','program-create','',''),(45,'priv','en','program-create','',''),(45,'priv','fr','program-create','',''),(45,'priv','zh-cn','program-create','',''),(45,'priv','zh-tw','program-create','',''),(45,'manager','zh-cn','','维护研发需求',''),(46,'priv','de','program-edit','',''),(46,'priv','en','program-edit','',''),(46,'priv','fr','program-edit','',''),(46,'priv','zh-cn','program-edit','',''),(46,'priv','zh-tw','program-edit','',''),(46,'manager','zh-cn','','浏览项目',''),(47,'priv','de','program-start','',''),(47,'priv','en','program-start','',''),(47,'priv','fr','program-start','',''),(47,'priv','zh-cn','program-start','',''),(47,'priv','zh-tw','program-start','',''),(47,'manager','zh-cn','','创建维护项目',''),(48,'priv','de','program-suspend','',''),(48,'priv','en','program-suspend','',''),(48,'priv','fr','program-suspend','',''),(48,'priv','zh-cn','program-suspend','',''),(48,'priv','zh-tw','program-suspend','',''),(48,'manager','zh-cn','','导入导出项目',''),(49,'priv','de','program-activate','',''),(49,'priv','en','program-activate','',''),(49,'priv','fr','program-activate','',''),(49,'priv','zh-cn','program-activate','',''),(49,'priv','zh-tw','program-activate','',''),(50,'priv','de','program-close','',''),(50,'priv','en','program-close','',''),(50,'priv','fr','program-close','',''),(50,'priv','zh-cn','program-close','',''),(50,'priv','zh-tw','program-close','',''),(50,'manager','zh-cn','','团队权限',''),(51,'priv','de','program-delete','',''),(51,'priv','en','program-delete','',''),(51,'priv','fr','program-delete','',''),(51,'priv','zh-cn','program-delete','',''),(51,'priv','zh-tw','program-delete','',''),(51,'manager','zh-cn','','删除项目',''),(52,'priv','de','program-project','',''),(52,'priv','en','program-project','',''),(52,'priv','fr','program-project','',''),(52,'priv','zh-cn','program-project','',''),(52,'priv','zh-tw','program-project','',''),(52,'manager','zh-cn','','项目白名单',''),(53,'priv','de','program-stakeholder','',''),(53,'priv','en','program-stakeholder','',''),(53,'priv','fr','program-stakeholder','',''),(53,'priv','zh-cn','program-stakeholder','',''),(53,'priv','zh-tw','program-stakeholder','',''),(53,'manager','zh-cn','','浏览执行',''),(54,'priv','de','program-createStakeholder','',''),(54,'priv','en','program-createStakeholder','',''),(54,'priv','fr','program-createStakeholder','',''),(54,'priv','zh-cn','program-createStakeholder','',''),(54,'priv','zh-tw','program-createStakeholder','',''),(54,'manager','zh-cn','','创建维护执行',''),(55,'priv','de','program-unlinkStakeholder','',''),(55,'priv','en','program-unlinkStakeholder','',''),(55,'priv','fr','program-unlinkStakeholder','',''),(55,'priv','zh-cn','program-unlinkStakeholder','',''),(55,'priv','zh-tw','program-unlinkStakeholder','',''),(55,'manager','zh-cn','','删除执行',''),(56,'priv','de','program-batchUnlinkStakeholders','',''),(56,'priv','en','program-batchUnlinkStakeholders','',''),(56,'priv','fr','program-batchUnlinkStakeholders','',''),(56,'priv','zh-cn','program-batchUnlinkStakeholders','',''),(56,'priv','zh-tw','program-batchUnlinkStakeholders','',''),(56,'manager','zh-cn','','导入导出执行',''),(57,'priv','de','program-unbindWhitelist','',''),(57,'priv','en','program-unbindWhitelist','',''),(57,'priv','fr','program-unbindWhitelist','',''),(57,'priv','zh-cn','program-unbindWhitelist','',''),(57,'priv','zh-tw','program-unbindWhitelist','',''),(57,'manager','zh-cn','','执行白名单',''),(58,'priv','de','program-updateOrder','',''),(58,'priv','en','program-updateOrder','',''),(58,'priv','fr','program-updateOrder','',''),(58,'priv','zh-cn','program-updateOrder','',''),(58,'priv','zh-tw','program-updateOrder','',''),(58,'manager','zh-cn','','甘特图',''),(59,'priv','de','personnel-accessible','',''),(59,'priv','en','personnel-accessible','',''),(59,'priv','fr','personnel-accessible','',''),(59,'priv','zh-cn','personnel-accessible','',''),(59,'priv','zh-tw','personnel-accessible','',''),(60,'priv','de','personnel-invest','',''),(60,'priv','en','personnel-invest','',''),(60,'priv','fr','personnel-invest','',''),(60,'priv','zh-cn','personnel-invest','',''),(60,'priv','zh-tw','personnel-invest','',''),(60,'manager','zh-cn','','浏览任务',''),(61,'priv','de','personnel-whitelist','',''),(61,'priv','en','personnel-whitelist','',''),(61,'priv','fr','personnel-whitelist','',''),(61,'priv','zh-cn','personnel-whitelist','',''),(61,'priv','zh-tw','personnel-whitelist','',''),(61,'manager','zh-cn','','创建维护任务',''),(62,'priv','de','personnel-addWhitelist','',''),(62,'priv','en','personnel-addWhitelist','',''),(62,'priv','fr','personnel-addWhitelist','',''),(62,'priv','zh-cn','personnel-addWhitelist','',''),(62,'priv','zh-tw','personnel-addWhitelist','',''),(62,'manager','zh-cn','','删除任务',''),(63,'priv','de','product-indexAction','',''),(63,'priv','en','product-indexAction','',''),(63,'priv','fr','product-indexAction','',''),(63,'priv','zh-cn','product-indexAction','',''),(63,'priv','zh-tw','product-indexAction','',''),(63,'manager','zh-cn','','导入导出任务',''),(64,'priv','de','product-browse','',''),(64,'priv','en','product-browse','',''),(64,'priv','fr','product-browse','',''),(64,'priv','zh-cn','product-browse','',''),(64,'priv','zh-tw','product-browse','',''),(64,'manager','zh-cn','','执行团队',''),(65,'priv','de','product-requirement','',''),(65,'priv','en','product-requirement','',''),(65,'priv','fr','product-requirement','',''),(65,'priv','zh-cn','product-requirement','',''),(65,'priv','zh-tw','product-requirement','',''),(65,'manager','zh-cn','','看板',''),(66,'priv','de','product-create','',''),(66,'priv','en','product-create','',''),(66,'priv','fr','product-create','',''),(66,'priv','zh-cn','product-create','',''),(66,'priv','zh-tw','product-create','',''),(66,'manager','zh-cn','','分组视图',''),(67,'priv','de','product-view','',''),(67,'priv','en','product-view','',''),(67,'priv','fr','product-view','',''),(67,'priv','zh-cn','product-view','',''),(67,'priv','zh-tw','product-view','',''),(67,'manager','zh-cn','','燃尽图',''),(68,'priv','de','product-edit','',''),(68,'priv','en','product-edit','',''),(68,'priv','fr','product-edit','',''),(68,'priv','zh-cn','product-edit','',''),(68,'priv','zh-tw','product-edit','',''),(68,'manager','zh-cn','','累积流图',''),(69,'priv','de','product-batchEdit','',''),(69,'priv','en','product-batchEdit','',''),(69,'priv','fr','product-batchEdit','',''),(69,'priv','zh-cn','product-batchEdit','',''),(69,'priv','zh-tw','product-batchEdit','',''),(69,'manager','zh-cn','','维护研发需求',''),(70,'priv','de','product-delete','',''),(70,'priv','en','product-delete','',''),(70,'priv','fr','product-delete','',''),(70,'priv','zh-cn','product-delete','',''),(70,'priv','zh-tw','product-delete','',''),(71,'priv','de','product-roadmap','',''),(71,'priv','en','product-roadmap','',''),(71,'priv','fr','product-roadmap','',''),(71,'priv','zh-cn','product-roadmap','',''),(71,'priv','zh-tw','product-roadmap','',''),(71,'manager','zh-cn','','维护日志',''),(72,'priv','de','product-track','',''),(72,'priv','en','product-track','',''),(72,'priv','fr','product-track','',''),(72,'priv','zh-cn','product-track','',''),(72,'priv','zh-tw','product-track','',''),(72,'manager','zh-cn','','创建维护版本',''),(73,'priv','de','product-dynamic','',''),(73,'priv','en','product-dynamic','',''),(73,'priv','fr','product-dynamic','',''),(73,'priv','zh-cn','product-dynamic','',''),(73,'priv','zh-tw','product-dynamic','',''),(73,'manager','zh-cn','','删除版本',''),(74,'priv','de','product-project','',''),(74,'priv','en','product-project','',''),(74,'priv','fr','product-project','',''),(74,'priv','zh-cn','product-project','',''),(74,'priv','zh-tw','product-project','',''),(74,'manager','zh-cn','','浏览需求库',''),(75,'priv','de','product-dashboard','',''),(75,'priv','en','product-dashboard','',''),(75,'priv','fr','product-dashboard','',''),(75,'priv','zh-cn','product-dashboard','',''),(75,'priv','zh-tw','product-dashboard','',''),(75,'manager','zh-cn','','创建维护需求库',''),(76,'priv','de','product-closeAction','',''),(76,'priv','en','product-closeAction','',''),(76,'priv','fr','product-closeAction','',''),(76,'priv','zh-cn','product-closeAction','',''),(76,'priv','zh-tw','product-closeAction','',''),(76,'manager','zh-cn','','删除需求库',''),(77,'priv','de','product-orderAction','',''),(77,'priv','en','product-orderAction','',''),(77,'priv','fr','product-orderAction','',''),(77,'priv','zh-cn','product-orderAction','',''),(77,'priv','zh-tw','product-orderAction','',''),(77,'manager','zh-cn','','审批需求',''),(78,'priv','de','product-list','',''),(78,'priv','en','product-list','',''),(78,'priv','fr','product-list','',''),(78,'priv','zh-cn','product-list','',''),(78,'priv','zh-tw','product-list','',''),(78,'manager','zh-cn','','浏览问题库',''),(79,'priv','de','product-kanban','',''),(79,'priv','en','product-kanban','',''),(79,'priv','fr','product-kanban','',''),(79,'priv','zh-cn','product-kanban','',''),(79,'priv','zh-tw','product-kanban','',''),(79,'manager','zh-cn','','创建编辑问题库',''),(80,'priv','de','product-manageLine','',''),(80,'priv','en','product-manageLine','',''),(80,'priv','fr','product-manageLine','',''),(80,'priv','zh-cn','product-manageLine','',''),(80,'priv','zh-tw','product-manageLine','',''),(80,'manager','zh-cn','','删除问题库',''),(81,'manager','zh-cn','','审批问题',''),(82,'priv','de','product-exportAction','',''),(82,'priv','en','product-exportAction','',''),(82,'priv','fr','product-exportAction','',''),(82,'priv','zh-cn','product-exportAction','',''),(82,'priv','zh-tw','product-exportAction','',''),(82,'manager','zh-cn','','浏览风险库',''),(83,'priv','de','product-whitelist','',''),(83,'priv','en','product-whitelist','',''),(83,'priv','fr','product-whitelist','',''),(83,'priv','zh-cn','product-whitelist','',''),(83,'priv','zh-tw','product-whitelist','',''),(83,'manager','zh-cn','','创建维护风险库',''),(84,'priv','de','product-addWhitelist','',''),(84,'priv','en','product-addWhitelist','',''),(84,'priv','fr','product-addWhitelist','',''),(84,'priv','zh-cn','product-addWhitelist','',''),(84,'priv','zh-tw','product-addWhitelist','',''),(84,'manager','zh-cn','','删除风险库',''),(85,'priv','de','product-unbindWhitelist','',''),(85,'priv','en','product-unbindWhitelist','',''),(85,'priv','fr','product-unbindWhitelist','',''),(85,'priv','zh-cn','product-unbindWhitelist','',''),(85,'priv','zh-tw','product-unbindWhitelist','',''),(85,'manager','zh-cn','','审批风险',''),(86,'priv','de','story-create','',''),(86,'priv','en','story-create','',''),(86,'priv','fr','story-create','',''),(86,'priv','zh-cn','story-create','',''),(86,'priv','zh-tw','story-create','',''),(86,'manager','zh-cn','','浏览机会库',''),(87,'priv','de','story-batchCreate','',''),(87,'priv','en','story-batchCreate','',''),(87,'priv','fr','story-batchCreate','',''),(87,'priv','zh-cn','story-batchCreate','',''),(87,'priv','zh-tw','story-batchCreate','',''),(87,'manager','zh-cn','','创建维护机会库',''),(88,'priv','de','story-editAction','',''),(88,'priv','en','story-editAction','',''),(88,'priv','fr','story-editAction','',''),(88,'priv','zh-cn','story-editAction','',''),(88,'priv','zh-tw','story-editAction','',''),(88,'manager','zh-cn','','删除机会库',''),(89,'priv','de','story-exportAction','',''),(89,'priv','en','story-exportAction','',''),(89,'priv','fr','story-exportAction','',''),(89,'priv','zh-cn','story-exportAction','',''),(89,'priv','zh-tw','story-exportAction','',''),(89,'manager','zh-cn','','审批机会',''),(90,'priv','de','story-deleteAction','',''),(90,'priv','en','story-deleteAction','',''),(90,'priv','fr','story-deleteAction','',''),(90,'priv','zh-cn','story-deleteAction','',''),(90,'priv','zh-tw','story-deleteAction','',''),(90,'manager','zh-cn','','浏览最佳实践库',''),(91,'priv','de','story-view','',''),(91,'priv','en','story-view','',''),(91,'priv','fr','story-view','',''),(91,'priv','zh-cn','story-view','',''),(91,'priv','zh-tw','story-view','',''),(91,'manager','zh-cn','','创建维护最佳实践库',''),(92,'priv','de','story-changeAction','',''),(92,'priv','en','story-changeAction','',''),(92,'priv','fr','story-changeAction','',''),(92,'priv','zh-cn','story-changeAction','',''),(92,'priv','zh-tw','story-changeAction','',''),(92,'manager','zh-cn','','删除最佳实践库',''),(93,'priv','de','story-reviewAction','',''),(93,'priv','en','story-reviewAction','',''),(93,'priv','fr','story-reviewAction','',''),(93,'priv','zh-cn','story-reviewAction','',''),(93,'priv','zh-tw','story-reviewAction','',''),(93,'manager','zh-cn','','审批最佳实践',''),(94,'priv','de','story-submitReview','',''),(94,'priv','en','story-submitReview','',''),(94,'priv','fr','story-submitReview','',''),(94,'priv','zh-cn','story-submitReview','',''),(94,'priv','zh-tw','story-submitReview','',''),(94,'manager','zh-cn','','浏览组件库',''),(95,'priv','de','story-batchReview','',''),(95,'priv','en','story-batchReview','',''),(95,'priv','fr','story-batchReview','',''),(95,'priv','zh-cn','story-batchReview','',''),(95,'priv','zh-tw','story-batchReview','',''),(95,'manager','zh-cn','','创建维护组件库',''),(96,'priv','de','story-recallAction','',''),(96,'priv','en','story-recallAction','',''),(96,'priv','fr','story-recallAction','',''),(96,'priv','zh-cn','story-recallAction','',''),(96,'priv','zh-tw','story-recallAction','',''),(96,'manager','zh-cn','','删除组件库',''),(97,'priv','de','story-closeAction','',''),(97,'priv','en','story-closeAction','',''),(97,'priv','fr','story-closeAction','',''),(97,'priv','zh-cn','story-closeAction','',''),(97,'priv','zh-tw','story-closeAction','',''),(97,'manager','zh-cn','','审批组件',''),(98,'priv','de','story-batchClose','',''),(98,'priv','en','story-batchClose','',''),(98,'priv','fr','story-batchClose','',''),(98,'priv','zh-cn','story-batchClose','',''),(98,'priv','zh-tw','story-batchClose','',''),(98,'manager','zh-cn','','浏览用例库',''),(99,'priv','de','story-batchChangePlan','',''),(99,'priv','en','story-batchChangePlan','',''),(99,'priv','fr','story-batchChangePlan','',''),(99,'priv','zh-cn','story-batchChangePlan','',''),(99,'priv','zh-tw','story-batchChangePlan','',''),(99,'manager','zh-cn','','创建维护用例库',''),(100,'priv','de','story-batchChangeStage','',''),(100,'priv','en','story-batchChangeStage','',''),(100,'priv','fr','story-batchChangeStage','',''),(100,'priv','zh-cn','story-batchChangeStage','',''),(100,'priv','zh-tw','story-batchChangeStage','',''),(100,'manager','zh-cn','','删除用例库',''),(101,'priv','de','story-assignAction','',''),(101,'priv','en','story-assignAction','',''),(101,'priv','fr','story-assignAction','',''),(101,'priv','zh-cn','story-assignAction','',''),(101,'priv','zh-tw','story-assignAction','',''),(101,'manager','zh-cn','','导入导出用例库',''),(102,'priv','de','story-batchAssignTo','',''),(102,'priv','en','story-batchAssignTo','',''),(102,'priv','fr','story-batchAssignTo','',''),(102,'priv','zh-cn','story-batchAssignTo','',''),(102,'priv','zh-tw','story-batchAssignTo','',''),(102,'manager','zh-cn','','办公审批',''),(103,'priv','de','story-activateAction','',''),(103,'priv','en','story-activateAction','',''),(103,'priv','fr','story-activateAction','',''),(103,'priv','zh-cn','story-activateAction','',''),(103,'priv','zh-tw','story-activateAction','',''),(103,'manager','zh-cn','','个人考勤',''),(104,'priv','de','story-tasks','',''),(104,'priv','en','story-tasks','',''),(104,'priv','fr','story-tasks','',''),(104,'priv','zh-cn','story-tasks','',''),(104,'priv','zh-tw','story-tasks','',''),(104,'manager','zh-cn','','办公设置',''),(105,'priv','de','story-bugs','',''),(105,'priv','en','story-bugs','',''),(105,'priv','fr','story-bugs','',''),(105,'priv','zh-cn','story-bugs','',''),(105,'priv','zh-tw','story-bugs','',''),(105,'manager','zh-cn','','数据权限',''),(106,'priv','de','story-cases','',''),(106,'priv','en','story-cases','',''),(106,'priv','fr','story-cases','',''),(106,'priv','zh-cn','story-cases','',''),(106,'priv','zh-tw','story-cases','',''),(106,'manager','zh-cn','','个人请假',''),(107,'priv','de','story-reportAction','',''),(107,'priv','en','story-reportAction','',''),(107,'priv','fr','story-reportAction','',''),(107,'priv','zh-cn','story-reportAction','',''),(107,'priv','zh-tw','story-reportAction','',''),(107,'manager','zh-cn','','个人补班',''),(108,'priv','de','story-linkStory','',''),(108,'priv','en','story-linkStory','',''),(108,'priv','fr','story-linkStory','',''),(108,'priv','zh-cn','story-linkStory','',''),(108,'priv','zh-tw','story-linkStory','',''),(108,'manager','zh-cn','','个人加班',''),(109,'priv','de','story-batchChangeBranch','',''),(109,'priv','en','story-batchChangeBranch','',''),(109,'priv','fr','story-batchChangeBranch','',''),(109,'priv','zh-cn','story-batchChangeBranch','',''),(109,'priv','zh-tw','story-batchChangeBranch','',''),(109,'manager','zh-cn','','个人调休',''),(110,'priv','de','story-batchChangeModule','',''),(110,'priv','en','story-batchChangeModule','',''),(110,'priv','fr','story-batchChangeModule','',''),(110,'priv','zh-cn','story-batchChangeModule','',''),(110,'priv','zh-tw','story-batchChangeModule','',''),(110,'manager','zh-cn','','节假日',''),(111,'priv','de','story-batchToTask','',''),(111,'priv','en','story-batchToTask','',''),(111,'priv','fr','story-batchToTask','',''),(111,'priv','zh-cn','story-batchToTask','',''),(111,'priv','zh-tw','story-batchToTask','',''),(111,'manager','zh-cn','','办公导出',''),(112,'priv','de','story-processStoryChange','',''),(112,'priv','en','story-processStoryChange','',''),(112,'priv','fr','story-processStoryChange','',''),(112,'priv','zh-cn','story-processStoryChange','',''),(112,'priv','zh-tw','story-processStoryChange','',''),(112,'manager','zh-cn','','浏览反馈',''),(113,'priv','de','story-linkStoriesAB','',''),(113,'priv','en','story-linkStoriesAB','',''),(113,'priv','fr','story-linkStoriesAB','',''),(113,'priv','zh-cn','story-linkStoriesAB','',''),(113,'priv','zh-tw','story-linkStoriesAB','',''),(113,'manager','zh-cn','','创建维护反馈',''),(114,'priv','de','story-relievedTwins','',''),(114,'priv','en','story-relievedTwins','',''),(114,'priv','fr','story-relievedTwins','',''),(114,'priv','zh-cn','story-relievedTwins','',''),(114,'priv','zh-tw','story-relievedTwins','',''),(114,'manager','zh-cn','','导入导出反馈',''),(115,'priv','de','story-batchEdit','',''),(115,'priv','en','story-batchEdit','',''),(115,'priv','fr','story-batchEdit','',''),(115,'priv','zh-cn','story-batchEdit','',''),(115,'priv','zh-tw','story-batchEdit','',''),(115,'manager','zh-cn','','处理反馈',''),(116,'priv','de','story-importCase','',''),(116,'priv','en','story-importCase','',''),(116,'priv','fr','story-importCase','',''),(116,'priv','zh-cn','story-importCase','',''),(116,'priv','zh-tw','story-importCase','',''),(116,'manager','zh-cn','','FAQ',''),(117,'priv','de','story-exportTemplate','',''),(117,'priv','en','story-exportTemplate','',''),(117,'priv','fr','story-exportTemplate','',''),(117,'priv','zh-cn','story-exportTemplate','',''),(117,'priv','zh-tw','story-exportTemplate','',''),(117,'manager','zh-cn','','浏览工单',''),(118,'priv','de','story-importToLib','',''),(118,'priv','en','story-importToLib','',''),(118,'priv','fr','story-importToLib','',''),(118,'priv','zh-cn','story-importToLib','',''),(118,'priv','zh-tw','story-importToLib','',''),(118,'manager','zh-cn','','创建维护工单',''),(119,'priv','de','story-batchImportToLib','',''),(119,'priv','en','story-batchImportToLib','',''),(119,'priv','fr','story-batchImportToLib','',''),(119,'priv','zh-cn','story-batchImportToLib','',''),(119,'priv','zh-tw','story-batchImportToLib','',''),(119,'manager','zh-cn','','导入导出工单',''),(120,'priv','de','story-relation','',''),(120,'priv','en','story-relation','',''),(120,'priv','fr','story-relation','',''),(120,'priv','zh-cn','story-relation','',''),(120,'priv','zh-tw','story-relation','',''),(121,'priv','de','requirement-create','',''),(121,'priv','en','requirement-create','',''),(121,'priv','fr','requirement-create','',''),(121,'priv','zh-cn','requirement-create','',''),(121,'priv','zh-tw','requirement-create','',''),(121,'manager','zh-cn','','删除反馈',''),(122,'priv','de','requirement-batchCreate','',''),(122,'priv','en','requirement-batchCreate','',''),(122,'priv','fr','requirement-batchCreate','',''),(122,'priv','zh-cn','requirement-batchCreate','',''),(122,'priv','zh-tw','requirement-batchCreate','',''),(122,'manager','zh-cn','','删除工单',''),(123,'priv','de','requirement-editAction','',''),(123,'priv','en','requirement-editAction','',''),(123,'priv','fr','requirement-editAction','',''),(123,'priv','zh-cn','requirement-editAction','',''),(123,'priv','zh-tw','requirement-editAction','',''),(123,'manager','zh-cn','','设置反馈权限',''),(124,'priv','de','requirement-exportAction','',''),(124,'priv','en','requirement-exportAction','',''),(124,'priv','fr','requirement-exportAction','',''),(124,'priv','zh-cn','requirement-exportAction','',''),(124,'priv','zh-tw','requirement-exportAction','',''),(124,'manager','zh-cn','','课程',''),(125,'priv','de','requirement-deleteAction','',''),(125,'priv','en','requirement-deleteAction','',''),(125,'priv','fr','requirement-deleteAction','',''),(125,'priv','zh-cn','requirement-deleteAction','',''),(125,'priv','zh-tw','requirement-deleteAction','',''),(125,'manager','zh-cn','','后台管理',''),(126,'priv','de','requirement-view','',''),(126,'priv','en','requirement-view','',''),(126,'priv','fr','requirement-view','',''),(126,'priv','zh-cn','requirement-view','',''),(126,'priv','zh-tw','requirement-view','',''),(126,'manager','zh-cn','','运维管理',''),(127,'priv','de','requirement-changeAction','',''),(127,'priv','en','requirement-changeAction','',''),(127,'priv','fr','requirement-changeAction','',''),(127,'priv','zh-cn','requirement-changeAction','',''),(127,'priv','zh-tw','requirement-changeAction','',''),(127,'manager','zh-cn','','主机管理',''),(128,'priv','de','requirement-reviewAction','',''),(128,'priv','en','requirement-reviewAction','',''),(128,'priv','fr','requirement-reviewAction','',''),(128,'priv','zh-cn','requirement-reviewAction','',''),(128,'priv','zh-tw','requirement-reviewAction','',''),(128,'manager','zh-cn','','机房管理',''),(129,'priv','de','requirement-submitReview','',''),(129,'priv','en','requirement-submitReview','',''),(129,'priv','fr','requirement-submitReview','',''),(129,'priv','zh-cn','requirement-submitReview','',''),(129,'priv','zh-tw','requirement-submitReview','',''),(129,'manager','zh-cn','','运维账号管理',''),(130,'priv','de','requirement-batchReview','',''),(130,'priv','en','requirement-batchReview','',''),(130,'priv','fr','requirement-batchReview','',''),(130,'priv','zh-cn','requirement-batchReview','',''),(130,'priv','zh-tw','requirement-batchReview','',''),(130,'manager','zh-cn','','域名管理',''),(131,'priv','de','requirement-recall','',''),(131,'priv','en','requirement-recall','',''),(131,'priv','fr','requirement-recall','',''),(131,'priv','zh-cn','requirement-recall','',''),(131,'priv','zh-tw','requirement-recall','',''),(131,'manager','zh-cn','','服务管理',''),(132,'priv','de','requirement-closeAction','',''),(132,'priv','en','requirement-closeAction','',''),(132,'priv','fr','requirement-closeAction','',''),(132,'priv','zh-cn','requirement-closeAction','',''),(132,'priv','zh-tw','requirement-closeAction','',''),(132,'manager','zh-cn','','运维计划',''),(133,'priv','de','requirement-batchClose','',''),(133,'priv','en','requirement-batchClose','',''),(133,'priv','fr','requirement-batchClose','',''),(133,'priv','zh-cn','requirement-batchClose','',''),(133,'priv','zh-tw','requirement-batchClose','',''),(133,'manager','zh-cn','','上线范围',''),(134,'priv','de','requirement-assignAction','',''),(134,'priv','en','requirement-assignAction','',''),(134,'priv','fr','requirement-assignAction','',''),(134,'priv','zh-cn','requirement-assignAction','',''),(134,'priv','zh-tw','requirement-assignAction','',''),(134,'manager','zh-cn','','上线步骤',''),(135,'priv','de','requirement-batchAssignTo','',''),(135,'priv','en','requirement-batchAssignTo','',''),(135,'priv','fr','requirement-batchAssignTo','',''),(135,'priv','zh-cn','requirement-batchAssignTo','',''),(135,'priv','zh-tw','requirement-batchAssignTo','',''),(135,'manager','zh-cn','','上线用例',''),(136,'priv','de','requirement-activateAction','',''),(136,'priv','en','requirement-activateAction','',''),(136,'priv','fr','requirement-activateAction','',''),(136,'priv','zh-cn','requirement-activateAction','',''),(136,'priv','zh-tw','requirement-activateAction','',''),(136,'manager','zh-cn','','测试仪表盘',''),(137,'priv','de','requirement-reportAction','',''),(137,'priv','en','requirement-reportAction','',''),(137,'priv','fr','requirement-reportAction','',''),(137,'priv','zh-cn','requirement-reportAction','',''),(137,'priv','zh-tw','requirement-reportAction','',''),(137,'manager','zh-cn','','浏览Bug',''),(138,'priv','de','requirement-linkStory','',''),(138,'priv','en','requirement-linkStory','',''),(138,'priv','fr','requirement-linkStory','',''),(138,'priv','zh-cn','requirement-linkStory','',''),(138,'priv','zh-tw','requirement-linkStory','',''),(138,'manager','zh-cn','','创建维护Bug',''),(139,'priv','de','requirement-batchChangeBranch','',''),(139,'priv','en','requirement-batchChangeBranch','',''),(139,'priv','fr','requirement-batchChangeBranch','',''),(139,'priv','zh-cn','requirement-batchChangeBranch','',''),(139,'priv','zh-tw','requirement-batchChangeBranch','',''),(139,'manager','zh-cn','','删除Bug',''),(140,'priv','de','requirement-batchChangeModule','',''),(140,'priv','en','requirement-batchChangeModule','',''),(140,'priv','fr','requirement-batchChangeModule','',''),(140,'priv','zh-cn','requirement-batchChangeModule','',''),(140,'priv','zh-tw','requirement-batchChangeModule','',''),(140,'manager','zh-cn','','导入导出Bug',''),(141,'priv','de','requirement-linkRequirementsAB','',''),(141,'priv','en','requirement-linkRequirementsAB','',''),(141,'priv','fr','requirement-linkRequirementsAB','',''),(141,'priv','zh-cn','requirement-linkRequirementsAB','',''),(141,'priv','zh-tw','requirement-linkRequirementsAB','',''),(141,'manager','zh-cn','','浏览用例',''),(142,'priv','de','requirement-batchEdit','',''),(142,'priv','en','requirement-batchEdit','',''),(142,'priv','fr','requirement-batchEdit','',''),(142,'priv','zh-cn','requirement-batchEdit','',''),(142,'priv','zh-tw','requirement-batchEdit','',''),(142,'manager','zh-cn','','创建维护用例',''),(143,'priv','de','requirement-importCase','',''),(143,'priv','en','requirement-importCase','',''),(143,'priv','fr','requirement-importCase','',''),(143,'priv','zh-cn','requirement-importCase','',''),(143,'priv','zh-tw','requirement-importCase','',''),(143,'manager','zh-cn','','导入导出用例',''),(144,'priv','de','requirement-exportTemplate','',''),(144,'priv','en','requirement-exportTemplate','',''),(144,'priv','fr','requirement-exportTemplate','',''),(144,'priv','zh-cn','requirement-exportTemplate','',''),(144,'priv','zh-tw','requirement-exportTemplate','',''),(144,'manager','zh-cn','','删除用例',''),(145,'priv','de','productplan-browse','',''),(145,'priv','en','productplan-browse','',''),(145,'priv','fr','productplan-browse','',''),(145,'priv','zh-cn','productplan-browse','',''),(145,'priv','zh-tw','productplan-browse','',''),(145,'manager','zh-cn','','评审用例',''),(146,'priv','de','productplan-create','',''),(146,'priv','en','productplan-create','',''),(146,'priv','fr','productplan-create','',''),(146,'priv','zh-cn','productplan-create','',''),(146,'priv','zh-tw','productplan-create','',''),(146,'manager','zh-cn','','浏览测试单',''),(147,'priv','de','productplan-edit','',''),(147,'priv','en','productplan-edit','',''),(147,'priv','fr','productplan-edit','',''),(147,'priv','zh-cn','productplan-edit','',''),(147,'priv','zh-tw','productplan-edit','',''),(147,'manager','zh-cn','','创建维护测试单',''),(148,'priv','de','productplan-delete','',''),(148,'priv','en','productplan-delete','',''),(148,'priv','fr','productplan-delete','',''),(148,'priv','zh-cn','productplan-delete','',''),(148,'priv','zh-tw','productplan-delete','',''),(148,'manager','zh-cn','','删除测试单',''),(149,'priv','de','productplan-view','',''),(149,'priv','en','productplan-view','',''),(149,'priv','fr','productplan-view','',''),(149,'priv','zh-cn','productplan-view','',''),(149,'priv','zh-tw','productplan-view','',''),(149,'manager','zh-cn','','单元测试',''),(150,'priv','de','productplan-linkStory','',''),(150,'priv','en','productplan-linkStory','',''),(150,'priv','fr','productplan-linkStory','',''),(150,'priv','zh-cn','productplan-linkStory','',''),(150,'priv','zh-tw','productplan-linkStory','',''),(150,'manager','zh-cn','','浏览套件',''),(151,'priv','de','productplan-unlinkStory','',''),(151,'priv','en','productplan-unlinkStory','',''),(151,'priv','fr','productplan-unlinkStory','',''),(151,'priv','zh-cn','productplan-unlinkStory','',''),(151,'priv','zh-tw','productplan-unlinkStory','',''),(151,'manager','zh-cn','','创建维护套件',''),(152,'priv','de','productplan-batchUnlinkStory','',''),(152,'priv','en','productplan-batchUnlinkStory','',''),(152,'priv','fr','productplan-batchUnlinkStory','',''),(152,'priv','zh-cn','productplan-batchUnlinkStory','',''),(152,'priv','zh-tw','productplan-batchUnlinkStory','',''),(152,'manager','zh-cn','','删除套件',''),(153,'priv','de','productplan-linkBug','',''),(153,'priv','en','productplan-linkBug','',''),(153,'priv','fr','productplan-linkBug','',''),(153,'priv','zh-cn','productplan-linkBug','',''),(153,'priv','zh-tw','productplan-linkBug','',''),(153,'manager','zh-cn','','浏览测试报告',''),(154,'priv','de','productplan-unlinkBug','',''),(154,'priv','en','productplan-unlinkBug','',''),(154,'priv','fr','productplan-unlinkBug','',''),(154,'priv','zh-cn','productplan-unlinkBug','',''),(154,'priv','zh-tw','productplan-unlinkBug','',''),(154,'manager','zh-cn','','创建维护测试报告',''),(155,'priv','de','productplan-batchUnlinkBug','',''),(155,'priv','en','productplan-batchUnlinkBug','',''),(155,'priv','fr','productplan-batchUnlinkBug','',''),(155,'priv','zh-cn','productplan-batchUnlinkBug','',''),(155,'priv','zh-tw','productplan-batchUnlinkBug','',''),(155,'manager','zh-cn','','删除测试报告',''),(156,'priv','de','productplan-batchEdit','',''),(156,'priv','en','productplan-batchEdit','',''),(156,'priv','fr','productplan-batchEdit','',''),(156,'priv','zh-cn','productplan-batchEdit','',''),(156,'priv','zh-tw','productplan-batchEdit','',''),(156,'manager','zh-cn','','导入导出测试报告',''),(157,'priv','de','productplan-start','',''),(157,'priv','en','productplan-start','',''),(157,'priv','fr','productplan-start','',''),(157,'priv','zh-cn','productplan-start','',''),(157,'priv','zh-tw','productplan-start','',''),(157,'manager','zh-cn','','浏览宿主机',''),(158,'priv','de','productplan-finish','',''),(158,'priv','en','productplan-finish','',''),(158,'priv','fr','productplan-finish','',''),(158,'priv','zh-cn','productplan-finish','',''),(158,'priv','zh-tw','productplan-finish','',''),(158,'manager','zh-cn','','创建维护宿主机',''),(159,'priv','de','productplan-close','',''),(159,'priv','en','productplan-close','',''),(159,'priv','fr','productplan-close','',''),(159,'priv','zh-cn','productplan-close','',''),(159,'priv','zh-tw','productplan-close','',''),(159,'manager','zh-cn','','删除宿主机',''),(160,'priv','de','productplan-activate','',''),(160,'priv','en','productplan-activate','',''),(160,'priv','fr','productplan-activate','',''),(160,'priv','zh-cn','productplan-activate','',''),(160,'priv','zh-tw','productplan-activate','',''),(160,'manager','zh-cn','','镜像',''),(161,'priv','de','productplan-batchChangeStatus','',''),(161,'priv','en','productplan-batchChangeStatus','',''),(161,'priv','fr','productplan-batchChangeStatus','',''),(161,'priv','zh-cn','productplan-batchChangeStatus','',''),(161,'priv','zh-tw','productplan-batchChangeStatus','',''),(161,'manager','zh-cn','','浏览执行节点',''),(162,'priv','de','release-browse','',''),(162,'priv','en','release-browse','',''),(162,'priv','fr','release-browse','',''),(162,'priv','zh-cn','release-browse','',''),(162,'priv','zh-tw','release-browse','',''),(162,'manager','zh-cn','','创建维护执行节点',''),(163,'priv','de','release-create','',''),(163,'priv','en','release-create','',''),(163,'priv','fr','release-create','',''),(163,'priv','zh-cn','release-create','',''),(163,'priv','zh-tw','release-create','',''),(163,'manager','zh-cn','','导入导出执行节点',''),(164,'priv','de','release-edit','',''),(164,'priv','en','release-edit','',''),(164,'priv','fr','release-edit','',''),(164,'priv','zh-cn','release-edit','',''),(164,'priv','zh-tw','release-edit','',''),(164,'manager','zh-cn','',' 快照',''),(165,'priv','de','release-delete','',''),(165,'priv','en','release-delete','',''),(165,'priv','fr','release-delete','',''),(165,'priv','zh-cn','release-delete','',''),(165,'priv','zh-tw','release-delete','',''),(165,'manager','zh-cn','','浏览组织团队',''),(166,'priv','de','release-view','',''),(166,'priv','en','release-view','',''),(166,'priv','fr','release-view','',''),(166,'priv','zh-cn','release-view','',''),(166,'priv','zh-tw','release-view','',''),(166,'manager','zh-cn','','浏览组织日程',''),(167,'priv','de','release-export','',''),(167,'priv','en','release-export','',''),(167,'priv','fr','release-export','',''),(167,'priv','zh-cn','release-export','',''),(167,'priv','zh-tw','release-export','',''),(167,'manager','zh-cn','','浏览组织日志',''),(168,'priv','de','release-linkStory','',''),(168,'priv','en','release-linkStory','',''),(168,'priv','fr','release-linkStory','',''),(168,'priv','zh-cn','release-linkStory','',''),(168,'priv','zh-tw','release-linkStory','',''),(168,'manager','zh-cn','','浏览组织动态',''),(169,'priv','de','release-unlinkStory','',''),(169,'priv','en','release-unlinkStory','',''),(169,'priv','fr','release-unlinkStory','',''),(169,'priv','zh-cn','release-unlinkStory','',''),(169,'priv','zh-tw','release-unlinkStory','',''),(169,'manager','zh-cn','','维护公司信息',''),(170,'priv','de','release-batchUnlinkStory','',''),(170,'priv','en','release-batchUnlinkStory','',''),(170,'priv','fr','release-batchUnlinkStory','',''),(170,'priv','zh-cn','release-batchUnlinkStory','',''),(170,'priv','zh-tw','release-batchUnlinkStory','',''),(170,'manager','zh-cn','','部门数据权限',''),(171,'priv','de','release-linkBug','',''),(171,'priv','en','release-linkBug','',''),(171,'priv','fr','release-linkBug','',''),(171,'priv','zh-cn','release-linkBug','',''),(171,'priv','zh-tw','release-linkBug','',''),(171,'manager','zh-cn','','项目阶段',''),(172,'priv','de','release-unlinkBug','',''),(172,'priv','en','release-unlinkBug','',''),(172,'priv','fr','release-unlinkBug','',''),(172,'priv','zh-cn','release-unlinkBug','',''),(172,'priv','zh-tw','release-unlinkBug','',''),(173,'priv','de','release-batchUnlinkBug','',''),(173,'priv','en','release-batchUnlinkBug','',''),(173,'priv','fr','release-batchUnlinkBug','',''),(173,'priv','zh-cn','release-batchUnlinkBug','',''),(173,'priv','zh-tw','release-batchUnlinkBug','',''),(174,'priv','de','release-changeStatus','',''),(174,'priv','en','release-changeStatus','',''),(174,'priv','fr','release-changeStatus','',''),(174,'priv','zh-cn','release-changeStatus','',''),(174,'priv','zh-tw','release-changeStatus','',''),(175,'priv','de','release-notify','',''),(175,'priv','en','release-notify','',''),(175,'priv','fr','release-notify','',''),(175,'priv','zh-cn','release-notify','',''),(175,'priv','zh-tw','release-notify','',''),(175,'manager','zh-cn','','浏览设计',''),(176,'priv','de','project-index','',''),(176,'priv','en','project-index','',''),(176,'priv','fr','project-index','',''),(176,'priv','zh-cn','project-index','',''),(176,'priv','zh-tw','project-index','',''),(176,'manager','zh-cn','','创建维护设计',''),(177,'priv','de','project-browse','',''),(177,'priv','en','project-browse','',''),(177,'priv','fr','project-browse','',''),(177,'priv','zh-cn','project-browse','',''),(177,'priv','zh-tw','project-browse','',''),(177,'manager','zh-cn','','删除设计',''),(178,'priv','de','project-kanban','',''),(178,'priv','en','project-kanban','',''),(178,'priv','fr','project-kanban','',''),(178,'priv','zh-cn','project-kanban','',''),(178,'priv','zh-tw','project-kanban','',''),(178,'manager','zh-cn','','维护基线评审',''),(179,'priv','de','project-create','',''),(179,'priv','en','project-create','',''),(179,'priv','fr','project-create','',''),(179,'priv','zh-cn','project-create','',''),(179,'priv','zh-tw','project-create','',''),(179,'manager','zh-cn','','维护问题',''),(180,'priv','de','project-edit','',''),(180,'priv','en','project-edit','',''),(180,'priv','fr','project-edit','',''),(180,'priv','zh-cn','project-edit','',''),(180,'priv','zh-tw','project-edit','',''),(180,'manager','zh-cn','','项目配置',''),(181,'priv','de','project-batchEdit','',''),(181,'priv','en','project-batchEdit','',''),(181,'priv','fr','project-batchEdit','',''),(181,'priv','zh-cn','project-batchEdit','',''),(181,'priv','zh-tw','project-batchEdit','',''),(181,'manager','zh-cn','','浏览项目发布',''),(182,'priv','de','project-group','',''),(182,'priv','en','project-group','',''),(182,'priv','fr','project-group','',''),(182,'priv','zh-cn','project-group','',''),(182,'priv','zh-tw','project-group','',''),(182,'manager','zh-cn','','项目周报',''),(183,'priv','de','project-createGroup','',''),(183,'priv','en','project-createGroup','',''),(183,'priv','fr','project-createGroup','',''),(183,'priv','zh-cn','project-createGroup','',''),(183,'priv','zh-tw','project-createGroup','',''),(183,'manager','zh-cn','','项目里程碑报告',''),(184,'priv','de','project-managePriv','',''),(184,'priv','en','project-managePriv','',''),(184,'priv','fr','project-managePriv','',''),(184,'priv','zh-cn','project-managePriv','',''),(184,'priv','zh-tw','project-managePriv','',''),(184,'manager','zh-cn','','调研计划',''),(185,'priv','de','project-manageMembers','',''),(185,'priv','en','project-manageMembers','',''),(185,'priv','fr','project-manageMembers','',''),(185,'priv','zh-cn','project-manageMembers','',''),(185,'priv','zh-tw','project-manageMembers','',''),(185,'manager','zh-cn','','调研报告',''),(186,'priv','de','project-manageGroupMember','',''),(186,'priv','en','project-manageGroupMember','',''),(186,'priv','fr','project-manageGroupMember','',''),(186,'priv','zh-cn','project-manageGroupMember','',''),(186,'priv','zh-tw','project-manageGroupMember','',''),(186,'manager','zh-cn','','费用估算',''),(187,'priv','de','project-copyGroup','',''),(187,'priv','en','project-copyGroup','',''),(187,'priv','fr','project-copyGroup','',''),(187,'priv','zh-cn','project-copyGroup','',''),(187,'priv','zh-tw','project-copyGroup','',''),(187,'manager','zh-cn','','工作量估算',''),(188,'priv','de','project-editGroup','',''),(188,'priv','en','project-editGroup','',''),(188,'priv','fr','project-editGroup','',''),(188,'priv','zh-cn','project-editGroup','',''),(188,'priv','zh-tw','project-editGroup','',''),(188,'manager','zh-cn','','项目工期估算',''),(189,'priv','de','project-start','',''),(189,'priv','en','project-start','',''),(189,'priv','fr','project-start','',''),(189,'priv','zh-cn','project-start','',''),(189,'priv','zh-tw','project-start','',''),(189,'manager','zh-cn','','浏览问题',''),(190,'priv','de','project-suspend','',''),(190,'priv','en','project-suspend','',''),(190,'priv','fr','project-suspend','',''),(190,'priv','zh-cn','project-suspend','',''),(190,'priv','zh-tw','project-suspend','',''),(190,'manager','zh-cn','','创建维护问题',''),(191,'priv','de','project-close','',''),(191,'priv','en','project-close','',''),(191,'priv','fr','project-close','',''),(191,'priv','zh-cn','project-close','',''),(191,'priv','zh-tw','project-close','',''),(191,'manager','zh-cn','','导入导出问题',''),(192,'priv','de','project-activate','',''),(192,'priv','en','project-activate','',''),(192,'priv','fr','project-activate','',''),(192,'priv','zh-cn','project-activate','',''),(192,'priv','zh-tw','project-activate','',''),(192,'manager','zh-cn','','删除问题',''),(193,'priv','de','project-updateOrder','',''),(193,'priv','en','project-updateOrder','',''),(193,'priv','fr','project-updateOrder','',''),(193,'priv','zh-cn','project-updateOrder','',''),(193,'priv','zh-tw','project-updateOrder','',''),(193,'manager','zh-cn','','导入问题库',''),(194,'priv','de','project-delete','',''),(194,'priv','en','project-delete','',''),(194,'priv','fr','project-delete','',''),(194,'priv','zh-cn','project-delete','',''),(194,'priv','zh-tw','project-delete','',''),(194,'manager','zh-cn','','浏览风险',''),(195,'priv','de','project-view','',''),(195,'priv','en','project-view','',''),(195,'priv','fr','project-view','',''),(195,'priv','zh-cn','project-view','',''),(195,'priv','zh-tw','project-view','',''),(195,'manager','zh-cn','','创建维护风险',''),(196,'priv','de','project-whitelist','',''),(196,'priv','en','project-whitelist','',''),(196,'priv','fr','project-whitelist','',''),(196,'priv','zh-cn','project-whitelist','',''),(196,'priv','zh-tw','project-whitelist','',''),(196,'manager','zh-cn','','导入导出风险',''),(197,'priv','de','project-addWhitelist','',''),(197,'priv','en','project-addWhitelist','',''),(197,'priv','fr','project-addWhitelist','',''),(197,'priv','zh-cn','project-addWhitelist','',''),(197,'priv','zh-tw','project-addWhitelist','',''),(197,'manager','zh-cn','','删除问题',''),(198,'priv','de','project-unbindWhitelist','',''),(198,'priv','en','project-unbindWhitelist','',''),(198,'priv','fr','project-unbindWhitelist','',''),(198,'priv','zh-cn','project-unbindWhitelist','',''),(198,'priv','zh-tw','project-unbindWhitelist','',''),(198,'manager','zh-cn','','导入风险库',''),(199,'priv','de','project-manageProducts','',''),(199,'priv','en','project-manageProducts','',''),(199,'priv','fr','project-manageProducts','',''),(199,'priv','zh-cn','project-manageProducts','',''),(199,'priv','zh-tw','project-manageProducts','',''),(199,'manager','zh-cn','','浏览机会',''),(200,'priv','de','project-dynamic','',''),(200,'priv','en','project-dynamic','',''),(200,'priv','fr','project-dynamic','',''),(200,'priv','zh-cn','project-dynamic','',''),(200,'priv','zh-tw','project-dynamic','',''),(200,'manager','zh-cn','','创建维护机会',''),(201,'manager','zh-cn','','删除机会',''),(202,'manager','zh-cn','','导入机会库',''),(203,'priv','de','project-bug','',''),(203,'priv','en','project-bug','',''),(203,'priv','fr','project-bug','',''),(203,'priv','zh-cn','project-bug','',''),(203,'priv','zh-tw','project-bug','',''),(203,'manager','zh-cn','','导入导出机会',''),(204,'priv','de','project-testcase','',''),(204,'priv','en','project-testcase','',''),(204,'priv','fr','project-testcase','',''),(204,'priv','zh-cn','project-testcase','',''),(204,'priv','zh-tw','project-testcase','',''),(204,'manager','zh-cn','','项目过程',''),(205,'priv','de','project-testtask','',''),(205,'priv','en','project-testtask','',''),(205,'priv','fr','project-testtask','',''),(205,'priv','zh-cn','project-testtask','',''),(205,'priv','zh-tw','project-testtask','',''),(205,'manager','zh-cn','','项目度量',''),(206,'priv','de','project-testreport','',''),(206,'priv','en','project-testreport','',''),(206,'priv','fr','project-testreport','',''),(206,'priv','zh-cn','project-testreport','',''),(206,'priv','zh-tw','project-testreport','',''),(206,'manager','zh-cn','','维护质量保证计划',''),(207,'priv','de','project-execution','',''),(207,'priv','en','project-execution','',''),(207,'priv','fr','project-execution','',''),(207,'priv','zh-cn','project-execution','',''),(207,'priv','zh-tw','project-execution','',''),(207,'manager','zh-cn','','不符合项',''),(208,'priv','de','project-export','',''),(208,'priv','en','project-export','',''),(208,'priv','fr','project-export','',''),(208,'priv','zh-cn','project-export','',''),(208,'priv','zh-tw','project-export','',''),(208,'manager','zh-cn','','会议',''),(209,'priv','de','project-teamAction','',''),(209,'priv','en','project-teamAction','',''),(209,'priv','fr','project-teamAction','',''),(209,'priv','zh-cn','project-teamAction','',''),(209,'priv','zh-tw','project-teamAction','',''),(209,'manager','zh-cn','','培训计划',''),(210,'priv','de','project-unlinkMemberAction','',''),(210,'priv','en','project-unlinkMemberAction','',''),(210,'priv','fr','project-unlinkMemberAction','',''),(210,'priv','zh-cn','project-unlinkMemberAction','',''),(210,'priv','zh-tw','project-unlinkMemberAction','',''),(210,'manager','zh-cn','','能力差距分析',''),(211,'manager','zh-cn','','工作流字段',''),(212,'priv','de','project-moduleOpenAction','',''),(212,'priv','en','project-moduleOpenAction','',''),(212,'priv','fr','project-moduleOpenAction','',''),(212,'priv','zh-cn','project-moduleOpenAction','',''),(212,'priv','zh-tw','project-moduleOpenAction','',''),(212,'manager','zh-cn','','工作流动作',''),(213,'priv','de','project-approval','',''),(213,'priv','en','project-approval','',''),(213,'priv','fr','project-approval','',''),(213,'priv','zh-cn','project-approval','',''),(213,'priv','zh-tw','project-approval','',''),(213,'manager','zh-cn','','工作流界面',''),(214,'priv','de','projectplan-browse','',''),(214,'priv','en','projectplan-browse','',''),(214,'priv','fr','projectplan-browse','',''),(214,'priv','zh-cn','projectplan-browse','',''),(214,'priv','zh-tw','projectplan-browse','',''),(214,'manager','zh-cn','','工作流触发条件',''),(215,'priv','de','projectplan-create','',''),(215,'priv','en','projectplan-create','',''),(215,'priv','fr','projectplan-create','',''),(215,'priv','zh-cn','projectplan-create','',''),(215,'priv','zh-tw','projectplan-create','',''),(215,'manager','zh-cn','','工作流界面联动',''),(216,'priv','de','projectplan-edit','',''),(216,'priv','en','projectplan-edit','',''),(216,'priv','fr','projectplan-edit','',''),(216,'priv','zh-cn','projectplan-edit','',''),(216,'priv','zh-tw','projectplan-edit','',''),(216,'manager','zh-cn','','工作流扩展动作',''),(217,'priv','de','projectplan-view','',''),(217,'priv','en','projectplan-view','',''),(217,'priv','fr','projectplan-view','',''),(217,'priv','zh-cn','projectplan-view','',''),(217,'priv','zh-tw','projectplan-view','',''),(217,'manager','zh-cn','','工作流标签',''),(218,'priv','de','projectstory-story','',''),(218,'priv','en','projectstory-story','',''),(218,'priv','fr','projectstory-story','',''),(218,'priv','zh-cn','projectstory-story','',''),(218,'priv','zh-tw','projectstory-story','',''),(218,'manager','zh-cn','','工作流跨流程设置',''),(219,'priv','de','projectstory-trackAction','',''),(219,'priv','en','projectstory-trackAction','',''),(219,'priv','fr','projectstory-trackAction','',''),(219,'priv','zh-cn','projectstory-trackAction','',''),(219,'priv','zh-tw','projectstory-trackAction','',''),(220,'priv','de','projectstory-view','',''),(220,'priv','en','projectstory-view','',''),(220,'priv','fr','projectstory-view','',''),(220,'priv','zh-cn','projectstory-view','',''),(220,'priv','zh-tw','projectstory-view','',''),(220,'manager','zh-cn','','工作流报表',''),(221,'priv','de','projectstory-linkStory','',''),(221,'priv','en','projectstory-linkStory','',''),(221,'priv','fr','projectstory-linkStory','',''),(221,'priv','zh-cn','projectstory-linkStory','',''),(221,'priv','zh-tw','projectstory-linkStory','',''),(221,'manager','zh-cn','','工作流数据源',''),(222,'priv','de','projectstory-importplanstories','',''),(222,'priv','en','projectstory-importplanstories','',''),(222,'priv','fr','projectstory-importplanstories','',''),(222,'priv','zh-cn','projectstory-importplanstories','',''),(222,'priv','zh-tw','projectstory-importplanstories','',''),(222,'manager','zh-cn','','工作流验证规则',''),(223,'priv','de','projectstory-unlinkStory','',''),(223,'priv','en','projectstory-unlinkStory','',''),(223,'priv','fr','projectstory-unlinkStory','',''),(223,'priv','zh-cn','projectstory-unlinkStory','',''),(223,'priv','zh-tw','projectstory-unlinkStory','',''),(223,'manager','zh-cn','','工作流',''),(224,'priv','de','projectstory-batchUnlinkStory','',''),(224,'priv','en','projectstory-batchUnlinkStory','',''),(224,'priv','fr','projectstory-batchUnlinkStory','',''),(224,'priv','zh-cn','projectstory-batchUnlinkStory','',''),(224,'priv','zh-tw','projectstory-batchUnlinkStory','',''),(224,'manager','zh-cn','','代码',''),(225,'priv','de','projectstory-importFromLib','',''),(225,'priv','en','projectstory-importFromLib','',''),(225,'priv','fr','projectstory-importFromLib','',''),(225,'priv','zh-cn','projectstory-importFromLib','',''),(225,'priv','zh-tw','projectstory-importFromLib','',''),(225,'manager','zh-cn','','下载代码',''),(226,'priv','de','execution-view','',''),(226,'priv','en','execution-view','',''),(226,'priv','fr','execution-view','',''),(226,'priv','zh-cn','execution-view','',''),(226,'priv','zh-tw','execution-view','',''),(226,'manager','zh-cn','','二次开发',''),(227,'manager','zh-cn','','评审代码',''),(228,'priv','de','execution-createExec','',''),(228,'priv','en','execution-createExec','',''),(228,'priv','fr','execution-createExec','',''),(228,'priv','zh-cn','execution-createExec','',''),(228,'priv','zh-tw','execution-createExec','',''),(228,'manager','zh-cn','','编辑器',''),(229,'priv','de','execution-editAction','',''),(229,'priv','en','execution-editAction','',''),(229,'priv','fr','execution-editAction','',''),(229,'priv','zh-cn','execution-editAction','',''),(229,'priv','zh-tw','execution-editAction','',''),(229,'manager','zh-cn','','接入禅道',''),(230,'priv','de','execution-batchEditAction','',''),(230,'priv','en','execution-batchEditAction','',''),(230,'priv','fr','execution-batchEditAction','',''),(230,'priv','zh-cn','execution-batchEditAction','',''),(230,'priv','zh-tw','execution-batchEditAction','',''),(230,'manager','zh-cn','','合并请求',''),(231,'priv','de','execution-batchChangeStatus','',''),(231,'priv','en','execution-batchChangeStatus','',''),(231,'priv','fr','execution-batchChangeStatus','',''),(231,'priv','zh-cn','execution-batchChangeStatus','',''),(231,'priv','zh-tw','execution-batchChangeStatus','',''),(231,'manager','zh-cn','','权限后台设置',''),(232,'priv','de','execution-startAction','',''),(232,'priv','en','execution-startAction','',''),(232,'priv','fr','execution-startAction','',''),(232,'priv','zh-cn','execution-startAction','',''),(232,'priv','zh-tw','execution-startAction','',''),(232,'manager','zh-cn','','部门结构',''),(233,'priv','de','execution-activateAction','',''),(233,'priv','en','execution-activateAction','',''),(233,'priv','fr','execution-activateAction','',''),(233,'priv','zh-cn','execution-activateAction','',''),(233,'priv','zh-tw','execution-activateAction','',''),(233,'manager','zh-cn','','权限分组',''),(234,'priv','de','execution-delayAction','',''),(234,'priv','en','execution-delayAction','',''),(234,'priv','fr','execution-delayAction','',''),(234,'priv','zh-cn','execution-delayAction','',''),(234,'priv','zh-tw','execution-delayAction','',''),(234,'manager','zh-cn','','维护用户',''),(235,'priv','de','execution-suspendAction','',''),(235,'priv','en','execution-suspendAction','',''),(235,'priv','fr','execution-suspendAction','',''),(235,'priv','zh-cn','execution-suspendAction','',''),(235,'priv','zh-tw','execution-suspendAction','',''),(235,'manager','zh-cn','','插件管理',''),(236,'priv','de','execution-closeAction','',''),(236,'priv','en','execution-closeAction','',''),(236,'priv','fr','execution-closeAction','',''),(236,'priv','zh-cn','execution-closeAction','',''),(236,'priv','zh-tw','execution-closeAction','',''),(236,'manager','zh-cn','','通知设置',''),(237,'priv','de','execution-deleteAB','',''),(237,'priv','en','execution-deleteAB','',''),(237,'priv','fr','execution-deleteAB','',''),(237,'priv','zh-cn','execution-deleteAB','',''),(237,'priv','zh-tw','execution-deleteAB','',''),(237,'manager','zh-cn','','邮件配置',''),(238,'priv','de','execution-task','',''),(238,'priv','en','execution-task','',''),(238,'priv','fr','execution-task','',''),(238,'priv','zh-cn','execution-task','',''),(238,'priv','zh-tw','execution-task','',''),(238,'manager','zh-cn','','Webhook',''),(239,'priv','de','execution-groupTask','',''),(239,'priv','en','execution-groupTask','',''),(239,'priv','fr','execution-groupTask','',''),(239,'priv','zh-cn','execution-groupTask','',''),(239,'priv','zh-tw','execution-groupTask','',''),(239,'manager','zh-cn','','代码库',''),(240,'priv','de','execution-importTask','',''),(240,'priv','en','execution-importTask','',''),(240,'priv','fr','execution-importTask','',''),(240,'priv','zh-cn','execution-importTask','',''),(240,'priv','zh-tw','execution-importTask','',''),(240,'manager','zh-cn','','GitLab',''),(241,'priv','de','execution-importPlanStories','',''),(241,'priv','en','execution-importPlanStories','',''),(241,'priv','fr','execution-importPlanStories','',''),(241,'priv','zh-cn','execution-importPlanStories','',''),(241,'priv','zh-tw','execution-importPlanStories','',''),(241,'manager','zh-cn','','短信配置',''),(242,'priv','de','execution-importBug','',''),(242,'priv','en','execution-importBug','',''),(242,'priv','fr','execution-importBug','',''),(242,'priv','zh-cn','execution-importBug','',''),(242,'priv','zh-tw','execution-importBug','',''),(242,'manager','zh-cn','','Gogs',''),(243,'priv','de','execution-story','',''),(243,'priv','en','execution-story','',''),(243,'priv','fr','execution-story','',''),(243,'priv','zh-cn','execution-story','',''),(243,'priv','zh-tw','execution-story','',''),(243,'manager','zh-cn','','Gitea',''),(244,'priv','de','execution-build','',''),(244,'priv','en','execution-build','',''),(244,'priv','fr','execution-build','',''),(244,'priv','zh-cn','execution-build','',''),(244,'priv','zh-tw','execution-build','',''),(244,'manager','zh-cn','','SonarQube',''),(245,'priv','de','execution-testcase','',''),(245,'priv','en','execution-testcase','',''),(245,'priv','fr','execution-testcase','',''),(245,'priv','zh-cn','execution-testcase','',''),(245,'priv','zh-tw','execution-testcase','',''),(245,'manager','zh-cn','','指令',''),(246,'priv','de','execution-bug','',''),(246,'priv','en','execution-bug','',''),(246,'priv','fr','execution-bug','',''),(246,'priv','zh-cn','execution-bug','',''),(246,'priv','zh-tw','execution-bug','',''),(246,'manager','zh-cn','','流水线',''),(247,'priv','de','execution-testtask','',''),(247,'priv','en','execution-testtask','',''),(247,'priv','fr','execution-testtask','',''),(247,'priv','zh-cn','execution-testtask','',''),(247,'priv','zh-tw','execution-testtask','',''),(247,'manager','zh-cn','','流水线列表',''),(248,'priv','de','execution-testreport','',''),(248,'priv','en','execution-testreport','',''),(248,'priv','fr','execution-testreport','',''),(248,'priv','zh-cn','execution-testreport','',''),(248,'priv','zh-tw','execution-testreport','',''),(248,'manager','zh-cn','','合并请求',''),(249,'priv','de','execution-burn','',''),(249,'priv','en','execution-burn','',''),(249,'priv','fr','execution-burn','',''),(249,'priv','zh-cn','execution-burn','',''),(249,'priv','zh-tw','execution-burn','',''),(249,'manager','zh-cn','','系统备份',''),(250,'priv','de','execution-computeBurnAction','',''),(250,'priv','en','execution-computeBurnAction','',''),(250,'priv','fr','execution-computeBurnAction','',''),(250,'priv','zh-cn','execution-computeBurnAction','',''),(250,'priv','zh-tw','execution-computeBurnAction','',''),(250,'manager','zh-cn','','回收站',''),(251,'priv','de','execution-CFD','',''),(251,'priv','en','execution-CFD','',''),(251,'priv','fr','execution-CFD','',''),(251,'priv','zh-cn','execution-CFD','',''),(251,'priv','zh-tw','execution-CFD','',''),(251,'manager','zh-cn','','安全',''),(252,'priv','de','execution-computeCFD','',''),(252,'priv','en','execution-computeCFD','',''),(252,'priv','fr','execution-computeCFD','',''),(252,'priv','zh-cn','execution-computeCFD','',''),(252,'priv','zh-tw','execution-computeCFD','',''),(252,'manager','zh-cn','','定时',''),(253,'priv','de','execution-fixFirst','',''),(253,'priv','en','execution-fixFirst','',''),(253,'priv','fr','execution-fixFirst','',''),(253,'priv','zh-cn','execution-fixFirst','',''),(253,'priv','zh-tw','execution-fixFirst','',''),(253,'manager','zh-cn','','LDAP',''),(254,'manager','zh-cn','','聊天',''),(255,'priv','de','execution-teamAction','',''),(255,'priv','en','execution-teamAction','',''),(255,'priv','fr','execution-teamAction','',''),(255,'priv','zh-cn','execution-teamAction','',''),(255,'priv','zh-tw','execution-teamAction','',''),(255,'manager','zh-cn','','jenkins',''),(256,'priv','de','execution-dynamic','',''),(256,'priv','en','execution-dynamic','',''),(256,'priv','fr','execution-dynamic','',''),(256,'priv','zh-cn','execution-dynamic','',''),(256,'priv','zh-tw','execution-dynamic','',''),(256,'manager','zh-cn','','系统设置',''),(257,'priv','de','execution-manageProducts','',''),(257,'priv','en','execution-manageProducts','',''),(257,'priv','fr','execution-manageProducts','',''),(257,'priv','zh-cn','execution-manageProducts','',''),(257,'priv','zh-tw','execution-manageProducts','',''),(257,'manager','zh-cn','','搜索',''),(258,'priv','de','execution-manageMembers','',''),(258,'priv','en','execution-manageMembers','',''),(258,'priv','fr','execution-manageMembers','',''),(258,'priv','zh-cn','execution-manageMembers','',''),(258,'priv','zh-tw','execution-manageMembers','',''),(258,'manager','zh-cn','','备注',''),(259,'priv','de','execution-unlinkMember','',''),(259,'priv','en','execution-unlinkMember','',''),(259,'priv','fr','execution-unlinkMember','',''),(259,'priv','zh-cn','execution-unlinkMember','',''),(259,'priv','zh-tw','execution-unlinkMember','',''),(259,'manager','zh-cn','','模块维护',''),(260,'priv','de','execution-linkStory','',''),(260,'priv','en','execution-linkStory','',''),(260,'priv','fr','execution-linkStory','',''),(260,'priv','zh-cn','execution-linkStory','',''),(260,'priv','zh-tw','execution-linkStory','',''),(260,'manager','zh-cn','','附件',''),(261,'priv','de','execution-unlinkStory','',''),(261,'priv','en','execution-unlinkStory','',''),(261,'priv','fr','execution-unlinkStory','',''),(261,'priv','zh-cn','execution-unlinkStory','',''),(261,'priv','zh-tw','execution-unlinkStory','',''),(261,'manager','zh-cn','','通用日志',''),(262,'priv','de','execution-batchUnlinkStory','',''),(262,'priv','en','execution-batchUnlinkStory','',''),(262,'priv','fr','execution-batchUnlinkStory','',''),(262,'priv','zh-cn','execution-batchUnlinkStory','',''),(262,'priv','zh-tw','execution-batchUnlinkStory','',''),(262,'manager','zh-cn','','文档模板',''),(263,'priv','de','execution-updateOrder','',''),(263,'priv','en','execution-updateOrder','',''),(263,'priv','fr','execution-updateOrder','',''),(263,'priv','zh-cn','execution-updateOrder','',''),(263,'priv','zh-tw','execution-updateOrder','',''),(263,'manager','zh-cn','','导入需求库',''),(264,'priv','de','execution-taskKanban','',''),(264,'priv','en','execution-taskKanban','',''),(264,'priv','fr','execution-taskKanban','',''),(264,'priv','zh-cn','execution-taskKanban','',''),(264,'priv','zh-tw','execution-taskKanban','',''),(264,'manager','zh-cn','','项目干系人',''),(265,'priv','de','execution-printKanbanAction','',''),(265,'priv','en','execution-printKanbanAction','',''),(265,'priv','fr','execution-printKanbanAction','',''),(265,'priv','zh-cn','execution-printKanbanAction','',''),(265,'priv','zh-tw','execution-printKanbanAction','',''),(265,'manager','zh-cn','','项目版本',''),(266,'priv','de','execution-treeAction','',''),(266,'priv','en','execution-treeAction','',''),(266,'priv','fr','execution-treeAction','',''),(266,'priv','zh-cn','execution-treeAction','',''),(266,'priv','zh-tw','execution-treeAction','',''),(266,'manager','zh-cn','','导入用例库',''),(267,'priv','de','execution-treeViewTask','',''),(267,'priv','en','execution-treeViewTask','',''),(267,'priv','fr','execution-treeViewTask','',''),(267,'priv','zh-cn','execution-treeViewTask','',''),(267,'priv','zh-tw','execution-treeViewTask','',''),(267,'manager','zh-cn','','通用配置',''),(268,'priv','de','execution-treeViewStory','',''),(268,'priv','en','execution-treeViewStory','',''),(268,'priv','fr','execution-treeViewStory','',''),(268,'priv','zh-cn','execution-treeViewStory','',''),(268,'priv','zh-tw','execution-treeViewStory','',''),(268,'manager','zh-cn','','阶段列表设置',''),(269,'priv','de','execution-allExecutionAB','',''),(269,'priv','en','execution-allExecutionAB','',''),(269,'priv','fr','execution-allExecutionAB','',''),(269,'priv','zh-cn','execution-allExecutionAB','',''),(269,'priv','zh-tw','execution-allExecutionAB','',''),(269,'manager','zh-cn','','分类项设置',''),(270,'priv','de','execution-exportAction','',''),(270,'priv','en','execution-exportAction','',''),(270,'priv','fr','execution-exportAction','',''),(270,'priv','zh-cn','execution-exportAction','',''),(270,'priv','zh-tw','execution-exportAction','',''),(270,'manager','zh-cn','','审计设置',''),(271,'priv','de','execution-storyKanban','',''),(271,'priv','en','execution-storyKanban','',''),(271,'priv','fr','execution-storyKanban','',''),(271,'priv','zh-cn','execution-storyKanban','',''),(271,'priv','zh-tw','execution-storyKanban','',''),(271,'manager','zh-cn','','QA检查项设置',''),(272,'priv','de','execution-storySort','',''),(272,'priv','en','execution-storySort','',''),(272,'priv','fr','execution-storySort','',''),(272,'priv','zh-cn','execution-storySort','',''),(272,'priv','zh-tw','execution-storySort','',''),(272,'manager','zh-cn','','评审设置',''),(273,'priv','de','execution-whitelist','',''),(273,'priv','en','execution-whitelist','',''),(273,'priv','fr','execution-whitelist','',''),(273,'priv','zh-cn','execution-whitelist','',''),(273,'priv','zh-tw','execution-whitelist','',''),(273,'manager','zh-cn','','过程设置',''),(274,'priv','de','execution-addWhitelist','',''),(274,'priv','en','execution-addWhitelist','',''),(274,'priv','fr','execution-addWhitelist','',''),(274,'priv','zh-cn','execution-addWhitelist','',''),(274,'priv','zh-tw','execution-addWhitelist','',''),(274,'manager','zh-cn','','活动设置',''),(275,'priv','de','execution-unbindWhitelist','',''),(275,'priv','en','execution-unbindWhitelist','',''),(275,'priv','fr','execution-unbindWhitelist','',''),(275,'priv','zh-cn','execution-unbindWhitelist','',''),(275,'priv','zh-tw','execution-unbindWhitelist','',''),(275,'manager','zh-cn','','文档设置',''),(276,'priv','de','execution-storyEstimate','',''),(276,'priv','en','execution-storyEstimate','',''),(276,'priv','fr','execution-storyEstimate','',''),(276,'priv','zh-cn','execution-storyEstimate','',''),(276,'priv','zh-tw','execution-storyEstimate','',''),(276,'manager','zh-cn','','自定义配置',''),(277,'priv','de','execution-kanbanAction','',''),(277,'priv','en','execution-kanbanAction','',''),(277,'priv','fr','execution-kanbanAction','',''),(277,'priv','zh-cn','execution-kanbanAction','',''),(277,'priv','zh-tw','execution-kanbanAction','',''),(277,'manager','zh-cn','','审批设置',''),(278,'priv','de','execution-RDKanban','',''),(278,'priv','en','execution-RDKanban','',''),(278,'priv','fr','execution-RDKanban','',''),(278,'priv','zh-cn','execution-RDKanban','',''),(278,'priv','zh-tw','execution-RDKanban','',''),(278,'manager','zh-cn','','度量设置',''),(279,'priv','de','execution-setKanban','',''),(279,'priv','en','execution-setKanban','',''),(279,'priv','fr','execution-setKanban','',''),(279,'priv','zh-cn','execution-setKanban','',''),(279,'priv','zh-tw','execution-setKanban','',''),(279,'manager','zh-cn','','用户设置',''),(280,'priv','de','execution-doc','',''),(280,'priv','en','execution-doc','',''),(280,'priv','fr','execution-doc','',''),(280,'priv','zh-cn','execution-doc','',''),(280,'priv','zh-tw','execution-doc','',''),(280,'manager','zh-cn','','会议室设置',''),(281,'priv','de','execution-storyView','',''),(281,'priv','en','execution-storyView','',''),(281,'priv','fr','execution-storyView','',''),(281,'priv','zh-cn','execution-storyView','',''),(281,'priv','zh-tw','execution-storyView','',''),(281,'manager','zh-cn','','sql构建器',''),(282,'priv','de','execution-calendar','',''),(282,'priv','en','execution-calendar','',''),(282,'priv','fr','execution-calendar','',''),(282,'priv','zh-cn','execution-calendar','',''),(282,'priv','zh-tw','execution-calendar','',''),(282,'manager','zh-cn','','设计设置',''),(283,'priv','de','execution-effortCalendar','',''),(283,'priv','en','execution-effortCalendar','',''),(283,'priv','fr','execution-effortCalendar','',''),(283,'priv','zh-cn','execution-effortCalendar','',''),(283,'priv','zh-tw','execution-effortCalendar','',''),(283,'manager','zh-cn','','维护空间',''),(284,'priv','de','execution-effortAction','',''),(284,'priv','en','execution-effortAction','',''),(284,'priv','fr','execution-effortAction','',''),(284,'priv','zh-cn','execution-effortAction','',''),(284,'priv','zh-tw','execution-effortAction','',''),(284,'manager','zh-cn','','删除空间',''),(285,'priv','de','execution-taskEffort','',''),(285,'priv','en','execution-taskEffort','',''),(285,'priv','fr','execution-taskEffort','',''),(285,'priv','zh-cn','execution-taskEffort','',''),(285,'priv','zh-tw','execution-taskEffort','',''),(285,'manager','zh-cn','','浏览看板',''),(286,'priv','de','execution-computeTaskEffort','',''),(286,'priv','en','execution-computeTaskEffort','',''),(286,'priv','fr','execution-computeTaskEffort','',''),(286,'priv','zh-cn','execution-computeTaskEffort','',''),(286,'priv','zh-tw','execution-computeTaskEffort','',''),(286,'manager','zh-cn','','创建维护看板',''),(287,'priv','de','execution-deleterelation','',''),(287,'priv','en','execution-deleterelation','',''),(287,'priv','fr','execution-deleterelation','',''),(287,'priv','zh-cn','execution-deleterelation','',''),(287,'priv','zh-tw','execution-deleterelation','',''),(287,'manager','zh-cn','','删除看板',''),(288,'priv','de','execution-editrelation','',''),(288,'priv','en','execution-editrelation','',''),(288,'priv','fr','execution-editrelation','',''),(288,'priv','zh-cn','execution-editrelation','',''),(288,'priv','zh-tw','execution-editrelation','',''),(288,'manager','zh-cn','','删除执行节点',''),(289,'priv','de','execution-viewrelation','',''),(289,'priv','en','execution-viewrelation','',''),(289,'priv','fr','execution-viewrelation','',''),(289,'priv','zh-cn','execution-viewrelation','',''),(289,'priv','zh-tw','execution-viewrelation','',''),(289,'manager','zh-cn','','自动化测试',''),(290,'priv','de','execution-ganttchart','',''),(290,'priv','en','execution-ganttchart','',''),(290,'priv','fr','execution-ganttchart','',''),(290,'priv','zh-cn','execution-ganttchart','',''),(290,'priv','zh-tw','execution-ganttchart','',''),(290,'manager','zh-cn','','测试',''),(291,'priv','de','execution-ganttSetting','',''),(291,'priv','en','execution-ganttSetting','',''),(291,'priv','fr','execution-ganttSetting','',''),(291,'priv','zh-cn','execution-ganttSetting','',''),(291,'priv','zh-tw','execution-ganttSetting','',''),(291,'manager','zh-cn','','维护日志',''),(292,'priv','de','execution-ganttEdit','',''),(292,'priv','en','execution-ganttEdit','',''),(292,'priv','fr','execution-ganttEdit','',''),(292,'priv','zh-cn','execution-ganttEdit','',''),(292,'priv','zh-tw','execution-ganttEdit','',''),(292,'manager','zh-cn','','测试',''),(293,'priv','de','kanban-spaceCommon','',''),(293,'priv','en','kanban-spaceCommon','',''),(293,'priv','fr','kanban-spaceCommon','',''),(293,'priv','zh-cn','kanban-spaceCommon','',''),(293,'priv','zh-tw','kanban-spaceCommon','',''),(293,'manager','zh-cn','','矩阵',''),(294,'priv','de','kanban-createSpace','',''),(294,'priv','en','kanban-createSpace','',''),(294,'priv','fr','kanban-createSpace','',''),(294,'priv','zh-cn','kanban-createSpace','',''),(294,'priv','zh-tw','kanban-createSpace','',''),(294,'manager','zh-cn','','后台',''),(295,'priv','de','kanban-editSpace','',''),(295,'priv','en','kanban-editSpace','',''),(295,'priv','fr','kanban-editSpace','',''),(295,'priv','zh-cn','kanban-editSpace','',''),(295,'priv','zh-tw','kanban-editSpace','',''),(295,'manager','zh-cn','','工作流跨流程设置',''),(296,'priv','de','kanban-closeSpace','',''),(296,'priv','en','kanban-closeSpace','',''),(296,'priv','fr','kanban-closeSpace','',''),(296,'priv','zh-cn','kanban-closeSpace','',''),(296,'priv','zh-tw','kanban-closeSpace','',''),(296,'manager','zh-cn','','模板',''),(297,'priv','de','kanban-deleteSpace','',''),(297,'priv','en','kanban-deleteSpace','',''),(297,'priv','fr','kanban-deleteSpace','',''),(297,'priv','zh-cn','kanban-deleteSpace','',''),(297,'priv','zh-tw','kanban-deleteSpace','',''),(297,'manager','zh-cn','','数据表格',''),(298,'manager','zh-cn','','自动化测试',''),(299,'priv','de','kanban-create','',''),(299,'priv','en','kanban-create','',''),(299,'priv','fr','kanban-create','',''),(299,'priv','zh-cn','kanban-create','',''),(299,'priv','zh-tw','kanban-create','',''),(299,'manager','zh-cn','','Git',''),(300,'priv','de','kanban-edit','',''),(300,'priv','en','kanban-edit','',''),(300,'priv','fr','kanban-edit','',''),(300,'priv','zh-cn','kanban-edit','',''),(300,'priv','zh-tw','kanban-edit','',''),(300,'manager','zh-cn','','Subversion',''),(301,'priv','de','kanban-view','',''),(301,'priv','en','kanban-view','',''),(301,'priv','fr','kanban-view','',''),(301,'priv','zh-cn','kanban-view','',''),(301,'priv','zh-tw','kanban-view','',''),(301,'manager','zh-cn','','防超时',''),(302,'priv','de','kanban-close','',''),(302,'priv','en','kanban-close','',''),(302,'priv','fr','kanban-close','',''),(302,'priv','zh-cn','kanban-close','',''),(302,'priv','zh-tw','kanban-close','',''),(302,'manager','zh-cn','','审批',''),(303,'priv','de','kanban-delete','',''),(303,'priv','en','kanban-delete','',''),(303,'priv','fr','kanban-delete','',''),(303,'priv','zh-cn','kanban-delete','',''),(303,'priv','zh-tw','kanban-delete','',''),(303,'manager','zh-cn','','创建维护项目发布',''),(304,'priv','de','kanban-createRegion','',''),(304,'priv','en','kanban-createRegion','',''),(304,'priv','fr','kanban-createRegion','',''),(304,'priv','zh-cn','kanban-createRegion','',''),(304,'priv','zh-tw','kanban-createRegion','',''),(304,'manager','zh-cn','','删除项目发布',''),(305,'priv','de','kanban-editRegion','',''),(305,'priv','en','kanban-editRegion','',''),(305,'priv','fr','kanban-editRegion','',''),(305,'priv','zh-cn','kanban-editRegion','',''),(305,'priv','zh-tw','kanban-editRegion','',''),(305,'manager','zh-cn','','导入导出项目发布',''),(306,'priv','de','kanban-sortRegion','',''),(306,'priv','en','kanban-sortRegion','',''),(306,'priv','fr','kanban-sortRegion','',''),(306,'priv','zh-cn','kanban-sortRegion','',''),(306,'priv','zh-tw','kanban-sortRegion','',''),(306,'manager','zh-cn','','发布通知',''),(307,'priv','de','kanban-sortGroup','',''),(307,'priv','en','kanban-sortGroup','',''),(307,'priv','fr','kanban-sortGroup','',''),(307,'priv','zh-cn','kanban-sortGroup','',''),(307,'priv','zh-tw','kanban-sortGroup','',''),(307,'manager','zh-cn','','甘特图',''),(308,'priv','de','kanban-deleteRegion','',''),(308,'priv','en','kanban-deleteRegion','',''),(308,'priv','fr','kanban-deleteRegion','',''),(308,'priv','zh-cn','kanban-deleteRegion','',''),(308,'priv','zh-tw','kanban-deleteRegion','',''),(308,'manager','zh-cn','','维护任务关系',''),(309,'priv','de','kanban-createLane','',''),(309,'priv','en','kanban-createLane','',''),(309,'priv','fr','kanban-createLane','',''),(309,'priv','zh-cn','kanban-createLane','',''),(309,'priv','zh-tw','kanban-createLane','',''),(309,'manager','zh-cn','','浏览版本',''),(310,'priv','de','kanban-sortLane','',''),(310,'priv','en','kanban-sortLane','',''),(310,'priv','fr','kanban-sortLane','',''),(310,'priv','zh-cn','kanban-sortLane','',''),(310,'priv','zh-tw','kanban-sortLane','',''),(311,'priv','de','kanban-deleteLane','',''),(311,'priv','en','kanban-deleteLane','',''),(311,'priv','fr','kanban-deleteLane','',''),(311,'priv','zh-cn','kanban-deleteLane','',''),(311,'priv','zh-tw','kanban-deleteLane','',''),(311,'manager','zh-cn','','浏览研发需求',''),(312,'priv','de','kanban-createColumn','',''),(312,'priv','en','kanban-createColumn','',''),(312,'priv','fr','kanban-createColumn','',''),(312,'priv','zh-cn','kanban-createColumn','',''),(312,'priv','zh-tw','kanban-createColumn','',''),(312,'manager','zh-cn','','维护卡片',''),(313,'priv','de','kanban-editColumn','',''),(313,'priv','en','kanban-editColumn','',''),(313,'priv','fr','kanban-editColumn','',''),(313,'priv','zh-cn','kanban-editColumn','',''),(313,'priv','zh-tw','kanban-editColumn','',''),(313,'manager','zh-cn','','浏览研发需求',''),(314,'priv','de','kanban-setWIP','',''),(314,'priv','en','kanban-setWIP','',''),(314,'priv','fr','kanban-setWIP','',''),(314,'priv','zh-cn','kanban-setWIP','',''),(314,'priv','zh-tw','kanban-setWIP','',''),(314,'manager','zh-cn','','检查质量保证计划',''),(315,'priv','de','kanban-sortColumn','',''),(315,'priv','en','kanban-sortColumn','',''),(315,'priv','fr','kanban-sortColumn','',''),(315,'priv','zh-cn','kanban-sortColumn','',''),(315,'priv','zh-tw','kanban-sortColumn','',''),(315,'manager','zh-cn','','评审基线评审',''),(316,'priv','de','kanban-deleteColumn','',''),(316,'priv','en','kanban-deleteColumn','',''),(316,'priv','fr','kanban-deleteColumn','',''),(316,'priv','zh-cn','kanban-deleteColumn','',''),(316,'priv','zh-tw','kanban-deleteColumn','',''),(316,'manager','zh-cn','','审计基线评审',''),(317,'priv','de','kanban-createCard','',''),(317,'priv','en','kanban-createCard','',''),(317,'priv','fr','kanban-createCard','',''),(317,'priv','zh-cn','kanban-createCard','',''),(317,'priv','zh-tw','kanban-createCard','',''),(317,'manager','zh-cn','','管理维度',''),(318,'priv','de','kanban-editCard','',''),(318,'priv','en','kanban-editCard','',''),(318,'priv','fr','kanban-editCard','',''),(318,'priv','zh-cn','kanban-editCard','',''),(318,'priv','zh-tw','kanban-editCard','',''),(318,'manager','zh-cn','','浏览大屏',''),(319,'priv','de','kanban-viewCard','',''),(319,'priv','en','kanban-viewCard','',''),(319,'priv','fr','kanban-viewCard','',''),(319,'priv','zh-cn','kanban-viewCard','',''),(319,'priv','zh-tw','kanban-viewCard','',''),(319,'manager','zh-cn','','创建维护大屏',''),(320,'priv','de','kanban-sortCard','',''),(320,'priv','en','kanban-sortCard','',''),(320,'priv','fr','kanban-sortCard','',''),(320,'priv','zh-cn','kanban-sortCard','',''),(320,'priv','zh-tw','kanban-sortCard','',''),(320,'manager','zh-cn','','删除大屏',''),(321,'priv','de','kanban-deleteCard','',''),(321,'priv','en','kanban-deleteCard','',''),(321,'priv','fr','kanban-deleteCard','',''),(321,'priv','zh-cn','kanban-deleteCard','',''),(321,'priv','zh-tw','kanban-deleteCard','',''),(321,'manager','zh-cn','','数据权限',''),(322,'priv','de','kanban-assigntoCard','',''),(322,'priv','en','kanban-assigntoCard','',''),(322,'priv','fr','kanban-assigntoCard','',''),(322,'priv','zh-cn','kanban-assigntoCard','',''),(322,'priv','zh-tw','kanban-assigntoCard','',''),(322,'manager','zh-cn','','浏览透视表',''),(323,'priv','de','kanban-moveCard','',''),(323,'priv','en','kanban-moveCard','',''),(323,'priv','fr','kanban-moveCard','',''),(323,'priv','zh-cn','kanban-moveCard','',''),(323,'priv','zh-tw','kanban-moveCard','',''),(323,'manager','zh-cn','','设计透视表',''),(324,'priv','de','kanban-setCardColor','',''),(324,'priv','en','kanban-setCardColor','',''),(324,'priv','fr','kanban-setCardColor','',''),(324,'priv','zh-cn','kanban-setCardColor','',''),(324,'priv','zh-tw','kanban-setCardColor','',''),(324,'manager','zh-cn','','导出透视表',''),(325,'manager','zh-cn','','数据权限',''),(326,'priv','de','kanban-viewArchivedColumn','',''),(326,'priv','en','kanban-viewArchivedColumn','',''),(326,'priv','fr','kanban-viewArchivedColumn','',''),(326,'priv','zh-cn','kanban-viewArchivedColumn','',''),(326,'priv','zh-tw','kanban-viewArchivedColumn','',''),(326,'manager','zh-cn','','浏览图表',''),(327,'priv','de','kanban-batchCreateCard','',''),(327,'priv','en','kanban-batchCreateCard','',''),(327,'priv','fr','kanban-batchCreateCard','',''),(327,'priv','zh-cn','kanban-batchCreateCard','',''),(327,'priv','zh-tw','kanban-batchCreateCard','',''),(327,'manager','zh-cn','','设计图表',''),(328,'priv','de','kanban-activateSpace','',''),(328,'priv','en','kanban-activateSpace','',''),(328,'priv','fr','kanban-activateSpace','',''),(328,'priv','zh-cn','kanban-activateSpace','',''),(328,'priv','zh-tw','kanban-activateSpace','',''),(328,'manager','zh-cn','','导出图表',''),(329,'priv','de','kanban-setting','',''),(329,'priv','en','kanban-setting','',''),(329,'priv','fr','kanban-setting','',''),(329,'priv','zh-cn','kanban-setting','',''),(329,'priv','zh-tw','kanban-setting','',''),(329,'manager','zh-cn','','浏览数据表',''),(330,'priv','de','kanban-activate','',''),(330,'priv','en','kanban-activate','',''),(330,'priv','fr','kanban-activate','',''),(330,'priv','zh-cn','kanban-activate','',''),(330,'priv','zh-tw','kanban-activate','',''),(330,'manager','zh-cn','','创建维护数据表',''),(331,'priv','de','kanban-editLaneColor','',''),(331,'priv','en','kanban-editLaneColor','',''),(331,'priv','fr','kanban-editLaneColor','',''),(331,'priv','zh-cn','kanban-editLaneColor','',''),(331,'priv','zh-tw','kanban-editLaneColor','',''),(331,'manager','zh-cn','','删除数据表',''),(332,'priv','de','kanban-editLaneName','',''),(332,'priv','en','kanban-editLaneName','',''),(332,'priv','fr','kanban-editLaneName','',''),(332,'priv','zh-cn','kanban-editLaneName','',''),(332,'priv','zh-tw','kanban-editLaneName','',''),(333,'priv','de','kanban-splitColumn','',''),(333,'priv','en','kanban-splitColumn','',''),(333,'priv','fr','kanban-splitColumn','',''),(333,'priv','zh-cn','kanban-splitColumn','',''),(333,'priv','zh-tw','kanban-splitColumn','',''),(333,'manager','zh-cn','','浏览文档',''),(334,'priv','de','kanban-archiveColumn','',''),(334,'priv','en','kanban-archiveColumn','',''),(334,'priv','fr','kanban-archiveColumn','',''),(334,'priv','zh-cn','kanban-archiveColumn','',''),(334,'priv','zh-tw','kanban-archiveColumn','',''),(334,'manager','zh-cn','','创建与维护文档',''),(335,'priv','de','kanban-restoreColumn','',''),(335,'priv','en','kanban-restoreColumn','',''),(335,'priv','fr','kanban-restoreColumn','',''),(335,'priv','zh-cn','kanban-restoreColumn','',''),(335,'priv','zh-tw','kanban-restoreColumn','',''),(335,'manager','zh-cn','','删除文档',''),(336,'priv','de','kanban-archiveCard','',''),(336,'priv','en','kanban-archiveCard','',''),(336,'priv','fr','kanban-archiveCard','',''),(336,'priv','zh-cn','kanban-archiveCard','',''),(336,'priv','zh-tw','kanban-archiveCard','',''),(336,'manager','zh-cn','','导出文档',''),(337,'priv','de','kanban-viewArchivedCard','',''),(337,'priv','en','kanban-viewArchivedCard','',''),(337,'priv','fr','kanban-viewArchivedCard','',''),(337,'priv','zh-cn','kanban-viewArchivedCard','',''),(337,'priv','zh-tw','kanban-viewArchivedCard','',''),(338,'priv','de','kanban-restoreCard','',''),(338,'priv','en','kanban-restoreCard','',''),(338,'priv','fr','kanban-restoreCard','',''),(338,'priv','zh-cn','kanban-restoreCard','',''),(338,'priv','zh-tw','kanban-restoreCard','',''),(338,'manager','zh-cn','','浏览接口空间',''),(339,'priv','de','programplan-create','',''),(339,'priv','en','programplan-create','',''),(339,'priv','fr','programplan-create','',''),(339,'priv','zh-cn','programplan-create','',''),(339,'priv','zh-tw','programplan-create','',''),(339,'manager','zh-cn','','创建维护接口',''),(340,'priv','de','programplan-edit','',''),(340,'priv','en','programplan-edit','',''),(340,'priv','fr','programplan-edit','',''),(340,'priv','zh-cn','programplan-edit','',''),(340,'priv','zh-tw','programplan-edit','',''),(340,'manager','zh-cn','','导出接口',''),(341,'priv','de','programplan-gantt','',''),(341,'priv','en','programplan-gantt','',''),(341,'priv','fr','programplan-gantt','',''),(341,'priv','zh-cn','programplan-gantt','',''),(341,'priv','zh-tw','programplan-gantt','',''),(341,'manager','zh-cn','','删除接口',''),(342,'priv','de','programplan-ganttEdit','',''),(342,'priv','en','programplan-ganttEdit','',''),(342,'priv','fr','programplan-ganttEdit','',''),(342,'priv','zh-cn','programplan-ganttEdit','',''),(342,'priv','zh-tw','programplan-ganttEdit','',''),(342,'manager','zh-cn','','接口调用',''),(343,'priv','de','task-create','',''),(343,'priv','en','task-create','',''),(343,'priv','fr','task-create','',''),(343,'priv','zh-cn','task-create','',''),(343,'priv','zh-tw','task-create','',''),(344,'priv','de','task-batchCreate','',''),(344,'priv','en','task-batchCreate','',''),(344,'priv','fr','task-batchCreate','',''),(344,'priv','zh-cn','task-batchCreate','',''),(344,'priv','zh-tw','task-batchCreate','',''),(344,'manager','zh-cn','','维护场景',''),(345,'priv','de','task-batchEdit','',''),(345,'priv','en','task-batchEdit','',''),(345,'priv','fr','task-batchEdit','',''),(345,'priv','zh-cn','task-batchEdit','',''),(345,'priv','zh-tw','task-batchEdit','',''),(345,'manager','zh-cn','','树状图',''),(346,'priv','de','task-edit','',''),(346,'priv','en','task-edit','',''),(346,'priv','fr','task-edit','',''),(346,'priv','zh-cn','task-edit','',''),(346,'priv','zh-tw','task-edit','',''),(346,'manager','zh-cn','','工时明细表',''),(347,'priv','de','task-assignAction','',''),(347,'priv','en','task-assignAction','',''),(347,'priv','fr','task-assignAction','',''),(347,'priv','zh-cn','task-assignAction','',''),(347,'priv','zh-tw','task-assignAction','',''),(347,'manager','zh-cn','','任务日历',''),(348,'priv','de','task-batchAssignTo','',''),(348,'priv','en','task-batchAssignTo','',''),(348,'priv','fr','task-batchAssignTo','',''),(348,'priv','zh-cn','task-batchAssignTo','',''),(348,'priv','zh-tw','task-batchAssignTo','',''),(348,'manager','de','index','',''),(348,'manager','en','index','',''),(348,'manager','fr','index','',''),(348,'manager','zh-cn','index','',''),(348,'manager','zh-tw','index','',''),(349,'priv','de','task-startAction','',''),(349,'priv','en','task-startAction','',''),(349,'priv','fr','task-startAction','',''),(349,'priv','zh-cn','task-startAction','',''),(349,'priv','zh-tw','task-startAction','',''),(349,'manager','de','index','',''),(349,'manager','en','index','',''),(349,'manager','fr','index','',''),(349,'manager','zh-cn','index','',''),(349,'manager','zh-tw','index','',''),(350,'priv','de','task-pauseAction','',''),(350,'priv','en','task-pauseAction','',''),(350,'priv','fr','task-pauseAction','',''),(350,'priv','zh-cn','task-pauseAction','',''),(350,'priv','zh-tw','task-pauseAction','',''),(350,'manager','de','my','',''),(350,'manager','en','my','',''),(350,'manager','fr','my','',''),(350,'manager','zh-cn','my','',''),(350,'manager','zh-tw','my','',''),(351,'priv','de','task-restartAction','',''),(351,'priv','en','task-restartAction','',''),(351,'priv','fr','task-restartAction','',''),(351,'priv','zh-cn','task-restartAction','',''),(351,'priv','zh-tw','task-restartAction','',''),(351,'manager','de','my','',''),(351,'manager','en','my','',''),(351,'manager','fr','my','',''),(351,'manager','zh-cn','my','',''),(351,'manager','zh-tw','my','',''),(352,'priv','de','task-finishAction','',''),(352,'priv','en','task-finishAction','',''),(352,'priv','fr','task-finishAction','',''),(352,'priv','zh-cn','task-finishAction','',''),(352,'priv','zh-tw','task-finishAction','',''),(352,'manager','de','todo','',''),(352,'manager','en','todo','',''),(352,'manager','fr','todo','',''),(352,'manager','zh-cn','todo','',''),(352,'manager','zh-tw','todo','',''),(353,'priv','de','task-cancelAction','',''),(353,'priv','en','task-cancelAction','',''),(353,'priv','fr','task-cancelAction','',''),(353,'priv','zh-cn','task-cancelAction','',''),(353,'priv','zh-tw','task-cancelAction','',''),(353,'manager','de','contact','',''),(353,'manager','en','contact','',''),(353,'manager','fr','contact','',''),(353,'manager','zh-cn','contact','',''),(353,'manager','zh-tw','contact','',''),(354,'priv','de','task-closeAction','',''),(354,'priv','en','task-closeAction','',''),(354,'priv','fr','task-closeAction','',''),(354,'priv','zh-cn','task-closeAction','',''),(354,'priv','zh-tw','task-closeAction','',''),(354,'manager','de','personalsettings','',''),(354,'manager','en','personalsettings','',''),(354,'manager','fr','personalsettings','',''),(354,'manager','zh-cn','personalsettings','',''),(354,'manager','zh-tw','personalsettings','',''),(355,'priv','de','task-batchClose','',''),(355,'priv','en','task-batchClose','',''),(355,'priv','fr','task-batchClose','',''),(355,'priv','zh-cn','task-batchClose','',''),(355,'priv','zh-tw','task-batchClose','',''),(355,'manager','de','effort','',''),(355,'manager','en','effort','',''),(355,'manager','fr','effort','',''),(355,'manager','zh-cn','effort','',''),(355,'manager','zh-tw','effort','',''),(356,'priv','de','task-activateAction','',''),(356,'priv','en','task-activateAction','',''),(356,'priv','fr','task-activateAction','',''),(356,'priv','zh-cn','task-activateAction','',''),(356,'priv','zh-tw','task-activateAction','',''),(356,'manager','de','program','',''),(356,'manager','en','program','',''),(356,'manager','fr','program','',''),(356,'manager','zh-cn','program','',''),(356,'manager','zh-tw','program','',''),(357,'priv','de','task-deleteAction','',''),(357,'priv','en','task-deleteAction','',''),(357,'priv','fr','task-deleteAction','',''),(357,'priv','zh-cn','task-deleteAction','',''),(357,'priv','zh-tw','task-deleteAction','',''),(357,'manager','de','program','',''),(357,'manager','en','program','',''),(357,'manager','fr','program','',''),(357,'manager','zh-cn','program','',''),(357,'manager','zh-tw','program','',''),(358,'priv','de','task-view','',''),(358,'priv','en','task-view','',''),(358,'priv','fr','task-view','',''),(358,'priv','zh-cn','task-view','',''),(358,'priv','zh-tw','task-view','',''),(358,'manager','de','personnel','',''),(358,'manager','en','personnel','',''),(358,'manager','fr','personnel','',''),(358,'manager','zh-cn','personnel','',''),(358,'manager','zh-tw','personnel','',''),(359,'priv','de','task-exportAction','',''),(359,'priv','en','task-exportAction','',''),(359,'priv','fr','task-exportAction','',''),(359,'priv','zh-cn','task-exportAction','',''),(359,'priv','zh-tw','task-exportAction','',''),(359,'manager','de','programstakeholder','',''),(359,'manager','en','programstakeholder','',''),(359,'manager','fr','programstakeholder','',''),(359,'manager','zh-cn','programstakeholder','',''),(359,'manager','zh-tw','programstakeholder','',''),(360,'priv','de','task-confirmStoryChange','',''),(360,'priv','en','task-confirmStoryChange','',''),(360,'priv','fr','task-confirmStoryChange','',''),(360,'priv','zh-cn','task-confirmStoryChange','',''),(360,'priv','zh-tw','task-confirmStoryChange','',''),(360,'manager','de','product','',''),(360,'manager','en','product','',''),(360,'manager','fr','product','',''),(360,'manager','zh-cn','product','',''),(360,'manager','zh-tw','product','',''),(361,'priv','de','task-recordEstimateAction','',''),(361,'priv','en','task-recordEstimateAction','',''),(361,'priv','fr','task-recordEstimateAction','',''),(361,'priv','zh-cn','task-recordEstimateAction','',''),(361,'priv','zh-tw','task-recordEstimateAction','',''),(361,'manager','de','product','',''),(361,'manager','en','product','',''),(361,'manager','fr','product','',''),(361,'manager','zh-cn','product','',''),(361,'manager','zh-tw','product','',''),(362,'priv','de','task-editEstimate','',''),(362,'priv','en','task-editEstimate','',''),(362,'priv','fr','task-editEstimate','',''),(362,'priv','zh-cn','task-editEstimate','',''),(362,'priv','zh-tw','task-editEstimate','',''),(362,'manager','de','story','',''),(362,'manager','en','story','',''),(362,'manager','fr','story','',''),(362,'manager','zh-cn','story','',''),(362,'manager','zh-tw','story','',''),(363,'priv','de','task-deleteEstimate','',''),(363,'priv','en','task-deleteEstimate','',''),(363,'priv','fr','task-deleteEstimate','',''),(363,'priv','zh-cn','task-deleteEstimate','',''),(363,'priv','zh-tw','task-deleteEstimate','',''),(363,'manager','de','requirement','',''),(363,'manager','en','requirement','',''),(363,'manager','fr','requirement','',''),(363,'manager','zh-cn','requirement','',''),(363,'manager','zh-tw','requirement','',''),(364,'priv','de','task-reportChart','',''),(364,'priv','en','task-reportChart','',''),(364,'priv','fr','task-reportChart','',''),(364,'priv','zh-cn','task-reportChart','',''),(364,'priv','zh-tw','task-reportChart','',''),(364,'manager','de','productplan','',''),(364,'manager','en','productplan','',''),(364,'manager','fr','productplan','',''),(364,'manager','zh-cn','productplan','',''),(364,'manager','zh-tw','productplan','',''),(365,'priv','de','task-batchChangeModule','',''),(365,'priv','en','task-batchChangeModule','',''),(365,'priv','fr','task-batchChangeModule','',''),(365,'priv','zh-cn','task-batchChangeModule','',''),(365,'priv','zh-tw','task-batchChangeModule','',''),(365,'manager','de','release','',''),(365,'manager','en','release','',''),(365,'manager','fr','release','',''),(365,'manager','zh-cn','release','',''),(365,'manager','zh-tw','release','',''),(366,'priv','de','task-batchCancel','',''),(366,'priv','en','task-batchCancel','',''),(366,'priv','fr','task-batchCancel','',''),(366,'priv','zh-cn','task-batchCancel','',''),(366,'priv','zh-tw','task-batchCancel','',''),(366,'manager','de','branch','',''),(366,'manager','en','branch','',''),(366,'manager','fr','branch','',''),(366,'manager','zh-cn','branch','',''),(366,'manager','zh-tw','branch','',''),(367,'priv','de','task-import','',''),(367,'priv','en','task-import','',''),(367,'priv','fr','task-import','',''),(367,'priv','zh-cn','task-import','',''),(367,'priv','zh-tw','task-import','',''),(367,'manager','de','productsettings','',''),(367,'manager','en','productsettings','',''),(367,'manager','fr','productsettings','',''),(367,'manager','zh-cn','productsettings','',''),(367,'manager','zh-tw','productsettings','',''),(368,'priv','de','task-exportTemplate','',''),(368,'priv','en','task-exportTemplate','',''),(368,'priv','fr','task-exportTemplate','',''),(368,'priv','zh-cn','task-exportTemplate','',''),(368,'priv','zh-tw','task-exportTemplate','',''),(368,'manager','de','project','',''),(368,'manager','en','project','',''),(368,'manager','fr','project','',''),(368,'manager','zh-cn','project','',''),(368,'manager','zh-tw','project','',''),(369,'priv','de','task-confirmDesignChange','',''),(369,'priv','en','task-confirmDesignChange','',''),(369,'priv','fr','task-confirmDesignChange','',''),(369,'priv','zh-cn','task-confirmDesignChange','',''),(369,'priv','zh-tw','task-confirmDesignChange','',''),(369,'manager','de','project','',''),(369,'manager','en','project','',''),(369,'manager','fr','project','',''),(369,'manager','zh-cn','project','',''),(369,'manager','zh-tw','project','',''),(370,'priv','de','build-create','',''),(370,'priv','en','build-create','',''),(370,'priv','fr','build-create','',''),(370,'priv','zh-cn','build-create','',''),(370,'priv','zh-tw','build-create','',''),(370,'manager','de','projectplan','',''),(370,'manager','en','projectplan','',''),(370,'manager','fr','projectplan','',''),(370,'manager','zh-cn','projectplan','',''),(370,'manager','zh-tw','projectplan','',''),(371,'priv','de','build-edit','',''),(371,'priv','en','build-edit','',''),(371,'priv','fr','build-edit','',''),(371,'priv','zh-cn','build-edit','',''),(371,'priv','zh-tw','build-edit','',''),(371,'manager','de','projectstory','',''),(371,'manager','en','projectstory','',''),(371,'manager','fr','projectstory','',''),(371,'manager','zh-cn','projectstory','',''),(371,'manager','zh-tw','projectstory','',''),(372,'priv','de','build-delete','',''),(372,'priv','en','build-delete','',''),(372,'priv','fr','build-delete','',''),(372,'priv','zh-cn','build-delete','',''),(372,'priv','zh-tw','build-delete','',''),(372,'manager','de','programplan','',''),(372,'manager','en','programplan','',''),(372,'manager','fr','programplan','',''),(372,'manager','zh-cn','programplan','',''),(372,'manager','zh-tw','programplan','',''),(373,'priv','de','build-view','',''),(373,'priv','en','build-view','',''),(373,'priv','fr','build-view','',''),(373,'priv','zh-cn','build-view','',''),(373,'priv','zh-tw','build-view','',''),(373,'manager','de','design','',''),(373,'manager','en','design','',''),(373,'manager','fr','design','',''),(373,'manager','zh-cn','design','',''),(373,'manager','zh-tw','design','',''),(374,'priv','de','build-linkStory','',''),(374,'priv','en','build-linkStory','',''),(374,'priv','fr','build-linkStory','',''),(374,'priv','zh-cn','build-linkStory','',''),(374,'priv','zh-tw','build-linkStory','',''),(374,'manager','de','milestone','',''),(374,'manager','en','milestone','',''),(374,'manager','fr','milestone','',''),(374,'manager','zh-cn','milestone','',''),(374,'manager','zh-tw','milestone','',''),(375,'priv','de','build-unlinkStory','',''),(375,'priv','en','build-unlinkStory','',''),(375,'priv','fr','build-unlinkStory','',''),(375,'priv','zh-cn','build-unlinkStory','',''),(375,'priv','zh-tw','build-unlinkStory','',''),(375,'manager','de','issue','',''),(375,'manager','en','issue','',''),(375,'manager','fr','issue','',''),(375,'manager','zh-cn','issue','',''),(375,'manager','zh-tw','issue','',''),(376,'priv','de','build-batchUnlinkStory','',''),(376,'priv','en','build-batchUnlinkStory','',''),(376,'priv','fr','build-batchUnlinkStory','',''),(376,'priv','zh-cn','build-batchUnlinkStory','',''),(376,'priv','zh-tw','build-batchUnlinkStory','',''),(376,'manager','de','risk','',''),(376,'manager','en','risk','',''),(376,'manager','fr','risk','',''),(376,'manager','zh-cn','risk','',''),(376,'manager','zh-tw','risk','',''),(377,'priv','de','build-linkBug','',''),(377,'priv','en','build-linkBug','',''),(377,'priv','fr','build-linkBug','',''),(377,'priv','zh-cn','build-linkBug','',''),(377,'priv','zh-tw','build-linkBug','',''),(377,'manager','de','budget','',''),(377,'manager','en','budget','',''),(377,'manager','fr','budget','',''),(377,'manager','zh-cn','budget','',''),(377,'manager','zh-tw','budget','',''),(378,'priv','de','build-unlinkBug','',''),(378,'priv','en','build-unlinkBug','',''),(378,'priv','fr','build-unlinkBug','',''),(378,'priv','zh-cn','build-unlinkBug','',''),(378,'priv','zh-tw','build-unlinkBug','',''),(378,'manager','de','workestimation','',''),(378,'manager','en','workestimation','',''),(378,'manager','fr','workestimation','',''),(378,'manager','zh-cn','workestimation','',''),(378,'manager','zh-tw','workestimation','',''),(379,'priv','de','build-batchUnlinkBug','',''),(379,'priv','en','build-batchUnlinkBug','',''),(379,'priv','fr','build-batchUnlinkBug','',''),(379,'priv','zh-cn','build-batchUnlinkBug','',''),(379,'priv','zh-tw','build-batchUnlinkBug','',''),(379,'manager','de','durationestimation','',''),(379,'manager','en','durationestimation','',''),(379,'manager','fr','durationestimation','',''),(379,'manager','zh-cn','durationestimation','',''),(379,'manager','zh-tw','durationestimation','',''),(380,'priv','de','design-browse','',''),(380,'priv','en','design-browse','',''),(380,'priv','fr','design-browse','',''),(380,'priv','zh-cn','design-browse','',''),(380,'priv','zh-tw','design-browse','',''),(380,'manager','de','weekly','',''),(380,'manager','en','weekly','',''),(380,'manager','fr','weekly','',''),(380,'manager','zh-cn','weekly','',''),(380,'manager','zh-tw','weekly','',''),(381,'priv','de','design-view','',''),(381,'priv','en','design-view','',''),(381,'priv','fr','design-view','',''),(381,'priv','zh-cn','design-view','',''),(381,'priv','zh-tw','design-view','',''),(381,'manager','de','opportunity','',''),(381,'manager','en','opportunity','',''),(381,'manager','fr','opportunity','',''),(381,'manager','zh-cn','opportunity','',''),(381,'manager','zh-tw','opportunity','',''),(382,'priv','de','design-create','',''),(382,'priv','en','design-create','',''),(382,'priv','fr','design-create','',''),(382,'priv','zh-cn','design-create','',''),(382,'priv','zh-tw','design-create','',''),(382,'manager','de','trainplan','',''),(382,'manager','en','trainplan','',''),(382,'manager','fr','trainplan','',''),(382,'manager','zh-cn','trainplan','',''),(382,'manager','zh-tw','trainplan','',''),(383,'priv','de','design-batchCreate','',''),(383,'priv','en','design-batchCreate','',''),(383,'priv','fr','design-batchCreate','',''),(383,'priv','zh-cn','design-batchCreate','',''),(383,'priv','zh-tw','design-batchCreate','',''),(383,'manager','de','nc','',''),(383,'manager','en','nc','',''),(383,'manager','fr','nc','',''),(383,'manager','zh-cn','nc','',''),(383,'manager','zh-tw','nc','',''),(384,'priv','de','design-edit','',''),(384,'priv','en','design-edit','',''),(384,'priv','fr','design-edit','',''),(384,'priv','zh-cn','design-edit','',''),(384,'priv','zh-tw','design-edit','',''),(384,'manager','de','gapanalysis','',''),(384,'manager','en','gapanalysis','',''),(384,'manager','fr','gapanalysis','',''),(384,'manager','zh-cn','gapanalysis','',''),(384,'manager','zh-tw','gapanalysis','',''),(385,'priv','de','design-assignTo','',''),(385,'priv','en','design-assignTo','',''),(385,'priv','fr','design-assignTo','',''),(385,'priv','zh-cn','design-assignTo','',''),(385,'priv','zh-tw','design-assignTo','',''),(385,'manager','de','researchplan','',''),(385,'manager','en','researchplan','',''),(385,'manager','fr','researchplan','',''),(385,'manager','zh-cn','researchplan','',''),(385,'manager','zh-tw','researchplan','',''),(386,'priv','de','design-delete','',''),(386,'priv','en','design-delete','',''),(386,'priv','fr','design-delete','',''),(386,'priv','zh-cn','design-delete','',''),(386,'priv','zh-tw','design-delete','',''),(386,'manager','de','researchreport','',''),(386,'manager','en','researchreport','',''),(386,'manager','fr','researchreport','',''),(386,'manager','zh-cn','researchreport','',''),(386,'manager','zh-tw','researchreport','',''),(387,'priv','de','design-linkCommit','',''),(387,'priv','en','design-linkCommit','',''),(387,'priv','fr','design-linkCommit','',''),(387,'priv','zh-cn','design-linkCommit','',''),(387,'priv','zh-tw','design-linkCommit','',''),(387,'manager','de','meeting','',''),(387,'manager','en','meeting','',''),(387,'manager','fr','meeting','',''),(387,'manager','zh-cn','meeting','',''),(387,'manager','zh-tw','meeting','',''),(388,'priv','de','design-viewCommit','',''),(388,'priv','en','design-viewCommit','',''),(388,'priv','fr','design-viewCommit','',''),(388,'priv','zh-cn','design-viewCommit','',''),(388,'priv','zh-tw','design-viewCommit','',''),(388,'manager','de','projectbuild','',''),(388,'manager','en','projectbuild','',''),(388,'manager','fr','projectbuild','',''),(388,'manager','zh-cn','projectbuild','',''),(388,'manager','zh-tw','projectbuild','',''),(389,'priv','de','design-unlinkCommit','',''),(389,'priv','en','design-unlinkCommit','',''),(389,'priv','fr','design-unlinkCommit','',''),(389,'priv','zh-cn','design-unlinkCommit','',''),(389,'priv','zh-tw','design-unlinkCommit','',''),(389,'manager','de','projectrelease','',''),(389,'manager','en','projectrelease','',''),(389,'manager','fr','projectrelease','',''),(389,'manager','zh-cn','projectrelease','',''),(389,'manager','zh-tw','projectrelease','',''),(390,'priv','de','design-revision','',''),(390,'priv','en','design-revision','',''),(390,'priv','fr','design-revision','',''),(390,'priv','zh-cn','design-revision','',''),(390,'priv','zh-tw','design-revision','',''),(390,'manager','de','stakeholder','',''),(390,'manager','en','stakeholder','',''),(390,'manager','fr','stakeholder','',''),(390,'manager','zh-cn','stakeholder','',''),(390,'manager','zh-tw','stakeholder','',''),(391,'priv','de','design-submit','',''),(391,'priv','en','design-submit','',''),(391,'priv','fr','design-submit','',''),(391,'priv','zh-cn','design-submit','',''),(391,'priv','zh-tw','design-submit','',''),(391,'manager','de','projectsettings','',''),(391,'manager','en','projectsettings','',''),(391,'manager','fr','projectsettings','',''),(391,'manager','zh-cn','projectsettings','',''),(391,'manager','zh-tw','projectsettings','',''),(392,'priv','de','design-setType','',''),(392,'priv','en','design-setType','',''),(392,'priv','fr','design-setType','',''),(392,'priv','zh-cn','design-setType','',''),(392,'priv','zh-tw','design-setType','',''),(392,'manager','de','projectreview','',''),(392,'manager','en','projectreview','',''),(392,'manager','fr','projectreview','',''),(392,'manager','zh-cn','projectreview','',''),(392,'manager','zh-tw','projectreview','',''),(393,'priv','de','design-setPlusType','',''),(393,'priv','en','design-setPlusType','',''),(393,'priv','fr','design-setPlusType','',''),(393,'priv','zh-cn','design-setPlusType','',''),(393,'priv','zh-tw','design-setPlusType','',''),(393,'manager','de','projecttrack','',''),(393,'manager','en','projecttrack','',''),(393,'manager','fr','projecttrack','',''),(393,'manager','zh-cn','projecttrack','',''),(393,'manager','zh-tw','projecttrack','',''),(394,'priv','de','qa-indexAction','',''),(394,'priv','en','qa-indexAction','',''),(394,'priv','fr','qa-indexAction','',''),(394,'priv','zh-cn','qa-indexAction','',''),(394,'priv','zh-tw','qa-indexAction','',''),(394,'manager','de','projectqa','',''),(394,'manager','en','projectqa','',''),(394,'manager','fr','projectqa','',''),(394,'manager','zh-cn','projectqa','',''),(394,'manager','zh-tw','projectqa','',''),(395,'priv','de','bug-browse','',''),(395,'priv','en','bug-browse','',''),(395,'priv','fr','bug-browse','',''),(395,'priv','zh-cn','bug-browse','',''),(395,'priv','zh-tw','bug-browse','',''),(395,'manager','de','pssp','',''),(395,'manager','en','pssp','',''),(395,'manager','fr','pssp','',''),(395,'manager','zh-cn','pssp','',''),(395,'manager','zh-tw','pssp','',''),(396,'priv','de','bug-create','',''),(396,'priv','en','bug-create','',''),(396,'priv','fr','bug-create','',''),(396,'priv','zh-cn','bug-create','',''),(396,'priv','zh-tw','bug-create','',''),(396,'manager','de','cm','',''),(396,'manager','en','cm','',''),(396,'manager','fr','cm','',''),(396,'manager','zh-cn','cm','',''),(396,'manager','zh-tw','cm','',''),(397,'priv','de','bug-batchCreate','',''),(397,'priv','en','bug-batchCreate','',''),(397,'priv','fr','bug-batchCreate','',''),(397,'priv','zh-cn','bug-batchCreate','',''),(397,'priv','zh-tw','bug-batchCreate','',''),(397,'manager','de','auditplan','',''),(397,'manager','en','auditplan','',''),(397,'manager','fr','auditplan','',''),(397,'manager','zh-cn','auditplan','',''),(397,'manager','zh-tw','auditplan','',''),(398,'priv','de','bug-batchEdit','',''),(398,'priv','en','bug-batchEdit','',''),(398,'priv','fr','bug-batchEdit','',''),(398,'priv','zh-cn','bug-batchEdit','',''),(398,'priv','zh-tw','bug-batchEdit','',''),(398,'manager','de','reviewissue','',''),(398,'manager','en','reviewissue','',''),(398,'manager','fr','reviewissue','',''),(398,'manager','zh-cn','reviewissue','',''),(398,'manager','zh-tw','reviewissue','',''),(399,'priv','de','bug-confirmAction','',''),(399,'priv','en','bug-confirmAction','',''),(399,'priv','fr','bug-confirmAction','',''),(399,'priv','zh-cn','bug-confirmAction','',''),(399,'priv','zh-tw','bug-confirmAction','',''),(399,'manager','de','review','',''),(399,'manager','en','review','',''),(399,'manager','fr','review','',''),(399,'manager','zh-cn','review','',''),(399,'manager','zh-tw','review','',''),(400,'priv','de','bug-batchConfirm','',''),(400,'priv','en','bug-batchConfirm','',''),(400,'priv','fr','bug-batchConfirm','',''),(400,'priv','zh-cn','bug-batchConfirm','',''),(400,'priv','zh-tw','bug-batchConfirm','',''),(400,'manager','de','measrecord','',''),(400,'manager','en','measrecord','',''),(400,'manager','fr','measrecord','',''),(400,'manager','zh-cn','measrecord','',''),(400,'manager','zh-tw','measrecord','',''),(401,'priv','de','bug-view','',''),(401,'priv','en','bug-view','',''),(401,'priv','fr','bug-view','',''),(401,'priv','zh-cn','bug-view','',''),(401,'priv','zh-tw','bug-view','',''),(401,'manager','de','projectreport','',''),(401,'manager','en','projectreport','',''),(401,'manager','fr','projectreport','',''),(401,'manager','zh-cn','projectreport','',''),(401,'manager','zh-tw','projectreport','',''),(402,'priv','de','bug-edit','',''),(402,'priv','en','bug-edit','',''),(402,'priv','fr','bug-edit','',''),(402,'priv','zh-cn','bug-edit','',''),(402,'priv','zh-tw','bug-edit','',''),(402,'manager','de','projectresearch','',''),(402,'manager','en','projectresearch','',''),(402,'manager','fr','projectresearch','',''),(402,'manager','zh-cn','projectresearch','',''),(402,'manager','zh-tw','projectresearch','',''),(403,'priv','de','bug-assignAction','',''),(403,'priv','en','bug-assignAction','',''),(403,'priv','fr','bug-assignAction','',''),(403,'priv','zh-cn','bug-assignAction','',''),(403,'priv','zh-tw','bug-assignAction','',''),(403,'manager','de','projectauditplan','',''),(403,'manager','en','projectauditplan','',''),(403,'manager','fr','projectauditplan','',''),(403,'manager','zh-cn','projectauditplan','',''),(403,'manager','zh-tw','projectauditplan','',''),(404,'priv','de','bug-batchAssignTo','',''),(404,'priv','en','bug-batchAssignTo','',''),(404,'priv','fr','bug-batchAssignTo','',''),(404,'priv','zh-cn','bug-batchAssignTo','',''),(404,'priv','zh-tw','bug-batchAssignTo','',''),(404,'manager','de','projectgapanalysis','',''),(404,'manager','en','projectgapanalysis','',''),(404,'manager','fr','projectgapanalysis','',''),(404,'manager','zh-cn','projectgapanalysis','',''),(404,'manager','zh-tw','projectgapanalysis','',''),(405,'priv','de','bug-resolveAction','',''),(405,'priv','en','bug-resolveAction','',''),(405,'priv','fr','bug-resolveAction','',''),(405,'priv','zh-cn','bug-resolveAction','',''),(405,'priv','zh-tw','bug-resolveAction','',''),(405,'manager','de','execution','',''),(405,'manager','en','execution','',''),(405,'manager','fr','execution','',''),(405,'manager','zh-cn','execution','',''),(405,'manager','zh-tw','execution','',''),(406,'priv','de','bug-batchResolve','',''),(406,'priv','en','bug-batchResolve','',''),(406,'priv','fr','bug-batchResolve','',''),(406,'priv','zh-cn','bug-batchResolve','',''),(406,'priv','zh-tw','bug-batchResolve','',''),(406,'manager','de','execution','',''),(406,'manager','en','execution','',''),(406,'manager','fr','execution','',''),(406,'manager','zh-cn','execution','',''),(406,'manager','zh-tw','execution','',''),(407,'priv','de','bug-batchClose','',''),(407,'priv','en','bug-batchClose','',''),(407,'priv','fr','bug-batchClose','',''),(407,'priv','zh-cn','bug-batchClose','',''),(407,'priv','zh-tw','bug-batchClose','',''),(407,'manager','de','task','',''),(407,'manager','en','task','',''),(407,'manager','fr','task','',''),(407,'manager','zh-cn','task','',''),(407,'manager','zh-tw','task','',''),(408,'priv','de','bug-batchActivate','',''),(408,'priv','en','bug-batchActivate','',''),(408,'priv','fr','bug-batchActivate','',''),(408,'priv','zh-cn','bug-batchActivate','',''),(408,'priv','zh-tw','bug-batchActivate','',''),(408,'manager','de','build','',''),(408,'manager','en','build','',''),(408,'manager','fr','build','',''),(408,'manager','zh-cn','build','',''),(408,'manager','zh-tw','build','',''),(409,'priv','de','bug-activateAction','',''),(409,'priv','en','bug-activateAction','',''),(409,'priv','fr','bug-activateAction','',''),(409,'priv','zh-cn','bug-activateAction','',''),(409,'priv','zh-tw','bug-activateAction','',''),(409,'manager','de','executionview','',''),(409,'manager','en','executionview','',''),(409,'manager','fr','executionview','',''),(409,'manager','zh-cn','executionview','',''),(409,'manager','zh-tw','executionview','',''),(410,'priv','de','bug-closeAction','',''),(410,'priv','en','bug-closeAction','',''),(410,'priv','fr','bug-closeAction','',''),(410,'priv','zh-cn','bug-closeAction','',''),(410,'priv','zh-tw','bug-closeAction','',''),(410,'manager','de','executiongantt','',''),(410,'manager','en','executiongantt','',''),(410,'manager','fr','executiongantt','',''),(410,'manager','zh-cn','executiongantt','',''),(410,'manager','zh-tw','executiongantt','',''),(411,'priv','de','bug-reportAction','',''),(411,'priv','en','bug-reportAction','',''),(411,'priv','fr','bug-reportAction','',''),(411,'priv','zh-cn','bug-reportAction','',''),(411,'priv','zh-tw','bug-reportAction','',''),(411,'manager','de','executionkanban','',''),(411,'manager','en','executionkanban','',''),(411,'manager','fr','executionkanban','',''),(411,'manager','zh-cn','executionkanban','',''),(411,'manager','zh-tw','executionkanban','',''),(412,'priv','de','bug-exportAction','',''),(412,'priv','en','bug-exportAction','',''),(412,'priv','fr','bug-exportAction','',''),(412,'priv','zh-cn','bug-exportAction','',''),(412,'priv','zh-tw','bug-exportAction','',''),(412,'manager','de','executionburn','',''),(412,'manager','en','executionburn','',''),(412,'manager','fr','executionburn','',''),(412,'manager','zh-cn','executionburn','',''),(412,'manager','zh-tw','executionburn','',''),(413,'priv','de','bug-confirmStoryChange','',''),(413,'priv','en','bug-confirmStoryChange','',''),(413,'priv','fr','bug-confirmStoryChange','',''),(413,'priv','zh-cn','bug-confirmStoryChange','',''),(413,'priv','zh-tw','bug-confirmStoryChange','',''),(413,'manager','de','executioncfd','',''),(413,'manager','en','executioncfd','',''),(413,'manager','fr','executioncfd','',''),(413,'manager','zh-cn','executioncfd','',''),(413,'manager','zh-tw','executioncfd','',''),(414,'priv','de','bug-deleteAction','',''),(414,'priv','en','bug-deleteAction','',''),(414,'priv','fr','bug-deleteAction','',''),(414,'priv','zh-cn','bug-deleteAction','',''),(414,'priv','zh-tw','bug-deleteAction','',''),(414,'manager','de','executionstory','',''),(414,'manager','en','executionstory','',''),(414,'manager','fr','executionstory','',''),(414,'manager','zh-cn','executionstory','',''),(414,'manager','zh-tw','executionstory','',''),(415,'priv','de','bug-linkBugs','',''),(415,'priv','en','bug-linkBugs','',''),(415,'priv','fr','bug-linkBugs','',''),(415,'priv','zh-cn','bug-linkBugs','',''),(415,'priv','zh-tw','bug-linkBugs','',''),(415,'manager','de','executionqa','',''),(415,'manager','en','executionqa','',''),(415,'manager','fr','executionqa','',''),(415,'manager','zh-cn','executionqa','',''),(415,'manager','zh-tw','executionqa','',''),(416,'priv','de','bug-batchChangeModule','',''),(416,'priv','en','bug-batchChangeModule','',''),(416,'priv','fr','bug-batchChangeModule','',''),(416,'priv','zh-cn','bug-batchChangeModule','',''),(416,'priv','zh-tw','bug-batchChangeModule','',''),(416,'manager','de','executionsettings','',''),(416,'manager','en','executionsettings','',''),(416,'manager','fr','executionsettings','',''),(416,'manager','zh-cn','executionsettings','',''),(416,'manager','zh-tw','executionsettings','',''),(417,'priv','de','bug-batchChangeBranch','',''),(417,'priv','en','bug-batchChangeBranch','',''),(417,'priv','fr','bug-batchChangeBranch','',''),(417,'priv','zh-cn','bug-batchChangeBranch','',''),(417,'priv','zh-tw','bug-batchChangeBranch','',''),(417,'manager','de','kanban','',''),(417,'manager','en','kanban','',''),(417,'manager','fr','kanban','',''),(417,'manager','zh-cn','kanban','',''),(417,'manager','zh-tw','kanban','',''),(418,'priv','de','bug-batchChangePlan','',''),(418,'priv','en','bug-batchChangePlan','',''),(418,'priv','fr','bug-batchChangePlan','',''),(418,'priv','zh-cn','bug-batchChangePlan','',''),(418,'priv','zh-tw','bug-batchChangePlan','',''),(418,'manager','de','kanban','',''),(418,'manager','en','kanban','',''),(418,'manager','fr','kanban','',''),(418,'manager','zh-cn','kanban','',''),(418,'manager','zh-tw','kanban','',''),(419,'priv','de','bug-importCase','',''),(419,'priv','en','bug-importCase','',''),(419,'priv','fr','bug-importCase','',''),(419,'priv','zh-cn','bug-importCase','',''),(419,'priv','zh-tw','bug-importCase','',''),(419,'manager','de','managespace','',''),(419,'manager','en','managespace','',''),(419,'manager','fr','managespace','',''),(419,'manager','zh-cn','managespace','',''),(419,'manager','zh-tw','managespace','',''),(420,'priv','de','bug-exportTemplate','',''),(420,'priv','en','bug-exportTemplate','',''),(420,'priv','fr','bug-exportTemplate','',''),(420,'priv','zh-cn','bug-exportTemplate','',''),(420,'priv','zh-tw','bug-exportTemplate','',''),(420,'manager','de','qa','',''),(420,'manager','en','qa','',''),(420,'manager','fr','qa','',''),(420,'manager','zh-cn','qa','',''),(420,'manager','zh-tw','qa','',''),(421,'priv','de','testcase-browse','',''),(421,'priv','en','testcase-browse','',''),(421,'priv','fr','testcase-browse','',''),(421,'priv','zh-cn','testcase-browse','',''),(421,'priv','zh-tw','testcase-browse','',''),(421,'manager','de','qa','',''),(421,'manager','en','qa','',''),(421,'manager','fr','qa','',''),(421,'manager','zh-cn','qa','',''),(421,'manager','zh-tw','qa','',''),(422,'priv','de','testcase-groupCase','',''),(422,'priv','en','testcase-groupCase','',''),(422,'priv','fr','testcase-groupCase','',''),(422,'priv','zh-cn','testcase-groupCase','',''),(422,'priv','zh-tw','testcase-groupCase','',''),(422,'manager','de','bug','',''),(422,'manager','en','bug','',''),(422,'manager','fr','bug','',''),(422,'manager','zh-cn','bug','',''),(422,'manager','zh-tw','bug','',''),(423,'priv','de','testcase-zeroCase','',''),(423,'priv','en','testcase-zeroCase','',''),(423,'priv','fr','testcase-zeroCase','',''),(423,'priv','zh-cn','testcase-zeroCase','',''),(423,'priv','zh-tw','testcase-zeroCase','',''),(423,'manager','de','testcase','',''),(423,'manager','en','testcase','',''),(423,'manager','fr','testcase','',''),(423,'manager','zh-cn','testcase','',''),(423,'manager','zh-tw','testcase','',''),(424,'priv','de','testcase-create','',''),(424,'priv','en','testcase-create','',''),(424,'priv','fr','testcase-create','',''),(424,'priv','zh-cn','testcase-create','',''),(424,'priv','zh-tw','testcase-create','',''),(424,'manager','de','testtask','',''),(424,'manager','en','testtask','',''),(424,'manager','fr','testtask','',''),(424,'manager','zh-cn','testtask','',''),(424,'manager','zh-tw','testtask','',''),(425,'priv','de','testcase-batchCreate','',''),(425,'priv','en','testcase-batchCreate','',''),(425,'priv','fr','testcase-batchCreate','',''),(425,'priv','zh-cn','testcase-batchCreate','',''),(425,'priv','zh-tw','testcase-batchCreate','',''),(425,'manager','de','testsuite','',''),(425,'manager','en','testsuite','',''),(425,'manager','fr','testsuite','',''),(425,'manager','zh-cn','testsuite','',''),(425,'manager','zh-tw','testsuite','',''),(426,'priv','de','testcase-createBug','',''),(426,'priv','en','testcase-createBug','',''),(426,'priv','fr','testcase-createBug','',''),(426,'priv','zh-cn','testcase-createBug','',''),(426,'priv','zh-tw','testcase-createBug','',''),(426,'manager','de','testreport','',''),(426,'manager','en','testreport','',''),(426,'manager','fr','testreport','',''),(426,'manager','zh-cn','testreport','',''),(426,'manager','zh-tw','testreport','',''),(427,'priv','de','testcase-view','',''),(427,'priv','en','testcase-view','',''),(427,'priv','fr','testcase-view','',''),(427,'priv','zh-cn','testcase-view','',''),(427,'priv','zh-tw','testcase-view','',''),(427,'manager','de','zahost','',''),(427,'manager','en','zahost','',''),(427,'manager','fr','zahost','',''),(427,'manager','zh-cn','zahost','',''),(427,'manager','zh-tw','zahost','',''),(428,'priv','de','testcase-edit','',''),(428,'priv','en','testcase-edit','',''),(428,'priv','fr','testcase-edit','',''),(428,'priv','zh-cn','testcase-edit','',''),(428,'priv','zh-tw','testcase-edit','',''),(428,'manager','de','zanode','',''),(428,'manager','en','zanode','',''),(428,'manager','fr','zanode','',''),(428,'manager','zh-cn','zanode','',''),(428,'manager','zh-tw','zanode','',''),(429,'priv','de','testcase-deleteAction','',''),(429,'priv','en','testcase-deleteAction','',''),(429,'priv','fr','testcase-deleteAction','',''),(429,'priv','zh-cn','testcase-deleteAction','',''),(429,'priv','zh-tw','testcase-deleteAction','',''),(429,'manager','de','assetlib','',''),(429,'manager','en','assetlib','',''),(429,'manager','fr','assetlib','',''),(429,'manager','zh-cn','assetlib','',''),(429,'manager','zh-tw','assetlib','',''),(430,'priv','de','testcase-exportAction','',''),(430,'priv','en','testcase-exportAction','',''),(430,'priv','fr','testcase-exportAction','',''),(430,'priv','zh-cn','testcase-exportAction','',''),(430,'priv','zh-tw','testcase-exportAction','',''),(430,'manager','de','caselib','',''),(430,'manager','en','caselib','',''),(430,'manager','fr','caselib','',''),(430,'manager','zh-cn','caselib','',''),(430,'manager','zh-tw','caselib','',''),(431,'priv','de','testcase-confirmChange','',''),(431,'priv','en','testcase-confirmChange','',''),(431,'priv','fr','testcase-confirmChange','',''),(431,'priv','zh-cn','testcase-confirmChange','',''),(431,'priv','zh-tw','testcase-confirmChange','',''),(431,'manager','de','assetlib','',''),(431,'manager','en','assetlib','',''),(431,'manager','fr','assetlib','',''),(431,'manager','zh-cn','assetlib','',''),(431,'manager','zh-tw','assetlib','',''),(432,'priv','de','testcase-confirmStoryChange','',''),(432,'priv','en','testcase-confirmStoryChange','',''),(432,'priv','fr','testcase-confirmStoryChange','',''),(432,'priv','zh-cn','testcase-confirmStoryChange','',''),(432,'priv','zh-tw','testcase-confirmStoryChange','',''),(432,'manager','de','storylib','',''),(432,'manager','en','storylib','',''),(432,'manager','fr','storylib','',''),(432,'manager','zh-cn','storylib','',''),(432,'manager','zh-tw','storylib','',''),(433,'priv','de','testcase-batchEdit','',''),(433,'priv','en','testcase-batchEdit','',''),(433,'priv','fr','testcase-batchEdit','',''),(433,'priv','zh-cn','testcase-batchEdit','',''),(433,'priv','zh-tw','testcase-batchEdit','',''),(433,'manager','de','issuelib','',''),(433,'manager','en','issuelib','',''),(433,'manager','fr','issuelib','',''),(433,'manager','zh-cn','issuelib','',''),(433,'manager','zh-tw','issuelib','',''),(434,'priv','de','testcase-batchDelete','',''),(434,'priv','en','testcase-batchDelete','',''),(434,'priv','fr','testcase-batchDelete','',''),(434,'priv','zh-cn','testcase-batchDelete','',''),(434,'priv','zh-tw','testcase-batchDelete','',''),(434,'manager','de','risklib','',''),(434,'manager','en','risklib','',''),(434,'manager','fr','risklib','',''),(434,'manager','zh-cn','risklib','',''),(434,'manager','zh-tw','risklib','',''),(435,'priv','de','testcase-batchChangeModule','',''),(435,'priv','en','testcase-batchChangeModule','',''),(435,'priv','fr','testcase-batchChangeModule','',''),(435,'priv','zh-cn','testcase-batchChangeModule','',''),(435,'priv','zh-tw','testcase-batchChangeModule','',''),(435,'manager','de','opportunitylib','',''),(435,'manager','en','opportunitylib','',''),(435,'manager','fr','opportunitylib','',''),(435,'manager','zh-cn','opportunitylib','',''),(435,'manager','zh-tw','opportunitylib','',''),(436,'priv','de','testcase-batchChangeBranch','',''),(436,'priv','en','testcase-batchChangeBranch','',''),(436,'priv','fr','testcase-batchChangeBranch','',''),(436,'priv','zh-cn','testcase-batchChangeBranch','',''),(436,'priv','zh-tw','testcase-batchChangeBranch','',''),(436,'manager','de','practicelib','',''),(436,'manager','en','practicelib','',''),(436,'manager','fr','practicelib','',''),(436,'manager','zh-cn','practicelib','',''),(436,'manager','zh-tw','practicelib','',''),(437,'priv','de','testcase-linkCases','',''),(437,'priv','en','testcase-linkCases','',''),(437,'priv','fr','testcase-linkCases','',''),(437,'priv','zh-cn','testcase-linkCases','',''),(437,'priv','zh-tw','testcase-linkCases','',''),(437,'manager','de','componentlib','',''),(437,'manager','en','componentlib','',''),(437,'manager','fr','componentlib','',''),(437,'manager','zh-cn','componentlib','',''),(437,'manager','zh-tw','componentlib','',''),(438,'priv','de','testcase-linkBugs','',''),(438,'priv','en','testcase-linkBugs','',''),(438,'priv','fr','testcase-linkBugs','',''),(438,'priv','zh-cn','testcase-linkBugs','',''),(438,'priv','zh-tw','testcase-linkBugs','',''),(438,'manager','de','doc','',''),(438,'manager','en','doc','',''),(438,'manager','fr','doc','',''),(438,'manager','zh-cn','doc','',''),(438,'manager','zh-tw','doc','',''),(439,'priv','de','testcase-bugs','',''),(439,'priv','en','testcase-bugs','',''),(439,'priv','fr','testcase-bugs','',''),(439,'priv','zh-cn','testcase-bugs','',''),(439,'priv','zh-tw','testcase-bugs','',''),(439,'manager','de','doc','',''),(439,'manager','en','doc','',''),(439,'manager','fr','doc','',''),(439,'manager','zh-cn','doc','',''),(439,'manager','zh-tw','doc','',''),(440,'priv','de','testcase-review','',''),(440,'priv','en','testcase-review','',''),(440,'priv','fr','testcase-review','',''),(440,'priv','zh-cn','testcase-review','',''),(440,'priv','zh-tw','testcase-review','',''),(440,'manager','de','api','',''),(440,'manager','en','api','',''),(440,'manager','fr','api','',''),(440,'manager','zh-cn','api','',''),(440,'manager','zh-tw','api','',''),(441,'priv','de','testcase-batchReview','',''),(441,'priv','en','testcase-batchReview','',''),(441,'priv','fr','testcase-batchReview','',''),(441,'priv','zh-cn','testcase-batchReview','',''),(441,'priv','zh-tw','testcase-batchReview','',''),(441,'manager','de','bi','',''),(441,'manager','en','bi','',''),(441,'manager','fr','bi','',''),(441,'manager','zh-cn','bi','',''),(441,'manager','zh-tw','bi','',''),(442,'priv','de','testcase-batchConfirmStoryChange','',''),(442,'priv','en','testcase-batchConfirmStoryChange','',''),(442,'priv','fr','testcase-batchConfirmStoryChange','',''),(442,'priv','zh-cn','testcase-batchConfirmStoryChange','',''),(442,'priv','zh-tw','testcase-batchConfirmStoryChange','',''),(442,'manager','de','screen','',''),(442,'manager','en','screen','',''),(442,'manager','fr','screen','',''),(442,'manager','zh-cn','screen','',''),(442,'manager','zh-tw','screen','',''),(443,'priv','de','testcase-importFromLib','',''),(443,'priv','en','testcase-importFromLib','',''),(443,'priv','fr','testcase-importFromLib','',''),(443,'priv','zh-cn','testcase-importFromLib','',''),(443,'priv','zh-tw','testcase-importFromLib','',''),(443,'manager','de','pivot','',''),(443,'manager','en','pivot','',''),(443,'manager','fr','pivot','',''),(443,'manager','zh-cn','pivot','',''),(443,'manager','zh-tw','pivot','',''),(444,'priv','de','testcase-batchCaseTypeChange','',''),(444,'priv','en','testcase-batchCaseTypeChange','',''),(444,'priv','fr','testcase-batchCaseTypeChange','',''),(444,'priv','zh-cn','testcase-batchCaseTypeChange','',''),(444,'priv','zh-tw','testcase-batchCaseTypeChange','',''),(444,'manager','de','chart','',''),(444,'manager','en','chart','',''),(444,'manager','fr','chart','',''),(444,'manager','zh-cn','chart','',''),(444,'manager','zh-tw','chart','',''),(445,'priv','de','testcase-confirmLibcaseChange','',''),(445,'priv','en','testcase-confirmLibcaseChange','',''),(445,'priv','fr','testcase-confirmLibcaseChange','',''),(445,'priv','zh-cn','testcase-confirmLibcaseChange','',''),(445,'priv','zh-tw','testcase-confirmLibcaseChange','',''),(445,'manager','de','dataview','',''),(445,'manager','en','dataview','',''),(445,'manager','fr','dataview','',''),(445,'manager','zh-cn','dataview','',''),(445,'manager','zh-tw','dataview','',''),(446,'priv','de','testcase-ignoreLibcaseChange','',''),(446,'priv','en','testcase-ignoreLibcaseChange','',''),(446,'priv','fr','testcase-ignoreLibcaseChange','',''),(446,'priv','zh-cn','testcase-ignoreLibcaseChange','',''),(446,'priv','zh-tw','testcase-ignoreLibcaseChange','',''),(446,'manager','de','dimension','',''),(446,'manager','en','dimension','',''),(446,'manager','fr','dimension','',''),(446,'manager','zh-cn','dimension','',''),(446,'manager','zh-tw','dimension','',''),(447,'priv','de','testcase-importToLib','',''),(447,'priv','en','testcase-importToLib','',''),(447,'priv','fr','testcase-importToLib','',''),(447,'priv','zh-cn','testcase-importToLib','',''),(447,'priv','zh-tw','testcase-importToLib','',''),(447,'manager','de','report','',''),(447,'manager','en','report','',''),(447,'manager','fr','report','',''),(447,'manager','zh-cn','report','',''),(447,'manager','zh-tw','report','',''),(448,'priv','de','testcase-automation','',''),(448,'priv','en','testcase-automation','',''),(448,'priv','fr','testcase-automation','',''),(448,'priv','zh-cn','testcase-automation','',''),(448,'priv','zh-tw','testcase-automation','',''),(448,'manager','de','bidesign','',''),(448,'manager','en','bidesign','',''),(448,'manager','fr','bidesign','',''),(448,'manager','zh-cn','bidesign','',''),(448,'manager','zh-tw','bidesign','',''),(449,'priv','de','testcase-showScript','',''),(449,'priv','en','testcase-showScript','',''),(449,'priv','fr','testcase-showScript','',''),(449,'priv','zh-cn','testcase-showScript','',''),(449,'priv','zh-tw','testcase-showScript','',''),(449,'manager','de','system','',''),(449,'manager','en','system','',''),(449,'manager','fr','system','',''),(449,'manager','zh-cn','system','',''),(449,'manager','zh-tw','system','',''),(450,'priv','de','testcase-exportTemplate','',''),(450,'priv','en','testcase-exportTemplate','',''),(450,'priv','fr','testcase-exportTemplate','',''),(450,'priv','zh-cn','testcase-exportTemplate','',''),(450,'priv','zh-tw','testcase-exportTemplate','',''),(450,'manager','de','company','',''),(450,'manager','en','company','',''),(450,'manager','fr','company','',''),(450,'manager','zh-cn','company','',''),(450,'manager','zh-tw','company','',''),(451,'priv','de','testcase-importCaseAction','',''),(451,'priv','en','testcase-importCaseAction','',''),(451,'priv','fr','testcase-importCaseAction','',''),(451,'priv','zh-cn','testcase-importCaseAction','',''),(451,'priv','zh-tw','testcase-importCaseAction','',''),(451,'manager','de','systemteam','',''),(451,'manager','en','systemteam','',''),(451,'manager','fr','systemteam','',''),(451,'manager','zh-cn','systemteam','',''),(451,'manager','zh-tw','systemteam','',''),(452,'manager','de','systemschedule','',''),(452,'manager','en','systemschedule','',''),(452,'manager','fr','systemschedule','',''),(452,'manager','zh-cn','systemschedule','',''),(452,'manager','zh-tw','systemschedule','',''),(453,'priv','de','testcase-submit','',''),(453,'priv','en','testcase-submit','',''),(453,'priv','fr','testcase-submit','',''),(453,'priv','zh-cn','testcase-submit','',''),(453,'priv','zh-tw','testcase-submit','',''),(453,'manager','de','systemeffort','',''),(453,'manager','en','systemeffort','',''),(453,'manager','fr','systemeffort','',''),(453,'manager','zh-cn','systemeffort','',''),(453,'manager','zh-tw','systemeffort','',''),(454,'priv','de','testtask-create','',''),(454,'priv','en','testtask-create','',''),(454,'priv','fr','testtask-create','',''),(454,'priv','zh-cn','testtask-create','',''),(454,'priv','zh-tw','testtask-create','',''),(454,'manager','de','systemdynamic','',''),(454,'manager','en','systemdynamic','',''),(454,'manager','fr','systemdynamic','',''),(454,'manager','zh-cn','systemdynamic','',''),(454,'manager','zh-tw','systemdynamic','',''),(455,'priv','de','testtask-browse','',''),(455,'priv','en','testtask-browse','',''),(455,'priv','fr','testtask-browse','',''),(455,'priv','zh-cn','testtask-browse','',''),(455,'priv','zh-tw','testtask-browse','',''),(455,'manager','de','systemcompany','',''),(455,'manager','en','systemcompany','',''),(455,'manager','fr','systemcompany','',''),(455,'manager','zh-cn','systemcompany','',''),(455,'manager','zh-tw','systemcompany','',''),(456,'priv','de','testtask-viewAction','',''),(456,'priv','en','testtask-viewAction','',''),(456,'priv','fr','testtask-viewAction','',''),(456,'priv','zh-cn','testtask-viewAction','',''),(456,'priv','zh-tw','testtask-viewAction','',''),(456,'manager','de','dataaccess','',''),(456,'manager','en','dataaccess','',''),(456,'manager','fr','dataaccess','',''),(456,'manager','zh-cn','dataaccess','',''),(456,'manager','zh-tw','dataaccess','',''),(457,'priv','de','testtask-casesAction','',''),(457,'priv','en','testtask-casesAction','',''),(457,'priv','fr','testtask-casesAction','',''),(457,'priv','zh-cn','testtask-casesAction','',''),(457,'priv','zh-tw','testtask-casesAction','',''),(457,'manager','de','admin','',''),(457,'manager','en','admin','',''),(457,'manager','fr','admin','',''),(457,'manager','zh-cn','admin','',''),(457,'manager','zh-tw','admin','',''),(458,'priv','de','testtask-groupCase','',''),(458,'priv','en','testtask-groupCase','',''),(458,'priv','fr','testtask-groupCase','',''),(458,'priv','zh-cn','testtask-groupCase','',''),(458,'priv','zh-tw','testtask-groupCase','',''),(458,'manager','de','dept','',''),(458,'manager','en','dept','',''),(458,'manager','fr','dept','',''),(458,'manager','zh-cn','dept','',''),(458,'manager','zh-tw','dept','',''),(459,'priv','de','testtask-edit','',''),(459,'priv','en','testtask-edit','',''),(459,'priv','fr','testtask-edit','',''),(459,'priv','zh-cn','testtask-edit','',''),(459,'priv','zh-tw','testtask-edit','',''),(459,'manager','de','group','',''),(459,'manager','en','group','',''),(459,'manager','fr','group','',''),(459,'manager','zh-cn','group','',''),(459,'manager','zh-tw','group','',''),(460,'priv','de','testtask-startAction','',''),(460,'priv','en','testtask-startAction','',''),(460,'priv','fr','testtask-startAction','',''),(460,'priv','zh-cn','testtask-startAction','',''),(460,'priv','zh-tw','testtask-startAction','',''),(460,'manager','de','user','',''),(460,'manager','en','user','',''),(460,'manager','fr','user','',''),(460,'manager','zh-cn','user','',''),(460,'manager','zh-tw','user','',''),(461,'priv','de','testtask-activateAction','',''),(461,'priv','en','testtask-activateAction','',''),(461,'priv','fr','testtask-activateAction','',''),(461,'priv','zh-cn','testtask-activateAction','',''),(461,'priv','zh-tw','testtask-activateAction','',''),(461,'manager','de','admin','',''),(461,'manager','en','admin','',''),(461,'manager','fr','admin','',''),(461,'manager','zh-cn','admin','',''),(461,'manager','zh-tw','admin','',''),(462,'priv','de','testtask-blockAction','',''),(462,'priv','en','testtask-blockAction','',''),(462,'priv','fr','testtask-blockAction','',''),(462,'priv','zh-cn','testtask-blockAction','',''),(462,'priv','zh-tw','testtask-blockAction','',''),(462,'manager','de','stage','',''),(462,'manager','en','stage','',''),(462,'manager','fr','stage','',''),(462,'manager','zh-cn','stage','',''),(462,'manager','zh-tw','stage','',''),(463,'priv','de','testtask-closeAction','',''),(463,'priv','en','testtask-closeAction','',''),(463,'priv','fr','testtask-closeAction','',''),(463,'priv','zh-cn','testtask-closeAction','',''),(463,'priv','zh-tw','testtask-closeAction','',''),(463,'manager','de','extension','',''),(463,'manager','en','extension','',''),(463,'manager','fr','extension','',''),(463,'manager','zh-cn','extension','',''),(463,'manager','zh-tw','extension','',''),(464,'priv','de','testtask-delete','',''),(464,'priv','en','testtask-delete','',''),(464,'priv','fr','testtask-delete','',''),(464,'priv','zh-cn','testtask-delete','',''),(464,'priv','zh-tw','testtask-delete','',''),(464,'manager','de','custom','',''),(464,'manager','en','custom','',''),(464,'manager','fr','custom','',''),(464,'manager','zh-cn','custom','',''),(464,'manager','zh-tw','custom','',''),(465,'priv','de','testtask-batchAssign','',''),(465,'priv','en','testtask-batchAssign','',''),(465,'priv','fr','testtask-batchAssign','',''),(465,'priv','zh-cn','testtask-batchAssign','',''),(465,'priv','zh-tw','testtask-batchAssign','',''),(465,'manager','de','action','',''),(465,'manager','en','action','',''),(465,'manager','fr','action','',''),(465,'manager','zh-cn','action','',''),(465,'manager','zh-tw','action','',''),(466,'priv','de','testtask-linkCase','',''),(466,'priv','en','testtask-linkCase','',''),(466,'priv','fr','testtask-linkCase','',''),(466,'priv','zh-cn','testtask-linkCase','',''),(466,'priv','zh-tw','testtask-linkCase','',''),(466,'manager','de','mail','',''),(466,'manager','en','mail','',''),(466,'manager','fr','mail','',''),(466,'manager','zh-cn','mail','',''),(466,'manager','zh-tw','mail','',''),(467,'priv','de','testtask-lblUnlinkCase','',''),(467,'priv','en','testtask-lblUnlinkCase','',''),(467,'priv','fr','testtask-lblUnlinkCase','',''),(467,'priv','zh-cn','testtask-lblUnlinkCase','',''),(467,'priv','zh-tw','testtask-lblUnlinkCase','',''),(467,'manager','de','sms','',''),(467,'manager','en','sms','',''),(467,'manager','fr','sms','',''),(467,'manager','zh-cn','sms','',''),(467,'manager','zh-tw','sms','',''),(468,'priv','de','testtask-lblRunCase','',''),(468,'priv','en','testtask-lblRunCase','',''),(468,'priv','fr','testtask-lblRunCase','',''),(468,'priv','zh-cn','testtask-lblRunCase','',''),(468,'priv','zh-tw','testtask-lblRunCase','',''),(468,'manager','de','backup','',''),(468,'manager','en','backup','',''),(468,'manager','fr','backup','',''),(468,'manager','zh-cn','backup','',''),(468,'manager','zh-tw','backup','',''),(469,'priv','de','testtask-resultsAction','',''),(469,'priv','en','testtask-resultsAction','',''),(469,'priv','fr','testtask-resultsAction','',''),(469,'priv','zh-cn','testtask-resultsAction','',''),(469,'priv','zh-tw','testtask-resultsAction','',''),(469,'manager','de','cron','',''),(469,'manager','en','cron','',''),(469,'manager','fr','cron','',''),(469,'manager','zh-cn','cron','',''),(469,'manager','zh-tw','cron','',''),(470,'priv','de','testtask-batchUnlinkCases','',''),(470,'priv','en','testtask-batchUnlinkCases','',''),(470,'priv','fr','testtask-batchUnlinkCases','',''),(470,'priv','zh-cn','testtask-batchUnlinkCases','',''),(470,'priv','zh-tw','testtask-batchUnlinkCases','',''),(470,'manager','de','dev','',''),(470,'manager','en','dev','',''),(470,'manager','fr','dev','',''),(470,'manager','zh-cn','dev','',''),(470,'manager','zh-tw','dev','',''),(471,'priv','de','testtask-reportAction','',''),(471,'priv','en','testtask-reportAction','',''),(471,'priv','fr','testtask-reportAction','',''),(471,'priv','zh-cn','testtask-reportAction','',''),(471,'priv','zh-tw','testtask-reportAction','',''),(471,'manager','de','editor','',''),(471,'manager','en','editor','',''),(471,'manager','fr','editor','',''),(471,'manager','zh-cn','editor','',''),(471,'manager','zh-tw','editor','',''),(472,'priv','de','testtask-browseUnits','',''),(472,'priv','en','testtask-browseUnits','',''),(472,'priv','fr','testtask-browseUnits','',''),(472,'priv','zh-cn','testtask-browseUnits','',''),(472,'priv','zh-tw','testtask-browseUnits','',''),(472,'manager','de','holiday','',''),(472,'manager','en','holiday','',''),(472,'manager','fr','holiday','',''),(472,'manager','zh-cn','holiday','',''),(472,'manager','zh-tw','holiday','',''),(473,'priv','de','testtask-unitCases','',''),(473,'priv','en','testtask-unitCases','',''),(473,'priv','fr','testtask-unitCases','',''),(473,'priv','zh-cn','testtask-unitCases','',''),(473,'priv','zh-tw','testtask-unitCases','',''),(473,'manager','de','meetingroom','',''),(473,'manager','en','meetingroom','',''),(473,'manager','fr','meetingroom','',''),(473,'manager','zh-cn','meetingroom','',''),(473,'manager','zh-tw','meetingroom','',''),(474,'priv','de','testtask-importUnitResult','',''),(474,'priv','en','testtask-importUnitResult','',''),(474,'priv','fr','testtask-importUnitResult','',''),(474,'priv','zh-cn','testtask-importUnitResult','',''),(474,'priv','zh-tw','testtask-importUnitResult','',''),(474,'manager','de','webhook','',''),(474,'manager','en','webhook','',''),(474,'manager','fr','webhook','',''),(474,'manager','zh-cn','webhook','',''),(474,'manager','zh-tw','webhook','',''),(475,'priv','de','testtask-batchRun','',''),(475,'priv','en','testtask-batchRun','',''),(475,'priv','fr','testtask-batchRun','',''),(475,'priv','zh-cn','testtask-batchRun','',''),(475,'priv','zh-tw','testtask-batchRun','',''),(475,'manager','de','message','',''),(475,'manager','en','message','',''),(475,'manager','fr','message','',''),(475,'manager','zh-cn','message','',''),(475,'manager','zh-tw','message','',''),(476,'priv','de','testtask-runDeployCase','',''),(476,'priv','en','testtask-runDeployCase','',''),(476,'priv','fr','testtask-runDeployCase','',''),(476,'priv','zh-cn','testtask-runDeployCase','',''),(476,'priv','zh-tw','testtask-runDeployCase','',''),(476,'manager','de','featureswitch','',''),(476,'manager','en','featureswitch','',''),(476,'manager','fr','featureswitch','',''),(476,'manager','zh-cn','featureswitch','',''),(476,'manager','zh-tw','featureswitch','',''),(477,'priv','de','testtask-deployCaseResults','',''),(477,'priv','en','testtask-deployCaseResults','',''),(477,'priv','fr','testtask-deployCaseResults','',''),(477,'priv','zh-cn','testtask-deployCaseResults','',''),(477,'priv','zh-tw','testtask-deployCaseResults','',''),(477,'manager','de','importdata','',''),(477,'manager','en','importdata','',''),(477,'manager','fr','importdata','',''),(477,'manager','zh-cn','importdata','',''),(477,'manager','zh-tw','importdata','',''),(478,'manager','de','systemsetting','',''),(478,'manager','en','systemsetting','',''),(478,'manager','fr','systemsetting','',''),(478,'manager','zh-cn','systemsetting','',''),(478,'manager','zh-tw','systemsetting','',''),(479,'priv','de','testsuite-browse','',''),(479,'priv','en','testsuite-browse','',''),(479,'priv','fr','testsuite-browse','',''),(479,'priv','zh-cn','testsuite-browse','',''),(479,'priv','zh-tw','testsuite-browse','',''),(479,'manager','de','staffmanage','',''),(479,'manager','en','staffmanage','',''),(479,'manager','fr','staffmanage','',''),(479,'manager','zh-cn','staffmanage','',''),(479,'manager','zh-tw','staffmanage','',''),(480,'priv','de','testsuite-create','',''),(480,'priv','en','testsuite-create','',''),(480,'priv','fr','testsuite-create','',''),(480,'priv','zh-cn','testsuite-create','',''),(480,'priv','zh-tw','testsuite-create','',''),(480,'manager','de','modelconfig','',''),(480,'manager','en','modelconfig','',''),(480,'manager','fr','modelconfig','',''),(480,'manager','zh-cn','modelconfig','',''),(480,'manager','zh-tw','modelconfig','',''),(481,'priv','de','testsuite-view','',''),(481,'priv','en','testsuite-view','',''),(481,'priv','fr','testsuite-view','',''),(481,'priv','zh-cn','testsuite-view','',''),(481,'priv','zh-tw','testsuite-view','',''),(481,'manager','de','featureconfig','',''),(481,'manager','en','featureconfig','',''),(481,'manager','fr','featureconfig','',''),(481,'manager','zh-cn','featureconfig','',''),(481,'manager','zh-tw','featureconfig','',''),(482,'priv','de','testsuite-edit','',''),(482,'priv','en','testsuite-edit','',''),(482,'priv','fr','testsuite-edit','',''),(482,'priv','zh-cn','testsuite-edit','',''),(482,'priv','zh-tw','testsuite-edit','',''),(482,'manager','de','doctemplate','',''),(482,'manager','en','doctemplate','',''),(482,'manager','fr','doctemplate','',''),(482,'manager','zh-cn','doctemplate','',''),(482,'manager','zh-tw','doctemplate','',''),(483,'priv','de','testsuite-delete','',''),(483,'priv','en','testsuite-delete','',''),(483,'priv','fr','testsuite-delete','',''),(483,'priv','zh-cn','testsuite-delete','',''),(483,'priv','zh-tw','testsuite-delete','',''),(483,'manager','de','notifysetting','',''),(483,'manager','en','notifysetting','',''),(483,'manager','fr','notifysetting','',''),(483,'manager','zh-cn','notifysetting','',''),(483,'manager','zh-tw','notifysetting','',''),(484,'priv','de','testsuite-linkCase','',''),(484,'priv','en','testsuite-linkCase','',''),(484,'priv','fr','testsuite-linkCase','',''),(484,'priv','zh-cn','testsuite-linkCase','',''),(484,'priv','zh-tw','testsuite-linkCase','',''),(484,'manager','de','ldap','',''),(484,'manager','en','ldap','',''),(484,'manager','fr','ldap','',''),(484,'manager','zh-cn','ldap','',''),(484,'manager','zh-tw','ldap','',''),(485,'priv','de','testsuite-unlinkCaseAction','',''),(485,'priv','en','testsuite-unlinkCaseAction','',''),(485,'priv','fr','testsuite-unlinkCaseAction','',''),(485,'priv','zh-cn','testsuite-unlinkCaseAction','',''),(485,'priv','zh-tw','testsuite-unlinkCaseAction','',''),(485,'manager','de','sqlbuilder','',''),(485,'manager','en','sqlbuilder','',''),(485,'manager','fr','sqlbuilder','',''),(485,'manager','zh-cn','sqlbuilder','',''),(485,'manager','zh-tw','sqlbuilder','',''),(486,'priv','de','testsuite-batchUnlinkCases','',''),(486,'priv','en','testsuite-batchUnlinkCases','',''),(486,'priv','fr','testsuite-batchUnlinkCases','',''),(486,'priv','zh-cn','testsuite-batchUnlinkCases','',''),(486,'priv','zh-tw','testsuite-batchUnlinkCases','',''),(486,'manager','de','holidayseason','',''),(486,'manager','en','holidayseason','',''),(486,'manager','fr','holidayseason','',''),(486,'manager','zh-cn','holidayseason','',''),(486,'manager','zh-tw','holidayseason','',''),(487,'priv','de','testreport-browse','',''),(487,'priv','en','testreport-browse','',''),(487,'priv','fr','testreport-browse','',''),(487,'priv','zh-cn','testreport-browse','',''),(487,'priv','zh-tw','testreport-browse','',''),(487,'manager','de','baseline','',''),(487,'manager','en','baseline','',''),(487,'manager','fr','baseline','',''),(487,'manager','zh-cn','baseline','',''),(487,'manager','zh-tw','baseline','',''),(488,'priv','de','testreport-create','',''),(488,'priv','en','testreport-create','',''),(488,'priv','fr','testreport-create','',''),(488,'priv','zh-cn','testreport-create','',''),(488,'priv','zh-tw','testreport-create','',''),(488,'manager','de','classify','',''),(488,'manager','en','classify','',''),(488,'manager','fr','classify','',''),(488,'manager','zh-cn','classify','',''),(488,'manager','zh-tw','classify','',''),(489,'priv','de','testreport-view','',''),(489,'priv','en','testreport-view','',''),(489,'priv','fr','testreport-view','',''),(489,'priv','zh-cn','testreport-view','',''),(489,'priv','zh-tw','testreport-view','',''),(489,'manager','de','cmcl','',''),(489,'manager','en','cmcl','',''),(489,'manager','fr','cmcl','',''),(489,'manager','zh-cn','cmcl','',''),(489,'manager','zh-tw','cmcl','',''),(490,'priv','de','testreport-delete','',''),(490,'priv','en','testreport-delete','',''),(490,'priv','fr','testreport-delete','',''),(490,'priv','zh-cn','testreport-delete','',''),(490,'priv','zh-tw','testreport-delete','',''),(490,'manager','de','auditcl','',''),(490,'manager','en','auditcl','',''),(490,'manager','fr','auditcl','',''),(490,'manager','zh-cn','auditcl','',''),(490,'manager','zh-tw','auditcl','',''),(491,'priv','de','testreport-edit','',''),(491,'priv','en','testreport-edit','',''),(491,'priv','fr','testreport-edit','',''),(491,'priv','zh-cn','testreport-edit','',''),(491,'priv','zh-tw','testreport-edit','',''),(491,'manager','de','reviewcl','',''),(491,'manager','en','reviewcl','',''),(491,'manager','fr','reviewcl','',''),(491,'manager','zh-cn','reviewcl','',''),(491,'manager','zh-tw','reviewcl','',''),(492,'priv','de','testreport-exportAction','',''),(492,'priv','en','testreport-exportAction','',''),(492,'priv','fr','testreport-exportAction','',''),(492,'priv','zh-cn','testreport-exportAction','',''),(492,'priv','zh-tw','testreport-exportAction','',''),(492,'manager','de','process','',''),(492,'manager','en','process','',''),(492,'manager','fr','process','',''),(492,'manager','zh-cn','process','',''),(492,'manager','zh-tw','process','',''),(493,'priv','de','milestone-indexAction','',''),(493,'priv','en','milestone-indexAction','',''),(493,'priv','fr','milestone-indexAction','',''),(493,'priv','zh-cn','milestone-indexAction','',''),(493,'priv','zh-tw','milestone-indexAction','',''),(493,'manager','de','activity','',''),(493,'manager','en','activity','',''),(493,'manager','fr','activity','',''),(493,'manager','zh-cn','activity','',''),(493,'manager','zh-tw','activity','',''),(494,'priv','de','milestone-saveOtherProblem','',''),(494,'priv','en','milestone-saveOtherProblem','',''),(494,'priv','fr','milestone-saveOtherProblem','',''),(494,'priv','zh-cn','milestone-saveOtherProblem','',''),(494,'priv','zh-tw','milestone-saveOtherProblem','',''),(494,'manager','de','zoutput','',''),(494,'manager','en','zoutput','',''),(494,'manager','fr','zoutput','',''),(494,'manager','zh-cn','zoutput','',''),(494,'manager','zh-tw','zoutput','',''),(495,'manager','de','subject','',''),(495,'manager','en','subject','',''),(495,'manager','fr','subject','',''),(495,'manager','zh-cn','subject','',''),(495,'manager','zh-tw','subject','',''),(496,'priv','de','caselib-browseAction','',''),(496,'priv','en','caselib-browseAction','',''),(496,'priv','fr','caselib-browseAction','',''),(496,'priv','zh-cn','caselib-browseAction','',''),(496,'priv','zh-tw','caselib-browseAction','',''),(496,'manager','de','approvalflow','',''),(496,'manager','en','approvalflow','',''),(496,'manager','fr','approvalflow','',''),(496,'manager','zh-cn','approvalflow','',''),(496,'manager','zh-tw','approvalflow','',''),(497,'priv','de','caselib-create','',''),(497,'priv','en','caselib-create','',''),(497,'priv','fr','caselib-create','',''),(497,'priv','zh-cn','caselib-create','',''),(497,'priv','zh-tw','caselib-create','',''),(497,'manager','de','reviewsetting','',''),(497,'manager','en','reviewsetting','',''),(497,'manager','fr','reviewsetting','',''),(497,'manager','zh-cn','reviewsetting','',''),(497,'manager','zh-tw','reviewsetting','',''),(498,'priv','de','caselib-edit','',''),(498,'priv','en','caselib-edit','',''),(498,'priv','fr','caselib-edit','',''),(498,'priv','zh-cn','caselib-edit','',''),(498,'priv','zh-tw','caselib-edit','',''),(498,'manager','de','measurement','',''),(498,'manager','en','measurement','',''),(498,'manager','fr','measurement','',''),(498,'manager','zh-cn','measurement','',''),(498,'manager','zh-tw','measurement','',''),(499,'priv','de','caselib-deleteAction','',''),(499,'priv','en','caselib-deleteAction','',''),(499,'priv','fr','caselib-deleteAction','',''),(499,'priv','zh-cn','caselib-deleteAction','',''),(499,'priv','zh-tw','caselib-deleteAction','',''),(499,'manager','de','setting','',''),(499,'manager','en','setting','',''),(499,'manager','fr','setting','',''),(499,'manager','zh-cn','setting','',''),(499,'manager','zh-tw','setting','',''),(500,'priv','de','caselib-view','',''),(500,'priv','en','caselib-view','',''),(500,'priv','fr','caselib-view','',''),(500,'priv','zh-cn','caselib-view','',''),(500,'priv','zh-tw','caselib-view','',''),(500,'manager','de','im','',''),(500,'manager','en','im','',''),(500,'manager','fr','im','',''),(500,'manager','zh-cn','im','',''),(500,'manager','zh-tw','im','',''),(501,'priv','de','caselib-createCase','',''),(501,'priv','en','caselib-createCase','',''),(501,'priv','fr','caselib-createCase','',''),(501,'priv','zh-cn','caselib-createCase','',''),(501,'priv','zh-tw','caselib-createCase','',''),(501,'manager','de','client','',''),(501,'manager','en','client','',''),(501,'manager','fr','client','',''),(501,'manager','zh-cn','client','',''),(501,'manager','zh-tw','client','',''),(502,'priv','de','caselib-batchCreateCase','',''),(502,'priv','en','caselib-batchCreateCase','',''),(502,'priv','fr','caselib-batchCreateCase','',''),(502,'priv','zh-cn','caselib-batchCreateCase','',''),(502,'priv','zh-tw','caselib-batchCreateCase','',''),(502,'manager','de','devops','',''),(502,'manager','en','devops','',''),(502,'manager','fr','devops','',''),(502,'manager','zh-cn','devops','',''),(502,'manager','zh-tw','devops','',''),(503,'priv','de','caselib-exportTemplate','',''),(503,'priv','en','caselib-exportTemplate','',''),(503,'priv','fr','caselib-exportTemplate','',''),(503,'priv','zh-cn','caselib-exportTemplate','',''),(503,'priv','zh-tw','caselib-exportTemplate','',''),(503,'manager','de','svn','',''),(503,'manager','en','svn','',''),(503,'manager','fr','svn','',''),(503,'manager','zh-cn','svn','',''),(503,'manager','zh-tw','svn','',''),(504,'priv','de','caselib-importAction','',''),(504,'priv','en','caselib-importAction','',''),(504,'priv','fr','caselib-importAction','',''),(504,'priv','zh-cn','caselib-importAction','',''),(504,'priv','zh-tw','caselib-importAction','',''),(504,'manager','de','git','',''),(504,'manager','en','git','',''),(504,'manager','fr','git','',''),(504,'manager','zh-cn','git','',''),(504,'manager','zh-tw','git','',''),(505,'priv','de','caselib-showImport','',''),(505,'priv','en','caselib-showImport','',''),(505,'priv','fr','caselib-showImport','',''),(505,'priv','zh-cn','caselib-showImport','',''),(505,'priv','zh-tw','caselib-showImport','',''),(505,'manager','de','mr','',''),(505,'manager','en','mr','',''),(505,'manager','fr','mr','',''),(505,'manager','zh-cn','mr','',''),(505,'manager','zh-tw','mr','',''),(506,'priv','de','zahost-browse','',''),(506,'priv','en','zahost-browse','',''),(506,'priv','fr','zahost-browse','',''),(506,'priv','zh-cn','zahost-browse','',''),(506,'priv','zh-tw','zahost-browse','',''),(506,'manager','de','repo','',''),(506,'manager','en','repo','',''),(506,'manager','fr','repo','',''),(506,'manager','zh-cn','repo','',''),(506,'manager','zh-tw','repo','',''),(507,'priv','de','zahost-create','',''),(507,'priv','en','zahost-create','',''),(507,'priv','fr','zahost-create','',''),(507,'priv','zh-cn','zahost-create','',''),(507,'priv','zh-tw','zahost-create','',''),(507,'manager','de','ci','',''),(507,'manager','en','ci','',''),(507,'manager','fr','ci','',''),(507,'manager','zh-cn','ci','',''),(507,'manager','zh-tw','ci','',''),(508,'priv','de','zahost-editAction','',''),(508,'priv','en','zahost-editAction','',''),(508,'priv','fr','zahost-editAction','',''),(508,'priv','zh-cn','zahost-editAction','',''),(508,'priv','zh-tw','zahost-editAction','',''),(508,'manager','de','compile','',''),(508,'manager','en','compile','',''),(508,'manager','fr','compile','',''),(508,'manager','zh-cn','compile','',''),(508,'manager','zh-tw','compile','',''),(509,'priv','de','zahost-deleteAction','',''),(509,'priv','en','zahost-deleteAction','',''),(509,'priv','fr','zahost-deleteAction','',''),(509,'priv','zh-cn','zahost-deleteAction','',''),(509,'priv','zh-tw','zahost-deleteAction','',''),(509,'manager','de','jenkins','',''),(509,'manager','en','jenkins','',''),(509,'manager','fr','jenkins','',''),(509,'manager','zh-cn','jenkins','',''),(509,'manager','zh-tw','jenkins','',''),(510,'priv','de','zahost-view','',''),(510,'priv','en','zahost-view','',''),(510,'priv','fr','zahost-view','',''),(510,'priv','zh-cn','zahost-view','',''),(510,'priv','zh-tw','zahost-view','',''),(510,'manager','de','job','',''),(510,'manager','en','job','',''),(510,'manager','fr','job','',''),(510,'manager','zh-cn','job','',''),(510,'manager','zh-tw','job','',''),(511,'priv','de','zahost-browseImage','',''),(511,'priv','en','zahost-browseImage','',''),(511,'priv','fr','zahost-browseImage','',''),(511,'priv','zh-cn','zahost-browseImage','',''),(511,'priv','zh-tw','zahost-browseImage','',''),(511,'manager','de','gitlab','',''),(511,'manager','en','gitlab','',''),(511,'manager','fr','gitlab','',''),(511,'manager','zh-cn','gitlab','',''),(511,'manager','zh-tw','gitlab','',''),(512,'priv','de','zahost-downloadImage','',''),(512,'priv','en','zahost-downloadImage','',''),(512,'priv','fr','zahost-downloadImage','',''),(512,'priv','zh-cn','zahost-downloadImage','',''),(512,'priv','zh-tw','zahost-downloadImage','',''),(512,'manager','de','gogs','',''),(512,'manager','en','gogs','',''),(512,'manager','fr','gogs','',''),(512,'manager','zh-cn','gogs','',''),(512,'manager','zh-tw','gogs','',''),(513,'priv','de','zahost-cancel','',''),(513,'priv','en','zahost-cancel','',''),(513,'priv','fr','zahost-cancel','',''),(513,'priv','zh-cn','zahost-cancel','',''),(513,'priv','zh-tw','zahost-cancel','',''),(513,'manager','de','gitea','',''),(513,'manager','en','gitea','',''),(513,'manager','fr','gitea','',''),(513,'manager','zh-cn','gitea','',''),(513,'manager','zh-tw','gitea','',''),(514,'priv','de','zanode-browse','',''),(514,'priv','en','zanode-browse','',''),(514,'priv','fr','zanode-browse','',''),(514,'priv','zh-cn','zanode-browse','',''),(514,'priv','zh-tw','zanode-browse','',''),(514,'manager','de','sonarqube','',''),(514,'manager','en','sonarqube','',''),(514,'manager','fr','sonarqube','',''),(514,'manager','zh-cn','sonarqube','',''),(514,'manager','zh-tw','sonarqube','',''),(515,'priv','de','zanode-create','',''),(515,'priv','en','zanode-create','',''),(515,'priv','fr','zanode-create','',''),(515,'priv','zh-cn','zanode-create','',''),(515,'priv','zh-tw','zanode-create','',''),(515,'manager','de','app','',''),(515,'manager','en','app','',''),(515,'manager','fr','app','',''),(515,'manager','zh-cn','app','',''),(515,'manager','zh-tw','app','',''),(516,'priv','de','zanode-edit','',''),(516,'priv','en','zanode-edit','',''),(516,'priv','fr','zanode-edit','',''),(516,'priv','zh-cn','zanode-edit','',''),(516,'priv','zh-tw','zanode-edit','',''),(516,'manager','de','pipeline','',''),(516,'manager','en','pipeline','',''),(516,'manager','fr','pipeline','',''),(516,'manager','zh-cn','pipeline','',''),(516,'manager','zh-tw','pipeline','',''),(517,'priv','de','zanode-destroy','',''),(517,'priv','en','zanode-destroy','',''),(517,'priv','fr','zanode-destroy','',''),(517,'priv','zh-cn','zanode-destroy','',''),(517,'priv','zh-tw','zanode-destroy','',''),(517,'manager','de','devopssetting','',''),(517,'manager','en','devopssetting','',''),(517,'manager','fr','devopssetting','',''),(517,'manager','zh-cn','devopssetting','',''),(517,'manager','zh-tw','devopssetting','',''),(518,'priv','de','zanode-reboot','',''),(518,'priv','en','zanode-reboot','',''),(518,'priv','fr','zanode-reboot','',''),(518,'priv','zh-cn','zanode-reboot','',''),(518,'priv','zh-tw','zanode-reboot','',''),(518,'manager','de','search','',''),(518,'manager','en','search','',''),(518,'manager','fr','search','',''),(518,'manager','zh-cn','search','',''),(518,'manager','zh-tw','search','',''),(519,'priv','de','zanode-resume','',''),(519,'priv','en','zanode-resume','',''),(519,'priv','fr','zanode-resume','',''),(519,'priv','zh-cn','zanode-resume','',''),(519,'priv','zh-tw','zanode-resume','',''),(519,'manager','de','tree','',''),(519,'manager','en','tree','',''),(519,'manager','fr','tree','',''),(519,'manager','zh-cn','tree','',''),(519,'manager','zh-tw','tree','',''),(520,'priv','de','zanode-getVNC','',''),(520,'priv','en','zanode-getVNC','',''),(520,'priv','fr','zanode-getVNC','',''),(520,'priv','zh-cn','zanode-getVNC','',''),(520,'priv','zh-tw','zanode-getVNC','',''),(520,'manager','de','file','',''),(520,'manager','en','file','',''),(520,'manager','fr','file','',''),(520,'manager','zh-cn','file','',''),(520,'manager','zh-tw','file','',''),(521,'priv','de','zanode-boot','',''),(521,'priv','en','zanode-boot','',''),(521,'priv','fr','zanode-boot','',''),(521,'priv','zh-cn','zanode-boot','',''),(521,'priv','zh-tw','zanode-boot','',''),(521,'manager','de','misc','',''),(521,'manager','en','misc','',''),(521,'manager','fr','misc','',''),(521,'manager','zh-cn','misc','',''),(521,'manager','zh-tw','misc','',''),(522,'priv','de','zanode-shutdown','',''),(522,'priv','en','zanode-shutdown','',''),(522,'priv','fr','zanode-shutdown','',''),(522,'priv','zh-cn','zanode-shutdown','',''),(522,'priv','zh-tw','zanode-shutdown','',''),(522,'manager','de','approval','',''),(522,'manager','en','approval','',''),(522,'manager','fr','approval','',''),(522,'manager','zh-cn','approval','',''),(522,'manager','zh-tw','approval','',''),(523,'priv','de','zanode-view','',''),(523,'priv','en','zanode-view','',''),(523,'priv','fr','zanode-view','',''),(523,'priv','zh-cn','zanode-view','',''),(523,'priv','zh-tw','zanode-view','',''),(523,'manager','de','workflow','',''),(523,'manager','en','workflow','',''),(523,'manager','fr','workflow','',''),(523,'manager','zh-cn','workflow','',''),(523,'manager','zh-tw','workflow','',''),(524,'priv','de','zanode-createImage','',''),(524,'priv','en','zanode-createImage','',''),(524,'priv','fr','zanode-createImage','',''),(524,'priv','zh-cn','zanode-createImage','',''),(524,'priv','zh-tw','zanode-createImage','',''),(524,'manager','de','workflow','',''),(524,'manager','en','workflow','',''),(524,'manager','fr','workflow','',''),(524,'manager','zh-cn','workflow','',''),(524,'manager','zh-tw','workflow','',''),(525,'priv','de','zanode-browseSnapshot','',''),(525,'priv','en','zanode-browseSnapshot','',''),(525,'priv','fr','zanode-browseSnapshot','',''),(525,'priv','zh-cn','zanode-browseSnapshot','',''),(525,'priv','zh-tw','zanode-browseSnapshot','',''),(525,'manager','de','workflowfield','',''),(525,'manager','en','workflowfield','',''),(525,'manager','fr','workflowfield','',''),(525,'manager','zh-cn','workflowfield','',''),(525,'manager','zh-tw','workflowfield','',''),(526,'priv','de','zanode-createSnapshot','',''),(526,'priv','en','zanode-createSnapshot','',''),(526,'priv','fr','zanode-createSnapshot','',''),(526,'priv','zh-cn','zanode-createSnapshot','',''),(526,'priv','zh-tw','zanode-createSnapshot','',''),(526,'manager','de','workflowaction','',''),(526,'manager','en','workflowaction','',''),(526,'manager','fr','workflowaction','',''),(526,'manager','zh-cn','workflowaction','',''),(526,'manager','zh-tw','workflowaction','',''),(527,'priv','de','zanode-editSnapshot','',''),(527,'priv','en','zanode-editSnapshot','',''),(527,'priv','fr','zanode-editSnapshot','',''),(527,'priv','zh-cn','zanode-editSnapshot','',''),(527,'priv','zh-tw','zanode-editSnapshot','',''),(527,'manager','de','workflowlayout','',''),(527,'manager','en','workflowlayout','',''),(527,'manager','fr','workflowlayout','',''),(527,'manager','zh-cn','workflowlayout','',''),(527,'manager','zh-tw','workflowlayout','',''),(528,'priv','de','zanode-restoreSnapshot','',''),(528,'priv','en','zanode-restoreSnapshot','',''),(528,'priv','fr','zanode-restoreSnapshot','',''),(528,'priv','zh-cn','zanode-restoreSnapshot','',''),(528,'priv','zh-tw','zanode-restoreSnapshot','',''),(528,'manager','de','workflowcondition','',''),(528,'manager','en','workflowcondition','',''),(528,'manager','fr','workflowcondition','',''),(528,'manager','zh-cn','workflowcondition','',''),(528,'manager','zh-tw','workflowcondition','',''),(529,'priv','de','zanode-deleteSnapshot','',''),(529,'priv','en','zanode-deleteSnapshot','',''),(529,'priv','fr','zanode-deleteSnapshot','',''),(529,'priv','zh-cn','zanode-deleteSnapshot','',''),(529,'priv','zh-tw','zanode-deleteSnapshot','',''),(529,'manager','de','workflowlinkage','',''),(529,'manager','en','workflowlinkage','',''),(529,'manager','fr','workflowlinkage','',''),(529,'manager','zh-cn','workflowlinkage','',''),(529,'manager','zh-tw','workflowlinkage','',''),(530,'priv','de','zanode-suspend','',''),(530,'priv','en','zanode-suspend','',''),(530,'priv','fr','zanode-suspend','',''),(530,'priv','zh-cn','zanode-suspend','',''),(530,'priv','zh-tw','zanode-suspend','',''),(530,'manager','de','workflowhook','',''),(530,'manager','en','workflowhook','',''),(530,'manager','fr','workflowhook','',''),(530,'manager','zh-cn','workflowhook','',''),(530,'manager','zh-tw','workflowhook','',''),(531,'manager','de','workflowlabel','',''),(531,'manager','en','workflowlabel','',''),(531,'manager','fr','workflowlabel','',''),(531,'manager','zh-cn','workflowlabel','',''),(531,'manager','zh-tw','workflowlabel','',''),(532,'manager','de','workflowrelation','',''),(532,'manager','en','workflowrelation','',''),(532,'manager','fr','workflowrelation','',''),(532,'manager','zh-cn','workflowrelation','',''),(532,'manager','zh-tw','workflowrelation','',''),(533,'manager','de','workflowreport','',''),(533,'manager','en','workflowreport','',''),(533,'manager','fr','workflowreport','',''),(533,'manager','zh-cn','workflowreport','',''),(533,'manager','zh-tw','workflowreport','',''),(534,'manager','de','workflowdatasource','',''),(534,'manager','en','workflowdatasource','',''),(534,'manager','fr','workflowdatasource','',''),(534,'manager','zh-cn','workflowdatasource','',''),(534,'manager','zh-tw','workflowdatasource','',''),(535,'manager','de','workflowrule','',''),(535,'manager','en','workflowrule','',''),(535,'manager','fr','workflowrule','',''),(535,'manager','zh-cn','workflowrule','',''),(535,'manager','zh-tw','workflowrule','',''),(536,'manager','de','datatable','',''),(536,'manager','en','datatable','',''),(536,'manager','fr','datatable','',''),(536,'manager','zh-cn','datatable','',''),(536,'manager','zh-tw','datatable','',''),(537,'manager','de','generalcomment','',''),(537,'manager','en','generalcomment','',''),(537,'manager','fr','generalcomment','',''),(537,'manager','zh-cn','generalcomment','',''),(537,'manager','zh-tw','generalcomment','',''),(538,'manager','de','generalping','',''),(538,'manager','en','generalping','',''),(538,'manager','fr','generalping','',''),(538,'manager','zh-cn','generalping','',''),(538,'manager','zh-tw','generalping','',''),(539,'manager','de','generaltemplate','',''),(539,'manager','en','generaltemplate','',''),(539,'manager','fr','generaltemplate','',''),(539,'manager','zh-cn','generaltemplate','',''),(539,'manager','zh-tw','generaltemplate','',''),(540,'manager','de','generaleffort','',''),(540,'manager','en','generaleffort','',''),(540,'manager','fr','generaleffort','',''),(540,'manager','zh-cn','generaleffort','',''),(540,'manager','zh-tw','generaleffort','',''),(541,'manager','de','feedback','',''),(541,'manager','en','feedback','',''),(541,'manager','fr','feedback','',''),(541,'manager','zh-cn','feedback','',''),(541,'manager','zh-tw','feedback','',''),(542,'manager','de','feedback','',''),(542,'manager','en','feedback','',''),(542,'manager','fr','feedback','',''),(542,'manager','zh-cn','feedback','',''),(542,'manager','zh-tw','feedback','',''),(543,'manager','de','faq','',''),(543,'manager','en','faq','',''),(543,'manager','fr','faq','',''),(543,'manager','zh-cn','faq','',''),(543,'manager','zh-tw','faq','',''),(544,'manager','de','ticket','',''),(544,'manager','en','ticket','',''),(544,'manager','fr','ticket','',''),(544,'manager','zh-cn','ticket','',''),(544,'manager','zh-tw','ticket','',''),(545,'manager','de','feedbackpriv','',''),(545,'manager','en','feedbackpriv','',''),(545,'manager','fr','feedbackpriv','',''),(545,'manager','zh-cn','feedbackpriv','',''),(545,'manager','zh-tw','feedbackpriv','',''),(546,'manager','de','oa','',''),(546,'manager','en','oa','',''),(546,'manager','fr','oa','',''),(546,'manager','zh-cn','oa','',''),(546,'manager','zh-tw','oa','',''),(547,'manager','de','attend','',''),(547,'manager','en','attend','',''),(547,'manager','fr','attend','',''),(547,'manager','zh-cn','attend','',''),(547,'manager','zh-tw','attend','',''),(548,'manager','de','leave','',''),(548,'manager','en','leave','',''),(548,'manager','fr','leave','',''),(548,'manager','zh-cn','leave','',''),(548,'manager','zh-tw','leave','',''),(549,'manager','de','makeup','',''),(549,'manager','en','makeup','',''),(549,'manager','fr','makeup','',''),(549,'manager','zh-cn','makeup','',''),(549,'manager','zh-tw','makeup','',''),(550,'manager','de','overtime','',''),(550,'manager','en','overtime','',''),(550,'manager','fr','overtime','',''),(550,'manager','zh-cn','overtime','',''),(550,'manager','zh-tw','overtime','',''),(551,'manager','de','lieu','',''),(551,'manager','en','lieu','',''),(551,'manager','fr','lieu','',''),(551,'manager','zh-cn','lieu','',''),(551,'manager','zh-tw','lieu','',''),(552,'manager','de','officeapproval','',''),(552,'manager','en','officeapproval','',''),(552,'manager','fr','officeapproval','',''),(552,'manager','zh-cn','officeapproval','',''),(552,'manager','zh-tw','officeapproval','',''),(553,'manager','de','officesetting','',''),(553,'manager','en','officesetting','',''),(553,'manager','fr','officesetting','',''),(553,'manager','zh-cn','officesetting','',''),(553,'manager','zh-tw','officesetting','',''),(554,'manager','de','datapermission','',''),(554,'manager','en','datapermission','',''),(554,'manager','fr','datapermission','',''),(554,'manager','zh-cn','datapermission','',''),(554,'manager','zh-tw','datapermission','',''),(555,'manager','de','officeexport','',''),(555,'manager','en','officeexport','',''),(555,'manager','fr','officeexport','',''),(555,'manager','zh-cn','officeexport','',''),(555,'manager','zh-tw','officeexport','',''),(556,'manager','de','ops','',''),(556,'manager','en','ops','',''),(556,'manager','fr','ops','',''),(556,'manager','zh-cn','ops','',''),(556,'manager','zh-tw','ops','',''),(557,'manager','de','ops','',''),(557,'manager','en','ops','',''),(557,'manager','fr','ops','',''),(557,'manager','zh-cn','ops','',''),(557,'manager','zh-tw','ops','',''),(558,'priv','de','screen-browse','',''),(558,'priv','en','screen-browse','',''),(558,'priv','fr','screen-browse','',''),(558,'priv','zh-cn','screen-browse','',''),(558,'priv','zh-tw','screen-browse','',''),(558,'manager','de','host','',''),(558,'manager','en','host','',''),(558,'manager','fr','host','',''),(558,'manager','zh-cn','host','',''),(558,'manager','zh-tw','host','',''),(559,'priv','de','screen-view','',''),(559,'priv','en','screen-view','',''),(559,'priv','fr','screen-view','',''),(559,'priv','zh-cn','screen-view','',''),(559,'priv','zh-tw','screen-view','',''),(559,'manager','de','serverroom','',''),(559,'manager','en','serverroom','',''),(559,'manager','fr','serverroom','',''),(559,'manager','zh-cn','serverroom','',''),(559,'manager','zh-tw','serverroom','',''),(560,'manager','de','account','',''),(560,'manager','en','account','',''),(560,'manager','fr','account','',''),(560,'manager','zh-cn','account','',''),(560,'manager','zh-tw','account','',''),(561,'manager','de','domain','',''),(561,'manager','en','domain','',''),(561,'manager','fr','domain','',''),(561,'manager','zh-cn','domain','',''),(561,'manager','zh-tw','domain','',''),(562,'manager','de','service','',''),(562,'manager','en','service','',''),(562,'manager','fr','service','',''),(562,'manager','zh-cn','service','',''),(562,'manager','zh-tw','service','',''),(563,'manager','de','deploy','',''),(563,'manager','en','deploy','',''),(563,'manager','fr','deploy','',''),(563,'manager','zh-cn','deploy','',''),(563,'manager','zh-tw','deploy','',''),(564,'manager','de','conference','',''),(564,'manager','en','conference','',''),(564,'manager','fr','conference','',''),(564,'manager','zh-cn','conference','',''),(564,'manager','zh-tw','conference','',''),(565,'manager','de','traincourse','',''),(565,'manager','en','traincourse','',''),(565,'manager','fr','traincourse','',''),(565,'manager','zh-cn','traincourse','',''),(565,'manager','zh-tw','traincourse','',''),(566,'manager','de','traincourse','',''),(566,'manager','en','traincourse','',''),(566,'manager','fr','traincourse','',''),(566,'manager','zh-cn','traincourse','',''),(566,'manager','zh-tw','traincourse','',''),(595,'priv','de','company-browse','',''),(595,'priv','en','company-browse','',''),(595,'priv','fr','company-browse','',''),(595,'priv','zh-cn','company-browse','',''),(595,'priv','zh-tw','company-browse','',''),(596,'priv','de','company-edit','',''),(596,'priv','en','company-edit','',''),(596,'priv','fr','company-edit','',''),(596,'priv','zh-cn','company-edit','',''),(596,'priv','zh-tw','company-edit','',''),(597,'priv','de','company-dynamic','',''),(597,'priv','en','company-dynamic','',''),(597,'priv','fr','company-dynamic','',''),(597,'priv','zh-cn','company-dynamic','',''),(597,'priv','zh-tw','company-dynamic','',''),(598,'priv','de','company-view','',''),(598,'priv','en','company-view','',''),(598,'priv','fr','company-view','',''),(598,'priv','zh-cn','company-view','',''),(598,'priv','zh-tw','company-view','',''),(599,'priv','de','company-companyTodo','',''),(599,'priv','en','company-companyTodo','',''),(599,'priv','fr','company-companyTodo','',''),(599,'priv','zh-cn','company-companyTodo','',''),(599,'priv','zh-tw','company-companyTodo','',''),(600,'priv','de','company-effortCalendar','',''),(600,'priv','en','company-effortCalendar','',''),(600,'priv','fr','company-effortCalendar','',''),(600,'priv','zh-cn','company-effortCalendar','',''),(600,'priv','zh-tw','company-effortCalendar','',''),(601,'priv','de','company-allTodo','',''),(601,'priv','en','company-allTodo','',''),(601,'priv','fr','company-allTodo','',''),(601,'priv','zh-cn','company-allTodo','',''),(601,'priv','zh-tw','company-allTodo','',''),(602,'priv','de','company-companyEffort','',''),(602,'priv','en','company-companyEffort','',''),(602,'priv','fr','company-companyEffort','',''),(602,'priv','zh-cn','company-companyEffort','',''),(602,'priv','zh-tw','company-companyEffort','',''),(603,'priv','de','company-allEffort','',''),(603,'priv','en','company-allEffort','',''),(603,'priv','fr','company-allEffort','',''),(603,'priv','zh-cn','company-allEffort','',''),(603,'priv','zh-tw','company-allEffort','',''),(604,'priv','de','dept-browse','',''),(604,'priv','en','dept-browse','',''),(604,'priv','fr','dept-browse','',''),(604,'priv','zh-cn','dept-browse','',''),(604,'priv','zh-tw','dept-browse','',''),(605,'priv','de','dept-updateOrder','',''),(605,'priv','en','dept-updateOrder','',''),(605,'priv','fr','dept-updateOrder','',''),(605,'priv','zh-cn','dept-updateOrder','',''),(605,'priv','zh-tw','dept-updateOrder','',''),(606,'priv','de','dept-manageChildAction','',''),(606,'priv','en','dept-manageChildAction','',''),(606,'priv','fr','dept-manageChildAction','',''),(606,'priv','zh-cn','dept-manageChildAction','',''),(606,'priv','zh-tw','dept-manageChildAction','',''),(607,'priv','de','dept-edit','',''),(607,'priv','en','dept-edit','',''),(607,'priv','fr','dept-edit','',''),(607,'priv','zh-cn','dept-edit','',''),(607,'priv','zh-tw','dept-edit','',''),(607,'manager','de','demandpool','',''),(607,'manager','en','demandpool','',''),(607,'manager','fr','demandpool','',''),(607,'manager','zh-cn','demandpool','',''),(607,'manager','zh-tw','demandpool','',''),(608,'priv','de','dept-delete','',''),(608,'priv','en','dept-delete','',''),(608,'priv','fr','dept-delete','',''),(608,'priv','zh-cn','dept-delete','',''),(608,'priv','zh-tw','dept-delete','',''),(608,'manager','de','charter','',''),(608,'manager','en','charter','',''),(608,'manager','fr','charter','',''),(608,'manager','zh-cn','charter','',''),(608,'manager','zh-tw','charter','',''),(609,'priv','de','group-browseAction','',''),(609,'priv','en','group-browseAction','',''),(609,'priv','fr','group-browseAction','',''),(609,'priv','zh-cn','group-browseAction','',''),(609,'priv','zh-tw','group-browseAction','',''),(609,'manager','de','charter','',''),(609,'manager','en','charter','',''),(609,'manager','fr','charter','',''),(609,'manager','zh-cn','charter','',''),(609,'manager','zh-tw','charter','',''),(610,'priv','de','group-create','',''),(610,'priv','en','group-create','',''),(610,'priv','fr','group-create','',''),(610,'priv','zh-cn','group-create','',''),(610,'priv','zh-tw','group-create','',''),(610,'manager','de','demandpool','',''),(610,'manager','en','demandpool','',''),(610,'manager','fr','demandpool','',''),(610,'manager','zh-cn','demandpool','',''),(610,'manager','zh-tw','demandpool','',''),(611,'priv','de','group-edit','',''),(611,'priv','en','group-edit','',''),(611,'priv','fr','group-edit','',''),(611,'priv','zh-cn','group-edit','',''),(611,'priv','zh-tw','group-edit','',''),(611,'manager','de','demand','',''),(611,'manager','en','demand','',''),(611,'manager','fr','demand','',''),(611,'manager','zh-cn','demand','',''),(611,'manager','zh-tw','demand','',''),(612,'priv','de','group-copy','',''),(612,'priv','en','group-copy','',''),(612,'priv','fr','group-copy','',''),(612,'priv','zh-cn','group-copy','',''),(612,'priv','zh-tw','group-copy','',''),(612,'manager','de','roadmap','',''),(612,'manager','en','roadmap','',''),(612,'manager','fr','roadmap','',''),(612,'manager','zh-cn','roadmap','',''),(612,'manager','zh-tw','roadmap','',''),(613,'priv','de','group-delete','',''),(613,'priv','en','group-delete','',''),(613,'priv','fr','group-delete','',''),(613,'priv','zh-cn','group-delete','',''),(613,'priv','zh-tw','group-delete','',''),(614,'priv','de','group-managePriv','',''),(614,'priv','en','group-managePriv','',''),(614,'priv','fr','group-managePriv','',''),(614,'priv','zh-cn','group-managePriv','',''),(614,'priv','zh-tw','group-managePriv','',''),(615,'priv','de','group-manageMember','',''),(615,'priv','en','group-manageMember','',''),(615,'priv','fr','group-manageMember','',''),(615,'priv','zh-cn','group-manageMember','',''),(615,'priv','zh-tw','group-manageMember','',''),(616,'priv','de','group-manageProjectAdmin','',''),(616,'priv','en','group-manageProjectAdmin','',''),(616,'priv','fr','group-manageProjectAdmin','',''),(616,'priv','zh-cn','group-manageProjectAdmin','',''),(616,'priv','zh-tw','group-manageProjectAdmin','',''),(618,'priv','de','group-manageView','',''),(618,'priv','en','group-manageView','',''),(618,'priv','fr','group-manageView','',''),(618,'priv','zh-cn','group-manageView','',''),(618,'priv','zh-tw','group-manageView','',''),(624,'priv','de','user-create','',''),(624,'priv','en','user-create','',''),(624,'priv','fr','user-create','',''),(624,'priv','zh-cn','user-create','',''),(624,'priv','zh-tw','user-create','',''),(625,'priv','de','user-batchCreate','',''),(625,'priv','en','user-batchCreate','',''),(625,'priv','fr','user-batchCreate','',''),(625,'priv','zh-cn','user-batchCreate','',''),(625,'priv','zh-tw','user-batchCreate','',''),(626,'priv','de','user-view','',''),(626,'priv','en','user-view','',''),(626,'priv','fr','user-view','',''),(626,'priv','zh-cn','user-view','',''),(626,'priv','zh-tw','user-view','',''),(627,'priv','de','user-edit','',''),(627,'priv','en','user-edit','',''),(627,'priv','fr','user-edit','',''),(627,'priv','zh-cn','user-edit','',''),(627,'priv','zh-tw','user-edit','',''),(628,'priv','de','user-unlock','',''),(628,'priv','en','user-unlock','',''),(628,'priv','fr','user-unlock','',''),(628,'priv','zh-cn','user-unlock','',''),(628,'priv','zh-tw','user-unlock','',''),(629,'priv','de','user-delete','',''),(629,'priv','en','user-delete','',''),(629,'priv','fr','user-delete','',''),(629,'priv','zh-cn','user-delete','',''),(629,'priv','zh-tw','user-delete','',''),(630,'priv','de','user-todo','',''),(630,'priv','en','user-todo','',''),(630,'priv','fr','user-todo','',''),(630,'priv','zh-cn','user-todo','',''),(630,'priv','zh-tw','user-todo','',''),(631,'priv','de','user-task','',''),(631,'priv','en','user-task','',''),(631,'priv','fr','user-task','',''),(631,'priv','zh-cn','user-task','',''),(631,'priv','zh-tw','user-task','',''),(632,'priv','de','user-bug','',''),(632,'priv','en','user-bug','',''),(632,'priv','fr','user-bug','',''),(632,'priv','zh-cn','user-bug','',''),(632,'priv','zh-tw','user-bug','',''),(633,'priv','de','user-dynamic','',''),(633,'priv','en','user-dynamic','',''),(633,'priv','fr','user-dynamic','',''),(633,'priv','zh-cn','user-dynamic','',''),(633,'priv','zh-tw','user-dynamic','',''),(635,'priv','de','user-profile','',''),(635,'priv','en','user-profile','',''),(635,'priv','fr','user-profile','',''),(635,'priv','zh-cn','user-profile','',''),(635,'priv','zh-tw','user-profile','',''),(635,'manager','zh-cn','','浏览需求池',''),(636,'priv','de','user-batchEdit','',''),(636,'priv','en','user-batchEdit','',''),(636,'priv','fr','user-batchEdit','',''),(636,'priv','zh-cn','user-batchEdit','',''),(636,'priv','zh-tw','user-batchEdit','',''),(636,'manager','zh-cn','','浏览立项',''),(637,'priv','de','user-unbind','',''),(637,'priv','en','user-unbind','',''),(637,'priv','fr','user-unbind','',''),(637,'priv','zh-cn','user-unbind','',''),(637,'priv','zh-tw','user-unbind','',''),(637,'manager','zh-cn','','创建维护需求池',''),(638,'priv','de','user-setPublicTemplate','',''),(638,'priv','en','user-setPublicTemplate','',''),(638,'priv','fr','user-setPublicTemplate','',''),(638,'priv','zh-cn','user-setPublicTemplate','',''),(638,'priv','zh-tw','user-setPublicTemplate','',''),(638,'manager','zh-cn','','提交立项',''),(639,'priv','de','user-export','',''),(639,'priv','en','user-export','',''),(639,'priv','fr','user-export','',''),(639,'priv','zh-cn','user-export','',''),(639,'priv','zh-tw','user-export','',''),(639,'manager','zh-cn','','立项审批',''),(640,'priv','de','user-exportTemplate','',''),(640,'priv','en','user-exportTemplate','',''),(640,'priv','fr','user-exportTemplate','',''),(640,'priv','zh-cn','user-exportTemplate','',''),(640,'priv','zh-tw','user-exportTemplate','',''),(640,'manager','zh-cn','','浏览需求',''),(641,'priv','de','user-story','',''),(641,'priv','en','user-story','',''),(641,'priv','fr','user-story','',''),(641,'priv','zh-cn','user-story','',''),(641,'priv','zh-tw','user-story','',''),(641,'manager','zh-cn','','创建维护需求',''),(642,'priv','de','user-testTask','',''),(642,'priv','en','user-testTask','',''),(642,'priv','fr','user-testTask','',''),(642,'priv','zh-cn','user-testTask','',''),(642,'priv','zh-tw','user-testTask','',''),(642,'manager','zh-cn','','评审需求',''),(643,'priv','de','user-testCase','',''),(643,'priv','en','user-testCase','',''),(643,'priv','fr','user-testCase','',''),(643,'priv','zh-cn','user-testCase','',''),(643,'priv','zh-tw','user-testCase','',''),(643,'manager','zh-cn','','导入导出需求',''),(644,'priv','de','user-execution','',''),(644,'priv','en','user-execution','',''),(644,'priv','fr','user-execution','',''),(644,'priv','zh-cn','user-execution','',''),(644,'priv','zh-tw','user-execution','',''),(644,'manager','zh-cn','','删除需求',''),(645,'priv','de','user-effortcalendar','',''),(645,'priv','en','user-effortcalendar','',''),(645,'priv','fr','user-effortcalendar','',''),(645,'priv','zh-cn','user-effortcalendar','',''),(645,'priv','zh-tw','user-effortcalendar','',''),(645,'manager','zh-cn','','后台',''),(646,'priv','de','user-todocalendar','',''),(646,'priv','en','user-todocalendar','',''),(646,'priv','fr','user-todocalendar','',''),(646,'priv','zh-cn','user-todocalendar','',''),(646,'priv','zh-tw','user-todocalendar','',''),(646,'manager','zh-cn','','浏览产品路标',''),(647,'priv','de','user-effort','',''),(647,'priv','en','user-effort','',''),(647,'priv','fr','user-effort','',''),(647,'priv','zh-cn','user-effort','',''),(647,'priv','zh-tw','user-effort','',''),(647,'manager','zh-cn','','创建维护产品路标',''),(648,'priv','de','user-import','',''),(648,'priv','en','user-import','',''),(648,'priv','fr','user-import','',''),(648,'priv','zh-cn','user-import','',''),(648,'priv','zh-tw','user-import','',''),(648,'manager','zh-cn','','删除产品路标',''),(649,'priv','de','user-importLDAP','',''),(649,'priv','en','user-importLDAP','',''),(649,'priv','fr','user-importLDAP','',''),(649,'priv','zh-cn','user-importLDAP','',''),(649,'priv','zh-tw','user-importLDAP','',''),(649,'manager','zh-cn','','删除需求池',''),(650,'priv','de','user-issue','',''),(650,'priv','en','user-issue','',''),(650,'priv','fr','user-issue','',''),(650,'priv','zh-cn','user-issue','',''),(650,'priv','zh-tw','user-issue','',''),(651,'priv','de','user-risk','',''),(651,'priv','en','user-risk','',''),(651,'priv','fr','user-risk','',''),(651,'priv','zh-cn','user-risk','',''),(651,'priv','zh-tw','user-risk','',''),(652,'priv','de','admin-index','',''),(652,'priv','en','admin-index','',''),(652,'priv','fr','admin-index','',''),(652,'priv','zh-cn','admin-index','',''),(652,'priv','zh-tw','admin-index','',''),(654,'priv','de','admin-checkWeak','',''),(654,'priv','en','admin-checkWeak','',''),(654,'priv','fr','admin-checkWeak','',''),(654,'priv','zh-cn','admin-checkWeak','',''),(654,'priv','zh-tw','admin-checkWeak','',''),(655,'priv','de','admin-ssoAction','',''),(655,'priv','en','admin-ssoAction','',''),(655,'priv','fr','admin-ssoAction','',''),(655,'priv','zh-cn','admin-ssoAction','',''),(655,'priv','zh-tw','admin-ssoAction','',''),(656,'priv','de','admin-register','',''),(656,'priv','en','admin-register','',''),(656,'priv','fr','admin-register','',''),(656,'priv','zh-cn','admin-register','',''),(656,'priv','zh-tw','admin-register','',''),(657,'priv','de','admin-xuanxuan','',''),(657,'priv','en','admin-xuanxuan','',''),(657,'priv','fr','admin-xuanxuan','',''),(657,'priv','zh-cn','admin-xuanxuan','',''),(657,'priv','zh-tw','admin-xuanxuan','',''),(659,'priv','de','admin-resetPWDSetting','',''),(659,'priv','en','admin-resetPWDSetting','',''),(659,'priv','fr','admin-resetPWDSetting','',''),(659,'priv','zh-cn','admin-resetPWDSetting','',''),(659,'priv','zh-tw','admin-resetPWDSetting','',''),(660,'priv','de','admin-tableEngine','',''),(660,'priv','en','admin-tableEngine','',''),(660,'priv','fr','admin-tableEngine','',''),(660,'priv','zh-cn','admin-tableEngine','',''),(660,'priv','zh-tw','admin-tableEngine','',''),(661,'priv','de','admin-safeIndex','',''),(661,'priv','en','admin-safeIndex','',''),(661,'priv','fr','admin-safeIndex','',''),(661,'priv','zh-cn','admin-safeIndex','',''),(661,'priv','zh-tw','admin-safeIndex','',''),(662,'priv','de','stage-browse','',''),(662,'priv','en','stage-browse','',''),(662,'priv','fr','stage-browse','',''),(662,'priv','zh-cn','stage-browse','',''),(662,'priv','zh-tw','stage-browse','',''),(663,'priv','de','stage-create','',''),(663,'priv','en','stage-create','',''),(663,'priv','fr','stage-create','',''),(663,'priv','zh-cn','stage-create','',''),(663,'priv','zh-tw','stage-create','',''),(664,'priv','de','stage-batchCreate','',''),(664,'priv','en','stage-batchCreate','',''),(664,'priv','fr','stage-batchCreate','',''),(664,'priv','zh-cn','stage-batchCreate','',''),(664,'priv','zh-tw','stage-batchCreate','',''),(665,'priv','de','stage-edit','',''),(665,'priv','en','stage-edit','',''),(665,'priv','fr','stage-edit','',''),(665,'priv','zh-cn','stage-edit','',''),(665,'priv','zh-tw','stage-edit','',''),(666,'priv','de','stage-setType','',''),(666,'priv','en','stage-setType','',''),(666,'priv','fr','stage-setType','',''),(666,'priv','zh-cn','stage-setType','',''),(666,'priv','zh-tw','stage-setType','',''),(667,'priv','de','stage-delete','',''),(667,'priv','en','stage-delete','',''),(667,'priv','fr','stage-delete','',''),(667,'priv','zh-cn','stage-delete','',''),(667,'priv','zh-tw','stage-delete','',''),(668,'priv','de','stage-plusBrowse','',''),(668,'priv','en','stage-plusBrowse','',''),(668,'priv','fr','stage-plusBrowse','',''),(668,'priv','zh-cn','stage-plusBrowse','',''),(668,'priv','zh-tw','stage-plusBrowse','',''),(669,'priv','de','extension-browseAction','',''),(669,'priv','en','extension-browseAction','',''),(669,'priv','fr','extension-browseAction','',''),(669,'priv','zh-cn','extension-browseAction','',''),(669,'priv','zh-tw','extension-browseAction','',''),(670,'priv','de','extension-obtain','',''),(670,'priv','en','extension-obtain','',''),(670,'priv','fr','extension-obtain','',''),(670,'priv','zh-cn','extension-obtain','',''),(670,'priv','zh-tw','extension-obtain','',''),(671,'priv','de','extension-structureAction','',''),(671,'priv','en','extension-structureAction','',''),(671,'priv','fr','extension-structureAction','',''),(671,'priv','zh-cn','extension-structureAction','',''),(671,'priv','zh-tw','extension-structureAction','',''),(672,'priv','de','extension-install','',''),(672,'priv','en','extension-install','',''),(672,'priv','fr','extension-install','',''),(672,'priv','zh-cn','extension-install','',''),(672,'priv','zh-tw','extension-install','',''),(673,'priv','de','extension-uninstallAction','',''),(673,'priv','en','extension-uninstallAction','',''),(673,'priv','fr','extension-uninstallAction','',''),(673,'priv','zh-cn','extension-uninstallAction','',''),(673,'priv','zh-tw','extension-uninstallAction','',''),(674,'priv','de','extension-activateAction','',''),(674,'priv','en','extension-activateAction','',''),(674,'priv','fr','extension-activateAction','',''),(674,'priv','zh-cn','extension-activateAction','',''),(674,'priv','zh-tw','extension-activateAction','',''),(675,'priv','de','extension-deactivateAction','',''),(675,'priv','en','extension-deactivateAction','',''),(675,'priv','fr','extension-deactivateAction','',''),(675,'priv','zh-cn','extension-deactivateAction','',''),(675,'priv','zh-tw','extension-deactivateAction','',''),(676,'priv','de','extension-upload','',''),(676,'priv','en','extension-upload','',''),(676,'priv','fr','extension-upload','',''),(676,'priv','zh-cn','extension-upload','',''),(676,'priv','zh-tw','extension-upload','',''),(677,'priv','de','extension-eraseAction','',''),(677,'priv','en','extension-eraseAction','',''),(677,'priv','fr','extension-eraseAction','',''),(677,'priv','zh-cn','extension-eraseAction','',''),(677,'priv','zh-tw','extension-eraseAction','',''),(678,'priv','de','extension-upgrade','',''),(678,'priv','en','extension-upgrade','',''),(678,'priv','fr','extension-upgrade','',''),(678,'priv','zh-cn','extension-upgrade','',''),(678,'priv','zh-tw','extension-upgrade','',''),(680,'priv','de','custom-set','',''),(680,'priv','en','custom-set','',''),(680,'priv','fr','custom-set','',''),(680,'priv','zh-cn','custom-set','',''),(680,'priv','zh-tw','custom-set','',''),(681,'priv','de','custom-productName','',''),(681,'priv','en','custom-productName','',''),(681,'priv','fr','custom-productName','',''),(681,'priv','zh-cn','custom-productName','',''),(681,'priv','zh-tw','custom-productName','',''),(682,'priv','de','custom-executionCommon','',''),(682,'priv','en','custom-executionCommon','',''),(682,'priv','fr','custom-executionCommon','',''),(682,'priv','zh-cn','custom-executionCommon','',''),(682,'priv','zh-tw','custom-executionCommon','',''),(683,'priv','de','custom-required','',''),(683,'priv','en','custom-required','',''),(683,'priv','fr','custom-required','',''),(683,'priv','zh-cn','custom-required','',''),(683,'priv','zh-tw','custom-required','',''),(684,'priv','de','custom-restore','',''),(684,'priv','en','custom-restore','',''),(684,'priv','fr','custom-restore','',''),(684,'priv','zh-cn','custom-restore','',''),(684,'priv','zh-tw','custom-restore','',''),(685,'priv','de','custom-flow','',''),(685,'priv','en','custom-flow','',''),(685,'priv','fr','custom-flow','',''),(685,'priv','zh-cn','custom-flow','',''),(685,'priv','zh-tw','custom-flow','',''),(687,'priv','de','custom-timezone','',''),(687,'priv','en','custom-timezone','',''),(687,'priv','fr','custom-timezone','',''),(687,'priv','zh-cn','custom-timezone','',''),(687,'priv','zh-tw','custom-timezone','',''),(688,'priv','de','custom-estimate','',''),(688,'priv','en','custom-estimate','',''),(688,'priv','fr','custom-estimate','',''),(688,'priv','zh-cn','custom-estimate','',''),(688,'priv','zh-tw','custom-estimate','',''),(689,'priv','de','custom-editStoryConcept','',''),(689,'priv','en','custom-editStoryConcept','',''),(689,'priv','fr','custom-editStoryConcept','',''),(689,'priv','zh-cn','custom-editStoryConcept','',''),(689,'priv','zh-tw','custom-editStoryConcept','',''),(690,'priv','de','custom-browseStoryConcept','',''),(690,'priv','en','custom-browseStoryConcept','',''),(690,'priv','fr','custom-browseStoryConcept','',''),(690,'priv','zh-cn','custom-browseStoryConcept','',''),(690,'priv','zh-tw','custom-browseStoryConcept','',''),(691,'priv','de','custom-setDefaultConcept','',''),(691,'priv','en','custom-setDefaultConcept','',''),(691,'priv','fr','custom-setDefaultConcept','',''),(691,'priv','zh-cn','custom-setDefaultConcept','',''),(691,'priv','zh-tw','custom-setDefaultConcept','',''),(692,'priv','de','custom-deleteStoryConcept','',''),(692,'priv','en','custom-deleteStoryConcept','',''),(692,'priv','fr','custom-deleteStoryConcept','',''),(692,'priv','zh-cn','custom-deleteStoryConcept','',''),(692,'priv','zh-tw','custom-deleteStoryConcept','',''),(693,'priv','de','custom-kanban','',''),(693,'priv','en','custom-kanban','',''),(693,'priv','fr','custom-kanban','',''),(693,'priv','zh-cn','custom-kanban','',''),(693,'priv','zh-tw','custom-kanban','',''),(694,'priv','de','custom-code','',''),(694,'priv','en','custom-code','',''),(694,'priv','fr','custom-code','',''),(694,'priv','zh-cn','custom-code','',''),(694,'priv','zh-tw','custom-code','',''),(695,'priv','de','custom-hours','',''),(695,'priv','en','custom-hours','',''),(695,'priv','fr','custom-hours','',''),(695,'priv','zh-cn','custom-hours','',''),(695,'priv','zh-tw','custom-hours','',''),(696,'priv','de','custom-percent','',''),(696,'priv','en','custom-percent','',''),(696,'priv','fr','custom-percent','',''),(696,'priv','zh-cn','custom-percent','',''),(696,'priv','zh-tw','custom-percent','',''),(697,'priv','de','custom-setStoryConcept','',''),(697,'priv','en','custom-setStoryConcept','',''),(697,'priv','fr','custom-setStoryConcept','',''),(697,'priv','zh-cn','custom-setStoryConcept','',''),(697,'priv','zh-tw','custom-setStoryConcept','',''),(698,'priv','de','custom-libreOffice','',''),(698,'priv','en','custom-libreOffice','',''),(698,'priv','fr','custom-libreOffice','',''),(698,'priv','zh-cn','custom-libreOffice','',''),(698,'priv','zh-tw','custom-libreOffice','',''),(699,'priv','de','action-trashAction','',''),(699,'priv','en','action-trashAction','',''),(699,'priv','fr','action-trashAction','',''),(699,'priv','zh-cn','action-trashAction','',''),(699,'priv','zh-tw','action-trashAction','',''),(700,'priv','de','action-undeleteAction','',''),(700,'priv','en','action-undeleteAction','',''),(700,'priv','fr','action-undeleteAction','',''),(700,'priv','zh-cn','action-undeleteAction','',''),(700,'priv','zh-tw','action-undeleteAction','',''),(701,'priv','de','action-hideOneAction','',''),(701,'priv','en','action-hideOneAction','',''),(701,'priv','fr','action-hideOneAction','',''),(701,'priv','zh-cn','action-hideOneAction','',''),(701,'priv','zh-tw','action-hideOneAction','',''),(702,'priv','de','action-hideAll','',''),(702,'priv','en','action-hideAll','',''),(702,'priv','fr','action-hideAll','',''),(702,'priv','zh-cn','action-hideAll','',''),(702,'priv','zh-tw','action-hideAll','',''),(703,'priv','de','action-comment','',''),(703,'priv','en','action-comment','',''),(703,'priv','fr','action-comment','',''),(703,'priv','zh-cn','action-comment','',''),(703,'priv','zh-tw','action-comment','',''),(704,'priv','de','action-editComment','',''),(704,'priv','en','action-editComment','',''),(704,'priv','fr','action-editComment','',''),(704,'priv','zh-cn','action-editComment','',''),(704,'priv','zh-tw','action-editComment','',''),(705,'priv','de','mail-index','',''),(705,'priv','en','mail-index','',''),(705,'priv','fr','mail-index','',''),(705,'priv','zh-cn','mail-index','',''),(705,'priv','zh-tw','mail-index','',''),(706,'priv','de','mail-detectAction','',''),(706,'priv','en','mail-detectAction','',''),(706,'priv','fr','mail-detectAction','',''),(706,'priv','zh-cn','mail-detectAction','',''),(706,'priv','zh-tw','mail-detectAction','',''),(707,'priv','de','mail-edit','',''),(707,'priv','en','mail-edit','',''),(707,'priv','fr','mail-edit','',''),(707,'priv','zh-cn','mail-edit','',''),(707,'priv','zh-tw','mail-edit','',''),(708,'priv','de','mail-saveAction','',''),(708,'priv','en','mail-saveAction','',''),(708,'priv','fr','mail-saveAction','',''),(708,'priv','zh-cn','mail-saveAction','',''),(708,'priv','zh-tw','mail-saveAction','',''),(709,'priv','de','mail-test','',''),(709,'priv','en','mail-test','',''),(709,'priv','fr','mail-test','',''),(709,'priv','zh-cn','mail-test','',''),(709,'priv','zh-tw','mail-test','',''),(710,'priv','de','mail-resetAction','',''),(710,'priv','en','mail-resetAction','',''),(710,'priv','fr','mail-resetAction','',''),(710,'priv','zh-cn','mail-resetAction','',''),(710,'priv','zh-tw','mail-resetAction','',''),(711,'priv','de','mail-browse','',''),(711,'priv','en','mail-browse','',''),(711,'priv','fr','mail-browse','',''),(711,'priv','zh-cn','mail-browse','',''),(711,'priv','zh-tw','mail-browse','',''),(712,'priv','de','mail-delete','',''),(712,'priv','en','mail-delete','',''),(712,'priv','fr','mail-delete','',''),(712,'priv','zh-cn','mail-delete','',''),(712,'priv','zh-tw','mail-delete','',''),(713,'priv','de','mail-batchDelete','',''),(713,'priv','en','mail-batchDelete','',''),(713,'priv','fr','mail-batchDelete','',''),(713,'priv','zh-cn','mail-batchDelete','',''),(713,'priv','zh-tw','mail-batchDelete','',''),(714,'priv','de','mail-resendAction','',''),(714,'priv','en','mail-resendAction','',''),(714,'priv','fr','mail-resendAction','',''),(714,'priv','zh-cn','mail-resendAction','',''),(714,'priv','zh-tw','mail-resendAction','',''),(715,'priv','de','sms-index','',''),(715,'priv','en','sms-index','',''),(715,'priv','fr','sms-index','',''),(715,'priv','zh-cn','sms-index','',''),(715,'priv','zh-tw','sms-index','',''),(716,'priv','de','sms-test','',''),(716,'priv','en','sms-test','',''),(716,'priv','fr','sms-test','',''),(716,'priv','zh-cn','sms-test','',''),(716,'priv','zh-tw','sms-test','',''),(717,'priv','de','sms-reset','',''),(717,'priv','en','sms-reset','',''),(717,'priv','fr','sms-reset','',''),(717,'priv','zh-cn','sms-reset','',''),(717,'priv','zh-tw','sms-reset','',''),(718,'priv','de','svn-diff','',''),(718,'priv','en','svn-diff','',''),(718,'priv','fr','svn-diff','',''),(718,'priv','zh-cn','svn-diff','',''),(718,'priv','zh-tw','svn-diff','',''),(719,'priv','de','svn-cat','',''),(719,'priv','en','svn-cat','',''),(719,'priv','fr','svn-cat','',''),(719,'priv','zh-cn','svn-cat','',''),(719,'priv','zh-tw','svn-cat','',''),(720,'priv','de','svn-apiSync','',''),(720,'priv','en','svn-apiSync','',''),(720,'priv','fr','svn-apiSync','',''),(720,'priv','zh-cn','svn-apiSync','',''),(720,'priv','zh-tw','svn-apiSync','',''),(721,'priv','de','git-diff','',''),(721,'priv','en','git-diff','',''),(721,'priv','fr','git-diff','',''),(721,'priv','zh-cn','git-diff','',''),(721,'priv','zh-tw','git-diff','',''),(722,'priv','de','git-cat','',''),(722,'priv','en','git-cat','',''),(722,'priv','fr','git-cat','',''),(722,'priv','zh-cn','git-cat','',''),(722,'priv','zh-tw','git-cat','',''),(723,'priv','de','git-apiSync','',''),(723,'priv','en','git-apiSync','',''),(723,'priv','fr','git-apiSync','',''),(723,'priv','zh-cn','git-apiSync','',''),(723,'priv','zh-tw','git-apiSync','',''),(724,'priv','de','search-buildForm','',''),(724,'priv','en','search-buildForm','',''),(724,'priv','fr','search-buildForm','',''),(724,'priv','zh-cn','search-buildForm','',''),(724,'priv','zh-tw','search-buildForm','',''),(725,'priv','de','search-buildQuery','',''),(725,'priv','en','search-buildQuery','',''),(725,'priv','fr','search-buildQuery','',''),(725,'priv','zh-cn','search-buildQuery','',''),(725,'priv','zh-tw','search-buildQuery','',''),(726,'priv','de','search-saveQuery','',''),(726,'priv','en','search-saveQuery','',''),(726,'priv','fr','search-saveQuery','',''),(726,'priv','zh-cn','search-saveQuery','',''),(726,'priv','zh-tw','search-saveQuery','',''),(727,'priv','de','search-deleteQuery','',''),(727,'priv','en','search-deleteQuery','',''),(727,'priv','fr','search-deleteQuery','',''),(727,'priv','zh-cn','search-deleteQuery','',''),(727,'priv','zh-tw','search-deleteQuery','',''),(728,'priv','de','search-select','',''),(728,'priv','en','search-select','',''),(728,'priv','fr','search-select','',''),(728,'priv','zh-cn','search-select','',''),(728,'priv','zh-tw','search-select','',''),(729,'priv','de','search-index','',''),(729,'priv','en','search-index','',''),(729,'priv','fr','search-index','',''),(729,'priv','zh-cn','search-index','',''),(729,'priv','zh-tw','search-index','',''),(730,'priv','de','search-buildIndex','',''),(730,'priv','en','search-buildIndex','',''),(730,'priv','fr','search-buildIndex','',''),(730,'priv','zh-cn','search-buildIndex','',''),(730,'priv','zh-tw','search-buildIndex','',''),(731,'priv','de','tree-browse','',''),(731,'priv','en','tree-browse','',''),(731,'priv','fr','tree-browse','',''),(731,'priv','zh-cn','tree-browse','',''),(731,'priv','zh-tw','tree-browse','',''),(732,'priv','de','tree-browseTask','',''),(732,'priv','en','tree-browseTask','',''),(732,'priv','fr','tree-browseTask','',''),(732,'priv','zh-cn','tree-browseTask','',''),(732,'priv','zh-tw','tree-browseTask','',''),(733,'priv','de','tree-updateOrder','',''),(733,'priv','en','tree-updateOrder','',''),(733,'priv','fr','tree-updateOrder','',''),(733,'priv','zh-cn','tree-updateOrder','',''),(733,'priv','zh-tw','tree-updateOrder','',''),(734,'priv','de','tree-manageChild','',''),(734,'priv','en','tree-manageChild','',''),(734,'priv','fr','tree-manageChild','',''),(734,'priv','zh-cn','tree-manageChild','',''),(734,'priv','zh-tw','tree-manageChild','',''),(735,'priv','de','tree-edit','',''),(735,'priv','en','tree-edit','',''),(735,'priv','fr','tree-edit','',''),(735,'priv','zh-cn','tree-edit','',''),(735,'priv','zh-tw','tree-edit','',''),(736,'priv','de','tree-delete','',''),(736,'priv','en','tree-delete','',''),(736,'priv','fr','tree-delete','',''),(736,'priv','zh-cn','tree-delete','',''),(736,'priv','zh-tw','tree-delete','',''),(737,'priv','de','tree-editHost','',''),(737,'priv','en','tree-editHost','',''),(737,'priv','fr','tree-editHost','',''),(737,'priv','zh-cn','tree-editHost','',''),(737,'priv','zh-tw','tree-editHost','',''),(738,'priv','de','tree-fix','',''),(738,'priv','en','tree-fix','',''),(738,'priv','fr','tree-fix','',''),(738,'priv','zh-cn','tree-fix','',''),(738,'priv','zh-tw','tree-fix','',''),(739,'priv','de','tree-groupMaintenance','',''),(739,'priv','en','tree-groupMaintenance','',''),(739,'priv','fr','tree-groupMaintenance','',''),(739,'priv','zh-cn','tree-groupMaintenance','',''),(739,'priv','zh-tw','tree-groupMaintenance','',''),(758,'priv','de','file-download','',''),(758,'priv','en','file-download','',''),(758,'priv','fr','file-download','',''),(758,'priv','zh-cn','file-download','',''),(758,'priv','zh-tw','file-download','',''),(759,'priv','de','file-edit','',''),(759,'priv','en','file-edit','',''),(759,'priv','fr','file-edit','',''),(759,'priv','zh-cn','file-edit','',''),(759,'priv','zh-tw','file-edit','',''),(760,'priv','de','file-delete','',''),(760,'priv','en','file-delete','',''),(760,'priv','fr','file-delete','',''),(760,'priv','zh-cn','file-delete','',''),(760,'priv','zh-tw','file-delete','',''),(761,'priv','de','file-uploadImages','',''),(761,'priv','en','file-uploadImages','',''),(761,'priv','fr','file-uploadImages','',''),(761,'priv','zh-cn','file-uploadImages','',''),(761,'priv','zh-tw','file-uploadImages','',''),(762,'priv','de','file-setPublic','',''),(762,'priv','en','file-setPublic','',''),(762,'priv','fr','file-setPublic','',''),(762,'priv','zh-cn','file-setPublic','',''),(762,'priv','zh-tw','file-setPublic','',''),(763,'priv','de','misc-ping','',''),(763,'priv','en','misc-ping','',''),(763,'priv','fr','misc-ping','',''),(763,'priv','zh-cn','misc-ping','',''),(763,'priv','zh-tw','misc-ping','',''),(764,'priv','de','backup-index','',''),(764,'priv','en','backup-index','',''),(764,'priv','fr','backup-index','',''),(764,'priv','zh-cn','backup-index','',''),(764,'priv','zh-tw','backup-index','',''),(765,'priv','de','backup-backup','',''),(765,'priv','en','backup-backup','',''),(765,'priv','fr','backup-backup','',''),(765,'priv','zh-cn','backup-backup','',''),(765,'priv','zh-tw','backup-backup','',''),(766,'priv','de','backup-restoreAction','',''),(766,'priv','en','backup-restoreAction','',''),(766,'priv','fr','backup-restoreAction','',''),(766,'priv','zh-cn','backup-restoreAction','',''),(766,'priv','zh-tw','backup-restoreAction','',''),(767,'priv','de','backup-delete','',''),(767,'priv','en','backup-delete','',''),(767,'priv','fr','backup-delete','',''),(767,'priv','zh-cn','backup-delete','',''),(767,'priv','zh-tw','backup-delete','',''),(768,'priv','de','backup-settingAction','',''),(768,'priv','en','backup-settingAction','',''),(768,'priv','fr','backup-settingAction','',''),(768,'priv','zh-cn','backup-settingAction','',''),(768,'priv','zh-tw','backup-settingAction','',''),(769,'priv','de','backup-rmPHPHeader','',''),(769,'priv','en','backup-rmPHPHeader','',''),(769,'priv','fr','backup-rmPHPHeader','',''),(769,'priv','zh-cn','backup-rmPHPHeader','',''),(769,'priv','zh-tw','backup-rmPHPHeader','',''),(770,'priv','de','backup-change','',''),(770,'priv','en','backup-change','',''),(770,'priv','fr','backup-change','',''),(770,'priv','zh-cn','backup-change','',''),(770,'priv','zh-tw','backup-change','',''),(771,'priv','de','cron-index','',''),(771,'priv','en','cron-index','',''),(771,'priv','fr','cron-index','',''),(771,'priv','zh-cn','cron-index','',''),(771,'priv','zh-tw','cron-index','',''),(772,'priv','de','cron-turnon','',''),(772,'priv','en','cron-turnon','',''),(772,'priv','fr','cron-turnon','',''),(772,'priv','zh-cn','cron-turnon','',''),(772,'priv','zh-tw','cron-turnon','',''),(773,'priv','de','cron-createAction','',''),(773,'priv','en','cron-createAction','',''),(773,'priv','fr','cron-createAction','',''),(773,'priv','zh-cn','cron-createAction','',''),(773,'priv','zh-tw','cron-createAction','',''),(774,'priv','de','cron-edit','',''),(774,'priv','en','cron-edit','',''),(774,'priv','fr','cron-edit','',''),(774,'priv','zh-cn','cron-edit','',''),(774,'priv','zh-tw','cron-edit','',''),(775,'priv','de','cron-toggle','',''),(775,'priv','en','cron-toggle','',''),(775,'priv','fr','cron-toggle','',''),(775,'priv','zh-cn','cron-toggle','',''),(775,'priv','zh-tw','cron-toggle','',''),(776,'priv','de','cron-delete','',''),(776,'priv','en','cron-delete','',''),(776,'priv','fr','cron-delete','',''),(776,'priv','zh-cn','cron-delete','',''),(776,'priv','zh-tw','cron-delete','',''),(777,'priv','de','cron-restart','',''),(777,'priv','en','cron-restart','',''),(777,'priv','fr','cron-restart','',''),(777,'priv','zh-cn','cron-restart','',''),(777,'priv','zh-tw','cron-restart','',''),(778,'priv','de','dev-api','',''),(778,'priv','en','dev-api','',''),(778,'priv','fr','dev-api','',''),(778,'priv','zh-cn','dev-api','',''),(778,'priv','zh-tw','dev-api','',''),(779,'priv','de','dev-db','',''),(779,'priv','en','dev-db','',''),(779,'priv','fr','dev-db','',''),(779,'priv','zh-cn','dev-db','',''),(779,'priv','zh-tw','dev-db','',''),(781,'priv','de','editor-index','',''),(781,'priv','en','editor-index','',''),(781,'priv','fr','editor-index','',''),(781,'priv','zh-cn','editor-index','',''),(781,'priv','zh-tw','editor-index','',''),(782,'priv','de','editor-extend','',''),(782,'priv','en','editor-extend','',''),(782,'priv','fr','editor-extend','',''),(782,'priv','zh-cn','editor-extend','',''),(782,'priv','zh-tw','editor-extend','',''),(783,'priv','de','editor-edit','',''),(783,'priv','en','editor-edit','',''),(783,'priv','fr','editor-edit','',''),(783,'priv','zh-cn','editor-edit','',''),(783,'priv','zh-tw','editor-edit','',''),(784,'priv','de','editor-newPage','',''),(784,'priv','en','editor-newPage','',''),(784,'priv','fr','editor-newPage','',''),(784,'priv','zh-cn','editor-newPage','',''),(784,'priv','zh-tw','editor-newPage','',''),(785,'priv','de','editor-save','',''),(785,'priv','en','editor-save','',''),(785,'priv','fr','editor-save','',''),(785,'priv','zh-cn','editor-save','',''),(785,'priv','zh-tw','editor-save','',''),(786,'priv','de','editor-delete','',''),(786,'priv','en','editor-delete','',''),(786,'priv','fr','editor-delete','',''),(786,'priv','zh-cn','editor-delete','',''),(786,'priv','zh-tw','editor-delete','',''),(787,'priv','de','issue-browse','',''),(787,'priv','en','issue-browse','',''),(787,'priv','fr','issue-browse','',''),(787,'priv','zh-cn','issue-browse','',''),(787,'priv','zh-tw','issue-browse','',''),(788,'priv','de','issue-create','',''),(788,'priv','en','issue-create','',''),(788,'priv','fr','issue-create','',''),(788,'priv','zh-cn','issue-create','',''),(788,'priv','zh-tw','issue-create','',''),(789,'priv','de','issue-batchCreate','',''),(789,'priv','en','issue-batchCreate','',''),(789,'priv','fr','issue-batchCreate','',''),(789,'priv','zh-cn','issue-batchCreate','',''),(789,'priv','zh-tw','issue-batchCreate','',''),(790,'priv','de','issue-deleteAction','',''),(790,'priv','en','issue-deleteAction','',''),(790,'priv','fr','issue-deleteAction','',''),(790,'priv','zh-cn','issue-deleteAction','',''),(790,'priv','zh-tw','issue-deleteAction','',''),(791,'priv','de','issue-editAction','',''),(791,'priv','en','issue-editAction','',''),(791,'priv','fr','issue-editAction','',''),(791,'priv','zh-cn','issue-editAction','',''),(791,'priv','zh-tw','issue-editAction','',''),(792,'priv','de','issue-confirmAction','',''),(792,'priv','en','issue-confirmAction','',''),(792,'priv','fr','issue-confirmAction','',''),(792,'priv','zh-cn','issue-confirmAction','',''),(792,'priv','zh-tw','issue-confirmAction','',''),(793,'priv','de','issue-assignToAction','',''),(793,'priv','en','issue-assignToAction','',''),(793,'priv','fr','issue-assignToAction','',''),(793,'priv','zh-cn','issue-assignToAction','',''),(793,'priv','zh-tw','issue-assignToAction','',''),(794,'priv','de','issue-closeAction','',''),(794,'priv','en','issue-closeAction','',''),(794,'priv','fr','issue-closeAction','',''),(794,'priv','zh-cn','issue-closeAction','',''),(794,'priv','zh-tw','issue-closeAction','',''),(795,'priv','de','issue-cancelAction','',''),(795,'priv','en','issue-cancelAction','',''),(795,'priv','fr','issue-cancelAction','',''),(795,'priv','zh-cn','issue-cancelAction','',''),(795,'priv','zh-tw','issue-cancelAction','',''),(796,'priv','de','issue-activateAction','',''),(796,'priv','en','issue-activateAction','',''),(796,'priv','fr','issue-activateAction','',''),(796,'priv','zh-cn','issue-activateAction','',''),(796,'priv','zh-tw','issue-activateAction','',''),(797,'priv','de','issue-resolveAction','',''),(797,'priv','en','issue-resolveAction','',''),(797,'priv','fr','issue-resolveAction','',''),(797,'priv','zh-cn','issue-resolveAction','',''),(797,'priv','zh-tw','issue-resolveAction','',''),(798,'priv','de','issue-view','',''),(798,'priv','en','issue-view','',''),(798,'priv','fr','issue-view','',''),(798,'priv','zh-cn','issue-view','',''),(798,'priv','zh-tw','issue-view','',''),(799,'priv','de','issue-exportAction','',''),(799,'priv','en','issue-exportAction','',''),(799,'priv','fr','issue-exportAction','',''),(799,'priv','zh-cn','issue-exportAction','',''),(799,'priv','zh-tw','issue-exportAction','',''),(800,'priv','de','issue-importToLib','',''),(800,'priv','en','issue-importToLib','',''),(800,'priv','fr','issue-importToLib','',''),(800,'priv','zh-cn','issue-importToLib','',''),(800,'priv','zh-tw','issue-importToLib','',''),(801,'priv','de','issue-batchImportToLib','',''),(801,'priv','en','issue-batchImportToLib','',''),(801,'priv','fr','issue-batchImportToLib','',''),(801,'priv','zh-cn','issue-batchImportToLib','',''),(801,'priv','zh-tw','issue-batchImportToLib','',''),(802,'priv','de','issue-importFromLib','',''),(802,'priv','en','issue-importFromLib','',''),(802,'priv','fr','issue-importFromLib','',''),(802,'priv','zh-cn','issue-importFromLib','',''),(802,'priv','zh-tw','issue-importFromLib','',''),(803,'priv','de','risk-browse','',''),(803,'priv','en','risk-browse','',''),(803,'priv','fr','risk-browse','',''),(803,'priv','zh-cn','risk-browse','',''),(803,'priv','zh-tw','risk-browse','',''),(804,'priv','de','risk-create','',''),(804,'priv','en','risk-create','',''),(804,'priv','fr','risk-create','',''),(804,'priv','zh-cn','risk-create','',''),(804,'priv','zh-tw','risk-create','',''),(805,'priv','de','risk-edit','',''),(805,'priv','en','risk-edit','',''),(805,'priv','fr','risk-edit','',''),(805,'priv','zh-cn','risk-edit','',''),(805,'priv','zh-tw','risk-edit','',''),(806,'priv','de','risk-deleteAction','',''),(806,'priv','en','risk-deleteAction','',''),(806,'priv','fr','risk-deleteAction','',''),(806,'priv','zh-cn','risk-deleteAction','',''),(806,'priv','zh-tw','risk-deleteAction','',''),(807,'priv','de','risk-activateAction','',''),(807,'priv','en','risk-activateAction','',''),(807,'priv','fr','risk-activateAction','',''),(807,'priv','zh-cn','risk-activateAction','',''),(807,'priv','zh-tw','risk-activateAction','',''),(808,'priv','de','risk-closeAction','',''),(808,'priv','en','risk-closeAction','',''),(808,'priv','fr','risk-closeAction','',''),(808,'priv','zh-cn','risk-closeAction','',''),(808,'priv','zh-tw','risk-closeAction','',''),(809,'priv','de','risk-hangupAction','',''),(809,'priv','en','risk-hangupAction','',''),(809,'priv','fr','risk-hangupAction','',''),(809,'priv','zh-cn','risk-hangupAction','',''),(809,'priv','zh-tw','risk-hangupAction','',''),(810,'priv','de','risk-batchCreate','',''),(810,'priv','en','risk-batchCreate','',''),(810,'priv','fr','risk-batchCreate','',''),(810,'priv','zh-cn','risk-batchCreate','',''),(810,'priv','zh-tw','risk-batchCreate','',''),(811,'priv','de','risk-cancelAction','',''),(811,'priv','en','risk-cancelAction','',''),(811,'priv','fr','risk-cancelAction','',''),(811,'priv','zh-cn','risk-cancelAction','',''),(811,'priv','zh-tw','risk-cancelAction','',''),(812,'priv','de','risk-trackAction','',''),(812,'priv','en','risk-trackAction','',''),(812,'priv','fr','risk-trackAction','',''),(812,'priv','zh-cn','risk-trackAction','',''),(812,'priv','zh-tw','risk-trackAction','',''),(813,'priv','de','risk-view','',''),(813,'priv','en','risk-view','',''),(813,'priv','fr','risk-view','',''),(813,'priv','zh-cn','risk-view','',''),(813,'priv','zh-tw','risk-view','',''),(814,'priv','de','risk-assignToAction','',''),(814,'priv','en','risk-assignToAction','',''),(814,'priv','fr','risk-assignToAction','',''),(814,'priv','zh-cn','risk-assignToAction','',''),(814,'priv','zh-tw','risk-assignToAction','',''),(815,'priv','de','risk-importToLib','',''),(815,'priv','en','risk-importToLib','',''),(815,'priv','fr','risk-importToLib','',''),(815,'priv','zh-cn','risk-importToLib','',''),(815,'priv','zh-tw','risk-importToLib','',''),(816,'priv','de','risk-batchImportToLib','',''),(816,'priv','en','risk-batchImportToLib','',''),(816,'priv','fr','risk-batchImportToLib','',''),(816,'priv','zh-cn','risk-batchImportToLib','',''),(816,'priv','zh-tw','risk-batchImportToLib','',''),(817,'priv','de','risk-importFromLib','',''),(817,'priv','en','risk-importFromLib','',''),(817,'priv','fr','risk-importFromLib','',''),(817,'priv','zh-cn','risk-importFromLib','',''),(817,'priv','zh-tw','risk-importFromLib','',''),(818,'priv','de','risk-exportAction','',''),(818,'priv','en','risk-exportAction','',''),(818,'priv','fr','risk-exportAction','',''),(818,'priv','zh-cn','risk-exportAction','',''),(818,'priv','zh-tw','risk-exportAction','',''),(819,'priv','de','mr-create','',''),(819,'priv','en','mr-create','',''),(819,'priv','fr','mr-create','',''),(819,'priv','zh-cn','mr-create','',''),(819,'priv','zh-tw','mr-create','',''),(820,'priv','de','mr-browseAction','',''),(820,'priv','en','mr-browseAction','',''),(820,'priv','fr','mr-browseAction','',''),(820,'priv','zh-cn','mr-browseAction','',''),(820,'priv','zh-tw','mr-browseAction','',''),(821,'priv','de','mr-edit','',''),(821,'priv','en','mr-edit','',''),(821,'priv','fr','mr-edit','',''),(821,'priv','zh-cn','mr-edit','',''),(821,'priv','zh-tw','mr-edit','',''),(822,'priv','de','mr-delete','',''),(822,'priv','en','mr-delete','',''),(822,'priv','fr','mr-delete','',''),(822,'priv','zh-cn','mr-delete','',''),(822,'priv','zh-tw','mr-delete','',''),(823,'priv','de','mr-viewAction','',''),(823,'priv','en','mr-viewAction','',''),(823,'priv','fr','mr-viewAction','',''),(823,'priv','zh-cn','mr-viewAction','',''),(823,'priv','zh-tw','mr-viewAction','',''),(824,'priv','de','mr-accept','',''),(824,'priv','en','mr-accept','',''),(824,'priv','fr','mr-accept','',''),(824,'priv','zh-cn','mr-accept','',''),(824,'priv','zh-tw','mr-accept','',''),(825,'priv','de','mr-viewDiff','',''),(825,'priv','en','mr-viewDiff','',''),(825,'priv','fr','mr-viewDiff','',''),(825,'priv','zh-cn','mr-viewDiff','',''),(825,'priv','zh-tw','mr-viewDiff','',''),(826,'priv','de','mr-linkList','',''),(826,'priv','en','mr-linkList','',''),(826,'priv','fr','mr-linkList','',''),(826,'priv','zh-cn','mr-linkList','',''),(826,'priv','zh-tw','mr-linkList','',''),(827,'priv','de','mr-linkStory','',''),(827,'priv','en','mr-linkStory','',''),(827,'priv','fr','mr-linkStory','',''),(827,'priv','zh-cn','mr-linkStory','',''),(827,'priv','zh-tw','mr-linkStory','',''),(828,'priv','de','mr-linkBug','',''),(828,'priv','en','mr-linkBug','',''),(828,'priv','fr','mr-linkBug','',''),(828,'priv','zh-cn','mr-linkBug','',''),(828,'priv','zh-tw','mr-linkBug','',''),(829,'priv','de','mr-linkTask','',''),(829,'priv','en','mr-linkTask','',''),(829,'priv','fr','mr-linkTask','',''),(829,'priv','zh-cn','mr-linkTask','',''),(829,'priv','zh-tw','mr-linkTask','',''),(830,'priv','de','mr-unlink','',''),(830,'priv','en','mr-unlink','',''),(830,'priv','fr','mr-unlink','',''),(830,'priv','zh-cn','mr-unlink','',''),(830,'priv','zh-tw','mr-unlink','',''),(831,'priv','de','mr-approval','',''),(831,'priv','en','mr-approval','',''),(831,'priv','fr','mr-approval','',''),(831,'priv','zh-cn','mr-approval','',''),(831,'priv','zh-tw','mr-approval','',''),(832,'priv','de','mr-close','',''),(832,'priv','en','mr-close','',''),(832,'priv','fr','mr-close','',''),(832,'priv','zh-cn','mr-close','',''),(832,'priv','zh-tw','mr-close','',''),(833,'priv','de','mr-reopen','',''),(833,'priv','en','mr-reopen','',''),(833,'priv','fr','mr-reopen','',''),(833,'priv','zh-cn','mr-reopen','',''),(833,'priv','zh-tw','mr-reopen','',''),(834,'priv','de','mr-addReview','',''),(834,'priv','en','mr-addReview','',''),(834,'priv','fr','mr-addReview','',''),(834,'priv','zh-cn','mr-addReview','',''),(834,'priv','zh-tw','mr-addReview','',''),(835,'priv','de','budget-browseAction','',''),(835,'priv','en','budget-browseAction','',''),(835,'priv','fr','budget-browseAction','',''),(835,'priv','zh-cn','budget-browseAction','',''),(835,'priv','zh-tw','budget-browseAction','',''),(836,'priv','de','budget-summaryAction','',''),(836,'priv','en','budget-summaryAction','',''),(836,'priv','fr','budget-summaryAction','',''),(836,'priv','zh-cn','budget-summaryAction','',''),(836,'priv','zh-tw','budget-summaryAction','',''),(837,'priv','de','budget-createAction','',''),(837,'priv','en','budget-createAction','',''),(837,'priv','fr','budget-createAction','',''),(837,'priv','zh-cn','budget-createAction','',''),(837,'priv','zh-tw','budget-createAction','',''),(838,'priv','de','budget-batchCreate','',''),(838,'priv','en','budget-batchCreate','',''),(838,'priv','fr','budget-batchCreate','',''),(838,'priv','zh-cn','budget-batchCreate','',''),(838,'priv','zh-tw','budget-batchCreate','',''),(839,'priv','de','budget-editAction','',''),(839,'priv','en','budget-editAction','',''),(839,'priv','fr','budget-editAction','',''),(839,'priv','zh-cn','budget-editAction','',''),(839,'priv','zh-tw','budget-editAction','',''),(840,'priv','de','budget-viewAction','',''),(840,'priv','en','budget-viewAction','',''),(840,'priv','fr','budget-viewAction','',''),(840,'priv','zh-cn','budget-viewAction','',''),(840,'priv','zh-tw','budget-viewAction','',''),(841,'priv','de','budget-deleteAction','',''),(841,'priv','en','budget-deleteAction','',''),(841,'priv','fr','budget-deleteAction','',''),(841,'priv','zh-cn','budget-deleteAction','',''),(841,'priv','zh-tw','budget-deleteAction','',''),(842,'priv','de','workestimation-index','',''),(842,'priv','en','workestimation-index','',''),(842,'priv','fr','workestimation-index','',''),(842,'priv','zh-cn','workestimation-index','',''),(842,'priv','zh-tw','workestimation-index','',''),(843,'priv','de','durationestimation-indexAction','',''),(843,'priv','en','durationestimation-indexAction','',''),(843,'priv','fr','durationestimation-indexAction','',''),(843,'priv','zh-cn','durationestimation-indexAction','',''),(843,'priv','zh-tw','durationestimation-indexAction','',''),(844,'priv','de','durationestimation-create','',''),(844,'priv','en','durationestimation-create','',''),(844,'priv','fr','durationestimation-create','',''),(844,'priv','zh-cn','durationestimation-create','',''),(844,'priv','zh-tw','durationestimation-create','',''),(845,'priv','de','holiday-browse','',''),(845,'priv','en','holiday-browse','',''),(845,'priv','fr','holiday-browse','',''),(845,'priv','zh-cn','holiday-browse','',''),(845,'priv','zh-tw','holiday-browse','',''),(846,'priv','de','holiday-createAction','',''),(846,'priv','en','holiday-createAction','',''),(846,'priv','fr','holiday-createAction','',''),(846,'priv','zh-cn','holiday-createAction','',''),(846,'priv','zh-tw','holiday-createAction','',''),(847,'priv','de','holiday-editAction','',''),(847,'priv','en','holiday-editAction','',''),(847,'priv','fr','holiday-editAction','',''),(847,'priv','zh-cn','holiday-editAction','',''),(847,'priv','zh-tw','holiday-editAction','',''),(848,'priv','de','holiday-deleteAction','',''),(848,'priv','en','holiday-deleteAction','',''),(848,'priv','fr','holiday-deleteAction','',''),(848,'priv','zh-cn','holiday-deleteAction','',''),(848,'priv','zh-tw','holiday-deleteAction','',''),(849,'priv','de','holiday-importAction','',''),(849,'priv','en','holiday-importAction','',''),(849,'priv','fr','holiday-importAction','',''),(849,'priv','zh-cn','holiday-importAction','',''),(849,'priv','zh-tw','holiday-importAction','',''),(850,'priv','de','weekly-index','',''),(850,'priv','en','weekly-index','',''),(850,'priv','fr','weekly-index','',''),(850,'priv','zh-cn','weekly-index','',''),(850,'priv','zh-tw','weekly-index','',''),(851,'priv','de','weekly-exportWeeklyReport','',''),(851,'priv','en','weekly-exportWeeklyReport','',''),(851,'priv','fr','weekly-exportWeeklyReport','',''),(851,'priv','zh-cn','weekly-exportWeeklyReport','',''),(851,'priv','zh-tw','weekly-exportWeeklyReport','',''),(852,'priv','de','opportunity-browse','',''),(852,'priv','en','opportunity-browse','',''),(852,'priv','fr','opportunity-browse','',''),(852,'priv','zh-cn','opportunity-browse','',''),(852,'priv','zh-tw','opportunity-browse','',''),(853,'priv','de','opportunity-create','',''),(853,'priv','en','opportunity-create','',''),(853,'priv','fr','opportunity-create','',''),(853,'priv','zh-cn','opportunity-create','',''),(853,'priv','zh-tw','opportunity-create','',''),(854,'priv','de','opportunity-edit','',''),(854,'priv','en','opportunity-edit','',''),(854,'priv','fr','opportunity-edit','',''),(854,'priv','zh-cn','opportunity-edit','',''),(854,'priv','zh-tw','opportunity-edit','',''),(855,'priv','de','opportunity-deleteAction','',''),(855,'priv','en','opportunity-deleteAction','',''),(855,'priv','fr','opportunity-deleteAction','',''),(855,'priv','zh-cn','opportunity-deleteAction','',''),(855,'priv','zh-tw','opportunity-deleteAction','',''),(856,'priv','de','opportunity-activateAction','',''),(856,'priv','en','opportunity-activateAction','',''),(856,'priv','fr','opportunity-activateAction','',''),(856,'priv','zh-cn','opportunity-activateAction','',''),(856,'priv','zh-tw','opportunity-activateAction','',''),(857,'priv','de','opportunity-closeAction','',''),(857,'priv','en','opportunity-closeAction','',''),(857,'priv','fr','opportunity-closeAction','',''),(857,'priv','zh-cn','opportunity-closeAction','',''),(857,'priv','zh-tw','opportunity-closeAction','',''),(858,'priv','de','opportunity-hangupAction','',''),(858,'priv','en','opportunity-hangupAction','',''),(858,'priv','fr','opportunity-hangupAction','',''),(858,'priv','zh-cn','opportunity-hangupAction','',''),(858,'priv','zh-tw','opportunity-hangupAction','',''),(859,'priv','de','opportunity-cancelAction','',''),(859,'priv','en','opportunity-cancelAction','',''),(859,'priv','fr','opportunity-cancelAction','',''),(859,'priv','zh-cn','opportunity-cancelAction','',''),(859,'priv','zh-tw','opportunity-cancelAction','',''),(860,'priv','de','opportunity-trackAction','',''),(860,'priv','en','opportunity-trackAction','',''),(860,'priv','fr','opportunity-trackAction','',''),(860,'priv','zh-cn','opportunity-trackAction','',''),(860,'priv','zh-tw','opportunity-trackAction','',''),(861,'priv','de','opportunity-view','',''),(861,'priv','en','opportunity-view','',''),(861,'priv','fr','opportunity-view','',''),(861,'priv','zh-cn','opportunity-view','',''),(861,'priv','zh-tw','opportunity-view','',''),(862,'priv','de','opportunity-assignToAction','',''),(862,'priv','en','opportunity-assignToAction','',''),(862,'priv','fr','opportunity-assignToAction','',''),(862,'priv','zh-cn','opportunity-assignToAction','',''),(862,'priv','zh-tw','opportunity-assignToAction','',''),(863,'priv','de','opportunity-batchCreate','',''),(863,'priv','en','opportunity-batchCreate','',''),(863,'priv','fr','opportunity-batchCreate','',''),(863,'priv','zh-cn','opportunity-batchCreate','',''),(863,'priv','zh-tw','opportunity-batchCreate','',''),(864,'priv','de','opportunity-batchEdit','',''),(864,'priv','en','opportunity-batchEdit','',''),(864,'priv','fr','opportunity-batchEdit','',''),(864,'priv','zh-cn','opportunity-batchEdit','',''),(864,'priv','zh-tw','opportunity-batchEdit','',''),(865,'priv','de','opportunity-batchAssignTo','',''),(865,'priv','en','opportunity-batchAssignTo','',''),(865,'priv','fr','opportunity-batchAssignTo','',''),(865,'priv','zh-cn','opportunity-batchAssignTo','',''),(865,'priv','zh-tw','opportunity-batchAssignTo','',''),(866,'priv','de','opportunity-batchClose','',''),(866,'priv','en','opportunity-batchClose','',''),(866,'priv','fr','opportunity-batchClose','',''),(866,'priv','zh-cn','opportunity-batchClose','',''),(866,'priv','zh-tw','opportunity-batchClose','',''),(867,'priv','de','opportunity-batchCancel','',''),(867,'priv','en','opportunity-batchCancel','',''),(867,'priv','fr','opportunity-batchCancel','',''),(867,'priv','zh-cn','opportunity-batchCancel','',''),(867,'priv','zh-tw','opportunity-batchCancel','',''),(868,'priv','de','opportunity-batchHangup','',''),(868,'priv','en','opportunity-batchHangup','',''),(868,'priv','fr','opportunity-batchHangup','',''),(868,'priv','zh-cn','opportunity-batchHangup','',''),(868,'priv','zh-tw','opportunity-batchHangup','',''),(869,'priv','de','opportunity-batchActivate','',''),(869,'priv','en','opportunity-batchActivate','',''),(869,'priv','fr','opportunity-batchActivate','',''),(869,'priv','zh-cn','opportunity-batchActivate','',''),(869,'priv','zh-tw','opportunity-batchActivate','',''),(870,'priv','de','opportunity-importToLib','',''),(870,'priv','en','opportunity-importToLib','',''),(870,'priv','fr','opportunity-importToLib','',''),(870,'priv','zh-cn','opportunity-importToLib','',''),(870,'priv','zh-tw','opportunity-importToLib','',''),(871,'priv','de','opportunity-batchImportToLib','',''),(871,'priv','en','opportunity-batchImportToLib','',''),(871,'priv','fr','opportunity-batchImportToLib','',''),(871,'priv','zh-cn','opportunity-batchImportToLib','',''),(871,'priv','zh-tw','opportunity-batchImportToLib','',''),(872,'priv','de','opportunity-importFromLib','',''),(872,'priv','en','opportunity-importFromLib','',''),(872,'priv','fr','opportunity-importFromLib','',''),(872,'priv','zh-cn','opportunity-importFromLib','',''),(872,'priv','zh-tw','opportunity-importFromLib','',''),(873,'priv','de','opportunity-exportAction','',''),(873,'priv','en','opportunity-exportAction','',''),(873,'priv','fr','opportunity-exportAction','',''),(873,'priv','zh-cn','opportunity-exportAction','',''),(873,'priv','zh-tw','opportunity-exportAction','',''),(874,'priv','de','trainplan-browse','',''),(874,'priv','en','trainplan-browse','',''),(874,'priv','fr','trainplan-browse','',''),(874,'priv','zh-cn','trainplan-browse','',''),(874,'priv','zh-tw','trainplan-browse','',''),(875,'priv','de','trainplan-create','',''),(875,'priv','en','trainplan-create','',''),(875,'priv','fr','trainplan-create','',''),(875,'priv','zh-cn','trainplan-create','',''),(875,'priv','zh-tw','trainplan-create','',''),(876,'priv','de','trainplan-edit','',''),(876,'priv','en','trainplan-edit','',''),(876,'priv','fr','trainplan-edit','',''),(876,'priv','zh-cn','trainplan-edit','',''),(876,'priv','zh-tw','trainplan-edit','',''),(877,'priv','de','trainplan-batchCreate','',''),(877,'priv','en','trainplan-batchCreate','',''),(877,'priv','fr','trainplan-batchCreate','',''),(877,'priv','zh-cn','trainplan-batchCreate','',''),(877,'priv','zh-tw','trainplan-batchCreate','',''),(878,'priv','de','trainplan-batchEdit','',''),(878,'priv','en','trainplan-batchEdit','',''),(878,'priv','fr','trainplan-batchEdit','',''),(878,'priv','zh-cn','trainplan-batchEdit','',''),(878,'priv','zh-tw','trainplan-batchEdit','',''),(879,'priv','de','trainplan-batchFinish','',''),(879,'priv','en','trainplan-batchFinish','',''),(879,'priv','fr','trainplan-batchFinish','',''),(879,'priv','zh-cn','trainplan-batchFinish','',''),(879,'priv','zh-tw','trainplan-batchFinish','',''),(880,'priv','de','trainplan-delete','',''),(880,'priv','en','trainplan-delete','',''),(880,'priv','fr','trainplan-delete','',''),(880,'priv','zh-cn','trainplan-delete','',''),(880,'priv','zh-tw','trainplan-delete','',''),(881,'priv','de','trainplan-finishAction','',''),(881,'priv','en','trainplan-finishAction','',''),(881,'priv','fr','trainplan-finishAction','',''),(881,'priv','zh-cn','trainplan-finishAction','',''),(881,'priv','zh-tw','trainplan-finishAction','',''),(882,'priv','de','trainplan-summaryAction','',''),(882,'priv','en','trainplan-summaryAction','',''),(882,'priv','fr','trainplan-summaryAction','',''),(882,'priv','zh-cn','trainplan-summaryAction','',''),(882,'priv','zh-tw','trainplan-summaryAction','',''),(883,'priv','de','trainplan-view','',''),(883,'priv','en','trainplan-view','',''),(883,'priv','fr','trainplan-view','',''),(883,'priv','zh-cn','trainplan-view','',''),(883,'priv','zh-tw','trainplan-view','',''),(884,'priv','de','nc-browse','',''),(884,'priv','en','nc-browse','',''),(884,'priv','fr','nc-browse','',''),(884,'priv','zh-cn','nc-browse','',''),(884,'priv','zh-tw','nc-browse','',''),(885,'priv','de','nc-create','',''),(885,'priv','en','nc-create','',''),(885,'priv','fr','nc-create','',''),(885,'priv','zh-cn','nc-create','',''),(885,'priv','zh-tw','nc-create','',''),(886,'priv','de','nc-edit','',''),(886,'priv','en','nc-edit','',''),(886,'priv','fr','nc-edit','',''),(886,'priv','zh-cn','nc-edit','',''),(886,'priv','zh-tw','nc-edit','',''),(887,'priv','de','nc-resolve','',''),(887,'priv','en','nc-resolve','',''),(887,'priv','fr','nc-resolve','',''),(887,'priv','zh-cn','nc-resolve','',''),(887,'priv','zh-tw','nc-resolve','',''),(888,'priv','de','nc-view','',''),(888,'priv','en','nc-view','',''),(888,'priv','fr','nc-view','',''),(888,'priv','zh-cn','nc-view','',''),(888,'priv','zh-tw','nc-view','',''),(889,'priv','de','nc-close','',''),(889,'priv','en','nc-close','',''),(889,'priv','fr','nc-close','',''),(889,'priv','zh-cn','nc-close','',''),(889,'priv','zh-tw','nc-close','',''),(890,'priv','de','nc-delete','',''),(890,'priv','en','nc-delete','',''),(890,'priv','fr','nc-delete','',''),(890,'priv','zh-cn','nc-delete','',''),(890,'priv','zh-tw','nc-delete','',''),(891,'priv','de','nc-assignTo','',''),(891,'priv','en','nc-assignTo','',''),(891,'priv','fr','nc-assignTo','',''),(891,'priv','zh-cn','nc-assignTo','',''),(891,'priv','zh-tw','nc-assignTo','',''),(892,'priv','de','nc-activate','',''),(892,'priv','en','nc-activate','',''),(892,'priv','fr','nc-activate','',''),(892,'priv','zh-cn','nc-activate','',''),(892,'priv','zh-tw','nc-activate','',''),(893,'priv','de','nc-exportAction','',''),(893,'priv','en','nc-exportAction','',''),(893,'priv','fr','nc-exportAction','',''),(893,'priv','zh-cn','nc-exportAction','',''),(893,'priv','zh-tw','nc-exportAction','',''),(894,'priv','de','gapanalysis-browse','',''),(894,'priv','en','gapanalysis-browse','',''),(894,'priv','fr','gapanalysis-browse','',''),(894,'priv','zh-cn','gapanalysis-browse','',''),(894,'priv','zh-tw','gapanalysis-browse','',''),(895,'priv','de','gapanalysis-create','',''),(895,'priv','en','gapanalysis-create','',''),(895,'priv','fr','gapanalysis-create','',''),(895,'priv','zh-cn','gapanalysis-create','',''),(895,'priv','zh-tw','gapanalysis-create','',''),(896,'priv','de','gapanalysis-edit','',''),(896,'priv','en','gapanalysis-edit','',''),(896,'priv','fr','gapanalysis-edit','',''),(896,'priv','zh-cn','gapanalysis-edit','',''),(896,'priv','zh-tw','gapanalysis-edit','',''),(897,'priv','de','gapanalysis-batchCreate','',''),(897,'priv','en','gapanalysis-batchCreate','',''),(897,'priv','fr','gapanalysis-batchCreate','',''),(897,'priv','zh-cn','gapanalysis-batchCreate','',''),(897,'priv','zh-tw','gapanalysis-batchCreate','',''),(898,'priv','de','gapanalysis-batchEdit','',''),(898,'priv','en','gapanalysis-batchEdit','',''),(898,'priv','fr','gapanalysis-batchEdit','',''),(898,'priv','zh-cn','gapanalysis-batchEdit','',''),(898,'priv','zh-tw','gapanalysis-batchEdit','',''),(899,'priv','de','gapanalysis-delete','',''),(899,'priv','en','gapanalysis-delete','',''),(899,'priv','fr','gapanalysis-delete','',''),(899,'priv','zh-cn','gapanalysis-delete','',''),(899,'priv','zh-tw','gapanalysis-delete','',''),(900,'priv','de','gapanalysis-view','',''),(900,'priv','en','gapanalysis-view','',''),(900,'priv','fr','gapanalysis-view','',''),(900,'priv','zh-cn','gapanalysis-view','',''),(900,'priv','zh-tw','gapanalysis-view','',''),(901,'priv','de','researchplan-browse','',''),(901,'priv','en','researchplan-browse','',''),(901,'priv','fr','researchplan-browse','',''),(901,'priv','zh-cn','researchplan-browse','',''),(901,'priv','zh-tw','researchplan-browse','',''),(902,'priv','de','researchplan-create','',''),(902,'priv','en','researchplan-create','',''),(902,'priv','fr','researchplan-create','',''),(902,'priv','zh-cn','researchplan-create','',''),(902,'priv','zh-tw','researchplan-create','',''),(903,'priv','de','researchplan-edit','',''),(903,'priv','en','researchplan-edit','',''),(903,'priv','fr','researchplan-edit','',''),(903,'priv','zh-cn','researchplan-edit','',''),(903,'priv','zh-tw','researchplan-edit','',''),(904,'priv','de','researchplan-delete','',''),(904,'priv','en','researchplan-delete','',''),(904,'priv','fr','researchplan-delete','',''),(904,'priv','zh-cn','researchplan-delete','',''),(904,'priv','zh-tw','researchplan-delete','',''),(905,'priv','de','researchplan-view','',''),(905,'priv','en','researchplan-view','',''),(905,'priv','fr','researchplan-view','',''),(905,'priv','zh-cn','researchplan-view','',''),(905,'priv','zh-tw','researchplan-view','',''),(906,'priv','de','researchreport-browse','',''),(906,'priv','en','researchreport-browse','',''),(906,'priv','fr','researchreport-browse','',''),(906,'priv','zh-cn','researchreport-browse','',''),(906,'priv','zh-tw','researchreport-browse','',''),(907,'priv','de','researchreport-create','',''),(907,'priv','en','researchreport-create','',''),(907,'priv','fr','researchreport-create','',''),(907,'priv','zh-cn','researchreport-create','',''),(907,'priv','zh-tw','researchreport-create','',''),(908,'priv','de','researchreport-edit','',''),(908,'priv','en','researchreport-edit','',''),(908,'priv','fr','researchreport-edit','',''),(908,'priv','zh-cn','researchreport-edit','',''),(908,'priv','zh-tw','researchreport-edit','',''),(909,'priv','de','researchreport-delete','',''),(909,'priv','en','researchreport-delete','',''),(909,'priv','fr','researchreport-delete','',''),(909,'priv','zh-cn','researchreport-delete','',''),(909,'priv','zh-tw','researchreport-delete','',''),(910,'priv','de','researchreport-view','',''),(910,'priv','en','researchreport-view','',''),(910,'priv','fr','researchreport-view','',''),(910,'priv','zh-cn','researchreport-view','',''),(910,'priv','zh-tw','researchreport-view','',''),(911,'priv','de','meeting-browse','',''),(911,'priv','en','meeting-browse','',''),(911,'priv','fr','meeting-browse','',''),(911,'priv','zh-cn','meeting-browse','',''),(911,'priv','zh-tw','meeting-browse','',''),(912,'priv','de','meeting-create','',''),(912,'priv','en','meeting-create','',''),(912,'priv','fr','meeting-create','',''),(912,'priv','zh-cn','meeting-create','',''),(912,'priv','zh-tw','meeting-create','',''),(913,'priv','de','meeting-edit','',''),(913,'priv','en','meeting-edit','',''),(913,'priv','fr','meeting-edit','',''),(913,'priv','zh-cn','meeting-edit','',''),(913,'priv','zh-tw','meeting-edit','',''),(914,'priv','de','meeting-deleteAction','',''),(914,'priv','en','meeting-deleteAction','',''),(914,'priv','fr','meeting-deleteAction','',''),(914,'priv','zh-cn','meeting-deleteAction','',''),(914,'priv','zh-tw','meeting-deleteAction','',''),(915,'priv','de','meeting-view','',''),(915,'priv','en','meeting-view','',''),(915,'priv','fr','meeting-view','',''),(915,'priv','zh-cn','meeting-view','',''),(915,'priv','zh-tw','meeting-view','',''),(916,'priv','de','meeting-minutes','',''),(916,'priv','en','meeting-minutes','',''),(916,'priv','fr','meeting-minutes','',''),(916,'priv','zh-cn','meeting-minutes','',''),(916,'priv','zh-tw','meeting-minutes','',''),(917,'priv','de','meetingroom-browse','',''),(917,'priv','en','meetingroom-browse','',''),(917,'priv','fr','meetingroom-browse','',''),(917,'priv','zh-cn','meetingroom-browse','',''),(917,'priv','zh-tw','meetingroom-browse','',''),(918,'priv','de','meetingroom-create','',''),(918,'priv','en','meetingroom-create','',''),(918,'priv','fr','meetingroom-create','',''),(918,'priv','zh-cn','meetingroom-create','',''),(918,'priv','zh-tw','meetingroom-create','',''),(919,'priv','de','meetingroom-edit','',''),(919,'priv','en','meetingroom-edit','',''),(919,'priv','fr','meetingroom-edit','',''),(919,'priv','zh-cn','meetingroom-edit','',''),(919,'priv','zh-tw','meetingroom-edit','',''),(920,'priv','de','meetingroom-deleteAction','',''),(920,'priv','en','meetingroom-deleteAction','',''),(920,'priv','fr','meetingroom-deleteAction','',''),(920,'priv','zh-cn','meetingroom-deleteAction','',''),(920,'priv','zh-tw','meetingroom-deleteAction','',''),(921,'priv','de','meetingroom-view','',''),(921,'priv','en','meetingroom-view','',''),(921,'priv','fr','meetingroom-view','',''),(921,'priv','zh-cn','meetingroom-view','',''),(921,'priv','zh-tw','meetingroom-view','',''),(922,'priv','de','meetingroom-batchCreate','',''),(922,'priv','en','meetingroom-batchCreate','',''),(922,'priv','fr','meetingroom-batchCreate','',''),(922,'priv','zh-cn','meetingroom-batchCreate','',''),(922,'priv','zh-tw','meetingroom-batchCreate','',''),(923,'priv','de','meetingroom-batchEdit','',''),(923,'priv','en','meetingroom-batchEdit','',''),(923,'priv','fr','meetingroom-batchEdit','',''),(923,'priv','zh-cn','meetingroom-batchEdit','',''),(923,'priv','zh-tw','meetingroom-batchEdit','',''),(924,'priv','de','approval-progress','',''),(924,'priv','en','approval-progress','',''),(924,'priv','fr','approval-progress','',''),(924,'priv','zh-cn','approval-progress','',''),(924,'priv','zh-tw','approval-progress','',''),(925,'priv','de','workflow-browseFlow','',''),(925,'priv','en','workflow-browseFlow','',''),(925,'priv','fr','workflow-browseFlow','',''),(925,'priv','zh-cn','workflow-browseFlow','',''),(925,'priv','zh-tw','workflow-browseFlow','',''),(926,'priv','de','workflow-browseDB','',''),(926,'priv','en','workflow-browseDB','',''),(926,'priv','fr','workflow-browseDB','',''),(926,'priv','zh-cn','workflow-browseDB','',''),(926,'priv','zh-tw','workflow-browseDB','',''),(927,'priv','de','workflow-create','',''),(927,'priv','en','workflow-create','',''),(927,'priv','fr','workflow-create','',''),(927,'priv','zh-cn','workflow-create','',''),(927,'priv','zh-tw','workflow-create','',''),(928,'priv','de','workflow-copy','',''),(928,'priv','en','workflow-copy','',''),(928,'priv','fr','workflow-copy','',''),(928,'priv','zh-cn','workflow-copy','',''),(928,'priv','zh-tw','workflow-copy','',''),(929,'priv','de','workflow-edit','',''),(929,'priv','en','workflow-edit','',''),(929,'priv','fr','workflow-edit','',''),(929,'priv','zh-cn','workflow-edit','',''),(929,'priv','zh-tw','workflow-edit','',''),(930,'priv','de','workflow-backup','',''),(930,'priv','en','workflow-backup','',''),(930,'priv','fr','workflow-backup','',''),(930,'priv','zh-cn','workflow-backup','',''),(930,'priv','zh-tw','workflow-backup','',''),(931,'priv','de','workflow-upgradeAction','',''),(931,'priv','en','workflow-upgradeAction','',''),(931,'priv','fr','workflow-upgradeAction','',''),(931,'priv','zh-cn','workflow-upgradeAction','',''),(931,'priv','zh-tw','workflow-upgradeAction','',''),(932,'priv','de','workflow-view','',''),(932,'priv','en','workflow-view','',''),(932,'priv','fr','workflow-view','',''),(932,'priv','zh-cn','workflow-view','',''),(932,'priv','zh-tw','workflow-view','',''),(933,'priv','de','workflow-delete','',''),(933,'priv','en','workflow-delete','',''),(933,'priv','fr','workflow-delete','',''),(933,'priv','zh-cn','workflow-delete','',''),(933,'priv','zh-tw','workflow-delete','',''),(934,'priv','de','workflow-flowchart','',''),(934,'priv','en','workflow-flowchart','',''),(934,'priv','fr','workflow-flowchart','',''),(934,'priv','zh-cn','workflow-flowchart','',''),(934,'priv','zh-tw','workflow-flowchart','',''),(935,'priv','de','workflow-ui','',''),(935,'priv','en','workflow-ui','',''),(935,'priv','fr','workflow-ui','',''),(935,'priv','zh-cn','workflow-ui','',''),(935,'priv','zh-tw','workflow-ui','',''),(936,'priv','de','workflow-release','',''),(936,'priv','en','workflow-release','',''),(936,'priv','fr','workflow-release','',''),(936,'priv','zh-cn','workflow-release','',''),(936,'priv','zh-tw','workflow-release','',''),(937,'priv','de','workflow-deactivate','',''),(937,'priv','en','workflow-deactivate','',''),(937,'priv','fr','workflow-deactivate','',''),(937,'priv','zh-cn','workflow-deactivate','',''),(937,'priv','zh-tw','workflow-deactivate','',''),(938,'priv','de','workflow-activate','',''),(938,'priv','en','workflow-activate','',''),(938,'priv','fr','workflow-activate','',''),(938,'priv','zh-cn','workflow-activate','',''),(938,'priv','zh-tw','workflow-activate','',''),(939,'priv','de','workflow-setApproval','',''),(939,'priv','en','workflow-setApproval','',''),(939,'priv','fr','workflow-setApproval','',''),(939,'priv','zh-cn','workflow-setApproval','',''),(939,'priv','zh-tw','workflow-setApproval','',''),(940,'priv','de','workflow-setJS','',''),(940,'priv','en','workflow-setJS','',''),(940,'priv','fr','workflow-setJS','',''),(940,'priv','zh-cn','workflow-setJS','',''),(940,'priv','zh-tw','workflow-setJS','',''),(941,'priv','de','workflow-setCSS','',''),(941,'priv','en','workflow-setCSS','',''),(941,'priv','fr','workflow-setCSS','',''),(941,'priv','zh-cn','workflow-setCSS','',''),(941,'priv','zh-tw','workflow-setCSS','',''),(942,'priv','de','workflowfield-browse','',''),(942,'priv','en','workflowfield-browse','',''),(942,'priv','fr','workflowfield-browse','',''),(942,'priv','zh-cn','workflowfield-browse','',''),(942,'priv','zh-tw','workflowfield-browse','',''),(943,'priv','de','workflowfield-create','',''),(943,'priv','en','workflowfield-create','',''),(943,'priv','fr','workflowfield-create','',''),(943,'priv','zh-cn','workflowfield-create','',''),(943,'priv','zh-tw','workflowfield-create','',''),(944,'priv','de','workflowfield-edit','',''),(944,'priv','en','workflowfield-edit','',''),(944,'priv','fr','workflowfield-edit','',''),(944,'priv','zh-cn','workflowfield-edit','',''),(944,'priv','zh-tw','workflowfield-edit','',''),(945,'priv','de','workflowfield-delete','',''),(945,'priv','en','workflowfield-delete','',''),(945,'priv','fr','workflowfield-delete','',''),(945,'priv','zh-cn','workflowfield-delete','',''),(945,'priv','zh-tw','workflowfield-delete','',''),(946,'priv','de','workflowfield-sort','',''),(946,'priv','en','workflowfield-sort','',''),(946,'priv','fr','workflowfield-sort','',''),(946,'priv','zh-cn','workflowfield-sort','',''),(946,'priv','zh-tw','workflowfield-sort','',''),(947,'priv','de','workflowfield-import','',''),(947,'priv','en','workflowfield-import','',''),(947,'priv','fr','workflowfield-import','',''),(947,'priv','zh-cn','workflowfield-import','',''),(947,'priv','zh-tw','workflowfield-import','',''),(948,'priv','de','workflowfield-showImport','',''),(948,'priv','en','workflowfield-showImport','',''),(948,'priv','fr','workflowfield-showImport','',''),(948,'priv','zh-cn','workflowfield-showImport','',''),(948,'priv','zh-tw','workflowfield-showImport','',''),(949,'priv','de','workflowfield-exportTemplate','',''),(949,'priv','en','workflowfield-exportTemplate','',''),(949,'priv','fr','workflowfield-exportTemplate','',''),(949,'priv','zh-cn','workflowfield-exportTemplate','',''),(949,'priv','zh-tw','workflowfield-exportTemplate','',''),(950,'priv','de','workflowfield-setValue','',''),(950,'priv','en','workflowfield-setValue','',''),(950,'priv','fr','workflowfield-setValue','',''),(950,'priv','zh-cn','workflowfield-setValue','',''),(950,'priv','zh-tw','workflowfield-setValue','',''),(951,'priv','de','workflowfield-setExport','',''),(951,'priv','en','workflowfield-setExport','',''),(951,'priv','fr','workflowfield-setExport','',''),(951,'priv','zh-cn','workflowfield-setExport','',''),(951,'priv','zh-tw','workflowfield-setExport','',''),(952,'priv','de','workflowfield-setSearch','',''),(952,'priv','en','workflowfield-setSearch','',''),(952,'priv','fr','workflowfield-setSearch','',''),(952,'priv','zh-cn','workflowfield-setSearch','',''),(952,'priv','zh-tw','workflowfield-setSearch','',''),(953,'priv','de','workflowaction-browse','',''),(953,'priv','en','workflowaction-browse','',''),(953,'priv','fr','workflowaction-browse','',''),(953,'priv','zh-cn','workflowaction-browse','',''),(953,'priv','zh-tw','workflowaction-browse','',''),(954,'priv','de','workflowaction-create','',''),(954,'priv','en','workflowaction-create','',''),(954,'priv','fr','workflowaction-create','',''),(954,'priv','zh-cn','workflowaction-create','',''),(954,'priv','zh-tw','workflowaction-create','',''),(955,'priv','de','workflowaction-edit','',''),(955,'priv','en','workflowaction-edit','',''),(955,'priv','fr','workflowaction-edit','',''),(955,'priv','zh-cn','workflowaction-edit','',''),(955,'priv','zh-tw','workflowaction-edit','',''),(956,'priv','de','workflowaction-view','',''),(956,'priv','en','workflowaction-view','',''),(956,'priv','fr','workflowaction-view','',''),(956,'priv','zh-cn','workflowaction-view','',''),(956,'priv','zh-tw','workflowaction-view','',''),(957,'priv','de','workflowaction-delete','',''),(957,'priv','en','workflowaction-delete','',''),(957,'priv','fr','workflowaction-delete','',''),(957,'priv','zh-cn','workflowaction-delete','',''),(957,'priv','zh-tw','workflowaction-delete','',''),(958,'priv','de','workflowaction-sort','',''),(958,'priv','en','workflowaction-sort','',''),(958,'priv','fr','workflowaction-sort','',''),(958,'priv','zh-cn','workflowaction-sort','',''),(958,'priv','zh-tw','workflowaction-sort','',''),(959,'priv','de','workflowaction-setVerification','',''),(959,'priv','en','workflowaction-setVerification','',''),(959,'priv','fr','workflowaction-setVerification','',''),(959,'priv','zh-cn','workflowaction-setVerification','',''),(959,'priv','zh-tw','workflowaction-setVerification','',''),(960,'priv','de','workflowaction-setNotice','',''),(960,'priv','en','workflowaction-setNotice','',''),(960,'priv','fr','workflowaction-setNotice','',''),(960,'priv','zh-cn','workflowaction-setNotice','',''),(960,'priv','zh-tw','workflowaction-setNotice','',''),(961,'priv','de','workflowaction-setJS','',''),(961,'priv','en','workflowaction-setJS','',''),(961,'priv','fr','workflowaction-setJS','',''),(961,'priv','zh-cn','workflowaction-setJS','',''),(961,'priv','zh-tw','workflowaction-setJS','',''),(962,'priv','de','workflowaction-setCSS','',''),(962,'priv','en','workflowaction-setCSS','',''),(962,'priv','fr','workflowaction-setCSS','',''),(962,'priv','zh-cn','workflowaction-setCSS','',''),(962,'priv','zh-tw','workflowaction-setCSS','',''),(963,'priv','de','workflowlayout-admin','',''),(963,'priv','en','workflowlayout-admin','',''),(963,'priv','fr','workflowlayout-admin','',''),(963,'priv','zh-cn','workflowlayout-admin','',''),(963,'priv','zh-tw','workflowlayout-admin','',''),(964,'priv','de','workflowlayout-block','',''),(964,'priv','en','workflowlayout-block','',''),(964,'priv','fr','workflowlayout-block','',''),(964,'priv','zh-cn','workflowlayout-block','',''),(964,'priv','zh-tw','workflowlayout-block','',''),(965,'priv','de','workflowcondition-browse','',''),(965,'priv','en','workflowcondition-browse','',''),(965,'priv','fr','workflowcondition-browse','',''),(965,'priv','zh-cn','workflowcondition-browse','',''),(965,'priv','zh-tw','workflowcondition-browse','',''),(966,'priv','de','workflowcondition-create','',''),(966,'priv','en','workflowcondition-create','',''),(966,'priv','fr','workflowcondition-create','',''),(966,'priv','zh-cn','workflowcondition-create','',''),(966,'priv','zh-tw','workflowcondition-create','',''),(967,'priv','de','workflowcondition-edit','',''),(967,'priv','en','workflowcondition-edit','',''),(967,'priv','fr','workflowcondition-edit','',''),(967,'priv','zh-cn','workflowcondition-edit','',''),(967,'priv','zh-tw','workflowcondition-edit','',''),(968,'priv','de','workflowcondition-delete','',''),(968,'priv','en','workflowcondition-delete','',''),(968,'priv','fr','workflowcondition-delete','',''),(968,'priv','zh-cn','workflowcondition-delete','',''),(968,'priv','zh-tw','workflowcondition-delete','',''),(969,'priv','de','workflowlinkage-browse','',''),(969,'priv','en','workflowlinkage-browse','',''),(969,'priv','fr','workflowlinkage-browse','',''),(969,'priv','zh-cn','workflowlinkage-browse','',''),(969,'priv','zh-tw','workflowlinkage-browse','',''),(970,'priv','de','workflowlinkage-create','',''),(970,'priv','en','workflowlinkage-create','',''),(970,'priv','fr','workflowlinkage-create','',''),(970,'priv','zh-cn','workflowlinkage-create','',''),(970,'priv','zh-tw','workflowlinkage-create','',''),(971,'priv','de','workflowlinkage-edit','',''),(971,'priv','en','workflowlinkage-edit','',''),(971,'priv','fr','workflowlinkage-edit','',''),(971,'priv','zh-cn','workflowlinkage-edit','',''),(971,'priv','zh-tw','workflowlinkage-edit','',''),(972,'priv','de','workflowlinkage-delete','',''),(972,'priv','en','workflowlinkage-delete','',''),(972,'priv','fr','workflowlinkage-delete','',''),(972,'priv','zh-cn','workflowlinkage-delete','',''),(972,'priv','zh-tw','workflowlinkage-delete','',''),(973,'priv','de','workflowhook-browse','',''),(973,'priv','en','workflowhook-browse','',''),(973,'priv','fr','workflowhook-browse','',''),(973,'priv','zh-cn','workflowhook-browse','',''),(973,'priv','zh-tw','workflowhook-browse','',''),(974,'priv','de','workflowhook-create','',''),(974,'priv','en','workflowhook-create','',''),(974,'priv','fr','workflowhook-create','',''),(974,'priv','zh-cn','workflowhook-create','',''),(974,'priv','zh-tw','workflowhook-create','',''),(975,'priv','de','workflowhook-edit','',''),(975,'priv','en','workflowhook-edit','',''),(975,'priv','fr','workflowhook-edit','',''),(975,'priv','zh-cn','workflowhook-edit','',''),(975,'priv','zh-tw','workflowhook-edit','',''),(976,'priv','de','workflowhook-delete','',''),(976,'priv','en','workflowhook-delete','',''),(976,'priv','fr','workflowhook-delete','',''),(976,'priv','zh-cn','workflowhook-delete','',''),(976,'priv','zh-tw','workflowhook-delete','',''),(977,'priv','de','workflowlabel-browse','',''),(977,'priv','en','workflowlabel-browse','',''),(977,'priv','fr','workflowlabel-browse','',''),(977,'priv','zh-cn','workflowlabel-browse','',''),(977,'priv','zh-tw','workflowlabel-browse','',''),(978,'priv','de','workflowlabel-create','',''),(978,'priv','en','workflowlabel-create','',''),(978,'priv','fr','workflowlabel-create','',''),(978,'priv','zh-cn','workflowlabel-create','',''),(978,'priv','zh-tw','workflowlabel-create','',''),(979,'priv','de','workflowlabel-edit','',''),(979,'priv','en','workflowlabel-edit','',''),(979,'priv','fr','workflowlabel-edit','',''),(979,'priv','zh-cn','workflowlabel-edit','',''),(979,'priv','zh-tw','workflowlabel-edit','',''),(980,'priv','de','workflowlabel-delete','',''),(980,'priv','en','workflowlabel-delete','',''),(980,'priv','fr','workflowlabel-delete','',''),(980,'priv','zh-cn','workflowlabel-delete','',''),(980,'priv','zh-tw','workflowlabel-delete','',''),(981,'priv','de','workflowlabel-sort','',''),(981,'priv','en','workflowlabel-sort','',''),(981,'priv','fr','workflowlabel-sort','',''),(981,'priv','zh-cn','workflowlabel-sort','',''),(981,'priv','zh-tw','workflowlabel-sort','',''),(982,'priv','de','workflowrelation-admin','',''),(982,'priv','en','workflowrelation-admin','',''),(982,'priv','fr','workflowrelation-admin','',''),(982,'priv','zh-cn','workflowrelation-admin','',''),(982,'priv','zh-tw','workflowrelation-admin','',''),(983,'priv','de','workflowreport-brow','',''),(983,'priv','en','workflowreport-brow','',''),(983,'priv','fr','workflowreport-brow','',''),(983,'priv','zh-cn','workflowreport-brow','',''),(983,'priv','zh-tw','workflowreport-brow','',''),(984,'priv','de','workflowreport-create','',''),(984,'priv','en','workflowreport-create','',''),(984,'priv','fr','workflowreport-create','',''),(984,'priv','zh-cn','workflowreport-create','',''),(984,'priv','zh-tw','workflowreport-create','',''),(985,'priv','de','workflowreport-edit','',''),(985,'priv','en','workflowreport-edit','',''),(985,'priv','fr','workflowreport-edit','',''),(985,'priv','zh-cn','workflowreport-edit','',''),(985,'priv','zh-tw','workflowreport-edit','',''),(986,'priv','de','workflowreport-delete','',''),(986,'priv','en','workflowreport-delete','',''),(986,'priv','fr','workflowreport-delete','',''),(986,'priv','zh-cn','workflowreport-delete','',''),(986,'priv','zh-tw','workflowreport-delete','',''),(987,'priv','de','workflowreport-sort','',''),(987,'priv','en','workflowreport-sort','',''),(987,'priv','fr','workflowreport-sort','',''),(987,'priv','zh-cn','workflowreport-sort','',''),(987,'priv','zh-tw','workflowreport-sort','',''),(988,'priv','de','workflowdatasource-browse','',''),(988,'priv','en','workflowdatasource-browse','',''),(988,'priv','fr','workflowdatasource-browse','',''),(988,'priv','zh-cn','workflowdatasource-browse','',''),(988,'priv','zh-tw','workflowdatasource-browse','',''),(989,'priv','de','workflowdatasource-create','',''),(989,'priv','en','workflowdatasource-create','',''),(989,'priv','fr','workflowdatasource-create','',''),(989,'priv','zh-cn','workflowdatasource-create','',''),(989,'priv','zh-tw','workflowdatasource-create','',''),(990,'priv','de','workflowdatasource-edit','',''),(990,'priv','en','workflowdatasource-edit','',''),(990,'priv','fr','workflowdatasource-edit','',''),(990,'priv','zh-cn','workflowdatasource-edit','',''),(990,'priv','zh-tw','workflowdatasource-edit','',''),(991,'priv','de','workflowdatasource-delete','',''),(991,'priv','en','workflowdatasource-delete','',''),(991,'priv','fr','workflowdatasource-delete','',''),(991,'priv','zh-cn','workflowdatasource-delete','',''),(991,'priv','zh-tw','workflowdatasource-delete','',''),(992,'priv','de','workflowrule-browse','',''),(992,'priv','en','workflowrule-browse','',''),(992,'priv','fr','workflowrule-browse','',''),(992,'priv','zh-cn','workflowrule-browse','',''),(992,'priv','zh-tw','workflowrule-browse','',''),(993,'priv','de','workflowrule-create','',''),(993,'priv','en','workflowrule-create','',''),(993,'priv','fr','workflowrule-create','',''),(993,'priv','zh-cn','workflowrule-create','',''),(993,'priv','zh-tw','workflowrule-create','',''),(994,'priv','de','workflowrule-edit','',''),(994,'priv','en','workflowrule-edit','',''),(994,'priv','fr','workflowrule-edit','',''),(994,'priv','zh-cn','workflowrule-edit','',''),(994,'priv','zh-tw','workflowrule-edit','',''),(995,'priv','de','workflowrule-view','',''),(995,'priv','en','workflowrule-view','',''),(995,'priv','fr','workflowrule-view','',''),(995,'priv','zh-cn','workflowrule-view','',''),(995,'priv','zh-tw','workflowrule-view','',''),(996,'priv','de','workflowrule-delete','',''),(996,'priv','en','workflowrule-delete','',''),(996,'priv','fr','workflowrule-delete','',''),(996,'priv','zh-cn','workflowrule-delete','',''),(996,'priv','zh-tw','workflowrule-delete','',''),(997,'priv','de','projectbuild-browse','',''),(997,'priv','en','projectbuild-browse','',''),(997,'priv','fr','projectbuild-browse','',''),(997,'priv','zh-cn','projectbuild-browse','',''),(997,'priv','zh-tw','projectbuild-browse','',''),(998,'priv','de','projectbuild-create','',''),(998,'priv','en','projectbuild-create','',''),(998,'priv','fr','projectbuild-create','',''),(998,'priv','zh-cn','projectbuild-create','',''),(998,'priv','zh-tw','projectbuild-create','',''),(999,'priv','de','projectbuild-edit','',''),(999,'priv','en','projectbuild-edit','',''),(999,'priv','fr','projectbuild-edit','',''),(999,'priv','zh-cn','projectbuild-edit','',''),(999,'priv','zh-tw','projectbuild-edit','',''),(1000,'priv','de','projectbuild-view','',''),(1000,'priv','en','projectbuild-view','',''),(1000,'priv','fr','projectbuild-view','',''),(1000,'priv','zh-cn','projectbuild-view','',''),(1000,'priv','zh-tw','projectbuild-view','',''),(1001,'priv','de','projectbuild-delete','',''),(1001,'priv','en','projectbuild-delete','',''),(1001,'priv','fr','projectbuild-delete','',''),(1001,'priv','zh-cn','projectbuild-delete','',''),(1001,'priv','zh-tw','projectbuild-delete','',''),(1002,'priv','de','projectbuild-linkStory','',''),(1002,'priv','en','projectbuild-linkStory','',''),(1002,'priv','fr','projectbuild-linkStory','',''),(1002,'priv','zh-cn','projectbuild-linkStory','',''),(1002,'priv','zh-tw','projectbuild-linkStory','',''),(1003,'priv','de','projectbuild-unlinkStory','',''),(1003,'priv','en','projectbuild-unlinkStory','',''),(1003,'priv','fr','projectbuild-unlinkStory','',''),(1003,'priv','zh-cn','projectbuild-unlinkStory','',''),(1003,'priv','zh-tw','projectbuild-unlinkStory','',''),(1004,'priv','de','projectbuild-batchUnlinkStory','',''),(1004,'priv','en','projectbuild-batchUnlinkStory','',''),(1004,'priv','fr','projectbuild-batchUnlinkStory','',''),(1004,'priv','zh-cn','projectbuild-batchUnlinkStory','',''),(1004,'priv','zh-tw','projectbuild-batchUnlinkStory','',''),(1005,'priv','de','projectbuild-linkBug','',''),(1005,'priv','en','projectbuild-linkBug','',''),(1005,'priv','fr','projectbuild-linkBug','',''),(1005,'priv','zh-cn','projectbuild-linkBug','',''),(1005,'priv','zh-tw','projectbuild-linkBug','',''),(1006,'priv','de','projectbuild-unlinkBug','',''),(1006,'priv','en','projectbuild-unlinkBug','',''),(1006,'priv','fr','projectbuild-unlinkBug','',''),(1006,'priv','zh-cn','projectbuild-unlinkBug','',''),(1006,'priv','zh-tw','projectbuild-unlinkBug','',''),(1007,'priv','de','projectbuild-batchUnlinkBug','',''),(1007,'priv','en','projectbuild-batchUnlinkBug','',''),(1007,'priv','fr','projectbuild-batchUnlinkBug','',''),(1007,'priv','zh-cn','projectbuild-batchUnlinkBug','',''),(1007,'priv','zh-tw','projectbuild-batchUnlinkBug','',''),(1008,'priv','de','projectrelease-browseAction','',''),(1008,'priv','en','projectrelease-browseAction','',''),(1008,'priv','fr','projectrelease-browseAction','',''),(1008,'priv','zh-cn','projectrelease-browseAction','',''),(1008,'priv','zh-tw','projectrelease-browseAction','',''),(1009,'priv','de','projectrelease-create','',''),(1009,'priv','en','projectrelease-create','',''),(1009,'priv','fr','projectrelease-create','',''),(1009,'priv','zh-cn','projectrelease-create','',''),(1009,'priv','zh-tw','projectrelease-create','',''),(1010,'priv','de','projectrelease-edit','',''),(1010,'priv','en','projectrelease-edit','',''),(1010,'priv','fr','projectrelease-edit','',''),(1010,'priv','zh-cn','projectrelease-edit','',''),(1010,'priv','zh-tw','projectrelease-edit','',''),(1011,'priv','de','projectrelease-delete','',''),(1011,'priv','en','projectrelease-delete','',''),(1011,'priv','fr','projectrelease-delete','',''),(1011,'priv','zh-cn','projectrelease-delete','',''),(1011,'priv','zh-tw','projectrelease-delete','',''),(1012,'priv','de','projectrelease-view','',''),(1012,'priv','en','projectrelease-view','',''),(1012,'priv','fr','projectrelease-view','',''),(1012,'priv','zh-cn','projectrelease-view','',''),(1012,'priv','zh-tw','projectrelease-view','',''),(1013,'priv','de','projectrelease-export','',''),(1013,'priv','en','projectrelease-export','',''),(1013,'priv','fr','projectrelease-export','',''),(1013,'priv','zh-cn','projectrelease-export','',''),(1013,'priv','zh-tw','projectrelease-export','',''),(1014,'priv','de','projectrelease-linkStory','',''),(1014,'priv','en','projectrelease-linkStory','',''),(1014,'priv','fr','projectrelease-linkStory','',''),(1014,'priv','zh-cn','projectrelease-linkStory','',''),(1014,'priv','zh-tw','projectrelease-linkStory','',''),(1015,'priv','de','projectrelease-unlinkStory','',''),(1015,'priv','en','projectrelease-unlinkStory','',''),(1015,'priv','fr','projectrelease-unlinkStory','',''),(1015,'priv','zh-cn','projectrelease-unlinkStory','',''),(1015,'priv','zh-tw','projectrelease-unlinkStory','',''),(1016,'priv','de','projectrelease-batchUnlinkStory','',''),(1016,'priv','en','projectrelease-batchUnlinkStory','',''),(1016,'priv','fr','projectrelease-batchUnlinkStory','',''),(1016,'priv','zh-cn','projectrelease-batchUnlinkStory','',''),(1016,'priv','zh-tw','projectrelease-batchUnlinkStory','',''),(1017,'priv','de','projectrelease-linkBug','',''),(1017,'priv','en','projectrelease-linkBug','',''),(1017,'priv','fr','projectrelease-linkBug','',''),(1017,'priv','zh-cn','projectrelease-linkBug','',''),(1017,'priv','zh-tw','projectrelease-linkBug','',''),(1018,'priv','de','projectrelease-unlinkBug','',''),(1018,'priv','en','projectrelease-unlinkBug','',''),(1018,'priv','fr','projectrelease-unlinkBug','',''),(1018,'priv','zh-cn','projectrelease-unlinkBug','',''),(1018,'priv','zh-tw','projectrelease-unlinkBug','',''),(1019,'priv','de','projectrelease-batchUnlinkBug','',''),(1019,'priv','en','projectrelease-batchUnlinkBug','',''),(1019,'priv','fr','projectrelease-batchUnlinkBug','',''),(1019,'priv','zh-cn','projectrelease-batchUnlinkBug','',''),(1019,'priv','zh-tw','projectrelease-batchUnlinkBug','',''),(1020,'priv','de','projectrelease-changeStatus','',''),(1020,'priv','en','projectrelease-changeStatus','',''),(1020,'priv','fr','projectrelease-changeStatus','',''),(1020,'priv','zh-cn','projectrelease-changeStatus','',''),(1020,'priv','zh-tw','projectrelease-changeStatus','',''),(1021,'priv','de','projectrelease-notify','',''),(1021,'priv','en','projectrelease-notify','',''),(1021,'priv','fr','projectrelease-notify','',''),(1021,'priv','zh-cn','projectrelease-notify','',''),(1021,'priv','zh-tw','projectrelease-notify','',''),(1022,'priv','de','stakeholder-browse','',''),(1022,'priv','en','stakeholder-browse','',''),(1022,'priv','fr','stakeholder-browse','',''),(1022,'priv','zh-cn','stakeholder-browse','',''),(1022,'priv','zh-tw','stakeholder-browse','',''),(1023,'priv','de','stakeholder-create','',''),(1023,'priv','en','stakeholder-create','',''),(1023,'priv','fr','stakeholder-create','',''),(1023,'priv','zh-cn','stakeholder-create','',''),(1023,'priv','zh-tw','stakeholder-create','',''),(1024,'priv','de','stakeholder-batchCreate','',''),(1024,'priv','en','stakeholder-batchCreate','',''),(1024,'priv','fr','stakeholder-batchCreate','',''),(1024,'priv','zh-cn','stakeholder-batchCreate','',''),(1024,'priv','zh-tw','stakeholder-batchCreate','',''),(1025,'priv','de','stakeholder-edit','',''),(1025,'priv','en','stakeholder-edit','',''),(1025,'priv','fr','stakeholder-edit','',''),(1025,'priv','zh-cn','stakeholder-edit','',''),(1025,'priv','zh-tw','stakeholder-edit','',''),(1027,'priv','de','stakeholder-delete','',''),(1027,'priv','en','stakeholder-delete','',''),(1027,'priv','fr','stakeholder-delete','',''),(1027,'priv','zh-cn','stakeholder-delete','',''),(1027,'priv','zh-tw','stakeholder-delete','',''),(1028,'priv','de','stakeholder-viewAction','',''),(1028,'priv','en','stakeholder-viewAction','',''),(1028,'priv','fr','stakeholder-viewAction','',''),(1028,'priv','zh-cn','stakeholder-viewAction','',''),(1028,'priv','zh-tw','stakeholder-viewAction','',''),(1031,'priv','de','stakeholder-communicate','',''),(1031,'priv','en','stakeholder-communicate','',''),(1031,'priv','fr','stakeholder-communicate','',''),(1031,'priv','zh-cn','stakeholder-communicate','',''),(1031,'priv','zh-tw','stakeholder-communicate','',''),(1032,'priv','de','stakeholder-expect','',''),(1032,'priv','en','stakeholder-expect','',''),(1032,'priv','fr','stakeholder-expect','',''),(1032,'priv','zh-cn','stakeholder-expect','',''),(1032,'priv','zh-tw','stakeholder-expect','',''),(1038,'priv','de','stakeholder-userIssue','',''),(1038,'priv','en','stakeholder-userIssue','',''),(1038,'priv','fr','stakeholder-userIssue','',''),(1038,'priv','zh-cn','stakeholder-userIssue','',''),(1038,'priv','zh-tw','stakeholder-userIssue','',''),(1039,'priv','de','branch-manage','',''),(1039,'priv','en','branch-manage','',''),(1039,'priv','fr','branch-manage','',''),(1039,'priv','zh-cn','branch-manage','',''),(1039,'priv','zh-tw','branch-manage','',''),(1040,'priv','de','branch-createAction','',''),(1040,'priv','en','branch-createAction','',''),(1040,'priv','fr','branch-createAction','',''),(1040,'priv','zh-cn','branch-createAction','',''),(1040,'priv','zh-tw','branch-createAction','',''),(1041,'priv','de','branch-editAction','',''),(1041,'priv','en','branch-editAction','',''),(1041,'priv','fr','branch-editAction','',''),(1041,'priv','zh-cn','branch-editAction','',''),(1041,'priv','zh-tw','branch-editAction','',''),(1042,'priv','de','branch-closeAction','',''),(1042,'priv','en','branch-closeAction','',''),(1042,'priv','fr','branch-closeAction','',''),(1042,'priv','zh-cn','branch-closeAction','',''),(1042,'priv','zh-tw','branch-closeAction','',''),(1043,'priv','de','branch-activateAction','',''),(1043,'priv','en','branch-activateAction','',''),(1043,'priv','fr','branch-activateAction','',''),(1043,'priv','zh-cn','branch-activateAction','',''),(1043,'priv','zh-tw','branch-activateAction','',''),(1044,'priv','de','branch-sort','',''),(1044,'priv','en','branch-sort','',''),(1044,'priv','fr','branch-sort','',''),(1044,'priv','zh-cn','branch-sort','',''),(1044,'priv','zh-tw','branch-sort','',''),(1045,'priv','de','branch-batchEdit','',''),(1045,'priv','en','branch-batchEdit','',''),(1045,'priv','fr','branch-batchEdit','',''),(1045,'priv','zh-cn','branch-batchEdit','',''),(1045,'priv','zh-tw','branch-batchEdit','',''),(1046,'priv','de','branch-mergeBranchAction','',''),(1046,'priv','en','branch-mergeBranchAction','',''),(1046,'priv','fr','branch-mergeBranchAction','',''),(1046,'priv','zh-cn','branch-mergeBranchAction','',''),(1046,'priv','zh-tw','branch-mergeBranchAction','',''),(1047,'priv','de','repo-createAction','',''),(1047,'priv','en','repo-createAction','',''),(1047,'priv','fr','repo-createAction','',''),(1047,'priv','zh-cn','repo-createAction','',''),(1047,'priv','zh-tw','repo-createAction','',''),(1048,'priv','de','repo-editAction','',''),(1048,'priv','en','repo-editAction','',''),(1048,'priv','fr','repo-editAction','',''),(1048,'priv','zh-cn','repo-editAction','',''),(1048,'priv','zh-tw','repo-editAction','',''),(1049,'priv','de','repo-delete','',''),(1049,'priv','en','repo-delete','',''),(1049,'priv','fr','repo-delete','',''),(1049,'priv','zh-cn','repo-delete','',''),(1049,'priv','zh-tw','repo-delete','',''),(1050,'priv','de','repo-showSyncCommit','',''),(1050,'priv','en','repo-showSyncCommit','',''),(1050,'priv','fr','repo-showSyncCommit','',''),(1050,'priv','zh-cn','repo-showSyncCommit','',''),(1050,'priv','zh-tw','repo-showSyncCommit','',''),(1051,'priv','de','repo-maintain','',''),(1051,'priv','en','repo-maintain','',''),(1051,'priv','fr','repo-maintain','',''),(1051,'priv','zh-cn','repo-maintain','',''),(1051,'priv','zh-tw','repo-maintain','',''),(1052,'priv','de','repo-browseAction','',''),(1052,'priv','en','repo-browseAction','',''),(1052,'priv','fr','repo-browseAction','',''),(1052,'priv','zh-cn','repo-browseAction','',''),(1052,'priv','zh-tw','repo-browseAction','',''),(1053,'priv','de','repo-view','',''),(1053,'priv','en','repo-view','',''),(1053,'priv','fr','repo-view','',''),(1053,'priv','zh-cn','repo-view','',''),(1053,'priv','zh-tw','repo-view','',''),(1054,'priv','de','repo-diffAction','',''),(1054,'priv','en','repo-diffAction','',''),(1054,'priv','fr','repo-diffAction','',''),(1054,'priv','zh-cn','repo-diffAction','',''),(1054,'priv','zh-tw','repo-diffAction','',''),(1055,'priv','de','repo-log','',''),(1055,'priv','en','repo-log','',''),(1055,'priv','fr','repo-log','',''),(1055,'priv','zh-cn','repo-log','',''),(1055,'priv','zh-tw','repo-log','',''),(1056,'priv','de','repo-revisionAction','',''),(1056,'priv','en','repo-revisionAction','',''),(1056,'priv','fr','repo-revisionAction','',''),(1056,'priv','zh-cn','repo-revisionAction','',''),(1056,'priv','zh-tw','repo-revisionAction','',''),(1057,'priv','de','repo-blameAction','',''),(1057,'priv','en','repo-blameAction','',''),(1057,'priv','fr','repo-blameAction','',''),(1057,'priv','zh-cn','repo-blameAction','',''),(1057,'priv','zh-tw','repo-blameAction','',''),(1058,'priv','de','repo-downloadAction','',''),(1058,'priv','en','repo-downloadAction','',''),(1058,'priv','fr','repo-downloadAction','',''),(1058,'priv','zh-cn','repo-downloadAction','',''),(1058,'priv','zh-tw','repo-downloadAction','',''),(1059,'priv','de','repo-setRules','',''),(1059,'priv','en','repo-setRules','',''),(1059,'priv','fr','repo-setRules','',''),(1059,'priv','zh-cn','repo-setRules','',''),(1059,'priv','zh-tw','repo-setRules','',''),(1060,'priv','de','repo-apiGetRepoByUrl','',''),(1060,'priv','en','repo-apiGetRepoByUrl','',''),(1060,'priv','fr','repo-apiGetRepoByUrl','',''),(1060,'priv','zh-cn','repo-apiGetRepoByUrl','',''),(1060,'priv','zh-tw','repo-apiGetRepoByUrl','',''),(1061,'priv','de','repo-downloadCode','',''),(1061,'priv','en','repo-downloadCode','',''),(1061,'priv','fr','repo-downloadCode','',''),(1061,'priv','zh-cn','repo-downloadCode','',''),(1061,'priv','zh-tw','repo-downloadCode','',''),(1062,'priv','de','repo-linkStory','',''),(1062,'priv','en','repo-linkStory','',''),(1062,'priv','fr','repo-linkStory','',''),(1062,'priv','zh-cn','repo-linkStory','',''),(1062,'priv','zh-tw','repo-linkStory','',''),(1063,'priv','de','repo-linkBug','',''),(1063,'priv','en','repo-linkBug','',''),(1063,'priv','fr','repo-linkBug','',''),(1063,'priv','zh-cn','repo-linkBug','',''),(1063,'priv','zh-tw','repo-linkBug','',''),(1064,'priv','de','repo-linkTask','',''),(1064,'priv','en','repo-linkTask','',''),(1064,'priv','fr','repo-linkTask','',''),(1064,'priv','zh-cn','repo-linkTask','',''),(1064,'priv','zh-tw','repo-linkTask','',''),(1065,'priv','de','repo-unlink','',''),(1065,'priv','en','repo-unlink','',''),(1065,'priv','fr','repo-unlink','',''),(1065,'priv','zh-cn','repo-unlink','',''),(1065,'priv','zh-tw','repo-unlink','',''),(1066,'priv','de','repo-reviewAction','',''),(1066,'priv','en','repo-reviewAction','',''),(1066,'priv','fr','repo-reviewAction','',''),(1066,'priv','zh-cn','repo-reviewAction','',''),(1066,'priv','zh-tw','repo-reviewAction','',''),(1067,'priv','de','repo-addBug','',''),(1067,'priv','en','repo-addBug','',''),(1067,'priv','fr','repo-addBug','',''),(1067,'priv','zh-cn','repo-addBug','',''),(1067,'priv','zh-tw','repo-addBug','',''),(1068,'priv','de','repo-editBug','',''),(1068,'priv','en','repo-editBug','',''),(1068,'priv','fr','repo-editBug','',''),(1068,'priv','zh-cn','repo-editBug','',''),(1068,'priv','zh-tw','repo-editBug','',''),(1069,'priv','de','repo-deleteBug','',''),(1069,'priv','en','repo-deleteBug','',''),(1069,'priv','fr','repo-deleteBug','',''),(1069,'priv','zh-cn','repo-deleteBug','',''),(1069,'priv','zh-tw','repo-deleteBug','',''),(1070,'priv','de','repo-addComment','',''),(1070,'priv','en','repo-addComment','',''),(1070,'priv','fr','repo-addComment','',''),(1070,'priv','zh-cn','repo-addComment','',''),(1070,'priv','zh-tw','repo-addComment','',''),(1071,'priv','de','repo-editComment','',''),(1071,'priv','en','repo-editComment','',''),(1071,'priv','fr','repo-editComment','',''),(1071,'priv','zh-cn','repo-editComment','',''),(1071,'priv','zh-tw','repo-editComment','',''),(1072,'priv','de','repo-deleteComment','',''),(1072,'priv','en','repo-deleteComment','',''),(1072,'priv','fr','repo-deleteComment','',''),(1072,'priv','zh-cn','repo-deleteComment','',''),(1072,'priv','zh-tw','repo-deleteComment','',''),(1073,'priv','de','ci-commitResult','',''),(1073,'priv','en','ci-commitResult','',''),(1073,'priv','fr','ci-commitResult','',''),(1073,'priv','zh-cn','ci-commitResult','',''),(1073,'priv','zh-tw','ci-commitResult','',''),(1074,'priv','de','ci-checkCompileStatus','',''),(1074,'priv','en','ci-checkCompileStatus','',''),(1074,'priv','fr','ci-checkCompileStatus','',''),(1074,'priv','zh-cn','ci-checkCompileStatus','',''),(1074,'priv','zh-tw','ci-checkCompileStatus','',''),(1075,'priv','de','compile-browse','',''),(1075,'priv','en','compile-browse','',''),(1075,'priv','fr','compile-browse','',''),(1075,'priv','zh-cn','compile-browse','',''),(1075,'priv','zh-tw','compile-browse','',''),(1076,'priv','de','compile-logs','',''),(1076,'priv','en','compile-logs','',''),(1076,'priv','fr','compile-logs','',''),(1076,'priv','zh-cn','compile-logs','',''),(1076,'priv','zh-tw','compile-logs','',''),(1077,'priv','de','compile-syncCompile','',''),(1077,'priv','en','compile-syncCompile','',''),(1077,'priv','fr','compile-syncCompile','',''),(1077,'priv','zh-cn','compile-syncCompile','',''),(1077,'priv','zh-tw','compile-syncCompile','',''),(1078,'priv','de','jenkins-browseAction','',''),(1078,'priv','en','jenkins-browseAction','',''),(1078,'priv','fr','jenkins-browseAction','',''),(1078,'priv','zh-cn','jenkins-browseAction','',''),(1078,'priv','zh-tw','jenkins-browseAction','',''),(1079,'priv','de','jenkins-create','',''),(1079,'priv','en','jenkins-create','',''),(1079,'priv','fr','jenkins-create','',''),(1079,'priv','zh-cn','jenkins-create','',''),(1079,'priv','zh-tw','jenkins-create','',''),(1080,'priv','de','jenkins-edit','',''),(1080,'priv','en','jenkins-edit','',''),(1080,'priv','fr','jenkins-edit','',''),(1080,'priv','zh-cn','jenkins-edit','',''),(1080,'priv','zh-tw','jenkins-edit','',''),(1081,'priv','de','jenkins-deleteAction','',''),(1081,'priv','en','jenkins-deleteAction','',''),(1081,'priv','fr','jenkins-deleteAction','',''),(1081,'priv','zh-cn','jenkins-deleteAction','',''),(1081,'priv','zh-tw','jenkins-deleteAction','',''),(1082,'priv','de','job-browseAction','',''),(1082,'priv','en','job-browseAction','',''),(1082,'priv','fr','job-browseAction','',''),(1082,'priv','zh-cn','job-browseAction','',''),(1082,'priv','zh-tw','job-browseAction','',''),(1083,'priv','de','job-create','',''),(1083,'priv','en','job-create','',''),(1083,'priv','fr','job-create','',''),(1083,'priv','zh-cn','job-create','',''),(1083,'priv','zh-tw','job-create','',''),(1084,'priv','de','job-edit','',''),(1084,'priv','en','job-edit','',''),(1084,'priv','fr','job-edit','',''),(1084,'priv','zh-cn','job-edit','',''),(1084,'priv','zh-tw','job-edit','',''),(1085,'priv','de','job-delete','',''),(1085,'priv','en','job-delete','',''),(1085,'priv','fr','job-delete','',''),(1085,'priv','zh-cn','job-delete','',''),(1085,'priv','zh-tw','job-delete','',''),(1086,'priv','de','job-exec','',''),(1086,'priv','en','job-exec','',''),(1086,'priv','fr','job-exec','',''),(1086,'priv','zh-cn','job-exec','',''),(1086,'priv','zh-tw','job-exec','',''),(1087,'priv','de','job-view','',''),(1087,'priv','en','job-view','',''),(1087,'priv','fr','job-view','',''),(1087,'priv','zh-cn','job-view','',''),(1087,'priv','zh-tw','job-view','',''),(1088,'priv','de','datatable-setGlobal','',''),(1088,'priv','en','datatable-setGlobal','',''),(1088,'priv','fr','datatable-setGlobal','',''),(1088,'priv','zh-cn','datatable-setGlobal','',''),(1088,'priv','zh-tw','datatable-setGlobal','',''),(1089,'priv','de','gitlab-browseAction','',''),(1089,'priv','en','gitlab-browseAction','',''),(1089,'priv','fr','gitlab-browseAction','',''),(1089,'priv','zh-cn','gitlab-browseAction','',''),(1089,'priv','zh-tw','gitlab-browseAction','',''),(1090,'priv','de','gitlab-create','',''),(1090,'priv','en','gitlab-create','',''),(1090,'priv','fr','gitlab-create','',''),(1090,'priv','zh-cn','gitlab-create','',''),(1090,'priv','zh-tw','gitlab-create','',''),(1091,'priv','de','gitlab-edit','',''),(1091,'priv','en','gitlab-edit','',''),(1091,'priv','fr','gitlab-edit','',''),(1091,'priv','zh-cn','gitlab-edit','',''),(1091,'priv','zh-tw','gitlab-edit','',''),(1092,'priv','de','gitlab-view','',''),(1092,'priv','en','gitlab-view','',''),(1092,'priv','fr','gitlab-view','',''),(1092,'priv','zh-cn','gitlab-view','',''),(1092,'priv','zh-tw','gitlab-view','',''),(1093,'priv','de','gitlab-importIssue','',''),(1093,'priv','en','gitlab-importIssue','',''),(1093,'priv','fr','gitlab-importIssue','',''),(1093,'priv','zh-cn','gitlab-importIssue','',''),(1093,'priv','zh-tw','gitlab-importIssue','',''),(1094,'priv','de','gitlab-delete','',''),(1094,'priv','en','gitlab-delete','',''),(1094,'priv','fr','gitlab-delete','',''),(1094,'priv','zh-cn','gitlab-delete','',''),(1094,'priv','zh-tw','gitlab-delete','',''),(1095,'priv','de','gitlab-bindUser','',''),(1095,'priv','en','gitlab-bindUser','',''),(1095,'priv','fr','gitlab-bindUser','',''),(1095,'priv','zh-cn','gitlab-bindUser','',''),(1095,'priv','zh-tw','gitlab-bindUser','',''),(1096,'priv','de','gitlab-browseProject','',''),(1096,'priv','en','gitlab-browseProject','',''),(1096,'priv','fr','gitlab-browseProject','',''),(1096,'priv','zh-cn','gitlab-browseProject','',''),(1096,'priv','zh-tw','gitlab-browseProject','',''),(1097,'priv','de','gitlab-createProject','',''),(1097,'priv','en','gitlab-createProject','',''),(1097,'priv','fr','gitlab-createProject','',''),(1097,'priv','zh-cn','gitlab-createProject','',''),(1097,'priv','zh-tw','gitlab-createProject','',''),(1098,'priv','de','gitlab-editProject','',''),(1098,'priv','en','gitlab-editProject','',''),(1098,'priv','fr','gitlab-editProject','',''),(1098,'priv','zh-cn','gitlab-editProject','',''),(1098,'priv','zh-tw','gitlab-editProject','',''),(1099,'priv','de','gitlab-deleteProject','',''),(1099,'priv','en','gitlab-deleteProject','',''),(1099,'priv','fr','gitlab-deleteProject','',''),(1099,'priv','zh-cn','gitlab-deleteProject','',''),(1099,'priv','zh-tw','gitlab-deleteProject','',''),(1100,'priv','de','gitlab-browseGroup','',''),(1100,'priv','en','gitlab-browseGroup','',''),(1100,'priv','fr','gitlab-browseGroup','',''),(1100,'priv','zh-cn','gitlab-browseGroup','',''),(1100,'priv','zh-tw','gitlab-browseGroup','',''),(1101,'priv','de','gitlab-createGroup','',''),(1101,'priv','en','gitlab-createGroup','',''),(1101,'priv','fr','gitlab-createGroup','',''),(1101,'priv','zh-cn','gitlab-createGroup','',''),(1101,'priv','zh-tw','gitlab-createGroup','',''),(1102,'priv','de','gitlab-editGroup','',''),(1102,'priv','en','gitlab-editGroup','',''),(1102,'priv','fr','gitlab-editGroup','',''),(1102,'priv','zh-cn','gitlab-editGroup','',''),(1102,'priv','zh-tw','gitlab-editGroup','',''),(1103,'priv','de','gitlab-deleteGroup','',''),(1103,'priv','en','gitlab-deleteGroup','',''),(1103,'priv','fr','gitlab-deleteGroup','',''),(1103,'priv','zh-cn','gitlab-deleteGroup','',''),(1103,'priv','zh-tw','gitlab-deleteGroup','',''),(1104,'priv','de','gitlab-manageGroupMembers','',''),(1104,'priv','en','gitlab-manageGroupMembers','',''),(1104,'priv','fr','gitlab-manageGroupMembers','',''),(1104,'priv','zh-cn','gitlab-manageGroupMembers','',''),(1104,'priv','zh-tw','gitlab-manageGroupMembers','',''),(1105,'priv','de','gitlab-browseUser','',''),(1105,'priv','en','gitlab-browseUser','',''),(1105,'priv','fr','gitlab-browseUser','',''),(1105,'priv','zh-cn','gitlab-browseUser','',''),(1105,'priv','zh-tw','gitlab-browseUser','',''),(1106,'priv','de','gitlab-createUser','',''),(1106,'priv','en','gitlab-createUser','',''),(1106,'priv','fr','gitlab-createUser','',''),(1106,'priv','zh-cn','gitlab-createUser','',''),(1106,'priv','zh-tw','gitlab-createUser','',''),(1107,'priv','de','gitlab-editUser','',''),(1107,'priv','en','gitlab-editUser','',''),(1107,'priv','fr','gitlab-editUser','',''),(1107,'priv','zh-cn','gitlab-editUser','',''),(1107,'priv','zh-tw','gitlab-editUser','',''),(1108,'priv','de','gitlab-deleteUser','',''),(1108,'priv','en','gitlab-deleteUser','',''),(1108,'priv','fr','gitlab-deleteUser','',''),(1108,'priv','zh-cn','gitlab-deleteUser','',''),(1108,'priv','zh-tw','gitlab-deleteUser','',''),(1109,'priv','de','gitlab-createBranch','',''),(1109,'priv','en','gitlab-createBranch','',''),(1109,'priv','fr','gitlab-createBranch','',''),(1109,'priv','zh-cn','gitlab-createBranch','',''),(1109,'priv','zh-tw','gitlab-createBranch','',''),(1110,'priv','de','gitlab-browseBranch','',''),(1110,'priv','en','gitlab-browseBranch','',''),(1110,'priv','fr','gitlab-browseBranch','',''),(1110,'priv','zh-cn','gitlab-browseBranch','',''),(1110,'priv','zh-tw','gitlab-browseBranch','',''),(1111,'priv','de','gitlab-webhook','',''),(1111,'priv','en','gitlab-webhook','',''),(1111,'priv','fr','gitlab-webhook','',''),(1111,'priv','zh-cn','gitlab-webhook','',''),(1111,'priv','zh-tw','gitlab-webhook','',''),(1112,'priv','de','gitlab-createWebhook','',''),(1112,'priv','en','gitlab-createWebhook','',''),(1112,'priv','fr','gitlab-createWebhook','',''),(1112,'priv','zh-cn','gitlab-createWebhook','',''),(1112,'priv','zh-tw','gitlab-createWebhook','',''),(1113,'priv','de','gitlab-manageProjectMembers','',''),(1113,'priv','en','gitlab-manageProjectMembers','',''),(1113,'priv','fr','gitlab-manageProjectMembers','',''),(1113,'priv','zh-cn','gitlab-manageProjectMembers','',''),(1113,'priv','zh-tw','gitlab-manageProjectMembers','',''),(1114,'priv','de','gitlab-browseBranchPriv','',''),(1114,'priv','en','gitlab-browseBranchPriv','',''),(1114,'priv','fr','gitlab-browseBranchPriv','',''),(1114,'priv','zh-cn','gitlab-browseBranchPriv','',''),(1114,'priv','zh-tw','gitlab-browseBranchPriv','',''),(1115,'priv','de','gitlab-browseTagPriv','',''),(1115,'priv','en','gitlab-browseTagPriv','',''),(1115,'priv','fr','gitlab-browseTagPriv','',''),(1115,'priv','zh-cn','gitlab-browseTagPriv','',''),(1115,'priv','zh-tw','gitlab-browseTagPriv','',''),(1116,'priv','de','gitlab-browseTag','',''),(1116,'priv','en','gitlab-browseTag','',''),(1116,'priv','fr','gitlab-browseTag','',''),(1116,'priv','zh-cn','gitlab-browseTag','',''),(1116,'priv','zh-tw','gitlab-browseTag','',''),(1117,'priv','de','gitlab-createTag','',''),(1117,'priv','en','gitlab-createTag','',''),(1117,'priv','fr','gitlab-createTag','',''),(1117,'priv','zh-cn','gitlab-createTag','',''),(1117,'priv','zh-tw','gitlab-createTag','',''),(1118,'priv','de','gitlab-deleteTag','',''),(1118,'priv','en','gitlab-deleteTag','',''),(1118,'priv','fr','gitlab-deleteTag','',''),(1118,'priv','zh-cn','gitlab-deleteTag','',''),(1118,'priv','zh-tw','gitlab-deleteTag','',''),(1120,'priv','de','gogs-browseAction','',''),(1120,'priv','en','gogs-browseAction','',''),(1120,'priv','fr','gogs-browseAction','',''),(1120,'priv','zh-cn','gogs-browseAction','',''),(1120,'priv','zh-tw','gogs-browseAction','',''),(1121,'priv','de','gogs-create','',''),(1121,'priv','en','gogs-create','',''),(1121,'priv','fr','gogs-create','',''),(1121,'priv','zh-cn','gogs-create','',''),(1121,'priv','zh-tw','gogs-create','',''),(1122,'priv','de','gogs-edit','',''),(1122,'priv','en','gogs-edit','',''),(1122,'priv','fr','gogs-edit','',''),(1122,'priv','zh-cn','gogs-edit','',''),(1122,'priv','zh-tw','gogs-edit','',''),(1123,'priv','de','gogs-view','',''),(1123,'priv','en','gogs-view','',''),(1123,'priv','fr','gogs-view','',''),(1123,'priv','zh-cn','gogs-view','',''),(1123,'priv','zh-tw','gogs-view','',''),(1124,'priv','de','gogs-delete','',''),(1124,'priv','en','gogs-delete','',''),(1124,'priv','fr','gogs-delete','',''),(1124,'priv','zh-cn','gogs-delete','',''),(1124,'priv','zh-tw','gogs-delete','',''),(1125,'priv','de','gogs-bindUser','',''),(1125,'priv','en','gogs-bindUser','',''),(1125,'priv','fr','gogs-bindUser','',''),(1125,'priv','zh-cn','gogs-bindUser','',''),(1125,'priv','zh-tw','gogs-bindUser','',''),(1126,'priv','de','gitea-browseAction','',''),(1126,'priv','en','gitea-browseAction','',''),(1126,'priv','fr','gitea-browseAction','',''),(1126,'priv','zh-cn','gitea-browseAction','',''),(1126,'priv','zh-tw','gitea-browseAction','',''),(1127,'priv','de','gitea-create','',''),(1127,'priv','en','gitea-create','',''),(1127,'priv','fr','gitea-create','',''),(1127,'priv','zh-cn','gitea-create','',''),(1127,'priv','zh-tw','gitea-create','',''),(1128,'priv','de','gitea-edit','',''),(1128,'priv','en','gitea-edit','',''),(1128,'priv','fr','gitea-edit','',''),(1128,'priv','zh-cn','gitea-edit','',''),(1128,'priv','zh-tw','gitea-edit','',''),(1129,'priv','de','gitea-view','',''),(1129,'priv','en','gitea-view','',''),(1129,'priv','fr','gitea-view','',''),(1129,'priv','zh-cn','gitea-view','',''),(1129,'priv','zh-tw','gitea-view','',''),(1130,'priv','de','gitea-delete','',''),(1130,'priv','en','gitea-delete','',''),(1130,'priv','fr','gitea-delete','',''),(1130,'priv','zh-cn','gitea-delete','',''),(1130,'priv','zh-tw','gitea-delete','',''),(1131,'priv','de','gitea-bindUser','',''),(1131,'priv','en','gitea-bindUser','',''),(1131,'priv','fr','gitea-bindUser','',''),(1131,'priv','zh-cn','gitea-bindUser','',''),(1131,'priv','zh-tw','gitea-bindUser','',''),(1132,'priv','de','sonarqube-browse','',''),(1132,'priv','en','sonarqube-browse','',''),(1132,'priv','fr','sonarqube-browse','',''),(1132,'priv','zh-cn','sonarqube-browse','',''),(1132,'priv','zh-tw','sonarqube-browse','',''),(1133,'priv','de','sonarqube-create','',''),(1133,'priv','en','sonarqube-create','',''),(1133,'priv','fr','sonarqube-create','',''),(1133,'priv','zh-cn','sonarqube-create','',''),(1133,'priv','zh-tw','sonarqube-create','',''),(1134,'priv','de','sonarqube-edit','',''),(1134,'priv','en','sonarqube-edit','',''),(1134,'priv','fr','sonarqube-edit','',''),(1134,'priv','zh-cn','sonarqube-edit','',''),(1134,'priv','zh-tw','sonarqube-edit','',''),(1135,'priv','de','sonarqube-delete','',''),(1135,'priv','en','sonarqube-delete','',''),(1135,'priv','fr','sonarqube-delete','',''),(1135,'priv','zh-cn','sonarqube-delete','',''),(1135,'priv','zh-tw','sonarqube-delete','',''),(1136,'priv','de','sonarqube-browseProject','',''),(1136,'priv','en','sonarqube-browseProject','',''),(1136,'priv','fr','sonarqube-browseProject','',''),(1136,'priv','zh-cn','sonarqube-browseProject','',''),(1136,'priv','zh-tw','sonarqube-browseProject','',''),(1137,'priv','de','sonarqube-createProject','',''),(1137,'priv','en','sonarqube-createProject','',''),(1137,'priv','fr','sonarqube-createProject','',''),(1137,'priv','zh-cn','sonarqube-createProject','',''),(1137,'priv','zh-tw','sonarqube-createProject','',''),(1138,'priv','de','sonarqube-deleteProject','',''),(1138,'priv','en','sonarqube-deleteProject','',''),(1138,'priv','fr','sonarqube-deleteProject','',''),(1138,'priv','zh-cn','sonarqube-deleteProject','',''),(1138,'priv','zh-tw','sonarqube-deleteProject','',''),(1139,'priv','de','sonarqube-execJob','',''),(1139,'priv','en','sonarqube-execJob','',''),(1139,'priv','fr','sonarqube-execJob','',''),(1139,'priv','zh-cn','sonarqube-execJob','',''),(1139,'priv','zh-tw','sonarqube-execJob','',''),(1140,'priv','de','sonarqube-reportView','',''),(1140,'priv','en','sonarqube-reportView','',''),(1140,'priv','fr','sonarqube-reportView','',''),(1140,'priv','zh-cn','sonarqube-reportView','',''),(1140,'priv','zh-tw','sonarqube-reportView','',''),(1141,'priv','de','sonarqube-browseIssue','',''),(1141,'priv','en','sonarqube-browseIssue','',''),(1141,'priv','fr','sonarqube-browseIssue','',''),(1141,'priv','zh-cn','sonarqube-browseIssue','',''),(1141,'priv','zh-tw','sonarqube-browseIssue','',''),(1142,'priv','de','app-serverLink','',''),(1142,'priv','en','app-serverLink','',''),(1142,'priv','fr','app-serverLink','',''),(1142,'priv','zh-cn','app-serverLink','',''),(1142,'priv','zh-tw','app-serverLink','',''),(1143,'priv','de','webhook-list','',''),(1143,'priv','en','webhook-list','',''),(1143,'priv','fr','webhook-list','',''),(1143,'priv','zh-cn','webhook-list','',''),(1143,'priv','zh-tw','webhook-list','',''),(1144,'priv','de','webhook-create','',''),(1144,'priv','en','webhook-create','',''),(1144,'priv','fr','webhook-create','',''),(1144,'priv','zh-cn','webhook-create','',''),(1144,'priv','zh-tw','webhook-create','',''),(1145,'priv','de','webhook-edit','',''),(1145,'priv','en','webhook-edit','',''),(1145,'priv','fr','webhook-edit','',''),(1145,'priv','zh-cn','webhook-edit','',''),(1145,'priv','zh-tw','webhook-edit','',''),(1146,'priv','de','webhook-delete','',''),(1146,'priv','en','webhook-delete','',''),(1146,'priv','fr','webhook-delete','',''),(1146,'priv','zh-cn','webhook-delete','',''),(1146,'priv','zh-tw','webhook-delete','',''),(1147,'priv','de','webhook-logAction','',''),(1147,'priv','en','webhook-logAction','',''),(1147,'priv','fr','webhook-logAction','',''),(1147,'priv','zh-cn','webhook-logAction','',''),(1147,'priv','zh-tw','webhook-logAction','',''),(1148,'priv','de','webhook-bind','',''),(1148,'priv','en','webhook-bind','',''),(1148,'priv','fr','webhook-bind','',''),(1148,'priv','zh-cn','webhook-bind','',''),(1148,'priv','zh-tw','webhook-bind','',''),(1149,'priv','de','webhook-chooseDept','',''),(1149,'priv','en','webhook-chooseDept','',''),(1149,'priv','fr','webhook-chooseDept','',''),(1149,'priv','zh-cn','webhook-chooseDept','',''),(1149,'priv','zh-tw','webhook-chooseDept','',''),(1150,'priv','de','message-index','',''),(1150,'priv','en','message-index','',''),(1150,'priv','fr','message-index','',''),(1150,'priv','zh-cn','message-index','',''),(1150,'priv','zh-tw','message-index','',''),(1151,'priv','de','message-browser','',''),(1151,'priv','en','message-browser','',''),(1151,'priv','fr','message-browser','',''),(1151,'priv','zh-cn','message-browser','',''),(1151,'priv','zh-tw','message-browser','',''),(1152,'priv','de','message-setting','',''),(1152,'priv','en','message-setting','',''),(1152,'priv','fr','message-setting','',''),(1152,'priv','zh-cn','message-setting','',''),(1152,'priv','zh-tw','message-setting','',''),(1153,'priv','de','effort-calendarAction','',''),(1153,'priv','en','effort-calendarAction','',''),(1153,'priv','fr','effort-calendarAction','',''),(1153,'priv','zh-cn','effort-calendarAction','',''),(1153,'priv','zh-tw','effort-calendarAction','',''),(1154,'priv','de','effort-batchCreate','',''),(1154,'priv','en','effort-batchCreate','',''),(1154,'priv','fr','effort-batchCreate','',''),(1154,'priv','zh-cn','effort-batchCreate','',''),(1154,'priv','zh-tw','effort-batchCreate','',''),(1155,'priv','de','effort-createForObject','',''),(1155,'priv','en','effort-createForObject','',''),(1155,'priv','fr','effort-createForObject','',''),(1155,'priv','zh-cn','effort-createForObject','',''),(1155,'priv','zh-tw','effort-createForObject','',''),(1156,'priv','de','effort-edit','',''),(1156,'priv','en','effort-edit','',''),(1156,'priv','fr','effort-edit','',''),(1156,'priv','zh-cn','effort-edit','',''),(1156,'priv','zh-tw','effort-edit','',''),(1157,'priv','de','effort-batchEdit','',''),(1157,'priv','en','effort-batchEdit','',''),(1157,'priv','fr','effort-batchEdit','',''),(1157,'priv','zh-cn','effort-batchEdit','',''),(1157,'priv','zh-tw','effort-batchEdit','',''),(1158,'priv','de','effort-view','',''),(1158,'priv','en','effort-view','',''),(1158,'priv','fr','effort-view','',''),(1158,'priv','zh-cn','effort-view','',''),(1158,'priv','zh-tw','effort-view','',''),(1159,'priv','de','effort-delete','',''),(1159,'priv','en','effort-delete','',''),(1159,'priv','fr','effort-delete','',''),(1159,'priv','zh-cn','effort-delete','',''),(1159,'priv','zh-tw','effort-delete','',''),(1160,'priv','de','effort-exportAction','',''),(1160,'priv','en','effort-exportAction','',''),(1160,'priv','fr','effort-exportAction','',''),(1160,'priv','zh-cn','effort-exportAction','',''),(1160,'priv','zh-tw','effort-exportAction','',''),(1162,'priv','de','ldap-common','',''),(1162,'priv','en','ldap-common','',''),(1162,'priv','fr','ldap-common','',''),(1162,'priv','zh-cn','ldap-common','',''),(1162,'priv','zh-tw','ldap-common','',''),(1163,'priv','de','sqlbuilder-browseSQLView','',''),(1163,'priv','en','sqlbuilder-browseSQLView','',''),(1163,'priv','fr','sqlbuilder-browseSQLView','',''),(1163,'priv','zh-cn','sqlbuilder-browseSQLView','',''),(1163,'priv','zh-tw','sqlbuilder-browseSQLView','',''),(1164,'priv','de','sqlbuilder-createSQLView','',''),(1164,'priv','en','sqlbuilder-createSQLView','',''),(1164,'priv','fr','sqlbuilder-createSQLView','',''),(1164,'priv','zh-cn','sqlbuilder-createSQLView','',''),(1164,'priv','zh-tw','sqlbuilder-createSQLView','',''),(1165,'priv','de','sqlbuilder-editSQLView','',''),(1165,'priv','en','sqlbuilder-editSQLView','',''),(1165,'priv','fr','sqlbuilder-editSQLView','',''),(1165,'priv','zh-cn','sqlbuilder-editSQLView','',''),(1165,'priv','zh-tw','sqlbuilder-editSQLView','',''),(1166,'priv','de','sqlbuilder-deleteSQLView','',''),(1166,'priv','en','sqlbuilder-deleteSQLView','',''),(1166,'priv','fr','sqlbuilder-deleteSQLView','',''),(1166,'priv','zh-cn','sqlbuilder-deleteSQLView','',''),(1166,'priv','zh-tw','sqlbuilder-deleteSQLView','',''),(1168,'priv','de','feedback-create','',''),(1168,'priv','en','feedback-create','',''),(1168,'priv','fr','feedback-create','',''),(1168,'priv','zh-cn','feedback-create','',''),(1168,'priv','zh-tw','feedback-create','',''),(1169,'priv','de','feedback-edit','',''),(1169,'priv','en','feedback-edit','',''),(1169,'priv','fr','feedback-edit','',''),(1169,'priv','zh-cn','feedback-edit','',''),(1169,'priv','zh-tw','feedback-edit','',''),(1170,'priv','de','feedback-editOthers','',''),(1170,'priv','en','feedback-editOthers','',''),(1170,'priv','fr','feedback-editOthers','',''),(1170,'priv','zh-cn','feedback-editOthers','',''),(1170,'priv','zh-tw','feedback-editOthers','',''),(1171,'priv','de','feedback-adminView','',''),(1171,'priv','en','feedback-adminView','',''),(1171,'priv','fr','feedback-adminView','',''),(1171,'priv','zh-cn','feedback-adminView','',''),(1171,'priv','zh-tw','feedback-adminView','',''),(1172,'priv','de','feedback-admin','',''),(1172,'priv','en','feedback-admin','',''),(1172,'priv','fr','feedback-admin','',''),(1172,'priv','zh-cn','feedback-admin','',''),(1172,'priv','zh-tw','feedback-admin','',''),(1173,'priv','de','feedback-assignAction','',''),(1173,'priv','en','feedback-assignAction','',''),(1173,'priv','fr','feedback-assignAction','',''),(1173,'priv','zh-cn','feedback-assignAction','',''),(1173,'priv','zh-tw','feedback-assignAction','',''),(1174,'priv','de','feedback-toTask','',''),(1174,'priv','en','feedback-toTask','',''),(1174,'priv','fr','feedback-toTask','',''),(1174,'priv','zh-cn','feedback-toTask','',''),(1174,'priv','zh-tw','feedback-toTask','',''),(1175,'priv','de','feedback-toTodo','',''),(1175,'priv','en','feedback-toTodo','',''),(1175,'priv','fr','feedback-toTodo','',''),(1175,'priv','zh-cn','feedback-toTodo','',''),(1175,'priv','zh-tw','feedback-toTodo','',''),(1176,'priv','de','feedback-toBug','',''),(1176,'priv','en','feedback-toBug','',''),(1176,'priv','fr','feedback-toBug','',''),(1176,'priv','zh-cn','feedback-toBug','',''),(1176,'priv','zh-tw','feedback-toBug','',''),(1177,'priv','de','feedback-toStory','',''),(1177,'priv','en','feedback-toStory','',''),(1177,'priv','fr','feedback-toStory','',''),(1177,'priv','zh-cn','feedback-toStory','',''),(1177,'priv','zh-tw','feedback-toStory','',''),(1178,'priv','de','feedback-toTicket','',''),(1178,'priv','en','feedback-toTicket','',''),(1178,'priv','fr','feedback-toTicket','',''),(1178,'priv','zh-cn','feedback-toTicket','',''),(1178,'priv','zh-tw','feedback-toTicket','',''),(1179,'priv','de','feedback-toUserStory','',''),(1179,'priv','en','feedback-toUserStory','',''),(1179,'priv','fr','feedback-toUserStory','',''),(1179,'priv','zh-cn','feedback-toUserStory','',''),(1179,'priv','zh-tw','feedback-toUserStory','',''),(1180,'priv','de','feedback-reviewAction','',''),(1180,'priv','en','feedback-reviewAction','',''),(1180,'priv','fr','feedback-reviewAction','',''),(1180,'priv','zh-cn','feedback-reviewAction','',''),(1180,'priv','zh-tw','feedback-reviewAction','',''),(1181,'priv','de','feedback-comment','',''),(1181,'priv','en','feedback-comment','',''),(1181,'priv','fr','feedback-comment','',''),(1181,'priv','zh-cn','feedback-comment','',''),(1181,'priv','zh-tw','feedback-comment','',''),(1182,'priv','de','feedback-reply','',''),(1182,'priv','en','feedback-reply','',''),(1182,'priv','fr','feedback-reply','',''),(1182,'priv','zh-cn','feedback-reply','',''),(1182,'priv','zh-tw','feedback-reply','',''),(1183,'priv','de','feedback-ask','',''),(1183,'priv','en','feedback-ask','',''),(1183,'priv','fr','feedback-ask','',''),(1183,'priv','zh-cn','feedback-ask','',''),(1183,'priv','zh-tw','feedback-ask','',''),(1184,'priv','de','feedback-closeAction','',''),(1184,'priv','en','feedback-closeAction','',''),(1184,'priv','fr','feedback-closeAction','',''),(1184,'priv','zh-cn','feedback-closeAction','',''),(1184,'priv','zh-tw','feedback-closeAction','',''),(1185,'priv','de','feedback-delete','',''),(1185,'priv','en','feedback-delete','',''),(1185,'priv','fr','feedback-delete','',''),(1185,'priv','zh-cn','feedback-delete','',''),(1185,'priv','zh-tw','feedback-delete','',''),(1186,'priv','de','feedback-activate','',''),(1186,'priv','en','feedback-activate','',''),(1186,'priv','fr','feedback-activate','',''),(1186,'priv','zh-cn','feedback-activate','',''),(1186,'priv','zh-tw','feedback-activate','',''),(1187,'priv','de','feedback-exportAction','',''),(1187,'priv','en','feedback-exportAction','',''),(1187,'priv','fr','feedback-exportAction','',''),(1187,'priv','zh-cn','feedback-exportAction','',''),(1187,'priv','zh-tw','feedback-exportAction','',''),(1188,'priv','de','feedback-batchEdit','',''),(1188,'priv','en','feedback-batchEdit','',''),(1188,'priv','fr','feedback-batchEdit','',''),(1188,'priv','zh-cn','feedback-batchEdit','',''),(1188,'priv','zh-tw','feedback-batchEdit','',''),(1189,'priv','de','feedback-batchClose','',''),(1189,'priv','en','feedback-batchClose','',''),(1189,'priv','fr','feedback-batchClose','',''),(1189,'priv','zh-cn','feedback-batchClose','',''),(1189,'priv','zh-tw','feedback-batchClose','',''),(1190,'priv','de','feedback-batchReview','',''),(1190,'priv','en','feedback-batchReview','',''),(1190,'priv','fr','feedback-batchReview','',''),(1190,'priv','zh-cn','feedback-batchReview','',''),(1190,'priv','zh-tw','feedback-batchReview','',''),(1191,'priv','de','feedback-batchAssignTo','',''),(1191,'priv','en','feedback-batchAssignTo','',''),(1191,'priv','fr','feedback-batchAssignTo','',''),(1191,'priv','zh-cn','feedback-batchAssignTo','',''),(1191,'priv','zh-tw','feedback-batchAssignTo','',''),(1193,'priv','de','feedback-products','',''),(1193,'priv','en','feedback-products','',''),(1193,'priv','fr','feedback-products','',''),(1193,'priv','zh-cn','feedback-products','',''),(1193,'priv','zh-tw','feedback-products','',''),(1194,'priv','de','feedback-manageProduct','',''),(1194,'priv','en','feedback-manageProduct','',''),(1194,'priv','fr','feedback-manageProduct','',''),(1194,'priv','zh-cn','feedback-manageProduct','',''),(1194,'priv','zh-tw','feedback-manageProduct','',''),(1195,'priv','de','feedback-import','',''),(1195,'priv','en','feedback-import','',''),(1195,'priv','fr','feedback-import','',''),(1195,'priv','zh-cn','feedback-import','',''),(1195,'priv','zh-tw','feedback-import','',''),(1196,'priv','de','feedback-exportTemplate','',''),(1196,'priv','en','feedback-exportTemplate','',''),(1196,'priv','fr','feedback-exportTemplate','',''),(1196,'priv','zh-cn','feedback-exportTemplate','',''),(1196,'priv','zh-tw','feedback-exportTemplate','',''),(1197,'priv','de','feedback-syncProduct','',''),(1197,'priv','en','feedback-syncProduct','',''),(1197,'priv','fr','feedback-syncProduct','',''),(1197,'priv','zh-cn','feedback-syncProduct','',''),(1197,'priv','zh-tw','feedback-syncProduct','',''),(1198,'priv','de','feedback-productSetting','',''),(1198,'priv','en','feedback-productSetting','',''),(1198,'priv','fr','feedback-productSetting','',''),(1198,'priv','zh-cn','feedback-productSetting','',''),(1198,'priv','zh-tw','feedback-productSetting','',''),(1199,'priv','de','faq-browse','',''),(1199,'priv','en','faq-browse','',''),(1199,'priv','fr','faq-browse','',''),(1199,'priv','zh-cn','faq-browse','',''),(1199,'priv','zh-tw','faq-browse','',''),(1200,'priv','de','faq-create','',''),(1200,'priv','en','faq-create','',''),(1200,'priv','fr','faq-create','',''),(1200,'priv','zh-cn','faq-create','',''),(1200,'priv','zh-tw','faq-create','',''),(1201,'priv','de','faq-edit','',''),(1201,'priv','en','faq-edit','',''),(1201,'priv','fr','faq-edit','',''),(1201,'priv','zh-cn','faq-edit','',''),(1201,'priv','zh-tw','faq-edit','',''),(1202,'priv','de','faq-delete','',''),(1202,'priv','en','faq-delete','',''),(1202,'priv','fr','faq-delete','',''),(1202,'priv','zh-cn','faq-delete','',''),(1202,'priv','zh-tw','faq-delete','',''),(1204,'priv','de','ticket-create','',''),(1204,'priv','en','ticket-create','',''),(1204,'priv','fr','ticket-create','',''),(1204,'priv','zh-cn','ticket-create','',''),(1204,'priv','zh-tw','ticket-create','',''),(1205,'priv','de','ticket-edit','',''),(1205,'priv','en','ticket-edit','',''),(1205,'priv','fr','ticket-edit','',''),(1205,'priv','zh-cn','ticket-edit','',''),(1205,'priv','zh-tw','ticket-edit','',''),(1206,'priv','de','ticket-view','',''),(1206,'priv','en','ticket-view','',''),(1206,'priv','fr','ticket-view','',''),(1206,'priv','zh-cn','ticket-view','',''),(1206,'priv','zh-tw','ticket-view','',''),(1207,'priv','de','ticket-browse','',''),(1207,'priv','en','ticket-browse','',''),(1207,'priv','fr','ticket-browse','',''),(1207,'priv','zh-cn','ticket-browse','',''),(1207,'priv','zh-tw','ticket-browse','',''),(1208,'priv','de','ticket-assign','',''),(1208,'priv','en','ticket-assign','',''),(1208,'priv','fr','ticket-assign','',''),(1208,'priv','zh-cn','ticket-assign','',''),(1208,'priv','zh-tw','ticket-assign','',''),(1209,'priv','de','ticket-createBug','',''),(1209,'priv','en','ticket-createBug','',''),(1209,'priv','fr','ticket-createBug','',''),(1209,'priv','zh-cn','ticket-createBug','',''),(1209,'priv','zh-tw','ticket-createBug','',''),(1210,'priv','de','ticket-createStory','',''),(1210,'priv','en','ticket-createStory','',''),(1210,'priv','fr','ticket-createStory','',''),(1210,'priv','zh-cn','ticket-createStory','',''),(1210,'priv','zh-tw','ticket-createStory','',''),(1211,'priv','de','ticket-start','',''),(1211,'priv','en','ticket-start','',''),(1211,'priv','fr','ticket-start','',''),(1211,'priv','zh-cn','ticket-start','',''),(1211,'priv','zh-tw','ticket-start','',''),(1212,'priv','de','ticket-finish','',''),(1212,'priv','en','ticket-finish','',''),(1212,'priv','fr','ticket-finish','',''),(1212,'priv','zh-cn','ticket-finish','',''),(1212,'priv','zh-tw','ticket-finish','',''),(1213,'priv','de','ticket-close','',''),(1213,'priv','en','ticket-close','',''),(1213,'priv','fr','ticket-close','',''),(1213,'priv','zh-cn','ticket-close','',''),(1213,'priv','zh-tw','ticket-close','',''),(1214,'priv','de','ticket-activate','',''),(1214,'priv','en','ticket-activate','',''),(1214,'priv','fr','ticket-activate','',''),(1214,'priv','zh-cn','ticket-activate','',''),(1214,'priv','zh-tw','ticket-activate','',''),(1215,'priv','de','ticket-delete','',''),(1215,'priv','en','ticket-delete','',''),(1215,'priv','fr','ticket-delete','',''),(1215,'priv','zh-cn','ticket-delete','',''),(1215,'priv','zh-tw','ticket-delete','',''),(1216,'priv','de','ticket-exportTemplate','',''),(1216,'priv','en','ticket-exportTemplate','',''),(1216,'priv','fr','ticket-exportTemplate','',''),(1216,'priv','zh-cn','ticket-exportTemplate','',''),(1216,'priv','zh-tw','ticket-exportTemplate','',''),(1217,'priv','de','ticket-import','',''),(1217,'priv','en','ticket-import','',''),(1217,'priv','fr','ticket-import','',''),(1217,'priv','zh-cn','ticket-import','',''),(1217,'priv','zh-tw','ticket-import','',''),(1218,'priv','de','ticket-exportAction','',''),(1218,'priv','en','ticket-exportAction','',''),(1218,'priv','fr','ticket-exportAction','',''),(1218,'priv','zh-cn','ticket-exportAction','',''),(1218,'priv','zh-tw','ticket-exportAction','',''),(1219,'priv','de','ticket-batchEdit','',''),(1219,'priv','en','ticket-batchEdit','',''),(1219,'priv','fr','ticket-batchEdit','',''),(1219,'priv','zh-cn','ticket-batchEdit','',''),(1219,'priv','zh-tw','ticket-batchEdit','',''),(1220,'priv','de','ticket-batchClose','',''),(1220,'priv','en','ticket-batchClose','',''),(1220,'priv','fr','ticket-batchClose','',''),(1220,'priv','zh-cn','ticket-batchClose','',''),(1220,'priv','zh-tw','ticket-batchClose','',''),(1221,'priv','de','ticket-batchActivate','',''),(1221,'priv','en','ticket-batchActivate','',''),(1221,'priv','fr','ticket-batchActivate','',''),(1221,'priv','zh-cn','ticket-batchActivate','',''),(1221,'priv','zh-tw','ticket-batchActivate','',''),(1222,'priv','de','ticket-batchFinish','',''),(1222,'priv','en','ticket-batchFinish','',''),(1222,'priv','fr','ticket-batchFinish','',''),(1222,'priv','zh-cn','ticket-batchFinish','',''),(1222,'priv','zh-tw','ticket-batchFinish','',''),(1223,'priv','de','ticket-batchAssignTo','',''),(1223,'priv','en','ticket-batchAssignTo','',''),(1223,'priv','fr','ticket-batchAssignTo','',''),(1223,'priv','zh-cn','ticket-batchAssignTo','',''),(1223,'priv','zh-tw','ticket-batchAssignTo','',''),(1224,'priv','de','ticket-syncProduct','',''),(1224,'priv','en','ticket-syncProduct','',''),(1224,'priv','fr','ticket-syncProduct','',''),(1224,'priv','zh-cn','ticket-syncProduct','',''),(1224,'priv','zh-tw','ticket-syncProduct','',''),(1225,'priv','de','attend-department','',''),(1225,'priv','en','attend-department','',''),(1225,'priv','fr','attend-department','',''),(1225,'priv','zh-cn','attend-department','',''),(1225,'priv','zh-tw','attend-department','',''),(1226,'priv','de','attend-company','',''),(1226,'priv','en','attend-company','',''),(1226,'priv','fr','attend-company','',''),(1226,'priv','zh-cn','attend-company','',''),(1226,'priv','zh-tw','attend-company','',''),(1227,'priv','de','attend-browseReview','',''),(1227,'priv','en','attend-browseReview','',''),(1227,'priv','fr','attend-browseReview','',''),(1227,'priv','zh-cn','attend-browseReview','',''),(1227,'priv','zh-tw','attend-browseReview','',''),(1228,'priv','de','attend-review','',''),(1228,'priv','en','attend-review','',''),(1228,'priv','fr','attend-review','',''),(1228,'priv','zh-cn','attend-review','',''),(1228,'priv','zh-tw','attend-review','',''),(1229,'priv','de','attend-exportAction','',''),(1229,'priv','en','attend-exportAction','',''),(1229,'priv','fr','attend-exportAction','',''),(1229,'priv','zh-cn','attend-exportAction','',''),(1229,'priv','zh-tw','attend-exportAction','',''),(1230,'priv','de','attend-reportAction','',''),(1230,'priv','en','attend-reportAction','',''),(1230,'priv','fr','attend-reportAction','',''),(1230,'priv','zh-cn','attend-reportAction','',''),(1230,'priv','zh-tw','attend-reportAction','',''),(1231,'priv','de','attend-saveStatAction','',''),(1231,'priv','en','attend-saveStatAction','',''),(1231,'priv','fr','attend-saveStatAction','',''),(1231,'priv','zh-cn','attend-saveStatAction','',''),(1231,'priv','zh-tw','attend-saveStatAction','',''),(1232,'priv','de','attend-exportStat','',''),(1232,'priv','en','attend-exportStat','',''),(1232,'priv','fr','attend-exportStat','',''),(1232,'priv','zh-cn','attend-exportStat','',''),(1232,'priv','zh-tw','attend-exportStat','',''),(1233,'priv','de','attend-detailAction','',''),(1233,'priv','en','attend-detailAction','',''),(1233,'priv','fr','attend-detailAction','',''),(1233,'priv','zh-cn','attend-detailAction','',''),(1233,'priv','zh-tw','attend-detailAction','',''),(1234,'priv','de','attend-exportDetail','',''),(1234,'priv','en','attend-exportDetail','',''),(1234,'priv','fr','attend-exportDetail','',''),(1234,'priv','zh-cn','attend-exportDetail','',''),(1234,'priv','zh-tw','attend-exportDetail','',''),(1235,'priv','de','attend-settings','',''),(1235,'priv','en','attend-settings','',''),(1235,'priv','fr','attend-settings','',''),(1235,'priv','zh-cn','attend-settings','',''),(1235,'priv','zh-tw','attend-settings','',''),(1236,'priv','de','attend-personalSettings','',''),(1236,'priv','en','attend-personalSettings','',''),(1236,'priv','fr','attend-personalSettings','',''),(1236,'priv','zh-cn','attend-personalSettings','',''),(1236,'priv','zh-tw','attend-personalSettings','',''),(1237,'priv','de','attend-setManager','',''),(1237,'priv','en','attend-setManager','',''),(1237,'priv','fr','attend-setManager','',''),(1237,'priv','zh-cn','attend-setManager','',''),(1237,'priv','zh-tw','attend-setManager','',''),(1238,'priv','de','attend-personal','',''),(1238,'priv','en','attend-personal','',''),(1238,'priv','fr','attend-personal','',''),(1238,'priv','zh-cn','attend-personal','',''),(1238,'priv','zh-tw','attend-personal','',''),(1239,'priv','de','attend-editAction','',''),(1239,'priv','en','attend-editAction','',''),(1239,'priv','fr','attend-editAction','',''),(1239,'priv','zh-cn','attend-editAction','',''),(1239,'priv','zh-tw','attend-editAction','',''),(1240,'priv','de','leave-browseReview','',''),(1240,'priv','en','leave-browseReview','',''),(1240,'priv','fr','leave-browseReview','',''),(1240,'priv','zh-cn','leave-browseReview','',''),(1240,'priv','zh-tw','leave-browseReview','',''),(1241,'priv','de','leave-companyAction','',''),(1241,'priv','en','leave-companyAction','',''),(1241,'priv','fr','leave-companyAction','',''),(1241,'priv','zh-cn','leave-companyAction','',''),(1241,'priv','zh-tw','leave-companyAction','',''),(1242,'priv','de','leave-reviewAction','',''),(1242,'priv','en','leave-reviewAction','',''),(1242,'priv','fr','leave-reviewAction','',''),(1242,'priv','zh-cn','leave-reviewAction','',''),(1242,'priv','zh-tw','leave-reviewAction','',''),(1243,'priv','de','leave-exportAction','',''),(1243,'priv','en','leave-exportAction','',''),(1243,'priv','fr','leave-exportAction','',''),(1243,'priv','zh-cn','leave-exportAction','',''),(1243,'priv','zh-tw','leave-exportAction','',''),(1244,'priv','de','leave-setReviewerAction','',''),(1244,'priv','en','leave-setReviewerAction','',''),(1244,'priv','fr','leave-setReviewerAction','',''),(1244,'priv','zh-cn','leave-setReviewerAction','',''),(1244,'priv','zh-tw','leave-setReviewerAction','',''),(1245,'priv','de','leave-personalAnnual','',''),(1245,'priv','en','leave-personalAnnual','',''),(1245,'priv','fr','leave-personalAnnual','',''),(1245,'priv','zh-cn','leave-personalAnnual','',''),(1245,'priv','zh-tw','leave-personalAnnual','',''),(1246,'priv','de','leave-personal','',''),(1246,'priv','en','leave-personal','',''),(1246,'priv','fr','leave-personal','',''),(1246,'priv','zh-cn','leave-personal','',''),(1246,'priv','zh-tw','leave-personal','',''),(1247,'priv','de','leave-createAction','',''),(1247,'priv','en','leave-createAction','',''),(1247,'priv','fr','leave-createAction','',''),(1247,'priv','zh-cn','leave-createAction','',''),(1247,'priv','zh-tw','leave-createAction','',''),(1248,'priv','de','leave-editAction','',''),(1248,'priv','en','leave-editAction','',''),(1248,'priv','fr','leave-editAction','',''),(1248,'priv','zh-cn','leave-editAction','',''),(1248,'priv','zh-tw','leave-editAction','',''),(1249,'priv','de','leave-deleteAction','',''),(1249,'priv','en','leave-deleteAction','',''),(1249,'priv','fr','leave-deleteAction','',''),(1249,'priv','zh-cn','leave-deleteAction','',''),(1249,'priv','zh-tw','leave-deleteAction','',''),(1250,'priv','de','leave-viewAction','',''),(1250,'priv','en','leave-viewAction','',''),(1250,'priv','fr','leave-viewAction','',''),(1250,'priv','zh-cn','leave-viewAction','',''),(1250,'priv','zh-tw','leave-viewAction','',''),(1251,'priv','de','leave-switchstatus','',''),(1251,'priv','en','leave-switchstatus','',''),(1251,'priv','fr','leave-switchstatus','',''),(1251,'priv','zh-cn','leave-switchstatus','',''),(1251,'priv','zh-tw','leave-switchstatus','',''),(1252,'priv','de','leave-backAction','',''),(1252,'priv','en','leave-backAction','',''),(1252,'priv','fr','leave-backAction','',''),(1252,'priv','zh-cn','leave-backAction','',''),(1252,'priv','zh-tw','leave-backAction','',''),(1253,'priv','de','makeup-browseReview','',''),(1253,'priv','en','makeup-browseReview','',''),(1253,'priv','fr','makeup-browseReview','',''),(1253,'priv','zh-cn','makeup-browseReview','',''),(1253,'priv','zh-tw','makeup-browseReview','',''),(1254,'priv','de','makeup-companyAction','',''),(1254,'priv','en','makeup-companyAction','',''),(1254,'priv','fr','makeup-companyAction','',''),(1254,'priv','zh-cn','makeup-companyAction','',''),(1254,'priv','zh-tw','makeup-companyAction','',''),(1255,'priv','de','makeup-reviewAction','',''),(1255,'priv','en','makeup-reviewAction','',''),(1255,'priv','fr','makeup-reviewAction','',''),(1255,'priv','zh-cn','makeup-reviewAction','',''),(1255,'priv','zh-tw','makeup-reviewAction','',''),(1256,'priv','de','makeup-exportAction','',''),(1256,'priv','en','makeup-exportAction','',''),(1256,'priv','fr','makeup-exportAction','',''),(1256,'priv','zh-cn','makeup-exportAction','',''),(1256,'priv','zh-tw','makeup-exportAction','',''),(1257,'priv','de','makeup-setReviewerAction','',''),(1257,'priv','en','makeup-setReviewerAction','',''),(1257,'priv','fr','makeup-setReviewerAction','',''),(1257,'priv','zh-cn','makeup-setReviewerAction','',''),(1257,'priv','zh-tw','makeup-setReviewerAction','',''),(1258,'priv','de','makeup-personal','',''),(1258,'priv','en','makeup-personal','',''),(1258,'priv','fr','makeup-personal','',''),(1258,'priv','zh-cn','makeup-personal','',''),(1258,'priv','zh-tw','makeup-personal','',''),(1259,'priv','de','makeup-createAction','',''),(1259,'priv','en','makeup-createAction','',''),(1259,'priv','fr','makeup-createAction','',''),(1259,'priv','zh-cn','makeup-createAction','',''),(1259,'priv','zh-tw','makeup-createAction','',''),(1260,'priv','de','makeup-editAction','',''),(1260,'priv','en','makeup-editAction','',''),(1260,'priv','fr','makeup-editAction','',''),(1260,'priv','zh-cn','makeup-editAction','',''),(1260,'priv','zh-tw','makeup-editAction','',''),(1261,'priv','de','makeup-viewAction','',''),(1261,'priv','en','makeup-viewAction','',''),(1261,'priv','fr','makeup-viewAction','',''),(1261,'priv','zh-cn','makeup-viewAction','',''),(1261,'priv','zh-tw','makeup-viewAction','',''),(1262,'priv','de','makeup-deleteAction','',''),(1262,'priv','en','makeup-deleteAction','',''),(1262,'priv','fr','makeup-deleteAction','',''),(1262,'priv','zh-cn','makeup-deleteAction','',''),(1262,'priv','zh-tw','makeup-deleteAction','',''),(1263,'priv','de','makeup-switchstatus','',''),(1263,'priv','en','makeup-switchstatus','',''),(1263,'priv','fr','makeup-switchstatus','',''),(1263,'priv','zh-cn','makeup-switchstatus','',''),(1263,'priv','zh-tw','makeup-switchstatus','',''),(1264,'priv','de','overtime-browseReview','',''),(1264,'priv','en','overtime-browseReview','',''),(1264,'priv','fr','overtime-browseReview','',''),(1264,'priv','zh-cn','overtime-browseReview','',''),(1264,'priv','zh-tw','overtime-browseReview','',''),(1265,'priv','de','overtime-companyAction','',''),(1265,'priv','en','overtime-companyAction','',''),(1265,'priv','fr','overtime-companyAction','',''),(1265,'priv','zh-cn','overtime-companyAction','',''),(1265,'priv','zh-tw','overtime-companyAction','',''),(1266,'priv','de','overtime-reviewAction','',''),(1266,'priv','en','overtime-reviewAction','',''),(1266,'priv','fr','overtime-reviewAction','',''),(1266,'priv','zh-cn','overtime-reviewAction','',''),(1266,'priv','zh-tw','overtime-reviewAction','',''),(1267,'priv','de','overtime-exportAction','',''),(1267,'priv','en','overtime-exportAction','',''),(1267,'priv','fr','overtime-exportAction','',''),(1267,'priv','zh-cn','overtime-exportAction','',''),(1267,'priv','zh-tw','overtime-exportAction','',''),(1268,'priv','de','overtime-setReviewerAction','',''),(1268,'priv','en','overtime-setReviewerAction','',''),(1268,'priv','fr','overtime-setReviewerAction','',''),(1268,'priv','zh-cn','overtime-setReviewerAction','',''),(1268,'priv','zh-tw','overtime-setReviewerAction','',''),(1269,'priv','de','overtime-personal','',''),(1269,'priv','en','overtime-personal','',''),(1269,'priv','fr','overtime-personal','',''),(1269,'priv','zh-cn','overtime-personal','',''),(1269,'priv','zh-tw','overtime-personal','',''),(1270,'priv','de','overtime-createAction','',''),(1270,'priv','en','overtime-createAction','',''),(1270,'priv','fr','overtime-createAction','',''),(1270,'priv','zh-cn','overtime-createAction','',''),(1270,'priv','zh-tw','overtime-createAction','',''),(1271,'priv','de','overtime-editAction','',''),(1271,'priv','en','overtime-editAction','',''),(1271,'priv','fr','overtime-editAction','',''),(1271,'priv','zh-cn','overtime-editAction','',''),(1271,'priv','zh-tw','overtime-editAction','',''),(1272,'priv','de','overtime-viewAction','',''),(1272,'priv','en','overtime-viewAction','',''),(1272,'priv','fr','overtime-viewAction','',''),(1272,'priv','zh-cn','overtime-viewAction','',''),(1272,'priv','zh-tw','overtime-viewAction','',''),(1273,'priv','de','overtime-deleteAction','',''),(1273,'priv','en','overtime-deleteAction','',''),(1273,'priv','fr','overtime-deleteAction','',''),(1273,'priv','zh-cn','overtime-deleteAction','',''),(1273,'priv','zh-tw','overtime-deleteAction','',''),(1274,'priv','de','overtime-switchstatus','',''),(1274,'priv','en','overtime-switchstatus','',''),(1274,'priv','fr','overtime-switchstatus','',''),(1274,'priv','zh-cn','overtime-switchstatus','',''),(1274,'priv','zh-tw','overtime-switchstatus','',''),(1275,'priv','de','lieu-companyAction','',''),(1275,'priv','en','lieu-companyAction','',''),(1275,'priv','fr','lieu-companyAction','',''),(1275,'priv','zh-cn','lieu-companyAction','',''),(1275,'priv','zh-tw','lieu-companyAction','',''),(1276,'priv','de','lieu-browseReviewAction','',''),(1276,'priv','en','lieu-browseReviewAction','',''),(1276,'priv','fr','lieu-browseReviewAction','',''),(1276,'priv','zh-cn','lieu-browseReviewAction','',''),(1276,'priv','zh-tw','lieu-browseReviewAction','',''),(1277,'priv','de','lieu-reviewAction','',''),(1277,'priv','en','lieu-reviewAction','',''),(1277,'priv','fr','lieu-reviewAction','',''),(1277,'priv','zh-cn','lieu-reviewAction','',''),(1277,'priv','zh-tw','lieu-reviewAction','',''),(1278,'priv','de','lieu-setReviewerAction','',''),(1278,'priv','en','lieu-setReviewerAction','',''),(1278,'priv','fr','lieu-setReviewerAction','',''),(1278,'priv','zh-cn','lieu-setReviewerAction','',''),(1278,'priv','zh-tw','lieu-setReviewerAction','',''),(1279,'priv','de','lieu-personal','',''),(1279,'priv','en','lieu-personal','',''),(1279,'priv','fr','lieu-personal','',''),(1279,'priv','zh-cn','lieu-personal','',''),(1279,'priv','zh-tw','lieu-personal','',''),(1280,'priv','de','lieu-createAction','',''),(1280,'priv','en','lieu-createAction','',''),(1280,'priv','fr','lieu-createAction','',''),(1280,'priv','zh-cn','lieu-createAction','',''),(1280,'priv','zh-tw','lieu-createAction','',''),(1281,'priv','de','lieu-editAction','',''),(1281,'priv','en','lieu-editAction','',''),(1281,'priv','fr','lieu-editAction','',''),(1281,'priv','zh-cn','lieu-editAction','',''),(1281,'priv','zh-tw','lieu-editAction','',''),(1282,'priv','de','lieu-deleteAction','',''),(1282,'priv','en','lieu-deleteAction','',''),(1282,'priv','fr','lieu-deleteAction','',''),(1282,'priv','zh-cn','lieu-deleteAction','',''),(1282,'priv','zh-tw','lieu-deleteAction','',''),(1283,'priv','de','lieu-viewAction','',''),(1283,'priv','en','lieu-viewAction','',''),(1283,'priv','fr','lieu-viewAction','',''),(1283,'priv','zh-cn','lieu-viewAction','',''),(1283,'priv','zh-tw','lieu-viewAction','',''),(1284,'priv','de','lieu-switchstatus','',''),(1284,'priv','en','lieu-switchstatus','',''),(1284,'priv','fr','lieu-switchstatus','',''),(1284,'priv','zh-cn','lieu-switchstatus','',''),(1284,'priv','zh-tw','lieu-switchstatus','',''),(1285,'priv','de','ops-index','',''),(1285,'priv','en','ops-index','',''),(1285,'priv','fr','ops-index','',''),(1285,'priv','zh-cn','ops-index','',''),(1285,'priv','zh-tw','ops-index','',''),(1286,'priv','de','ops-setting','',''),(1286,'priv','en','ops-setting','',''),(1286,'priv','fr','ops-setting','',''),(1286,'priv','zh-cn','ops-setting','',''),(1286,'priv','zh-tw','ops-setting','',''),(1287,'priv','de','host-browse','',''),(1287,'priv','en','host-browse','',''),(1287,'priv','fr','host-browse','',''),(1287,'priv','zh-cn','host-browse','',''),(1287,'priv','zh-tw','host-browse','',''),(1288,'priv','de','host-create','',''),(1288,'priv','en','host-create','',''),(1288,'priv','fr','host-create','',''),(1288,'priv','zh-cn','host-create','',''),(1288,'priv','zh-tw','host-create','',''),(1289,'priv','de','host-editAction','',''),(1289,'priv','en','host-editAction','',''),(1289,'priv','fr','host-editAction','',''),(1289,'priv','zh-cn','host-editAction','',''),(1289,'priv','zh-tw','host-editAction','',''),(1290,'priv','de','host-view','',''),(1290,'priv','en','host-view','',''),(1290,'priv','fr','host-view','',''),(1290,'priv','zh-cn','host-view','',''),(1290,'priv','zh-tw','host-view','',''),(1291,'priv','de','host-deleteAction','',''),(1291,'priv','en','host-deleteAction','',''),(1291,'priv','fr','host-deleteAction','',''),(1291,'priv','zh-cn','host-deleteAction','',''),(1291,'priv','zh-tw','host-deleteAction','',''),(1292,'priv','de','host-changeStatus','',''),(1292,'priv','en','host-changeStatus','',''),(1292,'priv','fr','host-changeStatus','',''),(1292,'priv','zh-cn','host-changeStatus','',''),(1292,'priv','zh-tw','host-changeStatus','',''),(1293,'priv','de','host-treemap','',''),(1293,'priv','en','host-treemap','',''),(1293,'priv','fr','host-treemap','',''),(1293,'priv','zh-cn','host-treemap','',''),(1293,'priv','zh-tw','host-treemap','',''),(1294,'priv','de','serverroom-browse','',''),(1294,'priv','en','serverroom-browse','',''),(1294,'priv','fr','serverroom-browse','',''),(1294,'priv','zh-cn','serverroom-browse','',''),(1294,'priv','zh-tw','serverroom-browse','',''),(1295,'priv','de','serverroom-create','',''),(1295,'priv','en','serverroom-create','',''),(1295,'priv','fr','serverroom-create','',''),(1295,'priv','zh-cn','serverroom-create','',''),(1295,'priv','zh-tw','serverroom-create','',''),(1296,'priv','de','serverroom-editAction','',''),(1296,'priv','en','serverroom-editAction','',''),(1296,'priv','fr','serverroom-editAction','',''),(1296,'priv','zh-cn','serverroom-editAction','',''),(1296,'priv','zh-tw','serverroom-editAction','',''),(1297,'priv','de','serverroom-view','',''),(1297,'priv','en','serverroom-view','',''),(1297,'priv','fr','serverroom-view','',''),(1297,'priv','zh-cn','serverroom-view','',''),(1297,'priv','zh-tw','serverroom-view','',''),(1298,'priv','de','serverroom-delete','',''),(1298,'priv','en','serverroom-delete','',''),(1298,'priv','fr','serverroom-delete','',''),(1298,'priv','zh-cn','serverroom-delete','',''),(1298,'priv','zh-tw','serverroom-delete','',''),(1299,'priv','de','account-browse','',''),(1299,'priv','en','account-browse','',''),(1299,'priv','fr','account-browse','',''),(1299,'priv','zh-cn','account-browse','',''),(1299,'priv','zh-tw','account-browse','',''),(1300,'priv','de','account-create','',''),(1300,'priv','en','account-create','',''),(1300,'priv','fr','account-create','',''),(1300,'priv','zh-cn','account-create','',''),(1300,'priv','zh-tw','account-create','',''),(1301,'priv','de','account-editAction','',''),(1301,'priv','en','account-editAction','',''),(1301,'priv','fr','account-editAction','',''),(1301,'priv','zh-cn','account-editAction','',''),(1301,'priv','zh-tw','account-editAction','',''),(1302,'priv','de','account-view','',''),(1302,'priv','en','account-view','',''),(1302,'priv','fr','account-view','',''),(1302,'priv','zh-cn','account-view','',''),(1302,'priv','zh-tw','account-view','',''),(1303,'priv','de','account-deleteAction','',''),(1303,'priv','en','account-deleteAction','',''),(1303,'priv','fr','account-deleteAction','',''),(1303,'priv','zh-cn','account-deleteAction','',''),(1303,'priv','zh-tw','account-deleteAction','',''),(1304,'priv','de','domain-browse','',''),(1304,'priv','en','domain-browse','',''),(1304,'priv','fr','domain-browse','',''),(1304,'priv','zh-cn','domain-browse','',''),(1304,'priv','zh-tw','domain-browse','',''),(1305,'priv','de','domain-create','',''),(1305,'priv','en','domain-create','',''),(1305,'priv','fr','domain-create','',''),(1305,'priv','zh-cn','domain-create','',''),(1305,'priv','zh-tw','domain-create','',''),(1306,'priv','de','domain-editAction','',''),(1306,'priv','en','domain-editAction','',''),(1306,'priv','fr','domain-editAction','',''),(1306,'priv','zh-cn','domain-editAction','',''),(1306,'priv','zh-tw','domain-editAction','',''),(1307,'priv','de','domain-view','',''),(1307,'priv','en','domain-view','',''),(1307,'priv','fr','domain-view','',''),(1307,'priv','zh-cn','domain-view','',''),(1307,'priv','zh-tw','domain-view','',''),(1308,'priv','de','domain-deleteAction','',''),(1308,'priv','en','domain-deleteAction','',''),(1308,'priv','fr','domain-deleteAction','',''),(1308,'priv','zh-cn','domain-deleteAction','',''),(1308,'priv','zh-tw','domain-deleteAction','',''),(1309,'priv','de','service-browseAction','',''),(1309,'priv','en','service-browseAction','',''),(1309,'priv','fr','service-browseAction','',''),(1309,'priv','zh-cn','service-browseAction','',''),(1309,'priv','zh-tw','service-browseAction','',''),(1310,'priv','de','service-create','',''),(1310,'priv','en','service-create','',''),(1310,'priv','fr','service-create','',''),(1310,'priv','zh-cn','service-create','',''),(1310,'priv','zh-tw','service-create','',''),(1311,'priv','de','service-edit','',''),(1311,'priv','en','service-edit','',''),(1311,'priv','fr','service-edit','',''),(1311,'priv','zh-cn','service-edit','',''),(1311,'priv','zh-tw','service-edit','',''),(1312,'priv','de','service-delete','',''),(1312,'priv','en','service-delete','',''),(1312,'priv','fr','service-delete','',''),(1312,'priv','zh-cn','service-delete','',''),(1312,'priv','zh-tw','service-delete','',''),(1313,'priv','de','service-view','',''),(1313,'priv','en','service-view','',''),(1313,'priv','fr','service-view','',''),(1313,'priv','zh-cn','service-view','',''),(1313,'priv','zh-tw','service-view','',''),(1315,'priv','de','service-manage','',''),(1315,'priv','en','service-manage','',''),(1315,'priv','fr','service-manage','',''),(1315,'priv','zh-cn','service-manage','',''),(1315,'priv','zh-tw','service-manage','',''),(1316,'priv','de','deploy-browseAction','',''),(1316,'priv','en','deploy-browseAction','',''),(1316,'priv','fr','deploy-browseAction','',''),(1316,'priv','zh-cn','deploy-browseAction','',''),(1316,'priv','zh-tw','deploy-browseAction','',''),(1317,'priv','de','deploy-create','',''),(1317,'priv','en','deploy-create','',''),(1317,'priv','fr','deploy-create','',''),(1317,'priv','zh-cn','deploy-create','',''),(1317,'priv','zh-tw','deploy-create','',''),(1318,'priv','de','deploy-editAction','',''),(1318,'priv','en','deploy-editAction','',''),(1318,'priv','fr','deploy-editAction','',''),(1318,'priv','zh-cn','deploy-editAction','',''),(1318,'priv','zh-tw','deploy-editAction','',''),(1319,'priv','de','deploy-deleteAction','',''),(1319,'priv','en','deploy-deleteAction','',''),(1319,'priv','fr','deploy-deleteAction','',''),(1319,'priv','zh-cn','deploy-deleteAction','',''),(1319,'priv','zh-tw','deploy-deleteAction','',''),(1320,'priv','de','deploy-activateAction','',''),(1320,'priv','en','deploy-activateAction','',''),(1320,'priv','fr','deploy-activateAction','',''),(1320,'priv','zh-cn','deploy-activateAction','',''),(1320,'priv','zh-tw','deploy-activateAction','',''),(1321,'priv','de','deploy-finishAction','',''),(1321,'priv','en','deploy-finishAction','',''),(1321,'priv','fr','deploy-finishAction','',''),(1321,'priv','zh-cn','deploy-finishAction','',''),(1321,'priv','zh-tw','deploy-finishAction','',''),(1322,'priv','de','deploy-scope','',''),(1322,'priv','en','deploy-scope','',''),(1322,'priv','fr','deploy-scope','',''),(1322,'priv','zh-cn','deploy-scope','',''),(1322,'priv','zh-tw','deploy-scope','',''),(1323,'priv','de','deploy-manageScope','',''),(1323,'priv','en','deploy-manageScope','',''),(1323,'priv','fr','deploy-manageScope','',''),(1323,'priv','zh-cn','deploy-manageScope','',''),(1323,'priv','zh-tw','deploy-manageScope','',''),(1324,'priv','de','deploy-view','',''),(1324,'priv','en','deploy-view','',''),(1324,'priv','fr','deploy-view','',''),(1324,'priv','zh-cn','deploy-view','',''),(1324,'priv','zh-tw','deploy-view','',''),(1325,'priv','de','deploy-casesAction','',''),(1325,'priv','en','deploy-casesAction','',''),(1325,'priv','fr','deploy-casesAction','',''),(1325,'priv','zh-cn','deploy-casesAction','',''),(1325,'priv','zh-tw','deploy-casesAction','',''),(1326,'priv','de','deploy-linkCases','',''),(1326,'priv','en','deploy-linkCases','',''),(1326,'priv','fr','deploy-linkCases','',''),(1326,'priv','zh-cn','deploy-linkCases','',''),(1326,'priv','zh-tw','deploy-linkCases','',''),(1327,'priv','de','deploy-unlinkCase','',''),(1327,'priv','en','deploy-unlinkCase','',''),(1327,'priv','fr','deploy-unlinkCase','',''),(1327,'priv','zh-cn','deploy-unlinkCase','',''),(1327,'priv','zh-tw','deploy-unlinkCase','',''),(1328,'priv','de','deploy-batchUnlinkCases','',''),(1328,'priv','en','deploy-batchUnlinkCases','',''),(1328,'priv','fr','deploy-batchUnlinkCases','',''),(1328,'priv','zh-cn','deploy-batchUnlinkCases','',''),(1328,'priv','zh-tw','deploy-batchUnlinkCases','',''),(1329,'priv','de','deploy-steps','',''),(1329,'priv','en','deploy-steps','',''),(1329,'priv','fr','deploy-steps','',''),(1329,'priv','zh-cn','deploy-steps','',''),(1329,'priv','zh-tw','deploy-steps','',''),(1330,'priv','de','deploy-manageStep','',''),(1330,'priv','en','deploy-manageStep','',''),(1330,'priv','fr','deploy-manageStep','',''),(1330,'priv','zh-cn','deploy-manageStep','',''),(1330,'priv','zh-tw','deploy-manageStep','',''),(1331,'priv','de','deploy-finishStep','',''),(1331,'priv','en','deploy-finishStep','',''),(1331,'priv','fr','deploy-finishStep','',''),(1331,'priv','zh-cn','deploy-finishStep','',''),(1331,'priv','zh-tw','deploy-finishStep','',''),(1332,'priv','de','deploy-assignAction','',''),(1332,'priv','en','deploy-assignAction','',''),(1332,'priv','fr','deploy-assignAction','',''),(1332,'priv','zh-cn','deploy-assignAction','',''),(1332,'priv','zh-tw','deploy-assignAction','',''),(1333,'priv','de','deploy-viewStep','',''),(1333,'priv','en','deploy-viewStep','',''),(1333,'priv','fr','deploy-viewStep','',''),(1333,'priv','zh-cn','deploy-viewStep','',''),(1333,'priv','zh-tw','deploy-viewStep','',''),(1334,'priv','de','deploy-editStep','',''),(1334,'priv','en','deploy-editStep','',''),(1334,'priv','fr','deploy-editStep','',''),(1334,'priv','zh-cn','deploy-editStep','',''),(1334,'priv','zh-tw','deploy-editStep','',''),(1335,'priv','de','deploy-deleteStep','',''),(1335,'priv','en','deploy-deleteStep','',''),(1335,'priv','fr','deploy-deleteStep','',''),(1335,'priv','zh-cn','deploy-deleteStep','',''),(1335,'priv','zh-tw','deploy-deleteStep','',''),(1336,'priv','de','conference-admin','',''),(1336,'priv','en','conference-admin','',''),(1336,'priv','fr','conference-admin','',''),(1336,'priv','zh-cn','conference-admin','',''),(1336,'priv','zh-tw','conference-admin','',''),(1337,'priv','de','traincourse-browseAction','',''),(1337,'priv','en','traincourse-browseAction','',''),(1337,'priv','fr','traincourse-browseAction','',''),(1337,'priv','zh-cn','traincourse-browseAction','',''),(1337,'priv','zh-tw','traincourse-browseAction','',''),(1338,'priv','de','traincourse-adminAction','',''),(1338,'priv','en','traincourse-adminAction','',''),(1338,'priv','fr','traincourse-adminAction','',''),(1338,'priv','zh-cn','traincourse-adminAction','',''),(1338,'priv','zh-tw','traincourse-adminAction','',''),(1339,'priv','de','traincourse-deleteCourse','',''),(1339,'priv','en','traincourse-deleteCourse','',''),(1339,'priv','fr','traincourse-deleteCourse','',''),(1339,'priv','zh-cn','traincourse-deleteCourse','',''),(1339,'priv','zh-tw','traincourse-deleteCourse','',''),(1340,'priv','de','traincourse-changeStatus','',''),(1340,'priv','en','traincourse-changeStatus','',''),(1340,'priv','fr','traincourse-changeStatus','',''),(1340,'priv','zh-cn','traincourse-changeStatus','',''),(1340,'priv','zh-tw','traincourse-changeStatus','',''),(1341,'priv','de','traincourse-uploadCourse','',''),(1341,'priv','en','traincourse-uploadCourse','',''),(1341,'priv','fr','traincourse-uploadCourse','',''),(1341,'priv','zh-cn','traincourse-uploadCourse','',''),(1341,'priv','zh-tw','traincourse-uploadCourse','',''),(1342,'priv','de','traincourse-viewCourse','',''),(1342,'priv','en','traincourse-viewCourse','',''),(1342,'priv','fr','traincourse-viewCourse','',''),(1342,'priv','zh-cn','traincourse-viewCourse','',''),(1342,'priv','zh-tw','traincourse-viewCourse','',''),(1343,'priv','de','traincourse-viewChapter','',''),(1343,'priv','en','traincourse-viewChapter','',''),(1343,'priv','fr','traincourse-viewChapter','',''),(1343,'priv','zh-cn','traincourse-viewChapter','',''),(1343,'priv','zh-tw','traincourse-viewChapter','',''),(1344,'priv','de','chart-browseAction','',''),(1344,'priv','en','chart-browseAction','',''),(1344,'priv','fr','chart-browseAction','',''),(1344,'priv','zh-cn','chart-browseAction','',''),(1344,'priv','zh-tw','chart-browseAction','',''),(1345,'priv','de','chart-create','',''),(1345,'priv','en','chart-create','',''),(1345,'priv','fr','chart-create','',''),(1345,'priv','zh-cn','chart-create','',''),(1345,'priv','zh-tw','chart-create','',''),(1346,'priv','de','chart-edit','',''),(1346,'priv','en','chart-edit','',''),(1346,'priv','fr','chart-edit','',''),(1346,'priv','zh-cn','chart-edit','',''),(1346,'priv','zh-tw','chart-edit','',''),(1347,'priv','de','chart-design','',''),(1347,'priv','en','chart-design','',''),(1347,'priv','fr','chart-design','',''),(1347,'priv','zh-cn','chart-design','',''),(1347,'priv','zh-tw','chart-design','',''),(1348,'priv','de','chart-delete','',''),(1348,'priv','en','chart-delete','',''),(1348,'priv','fr','chart-delete','',''),(1348,'priv','zh-cn','chart-delete','',''),(1348,'priv','zh-tw','chart-delete','',''),(1360,'priv','de','pssp-browse','',''),(1360,'priv','en','pssp-browse','',''),(1360,'priv','fr','pssp-browse','',''),(1360,'priv','zh-cn','pssp-browse','',''),(1360,'priv','zh-tw','pssp-browse','',''),(1361,'priv','de','pssp-update','',''),(1361,'priv','en','pssp-update','',''),(1361,'priv','fr','pssp-update','',''),(1361,'priv','zh-cn','pssp-update','',''),(1361,'priv','zh-tw','pssp-update','',''),(1362,'priv','de','baseline-templateType','',''),(1362,'priv','en','baseline-templateType','',''),(1362,'priv','fr','baseline-templateType','',''),(1362,'priv','zh-cn','baseline-templateType','',''),(1362,'priv','zh-tw','baseline-templateType','',''),(1363,'priv','de','baseline-template','',''),(1363,'priv','en','baseline-template','',''),(1363,'priv','fr','baseline-template','',''),(1363,'priv','zh-cn','baseline-template','',''),(1363,'priv','zh-tw','baseline-template','',''),(1364,'priv','de','baseline-createTemplate','',''),(1364,'priv','en','baseline-createTemplate','',''),(1364,'priv','fr','baseline-createTemplate','',''),(1364,'priv','zh-cn','baseline-createTemplate','',''),(1364,'priv','zh-tw','baseline-createTemplate','',''),(1365,'priv','de','baseline-view','',''),(1365,'priv','en','baseline-view','',''),(1365,'priv','fr','baseline-view','',''),(1365,'priv','zh-cn','baseline-view','',''),(1365,'priv','zh-tw','baseline-view','',''),(1366,'priv','de','baseline-editTemplate','',''),(1366,'priv','en','baseline-editTemplate','',''),(1366,'priv','fr','baseline-editTemplate','',''),(1366,'priv','zh-cn','baseline-editTemplate','',''),(1366,'priv','zh-tw','baseline-editTemplate','',''),(1367,'priv','de','baseline-editBook','',''),(1367,'priv','en','baseline-editBook','',''),(1367,'priv','fr','baseline-editBook','',''),(1367,'priv','zh-cn','baseline-editBook','',''),(1367,'priv','zh-tw','baseline-editBook','',''),(1369,'priv','de','baseline-manageBook','',''),(1369,'priv','en','baseline-manageBook','',''),(1369,'priv','fr','baseline-manageBook','',''),(1369,'priv','zh-cn','baseline-manageBook','',''),(1369,'priv','zh-tw','baseline-manageBook','',''),(1370,'priv','de','baseline-delete','',''),(1370,'priv','en','baseline-delete','',''),(1370,'priv','fr','baseline-delete','',''),(1370,'priv','zh-cn','baseline-delete','',''),(1370,'priv','zh-tw','baseline-delete','',''),(1371,'priv','de','classify-browse','',''),(1371,'priv','en','classify-browse','',''),(1371,'priv','fr','classify-browse','',''),(1371,'priv','zh-cn','classify-browse','',''),(1371,'priv','zh-tw','classify-browse','',''),(1372,'priv','de','cm-create','',''),(1372,'priv','en','cm-create','',''),(1372,'priv','fr','cm-create','',''),(1372,'priv','zh-cn','cm-create','',''),(1372,'priv','zh-tw','cm-create','',''),(1373,'priv','de','cm-delete','',''),(1373,'priv','en','cm-delete','',''),(1373,'priv','fr','cm-delete','',''),(1373,'priv','zh-cn','cm-delete','',''),(1373,'priv','zh-tw','cm-delete','',''),(1374,'priv','de','cm-edit','',''),(1374,'priv','en','cm-edit','',''),(1374,'priv','fr','cm-edit','',''),(1374,'priv','zh-cn','cm-edit','',''),(1374,'priv','zh-tw','cm-edit','',''),(1375,'priv','de','cm-browse','',''),(1375,'priv','en','cm-browse','',''),(1375,'priv','fr','cm-browse','',''),(1375,'priv','zh-cn','cm-browse','',''),(1375,'priv','zh-tw','cm-browse','',''),(1376,'priv','de','cm-view','',''),(1376,'priv','en','cm-view','',''),(1376,'priv','fr','cm-view','',''),(1376,'priv','zh-cn','cm-view','',''),(1376,'priv','zh-tw','cm-view','',''),(1377,'priv','de','cm-report','',''),(1377,'priv','en','cm-report','',''),(1377,'priv','fr','cm-report','',''),(1377,'priv','zh-cn','cm-report','',''),(1377,'priv','zh-tw','cm-report','',''),(1378,'priv','de','cmcl-batchCreate','',''),(1378,'priv','en','cmcl-batchCreate','',''),(1378,'priv','fr','cmcl-batchCreate','',''),(1378,'priv','zh-cn','cmcl-batchCreate','',''),(1378,'priv','zh-tw','cmcl-batchCreate','',''),(1379,'priv','de','cmcl-delete','',''),(1379,'priv','en','cmcl-delete','',''),(1379,'priv','fr','cmcl-delete','',''),(1379,'priv','zh-cn','cmcl-delete','',''),(1379,'priv','zh-tw','cmcl-delete','',''),(1380,'priv','de','cmcl-edit','',''),(1380,'priv','en','cmcl-edit','',''),(1380,'priv','fr','cmcl-edit','',''),(1380,'priv','zh-cn','cmcl-edit','',''),(1380,'priv','zh-tw','cmcl-edit','',''),(1381,'priv','de','cmcl-browse','',''),(1381,'priv','en','cmcl-browse','',''),(1381,'priv','fr','cmcl-browse','',''),(1381,'priv','zh-cn','cmcl-browse','',''),(1381,'priv','zh-tw','cmcl-browse','',''),(1382,'priv','de','cmcl-view','',''),(1382,'priv','en','cmcl-view','',''),(1382,'priv','fr','cmcl-view','',''),(1382,'priv','zh-cn','cmcl-view','',''),(1382,'priv','zh-tw','cmcl-view','',''),(1383,'priv','de','cmcl-waterfallplusBrowse','',''),(1383,'priv','en','cmcl-waterfallplusBrowse','',''),(1383,'priv','fr','cmcl-waterfallplusBrowse','',''),(1383,'priv','zh-cn','cmcl-waterfallplusBrowse','',''),(1383,'priv','zh-tw','cmcl-waterfallplusBrowse','',''),(1384,'priv','de','auditcl-batchCreate','',''),(1384,'priv','en','auditcl-batchCreate','',''),(1384,'priv','fr','auditcl-batchCreate','',''),(1384,'priv','zh-cn','auditcl-batchCreate','',''),(1384,'priv','zh-tw','auditcl-batchCreate','',''),(1385,'priv','de','auditcl-batchEdit','',''),(1385,'priv','en','auditcl-batchEdit','',''),(1385,'priv','fr','auditcl-batchEdit','',''),(1385,'priv','zh-cn','auditcl-batchEdit','',''),(1385,'priv','zh-tw','auditcl-batchEdit','',''),(1386,'priv','de','auditcl-delete','',''),(1386,'priv','en','auditcl-delete','',''),(1386,'priv','fr','auditcl-delete','',''),(1386,'priv','zh-cn','auditcl-delete','',''),(1386,'priv','zh-tw','auditcl-delete','',''),(1387,'priv','de','auditcl-edit','',''),(1387,'priv','en','auditcl-edit','',''),(1387,'priv','fr','auditcl-edit','',''),(1387,'priv','zh-cn','auditcl-edit','',''),(1387,'priv','zh-tw','auditcl-edit','',''),(1389,'priv','de','auditcl-scrumBrowse','',''),(1389,'priv','en','auditcl-scrumBrowse','',''),(1389,'priv','fr','auditcl-scrumBrowse','',''),(1389,'priv','zh-cn','auditcl-scrumBrowse','',''),(1389,'priv','zh-tw','auditcl-scrumBrowse','',''),(1390,'priv','de','auditcl-browse','',''),(1390,'priv','en','auditcl-browse','',''),(1390,'priv','fr','auditcl-browse','',''),(1390,'priv','zh-cn','auditcl-browse','',''),(1390,'priv','zh-tw','auditcl-browse','',''),(1391,'priv','de','auditcl-agilePlusBrowse','',''),(1391,'priv','en','auditcl-agilePlusBrowse','',''),(1391,'priv','fr','auditcl-agilePlusBrowse','',''),(1391,'priv','zh-cn','auditcl-agilePlusBrowse','',''),(1391,'priv','zh-tw','auditcl-agilePlusBrowse','',''),(1392,'priv','de','auditcl-waterfallplusBrowse','',''),(1392,'priv','en','auditcl-waterfallplusBrowse','',''),(1392,'priv','fr','auditcl-waterfallplusBrowse','',''),(1392,'priv','zh-cn','auditcl-waterfallplusBrowse','',''),(1392,'priv','zh-tw','auditcl-waterfallplusBrowse','',''),(1393,'priv','de','reviewcl-browse','',''),(1393,'priv','en','reviewcl-browse','',''),(1393,'priv','fr','reviewcl-browse','',''),(1393,'priv','zh-cn','reviewcl-browse','',''),(1393,'priv','zh-tw','reviewcl-browse','',''),(1394,'priv','de','reviewcl-create','',''),(1394,'priv','en','reviewcl-create','',''),(1394,'priv','fr','reviewcl-create','',''),(1394,'priv','zh-cn','reviewcl-create','',''),(1394,'priv','zh-tw','reviewcl-create','',''),(1395,'priv','de','reviewcl-batchCreate','',''),(1395,'priv','en','reviewcl-batchCreate','',''),(1395,'priv','fr','reviewcl-batchCreate','',''),(1395,'priv','zh-cn','reviewcl-batchCreate','',''),(1395,'priv','zh-tw','reviewcl-batchCreate','',''),(1396,'priv','de','reviewcl-delete','',''),(1396,'priv','en','reviewcl-delete','',''),(1396,'priv','fr','reviewcl-delete','',''),(1396,'priv','zh-cn','reviewcl-delete','',''),(1396,'priv','zh-tw','reviewcl-delete','',''),(1397,'priv','de','reviewcl-edit','',''),(1397,'priv','en','reviewcl-edit','',''),(1397,'priv','fr','reviewcl-edit','',''),(1397,'priv','zh-cn','reviewcl-edit','',''),(1397,'priv','zh-tw','reviewcl-edit','',''),(1398,'priv','de','reviewcl-view','',''),(1398,'priv','en','reviewcl-view','',''),(1398,'priv','fr','reviewcl-view','',''),(1398,'priv','zh-cn','reviewcl-view','',''),(1398,'priv','zh-tw','reviewcl-view','',''),(1399,'priv','de','reviewcl-waterfallplusBrowse','',''),(1399,'priv','en','reviewcl-waterfallplusBrowse','',''),(1399,'priv','fr','reviewcl-waterfallplusBrowse','',''),(1399,'priv','zh-cn','reviewcl-waterfallplusBrowse','',''),(1399,'priv','zh-tw','reviewcl-waterfallplusBrowse','',''),(1400,'priv','de','process-create','',''),(1400,'priv','en','process-create','',''),(1400,'priv','fr','process-create','',''),(1400,'priv','zh-cn','process-create','',''),(1400,'priv','zh-tw','process-create','',''),(1401,'priv','de','process-batchCreate','',''),(1401,'priv','en','process-batchCreate','',''),(1401,'priv','fr','process-batchCreate','',''),(1401,'priv','zh-cn','process-batchCreate','',''),(1401,'priv','zh-tw','process-batchCreate','',''),(1402,'priv','de','process-delete','',''),(1402,'priv','en','process-delete','',''),(1402,'priv','fr','process-delete','',''),(1402,'priv','zh-cn','process-delete','',''),(1402,'priv','zh-tw','process-delete','',''),(1403,'priv','de','process-edit','',''),(1403,'priv','en','process-edit','',''),(1403,'priv','fr','process-edit','',''),(1403,'priv','zh-cn','process-edit','',''),(1403,'priv','zh-tw','process-edit','',''),(1404,'priv','de','process-view','',''),(1404,'priv','en','process-view','',''),(1404,'priv','fr','process-view','',''),(1404,'priv','zh-cn','process-view','',''),(1404,'priv','zh-tw','process-view','',''),(1405,'priv','de','process-updateOrder','',''),(1405,'priv','en','process-updateOrder','',''),(1405,'priv','fr','process-updateOrder','',''),(1405,'priv','zh-cn','process-updateOrder','',''),(1405,'priv','zh-tw','process-updateOrder','',''),(1406,'priv','de','process-activityList','',''),(1406,'priv','en','process-activityList','',''),(1406,'priv','fr','process-activityList','',''),(1406,'priv','zh-cn','process-activityList','',''),(1406,'priv','zh-tw','process-activityList','',''),(1407,'priv','de','process-scrumBrowse','',''),(1407,'priv','en','process-scrumBrowse','',''),(1407,'priv','fr','process-scrumBrowse','',''),(1407,'priv','zh-cn','process-scrumBrowse','',''),(1407,'priv','zh-tw','process-scrumBrowse','',''),(1408,'priv','de','process-browse','',''),(1408,'priv','en','process-browse','',''),(1408,'priv','fr','process-browse','',''),(1408,'priv','zh-cn','process-browse','',''),(1408,'priv','zh-tw','process-browse','',''),(1409,'priv','de','process-agilePlusBrowse','',''),(1409,'priv','en','process-agilePlusBrowse','',''),(1409,'priv','fr','process-agilePlusBrowse','',''),(1409,'priv','zh-cn','process-agilePlusBrowse','',''),(1409,'priv','zh-tw','process-agilePlusBrowse','',''),(1410,'priv','de','process-waterfallPlusBrowse','',''),(1410,'priv','en','process-waterfallPlusBrowse','',''),(1410,'priv','fr','process-waterfallPlusBrowse','',''),(1410,'priv','zh-cn','process-waterfallPlusBrowse','',''),(1410,'priv','zh-tw','process-waterfallPlusBrowse','',''),(1411,'priv','de','activity-browse','',''),(1411,'priv','en','activity-browse','',''),(1411,'priv','fr','activity-browse','',''),(1411,'priv','zh-cn','activity-browse','',''),(1411,'priv','zh-tw','activity-browse','',''),(1412,'priv','de','activity-create','',''),(1412,'priv','en','activity-create','',''),(1412,'priv','fr','activity-create','',''),(1412,'priv','zh-cn','activity-create','',''),(1412,'priv','zh-tw','activity-create','',''),(1413,'priv','de','activity-batchCreate','',''),(1413,'priv','en','activity-batchCreate','',''),(1413,'priv','fr','activity-batchCreate','',''),(1413,'priv','zh-cn','activity-batchCreate','',''),(1413,'priv','zh-tw','activity-batchCreate','',''),(1414,'priv','de','activity-delete','',''),(1414,'priv','en','activity-delete','',''),(1414,'priv','fr','activity-delete','',''),(1414,'priv','zh-cn','activity-delete','',''),(1414,'priv','zh-tw','activity-delete','',''),(1415,'priv','de','activity-edit','',''),(1415,'priv','en','activity-edit','',''),(1415,'priv','fr','activity-edit','',''),(1415,'priv','zh-cn','activity-edit','',''),(1415,'priv','zh-tw','activity-edit','',''),(1416,'priv','de','activity-view','',''),(1416,'priv','en','activity-view','',''),(1416,'priv','fr','activity-view','',''),(1416,'priv','zh-cn','activity-view','',''),(1416,'priv','zh-tw','activity-view','',''),(1417,'priv','de','activity-assignTo','',''),(1417,'priv','en','activity-assignTo','',''),(1417,'priv','fr','activity-assignTo','',''),(1417,'priv','zh-cn','activity-assignTo','',''),(1417,'priv','zh-tw','activity-assignTo','',''),(1418,'priv','de','activity-outputList','',''),(1418,'priv','en','activity-outputList','',''),(1418,'priv','fr','activity-outputList','',''),(1418,'priv','zh-cn','activity-outputList','',''),(1418,'priv','zh-tw','activity-outputList','',''),(1419,'priv','de','activity-updateOrder','',''),(1419,'priv','en','activity-updateOrder','',''),(1419,'priv','fr','activity-updateOrder','',''),(1419,'priv','zh-cn','activity-updateOrder','',''),(1419,'priv','zh-tw','activity-updateOrder','',''),(1420,'priv','de','zoutput-browse','',''),(1420,'priv','en','zoutput-browse','',''),(1420,'priv','fr','zoutput-browse','',''),(1420,'priv','zh-cn','zoutput-browse','',''),(1420,'priv','zh-tw','zoutput-browse','',''),(1421,'priv','de','zoutput-create','',''),(1421,'priv','en','zoutput-create','',''),(1421,'priv','fr','zoutput-create','',''),(1421,'priv','zh-cn','zoutput-create','',''),(1421,'priv','zh-tw','zoutput-create','',''),(1422,'priv','de','zoutput-edit','',''),(1422,'priv','en','zoutput-edit','',''),(1422,'priv','fr','zoutput-edit','',''),(1422,'priv','zh-cn','zoutput-edit','',''),(1422,'priv','zh-tw','zoutput-edit','',''),(1423,'priv','de','zoutput-batchCreate','',''),(1423,'priv','en','zoutput-batchCreate','',''),(1423,'priv','fr','zoutput-batchCreate','',''),(1423,'priv','zh-cn','zoutput-batchCreate','',''),(1423,'priv','zh-tw','zoutput-batchCreate','',''),(1424,'priv','de','zoutput-batchEdit','',''),(1424,'priv','en','zoutput-batchEdit','',''),(1424,'priv','fr','zoutput-batchEdit','',''),(1424,'priv','zh-cn','zoutput-batchEdit','',''),(1424,'priv','zh-tw','zoutput-batchEdit','',''),(1425,'priv','de','zoutput-delete','',''),(1425,'priv','en','zoutput-delete','',''),(1425,'priv','fr','zoutput-delete','',''),(1425,'priv','zh-cn','zoutput-delete','',''),(1425,'priv','zh-tw','zoutput-delete','',''),(1426,'priv','de','zoutput-view','',''),(1426,'priv','en','zoutput-view','',''),(1426,'priv','fr','zoutput-view','',''),(1426,'priv','zh-cn','zoutput-view','',''),(1426,'priv','zh-tw','zoutput-view','',''),(1427,'priv','de','zoutput-updateOrder','',''),(1427,'priv','en','zoutput-updateOrder','',''),(1427,'priv','fr','zoutput-updateOrder','',''),(1427,'priv','zh-cn','zoutput-updateOrder','',''),(1427,'priv','zh-tw','zoutput-updateOrder','',''),(1428,'priv','de','auditplan-browseAction','',''),(1428,'priv','en','auditplan-browseAction','',''),(1428,'priv','fr','auditplan-browseAction','',''),(1428,'priv','zh-cn','auditplan-browseAction','',''),(1428,'priv','zh-tw','auditplan-browseAction','',''),(1429,'priv','de','auditplan-create','',''),(1429,'priv','en','auditplan-create','',''),(1429,'priv','fr','auditplan-create','',''),(1429,'priv','zh-cn','auditplan-create','',''),(1429,'priv','zh-tw','auditplan-create','',''),(1430,'priv','de','auditplan-editAction','',''),(1430,'priv','en','auditplan-editAction','',''),(1430,'priv','fr','auditplan-editAction','',''),(1430,'priv','zh-cn','auditplan-editAction','',''),(1430,'priv','zh-tw','auditplan-editAction','',''),(1431,'priv','de','auditplan-batchCreate','',''),(1431,'priv','en','auditplan-batchCreate','',''),(1431,'priv','fr','auditplan-batchCreate','',''),(1431,'priv','zh-cn','auditplan-batchCreate','',''),(1431,'priv','zh-tw','auditplan-batchCreate','',''),(1432,'priv','de','auditplan-batchEdit','',''),(1432,'priv','en','auditplan-batchEdit','',''),(1432,'priv','fr','auditplan-batchEdit','',''),(1432,'priv','zh-cn','auditplan-batchEdit','',''),(1432,'priv','zh-tw','auditplan-batchEdit','',''),(1433,'priv','de','auditplan-batchCheck','',''),(1433,'priv','en','auditplan-batchCheck','',''),(1433,'priv','fr','auditplan-batchCheck','',''),(1433,'priv','zh-cn','auditplan-batchCheck','',''),(1433,'priv','zh-tw','auditplan-batchCheck','',''),(1434,'priv','de','auditplan-check','',''),(1434,'priv','en','auditplan-check','',''),(1434,'priv','fr','auditplan-check','',''),(1434,'priv','zh-cn','auditplan-check','',''),(1434,'priv','zh-tw','auditplan-check','',''),(1435,'priv','de','auditplan-nc','',''),(1435,'priv','en','auditplan-nc','',''),(1435,'priv','fr','auditplan-nc','',''),(1435,'priv','zh-cn','auditplan-nc','',''),(1435,'priv','zh-tw','auditplan-nc','',''),(1436,'priv','de','auditplan-result','',''),(1436,'priv','en','auditplan-result','',''),(1436,'priv','fr','auditplan-result','',''),(1436,'priv','zh-cn','auditplan-result','',''),(1436,'priv','zh-tw','auditplan-result','',''),(1437,'priv','de','auditplan-delete','',''),(1437,'priv','en','auditplan-delete','',''),(1437,'priv','fr','auditplan-delete','',''),(1437,'priv','zh-cn','auditplan-delete','',''),(1437,'priv','zh-tw','auditplan-delete','',''),(1438,'priv','de','auditplan-assignTo','',''),(1438,'priv','en','auditplan-assignTo','',''),(1438,'priv','fr','auditplan-assignTo','',''),(1438,'priv','zh-cn','auditplan-assignTo','',''),(1438,'priv','zh-tw','auditplan-assignTo','',''),(1439,'priv','de','subject-common','',''),(1439,'priv','en','subject-common','',''),(1439,'priv','fr','subject-common','',''),(1439,'priv','zh-cn','subject-common','',''),(1439,'priv','zh-tw','subject-common','',''),(1440,'priv','de','approvalflow-browse','',''),(1440,'priv','en','approvalflow-browse','',''),(1440,'priv','fr','approvalflow-browse','',''),(1440,'priv','zh-cn','approvalflow-browse','',''),(1440,'priv','zh-tw','approvalflow-browse','',''),(1441,'priv','de','approvalflow-create','',''),(1441,'priv','en','approvalflow-create','',''),(1441,'priv','fr','approvalflow-create','',''),(1441,'priv','zh-cn','approvalflow-create','',''),(1441,'priv','zh-tw','approvalflow-create','',''),(1442,'priv','de','approvalflow-edit','',''),(1442,'priv','en','approvalflow-edit','',''),(1442,'priv','fr','approvalflow-edit','',''),(1442,'priv','zh-cn','approvalflow-edit','',''),(1442,'priv','zh-tw','approvalflow-edit','',''),(1443,'priv','de','approvalflow-view','',''),(1443,'priv','en','approvalflow-view','',''),(1443,'priv','fr','approvalflow-view','',''),(1443,'priv','zh-cn','approvalflow-view','',''),(1443,'priv','zh-tw','approvalflow-view','',''),(1444,'priv','de','approvalflow-design','',''),(1444,'priv','en','approvalflow-design','',''),(1444,'priv','fr','approvalflow-design','',''),(1444,'priv','zh-cn','approvalflow-design','',''),(1444,'priv','zh-tw','approvalflow-design','',''),(1445,'priv','de','approvalflow-delete','',''),(1445,'priv','en','approvalflow-delete','',''),(1445,'priv','fr','approvalflow-delete','',''),(1445,'priv','zh-cn','approvalflow-delete','',''),(1445,'priv','zh-tw','approvalflow-delete','',''),(1446,'priv','de','approvalflow-roleList','',''),(1446,'priv','en','approvalflow-roleList','',''),(1446,'priv','fr','approvalflow-roleList','',''),(1446,'priv','zh-cn','approvalflow-roleList','',''),(1446,'priv','zh-tw','approvalflow-roleList','',''),(1447,'priv','de','approvalflow-createRole','',''),(1447,'priv','en','approvalflow-createRole','',''),(1447,'priv','fr','approvalflow-createRole','',''),(1447,'priv','zh-cn','approvalflow-createRole','',''),(1447,'priv','zh-tw','approvalflow-createRole','',''),(1448,'priv','de','approvalflow-editRole','',''),(1448,'priv','en','approvalflow-editRole','',''),(1448,'priv','fr','approvalflow-editRole','',''),(1448,'priv','zh-cn','approvalflow-editRole','',''),(1448,'priv','zh-tw','approvalflow-editRole','',''),(1449,'priv','de','approvalflow-deleteRole','',''),(1449,'priv','en','approvalflow-deleteRole','',''),(1449,'priv','fr','approvalflow-deleteRole','',''),(1449,'priv','zh-cn','approvalflow-deleteRole','',''),(1449,'priv','zh-tw','approvalflow-deleteRole','',''),(1450,'priv','de','reviewissue-issue','',''),(1450,'priv','en','reviewissue-issue','',''),(1450,'priv','fr','reviewissue-issue','',''),(1450,'priv','zh-cn','reviewissue-issue','',''),(1450,'priv','zh-tw','reviewissue-issue','',''),(1451,'priv','de','reviewissue-updateStatus','',''),(1451,'priv','en','reviewissue-updateStatus','',''),(1451,'priv','fr','reviewissue-updateStatus','',''),(1451,'priv','zh-cn','reviewissue-updateStatus','',''),(1451,'priv','zh-tw','reviewissue-updateStatus','',''),(1452,'priv','de','reviewissue-resolved','',''),(1452,'priv','en','reviewissue-resolved','',''),(1452,'priv','fr','reviewissue-resolved','',''),(1452,'priv','zh-cn','reviewissue-resolved','',''),(1452,'priv','zh-tw','reviewissue-resolved','',''),(1453,'priv','de','reviewissue-create','',''),(1453,'priv','en','reviewissue-create','',''),(1453,'priv','fr','reviewissue-create','',''),(1453,'priv','zh-cn','reviewissue-create','',''),(1453,'priv','zh-tw','reviewissue-create','',''),(1454,'priv','de','reviewissue-edit','',''),(1454,'priv','en','reviewissue-edit','',''),(1454,'priv','fr','reviewissue-edit','',''),(1454,'priv','zh-cn','reviewissue-edit','',''),(1454,'priv','zh-tw','reviewissue-edit','',''),(1455,'priv','de','reviewissue-view','',''),(1455,'priv','en','reviewissue-view','',''),(1455,'priv','fr','reviewissue-view','',''),(1455,'priv','zh-cn','reviewissue-view','',''),(1455,'priv','zh-tw','reviewissue-view','',''),(1456,'priv','de','reviewissue-delete','',''),(1456,'priv','en','reviewissue-delete','',''),(1456,'priv','fr','reviewissue-delete','',''),(1456,'priv','zh-cn','reviewissue-delete','',''),(1456,'priv','zh-tw','reviewissue-delete','',''),(1457,'priv','de','reviewsetting-version','',''),(1457,'priv','en','reviewsetting-version','',''),(1457,'priv','fr','reviewsetting-version','',''),(1457,'priv','zh-cn','reviewsetting-version','',''),(1457,'priv','zh-tw','reviewsetting-version','',''),(1459,'priv','de','reviewsetting-waterfallplusVersion','',''),(1459,'priv','en','reviewsetting-waterfallplusVersion','',''),(1459,'priv','fr','reviewsetting-waterfallplusVersion','',''),(1459,'priv','zh-cn','reviewsetting-waterfallplusVersion','',''),(1459,'priv','zh-tw','reviewsetting-waterfallplusVersion','',''),(1460,'priv','de','review-browseAction','',''),(1460,'priv','en','review-browseAction','',''),(1460,'priv','fr','review-browseAction','',''),(1460,'priv','zh-cn','review-browseAction','',''),(1460,'priv','zh-tw','review-browseAction','',''),(1461,'priv','de','review-assess','',''),(1461,'priv','en','review-assess','',''),(1461,'priv','fr','review-assess','',''),(1461,'priv','zh-cn','review-assess','',''),(1461,'priv','zh-tw','review-assess','',''),(1462,'priv','de','review-create','',''),(1462,'priv','en','review-create','',''),(1462,'priv','fr','review-create','',''),(1462,'priv','zh-cn','review-create','',''),(1462,'priv','zh-tw','review-create','',''),(1463,'priv','de','review-edit','',''),(1463,'priv','en','review-edit','',''),(1463,'priv','fr','review-edit','',''),(1463,'priv','zh-cn','review-edit','',''),(1463,'priv','zh-tw','review-edit','',''),(1464,'priv','de','review-view','',''),(1464,'priv','en','review-view','',''),(1464,'priv','fr','review-view','',''),(1464,'priv','zh-cn','review-view','',''),(1464,'priv','zh-tw','review-view','',''),(1465,'priv','de','review-submit','',''),(1465,'priv','en','review-submit','',''),(1465,'priv','fr','review-submit','',''),(1465,'priv','zh-cn','review-submit','',''),(1465,'priv','zh-tw','review-submit','',''),(1466,'priv','de','review-recall','',''),(1466,'priv','en','review-recall','',''),(1466,'priv','fr','review-recall','',''),(1466,'priv','zh-cn','review-recall','',''),(1466,'priv','zh-tw','review-recall','',''),(1467,'priv','de','review-reviewReport','',''),(1467,'priv','en','review-reviewReport','',''),(1467,'priv','fr','review-reviewReport','',''),(1467,'priv','zh-cn','review-reviewReport','',''),(1467,'priv','zh-tw','review-reviewReport','',''),(1468,'priv','de','review-toAudit','',''),(1468,'priv','en','review-toAudit','',''),(1468,'priv','fr','review-toAudit','',''),(1468,'priv','zh-cn','review-toAudit','',''),(1468,'priv','zh-tw','review-toAudit','',''),(1469,'priv','de','review-audit','',''),(1469,'priv','en','review-audit','',''),(1469,'priv','fr','review-audit','',''),(1469,'priv','zh-cn','review-audit','',''),(1469,'priv','zh-tw','review-audit','',''),(1470,'priv','de','review-delete','',''),(1470,'priv','en','review-delete','',''),(1470,'priv','fr','review-delete','',''),(1470,'priv','zh-cn','review-delete','',''),(1470,'priv','zh-tw','review-delete','',''),(1471,'priv','de','measurement-setTips','',''),(1471,'priv','en','measurement-setTips','',''),(1471,'priv','fr','measurement-setTips','',''),(1471,'priv','zh-cn','measurement-setTips','',''),(1471,'priv','zh-tw','measurement-setTips','',''),(1472,'priv','de','measurement-setSQL','',''),(1472,'priv','en','measurement-setSQL','',''),(1472,'priv','fr','measurement-setSQL','',''),(1472,'priv','zh-cn','measurement-setSQL','',''),(1472,'priv','zh-tw','measurement-setSQL','',''),(1473,'priv','de','measurement-browseAction','',''),(1473,'priv','en','measurement-browseAction','',''),(1473,'priv','fr','measurement-browseAction','',''),(1473,'priv','zh-cn','measurement-browseAction','',''),(1473,'priv','zh-tw','measurement-browseAction','',''),(1474,'priv','de','measurement-createBasic','',''),(1474,'priv','en','measurement-createBasic','',''),(1474,'priv','fr','measurement-createBasic','',''),(1474,'priv','zh-cn','measurement-createBasic','',''),(1474,'priv','zh-tw','measurement-createBasic','',''),(1475,'priv','de','measurement-deleteAction','',''),(1475,'priv','en','measurement-deleteAction','',''),(1475,'priv','fr','measurement-deleteAction','',''),(1475,'priv','zh-cn','measurement-deleteAction','',''),(1475,'priv','zh-tw','measurement-deleteAction','',''),(1477,'priv','de','measurement-editBasic','',''),(1477,'priv','en','measurement-editBasic','',''),(1477,'priv','fr','measurement-editBasic','',''),(1477,'priv','zh-cn','measurement-editBasic','',''),(1477,'priv','zh-tw','measurement-editBasic','',''),(1478,'priv','de','measurement-searchMeas','',''),(1478,'priv','en','measurement-searchMeas','',''),(1478,'priv','fr','measurement-searchMeas','',''),(1478,'priv','zh-cn','measurement-searchMeas','',''),(1478,'priv','zh-tw','measurement-searchMeas','',''),(1479,'priv','de','measurement-template','',''),(1479,'priv','en','measurement-template','',''),(1479,'priv','fr','measurement-template','',''),(1479,'priv','zh-cn','measurement-template','',''),(1479,'priv','zh-tw','measurement-template','',''),(1480,'priv','de','measurement-createTemplate','',''),(1480,'priv','en','measurement-createTemplate','',''),(1480,'priv','fr','measurement-createTemplate','',''),(1480,'priv','zh-cn','measurement-createTemplate','',''),(1480,'priv','zh-tw','measurement-createTemplate','',''),(1481,'priv','de','measurement-editTemplate','',''),(1481,'priv','en','measurement-editTemplate','',''),(1481,'priv','fr','measurement-editTemplate','',''),(1481,'priv','zh-cn','measurement-editTemplate','',''),(1481,'priv','zh-tw','measurement-editTemplate','',''),(1482,'priv','de','measurement-viewTemplate','',''),(1482,'priv','en','measurement-viewTemplate','',''),(1482,'priv','fr','measurement-viewTemplate','',''),(1482,'priv','zh-cn','measurement-viewTemplate','',''),(1482,'priv','zh-tw','measurement-viewTemplate','',''),(1488,'priv','de','measurement-batchEditAction','',''),(1488,'priv','en','measurement-batchEditAction','',''),(1488,'priv','fr','measurement-batchEditAction','',''),(1488,'priv','zh-cn','measurement-batchEditAction','',''),(1488,'priv','zh-tw','measurement-batchEditAction','',''),(1489,'priv','de','measurement-saveReportAB','',''),(1489,'priv','en','measurement-saveReportAB','',''),(1489,'priv','fr','measurement-saveReportAB','',''),(1489,'priv','zh-cn','measurement-saveReportAB','',''),(1489,'priv','zh-tw','measurement-saveReportAB','',''),(1490,'priv','de','measrecord-browse','',''),(1490,'priv','en','measrecord-browse','',''),(1490,'priv','fr','measrecord-browse','',''),(1490,'priv','zh-cn','measrecord-browse','',''),(1490,'priv','zh-tw','measrecord-browse','',''),(1491,'priv','de','assetlib-caseLib','',''),(1491,'priv','en','assetlib-caseLib','',''),(1491,'priv','fr','assetlib-caseLib','',''),(1491,'priv','zh-cn','assetlib-caseLib','',''),(1491,'priv','zh-tw','assetlib-caseLib','',''),(1492,'priv','de','assetlib-storyLib','',''),(1492,'priv','en','assetlib-storyLib','',''),(1492,'priv','fr','assetlib-storyLib','',''),(1492,'priv','zh-cn','assetlib-storyLib','',''),(1492,'priv','zh-tw','assetlib-storyLib','',''),(1493,'priv','de','assetlib-createStoryLib','',''),(1493,'priv','en','assetlib-createStoryLib','',''),(1493,'priv','fr','assetlib-createStoryLib','',''),(1493,'priv','zh-cn','assetlib-createStoryLib','',''),(1493,'priv','zh-tw','assetlib-createStoryLib','',''),(1494,'priv','de','assetlib-editStoryLib','',''),(1494,'priv','en','assetlib-editStoryLib','',''),(1494,'priv','fr','assetlib-editStoryLib','',''),(1494,'priv','zh-cn','assetlib-editStoryLib','',''),(1494,'priv','zh-tw','assetlib-editStoryLib','',''),(1495,'priv','de','assetlib-deleteStoryLib','',''),(1495,'priv','en','assetlib-deleteStoryLib','',''),(1495,'priv','fr','assetlib-deleteStoryLib','',''),(1495,'priv','zh-cn','assetlib-deleteStoryLib','',''),(1495,'priv','zh-tw','assetlib-deleteStoryLib','',''),(1496,'priv','de','assetlib-storyLibView','',''),(1496,'priv','en','assetlib-storyLibView','',''),(1496,'priv','fr','assetlib-storyLibView','',''),(1496,'priv','zh-cn','assetlib-storyLibView','',''),(1496,'priv','zh-tw','assetlib-storyLibView','',''),(1497,'priv','de','assetlib-story','',''),(1497,'priv','en','assetlib-story','',''),(1497,'priv','fr','assetlib-story','',''),(1497,'priv','zh-cn','assetlib-story','',''),(1497,'priv','zh-tw','assetlib-story','',''),(1498,'priv','de','assetlib-importStory','',''),(1498,'priv','en','assetlib-importStory','',''),(1498,'priv','fr','assetlib-importStory','',''),(1498,'priv','zh-cn','assetlib-importStory','',''),(1498,'priv','zh-tw','assetlib-importStory','',''),(1499,'priv','de','assetlib-assignToStory','',''),(1499,'priv','en','assetlib-assignToStory','',''),(1499,'priv','fr','assetlib-assignToStory','',''),(1499,'priv','zh-cn','assetlib-assignToStory','',''),(1499,'priv','zh-tw','assetlib-assignToStory','',''),(1500,'priv','de','assetlib-batchAssignToStory','',''),(1500,'priv','en','assetlib-batchAssignToStory','',''),(1500,'priv','fr','assetlib-batchAssignToStory','',''),(1500,'priv','zh-cn','assetlib-batchAssignToStory','',''),(1500,'priv','zh-tw','assetlib-batchAssignToStory','',''),(1501,'priv','de','assetlib-approveStory','',''),(1501,'priv','en','assetlib-approveStory','',''),(1501,'priv','fr','assetlib-approveStory','',''),(1501,'priv','zh-cn','assetlib-approveStory','',''),(1501,'priv','zh-tw','assetlib-approveStory','',''),(1502,'priv','de','assetlib-batchApproveStory','',''),(1502,'priv','en','assetlib-batchApproveStory','',''),(1502,'priv','fr','assetlib-batchApproveStory','',''),(1502,'priv','zh-cn','assetlib-batchApproveStory','',''),(1502,'priv','zh-tw','assetlib-batchApproveStory','',''),(1503,'priv','de','assetlib-editStory','',''),(1503,'priv','en','assetlib-editStory','',''),(1503,'priv','fr','assetlib-editStory','',''),(1503,'priv','zh-cn','assetlib-editStory','',''),(1503,'priv','zh-tw','assetlib-editStory','',''),(1504,'priv','de','assetlib-removeStory','',''),(1504,'priv','en','assetlib-removeStory','',''),(1504,'priv','fr','assetlib-removeStory','',''),(1504,'priv','zh-cn','assetlib-removeStory','',''),(1504,'priv','zh-tw','assetlib-removeStory','',''),(1505,'priv','de','assetlib-batchRemoveStory','',''),(1505,'priv','en','assetlib-batchRemoveStory','',''),(1505,'priv','fr','assetlib-batchRemoveStory','',''),(1505,'priv','zh-cn','assetlib-batchRemoveStory','',''),(1505,'priv','zh-tw','assetlib-batchRemoveStory','',''),(1506,'priv','de','assetlib-storyView','',''),(1506,'priv','en','assetlib-storyView','',''),(1506,'priv','fr','assetlib-storyView','',''),(1506,'priv','zh-cn','assetlib-storyView','',''),(1506,'priv','zh-tw','assetlib-storyView','',''),(1507,'priv','de','assetlib-issueLib','',''),(1507,'priv','en','assetlib-issueLib','',''),(1507,'priv','fr','assetlib-issueLib','',''),(1507,'priv','zh-cn','assetlib-issueLib','',''),(1507,'priv','zh-tw','assetlib-issueLib','',''),(1508,'priv','de','assetlib-createIssueLib','',''),(1508,'priv','en','assetlib-createIssueLib','',''),(1508,'priv','fr','assetlib-createIssueLib','',''),(1508,'priv','zh-cn','assetlib-createIssueLib','',''),(1508,'priv','zh-tw','assetlib-createIssueLib','',''),(1509,'priv','de','assetlib-editIssueLib','',''),(1509,'priv','en','assetlib-editIssueLib','',''),(1509,'priv','fr','assetlib-editIssueLib','',''),(1509,'priv','zh-cn','assetlib-editIssueLib','',''),(1509,'priv','zh-tw','assetlib-editIssueLib','',''),(1510,'priv','de','assetlib-deleteIssueLib','',''),(1510,'priv','en','assetlib-deleteIssueLib','',''),(1510,'priv','fr','assetlib-deleteIssueLib','',''),(1510,'priv','zh-cn','assetlib-deleteIssueLib','',''),(1510,'priv','zh-tw','assetlib-deleteIssueLib','',''),(1511,'priv','de','assetlib-issueLibView','',''),(1511,'priv','en','assetlib-issueLibView','',''),(1511,'priv','fr','assetlib-issueLibView','',''),(1511,'priv','zh-cn','assetlib-issueLibView','',''),(1511,'priv','zh-tw','assetlib-issueLibView','',''),(1512,'priv','de','assetlib-issue','',''),(1512,'priv','en','assetlib-issue','',''),(1512,'priv','fr','assetlib-issue','',''),(1512,'priv','zh-cn','assetlib-issue','',''),(1512,'priv','zh-tw','assetlib-issue','',''),(1513,'priv','de','assetlib-importIssue','',''),(1513,'priv','en','assetlib-importIssue','',''),(1513,'priv','fr','assetlib-importIssue','',''),(1513,'priv','zh-cn','assetlib-importIssue','',''),(1513,'priv','zh-tw','assetlib-importIssue','',''),(1514,'priv','de','assetlib-assignToIssue','',''),(1514,'priv','en','assetlib-assignToIssue','',''),(1514,'priv','fr','assetlib-assignToIssue','',''),(1514,'priv','zh-cn','assetlib-assignToIssue','',''),(1514,'priv','zh-tw','assetlib-assignToIssue','',''),(1515,'priv','de','assetlib-batchAssignToIssue','',''),(1515,'priv','en','assetlib-batchAssignToIssue','',''),(1515,'priv','fr','assetlib-batchAssignToIssue','',''),(1515,'priv','zh-cn','assetlib-batchAssignToIssue','',''),(1515,'priv','zh-tw','assetlib-batchAssignToIssue','',''),(1516,'priv','de','assetlib-approveIssue','',''),(1516,'priv','en','assetlib-approveIssue','',''),(1516,'priv','fr','assetlib-approveIssue','',''),(1516,'priv','zh-cn','assetlib-approveIssue','',''),(1516,'priv','zh-tw','assetlib-approveIssue','',''),(1517,'priv','de','assetlib-batchApproveIssue','',''),(1517,'priv','en','assetlib-batchApproveIssue','',''),(1517,'priv','fr','assetlib-batchApproveIssue','',''),(1517,'priv','zh-cn','assetlib-batchApproveIssue','',''),(1517,'priv','zh-tw','assetlib-batchApproveIssue','',''),(1518,'priv','de','assetlib-editIssue','',''),(1518,'priv','en','assetlib-editIssue','',''),(1518,'priv','fr','assetlib-editIssue','',''),(1518,'priv','zh-cn','assetlib-editIssue','',''),(1518,'priv','zh-tw','assetlib-editIssue','',''),(1519,'priv','de','assetlib-removeIssue','',''),(1519,'priv','en','assetlib-removeIssue','',''),(1519,'priv','fr','assetlib-removeIssue','',''),(1519,'priv','zh-cn','assetlib-removeIssue','',''),(1519,'priv','zh-tw','assetlib-removeIssue','',''),(1520,'priv','de','assetlib-batchRemoveIssue','',''),(1520,'priv','en','assetlib-batchRemoveIssue','',''),(1520,'priv','fr','assetlib-batchRemoveIssue','',''),(1520,'priv','zh-cn','assetlib-batchRemoveIssue','',''),(1520,'priv','zh-tw','assetlib-batchRemoveIssue','',''),(1521,'priv','de','assetlib-issueView','',''),(1521,'priv','en','assetlib-issueView','',''),(1521,'priv','fr','assetlib-issueView','',''),(1521,'priv','zh-cn','assetlib-issueView','',''),(1521,'priv','zh-tw','assetlib-issueView','',''),(1522,'priv','de','assetlib-riskLib','',''),(1522,'priv','en','assetlib-riskLib','',''),(1522,'priv','fr','assetlib-riskLib','',''),(1522,'priv','zh-cn','assetlib-riskLib','',''),(1522,'priv','zh-tw','assetlib-riskLib','',''),(1523,'priv','de','assetlib-createRiskLib','',''),(1523,'priv','en','assetlib-createRiskLib','',''),(1523,'priv','fr','assetlib-createRiskLib','',''),(1523,'priv','zh-cn','assetlib-createRiskLib','',''),(1523,'priv','zh-tw','assetlib-createRiskLib','',''),(1524,'priv','de','assetlib-editRiskLib','',''),(1524,'priv','en','assetlib-editRiskLib','',''),(1524,'priv','fr','assetlib-editRiskLib','',''),(1524,'priv','zh-cn','assetlib-editRiskLib','',''),(1524,'priv','zh-tw','assetlib-editRiskLib','',''),(1525,'priv','de','assetlib-deleteRiskLib','',''),(1525,'priv','en','assetlib-deleteRiskLib','',''),(1525,'priv','fr','assetlib-deleteRiskLib','',''),(1525,'priv','zh-cn','assetlib-deleteRiskLib','',''),(1525,'priv','zh-tw','assetlib-deleteRiskLib','',''),(1526,'priv','de','assetlib-riskLibView','',''),(1526,'priv','en','assetlib-riskLibView','',''),(1526,'priv','fr','assetlib-riskLibView','',''),(1526,'priv','zh-cn','assetlib-riskLibView','',''),(1526,'priv','zh-tw','assetlib-riskLibView','',''),(1527,'priv','de','assetlib-risk','',''),(1527,'priv','en','assetlib-risk','',''),(1527,'priv','fr','assetlib-risk','',''),(1527,'priv','zh-cn','assetlib-risk','',''),(1527,'priv','zh-tw','assetlib-risk','',''),(1528,'priv','de','assetlib-importRisk','',''),(1528,'priv','en','assetlib-importRisk','',''),(1528,'priv','fr','assetlib-importRisk','',''),(1528,'priv','zh-cn','assetlib-importRisk','',''),(1528,'priv','zh-tw','assetlib-importRisk','',''),(1529,'priv','de','assetlib-assignToRisk','',''),(1529,'priv','en','assetlib-assignToRisk','',''),(1529,'priv','fr','assetlib-assignToRisk','',''),(1529,'priv','zh-cn','assetlib-assignToRisk','',''),(1529,'priv','zh-tw','assetlib-assignToRisk','',''),(1530,'priv','de','assetlib-batchAssignToRisk','',''),(1530,'priv','en','assetlib-batchAssignToRisk','',''),(1530,'priv','fr','assetlib-batchAssignToRisk','',''),(1530,'priv','zh-cn','assetlib-batchAssignToRisk','',''),(1530,'priv','zh-tw','assetlib-batchAssignToRisk','',''),(1531,'priv','de','assetlib-approveRisk','',''),(1531,'priv','en','assetlib-approveRisk','',''),(1531,'priv','fr','assetlib-approveRisk','',''),(1531,'priv','zh-cn','assetlib-approveRisk','',''),(1531,'priv','zh-tw','assetlib-approveRisk','',''),(1532,'priv','de','assetlib-batchApproveRisk','',''),(1532,'priv','en','assetlib-batchApproveRisk','',''),(1532,'priv','fr','assetlib-batchApproveRisk','',''),(1532,'priv','zh-cn','assetlib-batchApproveRisk','',''),(1532,'priv','zh-tw','assetlib-batchApproveRisk','',''),(1533,'priv','de','assetlib-editRisk','',''),(1533,'priv','en','assetlib-editRisk','',''),(1533,'priv','fr','assetlib-editRisk','',''),(1533,'priv','zh-cn','assetlib-editRisk','',''),(1533,'priv','zh-tw','assetlib-editRisk','',''),(1534,'priv','de','assetlib-removeRisk','',''),(1534,'priv','en','assetlib-removeRisk','',''),(1534,'priv','fr','assetlib-removeRisk','',''),(1534,'priv','zh-cn','assetlib-removeRisk','',''),(1534,'priv','zh-tw','assetlib-removeRisk','',''),(1535,'priv','de','assetlib-batchRemoveRisk','',''),(1535,'priv','en','assetlib-batchRemoveRisk','',''),(1535,'priv','fr','assetlib-batchRemoveRisk','',''),(1535,'priv','zh-cn','assetlib-batchRemoveRisk','',''),(1535,'priv','zh-tw','assetlib-batchRemoveRisk','',''),(1536,'priv','de','assetlib-riskView','',''),(1536,'priv','en','assetlib-riskView','',''),(1536,'priv','fr','assetlib-riskView','',''),(1536,'priv','zh-cn','assetlib-riskView','',''),(1536,'priv','zh-tw','assetlib-riskView','',''),(1537,'priv','de','assetlib-opportunityLib','',''),(1537,'priv','en','assetlib-opportunityLib','',''),(1537,'priv','fr','assetlib-opportunityLib','',''),(1537,'priv','zh-cn','assetlib-opportunityLib','',''),(1537,'priv','zh-tw','assetlib-opportunityLib','',''),(1538,'priv','de','assetlib-createOpportunityLib','',''),(1538,'priv','en','assetlib-createOpportunityLib','',''),(1538,'priv','fr','assetlib-createOpportunityLib','',''),(1538,'priv','zh-cn','assetlib-createOpportunityLib','',''),(1538,'priv','zh-tw','assetlib-createOpportunityLib','',''),(1539,'priv','de','assetlib-editOpportunityLib','',''),(1539,'priv','en','assetlib-editOpportunityLib','',''),(1539,'priv','fr','assetlib-editOpportunityLib','',''),(1539,'priv','zh-cn','assetlib-editOpportunityLib','',''),(1539,'priv','zh-tw','assetlib-editOpportunityLib','',''),(1540,'priv','de','assetlib-deleteOpportunityLib','',''),(1540,'priv','en','assetlib-deleteOpportunityLib','',''),(1540,'priv','fr','assetlib-deleteOpportunityLib','',''),(1540,'priv','zh-cn','assetlib-deleteOpportunityLib','',''),(1540,'priv','zh-tw','assetlib-deleteOpportunityLib','',''),(1541,'priv','de','assetlib-opportunityLibView','',''),(1541,'priv','en','assetlib-opportunityLibView','',''),(1541,'priv','fr','assetlib-opportunityLibView','',''),(1541,'priv','zh-cn','assetlib-opportunityLibView','',''),(1541,'priv','zh-tw','assetlib-opportunityLibView','',''),(1542,'priv','de','assetlib-opportunity','',''),(1542,'priv','en','assetlib-opportunity','',''),(1542,'priv','fr','assetlib-opportunity','',''),(1542,'priv','zh-cn','assetlib-opportunity','',''),(1542,'priv','zh-tw','assetlib-opportunity','',''),(1543,'priv','de','assetlib-importOpportunity','',''),(1543,'priv','en','assetlib-importOpportunity','',''),(1543,'priv','fr','assetlib-importOpportunity','',''),(1543,'priv','zh-cn','assetlib-importOpportunity','',''),(1543,'priv','zh-tw','assetlib-importOpportunity','',''),(1544,'priv','de','assetlib-assignToOpportunity','',''),(1544,'priv','en','assetlib-assignToOpportunity','',''),(1544,'priv','fr','assetlib-assignToOpportunity','',''),(1544,'priv','zh-cn','assetlib-assignToOpportunity','',''),(1544,'priv','zh-tw','assetlib-assignToOpportunity','',''),(1545,'priv','de','assetlib-batchAssignToOpportunity','',''),(1545,'priv','en','assetlib-batchAssignToOpportunity','',''),(1545,'priv','fr','assetlib-batchAssignToOpportunity','',''),(1545,'priv','zh-cn','assetlib-batchAssignToOpportunity','',''),(1545,'priv','zh-tw','assetlib-batchAssignToOpportunity','',''),(1546,'priv','de','assetlib-approveOpportunity','',''),(1546,'priv','en','assetlib-approveOpportunity','',''),(1546,'priv','fr','assetlib-approveOpportunity','',''),(1546,'priv','zh-cn','assetlib-approveOpportunity','',''),(1546,'priv','zh-tw','assetlib-approveOpportunity','',''),(1547,'priv','de','assetlib-batchApproveOpportunity','',''),(1547,'priv','en','assetlib-batchApproveOpportunity','',''),(1547,'priv','fr','assetlib-batchApproveOpportunity','',''),(1547,'priv','zh-cn','assetlib-batchApproveOpportunity','',''),(1547,'priv','zh-tw','assetlib-batchApproveOpportunity','',''),(1548,'priv','de','assetlib-editOpportunity','',''),(1548,'priv','en','assetlib-editOpportunity','',''),(1548,'priv','fr','assetlib-editOpportunity','',''),(1548,'priv','zh-cn','assetlib-editOpportunity','',''),(1548,'priv','zh-tw','assetlib-editOpportunity','',''),(1549,'priv','de','assetlib-removeOpportunity','',''),(1549,'priv','en','assetlib-removeOpportunity','',''),(1549,'priv','fr','assetlib-removeOpportunity','',''),(1549,'priv','zh-cn','assetlib-removeOpportunity','',''),(1549,'priv','zh-tw','assetlib-removeOpportunity','',''),(1550,'priv','de','assetlib-batchRemoveOpportunity','',''),(1550,'priv','en','assetlib-batchRemoveOpportunity','',''),(1550,'priv','fr','assetlib-batchRemoveOpportunity','',''),(1550,'priv','zh-cn','assetlib-batchRemoveOpportunity','',''),(1550,'priv','zh-tw','assetlib-batchRemoveOpportunity','',''),(1551,'priv','de','assetlib-opportunityView','',''),(1551,'priv','en','assetlib-opportunityView','',''),(1551,'priv','fr','assetlib-opportunityView','',''),(1551,'priv','zh-cn','assetlib-opportunityView','',''),(1551,'priv','zh-tw','assetlib-opportunityView','',''),(1552,'priv','de','assetlib-practiceLib','',''),(1552,'priv','en','assetlib-practiceLib','',''),(1552,'priv','fr','assetlib-practiceLib','',''),(1552,'priv','zh-cn','assetlib-practiceLib','',''),(1552,'priv','zh-tw','assetlib-practiceLib','',''),(1553,'priv','de','assetlib-createPracticeLib','',''),(1553,'priv','en','assetlib-createPracticeLib','',''),(1553,'priv','fr','assetlib-createPracticeLib','',''),(1553,'priv','zh-cn','assetlib-createPracticeLib','',''),(1553,'priv','zh-tw','assetlib-createPracticeLib','',''),(1554,'priv','de','assetlib-editPracticeLib','',''),(1554,'priv','en','assetlib-editPracticeLib','',''),(1554,'priv','fr','assetlib-editPracticeLib','',''),(1554,'priv','zh-cn','assetlib-editPracticeLib','',''),(1554,'priv','zh-tw','assetlib-editPracticeLib','',''),(1555,'priv','de','assetlib-deletePracticeLib','',''),(1555,'priv','en','assetlib-deletePracticeLib','',''),(1555,'priv','fr','assetlib-deletePracticeLib','',''),(1555,'priv','zh-cn','assetlib-deletePracticeLib','',''),(1555,'priv','zh-tw','assetlib-deletePracticeLib','',''),(1556,'priv','de','assetlib-practiceLibView','',''),(1556,'priv','en','assetlib-practiceLibView','',''),(1556,'priv','fr','assetlib-practiceLibView','',''),(1556,'priv','zh-cn','assetlib-practiceLibView','',''),(1556,'priv','zh-tw','assetlib-practiceLibView','',''),(1557,'priv','de','assetlib-practice','',''),(1557,'priv','en','assetlib-practice','',''),(1557,'priv','fr','assetlib-practice','',''),(1557,'priv','zh-cn','assetlib-practice','',''),(1557,'priv','zh-tw','assetlib-practice','',''),(1558,'priv','de','assetlib-importPractice','',''),(1558,'priv','en','assetlib-importPractice','',''),(1558,'priv','fr','assetlib-importPractice','',''),(1558,'priv','zh-cn','assetlib-importPractice','',''),(1558,'priv','zh-tw','assetlib-importPractice','',''),(1559,'priv','de','assetlib-assignToPractice','',''),(1559,'priv','en','assetlib-assignToPractice','',''),(1559,'priv','fr','assetlib-assignToPractice','',''),(1559,'priv','zh-cn','assetlib-assignToPractice','',''),(1559,'priv','zh-tw','assetlib-assignToPractice','',''),(1560,'priv','de','assetlib-batchAssignToPractice','',''),(1560,'priv','en','assetlib-batchAssignToPractice','',''),(1560,'priv','fr','assetlib-batchAssignToPractice','',''),(1560,'priv','zh-cn','assetlib-batchAssignToPractice','',''),(1560,'priv','zh-tw','assetlib-batchAssignToPractice','',''),(1561,'priv','de','assetlib-approvePractice','',''),(1561,'priv','en','assetlib-approvePractice','',''),(1561,'priv','fr','assetlib-approvePractice','',''),(1561,'priv','zh-cn','assetlib-approvePractice','',''),(1561,'priv','zh-tw','assetlib-approvePractice','',''),(1562,'priv','de','assetlib-batchApprovePractice','',''),(1562,'priv','en','assetlib-batchApprovePractice','',''),(1562,'priv','fr','assetlib-batchApprovePractice','',''),(1562,'priv','zh-cn','assetlib-batchApprovePractice','',''),(1562,'priv','zh-tw','assetlib-batchApprovePractice','',''),(1563,'priv','de','assetlib-editPractice','',''),(1563,'priv','en','assetlib-editPractice','',''),(1563,'priv','fr','assetlib-editPractice','',''),(1563,'priv','zh-cn','assetlib-editPractice','',''),(1563,'priv','zh-tw','assetlib-editPractice','',''),(1564,'priv','de','assetlib-removePractice','',''),(1564,'priv','en','assetlib-removePractice','',''),(1564,'priv','fr','assetlib-removePractice','',''),(1564,'priv','zh-cn','assetlib-removePractice','',''),(1564,'priv','zh-tw','assetlib-removePractice','',''),(1565,'priv','de','assetlib-batchRemovePractice','',''),(1565,'priv','en','assetlib-batchRemovePractice','',''),(1565,'priv','fr','assetlib-batchRemovePractice','',''),(1565,'priv','zh-cn','assetlib-batchRemovePractice','',''),(1565,'priv','zh-tw','assetlib-batchRemovePractice','',''),(1566,'priv','de','assetlib-practiceView','',''),(1566,'priv','en','assetlib-practiceView','',''),(1566,'priv','fr','assetlib-practiceView','',''),(1566,'priv','zh-cn','assetlib-practiceView','',''),(1566,'priv','zh-tw','assetlib-practiceView','',''),(1567,'priv','de','assetlib-componentLib','',''),(1567,'priv','en','assetlib-componentLib','',''),(1567,'priv','fr','assetlib-componentLib','',''),(1567,'priv','zh-cn','assetlib-componentLib','',''),(1567,'priv','zh-tw','assetlib-componentLib','',''),(1568,'priv','de','assetlib-createComponentLib','',''),(1568,'priv','en','assetlib-createComponentLib','',''),(1568,'priv','fr','assetlib-createComponentLib','',''),(1568,'priv','zh-cn','assetlib-createComponentLib','',''),(1568,'priv','zh-tw','assetlib-createComponentLib','',''),(1569,'priv','de','assetlib-editComponentLib','',''),(1569,'priv','en','assetlib-editComponentLib','',''),(1569,'priv','fr','assetlib-editComponentLib','',''),(1569,'priv','zh-cn','assetlib-editComponentLib','',''),(1569,'priv','zh-tw','assetlib-editComponentLib','',''),(1570,'priv','de','assetlib-deleteComponentLib','',''),(1570,'priv','en','assetlib-deleteComponentLib','',''),(1570,'priv','fr','assetlib-deleteComponentLib','',''),(1570,'priv','zh-cn','assetlib-deleteComponentLib','',''),(1570,'priv','zh-tw','assetlib-deleteComponentLib','',''),(1571,'priv','de','assetlib-componentLibView','',''),(1571,'priv','en','assetlib-componentLibView','',''),(1571,'priv','fr','assetlib-componentLibView','',''),(1571,'priv','zh-cn','assetlib-componentLibView','',''),(1571,'priv','zh-tw','assetlib-componentLibView','',''),(1572,'priv','de','assetlib-component','',''),(1572,'priv','en','assetlib-component','',''),(1572,'priv','fr','assetlib-component','',''),(1572,'priv','zh-cn','assetlib-component','',''),(1572,'priv','zh-tw','assetlib-component','',''),(1573,'priv','de','assetlib-importComponent','',''),(1573,'priv','en','assetlib-importComponent','',''),(1573,'priv','fr','assetlib-importComponent','',''),(1573,'priv','zh-cn','assetlib-importComponent','',''),(1573,'priv','zh-tw','assetlib-importComponent','',''),(1574,'priv','de','assetlib-assignToComponent','',''),(1574,'priv','en','assetlib-assignToComponent','',''),(1574,'priv','fr','assetlib-assignToComponent','',''),(1574,'priv','zh-cn','assetlib-assignToComponent','',''),(1574,'priv','zh-tw','assetlib-assignToComponent','',''),(1575,'priv','de','assetlib-batchAssignToComponent','',''),(1575,'priv','en','assetlib-batchAssignToComponent','',''),(1575,'priv','fr','assetlib-batchAssignToComponent','',''),(1575,'priv','zh-cn','assetlib-batchAssignToComponent','',''),(1575,'priv','zh-tw','assetlib-batchAssignToComponent','',''),(1576,'priv','de','assetlib-approveComponent','',''),(1576,'priv','en','assetlib-approveComponent','',''),(1576,'priv','fr','assetlib-approveComponent','',''),(1576,'priv','zh-cn','assetlib-approveComponent','',''),(1576,'priv','zh-tw','assetlib-approveComponent','',''),(1577,'priv','de','assetlib-batchApproveComponent','',''),(1577,'priv','en','assetlib-batchApproveComponent','',''),(1577,'priv','fr','assetlib-batchApproveComponent','',''),(1577,'priv','zh-cn','assetlib-batchApproveComponent','',''),(1577,'priv','zh-tw','assetlib-batchApproveComponent','',''),(1578,'priv','de','assetlib-editComponent','',''),(1578,'priv','en','assetlib-editComponent','',''),(1578,'priv','fr','assetlib-editComponent','',''),(1578,'priv','zh-cn','assetlib-editComponent','',''),(1578,'priv','zh-tw','assetlib-editComponent','',''),(1579,'priv','de','assetlib-removeComponent','',''),(1579,'priv','en','assetlib-removeComponent','',''),(1579,'priv','fr','assetlib-removeComponent','',''),(1579,'priv','zh-cn','assetlib-removeComponent','',''),(1579,'priv','zh-tw','assetlib-removeComponent','',''),(1580,'priv','de','assetlib-batchRemoveComponent','',''),(1580,'priv','en','assetlib-batchRemoveComponent','',''),(1580,'priv','fr','assetlib-batchRemoveComponent','',''),(1580,'priv','zh-cn','assetlib-batchRemoveComponent','',''),(1580,'priv','zh-tw','assetlib-batchRemoveComponent','',''),(1581,'priv','de','assetlib-componentView','',''),(1581,'priv','en','assetlib-componentView','',''),(1581,'priv','fr','assetlib-componentView','',''),(1581,'priv','zh-cn','assetlib-componentView','',''),(1581,'priv','zh-tw','assetlib-componentView','',''),(1583,'priv','de','assetlib-storylibSort','',''),(1583,'priv','en','assetlib-storylibSort','',''),(1583,'priv','fr','assetlib-storylibSort','',''),(1583,'priv','zh-cn','assetlib-storylibSort','',''),(1583,'priv','zh-tw','assetlib-storylibSort','',''),(1584,'priv','de','assetlib-caselibSort','',''),(1584,'priv','en','assetlib-caselibSort','',''),(1584,'priv','fr','assetlib-caselibSort','',''),(1584,'priv','zh-cn','assetlib-caselibSort','',''),(1584,'priv','zh-tw','assetlib-caselibSort','',''),(1585,'priv','de','assetlib-issuelibSort','',''),(1585,'priv','en','assetlib-issuelibSort','',''),(1585,'priv','fr','assetlib-issuelibSort','',''),(1585,'priv','zh-cn','assetlib-issuelibSort','',''),(1585,'priv','zh-tw','assetlib-issuelibSort','',''),(1586,'priv','de','assetlib-risklibSort','',''),(1586,'priv','en','assetlib-risklibSort','',''),(1586,'priv','fr','assetlib-risklibSort','',''),(1586,'priv','zh-cn','assetlib-risklibSort','',''),(1586,'priv','zh-tw','assetlib-risklibSort','',''),(1587,'priv','de','assetlib-opportunitylibSort','',''),(1587,'priv','en','assetlib-opportunitylibSort','',''),(1587,'priv','fr','assetlib-opportunitylibSort','',''),(1587,'priv','zh-cn','assetlib-opportunitylibSort','',''),(1587,'priv','zh-tw','assetlib-opportunitylibSort','',''),(1588,'priv','de','assetlib-practicelibSort','',''),(1588,'priv','en','assetlib-practicelibSort','',''),(1588,'priv','fr','assetlib-practicelibSort','',''),(1588,'priv','zh-cn','assetlib-practicelibSort','',''),(1588,'priv','zh-tw','assetlib-practicelibSort','',''),(1589,'priv','de','assetlib-componentlibSort','',''),(1589,'priv','en','assetlib-componentlibSort','',''),(1589,'priv','fr','assetlib-componentlibSort','',''),(1589,'priv','zh-cn','assetlib-componentlibSort','',''),(1589,'priv','zh-tw','assetlib-componentlibSort','',''),(1590,'priv','de','setting-xuanxuan','',''),(1590,'priv','en','setting-xuanxuan','',''),(1590,'priv','fr','setting-xuanxuan','',''),(1590,'priv','zh-cn','setting-xuanxuan','',''),(1590,'priv','zh-tw','setting-xuanxuan','',''),(1596,'priv','de','im-downloadXXD','',''),(1596,'priv','en','im-downloadXXD','',''),(1596,'priv','fr','im-downloadXXD','',''),(1596,'priv','zh-cn','im-downloadXXD','',''),(1596,'priv','zh-tw','im-downloadXXD','',''),(1597,'priv','de','im-debug','',''),(1597,'priv','en','im-debug','',''),(1597,'priv','fr','im-debug','',''),(1597,'priv','zh-cn','im-debug','',''),(1597,'priv','zh-tw','im-debug','',''),(1598,'priv','de','client-browse','',''),(1598,'priv','en','client-browse','',''),(1598,'priv','fr','client-browse','',''),(1598,'priv','zh-cn','client-browse','',''),(1598,'priv','zh-tw','client-browse','',''),(1599,'priv','de','client-create','',''),(1599,'priv','en','client-create','',''),(1599,'priv','fr','client-create','',''),(1599,'priv','zh-cn','client-create','',''),(1599,'priv','zh-tw','client-create','',''),(1600,'priv','de','client-edit','',''),(1600,'priv','en','client-edit','',''),(1600,'priv','fr','client-edit','',''),(1600,'priv','zh-cn','client-edit','',''),(1600,'priv','zh-tw','client-edit','',''),(1601,'priv','de','client-delete','',''),(1601,'priv','en','client-delete','',''),(1601,'priv','fr','client-delete','',''),(1601,'priv','zh-cn','client-delete','',''),(1601,'priv','zh-tw','client-delete','',''),(1615,'priv','de','screen-create','',''),(1615,'priv','en','screen-create','',''),(1615,'priv','fr','screen-create','',''),(1615,'priv','zh-cn','screen-create','',''),(1615,'priv','zh-tw','screen-create','',''),(1616,'priv','de','screen-editScreen','',''),(1616,'priv','en','screen-editScreen','',''),(1616,'priv','fr','screen-editScreen','',''),(1616,'priv','zh-cn','screen-editScreen','',''),(1616,'priv','zh-tw','screen-editScreen','',''),(1617,'priv','de','screen-designScreen','',''),(1617,'priv','en','screen-designScreen','',''),(1617,'priv','fr','screen-designScreen','',''),(1617,'priv','zh-cn','screen-designScreen','',''),(1617,'priv','zh-tw','screen-designScreen','',''),(1618,'priv','de','screen-publishScreen','',''),(1618,'priv','en','screen-publishScreen','',''),(1618,'priv','fr','screen-publishScreen','',''),(1618,'priv','zh-cn','screen-publishScreen','',''),(1618,'priv','zh-tw','screen-publishScreen','',''),(1619,'priv','de','screen-deleteScreen','',''),(1619,'priv','en','screen-deleteScreen','',''),(1619,'priv','fr','screen-deleteScreen','',''),(1619,'priv','zh-cn','screen-deleteScreen','',''),(1619,'priv','zh-tw','screen-deleteScreen','',''),(1620,'priv','de','screen-annualData','',''),(1620,'priv','en','screen-annualData','',''),(1620,'priv','fr','screen-annualData','',''),(1620,'priv','zh-cn','screen-annualData','',''),(1620,'priv','zh-tw','screen-annualData','',''),(1621,'priv','de','screen-allAnnualData','',''),(1621,'priv','en','screen-allAnnualData','',''),(1621,'priv','fr','screen-allAnnualData','',''),(1621,'priv','zh-cn','screen-allAnnualData','',''),(1621,'priv','zh-tw','screen-allAnnualData','',''),(1622,'priv','de','pivot-browseAction','',''),(1622,'priv','en','pivot-browseAction','',''),(1622,'priv','fr','pivot-browseAction','',''),(1622,'priv','zh-cn','pivot-browseAction','',''),(1622,'priv','zh-tw','pivot-browseAction','',''),(1623,'priv','de','pivot-preview','',''),(1623,'priv','en','pivot-preview','',''),(1623,'priv','fr','pivot-preview','',''),(1623,'priv','zh-cn','pivot-preview','',''),(1623,'priv','zh-tw','pivot-preview','',''),(1624,'priv','de','pivot-create','',''),(1624,'priv','en','pivot-create','',''),(1624,'priv','fr','pivot-create','',''),(1624,'priv','zh-cn','pivot-create','',''),(1624,'priv','zh-tw','pivot-create','',''),(1625,'priv','de','pivot-edit','',''),(1625,'priv','en','pivot-edit','',''),(1625,'priv','fr','pivot-edit','',''),(1625,'priv','zh-cn','pivot-edit','',''),(1625,'priv','zh-tw','pivot-edit','',''),(1626,'priv','de','pivot-design','',''),(1626,'priv','en','pivot-design','',''),(1626,'priv','fr','pivot-design','',''),(1626,'priv','zh-cn','pivot-design','',''),(1626,'priv','zh-tw','pivot-design','',''),(1627,'priv','de','pivot-delete','',''),(1627,'priv','en','pivot-delete','',''),(1627,'priv','fr','pivot-delete','',''),(1627,'priv','zh-cn','pivot-delete','',''),(1627,'priv','zh-tw','pivot-delete','',''),(1628,'priv','de','pivot-export','',''),(1628,'priv','en','pivot-export','',''),(1628,'priv','fr','pivot-export','',''),(1628,'priv','zh-cn','pivot-export','',''),(1628,'priv','zh-tw','pivot-export','',''),(1629,'priv','de','pivot-showProduct','',''),(1629,'priv','en','pivot-showProduct','',''),(1629,'priv','fr','pivot-showProduct','',''),(1629,'priv','zh-cn','pivot-showProduct','',''),(1629,'priv','zh-tw','pivot-showProduct','',''),(1630,'priv','de','pivot-showProject','',''),(1630,'priv','en','pivot-showProject','',''),(1630,'priv','fr','pivot-showProject','',''),(1630,'priv','zh-cn','pivot-showProject','',''),(1630,'priv','zh-tw','pivot-showProject','',''),(1631,'priv','de','pivot-projectDeviation','',''),(1631,'priv','en','pivot-projectDeviation','',''),(1631,'priv','fr','pivot-projectDeviation','',''),(1631,'priv','zh-cn','pivot-projectDeviation','',''),(1631,'priv','zh-tw','pivot-projectDeviation','',''),(1632,'priv','de','pivot-productSummary','',''),(1632,'priv','en','pivot-productSummary','',''),(1632,'priv','fr','pivot-productSummary','',''),(1632,'priv','zh-cn','pivot-productSummary','',''),(1632,'priv','zh-tw','pivot-productSummary','',''),(1633,'priv','de','pivot-bugCreate','',''),(1633,'priv','en','pivot-bugCreate','',''),(1633,'priv','fr','pivot-bugCreate','',''),(1633,'priv','zh-cn','pivot-bugCreate','',''),(1633,'priv','zh-tw','pivot-bugCreate','',''),(1634,'priv','de','pivot-bugAssign','',''),(1634,'priv','en','pivot-bugAssign','',''),(1634,'priv','fr','pivot-bugAssign','',''),(1634,'priv','zh-cn','pivot-bugAssign','',''),(1634,'priv','zh-tw','pivot-bugAssign','',''),(1635,'priv','de','pivot-workload','',''),(1635,'priv','en','pivot-workload','',''),(1635,'priv','fr','pivot-workload','',''),(1635,'priv','zh-cn','pivot-workload','',''),(1635,'priv','zh-tw','pivot-workload','',''),(1636,'priv','de','pivot-casesrun','',''),(1636,'priv','en','pivot-casesrun','',''),(1636,'priv','fr','pivot-casesrun','',''),(1636,'priv','zh-cn','pivot-casesrun','',''),(1636,'priv','zh-tw','pivot-casesrun','',''),(1637,'priv','de','pivot-storyLinkedBug','',''),(1637,'priv','en','pivot-storyLinkedBug','',''),(1637,'priv','fr','pivot-storyLinkedBug','',''),(1637,'priv','zh-cn','pivot-storyLinkedBug','',''),(1637,'priv','zh-tw','pivot-storyLinkedBug','',''),(1638,'priv','de','pivot-testcase','',''),(1638,'priv','en','pivot-testcase','',''),(1638,'priv','fr','pivot-testcase','',''),(1638,'priv','zh-cn','pivot-testcase','',''),(1638,'priv','zh-tw','pivot-testcase','',''),(1639,'priv','de','pivot-build','',''),(1639,'priv','en','pivot-build','',''),(1639,'priv','fr','pivot-build','',''),(1639,'priv','zh-cn','pivot-build','',''),(1639,'priv','zh-tw','pivot-build','',''),(1640,'priv','de','pivot-workSummary','',''),(1640,'priv','en','pivot-workSummary','',''),(1640,'priv','fr','pivot-workSummary','',''),(1640,'priv','zh-cn','pivot-workSummary','',''),(1640,'priv','zh-tw','pivot-workSummary','',''),(1641,'priv','de','pivot-roadmap','',''),(1641,'priv','en','pivot-roadmap','',''),(1641,'priv','fr','pivot-roadmap','',''),(1641,'priv','zh-cn','pivot-roadmap','',''),(1641,'priv','zh-tw','pivot-roadmap','',''),(1642,'priv','de','pivot-productInvest','',''),(1642,'priv','en','pivot-productInvest','',''),(1642,'priv','fr','pivot-productInvest','',''),(1642,'priv','zh-cn','pivot-productInvest','',''),(1642,'priv','zh-tw','pivot-productInvest','',''),(1643,'priv','de','pivot-bugSummary','',''),(1643,'priv','en','pivot-bugSummary','',''),(1643,'priv','fr','pivot-bugSummary','',''),(1643,'priv','zh-cn','pivot-bugSummary','',''),(1643,'priv','zh-tw','pivot-bugSummary','',''),(1644,'priv','de','pivot-bugAssignSummary','',''),(1644,'priv','en','pivot-bugAssignSummary','',''),(1644,'priv','fr','pivot-bugAssignSummary','',''),(1644,'priv','zh-cn','pivot-bugAssignSummary','',''),(1644,'priv','zh-tw','pivot-bugAssignSummary','',''),(1645,'priv','de','pivot-workAssignSummary','',''),(1645,'priv','en','pivot-workAssignSummary','',''),(1645,'priv','fr','pivot-workAssignSummary','',''),(1645,'priv','zh-cn','pivot-workAssignSummary','',''),(1645,'priv','zh-tw','pivot-workAssignSummary','',''),(1646,'priv','de','chart-preview','',''),(1646,'priv','en','chart-preview','',''),(1646,'priv','fr','chart-preview','',''),(1646,'priv','zh-cn','chart-preview','',''),(1646,'priv','zh-tw','chart-preview','',''),(1648,'priv','de','dataview-browse','',''),(1648,'priv','en','dataview-browse','',''),(1648,'priv','fr','dataview-browse','',''),(1648,'priv','zh-cn','dataview-browse','',''),(1648,'priv','zh-tw','dataview-browse','',''),(1649,'priv','de','dataview-create','',''),(1649,'priv','en','dataview-create','',''),(1649,'priv','fr','dataview-create','',''),(1649,'priv','zh-cn','dataview-create','',''),(1649,'priv','zh-tw','dataview-create','',''),(1650,'priv','de','dataview-edit','',''),(1650,'priv','en','dataview-edit','',''),(1650,'priv','fr','dataview-edit','',''),(1650,'priv','zh-cn','dataview-edit','',''),(1650,'priv','zh-tw','dataview-edit','',''),(1651,'priv','de','dataview-design','',''),(1651,'priv','en','dataview-design','',''),(1651,'priv','fr','dataview-design','',''),(1651,'priv','zh-cn','dataview-design','',''),(1651,'priv','zh-tw','dataview-design','',''),(1652,'priv','de','dataview-delete','',''),(1652,'priv','en','dataview-delete','',''),(1652,'priv','fr','dataview-delete','',''),(1652,'priv','zh-cn','dataview-delete','',''),(1652,'priv','zh-tw','dataview-delete','',''),(1653,'priv','de','dimension-browse','',''),(1653,'priv','en','dimension-browse','',''),(1653,'priv','fr','dimension-browse','',''),(1653,'priv','zh-cn','dimension-browse','',''),(1653,'priv','zh-tw','dimension-browse','',''),(1654,'priv','de','dimension-create','',''),(1654,'priv','en','dimension-create','',''),(1654,'priv','fr','dimension-create','',''),(1654,'priv','zh-cn','dimension-create','',''),(1654,'priv','zh-tw','dimension-create','',''),(1655,'priv','de','dimension-edit','',''),(1655,'priv','en','dimension-edit','',''),(1655,'priv','fr','dimension-edit','',''),(1655,'priv','zh-cn','dimension-edit','',''),(1655,'priv','zh-tw','dimension-edit','',''),(1656,'priv','de','dimension-delete','',''),(1656,'priv','en','dimension-delete','',''),(1656,'priv','fr','dimension-delete','',''),(1656,'priv','zh-cn','dimension-delete','',''),(1656,'priv','zh-tw','dimension-delete','',''),(1664,'priv','de','custom-limitTaskDateAction','',''),(1664,'priv','en','custom-limitTaskDateAction','',''),(1664,'priv','fr','custom-limitTaskDateAction','',''),(1664,'priv','zh-cn','custom-limitTaskDateAction','',''),(1664,'priv','zh-tw','custom-limitTaskDateAction','',''),(1665,'priv','de','tree-browsegroup','',''),(1665,'priv','en','tree-browsegroup','',''),(1665,'priv','fr','tree-browsegroup','',''),(1665,'priv','zh-cn','tree-browsegroup','',''),(1665,'priv','zh-tw','tree-browsegroup','',''),(1673,'priv','de','testcase-createScene','',''),(1673,'priv','en','testcase-createScene','',''),(1673,'priv','fr','testcase-createScene','',''),(1673,'priv','zh-cn','testcase-createScene','',''),(1673,'priv','zh-tw','testcase-createScene','',''),(1674,'priv','de','testcase-editScene','',''),(1674,'priv','en','testcase-editScene','',''),(1674,'priv','fr','testcase-editScene','',''),(1674,'priv','zh-cn','testcase-editScene','',''),(1674,'priv','zh-tw','testcase-editScene','',''),(1675,'priv','de','testcase-deleteScene','',''),(1675,'priv','en','testcase-deleteScene','',''),(1675,'priv','fr','testcase-deleteScene','',''),(1675,'priv','zh-cn','testcase-deleteScene','',''),(1675,'priv','zh-tw','testcase-deleteScene','',''),(1676,'priv','de','testcase-changeScene','',''),(1676,'priv','en','testcase-changeScene','',''),(1676,'priv','fr','testcase-changeScene','',''),(1676,'priv','zh-cn','testcase-changeScene','',''),(1676,'priv','zh-tw','testcase-changeScene','',''),(1677,'priv','de','testcase-batchChangeScene','',''),(1677,'priv','en','testcase-batchChangeScene','',''),(1677,'priv','fr','testcase-batchChangeScene','',''),(1677,'priv','zh-cn','testcase-batchChangeScene','',''),(1677,'priv','zh-tw','testcase-batchChangeScene','',''),(1678,'priv','de','testcase-updateOrder','',''),(1678,'priv','en','testcase-updateOrder','',''),(1678,'priv','fr','testcase-updateOrder','',''),(1678,'priv','zh-cn','testcase-updateOrder','',''),(1678,'priv','zh-tw','testcase-updateOrder','',''),(1679,'priv','de','testcase-importXmind','',''),(1679,'priv','en','testcase-importXmind','',''),(1679,'priv','fr','testcase-importXmind','',''),(1679,'priv','zh-cn','testcase-importXmind','',''),(1679,'priv','zh-tw','testcase-importXmind','',''),(1682,'priv','de','testcase-exportXmind','',''),(1682,'priv','en','testcase-exportXmind','',''),(1682,'priv','fr','testcase-exportXmind','',''),(1682,'priv','zh-cn','testcase-exportXmind','',''),(1682,'priv','zh-tw','testcase-exportXmind','',''),(1694,'priv','de','repo-importAction','',''),(1694,'priv','en','repo-importAction','',''),(1694,'priv','fr','repo-importAction','',''),(1694,'priv','zh-cn','repo-importAction','',''),(1694,'priv','zh-tw','repo-importAction','',''),(1695,'priv','de','chart-export','',''),(1695,'priv','en','chart-export','',''),(1695,'priv','fr','chart-export','',''),(1695,'priv','zh-cn','chart-export','',''),(1695,'priv','zh-tw','chart-export','',''),(1701,'priv','de','doc-index','',''),(1701,'priv','en','doc-index','',''),(1701,'priv','fr','doc-index','',''),(1701,'priv','zh-cn','doc-index','',''),(1701,'priv','zh-tw','doc-index','',''),(1702,'priv','de','doc-mySpace','',''),(1702,'priv','en','doc-mySpace','',''),(1702,'priv','fr','doc-mySpace','',''),(1702,'priv','zh-cn','doc-mySpace','',''),(1702,'priv','zh-tw','doc-mySpace','',''),(1703,'priv','de','doc-myView','',''),(1703,'priv','en','doc-myView','',''),(1703,'priv','fr','doc-myView','',''),(1703,'priv','zh-cn','doc-myView','',''),(1703,'priv','zh-tw','doc-myView','',''),(1704,'priv','de','doc-myCollection','',''),(1704,'priv','en','doc-myCollection','',''),(1704,'priv','fr','doc-myCollection','',''),(1704,'priv','zh-cn','doc-myCollection','',''),(1704,'priv','zh-tw','doc-myCollection','',''),(1705,'priv','de','doc-myCreation','',''),(1705,'priv','en','doc-myCreation','',''),(1705,'priv','fr','doc-myCreation','',''),(1705,'priv','zh-cn','doc-myCreation','',''),(1705,'priv','zh-tw','doc-myCreation','',''),(1706,'priv','de','doc-createLib','',''),(1706,'priv','en','doc-createLib','',''),(1706,'priv','fr','doc-createLib','',''),(1706,'priv','zh-cn','doc-createLib','',''),(1706,'priv','zh-tw','doc-createLib','',''),(1707,'priv','de','doc-editLib','',''),(1707,'priv','en','doc-editLib','',''),(1707,'priv','fr','doc-editLib','',''),(1707,'priv','zh-cn','doc-editLib','',''),(1707,'priv','zh-tw','doc-editLib','',''),(1708,'priv','de','doc-deleteLib','',''),(1708,'priv','en','doc-deleteLib','',''),(1708,'priv','fr','doc-deleteLib','',''),(1708,'priv','zh-cn','doc-deleteLib','',''),(1708,'priv','zh-tw','doc-deleteLib','',''),(1709,'priv','de','doc-create','',''),(1709,'priv','en','doc-create','',''),(1709,'priv','fr','doc-create','',''),(1709,'priv','zh-cn','doc-create','',''),(1709,'priv','zh-tw','doc-create','',''),(1710,'priv','de','doc-edit','',''),(1710,'priv','en','doc-edit','',''),(1710,'priv','fr','doc-edit','',''),(1710,'priv','zh-cn','doc-edit','',''),(1710,'priv','zh-tw','doc-edit','',''),(1711,'priv','de','doc-view','',''),(1711,'priv','en','doc-view','',''),(1711,'priv','fr','doc-view','',''),(1711,'priv','zh-cn','doc-view','',''),(1711,'priv','zh-tw','doc-view','',''),(1712,'priv','de','doc-delete','',''),(1712,'priv','en','doc-delete','',''),(1712,'priv','fr','doc-delete','',''),(1712,'priv','zh-cn','doc-delete','',''),(1712,'priv','zh-tw','doc-delete','',''),(1713,'priv','de','doc-deleteFile','',''),(1713,'priv','en','doc-deleteFile','',''),(1713,'priv','fr','doc-deleteFile','',''),(1713,'priv','zh-cn','doc-deleteFile','',''),(1713,'priv','zh-tw','doc-deleteFile','',''),(1714,'priv','de','doc-collectAction','',''),(1714,'priv','en','doc-collectAction','',''),(1714,'priv','fr','doc-collectAction','',''),(1714,'priv','zh-cn','doc-collectAction','',''),(1714,'priv','zh-tw','doc-collectAction','',''),(1715,'priv','de','doc-productSpace','',''),(1715,'priv','en','doc-productSpace','',''),(1715,'priv','fr','doc-productSpace','',''),(1715,'priv','zh-cn','doc-productSpace','',''),(1715,'priv','zh-tw','doc-productSpace','',''),(1716,'priv','de','doc-projectSpace','',''),(1716,'priv','en','doc-projectSpace','',''),(1716,'priv','fr','doc-projectSpace','',''),(1716,'priv','zh-cn','doc-projectSpace','',''),(1716,'priv','zh-tw','doc-projectSpace','',''),(1717,'priv','de','doc-teamSpace','',''),(1717,'priv','en','doc-teamSpace','',''),(1717,'priv','fr','doc-teamSpace','',''),(1717,'priv','zh-cn','doc-teamSpace','',''),(1717,'priv','zh-tw','doc-teamSpace','',''),(1718,'priv','de','doc-showFiles','',''),(1718,'priv','en','doc-showFiles','',''),(1718,'priv','fr','doc-showFiles','',''),(1718,'priv','zh-cn','doc-showFiles','',''),(1718,'priv','zh-tw','doc-showFiles','',''),(1719,'priv','de','doc-addCatalog','',''),(1719,'priv','en','doc-addCatalog','',''),(1719,'priv','fr','doc-addCatalog','',''),(1719,'priv','zh-cn','doc-addCatalog','',''),(1719,'priv','zh-tw','doc-addCatalog','',''),(1720,'priv','de','doc-editCatalog','',''),(1720,'priv','en','doc-editCatalog','',''),(1720,'priv','fr','doc-editCatalog','',''),(1720,'priv','zh-cn','doc-editCatalog','',''),(1720,'priv','zh-tw','doc-editCatalog','',''),(1721,'priv','de','doc-sortCatalog','',''),(1721,'priv','en','doc-sortCatalog','',''),(1721,'priv','fr','doc-sortCatalog','',''),(1721,'priv','zh-cn','doc-sortCatalog','',''),(1721,'priv','zh-tw','doc-sortCatalog','',''),(1722,'priv','de','doc-deleteCatalog','',''),(1722,'priv','en','doc-deleteCatalog','',''),(1722,'priv','fr','doc-deleteCatalog','',''),(1722,'priv','zh-cn','doc-deleteCatalog','',''),(1722,'priv','zh-tw','doc-deleteCatalog','',''),(1723,'priv','de','doc-displaySetting','',''),(1723,'priv','en','doc-displaySetting','',''),(1723,'priv','fr','doc-displaySetting','',''),(1723,'priv','zh-cn','doc-displaySetting','',''),(1723,'priv','zh-tw','doc-displaySetting','',''),(1724,'priv','de','doc-diffAction','',''),(1724,'priv','en','doc-diffAction','',''),(1724,'priv','fr','doc-diffAction','',''),(1724,'priv','zh-cn','doc-diffAction','',''),(1724,'priv','zh-tw','doc-diffAction','',''),(1725,'priv','de','doc-mine2export','',''),(1725,'priv','en','doc-mine2export','',''),(1725,'priv','fr','doc-mine2export','',''),(1725,'priv','zh-cn','doc-mine2export','',''),(1725,'priv','zh-tw','doc-mine2export','',''),(1726,'priv','de','doc-product2export','',''),(1726,'priv','en','doc-product2export','',''),(1726,'priv','fr','doc-product2export','',''),(1726,'priv','zh-cn','doc-product2export','',''),(1726,'priv','zh-tw','doc-product2export','',''),(1727,'priv','de','doc-project2export','',''),(1727,'priv','en','doc-project2export','',''),(1727,'priv','fr','doc-project2export','',''),(1727,'priv','zh-cn','doc-project2export','',''),(1727,'priv','zh-tw','doc-project2export','',''),(1728,'priv','de','doc-custom2export','',''),(1728,'priv','en','doc-custom2export','',''),(1728,'priv','fr','doc-custom2export','',''),(1728,'priv','zh-cn','doc-custom2export','',''),(1728,'priv','zh-tw','doc-custom2export','',''),(1729,'priv','de','doc-execution2export','',''),(1729,'priv','en','doc-execution2export','',''),(1729,'priv','fr','doc-execution2export','',''),(1729,'priv','zh-cn','doc-execution2export','',''),(1729,'priv','zh-tw','doc-execution2export','',''),(1730,'priv','de','doc-importToPracticeLib','',''),(1730,'priv','en','doc-importToPracticeLib','',''),(1730,'priv','fr','doc-importToPracticeLib','',''),(1730,'priv','zh-cn','doc-importToPracticeLib','',''),(1730,'priv','zh-tw','doc-importToPracticeLib','',''),(1731,'priv','de','doc-importToComponentLib','',''),(1731,'priv','en','doc-importToComponentLib','',''),(1731,'priv','fr','doc-importToComponentLib','',''),(1731,'priv','zh-cn','doc-importToComponentLib','',''),(1731,'priv','zh-tw','doc-importToComponentLib','',''),(1732,'priv','de','report-show','',''),(1732,'priv','en','report-show','',''),(1732,'priv','fr','report-show','',''),(1732,'priv','zh-cn','report-show','',''),(1732,'priv','zh-tw','report-show','',''),(1733,'priv','de','report-custom','',''),(1733,'priv','en','report-custom','',''),(1733,'priv','fr','report-custom','',''),(1733,'priv','zh-cn','report-custom','',''),(1733,'priv','zh-tw','report-custom','',''),(1734,'priv','de','report-editReportAction','',''),(1734,'priv','en','report-editReportAction','',''),(1734,'priv','fr','report-editReportAction','',''),(1734,'priv','zh-cn','report-editReportAction','',''),(1734,'priv','zh-tw','report-editReportAction','',''),(1735,'priv','de','report-useReportAction','',''),(1735,'priv','en','report-useReportAction','',''),(1735,'priv','fr','report-useReportAction','',''),(1735,'priv','zh-cn','report-useReportAction','',''),(1735,'priv','zh-tw','report-useReportAction','',''),(1736,'priv','de','report-deleteReport','',''),(1736,'priv','en','report-deleteReport','',''),(1736,'priv','fr','report-deleteReport','',''),(1736,'priv','zh-cn','report-deleteReport','',''),(1736,'priv','zh-tw','report-deleteReport','',''),(1737,'priv','de','report-saveReport','',''),(1737,'priv','en','report-saveReport','',''),(1737,'priv','fr','report-saveReport','',''),(1737,'priv','zh-cn','report-saveReport','',''),(1737,'priv','zh-tw','report-saveReport','',''),(1738,'priv','de','report-crystalExport','',''),(1738,'priv','en','report-crystalExport','',''),(1738,'priv','fr','report-crystalExport','',''),(1738,'priv','zh-cn','report-crystalExport','',''),(1738,'priv','zh-tw','report-crystalExport','',''),(1739,'priv','de','report-customeredReport','',''),(1739,'priv','en','report-customeredReport','',''),(1739,'priv','fr','report-customeredReport','',''),(1739,'priv','zh-cn','report-customeredReport','',''),(1739,'priv','zh-tw','report-customeredReport','',''),(1740,'priv','de','report-viewReport','',''),(1740,'priv','en','report-viewReport','',''),(1740,'priv','fr','report-viewReport','',''),(1740,'priv','zh-cn','report-viewReport','',''),(1740,'priv','zh-tw','report-viewReport','',''),(1741,'priv','de','report-projectSummary','',''),(1741,'priv','en','report-projectSummary','',''),(1741,'priv','fr','report-projectSummary','',''),(1741,'priv','zh-cn','report-projectSummary','',''),(1741,'priv','zh-tw','report-projectSummary','',''),(1742,'priv','de','report-projectWorkload','',''),(1742,'priv','en','report-projectWorkload','',''),(1742,'priv','fr','report-projectWorkload','',''),(1742,'priv','zh-cn','report-projectWorkload','',''),(1742,'priv','zh-tw','report-projectWorkload','',''),(1743,'priv','de','report-export','',''),(1743,'priv','en','report-export','',''),(1743,'priv','fr','report-export','',''),(1743,'priv','zh-cn','report-export','',''),(1743,'priv','zh-tw','report-export','',''),(1744,'priv','de','api-index','',''),(1744,'priv','en','api-index','',''),(1744,'priv','fr','api-index','',''),(1744,'priv','zh-cn','api-index','',''),(1744,'priv','zh-tw','api-index','',''),(1745,'priv','de','api-createLib','',''),(1745,'priv','en','api-createLib','',''),(1745,'priv','fr','api-createLib','',''),(1745,'priv','zh-cn','api-createLib','',''),(1745,'priv','zh-tw','api-createLib','',''),(1746,'priv','de','api-editLib','',''),(1746,'priv','en','api-editLib','',''),(1746,'priv','fr','api-editLib','',''),(1746,'priv','zh-cn','api-editLib','',''),(1746,'priv','zh-tw','api-editLib','',''),(1747,'priv','de','api-deleteLib','',''),(1747,'priv','en','api-deleteLib','',''),(1747,'priv','fr','api-deleteLib','',''),(1747,'priv','zh-cn','api-deleteLib','',''),(1747,'priv','zh-tw','api-deleteLib','',''),(1748,'priv','de','api-createRelease','',''),(1748,'priv','en','api-createRelease','',''),(1748,'priv','fr','api-createRelease','',''),(1748,'priv','zh-cn','api-createRelease','',''),(1748,'priv','zh-tw','api-createRelease','',''),(1749,'priv','de','api-releases','',''),(1749,'priv','en','api-releases','',''),(1749,'priv','fr','api-releases','',''),(1749,'priv','zh-cn','api-releases','',''),(1749,'priv','zh-tw','api-releases','',''),(1750,'priv','de','api-deleteRelease','',''),(1750,'priv','en','api-deleteRelease','',''),(1750,'priv','fr','api-deleteRelease','',''),(1750,'priv','zh-cn','api-deleteRelease','',''),(1750,'priv','zh-tw','api-deleteRelease','',''),(1751,'priv','de','api-struct','',''),(1751,'priv','en','api-struct','',''),(1751,'priv','fr','api-struct','',''),(1751,'priv','zh-cn','api-struct','',''),(1751,'priv','zh-tw','api-struct','',''),(1752,'priv','de','api-createStruct','',''),(1752,'priv','en','api-createStruct','',''),(1752,'priv','fr','api-createStruct','',''),(1752,'priv','zh-cn','api-createStruct','',''),(1752,'priv','zh-tw','api-createStruct','',''),(1753,'priv','de','api-editStruct','',''),(1753,'priv','en','api-editStruct','',''),(1753,'priv','fr','api-editStruct','',''),(1753,'priv','zh-cn','api-editStruct','',''),(1753,'priv','zh-tw','api-editStruct','',''),(1754,'priv','de','api-deleteStruct','',''),(1754,'priv','en','api-deleteStruct','',''),(1754,'priv','fr','api-deleteStruct','',''),(1754,'priv','zh-cn','api-deleteStruct','',''),(1754,'priv','zh-tw','api-deleteStruct','',''),(1755,'priv','de','api-create','',''),(1755,'priv','en','api-create','',''),(1755,'priv','fr','api-create','',''),(1755,'priv','zh-cn','api-create','',''),(1755,'priv','zh-tw','api-create','',''),(1756,'priv','de','api-edit','',''),(1756,'priv','en','api-edit','',''),(1756,'priv','fr','api-edit','',''),(1756,'priv','zh-cn','api-edit','',''),(1756,'priv','zh-tw','api-edit','',''),(1757,'priv','de','api-delete','',''),(1757,'priv','en','api-delete','',''),(1757,'priv','fr','api-delete','',''),(1757,'priv','zh-cn','api-delete','',''),(1757,'priv','zh-tw','api-delete','',''),(1758,'priv','de','api-addCatalog','',''),(1758,'priv','en','api-addCatalog','',''),(1758,'priv','fr','api-addCatalog','',''),(1758,'priv','zh-cn','api-addCatalog','',''),(1758,'priv','zh-tw','api-addCatalog','',''),(1759,'priv','de','api-editCatalog','',''),(1759,'priv','en','api-editCatalog','',''),(1759,'priv','fr','api-editCatalog','',''),(1759,'priv','zh-cn','api-editCatalog','',''),(1759,'priv','zh-tw','api-editCatalog','',''),(1760,'priv','de','api-sortCatalog','',''),(1760,'priv','en','api-sortCatalog','',''),(1760,'priv','fr','api-sortCatalog','',''),(1760,'priv','zh-cn','api-sortCatalog','',''),(1760,'priv','zh-tw','api-sortCatalog','',''),(1761,'priv','de','api-deleteCatalog','',''),(1761,'priv','en','api-deleteCatalog','',''),(1761,'priv','fr','api-deleteCatalog','',''),(1761,'priv','zh-cn','api-deleteCatalog','',''),(1761,'priv','zh-tw','api-deleteCatalog','',''),(1762,'priv','de','api-getModel','',''),(1762,'priv','en','api-getModel','',''),(1762,'priv','fr','api-getModel','',''),(1762,'priv','zh-cn','api-getModel','',''),(1762,'priv','zh-tw','api-getModel','',''),(1763,'priv','de','api-debug','',''),(1763,'priv','en','api-debug','',''),(1763,'priv','fr','api-debug','',''),(1763,'priv','zh-cn','api-debug','',''),(1763,'priv','zh-tw','api-debug','',''),(1764,'priv','de','api-sql','',''),(1764,'priv','en','api-sql','',''),(1764,'priv','fr','api-sql','',''),(1764,'priv','zh-cn','api-sql','',''),(1764,'priv','zh-tw','api-sql','',''),(1765,'priv','de','api-export','',''),(1765,'priv','en','api-export','',''),(1765,'priv','fr','api-export','',''),(1765,'priv','zh-cn','api-export','',''),(1765,'priv','zh-tw','api-export','',''),(1766,'priv','de','doc-myEdited','',''),(1766,'priv','en','doc-myEdited','',''),(1766,'priv','fr','doc-myEdited','',''),(1766,'priv','zh-cn','doc-myEdited','',''),(1766,'priv','zh-tw','doc-myEdited','',''),(1767,'priv','de','traincourse-batchImport','',''),(1767,'priv','en','traincourse-batchImport','',''),(1767,'priv','fr','traincourse-batchImport','',''),(1767,'priv','zh-cn','traincourse-batchImport','',''),(1767,'priv','zh-tw','traincourse-batchImport','',''),(2060,'priv','de','product-activateAction','',''),(2060,'priv','en','product-activateAction','',''),(2060,'priv','fr','product-activateAction','',''),(2060,'priv','zh-cn','product-activateAction','',''),(2060,'priv','zh-tw','product-activateAction','',''),(2061,'priv','de','charter-browse','',''),(2061,'priv','en','charter-browse','',''),(2061,'priv','fr','charter-browse','',''),(2061,'priv','zh-cn','charter-browse','',''),(2061,'priv','zh-tw','charter-browse','',''),(2062,'priv','de','charter-create','',''),(2062,'priv','en','charter-create','',''),(2062,'priv','fr','charter-create','',''),(2062,'priv','zh-cn','charter-create','',''),(2062,'priv','zh-tw','charter-create','',''),(2063,'priv','de','charter-edit','',''),(2063,'priv','en','charter-edit','',''),(2063,'priv','fr','charter-edit','',''),(2063,'priv','zh-cn','charter-edit','',''),(2063,'priv','zh-tw','charter-edit','',''),(2064,'priv','de','charter-view','',''),(2064,'priv','en','charter-view','',''),(2064,'priv','fr','charter-view','',''),(2064,'priv','zh-cn','charter-view','',''),(2064,'priv','zh-tw','charter-view','',''),(2065,'priv','de','charter-delete','',''),(2065,'priv','en','charter-delete','',''),(2065,'priv','fr','charter-delete','',''),(2065,'priv','zh-cn','charter-delete','',''),(2065,'priv','zh-tw','charter-delete','',''),(2066,'priv','de','charter-review','',''),(2066,'priv','en','charter-review','',''),(2066,'priv','fr','charter-review','',''),(2066,'priv','zh-cn','charter-review','',''),(2066,'priv','zh-tw','charter-review','',''),(2067,'priv','de','charter-loadStories','',''),(2067,'priv','en','charter-loadStories','',''),(2067,'priv','fr','charter-loadStories','',''),(2067,'priv','zh-cn','charter-loadStories','',''),(2067,'priv','zh-tw','charter-loadStories','',''),(2068,'priv','de','demandpool-browse','',''),(2068,'priv','en','demandpool-browse','',''),(2068,'priv','fr','demandpool-browse','',''),(2068,'priv','zh-cn','demandpool-browse','',''),(2068,'priv','zh-tw','demandpool-browse','',''),(2069,'priv','de','demandpool-create','',''),(2069,'priv','en','demandpool-create','',''),(2069,'priv','fr','demandpool-create','',''),(2069,'priv','zh-cn','demandpool-create','',''),(2069,'priv','zh-tw','demandpool-create','',''),(2070,'priv','de','demandpool-edit','',''),(2070,'priv','en','demandpool-edit','',''),(2070,'priv','fr','demandpool-edit','',''),(2070,'priv','zh-cn','demandpool-edit','',''),(2070,'priv','zh-tw','demandpool-edit','',''),(2071,'priv','de','demandpool-view','',''),(2071,'priv','en','demandpool-view','',''),(2071,'priv','fr','demandpool-view','',''),(2071,'priv','zh-cn','demandpool-view','',''),(2071,'priv','zh-tw','demandpool-view','',''),(2072,'priv','de','demandpool-close','',''),(2072,'priv','en','demandpool-close','',''),(2072,'priv','fr','demandpool-close','',''),(2072,'priv','zh-cn','demandpool-close','',''),(2072,'priv','zh-tw','demandpool-close','',''),(2073,'priv','de','demandpool-activate','',''),(2073,'priv','en','demandpool-activate','',''),(2073,'priv','fr','demandpool-activate','',''),(2073,'priv','zh-cn','demandpool-activate','',''),(2073,'priv','zh-tw','demandpool-activate','',''),(2074,'priv','de','demandpool-delete','',''),(2074,'priv','en','demandpool-delete','',''),(2074,'priv','fr','demandpool-delete','',''),(2074,'priv','zh-cn','demandpool-delete','',''),(2074,'priv','zh-tw','demandpool-delete','',''),(2075,'priv','de','demand-browse','',''),(2075,'priv','en','demand-browse','',''),(2075,'priv','fr','demand-browse','',''),(2075,'priv','zh-cn','demand-browse','',''),(2075,'priv','zh-tw','demand-browse','',''),(2076,'priv','de','demand-create','',''),(2076,'priv','en','demand-create','',''),(2076,'priv','fr','demand-create','',''),(2076,'priv','zh-cn','demand-create','',''),(2076,'priv','zh-tw','demand-create','',''),(2077,'priv','de','demand-batchCreate','',''),(2077,'priv','en','demand-batchCreate','',''),(2077,'priv','fr','demand-batchCreate','',''),(2077,'priv','zh-cn','demand-batchCreate','',''),(2077,'priv','zh-tw','demand-batchCreate','',''),(2078,'priv','de','demand-edit','',''),(2078,'priv','en','demand-edit','',''),(2078,'priv','fr','demand-edit','',''),(2078,'priv','zh-cn','demand-edit','',''),(2078,'priv','zh-tw','demand-edit','',''),(2079,'priv','de','demand-view','',''),(2079,'priv','en','demand-view','',''),(2079,'priv','fr','demand-view','',''),(2079,'priv','zh-cn','demand-view','',''),(2079,'priv','zh-tw','demand-view','',''),(2080,'priv','de','demand-assignedTo','',''),(2080,'priv','en','demand-assignedTo','',''),(2080,'priv','fr','demand-assignedTo','',''),(2080,'priv','zh-cn','demand-assignedTo','',''),(2080,'priv','zh-tw','demand-assignedTo','',''),(2081,'priv','de','demand-change','',''),(2081,'priv','en','demand-change','',''),(2081,'priv','fr','demand-change','',''),(2081,'priv','zh-cn','demand-change','',''),(2081,'priv','zh-tw','demand-change','',''),(2082,'priv','de','demand-review','',''),(2082,'priv','en','demand-review','',''),(2082,'priv','fr','demand-review','',''),(2082,'priv','zh-cn','demand-review','',''),(2082,'priv','zh-tw','demand-review','',''),(2083,'priv','de','demand-submitReview','',''),(2083,'priv','en','demand-submitReview','',''),(2083,'priv','fr','demand-submitReview','',''),(2083,'priv','zh-cn','demand-submitReview','',''),(2083,'priv','zh-tw','demand-submitReview','',''),(2084,'priv','de','demand-recall','',''),(2084,'priv','en','demand-recall','',''),(2084,'priv','fr','demand-recall','',''),(2084,'priv','zh-cn','demand-recall','',''),(2084,'priv','zh-tw','demand-recall','',''),(2085,'priv','de','demand-track','',''),(2085,'priv','en','demand-track','',''),(2085,'priv','fr','demand-track','',''),(2085,'priv','zh-cn','demand-track','',''),(2085,'priv','zh-tw','demand-track','',''),(2086,'priv','de','demand-manageTree','',''),(2086,'priv','en','demand-manageTree','',''),(2086,'priv','fr','demand-manageTree','',''),(2086,'priv','zh-cn','demand-manageTree','',''),(2086,'priv','zh-tw','demand-manageTree','',''),(2087,'priv','de','demand-export','',''),(2087,'priv','en','demand-export','',''),(2087,'priv','fr','demand-export','',''),(2087,'priv','zh-cn','demand-export','',''),(2087,'priv','zh-tw','demand-export','',''),(2088,'priv','de','demand-exportTemplate','',''),(2088,'priv','en','demand-exportTemplate','',''),(2088,'priv','fr','demand-exportTemplate','',''),(2088,'priv','zh-cn','demand-exportTemplate','',''),(2088,'priv','zh-tw','demand-exportTemplate','',''),(2089,'priv','de','demand-import','',''),(2089,'priv','en','demand-import','',''),(2089,'priv','fr','demand-import','',''),(2089,'priv','zh-cn','demand-import','',''),(2089,'priv','zh-tw','demand-import','',''),(2090,'priv','de','demand-showImport','',''),(2090,'priv','en','demand-showImport','',''),(2090,'priv','fr','demand-showImport','',''),(2090,'priv','zh-cn','demand-showImport','',''),(2090,'priv','zh-tw','demand-showImport','',''),(2091,'priv','de','demand-delete','',''),(2091,'priv','en','demand-delete','',''),(2091,'priv','fr','demand-delete','',''),(2091,'priv','zh-cn','demand-delete','',''),(2091,'priv','zh-tw','demand-delete','',''),(2092,'priv','de','demand-close','',''),(2092,'priv','en','demand-close','',''),(2092,'priv','fr','demand-close','',''),(2092,'priv','zh-cn','demand-close','',''),(2092,'priv','zh-tw','demand-close','',''),(2093,'priv','de','demand-activate','',''),(2093,'priv','en','demand-activate','',''),(2093,'priv','fr','demand-activate','',''),(2093,'priv','zh-cn','demand-activate','',''),(2093,'priv','zh-tw','demand-activate','',''),(2094,'priv','de','demand-distribute','',''),(2094,'priv','en','demand-distribute','',''),(2094,'priv','fr','demand-distribute','',''),(2094,'priv','zh-cn','demand-distribute','',''),(2094,'priv','zh-tw','demand-distribute','',''),(2095,'priv','de','roadmap-browse','',''),(2095,'priv','en','roadmap-browse','',''),(2095,'priv','fr','roadmap-browse','',''),(2095,'priv','zh-cn','roadmap-browse','',''),(2095,'priv','zh-tw','roadmap-browse','',''),(2096,'priv','de','roadmap-view','',''),(2096,'priv','en','roadmap-view','',''),(2096,'priv','fr','roadmap-view','',''),(2096,'priv','zh-cn','roadmap-view','',''),(2096,'priv','zh-tw','roadmap-view','',''),(2097,'priv','de','roadmap-linkUR','',''),(2097,'priv','en','roadmap-linkUR','',''),(2097,'priv','fr','roadmap-linkUR','',''),(2097,'priv','zh-cn','roadmap-linkUR','',''),(2097,'priv','zh-tw','roadmap-linkUR','',''),(2098,'priv','de','roadmap-create','',''),(2098,'priv','en','roadmap-create','',''),(2098,'priv','fr','roadmap-create','',''),(2098,'priv','zh-cn','roadmap-create','',''),(2098,'priv','zh-tw','roadmap-create','',''),(2099,'priv','de','roadmap-edit','',''),(2099,'priv','en','roadmap-edit','',''),(2099,'priv','fr','roadmap-edit','',''),(2099,'priv','zh-cn','roadmap-edit','',''),(2099,'priv','zh-tw','roadmap-edit','',''),(2100,'priv','de','roadmap-close','',''),(2100,'priv','en','roadmap-close','',''),(2100,'priv','fr','roadmap-close','',''),(2100,'priv','zh-cn','roadmap-close','',''),(2100,'priv','zh-tw','roadmap-close','',''),(2101,'priv','de','roadmap-delete','',''),(2101,'priv','en','roadmap-delete','',''),(2101,'priv','fr','roadmap-delete','',''),(2101,'priv','zh-cn','roadmap-delete','',''),(2101,'priv','zh-tw','roadmap-delete','',''),(2102,'priv','de','roadmap-activate','',''),(2102,'priv','en','roadmap-activate','',''),(2102,'priv','fr','roadmap-activate','',''),(2102,'priv','zh-cn','roadmap-activate','',''),(2102,'priv','zh-tw','roadmap-activate','',''),(2103,'priv','de','roadmap-unlinkUR','',''),(2103,'priv','en','roadmap-unlinkUR','',''),(2103,'priv','fr','roadmap-unlinkUR','',''),(2103,'priv','zh-cn','roadmap-unlinkUR','',''),(2103,'priv','zh-tw','roadmap-unlinkUR','',''),(2104,'priv','de','roadmap-batchUnlinkUR','',''),(2104,'priv','en','roadmap-batchUnlinkUR','',''),(2104,'priv','fr','roadmap-batchUnlinkUR','',''),(2104,'priv','zh-cn','roadmap-batchUnlinkUR','',''),(2104,'priv','zh-tw','roadmap-batchUnlinkUR','',''),(2105,'priv','de','my-story','',''),(2105,'priv','en','my-story','',''),(2105,'priv','fr','my-story','',''),(2105,'priv','zh-cn','my-story','',''),(2105,'priv','zh-tw','my-story','',''),(2106,'priv','de','my-task','',''),(2106,'priv','en','my-task','',''),(2106,'priv','fr','my-task','',''),(2106,'priv','zh-cn','my-task','',''),(2106,'priv','zh-tw','my-task','','');
REPLACE INTO `zt_privrelation` (`priv`, `type`, `relationPriv`) VALUES (2,'recommend',3),(3,'depend',2),(3,'depend',21),(3,'recommend',29),(4,'depend',2),(5,'depend',2),(6,'depend',2),(7,'depend',2),(8,'depend',2),(8,'depend',7),(9,'depend',2),(10,'depend',2),(11,'depend',2),(11,'depend',7),(12,'depend',2),(12,'depend',7),(13,'recommend',14),(14,'recommend',13),(15,'depend',2),(16,'recommend',630),(16,'recommend',631),(16,'recommend',632),(16,'recommend',633),(16,'recommend',635),(16,'recommend',641),(16,'recommend',642),(16,'recommend',643),(16,'recommend',644),(16,'recommend',645),(16,'recommend',646),(16,'recommend',647),(16,'recommend',650),(16,'recommend',651),(17,'depend',2),(18,'depend',2),(19,'depend',2),(21,'depend',2),(21,'recommend',3),(22,'depend',1153),(24,'depend',2),(24,'depend',21),(24,'depend',29),(24,'recommend',26),(25,'depend',2),(25,'depend',21),(25,'depend',24),(25,'depend',29),(26,'depend',2),(26,'depend',21),(26,'depend',29),(26,'recommend',24),(27,'depend',2),(27,'depend',21),(27,'depend',29),(27,'recommend',28),(28,'depend',2),(28,'depend',21),(28,'depend',29),(28,'recommend',24),(28,'recommend',27),(29,'depend',2),(29,'depend',21),(29,'recommend',3),(30,'depend',2),(30,'depend',21),(30,'depend',29),(31,'depend',2),(31,'depend',21),(32,'depend',2),(32,'depend',21),(32,'depend',29),(32,'recommend',33),(32,'recommend',37),(32,'recommend',38),(33,'depend',2),(33,'depend',21),(33,'depend',29),(33,'recommend',37),(33,'recommend',38),(34,'depend',2),(34,'depend',21),(34,'depend',29),(34,'recommend',33),(35,'depend',2),(35,'depend',21),(36,'depend',2),(36,'depend',21),(36,'depend',29),(37,'depend',2),(37,'depend',21),(37,'depend',29),(37,'recommend',38),(38,'depend',2),(38,'depend',21),(38,'depend',29),(38,'recommend',37),(39,'depend',2),(39,'depend',21),(39,'depend',29),(45,'depend',41),(45,'recommend',46),(45,'recommend',47),(45,'recommend',58),(46,'depend',41),(46,'recommend',45),(46,'recommend',47),(46,'recommend',48),(46,'recommend',49),(46,'recommend',50),(46,'recommend',58),(47,'depend',41),(47,'depend',43),(47,'recommend',45),(47,'recommend',46),(47,'recommend',49),(47,'recommend',50),(47,'recommend',51),(48,'depend',41),(48,'depend',43),(48,'recommend',45),(48,'recommend',46),(48,'recommend',47),(48,'recommend',49),(48,'recommend',50),(48,'recommend',51),(49,'depend',41),(49,'depend',43),(49,'recommend',45),(49,'recommend',46),(49,'recommend',47),(49,'recommend',50),(49,'recommend',51),(50,'depend',41),(50,'depend',43),(50,'recommend',45),(50,'recommend',46),(50,'recommend',47),(50,'recommend',49),(50,'recommend',51),(51,'depend',41),(51,'recommend',45),(53,'depend',41),(54,'depend',41),(54,'depend',53),(54,'recommend',55),(55,'depend',41),(55,'depend',53),(55,'recommend',54),(56,'depend',41),(56,'depend',53),(56,'recommend',55),(57,'depend',41),(57,'depend',61),(57,'recommend',62),(58,'depend',41),(58,'recommend',45),(58,'recommend',46),(59,'depend',41),(60,'depend',41),(61,'depend',41),(62,'depend',41),(62,'depend',61),(62,'recommend',57),(63,'recommend',67),(63,'recommend',75),(63,'recommend',78),(63,'recommend',79),(64,'recommend',91),(64,'recommend',107),(65,'depend',64),(65,'recommend',126),(65,'recommend',137),(66,'depend',78),(66,'recommend',68),(66,'recommend',76),(66,'recommend',77),(67,'depend',64),(67,'depend',75),(67,'depend',78),(67,'recommend',66),(67,'recommend',68),(67,'recommend',73),(67,'recommend',75),(67,'recommend',78),(67,'recommend',79),(67,'recommend',83),(67,'recommend',1039),(68,'depend',67),(68,'depend',78),(68,'recommend',66),(68,'recommend',69),(68,'recommend',76),(68,'recommend',77),(69,'depend',78),(69,'recommend',68),(70,'depend',67),(70,'recommend',66),(70,'recommend',68),(71,'depend',64),(71,'depend',75),(71,'depend',78),(71,'recommend',166),(72,'depend',64),(72,'recommend',64),(72,'recommend',65),(72,'recommend',91),(72,'recommend',126),(73,'depend',64),(73,'recommend',67),(73,'recommend',78),(73,'recommend',79),(74,'depend',64),(74,'recommend',179),(75,'recommend',71),(75,'recommend',73),(76,'depend',67),(76,'recommend',66),(76,'recommend',68),(77,'depend',78),(77,'recommend',66),(77,'recommend',68),(78,'recommend',63),(78,'recommend',66),(78,'recommend',67),(78,'recommend',68),(78,'recommend',73),(78,'recommend',75),(78,'recommend',77),(78,'recommend',79),(79,'recommend',63),(79,'recommend',67),(79,'recommend',73),(79,'recommend',75),(79,'recommend',78),(80,'depend',78),(80,'recommend',66),(80,'recommend',68),(80,'recommend',77),(81,'depend',64),(82,'depend',78),(83,'depend',64),(83,'recommend',67),(83,'recommend',84),(83,'recommend',85),(84,'depend',83),(84,'recommend',66),(85,'depend',83),(85,'recommend',66),(85,'recommend',84),(86,'recommend',87),(86,'recommend',88),(86,'recommend',92),(86,'recommend',94),(86,'recommend',96),(86,'recommend',97),(86,'recommend',101),(86,'recommend',103),(86,'recommend',108),(86,'recommend',112),(86,'recommend',113),(86,'recommend',114),(86,'recommend',120),(87,'depend',64),(87,'recommend',86),(88,'depend',91),(88,'recommend',86),(88,'recommend',92),(88,'recommend',94),(88,'recommend',96),(88,'recommend',97),(88,'recommend',101),(88,'recommend',103),(88,'recommend',108),(88,'recommend',112),(88,'recommend',113),(88,'recommend',114),(88,'recommend',115),(89,'depend',64),(90,'depend',91),(90,'recommend',86),(90,'recommend',88),(92,'depend',91),(92,'recommend',86),(92,'recommend',88),(92,'recommend',94),(92,'recommend',96),(92,'recommend',97),(92,'recommend',101),(92,'recommend',103),(92,'recommend',108),(92,'recommend',112),(92,'recommend',113),(92,'recommend',114),(93,'depend',91),(93,'recommend',95),(94,'depend',91),(94,'recommend',86),(94,'recommend',88),(94,'recommend',92),(94,'recommend',96),(94,'recommend',97),(94,'recommend',101),(94,'recommend',103),(94,'recommend',108),(94,'recommend',112),(94,'recommend',113),(94,'recommend',114),(95,'depend',64),(95,'recommend',93),(96,'depend',91),(96,'recommend',86),(96,'recommend',88),(96,'recommend',92),(96,'recommend',94),(96,'recommend',97),(96,'recommend',101),(96,'recommend',103),(96,'recommend',108),(96,'recommend',112),(96,'recommend',113),(96,'recommend',114),(97,'depend',91),(97,'recommend',86),(97,'recommend',88),(97,'recommend',92),(97,'recommend',94),(97,'recommend',96),(97,'recommend',101),(97,'recommend',103),(97,'recommend',108),(97,'recommend',112),(97,'recommend',113),(97,'recommend',114),(98,'depend',64),(98,'recommend',97),(99,'depend',64),(99,'recommend',88),(100,'depend',64),(100,'recommend',88),(101,'depend',64),(101,'recommend',86),(101,'recommend',88),(101,'recommend',92),(101,'recommend',94),(101,'recommend',96),(101,'recommend',97),(101,'recommend',103),(101,'recommend',108),(101,'recommend',112),(101,'recommend',113),(101,'recommend',114),(102,'depend',64),(102,'recommend',88),(103,'depend',91),(103,'recommend',86),(103,'recommend',88),(103,'recommend',92),(103,'recommend',94),(103,'recommend',96),(103,'recommend',97),(103,'recommend',101),(103,'recommend',108),(103,'recommend',112),(103,'recommend',113),(103,'recommend',114),(104,'depend',64),(105,'depend',64),(106,'depend',64),(107,'depend',64),(108,'depend',91),(108,'recommend',86),(108,'recommend',88),(108,'recommend',92),(108,'recommend',94),(108,'recommend',96),(108,'recommend',97),(108,'recommend',101),(108,'recommend',103),(108,'recommend',112),(108,'recommend',113),(108,'recommend',114),(109,'depend',64),(109,'recommend',88),(110,'depend',64),(110,'recommend',88),(111,'depend',218),(111,'recommend',238),(112,'depend',91),(112,'recommend',86),(112,'recommend',88),(112,'recommend',92),(112,'recommend',94),(112,'recommend',96),(112,'recommend',97),(112,'recommend',101),(112,'recommend',103),(112,'recommend',108),(112,'recommend',113),(112,'recommend',114),(113,'depend',91),(113,'recommend',86),(113,'recommend',88),(113,'recommend',92),(113,'recommend',94),(113,'recommend',96),(113,'recommend',97),(113,'recommend',101),(113,'recommend',103),(113,'recommend',108),(113,'recommend',112),(113,'recommend',114),(114,'depend',91),(114,'recommend',86),(114,'recommend',88),(114,'recommend',92),(114,'recommend',94),(114,'recommend',96),(114,'recommend',97),(114,'recommend',101),(114,'recommend',103),(114,'recommend',108),(114,'recommend',112),(114,'recommend',113),(115,'depend',64),(115,'recommend',88),(116,'depend',64),(116,'depend',117),(117,'depend',64),(118,'depend',91),(118,'recommend',119),(119,'depend',64),(119,'recommend',118),(120,'depend',91),(121,'recommend',122),(121,'recommend',123),(121,'recommend',127),(121,'recommend',129),(121,'recommend',131),(121,'recommend',132),(121,'recommend',134),(121,'recommend',136),(121,'recommend',138),(121,'recommend',141),(122,'depend',65),(122,'recommend',121),(123,'depend',126),(123,'recommend',121),(123,'recommend',127),(123,'recommend',129),(123,'recommend',131),(123,'recommend',132),(123,'recommend',134),(123,'recommend',136),(123,'recommend',138),(123,'recommend',141),(123,'recommend',142),(124,'depend',65),(125,'depend',126),(125,'recommend',121),(125,'recommend',123),(127,'depend',126),(127,'recommend',121),(127,'recommend',123),(127,'recommend',129),(127,'recommend',131),(127,'recommend',132),(127,'recommend',134),(127,'recommend',136),(127,'recommend',138),(127,'recommend',141),(128,'depend',126),(128,'recommend',130),(129,'depend',126),(129,'recommend',121),(129,'recommend',123),(129,'recommend',127),(129,'recommend',131),(129,'recommend',132),(129,'recommend',134),(129,'recommend',136),(129,'recommend',138),(129,'recommend',141),(130,'depend',65),(130,'recommend',128),(131,'depend',126),(131,'recommend',121),(131,'recommend',123),(131,'recommend',127),(131,'recommend',129),(131,'recommend',132),(131,'recommend',134),(131,'recommend',136),(131,'recommend',138),(131,'recommend',141),(132,'depend',126),(132,'recommend',121),(132,'recommend',123),(132,'recommend',127),(132,'recommend',129),(132,'recommend',131),(132,'recommend',133),(132,'recommend',134),(132,'recommend',136),(132,'recommend',138),(132,'recommend',141),(133,'depend',65),(133,'recommend',132),(134,'depend',126),(134,'recommend',121),(134,'recommend',123),(134,'recommend',127),(134,'recommend',129),(134,'recommend',131),(134,'recommend',132),(134,'recommend',135),(134,'recommend',136),(134,'recommend',138),(134,'recommend',141),(135,'depend',65),(135,'recommend',134),(136,'depend',126),(136,'recommend',121),(136,'recommend',123),(136,'recommend',127),(136,'recommend',129),(136,'recommend',131),(136,'recommend',132),(136,'recommend',134),(136,'recommend',138),(136,'recommend',141),(137,'depend',65),(138,'depend',126),(138,'recommend',121),(138,'recommend',123),(138,'recommend',127),(138,'recommend',129),(138,'recommend',131),(138,'recommend',132),(138,'recommend',134),(138,'recommend',136),(138,'recommend',140),(138,'recommend',141),(139,'depend',65),(139,'recommend',123),(140,'depend',65),(140,'recommend',123),(141,'depend',126),(141,'recommend',121),(141,'recommend',123),(141,'recommend',127),(141,'recommend',129),(141,'recommend',131),(141,'recommend',132),(141,'recommend',134),(141,'recommend',136),(141,'recommend',138),(142,'depend',65),(142,'recommend',123),(143,'depend',65),(143,'depend',144),(144,'depend',65),(145,'depend',64),(145,'recommend',146),(145,'recommend',147),(145,'recommend',149),(146,'depend',145),(146,'recommend',147),(146,'recommend',150),(146,'recommend',153),(146,'recommend',157),(146,'recommend',158),(146,'recommend',159),(146,'recommend',160),(147,'depend',149),(147,'recommend',146),(147,'recommend',150),(147,'recommend',151),(147,'recommend',153),(147,'recommend',154),(147,'recommend',156),(147,'recommend',157),(147,'recommend',158),(147,'recommend',159),(147,'recommend',160),(148,'depend',149),(148,'recommend',146),(148,'recommend',147),(149,'depend',145),(149,'recommend',146),(149,'recommend',147),(150,'depend',149),(150,'recommend',146),(150,'recommend',147),(150,'recommend',151),(150,'recommend',153),(150,'recommend',154),(150,'recommend',157),(150,'recommend',158),(150,'recommend',159),(150,'recommend',160),(151,'depend',149),(151,'recommend',146),(151,'recommend',147),(151,'recommend',150),(151,'recommend',152),(151,'recommend',153),(151,'recommend',154),(151,'recommend',157),(151,'recommend',158),(151,'recommend',159),(151,'recommend',160),(152,'depend',145),(152,'recommend',151),(153,'depend',149),(153,'recommend',146),(153,'recommend',147),(153,'recommend',150),(153,'recommend',151),(153,'recommend',154),(153,'recommend',157),(153,'recommend',158),(153,'recommend',159),(153,'recommend',160),(154,'depend',149),(154,'recommend',146),(154,'recommend',147),(154,'recommend',150),(154,'recommend',151),(154,'recommend',153),(154,'recommend',155),(154,'recommend',157),(154,'recommend',158),(154,'recommend',159),(154,'recommend',160),(155,'depend',149),(155,'recommend',154),(156,'depend',145),(156,'recommend',147),(157,'depend',149),(157,'recommend',146),(157,'recommend',147),(157,'recommend',150),(157,'recommend',151),(157,'recommend',153),(157,'recommend',154),(157,'recommend',158),(157,'recommend',159),(157,'recommend',160),(158,'depend',149),(158,'recommend',146),(158,'recommend',147),(158,'recommend',150),(158,'recommend',151),(158,'recommend',153),(158,'recommend',154),(158,'recommend',157),(158,'recommend',159),(158,'recommend',160),(159,'depend',149),(159,'recommend',146),(159,'recommend',147),(159,'recommend',150),(159,'recommend',151),(159,'recommend',153),(159,'recommend',154),(159,'recommend',157),(159,'recommend',158),(159,'recommend',160),(160,'depend',149),(160,'recommend',146),(160,'recommend',147),(160,'recommend',150),(160,'recommend',151),(160,'recommend',153),(160,'recommend',154),(160,'recommend',157),(160,'recommend',158),(160,'recommend',159),(161,'depend',145),(161,'recommend',147),(162,'depend',64),(162,'recommend',166),(163,'depend',162),(163,'recommend',164),(163,'recommend',168),(163,'recommend',169),(163,'recommend',171),(163,'recommend',172),(163,'recommend',174),(163,'recommend',175),(164,'depend',166),(164,'recommend',163),(164,'recommend',168),(164,'recommend',169),(164,'recommend',171),(164,'recommend',172),(164,'recommend',174),(164,'recommend',175),(165,'depend',166),(165,'recommend',163),(165,'recommend',164),(166,'depend',162),(166,'recommend',71),(167,'depend',166),(168,'depend',166),(168,'recommend',163),(168,'recommend',164),(168,'recommend',169),(168,'recommend',171),(168,'recommend',172),(168,'recommend',174),(168,'recommend',175),(169,'depend',166),(169,'recommend',163),(169,'recommend',164),(169,'recommend',168),(169,'recommend',170),(169,'recommend',171),(169,'recommend',172),(169,'recommend',174),(169,'recommend',175),(170,'depend',166),(170,'recommend',169),(171,'depend',166),(171,'recommend',163),(171,'recommend',164),(171,'recommend',168),(171,'recommend',169),(171,'recommend',172),(171,'recommend',174),(171,'recommend',175),(172,'depend',166),(172,'recommend',163),(172,'recommend',164),(172,'recommend',168),(172,'recommend',169),(172,'recommend',171),(172,'recommend',173),(172,'recommend',174),(172,'recommend',175),(173,'depend',166),(173,'recommend',172),(174,'depend',166),(174,'recommend',163),(174,'recommend',164),(174,'recommend',168),(174,'recommend',169),(174,'recommend',171),(174,'recommend',172),(174,'recommend',175),(175,'depend',166),(175,'recommend',163),(175,'recommend',164),(175,'recommend',168),(175,'recommend',169),(175,'recommend',171),(175,'recommend',172),(176,'recommend',177),(176,'recommend',178),(177,'depend',176),(177,'recommend',176),(177,'recommend',178),(177,'recommend',179),(177,'recommend',180),(177,'recommend',193),(177,'recommend',195),(177,'recommend',200),(178,'depend',176),(178,'recommend',177),(178,'recommend',195),(178,'recommend',200),(179,'depend',177),(179,'recommend',180),(179,'recommend',182),(179,'recommend',189),(179,'recommend',190),(179,'recommend',191),(179,'recommend',192),(179,'recommend',193),(179,'recommend',196),(179,'recommend',199),(179,'recommend',209),(180,'depend',177),(180,'recommend',179),(180,'recommend',181),(180,'recommend',189),(180,'recommend',190),(180,'recommend',191),(180,'recommend',192),(180,'recommend',193),(180,'recommend',199),(181,'depend',177),(181,'recommend',180),(182,'depend',176),(182,'recommend',179),(182,'recommend',180),(182,'recommend',183),(183,'depend',182),(183,'recommend',184),(183,'recommend',186),(183,'recommend',187),(183,'recommend',188),(184,'depend',182),(184,'recommend',183),(184,'recommend',186),(184,'recommend',187),(184,'recommend',188),(185,'depend',209),(185,'recommend',210),(186,'depend',182),(186,'recommend',183),(186,'recommend',184),(186,'recommend',187),(186,'recommend',188),(187,'depend',182),(187,'recommend',183),(187,'recommend',184),(187,'recommend',186),(187,'recommend',188),(188,'depend',182),(188,'recommend',183),(188,'recommend',184),(188,'recommend',186),(188,'recommend',187),(189,'depend',177),(189,'recommend',179),(189,'recommend',180),(189,'recommend',181),(189,'recommend',190),(189,'recommend',191),(189,'recommend',192),(190,'depend',177),(190,'recommend',179),(190,'recommend',180),(190,'recommend',181),(190,'recommend',189),(190,'recommend',191),(190,'recommend',192),(191,'depend',177),(191,'recommend',179),(191,'recommend',180),(191,'recommend',181),(191,'recommend',189),(191,'recommend',190),(191,'recommend',192),(192,'depend',177),(192,'recommend',179),(192,'recommend',180),(192,'recommend',181),(192,'recommend',189),(192,'recommend',190),(192,'recommend',191),(193,'depend',177),(193,'recommend',179),(193,'recommend',180),(194,'depend',177),(194,'recommend',179),(194,'recommend',180),(195,'depend',176),(195,'recommend',179),(195,'recommend',180),(195,'recommend',182),(195,'recommend',199),(195,'recommend',209),(195,'recommend',1022),(196,'depend',176),(196,'recommend',195),(196,'recommend',197),(196,'recommend',198),(197,'depend',196),(197,'recommend',198),(198,'depend',196),(198,'recommend',197),(199,'depend',177),(199,'recommend',179),(199,'recommend',180),(200,'depend',176),(200,'recommend',177),(200,'recommend',195),(201,'depend',176),(203,'depend',176),(203,'recommend',204),(203,'recommend',205),(203,'recommend',206),(204,'depend',176),(204,'recommend',205),(204,'recommend',206),(205,'depend',176),(205,'recommend',204),(205,'recommend',206),(206,'depend',176),(206,'recommend',205),(207,'depend',176),(207,'recommend',228),(208,'depend',177),(209,'recommend',185),(209,'recommend',210),(210,'depend',209),(210,'recommend',185),(212,'depend',177),(212,'recommend',41),(214,'depend',176),(214,'recommend',215),(214,'recommend',216),(215,'depend',214),(215,'recommend',216),(216,'depend',214),(216,'recommend',215),(217,'depend',214),(218,'depend',176),(218,'recommend',220),(219,'depend',176),(219,'recommend',218),(219,'recommend',220),(219,'recommend',390),(220,'depend',218),(221,'depend',218),(221,'recommend',111),(221,'recommend',222),(221,'recommend',223),(221,'recommend',225),(222,'depend',218),(222,'recommend',111),(222,'recommend',221),(222,'recommend',223),(222,'recommend',225),(223,'depend',218),(223,'recommend',111),(223,'recommend',221),(223,'recommend',222),(223,'recommend',224),(223,'recommend',225),(224,'depend',218),(224,'recommend',223),(225,'depend',218),(225,'recommend',111),(225,'recommend',221),(225,'recommend',222),(225,'recommend',223),(225,'recommend',224),(225,'recommend',1492),(225,'recommend',1497),(226,'recommend',227),(226,'recommend',256),(226,'recommend',269),(226,'recommend',280),(227,'recommend',226),(227,'recommend',256),(227,'recommend',269),(227,'recommend',280),(228,'depend',269),(228,'recommend',229),(228,'recommend',232),(228,'recommend',233),(228,'recommend',234),(228,'recommend',235),(228,'recommend',236),(228,'recommend',257),(229,'depend',269),(229,'recommend',228),(229,'recommend',230),(229,'recommend',232),(229,'recommend',233),(229,'recommend',234),(229,'recommend',235),(229,'recommend',236),(229,'recommend',257),(230,'depend',269),(230,'recommend',229),(231,'depend',269),(231,'recommend',229),(232,'depend',269),(232,'recommend',228),(232,'recommend',229),(232,'recommend',233),(232,'recommend',234),(232,'recommend',235),(232,'recommend',236),(233,'depend',269),(233,'recommend',228),(233,'recommend',229),(233,'recommend',232),(233,'recommend',234),(233,'recommend',235),(233,'recommend',236),(234,'depend',269),(234,'recommend',228),(234,'recommend',229),(234,'recommend',232),(234,'recommend',233),(234,'recommend',235),(234,'recommend',236),(235,'depend',269),(235,'recommend',228),(235,'recommend',229),(235,'recommend',232),(235,'recommend',233),(235,'recommend',234),(235,'recommend',236),(236,'depend',269),(236,'recommend',228),(236,'recommend',229),(236,'recommend',232),(236,'recommend',233),(236,'recommend',234),(236,'recommend',235),(237,'depend',269),(237,'recommend',228),(237,'recommend',229),(238,'recommend',343),(238,'recommend',358),(238,'recommend',364),(239,'recommend',266),(239,'recommend',282),(239,'recommend',285),(239,'recommend',290),(240,'depend',238),(240,'recommend',343),(240,'recommend',346),(241,'depend',238),(241,'recommend',343),(241,'recommend',346),(242,'depend',238),(242,'recommend',343),(242,'recommend',346),(243,'recommend',260),(243,'recommend',261),(243,'recommend',271),(243,'recommend',272),(243,'recommend',276),(243,'recommend',281),(244,'recommend',370),(244,'recommend',371),(244,'recommend',373),(244,'recommend',374),(244,'recommend',375),(244,'recommend',377),(244,'recommend',378),(245,'recommend',247),(245,'recommend',248),(246,'recommend',245),(246,'recommend',247),(246,'recommend',248),(247,'recommend',245),(247,'recommend',248),(248,'recommend',245),(248,'recommend',247),(249,'recommend',250),(249,'recommend',253),(250,'depend',249),(250,'recommend',253),(251,'recommend',252),(252,'depend',251),(253,'depend',249),(253,'recommend',250),(255,'recommend',258),(255,'recommend',259),(256,'recommend',226),(256,'recommend',227),(256,'recommend',269),(256,'recommend',280),(257,'depend',269),(257,'recommend',228),(257,'recommend',229),(258,'depend',255),(258,'recommend',259),(259,'depend',255),(259,'recommend',258),(260,'depend',243),(260,'recommend',261),(260,'recommend',271),(260,'recommend',272),(260,'recommend',276),(260,'recommend',281),(261,'depend',243),(261,'recommend',260),(261,'recommend',271),(261,'recommend',272),(261,'recommend',276),(261,'recommend',281),(262,'depend',243),(262,'recommend',261),(263,'depend',269),(263,'recommend',226),(263,'recommend',227),(263,'recommend',256),(263,'recommend',269),(263,'recommend',280),(264,'depend',277),(264,'recommend',277),(264,'recommend',279),(265,'depend',277),(266,'recommend',239),(266,'recommend',267),(266,'recommend',268),(266,'recommend',282),(266,'recommend',285),(266,'recommend',290),(267,'depend',266),(267,'recommend',268),(268,'depend',266),(268,'recommend',267),(269,'recommend',226),(269,'recommend',227),(269,'recommend',228),(269,'recommend',229),(269,'recommend',256),(269,'recommend',263),(269,'recommend',280),(270,'depend',269),(271,'depend',243),(271,'recommend',260),(271,'recommend',261),(271,'recommend',272),(271,'recommend',276),(271,'recommend',281),(272,'depend',243),(272,'recommend',260),(272,'recommend',261),(272,'recommend',271),(272,'recommend',276),(272,'recommend',281),(273,'recommend',274),(273,'recommend',275),(274,'depend',273),(274,'recommend',275),(275,'depend',273),(275,'recommend',274),(276,'depend',243),(276,'recommend',260),(276,'recommend',261),(276,'recommend',271),(276,'recommend',272),(276,'recommend',281),(277,'recommend',279),(278,'depend',277),(278,'recommend',277),(278,'recommend',279),(279,'depend',277),(280,'recommend',226),(280,'recommend',227),(280,'recommend',256),(280,'recommend',269),(281,'depend',243),(281,'recommend',260),(281,'recommend',261),(281,'recommend',271),(281,'recommend',272),(281,'recommend',276),(282,'recommend',239),(282,'recommend',266),(282,'recommend',285),(282,'recommend',290),(285,'recommend',239),(285,'recommend',266),(285,'recommend',282),(285,'recommend',286),(285,'recommend',290),(286,'depend',285),(287,'depend',289),(287,'depend',290),(288,'depend',289),(288,'depend',290),(289,'depend',290),(289,'recommend',287),(289,'recommend',288),(290,'recommend',239),(290,'recommend',266),(290,'recommend',282),(290,'recommend',285),(290,'recommend',291),(290,'recommend',292),(291,'depend',290),(292,'depend',290),(293,'recommend',294),(294,'depend',293),(294,'recommend',295),(294,'recommend',296),(294,'recommend',298),(294,'recommend',328),(295,'depend',293),(295,'recommend',294),(295,'recommend',296),(295,'recommend',298),(295,'recommend',328),(296,'depend',293),(296,'recommend',294),(296,'recommend',295),(296,'recommend',328),(297,'depend',293),(298,'depend',293),(298,'recommend',294),(298,'recommend',295),(299,'depend',301),(299,'recommend',300),(299,'recommend',302),(299,'recommend',329),(299,'recommend',330),(300,'depend',301),(300,'recommend',299),(300,'recommend',302),(300,'recommend',329),(300,'recommend',330),(301,'recommend',299),(301,'recommend',300),(301,'recommend',302),(301,'recommend',329),(301,'recommend',330),(302,'depend',301),(302,'recommend',299),(302,'recommend',300),(302,'recommend',329),(302,'recommend',330),(303,'depend',301),(303,'recommend',299),(303,'recommend',300),(304,'depend',301),(304,'recommend',305),(304,'recommend',306),(304,'recommend',308),(305,'depend',301),(305,'recommend',304),(305,'recommend',306),(305,'recommend',308),(306,'depend',301),(306,'recommend',304),(306,'recommend',305),(306,'recommend',308),(307,'depend',301),(307,'recommend',309),(307,'recommend',310),(307,'recommend',311),(307,'recommend',331),(307,'recommend',332),(308,'depend',301),(308,'recommend',304),(308,'recommend',305),(308,'recommend',306),(309,'depend',301),(309,'recommend',307),(309,'recommend',310),(309,'recommend',311),(309,'recommend',331),(309,'recommend',332),(310,'depend',301),(310,'recommend',307),(310,'recommend',309),(310,'recommend',311),(310,'recommend',331),(310,'recommend',332),(311,'depend',301),(311,'recommend',307),(311,'recommend',309),(311,'recommend',310),(311,'recommend',331),(311,'recommend',332),(312,'depend',301),(312,'recommend',313),(312,'recommend',314),(312,'recommend',315),(312,'recommend',316),(312,'recommend',326),(312,'recommend',333),(312,'recommend',334),(312,'recommend',335),(313,'depend',301),(313,'recommend',312),(313,'recommend',314),(313,'recommend',315),(313,'recommend',316),(313,'recommend',326),(313,'recommend',333),(313,'recommend',334),(313,'recommend',335),(314,'depend',301),(314,'recommend',312),(314,'recommend',313),(314,'recommend',315),(314,'recommend',316),(314,'recommend',326),(314,'recommend',333),(314,'recommend',334),(314,'recommend',335),(315,'depend',301),(315,'recommend',312),(315,'recommend',313),(315,'recommend',314),(315,'recommend',316),(315,'recommend',326),(315,'recommend',333),(315,'recommend',334),(315,'recommend',335),(316,'depend',301),(316,'recommend',312),(316,'recommend',313),(316,'recommend',314),(316,'recommend',315),(316,'recommend',326),(316,'recommend',333),(316,'recommend',334),(316,'recommend',335),(317,'depend',301),(317,'recommend',318),(317,'recommend',319),(317,'recommend',320),(317,'recommend',321),(317,'recommend',323),(317,'recommend',324),(317,'recommend',327),(317,'recommend',336),(317,'recommend',337),(317,'recommend',338),(318,'depend',301),(318,'recommend',317),(318,'recommend',319),(318,'recommend',320),(318,'recommend',321),(318,'recommend',323),(318,'recommend',324),(318,'recommend',336),(318,'recommend',337),(318,'recommend',338),(319,'depend',301),(319,'recommend',317),(319,'recommend',318),(319,'recommend',320),(319,'recommend',321),(319,'recommend',323),(319,'recommend',324),(319,'recommend',336),(319,'recommend',337),(319,'recommend',338),(320,'depend',301),(320,'recommend',317),(320,'recommend',318),(320,'recommend',319),(320,'recommend',321),(320,'recommend',323),(320,'recommend',324),(320,'recommend',336),(320,'recommend',337),(320,'recommend',338),(321,'depend',301),(321,'recommend',317),(321,'recommend',318),(321,'recommend',319),(321,'recommend',320),(321,'recommend',323),(321,'recommend',324),(321,'recommend',336),(321,'recommend',337),(321,'recommend',338),(322,'depend',301),(322,'recommend',317),(322,'recommend',318),(322,'recommend',319),(322,'recommend',320),(322,'recommend',321),(322,'recommend',323),(322,'recommend',324),(322,'recommend',336),(322,'recommend',337),(322,'recommend',338),(323,'depend',301),(323,'recommend',317),(323,'recommend',318),(323,'recommend',319),(323,'recommend',320),(323,'recommend',321),(323,'recommend',324),(323,'recommend',336),(323,'recommend',337),(323,'recommend',338),(324,'depend',301),(324,'recommend',317),(324,'recommend',318),(324,'recommend',319),(324,'recommend',320),(324,'recommend',321),(324,'recommend',323),(324,'recommend',336),(324,'recommend',337),(324,'recommend',338),(325,'recommend',307),(325,'recommend',309),(325,'recommend',310),(325,'recommend',311),(325,'recommend',331),(325,'recommend',332),(326,'depend',301),(326,'recommend',312),(326,'recommend',313),(326,'recommend',314),(326,'recommend',315),(326,'recommend',316),(326,'recommend',333),(326,'recommend',334),(326,'recommend',335),(327,'depend',301),(327,'recommend',317),(328,'depend',293),(328,'recommend',294),(328,'recommend',295),(328,'recommend',296),(329,'depend',301),(329,'recommend',299),(329,'recommend',300),(329,'recommend',302),(329,'recommend',330),(330,'depend',301),(330,'recommend',299),(330,'recommend',300),(330,'recommend',302),(330,'recommend',329),(331,'depend',301),(331,'recommend',307),(331,'recommend',309),(331,'recommend',310),(331,'recommend',311),(331,'recommend',332),(332,'depend',301),(332,'recommend',307),(332,'recommend',309),(332,'recommend',310),(332,'recommend',311),(332,'recommend',331),(333,'depend',301),(333,'recommend',312),(333,'recommend',313),(333,'recommend',314),(333,'recommend',315),(333,'recommend',316),(333,'recommend',326),(333,'recommend',334),(333,'recommend',335),(334,'depend',301),(334,'recommend',312),(334,'recommend',313),(334,'recommend',314),(334,'recommend',315),(334,'recommend',316),(334,'recommend',326),(334,'recommend',333),(334,'recommend',335),(335,'depend',301),(335,'recommend',312),(335,'recommend',313),(335,'recommend',314),(335,'recommend',315),(335,'recommend',316),(335,'recommend',326),(335,'recommend',333),(335,'recommend',334),(336,'depend',301),(336,'recommend',317),(336,'recommend',318),(336,'recommend',319),(336,'recommend',320),(336,'recommend',321),(336,'recommend',323),(336,'recommend',324),(336,'recommend',337),(336,'recommend',338),(337,'depend',301),(337,'recommend',317),(337,'recommend',318),(337,'recommend',319),(337,'recommend',320),(337,'recommend',321),(337,'recommend',323),(337,'recommend',324),(337,'recommend',336),(337,'recommend',338),(338,'depend',301),(338,'recommend',317),(338,'recommend',318),(338,'recommend',319),(338,'recommend',320),(338,'recommend',321),(338,'recommend',323),(338,'recommend',324),(338,'recommend',336),(338,'recommend',337),(339,'depend',341),(339,'recommend',340),(340,'depend',341),(340,'recommend',339),(341,'depend',176),(341,'recommend',342),(342,'depend',341),(343,'depend',238),(343,'recommend',241),(343,'recommend',242),(343,'recommend',344),(343,'recommend',346),(343,'recommend',347),(343,'recommend',349),(343,'recommend',350),(343,'recommend',351),(343,'recommend',352),(343,'recommend',353),(343,'recommend',354),(343,'recommend',356),(344,'depend',238),(344,'recommend',343),(345,'depend',238),(345,'recommend',346),(346,'depend',238),(346,'recommend',343),(346,'recommend',345),(346,'recommend',347),(346,'recommend',349),(346,'recommend',350),(346,'recommend',351),(346,'recommend',352),(346,'recommend',353),(346,'recommend',354),(346,'recommend',356),(346,'recommend',360),(346,'recommend',365),(346,'recommend',369),(347,'depend',238),(347,'recommend',343),(347,'recommend',346),(347,'recommend',348),(347,'recommend',349),(347,'recommend',350),(347,'recommend',351),(347,'recommend',352),(347,'recommend',353),(347,'recommend',354),(347,'recommend',356),(348,'depend',238),(348,'recommend',347),(349,'depend',238),(349,'recommend',343),(349,'recommend',346),(349,'recommend',347),(349,'recommend',350),(349,'recommend',351),(349,'recommend',352),(349,'recommend',353),(349,'recommend',354),(349,'recommend',356),(350,'depend',238),(350,'recommend',343),(350,'recommend',346),(350,'recommend',347),(350,'recommend',349),(350,'recommend',351),(350,'recommend',352),(350,'recommend',353),(350,'recommend',354),(350,'recommend',356),(351,'depend',238),(351,'recommend',343),(351,'recommend',346),(351,'recommend',347),(351,'recommend',349),(351,'recommend',350),(351,'recommend',352),(351,'recommend',353),(351,'recommend',354),(351,'recommend',356),(352,'depend',238),(352,'recommend',343),(352,'recommend',346),(352,'recommend',347),(352,'recommend',349),(352,'recommend',350),(352,'recommend',351),(352,'recommend',353),(352,'recommend',354),(352,'recommend',356),(353,'depend',238),(353,'recommend',343),(353,'recommend',346),(353,'recommend',347),(353,'recommend',349),(353,'recommend',350),(353,'recommend',351),(353,'recommend',352),(353,'recommend',354),(353,'recommend',356),(353,'recommend',366),(354,'depend',238),(354,'recommend',343),(354,'recommend',346),(354,'recommend',347),(354,'recommend',349),(354,'recommend',350),(354,'recommend',351),(354,'recommend',352),(354,'recommend',353),(354,'recommend',355),(354,'recommend',356),(355,'depend',238),(355,'recommend',354),(355,'recommend',362),(355,'recommend',363),(356,'depend',238),(356,'recommend',343),(356,'recommend',346),(356,'recommend',347),(356,'recommend',349),(356,'recommend',350),(356,'recommend',351),(356,'recommend',352),(356,'recommend',353),(356,'recommend',354),(357,'depend',238),(357,'recommend',343),(357,'recommend',346),(358,'depend',238),(358,'recommend',343),(358,'recommend',346),(358,'recommend',347),(358,'recommend',349),(358,'recommend',350),(358,'recommend',351),(358,'recommend',352),(358,'recommend',353),(358,'recommend',354),(358,'recommend',356),(359,'depend',238),(360,'depend',238),(360,'recommend',346),(361,'depend',238),(361,'recommend',362),(361,'recommend',363),(362,'depend',238),(362,'depend',361),(362,'recommend',363),(363,'depend',238),(363,'depend',361),(363,'recommend',362),(364,'depend',238),(365,'depend',238),(365,'recommend',346),(366,'depend',238),(366,'recommend',353),(367,'depend',238),(367,'depend',368),(368,'depend',238),(368,'recommend',367),(369,'depend',238),(369,'recommend',346),(370,'depend',244),(370,'recommend',371),(370,'recommend',374),(370,'recommend',375),(370,'recommend',377),(370,'recommend',378),(371,'depend',244),(371,'recommend',370),(371,'recommend',374),(371,'recommend',375),(371,'recommend',377),(371,'recommend',378),(372,'depend',244),(372,'recommend',370),(372,'recommend',371),(373,'depend',244),(373,'recommend',370),(373,'recommend',371),(373,'recommend',374),(373,'recommend',375),(373,'recommend',377),(373,'recommend',378),(374,'depend',244),(374,'recommend',370),(374,'recommend',371),(374,'recommend',375),(374,'recommend',377),(374,'recommend',378),(375,'depend',244),(375,'recommend',370),(375,'recommend',371),(375,'recommend',374),(375,'recommend',376),(375,'recommend',377),(375,'recommend',378),(376,'depend',244),(376,'recommend',375),(377,'depend',244),(377,'recommend',370),(377,'recommend',371),(377,'recommend',374),(377,'recommend',375),(377,'recommend',378),(378,'depend',244),(378,'recommend',370),(378,'recommend',371),(378,'recommend',374),(378,'recommend',375),(378,'recommend',377),(378,'recommend',379),(379,'depend',244),(379,'recommend',378),(380,'depend',176),(380,'recommend',381),(381,'depend',380),(382,'depend',380),(382,'recommend',383),(382,'recommend',384),(382,'recommend',385),(382,'recommend',387),(382,'recommend',389),(382,'recommend',391),(383,'depend',380),(383,'recommend',382),(384,'depend',380),(384,'recommend',382),(384,'recommend',385),(384,'recommend',387),(384,'recommend',389),(384,'recommend',390),(384,'recommend',391),(385,'depend',380),(385,'recommend',382),(385,'recommend',384),(385,'recommend',387),(385,'recommend',389),(385,'recommend',390),(385,'recommend',391),(386,'depend',380),(386,'recommend',382),(386,'recommend',384),(386,'recommend',385),(386,'recommend',387),(386,'recommend',389),(386,'recommend',391),(387,'depend',380),(387,'recommend',382),(387,'recommend',384),(387,'recommend',385),(387,'recommend',388),(387,'recommend',389),(387,'recommend',390),(387,'recommend',391),(388,'depend',380),(388,'recommend',387),(388,'recommend',390),(389,'depend',380),(389,'recommend',382),(389,'recommend',384),(389,'recommend',385),(389,'recommend',387),(389,'recommend',388),(389,'recommend',390),(389,'recommend',391),(390,'depend',388),(390,'recommend',387),(390,'recommend',388),(390,'recommend',389),(391,'depend',380),(395,'depend',394),(395,'recommend',401),(395,'recommend',411),(396,'depend',401),(396,'recommend',397),(396,'recommend',399),(396,'recommend',402),(396,'recommend',403),(396,'recommend',405),(396,'recommend',409),(396,'recommend',410),(396,'recommend',413),(396,'recommend',415),(397,'recommend',396),(398,'recommend',402),(399,'depend',401),(399,'recommend',396),(399,'recommend',400),(399,'recommend',402),(399,'recommend',403),(399,'recommend',405),(399,'recommend',409),(399,'recommend',410),(399,'recommend',413),(399,'recommend',415),(400,'recommend',399),(402,'depend',401),(402,'recommend',396),(402,'recommend',398),(402,'recommend',399),(402,'recommend',403),(402,'recommend',405),(402,'recommend',409),(402,'recommend',410),(402,'recommend',413),(402,'recommend',415),(403,'depend',401),(403,'recommend',396),(403,'recommend',399),(403,'recommend',402),(403,'recommend',404),(403,'recommend',405),(403,'recommend',409),(403,'recommend',410),(403,'recommend',413),(403,'recommend',415),(404,'recommend',403),(405,'depend',401),(405,'recommend',396),(405,'recommend',399),(405,'recommend',402),(405,'recommend',403),(405,'recommend',406),(405,'recommend',409),(405,'recommend',410),(405,'recommend',413),(405,'recommend',415),(406,'recommend',405),(407,'recommend',410),(408,'recommend',409),(409,'depend',401),(409,'recommend',396),(409,'recommend',399),(409,'recommend',402),(409,'recommend',403),(409,'recommend',405),(409,'recommend',408),(409,'recommend',410),(409,'recommend',413),(409,'recommend',415),(410,'depend',401),(410,'recommend',396),(410,'recommend',399),(410,'recommend',402),(410,'recommend',403),(410,'recommend',405),(410,'recommend',407),(410,'recommend',409),(410,'recommend',413),(410,'recommend',415),(413,'depend',401),(413,'recommend',396),(413,'recommend',399),(413,'recommend',402),(413,'recommend',403),(413,'recommend',405),(413,'recommend',409),(413,'recommend',410),(413,'recommend',415),(414,'depend',401),(415,'depend',402),(416,'recommend',402),(417,'recommend',402),(418,'recommend',402),(419,'depend',420),(420,'depend',419),(421,'depend',394),(421,'recommend',422),(421,'recommend',423),(421,'recommend',427),(424,'depend',427),(424,'recommend',428),(424,'recommend',431),(424,'recommend',432),(424,'recommend',437),(424,'recommend',438),(424,'recommend',445),(424,'recommend',446),(424,'recommend',453),(425,'recommend',424),(426,'depend',427),(426,'recommend',424),(426,'recommend',428),(426,'recommend',431),(426,'recommend',432),(426,'recommend',437),(426,'recommend',438),(426,'recommend',445),(426,'recommend',446),(426,'recommend',453),(428,'depend',427),(428,'recommend',424),(428,'recommend',431),(428,'recommend',432),(428,'recommend',437),(428,'recommend',438),(428,'recommend',445),(428,'recommend',446),(428,'recommend',453),(429,'depend',427),(429,'recommend',434),(430,'recommend',1682),(431,'depend',427),(431,'recommend',424),(431,'recommend',428),(431,'recommend',432),(431,'recommend',437),(431,'recommend',438),(431,'recommend',445),(431,'recommend',446),(432,'depend',427),(432,'recommend',424),(432,'recommend',428),(432,'recommend',431),(432,'recommend',437),(432,'recommend',438),(432,'recommend',445),(432,'recommend',446),(434,'recommend',429),(435,'recommend',428),(436,'recommend',428),(437,'depend',427),(437,'recommend',424),(437,'recommend',428),(437,'recommend',438),(438,'depend',427),(438,'recommend',424),(438,'recommend',428),(438,'recommend',437),(440,'depend',427),(440,'recommend',441),(441,'recommend',440),(443,'recommend',496),(443,'recommend',1491),(444,'recommend',428),(445,'depend',427),(445,'recommend',424),(445,'recommend',428),(445,'recommend',431),(445,'recommend',432),(445,'recommend',446),(446,'depend',427),(446,'recommend',424),(446,'recommend',428),(446,'recommend',431),(446,'recommend',432),(446,'recommend',445),(447,'depend',427),(448,'depend',421),(449,'depend',421),(450,'depend',451),(451,'depend',450),(451,'recommend',1679),(452,'depend',451),(453,'depend',427),(453,'recommend',424),(453,'recommend',428),(453,'recommend',431),(453,'recommend',432),(453,'recommend',437),(453,'recommend',438),(453,'recommend',445),(453,'recommend',446),(454,'recommend',459),(454,'recommend',460),(454,'recommend',461),(454,'recommend',462),(454,'recommend',463),(455,'depend',394),(457,'recommend',458),(457,'recommend',471),(458,'depend',457),(459,'recommend',454),(459,'recommend',460),(459,'recommend',461),(459,'recommend',462),(459,'recommend',463),(460,'recommend',454),(460,'recommend',459),(460,'recommend',461),(460,'recommend',462),(460,'recommend',463),(461,'recommend',454),(461,'recommend',459),(461,'recommend',460),(461,'recommend',462),(461,'recommend',463),(462,'recommend',454),(462,'recommend',459),(462,'recommend',460),(462,'recommend',461),(462,'recommend',463),(463,'recommend',454),(463,'recommend',459),(463,'recommend',460),(463,'recommend',461),(463,'recommend',462),(465,'depend',457),(466,'depend',457),(466,'recommend',467),(467,'depend',457),(467,'recommend',466),(468,'depend',457),(468,'recommend',469),(469,'depend',457),(469,'recommend',468),(470,'depend',457),(470,'recommend',467),(471,'depend',457),(473,'depend',472),(474,'depend',472),(475,'depend',457),(475,'recommend',468),(476,'depend',1285),(476,'depend',1316),(476,'depend',1329),(476,'recommend',477),(476,'recommend',1330),(476,'recommend',1331),(476,'recommend',1332),(476,'recommend',1334),(477,'depend',1285),(477,'depend',1316),(477,'depend',1329),(477,'recommend',476),(477,'recommend',1330),(477,'recommend',1331),(477,'recommend',1332),(477,'recommend',1334),(479,'depend',394),(479,'depend',478),(480,'depend',479),(480,'recommend',482),(481,'depend',478),(482,'depend',479),(482,'depend',481),(482,'recommend',480),(483,'depend',479),(483,'depend',481),(484,'depend',481),(484,'recommend',485),(484,'recommend',486),(485,'depend',481),(485,'recommend',484),(486,'depend',481),(486,'recommend',485),(487,'depend',394),(487,'recommend',489),(488,'depend',489),(488,'recommend',491),(490,'depend',489),(491,'depend',489),(491,'recommend',488),(493,'depend',176),(493,'depend',850),(493,'recommend',494),(494,'depend',493),(494,'depend',850),(496,'recommend',497),(496,'recommend',498),(496,'recommend',500),(496,'recommend',501),(496,'recommend',504),(496,'recommend',1491),(497,'depend',496),(497,'recommend',498),(497,'recommend',501),(497,'recommend',504),(497,'recommend',1584),(498,'depend',500),(498,'recommend',497),(498,'recommend',1584),(499,'depend',500),(499,'recommend',497),(499,'recommend',498),(500,'depend',496),(500,'recommend',498),(500,'recommend',1491),(501,'depend',496),(501,'recommend',497),(501,'recommend',502),(501,'recommend',504),(502,'depend',496),(502,'recommend',501),(503,'depend',496),(503,'depend',504),(504,'depend',496),(504,'depend',503),(504,'depend',505),(505,'depend',504),(506,'depend',394),(506,'recommend',510),(507,'depend',506),(507,'recommend',508),(508,'depend',506),(508,'recommend',507),(509,'depend',506),(510,'depend',506),(511,'depend',506),(512,'depend',511),(512,'depend',513),(513,'depend',512),(514,'depend',394),(514,'recommend',523),(515,'depend',514),(515,'depend',523),(515,'recommend',516),(515,'recommend',518),(515,'recommend',519),(515,'recommend',520),(515,'recommend',521),(515,'recommend',522),(515,'recommend',530),(516,'depend',514),(516,'depend',523),(516,'recommend',515),(516,'recommend',518),(516,'recommend',519),(516,'recommend',520),(516,'recommend',521),(516,'recommend',522),(516,'recommend',530),(517,'depend',514),(517,'depend',523),(518,'depend',514),(518,'depend',523),(518,'recommend',515),(518,'recommend',516),(518,'recommend',519),(518,'recommend',520),(518,'recommend',521),(518,'recommend',522),(518,'recommend',530),(519,'depend',514),(519,'depend',523),(519,'recommend',515),(519,'recommend',516),(519,'recommend',518),(519,'recommend',520),(519,'recommend',521),(519,'recommend',522),(519,'recommend',530),(520,'depend',514),(520,'depend',523),(520,'recommend',515),(520,'recommend',516),(520,'recommend',518),(520,'recommend',519),(520,'recommend',521),(520,'recommend',522),(520,'recommend',530),(521,'depend',514),(521,'depend',523),(521,'recommend',515),(521,'recommend',516),(521,'recommend',518),(521,'recommend',519),(521,'recommend',520),(521,'recommend',522),(521,'recommend',530),(522,'depend',514),(522,'depend',523),(522,'recommend',515),(522,'recommend',516),(522,'recommend',518),(522,'recommend',519),(522,'recommend',520),(522,'recommend',521),(522,'recommend',530),(523,'depend',514),(524,'depend',514),(525,'depend',523),(526,'depend',514),(526,'depend',523),(526,'recommend',527),(527,'depend',525),(527,'recommend',526),(528,'depend',525),(529,'depend',525),(530,'depend',514),(530,'depend',523),(530,'recommend',515),(530,'recommend',516),(530,'recommend',518),(530,'recommend',519),(530,'recommend',520),(530,'recommend',521),(530,'recommend',522),(595,'depend',652),(595,'depend',656),(595,'recommend',626),(596,'depend',16),(596,'depend',598),(597,'depend',16),(598,'depend',16),(598,'recommend',596),(599,'depend',16),(600,'depend',16),(600,'depend',602),(601,'depend',16),(601,'depend',630),(601,'recommend',603),(602,'depend',16),(602,'recommend',600),(603,'depend',16),(603,'depend',630),(603,'recommend',601),(604,'depend',607),(604,'depend',652),(604,'depend',656),(604,'recommend',605),(604,'recommend',606),(604,'recommend',608),(605,'depend',604),(605,'depend',652),(605,'depend',656),(605,'recommend',606),(605,'recommend',607),(605,'recommend',608),(605,'recommend',733),(606,'depend',604),(606,'depend',652),(606,'depend',656),(606,'recommend',607),(606,'recommend',608),(606,'recommend',733),(607,'depend',604),(607,'depend',652),(607,'depend',656),(607,'recommend',606),(607,'recommend',608),(607,'recommend',733),(608,'depend',604),(608,'depend',652),(608,'depend',656),(608,'recommend',606),(608,'recommend',607),(608,'recommend',733),(609,'depend',652),(609,'depend',656),(610,'depend',609),(610,'depend',652),(610,'depend',656),(610,'recommend',611),(610,'recommend',612),(610,'recommend',613),(610,'recommend',615),(610,'recommend',616),(610,'recommend',617),(610,'recommend',618),(611,'depend',609),(611,'depend',652),(611,'depend',656),(611,'recommend',610),(611,'recommend',612),(611,'recommend',613),(611,'recommend',615),(611,'recommend',616),(611,'recommend',617),(611,'recommend',618),(612,'depend',609),(612,'depend',652),(612,'depend',656),(612,'recommend',610),(612,'recommend',611),(612,'recommend',613),(612,'recommend',615),(612,'recommend',616),(612,'recommend',617),(612,'recommend',618),(613,'depend',609),(613,'depend',652),(613,'depend',656),(613,'recommend',610),(613,'recommend',611),(613,'recommend',612),(613,'recommend',615),(613,'recommend',616),(613,'recommend',617),(613,'recommend',618),(614,'depend',609),(614,'depend',652),(614,'depend',656),(615,'depend',609),(615,'depend',652),(615,'depend',656),(615,'recommend',610),(615,'recommend',611),(615,'recommend',612),(615,'recommend',613),(615,'recommend',616),(615,'recommend',617),(615,'recommend',618),(616,'depend',609),(616,'depend',652),(616,'depend',656),(616,'recommend',610),(616,'recommend',611),(616,'recommend',612),(616,'recommend',613),(616,'recommend',615),(616,'recommend',617),(616,'recommend',618),(617,'depend',609),(617,'recommend',610),(617,'recommend',611),(617,'recommend',612),(617,'recommend',613),(617,'recommend',615),(617,'recommend',616),(617,'recommend',618),(618,'depend',609),(618,'depend',652),(618,'depend',656),(618,'recommend',610),(618,'recommend',611),(618,'recommend',612),(618,'recommend',613),(618,'recommend',615),(618,'recommend',616),(618,'recommend',617),(619,'depend',614),(619,'recommend',620),(619,'recommend',621),(619,'recommend',622),(619,'recommend',623),(620,'depend',614),(620,'recommend',619),(620,'recommend',621),(620,'recommend',622),(620,'recommend',623),(621,'depend',614),(621,'recommend',619),(621,'recommend',620),(621,'recommend',622),(621,'recommend',623),(622,'depend',614),(622,'recommend',619),(622,'recommend',620),(622,'recommend',621),(622,'recommend',623),(623,'depend',614),(623,'recommend',619),(623,'recommend',620),(623,'recommend',621),(623,'recommend',622),(624,'depend',595),(624,'depend',652),(624,'depend',656),(624,'recommend',625),(624,'recommend',627),(624,'recommend',628),(624,'recommend',629),(625,'depend',595),(625,'depend',652),(625,'depend',656),(625,'recommend',624),(626,'depend',595),(626,'depend',652),(626,'depend',656),(627,'depend',595),(627,'depend',626),(627,'depend',652),(627,'depend',656),(627,'recommend',624),(627,'recommend',628),(627,'recommend',629),(627,'recommend',636),(628,'depend',595),(628,'depend',626),(628,'depend',652),(628,'depend',656),(628,'recommend',624),(628,'recommend',627),(628,'recommend',629),(629,'depend',595),(629,'depend',626),(629,'depend',652),(629,'depend',656),(629,'recommend',624),(629,'recommend',627),(629,'recommend',628),(630,'depend',16),(630,'recommend',631),(630,'recommend',632),(630,'recommend',633),(630,'recommend',635),(630,'recommend',641),(630,'recommend',642),(630,'recommend',643),(630,'recommend',644),(630,'recommend',645),(630,'recommend',646),(630,'recommend',647),(630,'recommend',650),(630,'recommend',651),(631,'depend',16),(631,'depend',630),(631,'recommend',632),(631,'recommend',633),(631,'recommend',635),(631,'recommend',641),(631,'recommend',642),(631,'recommend',643),(631,'recommend',644),(631,'recommend',647),(631,'recommend',650),(631,'recommend',651),(632,'depend',16),(632,'depend',630),(632,'recommend',631),(632,'recommend',633),(632,'recommend',635),(632,'recommend',641),(632,'recommend',642),(632,'recommend',643),(632,'recommend',644),(632,'recommend',647),(632,'recommend',650),(632,'recommend',651),(633,'depend',16),(633,'depend',630),(633,'recommend',631),(633,'recommend',632),(633,'recommend',635),(633,'recommend',641),(633,'recommend',642),(633,'recommend',643),(633,'recommend',644),(633,'recommend',647),(633,'recommend',650),(633,'recommend',651),(635,'depend',16),(635,'depend',630),(635,'recommend',631),(635,'recommend',632),(635,'recommend',633),(635,'recommend',641),(635,'recommend',642),(635,'recommend',643),(635,'recommend',644),(635,'recommend',647),(635,'recommend',650),(635,'recommend',651),(636,'depend',595),(636,'depend',626),(636,'depend',652),(636,'depend',656),(636,'recommend',627),(637,'depend',652),(637,'depend',656),(639,'depend',595),(640,'depend',595),(640,'depend',648),(641,'depend',16),(641,'depend',630),(641,'recommend',631),(641,'recommend',632),(641,'recommend',633),(641,'recommend',635),(641,'recommend',642),(641,'recommend',643),(641,'recommend',644),(641,'recommend',647),(641,'recommend',650),(641,'recommend',651),(642,'depend',16),(642,'depend',630),(642,'recommend',631),(642,'recommend',632),(642,'recommend',633),(642,'recommend',635),(642,'recommend',641),(642,'recommend',643),(642,'recommend',644),(642,'recommend',647),(642,'recommend',650),(642,'recommend',651),(643,'depend',16),(643,'depend',630),(643,'recommend',631),(643,'recommend',632),(643,'recommend',633),(643,'recommend',635),(643,'recommend',641),(643,'recommend',642),(643,'recommend',644),(643,'recommend',647),(643,'recommend',650),(643,'recommend',651),(644,'depend',16),(644,'depend',630),(644,'recommend',631),(644,'recommend',632),(644,'recommend',633),(644,'recommend',635),(644,'recommend',641),(644,'recommend',642),(644,'recommend',643),(644,'recommend',647),(644,'recommend',650),(644,'recommend',651),(645,'depend',16),(645,'depend',630),(646,'depend',16),(646,'depend',630),(647,'depend',16),(647,'depend',630),(647,'recommend',631),(647,'recommend',632),(647,'recommend',633),(647,'recommend',635),(647,'recommend',641),(647,'recommend',642),(647,'recommend',643),(647,'recommend',644),(647,'recommend',650),(647,'recommend',651),(648,'depend',595),(648,'depend',640),(649,'depend',1162),(650,'depend',16),(650,'depend',630),(650,'recommend',631),(650,'recommend',632),(650,'recommend',633),(650,'recommend',635),(650,'recommend',641),(650,'recommend',642),(650,'recommend',643),(650,'recommend',644),(650,'recommend',647),(650,'recommend',651),(651,'depend',16),(651,'depend',630),(651,'recommend',631),(651,'recommend',632),(651,'recommend',633),(651,'recommend',635),(651,'recommend',641),(651,'recommend',642),(651,'recommend',643),(651,'recommend',644),(651,'recommend',647),(651,'recommend',650),(654,'depend',652),(655,'depend',652),(655,'depend',656),(659,'depend',652),(660,'depend',652),(661,'depend',652),(663,'recommend',664),(663,'recommend',665),(663,'recommend',667),(664,'recommend',663),(665,'recommend',663),(665,'recommend',667),(667,'recommend',663),(667,'recommend',665),(670,'depend',669),(670,'recommend',671),(670,'recommend',672),(670,'recommend',673),(670,'recommend',674),(670,'recommend',675),(670,'recommend',676),(670,'recommend',677),(670,'recommend',678),(671,'depend',669),(671,'recommend',670),(671,'recommend',672),(671,'recommend',673),(671,'recommend',674),(671,'recommend',675),(671,'recommend',676),(671,'recommend',677),(671,'recommend',678),(672,'depend',669),(672,'recommend',670),(672,'recommend',671),(672,'recommend',673),(672,'recommend',674),(672,'recommend',675),(672,'recommend',676),(672,'recommend',677),(672,'recommend',678),(673,'depend',669),(673,'recommend',670),(673,'recommend',671),(673,'recommend',672),(673,'recommend',674),(673,'recommend',675),(673,'recommend',676),(673,'recommend',677),(673,'recommend',678),(674,'depend',669),(674,'recommend',670),(674,'recommend',671),(674,'recommend',672),(674,'recommend',673),(674,'recommend',675),(674,'recommend',676),(674,'recommend',677),(674,'recommend',678),(675,'depend',669),(675,'recommend',670),(675,'recommend',671),(675,'recommend',672),(675,'recommend',673),(675,'recommend',674),(675,'recommend',676),(675,'recommend',677),(675,'recommend',678),(676,'depend',669),(676,'recommend',670),(676,'recommend',671),(676,'recommend',672),(676,'recommend',673),(676,'recommend',674),(676,'recommend',675),(676,'recommend',677),(676,'recommend',678),(677,'depend',669),(677,'recommend',670),(677,'recommend',671),(677,'recommend',672),(677,'recommend',673),(677,'recommend',674),(677,'recommend',675),(677,'recommend',676),(677,'recommend',678),(678,'depend',669),(678,'recommend',670),(678,'recommend',671),(678,'recommend',672),(678,'recommend',673),(678,'recommend',674),(678,'recommend',675),(678,'recommend',676),(678,'recommend',677),(680,'depend',652),(680,'depend',656),(681,'depend',652),(681,'depend',656),(682,'depend',652),(682,'depend',656),(683,'depend',652),(683,'depend',656),(684,'depend',652),(684,'depend',656),(685,'depend',652),(685,'depend',656),(687,'depend',652),(689,'depend',652),(689,'depend',656),(689,'depend',690),(690,'depend',652),(690,'depend',656),(691,'depend',652),(691,'depend',656),(691,'depend',690),(692,'depend',652),(692,'depend',656),(692,'depend',690),(693,'depend',652),(693,'depend',656),(694,'depend',652),(694,'depend',656),(695,'depend',652),(695,'depend',656),(696,'depend',652),(696,'depend',656),(697,'depend',652),(697,'depend',656),(697,'depend',690),(700,'depend',699),(701,'depend',699),(701,'recommend',702),(702,'depend',699),(702,'recommend',701),(704,'depend',703),(707,'depend',1150),(708,'depend',707),(708,'recommend',710),(709,'depend',707),(710,'depend',707),(710,'recommend',708),(711,'depend',707),(712,'depend',711),(713,'depend',711),(713,'recommend',712),(714,'depend',711),(716,'depend',715),(717,'depend',715),(718,'depend',719),(718,'depend',720),(719,'depend',718),(719,'depend',720),(720,'depend',718),(720,'depend',719),(721,'recommend',722),(721,'recommend',723),(722,'recommend',721),(722,'recommend',723),(723,'recommend',721),(723,'recommend',722),(725,'depend',724),(726,'depend',724),(726,'recommend',727),(727,'depend',724),(727,'recommend',726),(730,'depend',652),(731,'depend',735),(731,'recommend',734),(731,'recommend',736),(732,'depend',735),(732,'recommend',734),(732,'recommend',736),(734,'depend',735),(734,'recommend',736),(760,'recommend',759),(765,'depend',764),(766,'depend',764),(767,'depend',764),(768,'depend',764),(768,'recommend',770),(769,'depend',764),(770,'depend',768),(772,'depend',771),(773,'depend',771),(773,'recommend',774),(773,'recommend',775),(773,'recommend',776),(774,'depend',771),(774,'recommend',773),(774,'recommend',775),(774,'recommend',776),(775,'depend',771),(775,'recommend',773),(775,'recommend',774),(775,'recommend',776),(776,'depend',771),(776,'recommend',773),(776,'recommend',774),(776,'recommend',775),(777,'depend',771),(787,'recommend',798),(788,'depend',787),(788,'depend',798),(788,'recommend',789),(788,'recommend',791),(788,'recommend',792),(788,'recommend',793),(788,'recommend',794),(788,'recommend',795),(788,'recommend',796),(788,'recommend',797),(789,'depend',787),(789,'recommend',788),(790,'depend',787),(791,'depend',787),(791,'depend',798),(791,'recommend',788),(791,'recommend',792),(791,'recommend',793),(791,'recommend',794),(791,'recommend',795),(791,'recommend',796),(791,'recommend',797),(792,'depend',787),(792,'depend',798),(792,'recommend',788),(792,'recommend',791),(792,'recommend',793),(792,'recommend',794),(792,'recommend',795),(792,'recommend',796),(792,'recommend',797),(793,'depend',787),(793,'depend',798),(793,'recommend',788),(793,'recommend',791),(793,'recommend',792),(793,'recommend',794),(793,'recommend',795),(793,'recommend',796),(793,'recommend',797),(794,'depend',787),(794,'depend',798),(794,'recommend',788),(794,'recommend',791),(794,'recommend',792),(794,'recommend',793),(794,'recommend',795),(794,'recommend',796),(794,'recommend',797),(795,'depend',787),(795,'depend',798),(795,'recommend',788),(795,'recommend',791),(795,'recommend',792),(795,'recommend',793),(795,'recommend',794),(795,'recommend',796),(795,'recommend',797),(796,'depend',787),(796,'depend',798),(796,'recommend',788),(796,'recommend',791),(796,'recommend',792),(796,'recommend',793),(796,'recommend',794),(796,'recommend',795),(796,'recommend',797),(797,'depend',787),(797,'depend',798),(797,'recommend',788),(797,'recommend',791),(797,'recommend',792),(797,'recommend',793),(797,'recommend',794),(797,'recommend',795),(797,'recommend',796),(798,'depend',787),(799,'depend',787),(800,'depend',798),(800,'recommend',801),(801,'depend',787),(801,'recommend',800),(802,'depend',787),(802,'recommend',1507),(802,'recommend',1512),(803,'recommend',813),(804,'depend',803),(804,'depend',813),(804,'recommend',805),(804,'recommend',807),(804,'recommend',808),(804,'recommend',809),(804,'recommend',810),(804,'recommend',811),(804,'recommend',812),(804,'recommend',814),(805,'depend',803),(805,'depend',813),(805,'recommend',804),(805,'recommend',807),(805,'recommend',808),(805,'recommend',809),(805,'recommend',811),(805,'recommend',812),(805,'recommend',814),(806,'depend',803),(807,'depend',803),(807,'depend',813),(807,'recommend',804),(807,'recommend',805),(807,'recommend',808),(807,'recommend',809),(807,'recommend',811),(807,'recommend',812),(807,'recommend',814),(808,'depend',803),(808,'depend',813),(808,'recommend',804),(808,'recommend',805),(808,'recommend',807),(808,'recommend',809),(808,'recommend',811),(808,'recommend',812),(808,'recommend',814),(809,'depend',803),(809,'depend',813),(809,'recommend',804),(809,'recommend',805),(809,'recommend',807),(809,'recommend',808),(809,'recommend',811),(809,'recommend',812),(809,'recommend',814),(810,'depend',803),(810,'depend',813),(810,'recommend',804),(811,'depend',803),(811,'depend',813),(811,'recommend',804),(811,'recommend',805),(811,'recommend',807),(811,'recommend',808),(811,'recommend',809),(811,'recommend',812),(811,'recommend',814),(812,'depend',803),(812,'depend',813),(812,'recommend',804),(812,'recommend',805),(812,'recommend',807),(812,'recommend',808),(812,'recommend',809),(812,'recommend',811),(812,'recommend',814),(813,'depend',803),(814,'depend',803),(814,'depend',813),(814,'recommend',804),(814,'recommend',805),(814,'recommend',807),(814,'recommend',808),(814,'recommend',809),(814,'recommend',811),(814,'recommend',812),(815,'depend',813),(815,'recommend',816),(816,'depend',803),(816,'recommend',815),(817,'depend',803),(817,'depend',813),(817,'recommend',1522),(817,'recommend',1527),(818,'depend',803),(819,'depend',824),(819,'recommend',821),(820,'depend',824),(820,'recommend',819),(820,'recommend',821),(820,'recommend',823),(820,'recommend',825),(820,'recommend',826),(820,'recommend',827),(820,'recommend',828),(820,'recommend',829),(820,'recommend',830),(820,'recommend',831),(820,'recommend',832),(820,'recommend',833),(820,'recommend',834),(821,'depend',824),(821,'recommend',819),(821,'recommend',827),(821,'recommend',828),(821,'recommend',829),(821,'recommend',830),(822,'depend',824),(822,'recommend',819),(822,'recommend',821),(823,'depend',824),(823,'recommend',825),(823,'recommend',826),(824,'recommend',819),(824,'recommend',820),(824,'recommend',821),(825,'depend',824),(825,'recommend',823),(825,'recommend',826),(826,'depend',824),(826,'recommend',823),(826,'recommend',825),(827,'depend',824),(827,'depend',826),(827,'recommend',825),(827,'recommend',828),(827,'recommend',829),(827,'recommend',830),(827,'recommend',831),(827,'recommend',832),(827,'recommend',833),(828,'depend',824),(828,'depend',826),(828,'recommend',827),(828,'recommend',829),(828,'recommend',830),(829,'depend',824),(829,'depend',826),(829,'recommend',827),(829,'recommend',828),(829,'recommend',830),(830,'depend',824),(830,'recommend',826),(830,'recommend',827),(830,'recommend',828),(830,'recommend',829),(831,'depend',824),(831,'recommend',832),(831,'recommend',833),(832,'depend',824),(832,'recommend',831),(832,'recommend',833),(833,'depend',824),(833,'recommend',831),(833,'recommend',832),(834,'depend',824),(834,'recommend',1067),(835,'depend',176),(835,'depend',842),(835,'recommend',836),(836,'depend',842),(836,'recommend',835),(837,'depend',842),(837,'recommend',838),(838,'depend',842),(838,'recommend',837),(839,'depend',835),(839,'depend',842),(839,'recommend',840),(840,'depend',835),(840,'depend',842),(840,'recommend',839),(841,'depend',835),(841,'depend',842),(841,'recommend',837),(841,'recommend',839),(842,'depend',176),(843,'depend',176),(843,'depend',835),(843,'depend',842),(843,'recommend',839),(843,'recommend',844),(844,'depend',842),(844,'depend',843),(846,'depend',845),(846,'recommend',847),(846,'recommend',848),(847,'depend',845),(847,'recommend',846),(848,'depend',845),(848,'recommend',846),(848,'recommend',847),(849,'depend',845),(849,'recommend',846),(850,'depend',176),(851,'depend',850),(851,'recommend',850),(852,'recommend',861),(853,'depend',852),(853,'depend',861),(853,'recommend',854),(853,'recommend',856),(853,'recommend',857),(853,'recommend',858),(853,'recommend',859),(853,'recommend',860),(853,'recommend',862),(853,'recommend',863),(854,'depend',852),(854,'depend',861),(854,'recommend',853),(854,'recommend',856),(854,'recommend',857),(854,'recommend',858),(854,'recommend',859),(854,'recommend',860),(854,'recommend',862),(854,'recommend',864),(855,'depend',852),(856,'depend',852),(856,'depend',861),(856,'recommend',853),(856,'recommend',854),(856,'recommend',857),(856,'recommend',858),(856,'recommend',859),(856,'recommend',860),(856,'recommend',862),(856,'recommend',869),(857,'depend',852),(857,'depend',861),(857,'recommend',853),(857,'recommend',854),(857,'recommend',856),(857,'recommend',858),(857,'recommend',859),(857,'recommend',860),(857,'recommend',862),(857,'recommend',866),(858,'depend',852),(858,'depend',861),(858,'recommend',853),(858,'recommend',854),(858,'recommend',856),(858,'recommend',857),(858,'recommend',859),(858,'recommend',860),(858,'recommend',862),(858,'recommend',868),(859,'depend',852),(859,'depend',861),(859,'recommend',853),(859,'recommend',854),(859,'recommend',856),(859,'recommend',857),(859,'recommend',858),(859,'recommend',860),(859,'recommend',862),(859,'recommend',867),(860,'depend',852),(860,'depend',861),(860,'recommend',853),(860,'recommend',854),(860,'recommend',856),(860,'recommend',857),(860,'recommend',858),(860,'recommend',859),(860,'recommend',862),(862,'depend',852),(862,'depend',861),(862,'recommend',853),(862,'recommend',854),(862,'recommend',856),(862,'recommend',857),(862,'recommend',858),(862,'recommend',859),(862,'recommend',860),(862,'recommend',865),(863,'depend',852),(863,'recommend',853),(864,'depend',852),(864,'recommend',854),(865,'depend',852),(865,'recommend',862),(866,'depend',852),(866,'recommend',857),(867,'depend',852),(867,'recommend',859),(868,'depend',852),(868,'recommend',858),(869,'depend',852),(869,'recommend',856),(870,'depend',861),(870,'recommend',871),(871,'depend',852),(871,'recommend',870),(872,'depend',852),(872,'recommend',1537),(872,'recommend',1542),(873,'depend',852),(875,'depend',874),(875,'recommend',876),(875,'recommend',880),(875,'recommend',881),(875,'recommend',882),(876,'depend',874),(876,'recommend',875),(876,'recommend',878),(876,'recommend',880),(876,'recommend',881),(876,'recommend',882),(877,'depend',874),(877,'recommend',875),(878,'depend',874),(878,'recommend',876),(879,'depend',874),(879,'recommend',881),(880,'depend',883),(880,'recommend',875),(880,'recommend',876),(881,'depend',874),(881,'recommend',875),(881,'recommend',876),(881,'recommend',879),(881,'recommend',880),(881,'recommend',882),(882,'depend',874),(882,'recommend',881),(883,'depend',874),(885,'depend',884),(885,'recommend',886),(885,'recommend',887),(885,'recommend',889),(885,'recommend',890),(885,'recommend',891),(885,'recommend',892),(886,'depend',884),(886,'recommend',885),(886,'recommend',887),(886,'recommend',889),(886,'recommend',890),(886,'recommend',891),(886,'recommend',892),(887,'depend',884),(887,'recommend',885),(887,'recommend',886),(887,'recommend',889),(887,'recommend',890),(887,'recommend',891),(887,'recommend',892),(888,'depend',884),(889,'depend',884),(889,'recommend',885),(889,'recommend',886),(889,'recommend',887),(889,'recommend',890),(889,'recommend',891),(889,'recommend',892),(890,'depend',884),(890,'recommend',885),(890,'recommend',886),(890,'recommend',887),(890,'recommend',889),(890,'recommend',891),(890,'recommend',892),(891,'depend',884),(891,'recommend',885),(891,'recommend',886),(891,'recommend',887),(891,'recommend',889),(891,'recommend',890),(891,'recommend',892),(892,'depend',884),(892,'recommend',885),(892,'recommend',886),(892,'recommend',887),(892,'recommend',889),(892,'recommend',890),(892,'recommend',891),(893,'depend',884),(895,'depend',894),(895,'recommend',896),(895,'recommend',897),(895,'recommend',899),(896,'depend',894),(896,'recommend',895),(896,'recommend',898),(896,'recommend',899),(897,'depend',894),(897,'recommend',895),(898,'depend',894),(898,'recommend',896),(898,'recommend',897),(899,'depend',900),(899,'recommend',895),(900,'depend',894),(901,'depend',176),(901,'recommend',902),(901,'recommend',903),(901,'recommend',905),(902,'depend',901),(902,'recommend',903),(902,'recommend',905),(903,'depend',901),(903,'recommend',902),(903,'recommend',905),(904,'depend',901),(904,'recommend',902),(904,'recommend',903),(904,'recommend',905),(905,'depend',901),(905,'recommend',902),(905,'recommend',903),(906,'depend',176),(906,'depend',901),(906,'recommend',907),(906,'recommend',908),(906,'recommend',910),(907,'depend',901),(907,'depend',906),(907,'recommend',908),(907,'recommend',910),(908,'depend',901),(908,'depend',906),(908,'recommend',907),(908,'recommend',910),(909,'depend',901),(909,'depend',906),(909,'recommend',907),(909,'recommend',908),(909,'recommend',910),(910,'depend',901),(910,'depend',906),(910,'recommend',907),(910,'recommend',908),(912,'depend',911),(912,'recommend',913),(912,'recommend',914),(912,'recommend',915),(912,'recommend',916),(913,'depend',911),(913,'recommend',912),(913,'recommend',914),(913,'recommend',915),(913,'recommend',916),(914,'depend',915),(914,'recommend',912),(915,'depend',911),(915,'recommend',912),(915,'recommend',913),(915,'recommend',914),(915,'recommend',916),(916,'depend',911),(916,'recommend',912),(916,'recommend',913),(916,'recommend',915),(918,'depend',917),(918,'recommend',919),(918,'recommend',920),(918,'recommend',921),(918,'recommend',922),(919,'depend',917),(919,'recommend',918),(919,'recommend',920),(919,'recommend',921),(919,'recommend',923),(920,'depend',921),(920,'recommend',918),(920,'recommend',919),(921,'depend',917),(921,'recommend',918),(921,'recommend',919),(921,'recommend',920),(921,'recommend',922),(921,'recommend',923),(922,'depend',917),(922,'recommend',918),(923,'depend',917),(923,'recommend',918),(926,'depend',925),(927,'depend',925),(928,'depend',925),(929,'depend',925),(930,'depend',925),(931,'depend',925),(932,'depend',925),(933,'depend',925),(934,'depend',925),(935,'depend',925),(936,'depend',925),(937,'depend',925),(938,'depend',925),(939,'depend',925),(940,'depend',925),(941,'depend',925),(942,'depend',925),(943,'depend',925),(944,'depend',925),(945,'depend',925),(946,'depend',925),(947,'depend',925),(948,'depend',925),(949,'depend',925),(950,'depend',925),(951,'depend',925),(952,'depend',925),(953,'depend',925),(954,'depend',925),(955,'depend',925),(956,'depend',925),(957,'depend',925),(958,'depend',925),(959,'depend',925),(960,'depend',925),(961,'depend',925),(962,'depend',925),(963,'depend',925),(964,'depend',925),(965,'depend',925),(966,'depend',925),(967,'depend',925),(968,'depend',925),(969,'depend',925),(970,'depend',925),(971,'depend',925),(972,'depend',925),(973,'depend',925),(974,'depend',925),(975,'depend',925),(976,'depend',925),(977,'depend',925),(978,'depend',925),(979,'depend',925),(980,'depend',925),(981,'depend',925),(982,'depend',925),(983,'depend',925),(984,'depend',925),(985,'depend',925),(986,'depend',925),(987,'depend',925),(988,'depend',925),(989,'depend',925),(990,'depend',925),(991,'depend',925),(992,'depend',925),(993,'depend',925),(994,'depend',925),(995,'depend',925),(996,'depend',925),(997,'depend',176),(997,'recommend',1000),(998,'recommend',999),(998,'recommend',1001),(998,'recommend',1002),(998,'recommend',1003),(998,'recommend',1004),(998,'recommend',1005),(998,'recommend',1006),(998,'recommend',1007),(999,'recommend',998),(999,'recommend',1001),(999,'recommend',1002),(999,'recommend',1003),(999,'recommend',1004),(999,'recommend',1005),(999,'recommend',1006),(999,'recommend',1007),(1000,'depend',997),(1001,'recommend',998),(1001,'recommend',999),(1001,'recommend',1002),(1001,'recommend',1003),(1001,'recommend',1004),(1001,'recommend',1005),(1001,'recommend',1006),(1001,'recommend',1007),(1002,'recommend',998),(1002,'recommend',999),(1002,'recommend',1001),(1002,'recommend',1003),(1002,'recommend',1005),(1003,'recommend',998),(1003,'recommend',999),(1003,'recommend',1001),(1003,'recommend',1002),(1003,'recommend',1004),(1004,'recommend',1003),(1005,'recommend',998),(1005,'recommend',999),(1005,'recommend',1001),(1005,'recommend',1006),(1006,'recommend',998),(1006,'recommend',999),(1006,'recommend',1001),(1006,'recommend',1002),(1006,'recommend',1004),(1007,'recommend',1006),(1008,'depend',176),(1008,'recommend',1009),(1008,'recommend',1010),(1008,'recommend',1012),(1009,'depend',1008),(1009,'recommend',1010),(1009,'recommend',1011),(1009,'recommend',1014),(1009,'recommend',1015),(1009,'recommend',1017),(1009,'recommend',1018),(1009,'recommend',1020),(1010,'depend',1008),(1010,'recommend',1009),(1010,'recommend',1011),(1010,'recommend',1014),(1010,'recommend',1015),(1010,'recommend',1017),(1010,'recommend',1018),(1010,'recommend',1020),(1011,'depend',1008),(1011,'recommend',1009),(1011,'recommend',1010),(1011,'recommend',1014),(1011,'recommend',1015),(1011,'recommend',1017),(1011,'recommend',1018),(1011,'recommend',1020),(1012,'depend',1008),(1012,'recommend',1009),(1012,'recommend',1010),(1013,'depend',1008),(1013,'depend',1012),(1014,'depend',1008),(1014,'recommend',1009),(1014,'recommend',1010),(1014,'recommend',1011),(1014,'recommend',1015),(1014,'recommend',1017),(1014,'recommend',1018),(1014,'recommend',1020),(1015,'depend',1008),(1015,'recommend',1009),(1015,'recommend',1010),(1015,'recommend',1011),(1015,'recommend',1014),(1015,'recommend',1016),(1015,'recommend',1017),(1015,'recommend',1018),(1015,'recommend',1020),(1016,'depend',1008),(1016,'recommend',1015),(1017,'depend',1008),(1017,'recommend',1009),(1017,'recommend',1010),(1017,'recommend',1011),(1017,'recommend',1014),(1017,'recommend',1015),(1017,'recommend',1018),(1017,'recommend',1020),(1018,'depend',1008),(1018,'recommend',1009),(1018,'recommend',1010),(1018,'recommend',1011),(1018,'recommend',1014),(1018,'recommend',1015),(1018,'recommend',1017),(1018,'recommend',1019),(1018,'recommend',1020),(1019,'depend',1008),(1019,'recommend',1018),(1020,'depend',1008),(1020,'recommend',1009),(1020,'recommend',1010),(1020,'recommend',1011),(1020,'recommend',1014),(1020,'recommend',1015),(1020,'recommend',1017),(1020,'recommend',1018),(1021,'depend',1008),(1022,'depend',176),(1022,'recommend',1028),(1023,'depend',1022),(1023,'recommend',1024),(1023,'recommend',1025),(1023,'recommend',1027),(1023,'recommend',1031),(1023,'recommend',1032),(1023,'recommend',1038),(1024,'depend',1022),(1024,'recommend',1023),(1025,'depend',1022),(1025,'recommend',1023),(1025,'recommend',1024),(1025,'recommend',1027),(1025,'recommend',1031),(1025,'recommend',1032),(1025,'recommend',1038),(1027,'depend',1022),(1027,'recommend',1023),(1027,'recommend',1024),(1027,'recommend',1025),(1027,'recommend',1031),(1027,'recommend',1032),(1027,'recommend',1038),(1028,'depend',1022),(1031,'depend',1022),(1031,'recommend',1023),(1031,'recommend',1024),(1031,'recommend',1025),(1031,'recommend',1027),(1031,'recommend',1032),(1031,'recommend',1038),(1032,'depend',1022),(1032,'recommend',1023),(1032,'recommend',1024),(1032,'recommend',1025),(1032,'recommend',1027),(1032,'recommend',1031),(1032,'recommend',1038),(1038,'depend',1022),(1038,'recommend',1023),(1038,'recommend',1024),(1038,'recommend',1025),(1038,'recommend',1027),(1038,'recommend',1031),(1038,'recommend',1032),(1039,'depend',66),(1039,'depend',67),(1039,'depend',68),(1039,'recommend',1040),(1039,'recommend',1041),(1039,'recommend',1042),(1039,'recommend',1043),(1039,'recommend',1044),(1039,'recommend',1046),(1040,'depend',1039),(1040,'recommend',1041),(1040,'recommend',1042),(1040,'recommend',1043),(1040,'recommend',1044),(1040,'recommend',1045),(1040,'recommend',1046),(1041,'depend',1039),(1041,'recommend',1040),(1041,'recommend',1042),(1041,'recommend',1043),(1041,'recommend',1044),(1041,'recommend',1045),(1041,'recommend',1046),(1042,'depend',1039),(1042,'recommend',1040),(1042,'recommend',1041),(1042,'recommend',1043),(1042,'recommend',1044),(1042,'recommend',1045),(1042,'recommend',1046),(1043,'depend',1039),(1043,'depend',1042),(1043,'recommend',1040),(1043,'recommend',1041),(1043,'recommend',1044),(1043,'recommend',1046),(1044,'depend',1039),(1044,'recommend',1040),(1044,'recommend',1041),(1045,'depend',78),(1045,'recommend',68),(1046,'depend',1039),(1046,'recommend',1040),(1046,'recommend',1041),(1046,'recommend',1042),(1046,'recommend',1043),(1046,'recommend',1044),(1046,'recommend',1045),(1047,'depend',1051),(1047,'recommend',1048),(1047,'recommend',1694),(1048,'depend',1051),(1048,'recommend',1047),(1049,'depend',1051),(1049,'recommend',1047),(1049,'recommend',1048),(1050,'recommend',1053),(1050,'recommend',1055),(1050,'recommend',1056),(1050,'recommend',1057),(1050,'recommend',1062),(1050,'recommend',1063),(1050,'recommend',1064),(1050,'recommend',1065),(1051,'recommend',1047),(1051,'recommend',1048),(1051,'recommend',1052),(1052,'depend',1051),(1052,'recommend',1047),(1052,'recommend',1048),(1053,'recommend',1050),(1053,'recommend',1055),(1053,'recommend',1056),(1053,'recommend',1057),(1053,'recommend',1062),(1053,'recommend',1063),(1053,'recommend',1064),(1053,'recommend',1065),(1054,'recommend',1066),(1054,'recommend',1067),(1054,'recommend',1068),(1055,'recommend',1050),(1055,'recommend',1053),(1055,'recommend',1056),(1055,'recommend',1057),(1055,'recommend',1062),(1055,'recommend',1063),(1055,'recommend',1064),(1055,'recommend',1065),(1056,'recommend',1050),(1056,'recommend',1053),(1056,'recommend',1055),(1056,'recommend',1057),(1056,'recommend',1062),(1056,'recommend',1063),(1056,'recommend',1064),(1056,'recommend',1065),(1057,'recommend',1050),(1057,'recommend',1053),(1057,'recommend',1055),(1057,'recommend',1056),(1057,'recommend',1062),(1057,'recommend',1063),(1057,'recommend',1064),(1057,'recommend',1065),(1058,'recommend',1061),(1060,'depend',1051),(1061,'recommend',1058),(1062,'recommend',1050),(1062,'recommend',1053),(1062,'recommend',1055),(1062,'recommend',1056),(1062,'recommend',1057),(1062,'recommend',1063),(1062,'recommend',1064),(1062,'recommend',1065),(1063,'recommend',1050),(1063,'recommend',1053),(1063,'recommend',1055),(1063,'recommend',1056),(1063,'recommend',1057),(1063,'recommend',1062),(1063,'recommend',1064),(1063,'recommend',1065),(1064,'recommend',1050),(1064,'recommend',1053),(1064,'recommend',1055),(1064,'recommend',1056),(1064,'recommend',1057),(1064,'recommend',1062),(1064,'recommend',1063),(1064,'recommend',1065),(1065,'recommend',1050),(1065,'recommend',1053),(1065,'recommend',1055),(1065,'recommend',1056),(1065,'recommend',1057),(1065,'recommend',1062),(1065,'recommend',1063),(1065,'recommend',1064),(1066,'depend',1054),(1066,'recommend',1067),(1066,'recommend',1068),(1067,'depend',1054),(1067,'recommend',834),(1067,'recommend',1066),(1067,'recommend',1068),(1067,'recommend',1070),(1067,'recommend',1071),(1068,'depend',1054),(1068,'recommend',1066),(1068,'recommend',1067),(1068,'recommend',1070),(1068,'recommend',1071),(1069,'depend',1054),(1069,'recommend',1066),(1069,'recommend',1067),(1069,'recommend',1068),(1069,'recommend',1070),(1069,'recommend',1071),(1070,'depend',1054),(1070,'recommend',1066),(1070,'recommend',1067),(1070,'recommend',1068),(1070,'recommend',1071),(1071,'depend',1054),(1071,'recommend',1066),(1071,'recommend',1067),(1071,'recommend',1068),(1071,'recommend',1070),(1072,'depend',1054),(1072,'recommend',1066),(1072,'recommend',1067),(1072,'recommend',1068),(1072,'recommend',1070),(1072,'recommend',1071),(1073,'recommend',1074),(1074,'recommend',1073),(1075,'depend',1082),(1075,'recommend',1076),(1075,'recommend',1086),(1075,'recommend',1087),(1076,'depend',1082),(1076,'recommend',1075),(1076,'recommend',1086),(1076,'recommend',1087),(1077,'depend',1082),(1078,'recommend',1079),(1078,'recommend',1080),(1079,'depend',1078),(1079,'recommend',1080),(1080,'depend',1078),(1080,'recommend',1079),(1081,'depend',1078),(1081,'recommend',1079),(1081,'recommend',1080),(1082,'recommend',1083),(1082,'recommend',1084),(1083,'depend',1082),(1083,'recommend',1084),(1084,'depend',1082),(1084,'recommend',1083),(1085,'depend',1082),(1085,'recommend',1083),(1085,'recommend',1084),(1086,'depend',1082),(1086,'recommend',1075),(1086,'recommend',1076),(1086,'recommend',1087),(1087,'depend',1082),(1087,'recommend',1075),(1087,'recommend',1076),(1087,'recommend',1086),(1089,'recommend',1090),(1089,'recommend',1091),(1089,'recommend',1092),(1090,'depend',1089),(1090,'recommend',1091),(1090,'recommend',1092),(1091,'depend',1089),(1091,'recommend',1090),(1091,'recommend',1092),(1092,'depend',1089),(1092,'recommend',1090),(1092,'recommend',1091),(1093,'depend',1089),(1093,'recommend',1095),(1093,'recommend',1112),(1093,'recommend',1131),(1094,'depend',1089),(1094,'recommend',1090),(1094,'recommend',1091),(1094,'recommend',1092),(1095,'depend',1089),(1095,'recommend',1093),(1095,'recommend',1112),(1095,'recommend',1131),(1096,'depend',1089),(1096,'recommend',1097),(1096,'recommend',1098),(1097,'depend',1089),(1097,'depend',1096),(1097,'recommend',1098),(1098,'depend',1089),(1098,'depend',1096),(1098,'recommend',1097),(1099,'depend',1089),(1099,'depend',1096),(1099,'recommend',1097),(1099,'recommend',1098),(1100,'depend',1089),(1100,'recommend',1101),(1100,'recommend',1102),(1100,'recommend',1104),(1101,'depend',1089),(1101,'depend',1100),(1101,'recommend',1102),(1101,'recommend',1104),(1102,'depend',1089),(1102,'depend',1100),(1102,'recommend',1101),(1102,'recommend',1104),(1103,'depend',1089),(1103,'depend',1100),(1103,'recommend',1101),(1103,'recommend',1102),(1103,'recommend',1104),(1104,'depend',1089),(1104,'depend',1100),(1104,'recommend',1101),(1104,'recommend',1102),(1105,'depend',1089),(1105,'recommend',1106),(1105,'recommend',1107),(1106,'depend',1089),(1106,'depend',1105),(1106,'recommend',1107),(1107,'depend',1089),(1107,'depend',1105),(1107,'recommend',1106),(1108,'depend',1089),(1108,'depend',1105),(1108,'recommend',1106),(1108,'recommend',1107),(1109,'depend',1089),(1109,'depend',1110),(1109,'recommend',1110),(1109,'recommend',1114),(1110,'depend',1089),(1110,'recommend',1109),(1110,'recommend',1114),(1111,'depend',1089),(1112,'depend',1089),(1112,'recommend',1093),(1112,'recommend',1095),(1112,'recommend',1131),(1113,'depend',1089),(1113,'depend',1096),(1113,'recommend',1097),(1113,'recommend',1098),(1114,'depend',1089),(1114,'depend',1110),(1114,'recommend',1109),(1114,'recommend',1110),(1115,'depend',1089),(1115,'depend',1116),(1115,'recommend',1117),(1116,'depend',1089),(1116,'recommend',1115),(1116,'recommend',1117),(1117,'depend',1089),(1117,'depend',1116),(1117,'recommend',1115),(1118,'depend',1089),(1118,'depend',1116),(1118,'recommend',1115),(1118,'recommend',1117),(1120,'recommend',1121),(1120,'recommend',1122),(1120,'recommend',1123),(1120,'recommend',1125),(1121,'depend',1120),(1121,'recommend',1122),(1121,'recommend',1123),(1121,'recommend',1125),(1122,'depend',1120),(1122,'recommend',1121),(1122,'recommend',1123),(1122,'recommend',1125),(1123,'depend',1120),(1123,'recommend',1121),(1123,'recommend',1122),(1123,'recommend',1125),(1124,'depend',1120),(1124,'recommend',1121),(1124,'recommend',1122),(1124,'recommend',1123),(1124,'recommend',1125),(1125,'depend',1120),(1125,'recommend',1121),(1125,'recommend',1122),(1125,'recommend',1123),(1126,'recommend',1127),(1126,'recommend',1128),(1126,'recommend',1129),(1127,'depend',1126),(1127,'recommend',1128),(1127,'recommend',1129),(1128,'depend',1126),(1128,'recommend',1127),(1128,'recommend',1129),(1129,'depend',1126),(1129,'recommend',1127),(1129,'recommend',1128),(1130,'depend',1126),(1130,'recommend',1127),(1130,'recommend',1128),(1130,'recommend',1129),(1131,'depend',1089),(1131,'recommend',1127),(1131,'recommend',1128),(1131,'recommend',1129),(1132,'recommend',1133),(1132,'recommend',1134),(1133,'depend',1132),(1133,'recommend',1134),(1134,'depend',1132),(1134,'recommend',1133),(1135,'depend',1132),(1135,'recommend',1133),(1135,'recommend',1134),(1136,'depend',1132),(1137,'depend',1132),(1137,'depend',1136),(1137,'recommend',1139),(1137,'recommend',1140),(1137,'recommend',1141),(1138,'depend',1132),(1138,'depend',1136),(1138,'recommend',1137),(1138,'recommend',1139),(1138,'recommend',1140),(1138,'recommend',1141),(1139,'depend',1132),(1139,'depend',1136),(1139,'recommend',1137),(1139,'recommend',1140),(1139,'recommend',1141),(1140,'depend',1132),(1140,'depend',1136),(1140,'recommend',1137),(1140,'recommend',1139),(1140,'recommend',1141),(1141,'depend',1132),(1141,'depend',1136),(1141,'recommend',1137),(1141,'recommend',1139),(1141,'recommend',1140),(1144,'depend',1143),(1144,'recommend',1145),(1144,'recommend',1146),(1144,'recommend',1147),(1144,'recommend',1148),(1144,'recommend',1149),(1145,'depend',1143),(1145,'recommend',1144),(1145,'recommend',1146),(1145,'recommend',1147),(1145,'recommend',1148),(1145,'recommend',1149),(1146,'depend',1143),(1146,'recommend',1144),(1146,'recommend',1145),(1146,'recommend',1147),(1146,'recommend',1148),(1146,'recommend',1149),(1147,'depend',1143),(1147,'recommend',1144),(1147,'recommend',1145),(1147,'recommend',1146),(1147,'recommend',1148),(1147,'recommend',1149),(1148,'depend',1149),(1149,'depend',1143),(1149,'recommend',1144),(1149,'recommend',1145),(1149,'recommend',1146),(1154,'depend',1153),(1154,'recommend',1156),(1154,'recommend',1158),(1154,'recommend',1159),(1155,'recommend',1156),(1155,'recommend',1159),(1156,'recommend',1154),(1156,'recommend',1155),(1156,'recommend',1157),(1156,'recommend',1158),(1156,'recommend',1159),(1156,'recommend',1160),(1157,'depend',22),(1157,'recommend',1156),(1158,'depend',1153),(1158,'recommend',22),(1158,'recommend',1156),(1158,'recommend',1159),(1159,'recommend',1154),(1159,'recommend',1155),(1159,'recommend',1156),(1159,'recommend',1157),(1159,'recommend',1158),(1159,'recommend',1160),(1160,'depend',22),(1160,'depend',1153),(1160,'recommend',1158),(1164,'depend',1163),(1164,'recommend',1165),(1164,'recommend',1166),(1165,'depend',1163),(1165,'recommend',1164),(1165,'recommend',1166),(1166,'depend',1163),(1166,'recommend',1164),(1166,'recommend',1165),(1168,'depend',1172),(1168,'recommend',1169),(1168,'recommend',1173),(1168,'recommend',1181),(1168,'recommend',1183),(1168,'recommend',1184),(1168,'recommend',1186),(1169,'depend',1172),(1169,'recommend',1168),(1169,'recommend',1173),(1169,'recommend',1181),(1169,'recommend',1183),(1169,'recommend',1184),(1169,'recommend',1186),(1169,'recommend',1188),(1170,'depend',1172),(1170,'recommend',1169),(1171,'depend',1172),(1171,'recommend',1168),(1171,'recommend',1169),(1172,'recommend',1171),(1173,'depend',1172),(1173,'recommend',1168),(1173,'recommend',1169),(1173,'recommend',1181),(1173,'recommend',1183),(1173,'recommend',1184),(1173,'recommend',1186),(1173,'recommend',1191),(1174,'depend',1172),(1174,'recommend',1175),(1174,'recommend',1176),(1174,'recommend',1177),(1174,'recommend',1178),(1174,'recommend',1179),(1174,'recommend',1180),(1174,'recommend',1182),(1175,'depend',1172),(1175,'recommend',1174),(1175,'recommend',1176),(1175,'recommend',1177),(1175,'recommend',1178),(1175,'recommend',1179),(1175,'recommend',1180),(1175,'recommend',1182),(1176,'depend',1172),(1176,'recommend',1174),(1176,'recommend',1175),(1176,'recommend',1177),(1176,'recommend',1178),(1176,'recommend',1179),(1176,'recommend',1180),(1176,'recommend',1182),(1177,'depend',1172),(1177,'recommend',1174),(1177,'recommend',1175),(1177,'recommend',1176),(1177,'recommend',1178),(1177,'recommend',1179),(1177,'recommend',1180),(1177,'recommend',1182),(1178,'depend',1172),(1178,'recommend',1174),(1178,'recommend',1175),(1178,'recommend',1176),(1178,'recommend',1177),(1178,'recommend',1179),(1178,'recommend',1180),(1178,'recommend',1182),(1179,'depend',1172),(1179,'recommend',1174),(1179,'recommend',1175),(1179,'recommend',1176),(1179,'recommend',1177),(1179,'recommend',1178),(1179,'recommend',1180),(1179,'recommend',1182),(1180,'depend',1172),(1180,'recommend',1174),(1180,'recommend',1175),(1180,'recommend',1176),(1180,'recommend',1177),(1180,'recommend',1178),(1180,'recommend',1179),(1180,'recommend',1182),(1180,'recommend',1190),(1181,'depend',1172),(1181,'recommend',1168),(1181,'recommend',1169),(1181,'recommend',1173),(1181,'recommend',1183),(1181,'recommend',1184),(1181,'recommend',1186),(1182,'depend',1172),(1182,'recommend',1174),(1182,'recommend',1175),(1182,'recommend',1176),(1182,'recommend',1177),(1182,'recommend',1178),(1182,'recommend',1179),(1182,'recommend',1180),(1183,'depend',1172),(1183,'recommend',1168),(1183,'recommend',1169),(1183,'recommend',1173),(1183,'recommend',1181),(1183,'recommend',1184),(1183,'recommend',1186),(1184,'depend',1172),(1184,'recommend',1168),(1184,'recommend',1169),(1184,'recommend',1173),(1184,'recommend',1181),(1184,'recommend',1183),(1184,'recommend',1186),(1184,'recommend',1189),(1185,'depend',1172),(1185,'recommend',1168),(1185,'recommend',1169),(1186,'depend',1172),(1186,'recommend',1168),(1186,'recommend',1169),(1186,'recommend',1173),(1186,'recommend',1181),(1186,'recommend',1183),(1186,'recommend',1184),(1187,'depend',1172),(1188,'depend',1172),(1188,'recommend',1169),(1189,'depend',1172),(1189,'recommend',1184),(1190,'depend',1172),(1190,'recommend',1180),(1191,'depend',1172),(1191,'recommend',1173),(1192,'depend',1172),(1193,'recommend',1194),(1193,'recommend',1198),(1194,'depend',1193),(1194,'recommend',1198),(1195,'depend',1172),(1195,'depend',1196),(1196,'depend',1172),(1196,'depend',1195),(1197,'depend',1172),(1198,'depend',1193),(1198,'recommend',1194),(1199,'recommend',1200),(1199,'recommend',1201),(1200,'depend',1199),(1200,'recommend',1201),(1201,'depend',1199),(1201,'recommend',1200),(1202,'depend',1199),(1202,'recommend',1200),(1202,'recommend',1201),(1204,'depend',1207),(1204,'recommend',1205),(1204,'recommend',1213),(1204,'recommend',1214),(1205,'depend',1207),(1205,'recommend',1204),(1205,'recommend',1213),(1205,'recommend',1214),(1206,'depend',1207),(1206,'recommend',1205),(1207,'recommend',1204),(1207,'recommend',1205),(1207,'recommend',1206),(1208,'depend',1207),(1208,'recommend',1204),(1208,'recommend',1205),(1208,'recommend',1223),(1209,'depend',1207),(1209,'recommend',1210),(1209,'recommend',1211),(1209,'recommend',1212),(1210,'depend',1207),(1210,'recommend',1209),(1210,'recommend',1211),(1210,'recommend',1212),(1211,'depend',1207),(1211,'recommend',1204),(1211,'recommend',1205),(1211,'recommend',1208),(1211,'recommend',1209),(1211,'recommend',1210),(1211,'recommend',1212),(1211,'recommend',1213),(1211,'recommend',1214),(1212,'depend',1207),(1212,'recommend',1209),(1212,'recommend',1210),(1212,'recommend',1211),(1213,'depend',1207),(1213,'recommend',1205),(1213,'recommend',1220),(1214,'depend',1207),(1214,'recommend',1221),(1215,'depend',1207),(1215,'recommend',1204),(1215,'recommend',1205),(1216,'depend',1207),(1216,'depend',1217),(1217,'depend',1207),(1217,'depend',1216),(1218,'depend',1207),(1219,'depend',1207),(1219,'recommend',1205),(1220,'depend',1207),(1220,'recommend',1213),(1221,'depend',1207),(1221,'recommend',1214),(1222,'depend',1207),(1222,'recommend',1212),(1223,'depend',1207),(1223,'recommend',1208),(1224,'depend',1207),(1225,'depend',1238),(1226,'depend',1238),(1227,'depend',1238),(1228,'depend',1227),(1228,'depend',1238),(1229,'depend',1225),(1229,'depend',1238),(1230,'depend',1238),(1231,'depend',1230),(1231,'depend',1238),(1232,'depend',1230),(1232,'depend',1238),(1233,'depend',1238),(1234,'depend',1233),(1234,'depend',1238),(1235,'depend',1238),(1236,'depend',1238),(1237,'depend',1238),(1238,'recommend',1239),(1239,'depend',1238),(1239,'recommend',1227),(1240,'depend',1238),(1240,'depend',1246),(1241,'depend',1238),(1242,'depend',1238),(1242,'depend',1240),(1242,'depend',1246),(1243,'depend',1238),(1243,'depend',1246),(1244,'depend',1238),(1244,'depend',1246),(1245,'depend',1238),(1245,'depend',1246),(1246,'depend',1238),(1246,'recommend',1247),(1246,'recommend',1248),(1246,'recommend',1250),(1247,'depend',1238),(1247,'depend',1246),(1247,'recommend',1248),(1247,'recommend',1249),(1247,'recommend',1250),(1247,'recommend',1251),(1248,'depend',1238),(1248,'depend',1246),(1248,'recommend',1247),(1248,'recommend',1249),(1248,'recommend',1250),(1248,'recommend',1251),(1249,'depend',1238),(1249,'depend',1246),(1249,'recommend',1247),(1249,'recommend',1248),(1249,'recommend',1250),(1249,'recommend',1251),(1250,'depend',1238),(1250,'depend',1246),(1251,'depend',1238),(1251,'depend',1246),(1251,'recommend',1247),(1251,'recommend',1248),(1251,'recommend',1249),(1251,'recommend',1250),(1252,'depend',1238),(1252,'depend',1246),(1253,'depend',1238),(1253,'depend',1258),(1254,'depend',1238),(1255,'depend',1238),(1255,'depend',1253),(1255,'depend',1258),(1256,'depend',1238),(1256,'depend',1258),(1257,'depend',1238),(1257,'depend',1258),(1258,'depend',1238),(1258,'recommend',1259),(1258,'recommend',1260),(1258,'recommend',1261),(1259,'depend',1238),(1259,'depend',1258),(1259,'recommend',1260),(1259,'recommend',1261),(1259,'recommend',1262),(1259,'recommend',1263),(1260,'depend',1238),(1260,'depend',1258),(1260,'recommend',1259),(1260,'recommend',1261),(1260,'recommend',1262),(1260,'recommend',1263),(1261,'depend',1238),(1261,'depend',1258),(1262,'depend',1238),(1262,'depend',1258),(1262,'recommend',1259),(1262,'recommend',1260),(1262,'recommend',1261),(1262,'recommend',1263),(1263,'depend',1238),(1263,'depend',1258),(1263,'recommend',1259),(1263,'recommend',1260),(1263,'recommend',1261),(1263,'recommend',1262),(1264,'depend',1238),(1264,'depend',1269),(1265,'depend',1238),(1266,'depend',1238),(1266,'depend',1264),(1266,'depend',1269),(1267,'depend',1238),(1268,'depend',1238),(1268,'depend',1269),(1269,'depend',1238),(1269,'recommend',1270),(1269,'recommend',1271),(1269,'recommend',1272),(1270,'depend',1238),(1270,'depend',1269),(1270,'recommend',1271),(1270,'recommend',1272),(1270,'recommend',1273),(1270,'recommend',1274),(1271,'depend',1238),(1271,'depend',1269),(1271,'recommend',1270),(1271,'recommend',1272),(1271,'recommend',1273),(1271,'recommend',1274),(1272,'depend',1238),(1272,'depend',1269),(1273,'depend',1238),(1273,'depend',1269),(1273,'recommend',1270),(1273,'recommend',1271),(1273,'recommend',1272),(1273,'recommend',1274),(1274,'depend',1238),(1274,'depend',1269),(1274,'recommend',1270),(1274,'recommend',1271),(1274,'recommend',1272),(1274,'recommend',1273),(1275,'depend',1238),(1276,'depend',1238),(1276,'depend',1279),(1277,'depend',1238),(1277,'depend',1276),(1277,'depend',1279),(1278,'depend',1238),(1279,'depend',1238),(1279,'recommend',1280),(1279,'recommend',1281),(1279,'recommend',1283),(1280,'depend',1238),(1280,'depend',1279),(1280,'recommend',1281),(1280,'recommend',1282),(1280,'recommend',1283),(1280,'recommend',1284),(1281,'depend',1238),(1281,'depend',1279),(1281,'recommend',1280),(1281,'recommend',1282),(1281,'recommend',1283),(1281,'recommend',1284),(1282,'depend',1238),(1282,'depend',1279),(1282,'recommend',1280),(1282,'recommend',1281),(1282,'recommend',1283),(1282,'recommend',1284),(1283,'depend',1238),(1283,'depend',1279),(1284,'depend',1238),(1284,'depend',1279),(1284,'recommend',1280),(1284,'recommend',1281),(1284,'recommend',1282),(1284,'recommend',1283),(1286,'depend',1285),(1287,'depend',1285),(1287,'recommend',1288),(1287,'recommend',1289),(1287,'recommend',1290),(1287,'recommend',1293),(1288,'depend',1285),(1288,'depend',1287),(1288,'recommend',1289),(1288,'recommend',1292),(1289,'depend',1285),(1289,'depend',1287),(1289,'recommend',1288),(1289,'recommend',1292),(1290,'depend',1285),(1290,'depend',1287),(1290,'recommend',1288),(1290,'recommend',1289),(1291,'depend',1285),(1291,'depend',1287),(1291,'recommend',1288),(1291,'recommend',1289),(1292,'depend',1285),(1292,'depend',1287),(1292,'recommend',1288),(1292,'recommend',1289),(1293,'depend',1285),(1293,'depend',1287),(1294,'depend',1285),(1294,'recommend',1295),(1294,'recommend',1296),(1294,'recommend',1297),(1295,'depend',1285),(1295,'depend',1294),(1295,'recommend',1296),(1296,'depend',1285),(1296,'depend',1294),(1296,'recommend',1295),(1297,'depend',1285),(1297,'depend',1294),(1297,'recommend',1295),(1297,'recommend',1296),(1298,'depend',1285),(1298,'depend',1294),(1298,'recommend',1295),(1298,'recommend',1296),(1299,'depend',1285),(1299,'recommend',1300),(1299,'recommend',1301),(1299,'recommend',1302),(1300,'depend',1285),(1300,'depend',1299),(1300,'recommend',1301),(1301,'depend',1285),(1301,'depend',1299),(1301,'recommend',1300),(1302,'depend',1285),(1302,'depend',1299),(1302,'recommend',1300),(1302,'recommend',1301),(1303,'depend',1285),(1303,'depend',1299),(1303,'recommend',1300),(1303,'recommend',1301),(1304,'depend',1285),(1304,'recommend',1305),(1304,'recommend',1306),(1304,'recommend',1307),(1305,'depend',1285),(1305,'depend',1304),(1305,'recommend',1306),(1306,'depend',1285),(1306,'depend',1304),(1306,'recommend',1305),(1307,'depend',1285),(1307,'depend',1304),(1307,'recommend',1305),(1307,'recommend',1306),(1308,'depend',1285),(1308,'depend',1304),(1308,'recommend',1305),(1308,'recommend',1306),(1309,'depend',1285),(1309,'recommend',1310),(1309,'recommend',1311),(1309,'recommend',1313),(1309,'recommend',1315),(1310,'depend',1285),(1310,'depend',1309),(1310,'recommend',1311),(1310,'recommend',1315),(1311,'depend',1285),(1311,'depend',1309),(1311,'recommend',1310),(1311,'recommend',1315),(1312,'depend',1285),(1312,'depend',1309),(1312,'recommend',1310),(1312,'recommend',1311),(1312,'recommend',1315),(1313,'depend',1285),(1313,'depend',1309),(1313,'recommend',1310),(1313,'recommend',1311),(1313,'recommend',1315),(1315,'depend',1285),(1315,'depend',1309),(1315,'recommend',1310),(1315,'recommend',1311),(1316,'depend',1285),(1316,'recommend',1317),(1316,'recommend',1318),(1316,'recommend',1320),(1316,'recommend',1321),(1316,'recommend',1324),(1317,'depend',1285),(1317,'depend',1316),(1317,'recommend',1318),(1317,'recommend',1320),(1317,'recommend',1321),(1318,'depend',1285),(1318,'depend',1316),(1318,'recommend',1317),(1318,'recommend',1320),(1318,'recommend',1321),(1319,'depend',1285),(1319,'depend',1316),(1319,'recommend',1317),(1319,'recommend',1318),(1320,'depend',1285),(1320,'depend',1316),(1320,'recommend',1317),(1320,'recommend',1318),(1320,'recommend',1321),(1321,'depend',1285),(1321,'depend',1316),(1321,'recommend',1317),(1321,'recommend',1318),(1321,'recommend',1320),(1322,'depend',1285),(1322,'depend',1316),(1322,'recommend',1323),(1323,'depend',1285),(1323,'depend',1316),(1323,'depend',1322),(1324,'depend',1285),(1324,'depend',1316),(1324,'recommend',1317),(1324,'recommend',1318),(1324,'recommend',1320),(1324,'recommend',1321),(1325,'depend',1285),(1325,'depend',1316),(1325,'recommend',1326),(1325,'recommend',1327),(1326,'depend',1285),(1326,'depend',1316),(1326,'depend',1325),(1326,'recommend',1327),(1327,'depend',1285),(1327,'depend',1316),(1327,'depend',1325),(1327,'recommend',1326),(1327,'recommend',1328),(1328,'depend',1285),(1328,'depend',1316),(1328,'depend',1325),(1328,'recommend',1327),(1329,'depend',1285),(1329,'depend',1316),(1329,'recommend',476),(1329,'recommend',477),(1329,'recommend',1330),(1329,'recommend',1331),(1329,'recommend',1332),(1329,'recommend',1333),(1329,'recommend',1334),(1330,'depend',1285),(1330,'depend',1316),(1330,'depend',1329),(1330,'recommend',476),(1330,'recommend',477),(1330,'recommend',1331),(1330,'recommend',1332),(1330,'recommend',1334),(1331,'depend',1285),(1331,'depend',1316),(1331,'depend',1329),(1331,'recommend',476),(1331,'recommend',477),(1331,'recommend',1330),(1331,'recommend',1332),(1331,'recommend',1334),(1332,'depend',1285),(1332,'depend',1316),(1332,'depend',1329),(1332,'recommend',476),(1332,'recommend',477),(1332,'recommend',1330),(1332,'recommend',1331),(1332,'recommend',1334),(1333,'depend',1285),(1333,'depend',1316),(1333,'depend',1329),(1333,'recommend',476),(1333,'recommend',477),(1333,'recommend',1330),(1333,'recommend',1331),(1333,'recommend',1332),(1333,'recommend',1334),(1334,'depend',1285),(1334,'depend',1316),(1334,'depend',1329),(1334,'recommend',476),(1334,'recommend',477),(1334,'recommend',1330),(1334,'recommend',1331),(1334,'recommend',1332),(1335,'depend',1285),(1335,'depend',1316),(1335,'depend',1329),(1335,'recommend',476),(1335,'recommend',477),(1335,'recommend',1330),(1335,'recommend',1331),(1335,'recommend',1332),(1335,'recommend',1334),(1339,'depend',1338),(1339,'recommend',1341),(1340,'depend',1338),(1340,'recommend',1341),(1341,'depend',1338),(1341,'recommend',1339),(1342,'depend',1337),(1343,'depend',1337),(1343,'depend',1342),(1344,'depend',1646),(1345,'depend',1344),(1345,'recommend',1346),(1345,'recommend',1347),(1345,'recommend',1348),(1346,'depend',1344),(1346,'recommend',1345),(1346,'recommend',1347),(1346,'recommend',1348),(1347,'depend',1344),(1347,'recommend',1345),(1347,'recommend',1346),(1347,'recommend',1348),(1348,'depend',1344),(1348,'recommend',1345),(1348,'recommend',1346),(1348,'recommend',1347),(1360,'depend',176),(1361,'depend',1360),(1364,'depend',1363),(1364,'recommend',1366),(1364,'recommend',1367),(1364,'recommend',1369),(1364,'recommend',1370),(1365,'depend',1363),(1366,'depend',1363),(1366,'recommend',1364),(1366,'recommend',1367),(1366,'recommend',1369),(1366,'recommend',1370),(1367,'depend',1363),(1367,'recommend',1364),(1367,'recommend',1366),(1367,'recommend',1369),(1367,'recommend',1370),(1368,'depend',1363),(1369,'depend',1363),(1369,'recommend',1364),(1369,'recommend',1366),(1369,'recommend',1367),(1369,'recommend',1370),(1370,'depend',1363),(1370,'recommend',1364),(1372,'depend',1375),(1372,'depend',1376),(1372,'recommend',1373),(1372,'recommend',1374),(1372,'recommend',1460),(1373,'depend',1375),(1373,'depend',1376),(1373,'recommend',1372),(1373,'recommend',1374),(1374,'depend',1375),(1374,'depend',1376),(1374,'recommend',1372),(1374,'recommend',1373),(1375,'depend',176),(1375,'recommend',1376),(1376,'depend',1375),(1377,'depend',1375),(1378,'recommend',1379),(1378,'recommend',1380),(1379,'recommend',1378),(1379,'recommend',1380),(1380,'recommend',1378),(1380,'recommend',1379),(1384,'recommend',1385),(1384,'recommend',1386),(1384,'recommend',1387),(1385,'recommend',1384),(1385,'recommend',1386),(1385,'recommend',1387),(1386,'recommend',1384),(1386,'recommend',1385),(1386,'recommend',1387),(1387,'recommend',1384),(1387,'recommend',1385),(1387,'recommend',1386),(1394,'recommend',1395),(1394,'recommend',1396),(1394,'recommend',1397),(1394,'recommend',1398),(1395,'recommend',1394),(1396,'recommend',1394),(1396,'recommend',1397),(1396,'recommend',1398),(1397,'recommend',1394),(1397,'recommend',1396),(1397,'recommend',1398),(1400,'recommend',1401),(1400,'recommend',1402),(1400,'recommend',1403),(1400,'recommend',1404),(1400,'recommend',1405),(1400,'recommend',1406),(1401,'recommend',1400),(1402,'recommend',1400),(1403,'recommend',1400),(1403,'recommend',1402),(1403,'recommend',1404),(1403,'recommend',1405),(1403,'recommend',1406),(1404,'recommend',1406),(1405,'recommend',1400),(1405,'recommend',1403),(1406,'recommend',1400),(1406,'recommend',1403),(1406,'recommend',1404),(1412,'depend',1411),(1412,'recommend',1413),(1412,'recommend',1414),(1412,'recommend',1415),(1412,'recommend',1416),(1412,'recommend',1417),(1412,'recommend',1418),(1412,'recommend',1419),(1413,'depend',1411),(1413,'recommend',1412),(1414,'depend',1411),(1414,'recommend',1412),(1415,'depend',1411),(1415,'recommend',1412),(1415,'recommend',1413),(1415,'recommend',1414),(1415,'recommend',1416),(1415,'recommend',1417),(1415,'recommend',1418),(1415,'recommend',1419),(1416,'depend',1411),(1416,'recommend',1418),(1417,'depend',1411),(1417,'recommend',1412),(1417,'recommend',1415),(1418,'depend',1411),(1418,'recommend',1412),(1418,'recommend',1415),(1418,'recommend',1416),(1419,'depend',1411),(1419,'recommend',1412),(1419,'recommend',1415),(1421,'depend',1420),(1421,'recommend',1422),(1421,'recommend',1423),(1421,'recommend',1425),(1421,'recommend',1426),(1421,'recommend',1427),(1422,'depend',1420),(1422,'recommend',1421),(1422,'recommend',1424),(1422,'recommend',1425),(1422,'recommend',1426),(1422,'recommend',1427),(1423,'depend',1420),(1423,'recommend',1421),(1424,'depend',1420),(1424,'recommend',1422),(1425,'depend',1420),(1425,'recommend',1421),(1426,'depend',1420),(1427,'depend',1420),(1427,'recommend',1421),(1427,'recommend',1422),(1429,'depend',1428),(1429,'recommend',1430),(1429,'recommend',1431),(1429,'recommend',1434),(1429,'recommend',1435),(1429,'recommend',1436),(1429,'recommend',1437),(1429,'recommend',1438),(1430,'depend',1428),(1430,'recommend',1429),(1430,'recommend',1432),(1430,'recommend',1434),(1430,'recommend',1435),(1430,'recommend',1436),(1430,'recommend',1437),(1430,'recommend',1438),(1431,'depend',1428),(1431,'recommend',1429),(1432,'depend',1428),(1432,'recommend',1430),(1433,'depend',1428),(1433,'recommend',1434),(1434,'depend',1428),(1434,'recommend',1429),(1434,'recommend',1430),(1434,'recommend',1433),(1434,'recommend',1435),(1434,'recommend',1436),(1434,'recommend',1438),(1435,'depend',1428),(1435,'recommend',1429),(1435,'recommend',1430),(1435,'recommend',1434),(1435,'recommend',1436),(1435,'recommend',1438),(1436,'depend',1428),(1436,'recommend',1429),(1436,'recommend',1430),(1436,'recommend',1434),(1436,'recommend',1435),(1436,'recommend',1438),(1437,'depend',1428),(1437,'recommend',1429),(1437,'recommend',1430),(1438,'depend',1428),(1438,'recommend',1429),(1438,'recommend',1430),(1438,'recommend',1434),(1438,'recommend',1435),(1438,'recommend',1436),(1441,'depend',1440),(1441,'recommend',1442),(1441,'recommend',1443),(1441,'recommend',1444),(1441,'recommend',1445),(1442,'depend',1440),(1442,'recommend',1441),(1442,'recommend',1443),(1442,'recommend',1444),(1442,'recommend',1445),(1443,'depend',1440),(1444,'depend',1440),(1444,'recommend',1441),(1444,'recommend',1442),(1444,'recommend',1443),(1444,'recommend',1445),(1445,'depend',1440),(1445,'recommend',1441),(1445,'recommend',1442),(1445,'recommend',1443),(1445,'recommend',1444),(1447,'depend',1446),(1447,'recommend',1448),(1447,'recommend',1449),(1448,'depend',1446),(1448,'recommend',1447),(1448,'recommend',1449),(1449,'depend',1446),(1449,'recommend',1447),(1449,'recommend',1448),(1450,'depend',176),(1450,'depend',1460),(1451,'depend',1450),(1451,'recommend',1452),(1451,'recommend',1453),(1451,'recommend',1454),(1451,'recommend',1456),(1452,'depend',1450),(1452,'recommend',1451),(1452,'recommend',1453),(1452,'recommend',1454),(1452,'recommend',1456),(1453,'depend',1450),(1453,'recommend',1451),(1453,'recommend',1452),(1453,'recommend',1454),(1453,'recommend',1456),(1454,'depend',1450),(1454,'recommend',1451),(1454,'recommend',1452),(1454,'recommend',1453),(1454,'recommend',1456),(1455,'depend',1450),(1456,'depend',1450),(1456,'recommend',1451),(1456,'recommend',1452),(1456,'recommend',1453),(1456,'recommend',1454),(1460,'depend',176),(1460,'recommend',1464),(1461,'depend',1460),(1461,'recommend',1467),(1462,'depend',1460),(1462,'recommend',1463),(1462,'recommend',1465),(1462,'recommend',1466),(1462,'recommend',1467),(1462,'recommend',1468),(1463,'depend',1460),(1463,'recommend',1462),(1463,'recommend',1465),(1463,'recommend',1466),(1463,'recommend',1467),(1463,'recommend',1468),(1463,'recommend',1470),(1464,'depend',1460),(1465,'depend',1460),(1465,'recommend',1462),(1465,'recommend',1463),(1465,'recommend',1466),(1465,'recommend',1467),(1465,'recommend',1468),(1466,'depend',1460),(1466,'recommend',1462),(1466,'recommend',1463),(1466,'recommend',1465),(1466,'recommend',1467),(1466,'recommend',1468),(1466,'recommend',1470),(1467,'depend',1460),(1467,'recommend',1462),(1467,'recommend',1463),(1467,'recommend',1465),(1467,'recommend',1466),(1467,'recommend',1468),(1467,'recommend',1470),(1468,'depend',1460),(1468,'recommend',1462),(1468,'recommend',1463),(1468,'recommend',1465),(1468,'recommend',1466),(1468,'recommend',1467),(1468,'recommend',1470),(1469,'depend',1460),(1470,'depend',1460),(1470,'recommend',1462),(1470,'recommend',1463),(1472,'depend',1473),(1472,'recommend',1474),(1472,'recommend',1475),(1472,'recommend',1477),(1474,'depend',1473),(1474,'recommend',1472),(1474,'recommend',1475),(1474,'recommend',1477),(1475,'depend',1473),(1475,'recommend',1472),(1475,'recommend',1474),(1475,'recommend',1477),(1475,'recommend',1488),(1477,'depend',1473),(1477,'recommend',1472),(1477,'recommend',1474),(1477,'recommend',1475),(1477,'recommend',1488),(1480,'depend',1479),(1480,'recommend',1481),(1480,'recommend',1482),(1481,'recommend',1480),(1481,'recommend',1482),(1488,'depend',1473),(1488,'recommend',1477),(1489,'depend',1482),(1490,'depend',176),(1491,'recommend',496),(1491,'recommend',500),(1491,'recommend',1584),(1492,'recommend',1493),(1492,'recommend',1494),(1492,'recommend',1496),(1492,'recommend',1497),(1492,'recommend',1583),(1493,'depend',1492),(1493,'recommend',1494),(1493,'recommend',1583),(1494,'depend',1492),(1494,'recommend',1493),(1494,'recommend',1583),(1495,'depend',1492),(1495,'recommend',1493),(1495,'recommend',1494),(1496,'depend',1492),(1496,'depend',1497),(1496,'recommend',1494),(1497,'depend',1492),(1497,'recommend',1498),(1497,'recommend',1499),(1497,'recommend',1503),(1497,'recommend',1504),(1497,'recommend',1506),(1498,'depend',1492),(1498,'depend',1497),(1498,'recommend',1499),(1498,'recommend',1503),(1498,'recommend',1504),(1499,'depend',1492),(1499,'depend',1497),(1499,'recommend',1498),(1499,'recommend',1500),(1499,'recommend',1503),(1499,'recommend',1504),(1500,'depend',1492),(1500,'depend',1497),(1500,'recommend',1499),(1501,'depend',1492),(1501,'depend',1497),(1501,'recommend',1502),(1502,'depend',1492),(1502,'depend',1497),(1502,'recommend',1501),(1503,'depend',1492),(1503,'depend',1497),(1503,'recommend',1498),(1503,'recommend',1499),(1503,'recommend',1504),(1504,'depend',1492),(1504,'depend',1497),(1504,'recommend',1498),(1504,'recommend',1503),(1504,'recommend',1505),(1505,'depend',1492),(1505,'depend',1497),(1505,'recommend',1504),(1506,'depend',1492),(1506,'depend',1497),(1506,'recommend',1498),(1506,'recommend',1499),(1506,'recommend',1503),(1506,'recommend',1504),(1507,'recommend',1508),(1507,'recommend',1509),(1507,'recommend',1511),(1507,'recommend',1512),(1507,'recommend',1585),(1508,'depend',1507),(1508,'recommend',1509),(1508,'recommend',1585),(1509,'depend',1507),(1509,'recommend',1508),(1509,'recommend',1585),(1510,'depend',1507),(1510,'recommend',1508),(1510,'recommend',1509),(1511,'depend',1507),(1511,'depend',1512),(1511,'recommend',1509),(1512,'depend',1507),(1512,'recommend',1513),(1512,'recommend',1518),(1512,'recommend',1519),(1512,'recommend',1521),(1513,'depend',1507),(1513,'depend',1512),(1513,'recommend',1514),(1513,'recommend',1518),(1513,'recommend',1519),(1514,'depend',1507),(1514,'depend',1512),(1514,'recommend',1513),(1514,'recommend',1515),(1514,'recommend',1518),(1514,'recommend',1519),(1515,'depend',1507),(1515,'depend',1512),(1515,'recommend',1514),(1516,'depend',1507),(1516,'depend',1512),(1516,'recommend',1517),(1517,'depend',1507),(1517,'depend',1512),(1517,'recommend',1516),(1518,'depend',1507),(1518,'depend',1512),(1518,'recommend',1513),(1518,'recommend',1514),(1518,'recommend',1519),(1519,'depend',1507),(1519,'depend',1512),(1519,'recommend',1513),(1519,'recommend',1518),(1519,'recommend',1520),(1520,'depend',1507),(1520,'depend',1512),(1520,'recommend',1519),(1521,'depend',1507),(1521,'depend',1512),(1521,'recommend',1518),(1521,'recommend',1519),(1522,'recommend',1523),(1522,'recommend',1524),(1522,'recommend',1526),(1522,'recommend',1527),(1522,'recommend',1586),(1523,'depend',1522),(1523,'recommend',1524),(1523,'recommend',1586),(1524,'depend',1522),(1524,'recommend',1523),(1524,'recommend',1586),(1525,'depend',1522),(1525,'recommend',1523),(1525,'recommend',1524),(1526,'depend',1522),(1526,'recommend',1533),(1527,'depend',1522),(1527,'recommend',1528),(1527,'recommend',1529),(1527,'recommend',1533),(1527,'recommend',1534),(1527,'recommend',1536),(1528,'depend',1522),(1528,'depend',1527),(1528,'recommend',1529),(1528,'recommend',1533),(1528,'recommend',1534),(1529,'depend',1522),(1529,'depend',1527),(1529,'recommend',1528),(1529,'recommend',1530),(1529,'recommend',1533),(1529,'recommend',1534),(1530,'depend',1522),(1530,'depend',1527),(1530,'recommend',1529),(1531,'depend',1522),(1531,'depend',1527),(1531,'recommend',1532),(1532,'depend',1522),(1532,'depend',1527),(1532,'recommend',1531),(1533,'depend',1522),(1533,'depend',1527),(1533,'recommend',1528),(1533,'recommend',1529),(1533,'recommend',1534),(1534,'depend',1522),(1534,'depend',1527),(1534,'recommend',1528),(1534,'recommend',1533),(1534,'recommend',1535),(1535,'depend',1522),(1535,'depend',1527),(1535,'recommend',1534),(1536,'depend',1522),(1536,'depend',1527),(1536,'recommend',1529),(1536,'recommend',1533),(1537,'recommend',1538),(1537,'recommend',1539),(1537,'recommend',1587),(1538,'depend',1537),(1538,'recommend',1539),(1538,'recommend',1587),(1539,'depend',1537),(1539,'recommend',1538),(1539,'recommend',1587),(1540,'depend',1537),(1540,'recommend',1543),(1540,'recommend',1548),(1541,'depend',1537),(1541,'recommend',1539),(1542,'depend',1537),(1542,'recommend',1543),(1542,'recommend',1544),(1542,'recommend',1548),(1542,'recommend',1549),(1543,'depend',1537),(1543,'depend',1542),(1543,'recommend',1544),(1543,'recommend',1548),(1543,'recommend',1549),(1544,'depend',1537),(1544,'depend',1542),(1544,'recommend',1543),(1544,'recommend',1545),(1544,'recommend',1548),(1544,'recommend',1549),(1545,'depend',1537),(1545,'depend',1542),(1545,'recommend',1544),(1546,'depend',1537),(1546,'depend',1542),(1546,'recommend',1547),(1547,'depend',1537),(1547,'depend',1542),(1547,'recommend',1546),(1548,'depend',1537),(1548,'depend',1542),(1548,'recommend',1543),(1548,'recommend',1544),(1548,'recommend',1549),(1549,'depend',1537),(1549,'depend',1542),(1549,'recommend',1543),(1549,'recommend',1548),(1549,'recommend',1550),(1550,'depend',1537),(1550,'depend',1542),(1550,'recommend',1549),(1551,'depend',1537),(1551,'depend',1542),(1551,'recommend',1544),(1551,'recommend',1548),(1552,'recommend',1553),(1552,'recommend',1554),(1552,'recommend',1588),(1553,'depend',1552),(1553,'recommend',1554),(1553,'recommend',1588),(1554,'depend',1552),(1554,'recommend',1553),(1554,'recommend',1588),(1555,'depend',1552),(1555,'recommend',1553),(1555,'recommend',1554),(1556,'depend',1552),(1556,'recommend',1554),(1557,'depend',1552),(1557,'recommend',1558),(1557,'recommend',1559),(1557,'recommend',1563),(1557,'recommend',1564),(1558,'depend',1552),(1558,'depend',1557),(1558,'recommend',1559),(1558,'recommend',1563),(1558,'recommend',1564),(1559,'depend',1552),(1559,'depend',1557),(1559,'recommend',1558),(1559,'recommend',1560),(1559,'recommend',1563),(1559,'recommend',1564),(1560,'depend',1552),(1560,'depend',1557),(1560,'recommend',1559),(1561,'depend',1552),(1561,'depend',1557),(1561,'recommend',1562),(1562,'depend',1552),(1562,'depend',1557),(1562,'recommend',1561),(1563,'depend',1552),(1563,'depend',1557),(1563,'recommend',1558),(1563,'recommend',1559),(1563,'recommend',1564),(1564,'depend',1552),(1564,'depend',1557),(1564,'recommend',1558),(1564,'recommend',1563),(1564,'recommend',1565),(1565,'depend',1552),(1565,'depend',1557),(1565,'recommend',1564),(1566,'depend',1552),(1566,'depend',1557),(1566,'recommend',1563),(1566,'recommend',1564),(1567,'recommend',1568),(1567,'recommend',1569),(1567,'recommend',1589),(1568,'depend',1567),(1568,'recommend',1569),(1568,'recommend',1589),(1569,'depend',1567),(1569,'recommend',1568),(1569,'recommend',1589),(1570,'depend',1567),(1570,'recommend',1568),(1570,'recommend',1569),(1571,'depend',1567),(1571,'recommend',1568),(1571,'recommend',1569),(1572,'depend',1567),(1572,'recommend',1573),(1572,'recommend',1574),(1572,'recommend',1578),(1572,'recommend',1579),(1573,'depend',1567),(1573,'depend',1572),(1573,'recommend',1574),(1573,'recommend',1578),(1573,'recommend',1579),(1574,'depend',1567),(1574,'depend',1572),(1574,'recommend',1573),(1574,'recommend',1575),(1574,'recommend',1578),(1574,'recommend',1579),(1575,'depend',1567),(1575,'depend',1572),(1575,'recommend',1574),(1576,'depend',1567),(1576,'depend',1572),(1576,'recommend',1577),(1577,'depend',1567),(1577,'depend',1572),(1577,'recommend',1576),(1578,'depend',1567),(1578,'depend',1572),(1578,'recommend',1573),(1578,'recommend',1574),(1578,'recommend',1579),(1579,'depend',1567),(1579,'depend',1572),(1579,'recommend',1573),(1579,'recommend',1578),(1579,'recommend',1580),(1580,'depend',1567),(1580,'depend',1572),(1580,'recommend',1579),(1581,'depend',1567),(1581,'depend',1572),(1581,'recommend',1578),(1583,'depend',1492),(1583,'recommend',1493),(1583,'recommend',1494),(1584,'depend',1491),(1584,'recommend',497),(1584,'recommend',498),(1585,'depend',1507),(1585,'recommend',1508),(1585,'recommend',1509),(1586,'depend',1522),(1586,'recommend',1523),(1586,'recommend',1524),(1587,'depend',1537),(1587,'recommend',1538),(1587,'recommend',1539),(1588,'depend',1552),(1588,'recommend',1553),(1588,'recommend',1554),(1589,'depend',1567),(1589,'recommend',1568),(1589,'recommend',1569),(1615,'depend',558),(1615,'recommend',1616),(1615,'recommend',1617),(1615,'recommend',1618),(1616,'depend',558),(1616,'recommend',1615),(1616,'recommend',1617),(1616,'recommend',1618),(1617,'depend',558),(1617,'recommend',1615),(1617,'recommend',1616),(1617,'recommend',1618),(1618,'depend',558),(1618,'recommend',1615),(1618,'recommend',1616),(1618,'recommend',1617),(1619,'depend',558),(1620,'depend',558),(1621,'depend',1620),(1622,'depend',1623),(1624,'depend',1622),(1624,'recommend',1625),(1624,'recommend',1626),(1624,'recommend',1627),(1625,'depend',1622),(1625,'recommend',1624),(1625,'recommend',1626),(1625,'recommend',1627),(1626,'depend',1622),(1626,'recommend',1624),(1626,'recommend',1625),(1626,'recommend',1627),(1627,'depend',1622),(1627,'recommend',1624),(1627,'recommend',1625),(1627,'recommend',1626),(1628,'depend',1623),(1631,'depend',1623),(1632,'depend',1623),(1633,'depend',1623),(1634,'depend',1623),(1635,'depend',1623),(1636,'depend',1623),(1637,'depend',1623),(1638,'depend',1623),(1639,'depend',1623),(1640,'depend',1623),(1641,'depend',1623),(1642,'depend',1623),(1643,'depend',1623),(1644,'depend',1623),(1645,'depend',1623),(1649,'depend',1648),(1649,'recommend',1650),(1649,'recommend',1651),(1650,'depend',1648),(1650,'recommend',1649),(1650,'recommend',1651),(1651,'depend',1648),(1651,'recommend',1649),(1651,'recommend',1650),(1652,'depend',1648),(1654,'depend',1653),(1654,'recommend',1655),(1654,'recommend',1656),(1655,'depend',1653),(1655,'recommend',1654),(1655,'recommend',1656),(1656,'depend',1653),(1656,'recommend',1654),(1656,'recommend',1655),(1664,'depend',652),(1664,'depend',656),(1664,'depend',682),(1673,'depend',421),(1673,'recommend',1674),(1673,'recommend',1676),(1673,'recommend',1677),(1674,'depend',421),(1674,'recommend',1673),(1674,'recommend',1676),(1674,'recommend',1677),(1675,'depend',421),(1676,'depend',421),(1676,'recommend',1673),(1676,'recommend',1674),(1676,'recommend',1677),(1677,'depend',421),(1677,'recommend',1673),(1677,'recommend',1674),(1677,'recommend',1676),(1679,'recommend',451),(1682,'recommend',430),(1694,'depend',1051),(1694,'recommend',1047),(1695,'depend',1646),(1701,'recommend',1702),(1701,'recommend',1711),(1701,'recommend',1715),(1701,'recommend',1716),(1701,'recommend',1717),(1702,'recommend',1701),(1702,'recommend',1711),(1702,'recommend',1715),(1702,'recommend',1716),(1702,'recommend',1717),(1703,'depend',1702),(1703,'recommend',1704),(1703,'recommend',1705),(1703,'recommend',1766),(1704,'depend',1702),(1704,'recommend',1703),(1704,'recommend',1705),(1704,'recommend',1766),(1705,'depend',1702),(1705,'recommend',1703),(1705,'recommend',1704),(1705,'recommend',1766),(1706,'recommend',1707),(1706,'recommend',1718),(1707,'recommend',1706),(1707,'recommend',1718),(1709,'recommend',1710),(1709,'recommend',1714),(1710,'recommend',1709),(1710,'recommend',1714),(1711,'recommend',1701),(1711,'recommend',1702),(1711,'recommend',1703),(1711,'recommend',1704),(1711,'recommend',1705),(1711,'recommend',1715),(1711,'recommend',1716),(1711,'recommend',1717),(1711,'recommend',1723),(1711,'recommend',1724),(1711,'recommend',1766),(1714,'recommend',1709),(1714,'recommend',1710),(1715,'recommend',1701),(1715,'recommend',1702),(1715,'recommend',1711),(1715,'recommend',1716),(1715,'recommend',1717),(1716,'recommend',1701),(1716,'recommend',1702),(1716,'recommend',1711),(1716,'recommend',1715),(1716,'recommend',1717),(1717,'recommend',1701),(1717,'recommend',1702),(1717,'recommend',1711),(1717,'recommend',1715),(1717,'recommend',1716),(1718,'recommend',1706),(1718,'recommend',1707),(1719,'recommend',1720),(1719,'recommend',1721),(1720,'recommend',1719),(1720,'recommend',1721),(1721,'recommend',1719),(1721,'recommend',1720),(1723,'depend',1711),(1724,'depend',1711),(1725,'depend',1702),(1726,'depend',1715),(1727,'depend',1716),(1728,'depend',1717),(1740,'depend',1739),(1745,'depend',1744),(1745,'recommend',1746),(1746,'depend',1744),(1746,'recommend',1745),(1747,'depend',1744),(1748,'depend',1744),(1748,'recommend',1749),(1748,'recommend',1755),(1748,'recommend',1756),(1749,'depend',1744),(1749,'recommend',1748),(1749,'recommend',1755),(1749,'recommend',1756),(1750,'depend',1744),(1751,'depend',1744),(1751,'recommend',1752),(1751,'recommend',1753),(1752,'depend',1744),(1752,'recommend',1751),(1752,'recommend',1753),(1753,'depend',1744),(1753,'recommend',1751),(1753,'recommend',1752),(1754,'depend',1744),(1755,'depend',1744),(1755,'recommend',1748),(1755,'recommend',1749),(1755,'recommend',1756),(1756,'depend',1744),(1756,'recommend',1748),(1756,'recommend',1749),(1756,'recommend',1755),(1757,'depend',1744),(1758,'depend',1744),(1758,'recommend',1759),(1759,'depend',1744),(1759,'recommend',1758),(1760,'depend',1744),(1761,'depend',1744),(1765,'depend',1744),(1766,'depend',1702),(1766,'recommend',1703),(1766,'recommend',1704),(1766,'recommend',1705),(2062,'depend',2061),(2062,'recommend',2063),(2062,'recommend',2065),(2063,'depend',2061),(2063,'depend',2064),(2063,'depend',2067),(2063,'recommend',2062),(2063,'recommend',2065),(2064,'depend',2061),(2065,'depend',2061),(2065,'depend',2064),(2066,'depend',2061),(2066,'depend',2064),(2066,'depend',2067),(2067,'depend',2061),(2067,'depend',2064),(2068,'recommend',2070),(2068,'recommend',2071),(2069,'depend',2068),(2069,'recommend',2070),(2069,'recommend',2071),(2069,'recommend',2072),(2070,'depend',2068),(2070,'depend',2071),(2070,'recommend',2069),(2070,'recommend',2072),(2071,'depend',2068),(2071,'recommend',2070),(2071,'recommend',2072),(2071,'recommend',2073),(2071,'recommend',2074),(2072,'depend',2068),(2072,'depend',2071),(2072,'recommend',2069),(2072,'recommend',2070),(2072,'recommend',2073),(2073,'depend',2068),(2073,'depend',2071),(2073,'recommend',2069),(2073,'recommend',2070),(2073,'recommend',2072),(2074,'depend',2068),(2074,'depend',2071),(2074,'recommend',2069),(2074,'recommend',2070),(2075,'recommend',2079),(2076,'depend',2075),(2076,'depend',2079),(2076,'recommend',2077),(2076,'recommend',2078),(2076,'recommend',2080),(2076,'recommend',2081),(2076,'recommend',2083),(2076,'recommend',2084),(2077,'depend',2075),(2077,'depend',2079),(2077,'recommend',2076),(2078,'depend',2075),(2078,'recommend',2077),(2078,'recommend',2080),(2079,'depend',2075),(2079,'recommend',2076),(2079,'recommend',2078),(2079,'recommend',2080),(2079,'recommend',2081),(2079,'recommend',2082),(2079,'recommend',2083),(2079,'recommend',2084),(2080,'depend',2075),(2080,'recommend',2076),(2080,'recommend',2078),(2080,'recommend',2092),(2080,'recommend',2093),(2081,'depend',2075),(2081,'depend',2079),(2081,'recommend',2076),(2081,'recommend',2077),(2081,'recommend',2078),(2081,'recommend',2080),(2081,'recommend',2092),(2081,'recommend',2093),(2082,'depend',2075),(2082,'depend',2079),(2082,'recommend',2076),(2082,'recommend',2077),(2082,'recommend',2078),(2082,'recommend',2080),(2082,'recommend',2081),(2082,'recommend',2092),(2082,'recommend',2093),(2083,'depend',2075),(2083,'depend',2079),(2083,'recommend',2076),(2083,'recommend',2077),(2083,'recommend',2078),(2083,'recommend',2080),(2083,'recommend',2081),(2083,'recommend',2092),(2083,'recommend',2093),(2084,'depend',2075),(2084,'depend',2079),(2084,'recommend',2076),(2084,'recommend',2077),(2084,'recommend',2078),(2084,'recommend',2080),(2084,'recommend',2081),(2084,'recommend',2092),(2084,'recommend',2093),(2085,'recommend',2075),(2085,'recommend',2079),(2086,'depend',2075),(2086,'depend',2088),(2086,'depend',2090),(2087,'depend',2075),(2087,'recommend',2089),(2087,'recommend',2090),(2088,'depend',2075),(2088,'recommend',2089),(2088,'recommend',2090),(2089,'depend',2075),(2090,'depend',2075),(2091,'depend',2075),(2091,'depend',2079),(2092,'depend',2075),(2092,'depend',2079),(2092,'recommend',2076),(2092,'recommend',2077),(2092,'recommend',2078),(2092,'recommend',2080),(2092,'recommend',2093),(2093,'depend',2075),(2093,'depend',2079),(2093,'recommend',2076),(2093,'recommend',2077),(2093,'recommend',2078),(2093,'recommend',2080),(2093,'recommend',2092),(2094,'depend',2075),(2094,'depend',2079),(2094,'recommend',2076),(2094,'recommend',2077),(2094,'recommend',2078),(2094,'recommend',2080),(2095,'recommend',2096),(2095,'recommend',2098),(2095,'recommend',2099),(2096,'depend',2095),(2096,'recommend',2097),(2096,'recommend',2099),(2097,'depend',2095),(2097,'depend',2096),(2097,'recommend',2103),(2097,'recommend',2104),(2098,'depend',2095),(2098,'depend',2096),(2098,'recommend',2099),(2099,'depend',2095),(2099,'depend',2096),(2099,'recommend',2098),(2100,'depend',2095),(2100,'depend',2096),(2100,'recommend',2102),(2101,'depend',2095),(2101,'depend',2096),(2102,'depend',2095),(2102,'depend',2096),(2102,'recommend',2100),(2103,'depend',2095),(2103,'depend',2096),(2103,'recommend',2104),(2104,'depend',2095),(2104,'depend',2096),(2104,'recommend',2103);

INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'hourPoint',   '0');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRProduct',   '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRExecution', '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'URSR', '2');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', 'global', 'mode', 'ALM');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'unitList', 'CNY,USD');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'defaultCurrency', 'CNY');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'story', '', 'reviewRules', 'allpass');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', 'global', 'syncProduct', '{"feedback":{},"ticket":{}}');
-- DROP TABLE IF EXISTS `zt_im_chat`;
CREATE TABLE IF NOT EXISTS `zt_im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `ownedBy` varchar(30) NOT NULL DEFAULT '',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `mergedDate` datetime NULL,
  `lastActiveTime` datetime NULL,
  `lastMessage` int(11) unsigned NOT NULL DEFAULT 0,
  `lastMessageIndex` int(11) unsigned NOT NULL DEFAULT 0,
  `dismissDate` datetime NULL,
  `pinnedMessages` text NULL,
  `mergedChats` text NULL,
  `adminInvite` enum('0','1') NOT NULL DEFAULT '0',
  `avatar` text NULL,
  `archiveDate` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chatuser`;
CREATE TABLE IF NOT EXISTS `zt_im_chatuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0', '1') NOT NULL DEFAULT '0',
  `hide` enum('0', '1') NOT NULL DEFAULT '0',
  `mute` enum('0', '1') NOT NULL DEFAULT '0',
  `freeze` enum('0', '1') NOT NULL DEFAULT '0',
  `join` datetime NULL,
  `quit` datetime NULL,
  `category` varchar(40) NOT NULL DEFAULT '',
  `lastReadMessage` int(11) unsigned NOT NULL DEFAULT 0,
  `lastReadMessageIndex` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `chatuser` ON `zt_im_chatuser`(`cgid`, `user`);

-- DROP TABLE IF EXISTS `zt_im_client`;
CREATE TABLE IF NOT EXISTS `zt_im_client` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` char(30) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `changeLog` text NULL,
  `strategy` varchar(10) NOT NULL DEFAULT '',
  `downloads` text NULL,
  `createdDate` datetime NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `status` enum('released','wait') NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message`;
CREATE TABLE IF NOT EXISTS `zt_im_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NULL,
  `index` int(11) unsigned NOT NULL DEFAULT 0,
  `type` enum('normal','broadcast','notify','bulletin','botcommand') NOT NULL DEFAULT 'normal',
  `content` text NULL,
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message_backup`;
CREATE TABLE IF NOT EXISTS `zt_im_message_backup` (
  `id` int(11) unsigned NOT NULL DEFAULT '0',
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NULL,
  `index` int(11) unsigned NOT NULL DEFAULT 0,
  `type` enum('normal', 'broadcast', 'notify') NOT NULL DEFAULT 'normal',
  `content` text NULL,
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message_index`;
CREATE TABLE IF NOT EXISTS `zt_im_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tableName` char(64) NOT NULL DEFAULT '',
  `start` int(11) unsigned NOT NULL DEFAULT '0',
  `end` int(11) unsigned NOT NULL DEFAULT '0',
  `startDate` datetime NULL,
  `endDate` datetime NULL,
  `chats` text NULL,
  PRIMARY KEY (`id`),
  KEY `tableName` (`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chat_message_index`;
CREATE TABLE IF NOT EXISTS `zt_im_chat_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `tableName` char(64) NOT NULL DEFAULT '',
  `start` int(11) unsigned NOT NULL DEFAULT '0',
  `end` int(11) unsigned NOT NULL DEFAULT '0',
  `startIndex` int(11) unsigned NOT NULL DEFAULT '0',
  `endIndex` int(11) unsigned NOT NULL DEFAULT '0',
  `startDate` datetime NULL,
  `endDate` datetime NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`),
  KEY `chatstartindex` (`gid`,`startIndex`),
  KEY `chatendindex` (`gid`,`endIndex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `chattable` ON `zt_im_chat_message_index`(`gid`,`tableName`);

-- DROP TABLE IF EXISTS `zt_im_messagestatus`;
CREATE TABLE IF NOT EXISTS `zt_im_messagestatus` (
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `message` int(11) unsigned NOT NULL DEFAULT '0',
  `status` enum('waiting','sent','readed','deleted') NOT NULL DEFAULT 'waiting'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `user` ON `zt_im_messagestatus`(`user`,`message`);

-- DROP TABLE IF EXISTS `zt_im_queue`;
CREATE TABLE IF NOT EXISTS `zt_im_queue` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `type` char(30) NOT NULL DEFAULT '',
  `content` text NULL,
  `addDate` datetime NULL,
  `processDate` datetime NULL,
  `result` text NULL,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conference`;
CREATE TABLE IF NOT EXISTS `zt_im_conference` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `status` enum('closed','open') NOT NULL DEFAULT 'closed',
  `participants` text NULL,
  `invitee` text NULL,
  `openedBy` mediumint(8) NOT NULL DEFAULT 0,
  `openedDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conferenceaction`;
CREATE TABLE IF NOT EXISTS `zt_im_conferenceaction` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(40) NOT NULL DEFAULT '',
  `type` enum('create','invite','join','leave','close','publish') NOT NULL DEFAULT 'create',
  `data` text NULL,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `date` datetime NULL,
  `device` char(40) NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_userdevice`;
CREATE TABLE IF NOT EXISTS `zt_im_userdevice` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `device` char(40) NOT NULL DEFAULT 'default',
  `deviceID` char(40) NOT NULL DEFAULT '',
  `token` char(64) NOT NULL DEFAULT '',
  `validUntil` datetime NULL,
  `lastLogin` datetime NULL,
  `lastLogout` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`),
  KEY `lastLogin` (`lastLogin`),
  KEY `lastLogout` (`lastLogout`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `userdevice` ON `zt_im_userdevice`(`user`, `device`);

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`) VALUES ('30', '23', '*', '*', '*', 'moduleName=execution&methodName=computeTaskEffort', '计算任务剩余工时', 'zentao', '1', 'normal');
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`) VALUES ('30', '7', '*', '*', '*', 'moduleName=effort&methodName=remindNotRecord', '提醒录入日志', 'zentao', '1', 'stop');

 -- DROP TABLE IF EXISTS `zt_relationoftasks`;
CREATE TABLE IF NOT EXISTS `zt_relationoftasks` (
  `id` MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `execution` MEDIUMINT(8) UNSIGNED NOT NULL ,
  `pretask` MEDIUMINT(8) UNSIGNED NOT NULL ,
  `condition` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  `task` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `action` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`execution`,`task`)
) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;

-- DROP TABLE IF EXISTS `zt_report`;
CREATE TABLE IF NOT EXISTS `zt_report` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL DEFAULT '',
  `name` text NULL,
  `dimension` int(8) NOT NULL default 0,
  `module` varchar(100) NOT NULL DEFAULT '',
  `sql` text NULL,
  `vars` text NULL,
  `langs` text NULL,
  `params` text NULL,
  `step` tinyint(1) NOT NULL DEFAULT '2',
  `desc` text NULL,
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `code` ON `zt_report`(`code`);

-- DROP VIEW IF EXISTS `ztv_executionsummary`;
CREATE OR REPLACE VIEW `ztv_executionsummary` AS select `zt_task`.`execution` AS `execution`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`estimate`,0)) AS `estimate`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0)) AS `consumed`,sum(if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` <> 'done') and (`zt_task`.`status` <> 'closed')),1,0)) AS `undone`,sum(if(`zt_task`.`parent` >= '0',`zt_task`.`consumed`,0) + if(`zt_task`.`status` <> 'cancel' and `zt_task`.`status` <> 'closed' and `zt_task`.`parent` >= '0',`zt_task`.`left`,0)) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`execution`;
-- DROP VIEW IF EXISTS `ztv_projectsummary`;
CREATE OR REPLACE VIEW `ztv_projectsummary` AS select `zt_task`.`project` AS `project`,sum(if(`zt_task`.`parent` >= '0',`zt_task`.`estimate`,0)) AS `estimate`,sum(if(`zt_task`.`parent` >= '0',`zt_task`.`consumed`,0)) AS `consumed`,sum(if((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0'),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` <> 'done') and (`zt_task`.`status` <> 'closed')),1,0)) AS `undone`,sum(if(`zt_task`.`parent` >= '0',`zt_task`.`consumed`,0) + if(`zt_task`.`status` <> 'cancel' and `zt_task`.`status` <> 'closed' and `zt_task`.`parent` >= '0',`zt_task`.`left`,0)) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`project`;
-- DROP VIEW IF EXISTS `ztv_projectstories`;
CREATE OR REPLACE VIEW `ztv_projectstories` AS select `t1`.`project` AS `execution`,count('*') AS `stories`,sum(if((`t2`.`status` = 'closed'),0,1)) AS `undone` from ((`zt_projectstory` `t1` left join `zt_story` `t2` on((`t1`.`story` = `t2`.`id`))) left join `zt_project` `t3` on((`t1`.`project` = `t3`.`id`))) where ((`t2`.`deleted` = '0') and (`t3`.`type` in ('sprint','stage'))) group by `t1`.`project`;
-- DROP VIEW IF EXISTS `ztv_projectteams`;
CREATE OR REPLACE VIEW `ztv_projectteams` AS select `zt_team`.`root` AS `execution`,count('*') AS `teams` from `zt_team` where (`zt_team`.`type` = 'execution') group by `zt_team`.`root`;
-- DROP VIEW IF EXISTS `ztv_projectbugs`;
CREATE OR REPLACE VIEW `ztv_projectbugs` AS select `zt_bug`.`execution` AS `execution`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`execution`;
-- DROP VIEW IF EXISTS `ztv_productbugs`;
CREATE OR REPLACE VIEW `ztv_productbugs` AS select `zt_bug`.`product` AS `product`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`product`;
-- DROP VIEW IF EXISTS `ztv_productstories`;
CREATE OR REPLACE VIEW `ztv_productstories` AS select `zt_story`.`product` AS `product`,count('*') AS `stories`,sum(if((`zt_story`.`status` = 'closed'),0,1)) AS `undone` from `zt_story` where (`zt_story`.`deleted` = '0') group by `zt_story`.`product`;
-- DROP VIEW IF EXISTS `ztv_dayuserlogin`;
CREATE OR REPLACE VIEW `ztv_dayuserlogin` AS select count(*) AS `userlogin`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'user') and (`zt_action`.`action` = 'login')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_dayeffort`;
CREATE OR REPLACE VIEW `ztv_dayeffort` AS select round(sum(`zt_effort`.`consumed`),1) AS `consumed`,`zt_effort`.`date` AS `date` from `zt_effort` group by `zt_effort`.`date`;
-- DROP VIEW IF EXISTS `ztv_daystoryopen`;
CREATE OR REPLACE VIEW `ztv_daystoryopen` AS select count(*) AS `storyopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_daystoryclose`;
CREATE OR REPLACE VIEW `ztv_daystoryclose` AS select count(*) AS `storyclose`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'closed')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_daytaskopen`;
CREATE OR REPLACE VIEW `ztv_daytaskopen` AS select count(*) AS `taskopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_daytaskfinish`;
CREATE OR REPLACE VIEW `ztv_daytaskfinish` AS select count(*) AS `taskfinish`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'finished')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_daybugopen`;
CREATE OR REPLACE VIEW `ztv_daybugopen` AS select count(*) AS `bugopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_daybugresolve`;
CREATE OR REPLACE VIEW `ztv_daybugresolve` AS select count(*) AS `bugresolve`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'resolved')) group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_dayactions`;
CREATE OR REPLACE VIEW `ztv_dayactions` AS select count(*) AS `actions`,left(`zt_action`.`date`,10) AS `day` from `zt_action` group by left(`zt_action`.`date`,10);
-- DROP VIEW IF EXISTS `ztv_normalproduct`;
CREATE OR REPLACE VIEW `ztv_normalproduct` AS SELECT * FROM `zt_product` WHERE `shadow` = 0;

-- DROP TABLE IF EXISTS `zt_feedback`;
CREATE TABLE IF NOT EXISTS `zt_feedback` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `solution` char(30) NOT NULL DEFAULT '',
  `desc` text NULL,
  `pri` tinyint unsigned NOT NULL DEFAULT 2,
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL default '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `source` varchar(255) NOT NULL DEFAULT '',
  `likes` text NULL,
  `result` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `faq` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  `processedBy` char(30) NOT NULL DEFAULT '',
  `processedDate` datetime NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `repeatFeedback` mediumint(8) NOT NULL DEFAULT 0,
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_ticket`;
CREATE TABLE IF NOT EXISTS `zt_ticket` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `feedback` mediumint(8) NOT NULL DEFAULT '0',
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `realStarted` datetime NULL,
  `startedBy` varchar(255) NOT NULL DEFAULT '',
  `startedDate` datetime NULL,
  `deadline` date NULL,
  `pri` tinyint unsigned NOT NULL DEFAULT '0',
  `estimate` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `activatedCount` int(10) NOT NULL DEFAULT '0',
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime NULL,
  `resolution` text NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `repeatTicket` mediumint(8) NOT NULL DEFAULT '0',
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `product` (`product`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_ticketsource`;
CREATE TABLE IF NOT EXISTS `zt_ticketsource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `customer` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  PRIMARY KEY (`id`),
  key `ticketId` (`ticketId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_ticketrelation`;
CREATE TABLE IF NOT EXISTS `zt_ticketrelation` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` mediumint unsigned NOT NULL DEFAULT '0',
  `objectId` mediumint NOT NULL DEFAULT '0',
  `objectType` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_feedbackview`;
CREATE TABLE IF NOT EXISTS `zt_feedbackview` (
  `account` char(30) NOT NULL DEFAULT '',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `account_product` ON `zt_feedbackview`(`account`,`product`);

-- DROP TABLE IF EXISTS `zt_serverroom`;
CREATE TABLE IF NOT EXISTS `zt_serverroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `city` varchar(128) NOT NULL DEFAULT '',
  `line` varchar(20) NOT NULL DEFAULT '',
  `bandwidth` varchar(128) NOT NULL DEFAULT '',
  `provider` varchar(128) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_account`;
CREATE TABLE IF NOT EXISTS `zt_account` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `provider` varchar(255) NOT NULL DEFAULT '',
  `adminURI` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `extra` text NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `name` (`name`),
  key `provider` (`provider`),
  key `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_host`;
CREATE TABLE `zt_host` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `hostType` varchar(30) NOT NULL DEFAULT '',
  `mac` varchar(128) NOT NULL DEFAULT '',
  `memory` varchar(30) NOT NULL DEFAULT '',
  `diskSize` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT '',
  `secret` varchar(50) NOT NULL DEFAULT '',
  `desc` text NULL,
  `tokenSN` varchar(50) NOT NULL DEFAULT '',
  `tokenTime` datetime NULL,
  `oldTokenSN` varchar(50) NOT NULL DEFAULT '',
  `vsoft` varchar(30) NOT NULL DEFAULT '',
  `heartbeat` datetime NULL,
  `zap` varchar(10) NOT NULL DEFAULT '',
  `provider` varchar(255) NOT NULL DEFAULT '',
  `vnc` int(11) NOT NULL DEFAULT '0',
  `ztf` int(11) NOT NULL DEFAULT '0',
  `zd` int(11) NOT NULL DEFAULT '0',
  `ssh` int(11) NOT NULL DEFAULT '0',
  `parent` int(11) unsigned NOT NULL DEFAULT '0',
  `image` int(11) unsigned NOT NULL DEFAULT '0',
  `admin` smallint(5) unsigned NOT NULL DEFAULT '0',
  `serverRoom` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `serverModel` varchar(256) NOT NULL DEFAULT '',
  `hardwareType` varchar(64) NOT NULL DEFAULT '',
  `cpuBrand` varchar(128) NOT NULL DEFAULT '',
  `cpuModel` varchar(128) NOT NULL DEFAULT '',
  `cpuNumber` varchar(16) NOT NULL DEFAULT '',
  `cpuCores` varchar(30) NOT NULL DEFAULT '',
  `intranet` varchar(128) NOT NULL DEFAULT '',
  `extranet` varchar(128) NOT NULL DEFAULT '',
  `osName` varchar(64) NOT NULL DEFAULT '',
  `osVersion` varchar(64) NOT NULL DEFAULT '',
  `group` varchar(128) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_image`;
CREATE TABLE `zt_image` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `host` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(64) NOT NULL DEFAULT '',
  `localName` varchar(64) NOT NULL DEFAULT '',
  `address` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(64) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `osName` varchar(32) NOT NULL DEFAULT '',
  `from` varchar(10) NOT NULL DEFAULT 'zentao',
  `memory` float unsigned NOT NULL,
  `disk` float unsigned NOT NULL,
  `fileSize` float unsigned NOT NULL,
  `md5` varchar(64) NOT NULL DEFAULT '',
  `desc` text NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `restoreDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_automation`;
CREATE TABLE `zt_automation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `node` int(11) unsigned NOT NULL DEFAULT 0,
  `product` int(11) unsigned NOT NULL DEFAULT 0,
  `scriptPath` varchar(255) NOT NULL DEFAULT '',
  `shell` mediumtext NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_service`;
CREATE TABLE IF NOT EXISTS `zt_service` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `external` enum('0','1') NOT NULL DEFAULT '0',
  `port` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entry` varchar(255) NOT NULL DEFAULT '',
  `deploy` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(64) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `dept` varchar(128) NOT NULL DEFAULT '',
  `devel` varchar(30) NOT NULL DEFAULT '',
  `qa` varchar(30) NOT NULL DEFAULT '',
  `ops` varchar(30) NOT NULL DEFAULT '',
  `hosts` text NULL,
  `softName` varchar(128) NOT NULL DEFAULT '',
  `softVersion` varchar(128) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_attend`;
CREATE TABLE IF NOT EXISTS `zt_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `date` date NULL,
  `signIn` time NULL,
  `signOut` time NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `device` varchar(30) NOT NULL DEFAULT '',
  `client` varchar(20) NOT NULL DEFAULT '',
  `manualIn` time NULL,
  `manualOut` time NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text NULL,
  `reviewStatus` varchar(30) NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `attend` ON `zt_attend`(`date`,`account`);
-- DROP TABLE IF EXISTS `zt_attendstat`;
CREATE TABLE IF NOT EXISTS `zt_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `attend` ON `zt_attendstat`(`month`,`account`);
-- DROP TABLE IF EXISTS `zt_overtime`;
CREATE TABLE IF NOT EXISTS `zt_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  `level` tinyint(3) NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_leave`;
CREATE TABLE IF NOT EXISTS `zt_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  `level` tinyint(3) NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text NULL,
  `backReviewers` text NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lieu`;
CREATE TABLE IF NOT EXISTS `zt_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL DEFAULT '',
  `trip` char(255) NOT NULL DEFAULT '',
  `desc` text NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime NULL,
  `level` tinyint(3) NOT NULL DEFAULT '0',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_trip`;
CREATE TABLE IF NOT EXISTS `zt_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip', 'egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `desc` text NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date NULL,
  `end` date NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `from` char(50) NOT NULL DEFAULT '',
  `to` char(50) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_deploy`;
CREATE TABLE IF NOT EXISTS `zt_deploy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime NULL,
  `end` datetime NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL DEFAULT '',
  `members` text NULL,
  `notify` text NULL,
  `cases` text NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `result` varchar(20) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deployproduct`;
CREATE TABLE IF NOT EXISTS `zt_deployproduct` (
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `release` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `package` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `deploy_product_release` ON `zt_deployproduct`(`deploy`,`product`,`release`);
-- DROP TABLE IF EXISTS `zt_deploystep`;
CREATE TABLE IF NOT EXISTS `zt_deploystep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime NULL,
  `end` datetime NULL,
  `stage` varchar(30) NOT NULL DEFAULT '',
  `content` text NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NULL,
  `finishedBy` char(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deployscope`;
CREATE TABLE IF NOT EXISTS `zt_deployscope` (
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `service` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `hosts` text NULL,
  `remove` text NULL,
  `add` text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincourse`;
CREATE TABLE IF NOT EXISTS `zt_traincourse` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `category` mediumint(8) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `teacher` varchar(30) NOT NULL default '',
  `desc` mediumtext NULL,
  `createdBy` varchar(255) NOT NULL DEFAULT '',
  `createdDate` date NULL,
  `editedBy` varchar(255) NOT NULL DEFAULT '',
  `editedDate` date NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincontents`;
CREATE TABLE IF NOT EXISTS `zt_traincontents` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `course` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `desc` text NULL,
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincategory`;
CREATE TABLE IF NOT EXISTS `zt_traincategory` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) NOT NULL DEFAULT '0',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_trainrecords`;
CREATE TABLE IF NOT EXISTS `zt_trainrecords` (
  `user` char(30) NOT NULL DEFAULT '',
  `objectId` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`user`, `objectId`, `objectType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_faq`;
CREATE TABLE IF NOT EXISTS `zt_faq` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
`module` mediumint(9) NOT NULL DEFAULT '0',
`product` mediumint(9) NOT NULL DEFAULT '0',
`question` varchar(255) NOT NULL DEFAULT '',
`answer` text NULL,
`addedtime` datetime NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_domain`;
CREATE TABLE IF NOT EXISTS `zt_domain`(
  `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL DEFAULT '',
  `adminURI` varchar(255) NOT NULL DEFAULT '',
  `resolverURI` varchar(255) NOT NULL DEFAULT '',
  `register` varchar(255) NOT NULL DEFAULT '',
  `expiredDate` datetime NULL,
  `renew` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP VIEW IF EXISTS `view_datasource_5`;
CREATE VIEW `view_datasource_5`  AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'rnd';

DROP VIEW IF EXISTS `view_datasource_54`;
CREATE VIEW `view_datasource_54` AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'lite';

UPDATE `zt_user` SET `visions` = 'lite', `feedback` = '0' WHERE `feedback` = '1';

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,	'account',	'browse'),
(1,	'account',	'create'),
(1,	'account',	'delete'),
(1,	'account',	'edit'),
(1,	'account',	'view'),
(1,	'action',	'comment'),
(1,	'action',	'editComment'),
(1,	'action',	'hideAll'),
(1,	'action',	'hideOne'),
(1,	'action',	'trash'),
(1,	'action',	'undelete'),
(1,	'activity',	'assignTo'),
(1,	'activity',	'batchCreate'),
(1,	'activity',	'browse'),
(1,	'activity',	'create'),
(1,	'activity',	'delete'),
(1,	'activity',	'edit'),
(1,	'activity',	'outputList'),
(1,	'activity',	'updateOrder'),
(1,	'activity',	'view'),
(1,	'admin',	'checkDB'),
(1,	'admin',	'checkWeak'),
(1,	'admin',	'index'),
(1,	'admin',	'register'),
(1,	'admin',	'safe'),
(1,	'admin',	'sso'),
(1,	'admin',	'ztCompany'),
(1,	'api',	'debug'),
(1,	'api',	'getModel'),
(1,	'api',	'sql'),
(1,	'apppriv',	'flow'),
(1,	'assetlib',	'approveComponent'),
(1,	'assetlib',	'approveIssue'),
(1,	'assetlib',	'approveOpportunity'),
(1,	'assetlib',	'approvePractice'),
(1,	'assetlib',	'approveRisk'),
(1,	'assetlib',	'approveStory'),
(1,	'assetlib',	'assignToComponent'),
(1,	'assetlib',	'assignToIssue'),
(1,	'assetlib',	'assignToOpportunity'),
(1,	'assetlib',	'assignToPractice'),
(1,	'assetlib',	'assignToRisk'),
(1,	'assetlib',	'assignToStory'),
(1,	'assetlib',	'batchApproveComponent'),
(1,	'assetlib',	'batchApproveIssue'),
(1,	'assetlib',	'batchApproveOpportunity'),
(1,	'assetlib',	'batchApprovePractice'),
(1,	'assetlib',	'batchApproveRisk'),
(1,	'assetlib',	'batchApproveStory'),
(1,	'assetlib',	'batchAssignToComponent'),
(1,	'assetlib',	'batchAssignToIssue'),
(1,	'assetlib',	'batchAssignToOpportunity'),
(1,	'assetlib',	'batchAssignToPractice'),
(1,	'assetlib',	'batchAssignToRisk'),
(1,	'assetlib',	'batchAssignToStory'),
(1,	'assetlib',	'batchRemoveComponent'),
(1,	'assetlib',	'batchRemoveIssue'),
(1,	'assetlib',	'batchRemoveOpportunity'),
(1,	'assetlib',	'batchRemovePractice'),
(1,	'assetlib',	'batchRemoveRisk'),
(1,	'assetlib',	'batchRemoveStory'),
(1,	'assetlib',	'caselib'),
(1,	'assetlib',	'component'),
(1,	'assetlib',	'componentlib'),
(1,	'assetlib',	'componentLibView'),
(1,	'assetlib',	'componentView'),
(1,	'assetlib',	'createComponentlib'),
(1,	'assetlib',	'createIssuelib'),
(1,	'assetlib',	'createOpportunitylib'),
(1,	'assetlib',	'createPracticelib'),
(1,	'assetlib',	'createRisklib'),
(1,	'assetlib',	'createStorylib'),
(1,	'assetlib',	'deleteComponentlib'),
(1,	'assetlib',	'deleteIssuelib'),
(1,	'assetlib',	'deleteOpportunitylib'),
(1,	'assetlib',	'deletePracticelib'),
(1,	'assetlib',	'deleteRisklib'),
(1,	'assetlib',	'deleteStorylib'),
(1,	'assetlib',	'editComponent'),
(1,	'assetlib',	'editComponentlib'),
(1,	'assetlib',	'editIssue'),
(1,	'assetlib',	'editIssuelib'),
(1,	'assetlib',	'editOpportunity'),
(1,	'assetlib',	'editOpportunitylib'),
(1,	'assetlib',	'editPractice'),
(1,	'assetlib',	'editPracticelib'),
(1,	'assetlib',	'editRisk'),
(1,	'assetlib',	'editRisklib'),
(1,	'assetlib',	'editStory'),
(1,	'assetlib',	'editStorylib'),
(1,	'assetlib',	'importComponent'),
(1,	'assetlib',	'importIssue'),
(1,	'assetlib',	'importOpportunity'),
(1,	'assetlib',	'importPractice'),
(1,	'assetlib',	'importRisk'),
(1,	'assetlib',	'importStory'),
(1,	'assetlib',	'issue'),
(1,	'assetlib',	'issuelib'),
(1,	'assetlib',	'issueLibView'),
(1,	'assetlib',	'issueView'),
(1,	'assetlib',	'opportunity'),
(1,	'assetlib',	'opportunitylib'),
(1,	'assetlib',	'opportunityLibView'),
(1,	'assetlib',	'opportunityView'),
(1,	'assetlib',	'practice'),
(1,	'assetlib',	'practicelib'),
(1,	'assetlib',	'practiceLibView'),
(1,	'assetlib',	'practiceView'),
(1,	'assetlib',	'removeComponent'),
(1,	'assetlib',	'removeIssue'),
(1,	'assetlib',	'removeOpportunity'),
(1,	'assetlib',	'removePractice'),
(1,	'assetlib',	'removeRisk'),
(1,	'assetlib',	'removeStory'),
(1,	'assetlib',	'risk'),
(1,	'assetlib',	'risklib'),
(1,	'assetlib',	'riskLibView'),
(1,	'assetlib',	'riskView'),
(1,	'assetlib',	'story'),
(1,	'assetlib',	'storylib'),
(1,	'assetlib',	'storyLibView'),
(1,	'assetlib',	'storyView'),
(1,	'assetlib',	'view'),
(1,	'attend',	'browseReview'),
(1,	'attend',	'company'),
(1,	'attend',	'department'),
(1,	'attend',	'detail'),
(1,	'attend',	'edit'),
(1,	'attend',	'export'),
(1,	'attend',	'exportDetail'),
(1,	'attend',	'exportStat'),
(1,	'attend',	'personal'),
(1,	'attend',	'personalSettings'),
(1,	'attend',	'review'),
(1,	'attend',	'saveStat'),
(1,	'attend',	'setManager'),
(1,	'attend',	'settings'),
(1,	'attend',	'stat'),
(1,	'audit',	'8'),
(1,	'audit',	'assign'),
(1,	'audit',	'batchassign'),
(1,	'audit',	'batchcreate'),
(1,	'audit',	'batchedit'),
(1,	'audit',	'browse'),
(1,	'audit',	'create'),
(1,	'audit',	'delete'),
(1,	'audit',	'edit'),
(1,	'audit',	'export'),
(1,	'audit',	'exporttemplate'),
(1,	'audit',	'import'),
(1,	'audit',	'link'),
(1,	'audit',	'search'),
(1,	'audit',	'showimport'),
(1,	'audit',	'unlink'),
(1,	'audit',	'view'),
(1,	'auditcl',	'batchCreate'),
(1,	'auditcl',	'batchEdit'),
(1,	'auditcl',	'browse'),
(1,	'auditcl',	'delete'),
(1,	'auditcl',	'edit'),
(1,	'auditplan',	'batchCheck'),
(1,	'auditplan',	'batchCreate'),
(1,	'auditplan',	'browse'),
(1,	'auditplan',	'check'),
(1,	'auditplan',	'create'),
(1,	'auditplan',	'edit'),
(1,	'auditplan',	'nc'),
(1,	'auditplan',	'result'),
(1,	'auditresult',	'10'),
(1,	'auditresult',	'assign'),
(1,	'auditresult',	'batchassign'),
(1,	'auditresult',	'batchcreate'),
(1,	'auditresult',	'batchedit'),
(1,	'auditresult',	'browse'),
(1,	'auditresult',	'create'),
(1,	'auditresult',	'delete'),
(1,	'auditresult',	'edit'),
(1,	'auditresult',	'export'),
(1,	'auditresult',	'exporttemplate'),
(1,	'auditresult',	'import'),
(1,	'auditresult',	'link'),
(1,	'auditresult',	'search'),
(1,	'auditresult',	'showimport'),
(1,	'auditresult',	'unlink'),
(1,	'auditresult',	'view'),
(1,	'automation',	'browse'),
(1,	'backup',	'backup'),
(1,	'backup',	'change'),
(1,	'backup',	'delete'),
(1,	'backup',	'index'),
(1,	'backup',	'restore'),
(1,	'backup',	'rmPHPHeader'),
(1,	'backup',	'setting'),
(1,	'baseline',	'articleview'),
(1,	'baseline',	'catalog'),
(1,	'baseline',	'createTemplate'),
(1,	'baseline',	'delete'),
(1,	'baseline',	'editBook'),
(1,	'baseline',	'editTemplate'),
(1,	'baseline',	'manageBook'),
(1,	'baseline',	'template'),
(1,	'baseline',	'view'),
(1,	'bookborrow',	'59'),
(1,	'bookborrow',	'62'),
(1,	'bookborrow',	'assign'),
(1,	'bookborrow',	'batchassign'),
(1,	'bookborrow',	'batchcreate'),
(1,	'bookborrow',	'batchedit'),
(1,	'bookborrow',	'browse'),
(1,	'bookborrow',	'create'),
(1,	'bookborrow',	'delete'),
(1,	'bookborrow',	'edit'),
(1,	'bookborrow',	'export'),
(1,	'bookborrow',	'exporttemplate'),
(1,	'bookborrow',	'import'),
(1,	'bookborrow',	'link'),
(1,	'bookborrow',	'return'),
(1,	'bookborrow',	'search'),
(1,	'bookborrow',	'showimport'),
(1,	'bookborrow',	'unlink'),
(1,	'bookborrow',	'view'),
(1,	'branch',	'delete'),
(1,	'branch',	'manage'),
(1,	'branch',	'sort'),
(1,	'budget',	'batchCreate'),
(1,	'budget',	'browse'),
(1,	'budget',	'create'),
(1,	'budget',	'delete'),
(1,	'budget',	'edit'),
(1,	'budget',	'summary'),
(1,	'budget',	'view'),
(1,	'bug',	'activate'),
(1,	'bug',	'assignTo'),
(1,	'bug',	'batchActivate'),
(1,	'bug',	'batchAssignTo'),
(1,	'bug',	'batchChangeBranch'),
(1,	'bug',	'batchChangeModule'),
(1,	'bug',	'batchClose'),
(1,	'bug',	'batchConfirm'),
(1,	'bug',	'batchCreate'),
(1,	'bug',	'batchEdit'),
(1,	'bug',	'batchResolve'),
(1,	'bug',	'browse'),
(1,	'bug',	'close'),
(1,	'bug',	'confirmBug'),
(1,	'bug',	'confirmStoryChange'),
(1,	'bug',	'create'),
(1,	'bug',	'delete'),
(1,	'bug',	'edit'),
(1,	'bug',	'export'),
(1,	'bug',	'exportTemplet'),
(1,	'bug',	'import'),
(1,	'bug',	'index'),
(1,	'bug',	'linkBugs'),
(1,	'bug',	'report'),
(1,	'bug',	'resolve'),
(1,	'bug',	'showImport'),
(1,	'bug',	'view'),
(1,	'build',	'batchUnlinkBug'),
(1,	'build',	'batchUnlinkStory'),
(1,	'build',	'browse'),
(1,	'build',	'create'),
(1,	'build',	'delete'),
(1,	'build',	'edit'),
(1,	'build',	'linkBug'),
(1,	'build',	'linkStory'),
(1,	'build',	'unlinkBug'),
(1,	'build',	'unlinkStory'),
(1,	'build',	'view'),
(1,	'caselib',	'batchCreateCase'),
(1,	'caselib',	'browse'),
(1,	'caselib',	'create'),
(1,	'caselib',	'createCase'),
(1,	'caselib',	'delete'),
(1,	'caselib',	'edit'),
(1,	'caselib',	'exportTemplet'),
(1,	'caselib',	'import'),
(1,	'caselib',	'index'),
(1,	'caselib',	'justtest'),
(1,	'caselib',	'showImport'),
(1,	'caselib',	'view'),
(1,	'ci',	'checkCompileStatus'),
(1,	'ci',	'commitResult'),
(1,	'classify',	'browse'),
(1,	'cm',	'browse'),
(1,	'cm',	'create'),
(1,	'cm',	'delete'),
(1,	'cm',	'edit'),
(1,	'cm',	'report'),
(1,	'cm',	'view'),
(1,	'cmcl',	'batchCreate'),
(1,	'cmcl',	'browse'),
(1,	'cmcl',	'delete'),
(1,	'cmcl',	'edit'),
(1,	'cmcl',	'view'),
(1,	'company',	'alleffort'),
(1,	'company',	'allTodo'),
(1,	'company',	'browse'),
(1,	'company',	'calendar'),
(1,	'company',	'dynamic'),
(1,	'company',	'edit'),
(1,	'company',	'effort'),
(1,	'company',	'index'),
(1,	'company',	'todo'),
(1,	'company',	'view'),
(1,	'compile',	'browse'),
(1,	'compile',	'logs'),
(1,	'convert',	'checkBugFree'),
(1,	'convert',	'checkConfig'),
(1,	'convert',	'checkRedmine'),
(1,	'convert',	'convertBugFree'),
(1,	'convert',	'convertRedmine'),
(1,	'convert',	'execute'),
(1,	'convert',	'index'),
(1,	'convert',	'selectSource'),
(1,	'convert',	'setBugfree'),
(1,	'convert',	'setConfig'),
(1,	'convert',	'setRedmine'),
(1,	'cron',	'create'),
(1,	'cron',	'delete'),
(1,	'cron',	'edit'),
(1,	'cron',	'index'),
(1,	'cron',	'openProcess'),
(1,	'cron',	'toggle'),
(1,	'cron',	'turnon'),
(1,	'custom',	'browseStoryConcept'),
(1,	'custom',	'deleteStoryConcept'),
(1,	'custom',	'editStoryConcept'),
(1,	'custom',	'estimate'),
(1,	'custom',	'execution'),
(1,	'custom',	'feedback'),
(1,	'custom',	'flow'),
(1,	'custom',	'hours'),
(1,	'custom',	'index'),
(1,	'custom',	'libreoffice'),
(1,	'custom',	'product'),
(1,	'custom',	'project'),
(1,	'custom',	'restore'),
(1,	'custom',	'set'),
(1,	'custom',	'setDefaultConcept'),
(1,	'custom',	'setPublic'),
(1,	'custom',	'setStoryConcept'),
(1,	'custom',	'timezone'),
(1,	'custom',	'working'),
(1,	'datatable',	'setGlobal'),
(1,	'deploy',	'activate'),
(1,	'deploy',	'assignTo'),
(1,	'deploy',	'batchUnlinkCases'),
(1,	'deploy',	'browse'),
(1,	'deploy',	'cases'),
(1,	'deploy',	'create'),
(1,	'deploy',	'delete'),
(1,	'deploy',	'deleteStep'),
(1,	'deploy',	'edit'),
(1,	'deploy',	'editStep'),
(1,	'deploy',	'finish'),
(1,	'deploy',	'finishStep'),
(1,	'deploy',	'linkCases'),
(1,	'deploy',	'manageScope'),
(1,	'deploy',	'manageStep'),
(1,	'deploy',	'scope'),
(1,	'deploy',	'steps'),
(1,	'deploy',	'unlinkCase'),
(1,	'deploy',	'view'),
(1,	'deploy',	'viewStep'),
(1,	'dept',	'browse'),
(1,	'dept',	'delete'),
(1,	'dept',	'edit'),
(1,	'dept',	'manageChild'),
(1,	'dept',	'updateOrder'),
(1,	'design',	'assignTo'),
(1,	'design',	'batchCreate'),
(1,	'design',	'browse'),
(1,	'design',	'create'),
(1,	'design',	'delete'),
(1,	'design',	'edit'),
(1,	'design',	'linkCommit'),
(1,	'design',	'revision'),
(1,	'design',	'unlinkCommit'),
(1,	'design',	'view'),
(1,	'design',	'viewCommit'),
(1,	'dev',	'api'),
(1,	'dev',	'db'),
(1,	'dev',	'editor'),
(1,	'dev',	'translate'),
(1,	'doc',	'allLibs'),
(1,	'doc',	'catalog'),
(1,	'doc',	'collect'),
(1,	'doc',	'create'),
(1,	'doc',	'createLib'),
(1,	'doc',	'delete'),
(1,	'doc',	'deleteFile'),
(1,	'doc',	'deleteLib'),
(1,	'doc',	'diff'),
(1,	'doc',	'edit'),
(1,	'doc',	'editLib'),
(1,	'doc',	'importToComponentLib'),
(1,	'doc',	'importToPracticeLib'),
(1,	'doc',	'index'),
(1,	'doc',	'manageBook'),
(1,	'doc',	'myCollection'),
(1,	'doc',	'myCreation'),
(1,	'doc',	'myEdited'),
(1,	'doc',	'mySpace'),
(1,	'doc',	'myView'),
(1,	'doc',	'productSpace'),
(1,	'doc',	'projectSpace'),
(1,	'doc',	'showFiles'),
(1,	'doc',	'teamSpace'),
(1,	'doc',	'view'),
(1,	'domain',	'browse'),
(1,	'domain',	'create'),
(1,	'domain',	'delete'),
(1,	'domain',	'edit'),
(1,	'domain',	'view'),
(1,	'durationestimation',	'create'),
(1,	'durationestimation',	'index'),
(1,	'effort',	'batchCreate'),
(1,	'effort',	'batchEdit'),
(1,	'effort',	'calendar'),
(1,	'effort',	'createForObject'),
(1,	'effort',	'delete'),
(1,	'effort',	'edit'),
(1,	'effort',	'export'),
(1,	'effort',	'view'),
(1,	'execution',	'activate'),
(1,	'execution',	'addWhitelist'),
(1,	'execution',	'all'),
(1,	'execution',	'batchedit'),
(1,	'execution',	'batchUnlinkStory'),
(1,	'execution',	'browse'),
(1,	'execution',	'bug'),
(1,	'execution',	'build'),
(1,	'execution',	'burn'),
(1,	'execution',	'burnData'),
(1,	'execution',	'calendar'),
(1,	'execution',	'close'),
(1,	'execution',	'computeBurn'),
(1,	'execution',	'computeTaskEffort'),
(1,	'execution',	'create'),
(1,	'execution',	'delete'),
(1,	'execution',	'deleterelation'),
(1,	'execution',	'doc'),
(1,	'execution',	'dynamic'),
(1,	'execution',	'edit'),
(1,	'execution',	'effort'),
(1,	'execution',	'effortCalendar'),
(1,	'execution',	'executionkanban'),
(1,	'execution',	'export'),
(1,	'execution',	'fixFirst'),
(1,	'execution',	'gantt'),
(1,	'execution',	'grouptask'),
(1,	'execution',	'importBug'),
(1,	'execution',	'importplanstories'),
(1,	'execution',	'importtask'),
(1,	'execution',	'index'),
(1,	'execution',	'kanban'),
(1,	'execution',	'linkStory'),
(1,	'execution',	'maintainrelation'),
(1,	'execution',	'manageMembers'),
(1,	'execution',	'manageProducts'),
(1,	'execution',	'printKanban'),
(1,	'execution',	'putoff'),
(1,	'execution',	'relation'),
(1,	'execution',	'start'),
(1,	'execution',	'story'),
(1,	'execution',	'storyEstimate'),
(1,	'execution',	'storyKanban'),
(1,	'execution',	'storySort'),
(1,	'execution',	'storyView'),
(1,	'execution',	'suspend'),
(1,	'execution',	'task'),
(1,	'execution',	'taskEffort'),
(1,	'execution',	'team'),
(1,	'execution',	'testcase'),
(1,	'execution',	'testreport'),
(1,	'execution',	'testtask'),
(1,	'execution',	'tree'),
(1,	'execution',	'treeStory'),
(1,	'execution',	'treeTask'),
(1,	'execution',	'unbindWhitelist'),
(1,	'execution',	'unlinkMember'),
(1,	'execution',	'unlinkStory'),
(1,	'execution',	'updateOrder'),
(1,	'execution',	'view'),
(1,	'execution',	'whitelist'),
(1,	'extension',	'activate'),
(1,	'extension',	'browse'),
(1,	'extension',	'deactivate'),
(1,	'extension',	'erase'),
(1,	'extension',	'install'),
(1,	'extension',	'obtain'),
(1,	'extension',	'structure'),
(1,	'extension',	'uninstall'),
(1,	'extension',	'upgrade'),
(1,	'extension',	'upload'),
(1,	'faq',	'browse'),
(1,	'faq',	'create'),
(1,	'faq',	'delete'),
(1,	'faq',	'edit'),
(1,	'feedback',	'admin'),
(1,	'feedback',	'adminView'),
(1,	'feedback',	'assignTo'),
(1,	'feedback',	'batchAssignTo'),
(1,	'feedback',	'batchChangeModule'),
(1,	'feedback',	'batchClose'),
(1,	'feedback',	'batchEdit'),
(1,	'feedback',	'batchReview'),
(1,	'feedback',	'browse'),
(1,	'feedback',	'close'),
(1,	'feedback',	'comment'),
(1,	'feedback',	'create'),
(1,	'feedback',	'delete'),
(1,	'feedback',	'edit'),
(1,	'feedback',	'export'),
(1,	'feedback',	'index'),
(1,	'feedback',	'manageProduct'),
(1,	'feedback',	'products'),
(1,	'feedback',	'review'),
(1,	'feedback',	'view'),
(1,	'file',	'delete'),
(1,	'file',	'download'),
(1,	'file',	'edit'),
(1,	'file',	'setPublic'),
(1,	'file',	'uploadImages'),
(1,	'gapanalysis',	'batchCreate'),
(1,	'gapanalysis',	'batchEdit'),
(1,	'gapanalysis',	'browse'),
(1,	'gapanalysis',	'create'),
(1,	'gapanalysis',	'delete'),
(1,	'gapanalysis',	'edit'),
(1,	'gapanalysis',	'view'),
(1,	'git',	'apiSync'),
(1,	'git',	'cat'),
(1,	'git',	'diff'),
(1,	'gitlab',	'bindProduct'),
(1,	'gitlab',	'bindUser'),
(1,	'gitlab',	'browse'),
(1,	'gitlab',	'create'),
(1,	'gitlab',	'delete'),
(1,	'gitlab',	'edit'),
(1,	'gitlab',	'importIssue'),
(1,	'group',	'browse'),
(1,	'group',	'copy'),
(1,	'group',	'create'),
(1,	'group',	'delete'),
(1,	'group',	'edit'),
(1,	'group',	'manageMember'),
(1,	'group',	'managePriv'),
(1,	'group',	'manageProjectAdmin'),
(1,	'group',	'manageView'),
(1,	'holiday',	'browse'),
(1,	'holiday',	'create'),
(1,	'holiday',	'delete'),
(1,	'holiday',	'edit'),
(1,	'host',	'browse'),
(1,	'host',	'changeStatus'),
(1,	'host',	'create'),
(1,	'host',	'delete'),
(1,	'host',	'edit'),
(1,	'host',	'treemap'),
(1,	'host',	'view'),
(1,	'index',	'index'),
(1,	'investigation',	'126'),
(1,	'investigation',	'assign'),
(1,	'investigation',	'batchassign'),
(1,	'investigation',	'batchcreate'),
(1,	'investigation',	'batchedit'),
(1,	'investigation',	'browse'),
(1,	'investigation',	'create'),
(1,	'investigation',	'delete'),
(1,	'investigation',	'edit'),
(1,	'investigation',	'export'),
(1,	'investigation',	'exporttemplate'),
(1,	'investigation',	'import'),
(1,	'investigation',	'investigationreport_create'),
(1,	'investigation',	'link'),
(1,	'investigation',	'report'),
(1,	'investigation',	'search'),
(1,	'investigation',	'showimport'),
(1,	'investigation',	'unlink'),
(1,	'investigation',	'view'),
(1,	'investigationreport',	'129'),
(1,	'investigationreport',	'assign'),
(1,	'investigationreport',	'batchassign'),
(1,	'investigationreport',	'batchcreate'),
(1,	'investigationreport',	'batchedit'),
(1,	'investigationreport',	'browse'),
(1,	'investigationreport',	'create'),
(1,	'investigationreport',	'delete'),
(1,	'investigationreport',	'edit'),
(1,	'investigationreport',	'export'),
(1,	'investigationreport',	'exporttemplate'),
(1,	'investigationreport',	'import'),
(1,	'investigationreport',	'link'),
(1,	'investigationreport',	'report'),
(1,	'investigationreport',	'search'),
(1,	'investigationreport',	'showimport'),
(1,	'investigationreport',	'unlink'),
(1,	'investigationreport',	'view'),
(1,	'issue',	'activate'),
(1,	'issue',	'assignTo'),
(1,	'issue',	'batchCreate'),
(1,	'issue',	'batchImportToLib'),
(1,	'issue',	'browse'),
(1,	'issue',	'cancel'),
(1,	'issue',	'close'),
(1,	'issue',	'confirm'),
(1,	'issue',	'create'),
(1,	'issue',	'delete'),
(1,	'issue',	'edit'),
(1,	'issue',	'importFromLib'),
(1,	'issue',	'importToLib'),
(1,	'issue',	'resolve'),
(1,	'issue',	'view'),
(1,	'jenkins',	'browse'),
(1,	'jenkins',	'create'),
(1,	'jenkins',	'delete'),
(1,	'jenkins',	'edit'),
(1,	'job',	'browse'),
(1,	'job',	'create'),
(1,	'job',	'delete'),
(1,	'job',	'edit'),
(1,	'job',	'exec'),
(1,	'job',	'view'),
(1,	'ldap',	'index'),
(1,	'ldap',	'set'),
(1,	'leave',	'back'),
(1,	'leave',	'browseReview'),
(1,	'leave',	'company'),
(1,	'leave',	'create'),
(1,	'leave',	'delete'),
(1,	'leave',	'edit'),
(1,	'leave',	'export'),
(1,	'leave',	'personal'),
(1,	'leave',	'personalAnnual'),
(1,	'leave',	'review'),
(1,	'leave',	'setReviewer'),
(1,	'leave',	'switchstatus'),
(1,	'leave',	'view'),
(1,	'library',	'58'),
(1,	'library',	'60'),
(1,	'library',	'61'),
(1,	'library',	'assign'),
(1,	'library',	'batchassign'),
(1,	'library',	'batchcreate'),
(1,	'library',	'batchedit'),
(1,	'library',	'browse'),
(1,	'library',	'create'),
(1,	'library',	'delete'),
(1,	'library',	'edit'),
(1,	'library',	'export'),
(1,	'library',	'exporttemplate'),
(1,	'library',	'import'),
(1,	'library',	'link'),
(1,	'library',	'review'),
(1,	'library',	'search'),
(1,	'library',	'setarea'),
(1,	'library',	'setcategory'),
(1,	'library',	'showimport'),
(1,	'library',	'unlink'),
(1,	'library',	'view'),
(1,	'lieu',	'browseReview'),
(1,	'lieu',	'company'),
(1,	'lieu',	'create'),
(1,	'lieu',	'delete'),
(1,	'lieu',	'edit'),
(1,	'lieu',	'personal'),
(1,	'lieu',	'review'),
(1,	'lieu',	'setReviewer'),
(1,	'lieu',	'switchstatus'),
(1,	'lieu',	'view'),
(1,	'mail',	'batchDelete'),
(1,	'mail',	'browse'),
(1,	'mail',	'delete'),
(1,	'mail',	'detect'),
(1,	'mail',	'edit'),
(1,	'mail',	'index'),
(1,	'mail',	'resend'),
(1,	'mail',	'reset'),
(1,	'mail',	'save'),
(1,	'mail',	'sendCloud'),
(1,	'mail',	'sendcloudUser'),
(1,	'mail',	'test'),
(1,	'mail',	'ztCloud'),
(1,	'makeup',	'browseReview'),
(1,	'makeup',	'company'),
(1,	'makeup',	'create'),
(1,	'makeup',	'delete'),
(1,	'makeup',	'edit'),
(1,	'makeup',	'export'),
(1,	'makeup',	'personal'),
(1,	'makeup',	'review'),
(1,	'makeup',	'setReviewer'),
(1,	'makeup',	'switchstatus'),
(1,	'makeup',	'view'),
(1,	'measrecord',	'browse'),
(1,	'measurement',	'batchEdit'),
(1,	'measurement',	'browse'),
(1,	'measurement',	'createBasic'),
(1,	'measurement',	'createTemplate'),
(1,	'measurement',	'delete'),
(1,	'measurement',	'design'),
(1,	'measurement',	'designPHP'),
(1,	'measurement',	'designSQL'),
(1,	'measurement',	'editBasic'),
(1,	'measurement',	'editDerivation'),
(1,	'measurement',	'editTemplate'),
(1,	'measurement',	'execCrontabQueue'),
(1,	'measurement',	'initCrontabQueue'),
(1,	'measurement',	'searchMeas'),
(1,	'measurement',	'setSQL'),
(1,	'measurement',	'settips'),
(1,	'measurement',	'template'),
(1,	'measurement',	'viewTemplate'),
(1,	'meeting',	'browse'),
(1,	'meeting',	'create'),
(1,	'meeting',	'delete'),
(1,	'meeting',	'edit'),
(1,	'meeting',	'minutes'),
(1,	'meeting',	'view'),
(1,	'meetingroom',	'batchCreate'),
(1,	'meetingroom',	'batchEdit'),
(1,	'meetingroom',	'browse'),
(1,	'meetingroom',	'create'),
(1,	'meetingroom',	'delete'),
(1,	'meetingroom',	'edit'),
(1,	'meetingroom',	'view'),
(1,	'message',	'browser'),
(1,	'message',	'index'),
(1,	'message',	'setting'),
(1,	'metting',	'127'),
(1,	'metting',	'130'),
(1,	'metting',	'131'),
(1,	'metting',	'assign'),
(1,	'metting',	'batchassign'),
(1,	'metting',	'batchcreate'),
(1,	'metting',	'batchedit'),
(1,	'metting',	'browse'),
(1,	'metting',	'create'),
(1,	'metting',	'delete'),
(1,	'metting',	'edit'),
(1,	'metting',	'export'),
(1,	'metting',	'exporttemplate'),
(1,	'metting',	'import'),
(1,	'metting',	'link'),
(1,	'metting',	'report'),
(1,	'metting',	'search'),
(1,	'metting',	'showimport'),
(1,	'metting',	'summary'),
(1,	'metting',	'unlink'),
(1,	'metting',	'view'),
(1,	'milestone',	'index'),
(1,	'milestone',	'saveOtherProblem'),
(1,	'misc',	'ping'),
(1,	'my',	'bug'),
(1,	'my',	'calendar'),
(1,	'my',	'changePassword'),
(1,	'my',	'contribute'),
(1,	'my',	'deleteContacts'),
(1,	'my',	'doc'),
(1,	'my',	'dynamic'),
(1,	'my',	'editProfile'),
(1,	'my',	'effort'),
(1,	'my',	'execution'),
(1,	'my',	'index'),
(1,	'my',	'issue'),
(1,	'my',	'manageContacts'),
(1,	'my',	'meeting'),
(1,	'my',	'myMeeting'),
(1,	'my',	'nc'),
(1,	'my',	'preference'),
(1,	'my',	'profile'),
(1,	'my',	'project'),
(1,	'my',	'review'),
(1,	'my',	'risk'),
(1,	'my',	'score'),
(1,	'my',	'story'),
(1,	'my',	'task'),
(1,	'my',	'team'),
(1,	'my',	'testcase'),
(1,	'my',	'testtask'),
(1,	'my',	'todo'),
(1,	'my',	'unbind'),
(1,	'my',	'uploadAvatar'),
(1,	'my',	'work'),
(1,	'nc',	'16'),
(1,	'nc',	'activate'),
(1,	'nc',	'assign'),
(1,	'nc',	'batchassign'),
(1,	'nc',	'batchcreate'),
(1,	'nc',	'batchedit'),
(1,	'nc',	'browse'),
(1,	'nc',	'close'),
(1,	'nc',	'create'),
(1,	'nc',	'delete'),
(1,	'nc',	'edit'),
(1,	'nc',	'export'),
(1,	'nc',	'exporttemplate'),
(1,	'nc',	'import'),
(1,	'nc',	'link'),
(1,	'nc',	'resolve'),
(1,	'nc',	'search'),
(1,	'nc',	'showimport'),
(1,	'nc',	'unlink'),
(1,	'nc',	'view'),
(1,	'opportunity',	'activate'),
(1,	'opportunity',	'assignTo'),
(1,	'opportunity',	'batchActivate'),
(1,	'opportunity',	'batchAssignTo'),
(1,	'opportunity',	'batchCancel'),
(1,	'opportunity',	'batchClose'),
(1,	'opportunity',	'batchCreate'),
(1,	'opportunity',	'batchEdit'),
(1,	'opportunity',	'batchHangup'),
(1,	'opportunity',	'batchImportToLib'),
(1,	'opportunity',	'browse'),
(1,	'opportunity',	'cancel'),
(1,	'opportunity',	'close'),
(1,	'opportunity',	'create'),
(1,	'opportunity',	'delete'),
(1,	'opportunity',	'edit'),
(1,	'opportunity',	'hangup'),
(1,	'opportunity',	'importFromLib'),
(1,	'opportunity',	'importToLib'),
(1,	'opportunity',	'track'),
(1,	'opportunity',	'view'),
(1,	'ops',	'index'),
(1,	'ops',	'setting'),
(1,	'output',	'13'),
(1,	'output',	'assign'),
(1,	'output',	'batchassign'),
(1,	'output',	'batchcreate'),
(1,	'output',	'batchedit'),
(1,	'output',	'browse'),
(1,	'output',	'create'),
(1,	'output',	'delete'),
(1,	'output',	'edit'),
(1,	'output',	'export'),
(1,	'output',	'exporttemplate'),
(1,	'output',	'import'),
(1,	'output',	'link'),
(1,	'output',	'search'),
(1,	'output',	'showimport'),
(1,	'output',	'unlink'),
(1,	'output',	'view'),
(1,	'overtime',	'browseReview'),
(1,	'overtime',	'company'),
(1,	'overtime',	'create'),
(1,	'overtime',	'delete'),
(1,	'overtime',	'edit'),
(1,	'overtime',	'export'),
(1,	'overtime',	'personal'),
(1,	'overtime',	'review'),
(1,	'overtime',	'setReviewer'),
(1,	'overtime',	'switchstatus'),
(1,	'overtime',	'view'),
(1,	'personnel',	'accessible'),
(1,	'personnel',	'addWhitelist'),
(1,	'personnel',	'invest'),
(1,	'personnel',	'unbindWhitelist'),
(1,	'personnel',	'whitelist'),
(1,	'pivot',	'browse'),
(1,	'pivot',	'bugAssign'),
(1,	'pivot',	'bugAssignSummary'),
(1,	'pivot',	'bugCreate'),
(1,	'pivot',	'bugSummary'),
(1,	'pivot',	'build'),
(1,	'pivot',	'casesrun'),
(1,	'pivot',	'create'),
(1,	'pivot',	'delete'),
(1,	'pivot',	'design'),
(1,	'pivot',	'edit'),
(1,	'pivot',	'export'),
(1,	'pivot',	'preview'),
(1,	'pivot',	'productSummary'),
(1,	'pivot',	'projectDeviation'),
(1,	'pivot',	'projectSummary'),
(1,	'pivot',	'projectWorkload'),
(1,	'pivot',	'reportExport'),
(1,	'pivot',	'roadmap'),
(1,	'pivot',	'storyLinkedBug'),
(1,	'pivot',	'testcase'),
(1,	'pivot',	'workAssignSummary'),
(1,	'pivot',	'workload'),
(1,	'pivot',	'workSummary'),
(1,	'process',	'activityList'),
(1,	'process',	'batchCreate'),
(1,	'process',	'browse'),
(1,	'process',	'create'),
(1,	'process',	'delete'),
(1,	'process',	'edit'),
(1,	'process',	'updateOrder'),
(1,	'process',	'view'),
(1,	'product',	'addWhitelist'),
(1,	'product',	'all'),
(1,	'product',	'batchEdit'),
(1,	'product',	'browse'),
(1,	'product',	'build'),
(1,	'product',	'close'),
(1,	'product',	'create'),
(1,	'product',	'dashboard'),
(1,	'product',	'delete'),
(1,	'product',	'doc'),
(1,	'product',	'dynamic'),
(1,	'product',	'edit'),
(1,	'product',	'export'),
(1,	'product',	'index'),
(1,	'product',	'kanban'),
(1,	'product',	'manageLine'),
(1,	'product',	'project'),
(1,	'product',	'roadmap'),
(1,	'product',	'track'),
(1,	'product',	'unbindWhitelist'),
(1,	'product',	'updateOrder'),
(1,	'product',	'view'),
(1,	'product',	'whitelist'),
(1,	'productplan',	'batchEdit'),
(1,	'productplan',	'batchUnlinkBug'),
(1,	'productplan',	'batchUnlinkStory'),
(1,	'productplan',	'browse'),
(1,	'productplan',	'create'),
(1,	'productplan',	'delete'),
(1,	'productplan',	'edit'),
(1,	'productplan',	'linkBug'),
(1,	'productplan',	'linkStory'),
(1,	'productplan',	'unlinkBug'),
(1,	'productplan',	'unlinkStory'),
(1,	'productplan',	'view'),
(1,	'program',	'activate'),
(1,	'program',	'batchUnlinkStakeholders'),
(1,	'program',	'browse'),
(1,	'program',	'close'),
(1,	'program',	'create'),
(1,	'program',	'createStakeholder'),
(1,	'program',	'delete'),
(1,	'program',	'edit'),
(1,	'program',	'export'),
(1,	'program',	'index'),
(1,	'program',	'kanban'),
(1,	'program',	'product'),
(1,	'program',	'project'),
(1,	'program',	'stakeholder'),
(1,	'program',	'start'),
(1,	'program',	'suspend'),
(1,	'program',	'unbindWhitelist'),
(1,	'program',	'unlinkStakeholder'),
(1,	'program',	'updateOrder'),
(1,	'program',	'view'),
(1,	'programplan',	'browse'),
(1,	'programplan',	'create'),
(1,	'programplan',	'edit'),
(1,	'project',	'activate'),
(1,	'project',	'addWhitelist'),
(1,	'project',	'batchEdit'),
(1,	'project',	'browse'),
(1,	'project',	'bug'),
(1,	'project',	'build'),
(1,	'project',	'close'),
(1,	'project',	'copyGroup'),
(1,	'project',	'create'),
(1,	'project',	'createGroup'),
(1,	'project',	'createGuide'),
(1,	'project',	'createStakeholder'),
(1,	'project',	'delete'),
(1,	'project',	'dynamic'),
(1,	'project',	'edit'),
(1,	'project',	'editGroup'),
(1,	'project',	'execution'),
(1,	'project',	'export'),
(1,	'project',	'group'),
(1,	'project',	'index'),
(1,	'project',	'kanban'),
(1,	'project',	'manageGroupMember'),
(1,	'project',	'manageMembers'),
(1,	'project',	'managePriv'),
(1,	'project',	'manageProducts'),
(1,	'project',	'manageView'),
(1,	'project',	'programTitle'),
(1,	'project',	'qa'),
(1,	'project',	'start'),
(1,	'project',	'suspend'),
(1,	'project',	'team'),
(1,	'project',	'testcase'),
(1,	'project',	'testreport'),
(1,	'project',	'testtask'),
(1,	'project',	'unbindWhitelist'),
(1,	'project',	'unlinkMember'),
(1,	'project',	'updateOrder'),
(1,	'project',	'view'),
(1,	'project',	'whitelist'),
(1,	'projectbuild',	'browse'),
(1,	'projectrelease',	'batchUnlinkBug'),
(1,	'projectrelease',	'batchUnlinkStory'),
(1,	'projectrelease',	'browse'),
(1,	'projectrelease',	'changeStatus'),
(1,	'projectrelease',	'create'),
(1,	'projectrelease',	'delete'),
(1,	'projectrelease',	'edit'),
(1,	'projectrelease',	'export'),
(1,	'projectrelease',	'linkBug'),
(1,	'projectrelease',	'linkStory'),
(1,	'projectrelease',	'unlinkBug'),
(1,	'projectrelease',	'unlinkStory'),
(1,	'projectrelease',	'view'),
(1,	'projectstory',	'batchUnlinkStory'),
(1,	'projectstory',	'importFromLib'),
(1,	'projectstory',	'importplanstories'),
(1,	'projectstory',	'linkStory'),
(1,	'projectstory',	'story'),
(1,	'projectstory',	'track'),
(1,	'projectstory',	'unlinkStory'),
(1,	'projectstory',	'view'),
(1,	'pssp',	'browse'),
(1,	'pssp',	'update'),
(1,	'qa',	'index'),
(1,	'release',	'batchUnlinkBug'),
(1,	'release',	'batchUnlinkStory'),
(1,	'release',	'browse'),
(1,	'release',	'changeStatus'),
(1,	'release',	'create'),
(1,	'release',	'delete'),
(1,	'release',	'edit'),
(1,	'release',	'export'),
(1,	'release',	'linkBug'),
(1,	'release',	'linkStory'),
(1,	'release',	'unlinkBug'),
(1,	'release',	'unlinkStory'),
(1,	'release',	'view'),
(1,	'repo',	'addBug'),
(1,	'repo',	'addComment'),
(1,	'repo',	'blame'),
(1,	'repo',	'browse'),
(1,	'repo',	'create'),
(1,	'repo',	'delete'),
(1,	'repo',	'deleteBug'),
(1,	'repo',	'deleteComment'),
(1,	'repo',	'diff'),
(1,	'repo',	'download'),
(1,	'repo',	'edit'),
(1,	'repo',	'editBug'),
(1,	'repo',	'editComment'),
(1,	'repo',	'log'),
(1,	'repo',	'maintain'),
(1,	'repo',	'review'),
(1,	'repo',	'revision'),
(1,	'repo',	'setRules'),
(1,	'repo',	'showSyncCommit'),
(1,	'repo',	'view'),
(1,	'report',	'crystalExport'),
(1,	'report',	'custom'),
(1,	'report',	'customeredReport'),
(1,	'report',	'deleteReport'),
(1,	'report',	'editReport'),
(1,	'report',	'export'),
(1,	'report',	'viewReport'),
(1,	'report',	'saveReport'),
(1,	'report',	'show'),
(1,	'report',	'useReport'),
(1,	'requirement',	'activate'),
(1,	'requirement',	'assignTo'),
(1,	'requirement',	'batchAssignTo'),
(1,	'requirement',	'batchChangeBranch'),
(1,	'requirement',	'batchChangeModule'),
(1,	'requirement',	'batchClose'),
(1,	'requirement',	'batchCreate'),
(1,	'requirement',	'batchEdit'),
(1,	'requirement',	'batchReview'),
(1,	'requirement',	'change'),
(1,	'requirement',	'close'),
(1,	'requirement',	'create'),
(1,	'requirement',	'delete'),
(1,	'requirement',	'edit'),
(1,	'requirement',	'export'),
(1,	'requirement',	'recall'),
(1,	'requirement',	'report'),
(1,	'requirement',	'review'),
(1,	'requirement',	'view'),
(1,	'researchplan',	'browse'),
(1,	'researchplan',	'create'),
(1,	'researchplan',	'delete'),
(1,	'researchplan',	'edit'),
(1,	'researchplan',	'view'),
(1,	'researchreport',	'browse'),
(1,	'researchreport',	'create'),
(1,	'researchreport',	'delete'),
(1,	'researchreport',	'edit'),
(1,	'researchreport',	'view'),
(1,	'review',	'assess'),
(1,	'review',	'audit'),
(1,	'review',	'browse'),
(1,	'review',	'create'),
(1,	'review',	'edit'),
(1,	'review',	'recall'),
(1,	'review',	'report'),
(1,	'review',	'result'),
(1,	'review',	'submit'),
(1,	'review',	'toAudit'),
(1,	'review',	'view'),
(1,	'reviewcl',	'batchCreate'),
(1,	'reviewcl',	'browse'),
(1,	'reviewcl',	'create'),
(1,	'reviewcl',	'delete'),
(1,	'reviewcl',	'edit'),
(1,	'reviewcl',	'view'),
(1,	'reviewissue',	'create'),
(1,	'reviewissue',	'edit'),
(1,	'reviewissue',	'issue'),
(1,	'reviewissue',	'resolved'),
(1,	'reviewissue',	'updateStatus'),
(1,	'reviewissue',	'view'),
(1,	'reviewsetting',	'reviewer'),
(1,	'reviewsetting',	'version'),
(1,	'risk',	'activate'),
(1,	'risk',	'assignTo'),
(1,	'risk',	'batchCreate'),
(1,	'risk',	'batchImportToLib'),
(1,	'risk',	'browse'),
(1,	'risk',	'cancel'),
(1,	'risk',	'close'),
(1,	'risk',	'create'),
(1,	'risk',	'delete'),
(1,	'risk',	'edit'),
(1,	'risk',	'hangup'),
(1,	'risk',	'importFromLib'),
(1,	'risk',	'importToLib'),
(1,	'risk',	'track'),
(1,	'risk',	'view'),
(1,	'screen',	'allAnnualData'),
(1,	'screen',	'annualData'),
(1,	'screen',	'browse'),
(1,	'screen',	'create'),
(1,	'screen',	'delete'),
(1,	'screen',	'design'),
(1,	'screen',	'edit'),
(1,	'screen',	'release'),
(1,	'screen',	'view'),
(1,	'search',	'buildForm'),
(1,	'search',	'buildIndex'),
(1,	'search',	'buildQuery'),
(1,	'search',	'deleteQuery'),
(1,	'search',	'index'),
(1,	'search',	'saveQuery'),
(1,	'search',	'select'),
(1,	'serverroom',	'browse'),
(1,	'serverroom',	'create'),
(1,	'serverroom',	'delete'),
(1,	'serverroom',	'edit'),
(1,	'serverroom',	'view'),
(1,	'service',	'browse'),
(1,	'service',	'create'),
(1,	'service',	'delete'),
(1,	'service',	'edit'),
(1,	'service',	'index'),
(1,	'service',	'manage'),
(1,	'service',	'view'),
(1,	'sqlbuilder',	'browseSQLView'),
(1,	'sqlbuilder',	'create'),
(1,	'sqlbuilder',	'createSQLView'),
(1,	'sqlbuilder',	'deleteSQLView'),
(1,	'sqlbuilder',	'editSQLView'),
(1,	'stage',	'batchCreate'),
(1,	'stage',	'browse'),
(1,	'stage',	'create'),
(1,	'stage',	'delete'),
(1,	'stage',	'edit'),
(1,	'stage',	'setType'),
(1,	'stakeholder',	'batchCreate'),
(1,	'stakeholder',	'browse'),
(1,	'stakeholder',	'communicate'),
(1,	'stakeholder',	'create'),
(1,	'stakeholder',	'createExpect'),
(1,	'stakeholder',	'delete'),
(1,	'stakeholder',	'deleteExpect'),
(1,	'stakeholder',	'edit'),
(1,	'stakeholder',	'editExpect'),
(1,	'stakeholder',	'expect'),
(1,	'stakeholder',	'expectation'),
(1,	'stakeholder',	'issue'),
(1,	'stakeholder',	'plan'),
(1,	'stakeholder',	'userIssue'),
(1,	'stakeholder',	'view'),
(1,	'stakeholder',	'viewExpect'),
(1,	'stakeholder',	'viewIssue'),
(1,	'story',	'activate'),
(1,	'story',	'assignTo'),
(1,	'story',	'batchAssignTo'),
(1,	'story',	'batchChangeBranch'),
(1,	'story',	'batchChangeModule'),
(1,	'story',	'batchChangePlan'),
(1,	'story',	'batchChangeStage'),
(1,	'story',	'batchClose'),
(1,	'story',	'batchCreate'),
(1,	'story',	'batchEdit'),
(1,	'story',	'batchImportToLib'),
(1,	'story',	'batchReview'),
(1,	'story',	'batchToTask'),
(1,	'story',	'browse'),
(1,	'story',	'bugs'),
(1,	'story',	'cases'),
(1,	'story',	'change'),
(1,	'story',	'close'),
(1,	'story',	'create'),
(1,	'story',	'delete'),
(1,	'story',	'edit'),
(1,	'story',	'export'),
(1,	'story',	'exportTemplet'),
(1,	'story',	'import'),
(1,	'story',	'importToLib'),
(1,	'story',	'linkStory'),
(1,	'story',	'processStoryChange'),
(1,	'story',	'recall'),
(1,	'story',	'report'),
(1,	'story',	'review'),
(1,	'story',	'showImport'),
(1,	'story',	'tasks'),
(1,	'story',	'view'),
(1,	'subject',	'browse'),
(1,	'svn',	'apiSync'),
(1,	'svn',	'cat'),
(1,	'svn',	'diff'),
(1,	'task',	'activate'),
(1,	'task',	'assignTo'),
(1,	'task',	'batchAssignTo'),
(1,	'task',	'batchCancel'),
(1,	'task',	'batchChangeModule'),
(1,	'task',	'batchClose'),
(1,	'task',	'batchCreate'),
(1,	'task',	'batchEdit'),
(1,	'task',	'browse'),
(1,	'task',	'cancel'),
(1,	'task',	'close'),
(1,	'task',	'confirmdesignchange'),
(1,	'task',	'confirmStoryChange'),
(1,	'task',	'create'),
(1,	'task',	'delete'),
(1,	'task',	'deleteEstimate'),
(1,	'task',	'edit'),
(1,	'task',	'editEstimate'),
(1,	'task',	'export'),
(1,	'task',	'exportTemplet'),
(1,	'task',	'finish'),
(1,	'task',	'import'),
(1,	'task',	'pause'),
(1,	'task',	'recordEstimate'),
(1,	'task',	'report'),
(1,	'task',	'restart'),
(1,	'task',	'showImport'),
(1,	'task',	'start'),
(1,	'task',	'view'),
(1,	'testcase',	'batchCaseTypeChange'),
(1,	'testcase',	'batchChangeBranch'),
(1,	'testcase',	'batchChangeModule'),
(1,	'testcase',	'batchConfirmStoryChange'),
(1,	'testcase',	'batchCreate'),
(1,	'testcase',	'batchDelete'),
(1,	'testcase',	'batchEdit'),
(1,	'testcase',	'batchReview'),
(1,	'testcase',	'browse'),
(1,	'testcase',	'bugs'),
(1,	'testcase',	'confirmChange'),
(1,	'testcase',	'confirmLibcaseChange'),
(1,	'testcase',	'confirmStoryChange'),
(1,	'testcase',	'create'),
(1,	'testcase',	'createBug'),
(1,	'testcase',	'delete'),
(1,	'testcase',	'edit'),
(1,	'testcase',	'export'),
(1,	'testcase',	'exportTemplet'),
(1,	'testcase',	'groupCase'),
(1,	'testcase',	'ignoreLibcaseChange'),
(1,	'testcase',	'import'),
(1,	'testcase',	'importFromLib'),
(1,	'testcase',	'index'),
(1,	'testcase',	'linkCases'),
(1,	'testcase',	'review'),
(1,	'testcase',	'showImport'),
(1,	'testcase',	'submit'),
(1,	'testcase',	'view'),
(1,	'testcase',	'zeroCase'),
(1,	'testreport',	'browse'),
(1,	'testreport',	'create'),
(1,	'testreport',	'delete'),
(1,	'testreport',	'edit'),
(1,	'testreport',	'export'),
(1,	'testreport',	'view'),
(1,	'testsuite',	'batchUnlinkCases'),
(1,	'testsuite',	'browse'),
(1,	'testsuite',	'create'),
(1,	'testsuite',	'delete'),
(1,	'testsuite',	'edit'),
(1,	'testsuite',	'index'),
(1,	'testsuite',	'linkCase'),
(1,	'testsuite',	'test'),
(1,	'testsuite',	'unlinkCase'),
(1,	'testsuite',	'view'),
(1,	'testtask',	'activate'),
(1,	'testtask',	'batchAssign'),
(1,	'testtask',	'batchRun'),
(1,	'testtask',	'batchUnlinkCases'),
(1,	'testtask',	'block'),
(1,	'testtask',	'browse'),
(1,	'testtask',	'browseUnits'),
(1,	'testtask',	'cases'),
(1,	'testtask',	'close'),
(1,	'testtask',	'create'),
(1,	'testtask',	'delete'),
(1,	'testtask',	'deployCaseResults'),
(1,	'testtask',	'edit'),
(1,	'testtask',	'groupCase'),
(1,	'testtask',	'importUnitResult'),
(1,	'testtask',	'index'),
(1,	'testtask',	'linkcase'),
(1,	'testtask',	'report'),
(1,	'testtask',	'results'),
(1,	'testtask',	'runcase'),
(1,	'testtask',	'runDeployCase'),
(1,	'testtask',	'start'),
(1,	'testtask',	'unitCases'),
(1,	'testtask',	'unlinkcase'),
(1,	'testtask',	'view'),
(1,	'todo',	'activate'),
(1,	'todo',	'assignTo'),
(1,	'todo',	'batchClose'),
(1,	'todo',	'batchCreate'),
(1,	'todo',	'batchEdit'),
(1,	'todo',	'batchFinish'),
(1,	'todo',	'calendar'),
(1,	'todo',	'close'),
(1,	'todo',	'create'),
(1,	'todo',	'createcycle'),
(1,	'todo',	'delete'),
(1,	'todo',	'edit'),
(1,	'todo',	'export'),
(1,	'todo',	'finish'),
(1,	'todo',	'import2Today'),
(1,	'todo',	'start'),
(1,	'todo',	'view'),
(1,	'train',	'browse'),
(1,	'train',	'create'),
(1,	'train',	'delete'),
(1,	'train',	'edit'),
(1,	'train',	'finish'),
(1,	'train',	'summary'),
(1,	'train',	'view'),
(1,	'trainbook',	'ajaxgetbookbysn'),
(1,	'trainbook',	'export'),
(1,	'traincareer',	'index'),
(1,	'trainchapter',	'browse'),
(1,	'trainchapter',	'catalog'),
(1,	'trainchapter',	'delete'),
(1,	'trainchapter',	'download'),
(1,	'trainchapter',	'edit'),
(1,	'trainchapter',	'manage'),
(1,	'trainchapter',	'showDocFiles'),
(1,	'trainchapter',	'sortChapterOrder'),
(1,	'trainchapter',	'view'),
(1,	'traincourse',	'browse'),
(1,	'traincourse',	'changeStatus'),
(1,	'traincourse',	'collect'),
(1,	'traincourse',	'create'),
(1,	'traincourse',	'delete'),
(1,	'traincourse',	'edit'),
(1,	'traincourse',	'manage'),
(1,	'traincourse',	'view'),
(1,	'trainexam',	'browse'),
(1,	'trainexam',	'changeStatus'),
(1,	'trainexam',	'choseExam'),
(1,	'trainexam',	'create'),
(1,	'trainexam',	'delete'),
(1,	'trainexam',	'deleteQuestion'),
(1,	'trainexam',	'edit'),
(1,	'trainexam',	'editQuestion'),
(1,	'trainexam',	'exam'),
(1,	'trainexam',	'myExams'),
(1,	'trainexam',	'review'),
(1,	'trainexam',	'scoreDetail'),
(1,	'trainexam',	'setQuestion'),
(1,	'trainexam',	'updateOrder'),
(1,	'trainexam',	'view'),
(1,	'traingoal',	'browse'),
(1,	'traingoal',	'browseCompanyGoals'),
(1,	'traingoal',	'browseDeptGoals'),
(1,	'traingoal',	'create'),
(1,	'traingoal',	'delete'),
(1,	'traingoal',	'edit'),
(1,	'traingoal',	'recall'),
(1,	'traingoal',	'review'),
(1,	'traingoal',	'submitReview'),
(1,	'traingoal',	'updateOrder'),
(1,	'traingoal',	'view'),
(1,	'trainplan',	'batchCreate'),
(1,	'trainplan',	'batchEdit'),
(1,	'trainplan',	'batchFinish'),
(1,	'trainplan',	'browse'),
(1,	'trainplan',	'create'),
(1,	'trainplan',	'delete'),
(1,	'trainplan',	'edit'),
(1,	'trainplan',	'finish'),
(1,	'trainplan',	'summary'),
(1,	'trainplan',	'view'),
(1,	'trainpost',	'browse'),
(1,	'trainpost',	'create'),
(1,	'trainpost',	'createGrade'),
(1,	'trainpost',	'delete'),
(1,	'trainpost',	'edit'),
(1,	'trainpost',	'editGrade'),
(1,	'trainpost',	'gradeView'),
(1,	'trainpost',	'manageGrade'),
(1,	'trainpost',	'sortGrade'),
(1,	'trainpost',	'sortPost'),
(1,	'trainpost',	'view'),
(1,	'trainskill',	'browse'),
(1,	'trainskill',	'create'),
(1,	'trainskill',	'createGrade'),
(1,	'trainskill',	'delete'),
(1,	'trainskill',	'deleteDesc'),
(1,	'trainskill',	'deleteGrade'),
(1,	'trainskill',	'edit'),
(1,	'trainskill',	'editGrade'),
(1,	'trainskill',	'view'),
(1,	'traintask',	'browse'),
(1,	'traintask',	'browseCompanyTasks'),
(1,	'traintask',	'browseDeptTasks'),
(1,	'traintask',	'close'),
(1,	'traintask',	'create'),
(1,	'traintask',	'createTask'),
(1,	'traintask',	'delete'),
(1,	'traintask',	'edit'),
(1,	'traintask',	'finish'),
(1,	'traintask',	'import'),
(1,	'traintask',	'setCondition'),
(1,	'traintask',	'start'),
(1,	'traintask',	'view'),
(1,	'tree',	'browse'),
(1,	'tree',	'browsehost'),
(1,	'tree',	'browseTask'),
(1,	'tree',	'delete'),
(1,	'tree',	'edit'),
(1,	'tree',	'editHost'),
(1,	'tree',	'fix'),
(1,	'tree',	'manageChild'),
(1,	'tree',	'updateOrder'),
(1,	'user',	'batchCreate'),
(1,	'user',	'batchEdit'),
(1,	'user',	'bug'),
(1,	'user',	'create'),
(1,	'user',	'cropAvatar'),
(1,	'user',	'delete'),
(1,	'user',	'dynamic'),
(1,	'user',	'edit'),
(1,	'user',	'effort'),
(1,	'user',	'effortcalendar'),
(1,	'user',	'execution'),
(1,	'user',	'importldap'),
(1,	'user',	'issue'),
(1,	'user',	'profile'),
(1,	'user',	'risk'),
(1,	'user',	'setPublicTemplate'),
(1,	'user',	'story'),
(1,	'user',	'task'),
(1,	'user',	'testCase'),
(1,	'user',	'testTask'),
(1,	'user',	'todo'),
(1,	'user',	'todocalendar'),
(1,	'user',	'unbind'),
(1,	'user',	'unlock'),
(1,	'user',	'view'),
(1,	'webhook',	'bind'),
(1,	'webhook',	'browse'),
(1,	'webhook',	'chooseDept'),
(1,	'webhook',	'create'),
(1,	'webhook',	'delete'),
(1,	'webhook',	'edit'),
(1,	'webhook',	'log'),
(1,	'weekly',	'index'),
(1,	'workestimation',	'index'),
(1,	'workflow',	'activate'),
(1,	'workflow',	'backup'),
(1,	'workflow',	'browse'),
(1,	'workflow',	'browseDB'),
(1,	'workflow',	'browseFlow'),
(1,	'workflow',	'copy'),
(1,	'workflow',	'create'),
(1,	'workflow',	'deactivate'),
(1,	'workflow',	'delete'),
(1,	'workflow',	'edit'),
(1,	'workflow',	'flowchart'),
(1,	'workflow',	'release'),
(1,	'workflow',	'setCSS'),
(1,	'workflow',	'setJS'),
(1,	'workflow',	'ui'),
(1,	'workflow',	'upgrade'),
(1,	'workflow',	'view'),
(1,	'workflowaction',	'browse'),
(1,	'workflowaction',	'create'),
(1,	'workflowaction',	'delete'),
(1,	'workflowaction',	'edit'),
(1,	'workflowaction',	'setCSS'),
(1,	'workflowaction',	'setJS'),
(1,	'workflowaction',	'setNotice'),
(1,	'workflowaction',	'setVerification'),
(1,	'workflowaction',	'sort'),
(1,	'workflowaction',	'view'),
(1,	'workflowcondition',	'browse'),
(1,	'workflowcondition',	'create'),
(1,	'workflowcondition',	'delete'),
(1,	'workflowcondition',	'edit'),
(1,	'workflowdatasource',	'browse'),
(1,	'workflowdatasource',	'create'),
(1,	'workflowdatasource',	'delete'),
(1,	'workflowdatasource',	'edit'),
(1,	'workflowfield',	'browse'),
(1,	'workflowfield',	'create'),
(1,	'workflowfield',	'delete'),
(1,	'workflowfield',	'edit'),
(1,	'workflowfield',	'export'),
(1,	'workflowfield',	'exportTemplate'),
(1,	'workflowfield',	'import'),
(1,	'workflowfield',	'setExport'),
(1,	'workflowfield',	'setSearch'),
(1,	'workflowfield',	'setValue'),
(1,	'workflowfield',	'showImport'),
(1,	'workflowfield',	'sort'),
(1,	'workflowhook',	'browse'),
(1,	'workflowhook',	'create'),
(1,	'workflowhook',	'delete'),
(1,	'workflowhook',	'edit'),
(1,	'workflowlabel',	'browse'),
(1,	'workflowlabel',	'create'),
(1,	'workflowlabel',	'delete'),
(1,	'workflowlabel',	'edit'),
(1,	'workflowlabel',	'sort'),
(1,	'workflowlayout',	'admin'),
(1,	'workflowlayout',	'block'),
(1,	'workflowlinkage',	'browse'),
(1,	'workflowlinkage',	'create'),
(1,	'workflowlinkage',	'delete'),
(1,	'workflowlinkage',	'edit'),
(1,	'workflowrelation',	'admin'),
(1,	'workflowreport',	'browse'),
(1,	'workflowreport',	'create'),
(1,	'workflowreport',	'delete'),
(1,	'workflowreport',	'edit'),
(1,	'workflowreport',	'sort'),
(1,	'workflowrule',	'browse'),
(1,	'workflowrule',	'create'),
(1,	'workflowrule',	'delete'),
(1,	'workflowrule',	'edit'),
(1,	'workflowrule',	'view'),
(1,	'workloadbudget',	'27'),
(1,	'workloadbudget',	'assign'),
(1,	'workloadbudget',	'batchassign'),
(1,	'workloadbudget',	'batchcreate'),
(1,	'workloadbudget',	'batchedit'),
(1,	'workloadbudget',	'browse'),
(1,	'workloadbudget',	'create'),
(1,	'workloadbudget',	'delete'),
(1,	'workloadbudget',	'edit'),
(1,	'workloadbudget',	'export'),
(1,	'workloadbudget',	'exporttemplate'),
(1,	'workloadbudget',	'import'),
(1,	'workloadbudget',	'link'),
(1,	'workloadbudget',	'search'),
(1,	'workloadbudget',	'showimport'),
(1,	'workloadbudget',	'unlink'),
(1,	'workloadbudget',	'view'),
(1,	'zoutput',	'batchCreate'),
(1,	'zoutput',	'batchEdit'),
(1,	'zoutput',	'browse'),
(1,	'zoutput',	'create'),
(1,	'zoutput',	'delete'),
(1,	'zoutput',	'edit'),
(1,	'zoutput',	'updateOrder'),
(1,	'zoutput',	'view'),
(2,	'account',	'browse'),
(2,	'account',	'view'),
(2,	'action',	'comment'),
(2,	'action',	'editComment'),
(2,	'action',	'trash'),
(2,	'action',	'undelete'),
(2,	'activity',	'browse'),
(2,	'activity',	'create'),
(2,	'activity',	'delete'),
(2,	'activity',	'edit'),
(2,	'activity',	'view'),
(2,	'admin',	'checkWeak'),
(2,	'admin',	'index'),
(2,	'admin',	'safe'),
(2,	'api',	'debug'),
(2,	'attend',	'company'),
(2,	'attend',	'department'),
(2,	'attend',	'detail'),
(2,	'attend',	'edit'),
(2,	'attend',	'export'),
(2,	'attend',	'exportDetail'),
(2,	'attend',	'exportStat'),
(2,	'attend',	'personal'),
(2,	'audit',	'8'),
(2,	'audit',	'assign'),
(2,	'audit',	'batchassign'),
(2,	'audit',	'batchcreate'),
(2,	'audit',	'batchedit'),
(2,	'audit',	'browse'),
(2,	'audit',	'create'),
(2,	'audit',	'delete'),
(2,	'audit',	'edit'),
(2,	'audit',	'export'),
(2,	'audit',	'exporttemplate'),
(2,	'audit',	'import'),
(2,	'audit',	'link'),
(2,	'audit',	'search'),
(2,	'audit',	'showimport'),
(2,	'audit',	'unlink'),
(2,	'audit',	'view'),
(2,	'auditcl',	'browse'),
(2,	'auditplan',	'browse'),
(2,	'auditplan',	'create'),
(2,	'auditplan',	'edit'),
(2,	'auditplan',	'nc'),
(2,	'auditplan',	'result'),
(2,	'auditresult',	'10'),
(2,	'auditresult',	'assign'),
(2,	'auditresult',	'batchassign'),
(2,	'auditresult',	'batchcreate'),
(2,	'auditresult',	'batchedit'),
(2,	'auditresult',	'browse'),
(2,	'auditresult',	'create'),
(2,	'auditresult',	'delete'),
(2,	'auditresult',	'edit'),
(2,	'auditresult',	'export'),
(2,	'auditresult',	'exporttemplate'),
(2,	'auditresult',	'import'),
(2,	'auditresult',	'link'),
(2,	'auditresult',	'search'),
(2,	'auditresult',	'showimport'),
(2,	'auditresult',	'unlink'),
(2,	'auditresult',	'view'),
(2,	'automation',	'browse'),
(2,	'baseline',	'articleview'),
(2,	'baseline',	'catalog'),
(2,	'baseline',	'createTemplate'),
(2,	'baseline',	'editBook'),
(2,	'baseline',	'editTemplate'),
(2,	'baseline',	'manageBook'),
(2,	'baseline',	'template'),
(2,	'baseline',	'view'),
(2,	'budget',	'browse'),
(2,	'bug',	'activate'),
(2,	'bug',	'assignTo'),
(2,	'bug',	'batchActivate'),
(2,	'bug',	'batchAssignTo'),
(2,	'bug',	'batchChangeBranch'),
(2,	'bug',	'batchChangeModule'),
(2,	'bug',	'batchClose'),
(2,	'bug',	'batchConfirm'),
(2,	'bug',	'batchCreate'),
(2,	'bug',	'batchEdit'),
(2,	'bug',	'batchResolve'),
(2,	'bug',	'browse'),
(2,	'bug',	'close'),
(2,	'bug',	'confirmBug'),
(2,	'bug',	'confirmStoryChange'),
(2,	'bug',	'create'),
(2,	'bug',	'delete'),
(2,	'bug',	'edit'),
(2,	'bug',	'export'),
(2,	'bug',	'exportTemplet'),
(2,	'bug',	'import'),
(2,	'bug',	'index'),
(2,	'bug',	'linkBugs'),
(2,	'bug',	'report'),
(2,	'bug',	'resolve'),
(2,	'bug',	'showImport'),
(2,	'bug',	'view'),
(2,	'build',	'batchUnlinkBug'),
(2,	'build',	'batchUnlinkStory'),
(2,	'build',	'browse'),
(2,	'build',	'create'),
(2,	'build',	'delete'),
(2,	'build',	'edit'),
(2,	'build',	'linkBug'),
(2,	'build',	'linkStory'),
(2,	'build',	'unlinkBug'),
(2,	'build',	'unlinkStory'),
(2,	'build',	'view'),
(2,	'caselib',	'browse'),
(2,	'caselib',	'index'),
(2,	'caselib',	'view'),
(2,	'classify',	'browse'),
(2,	'cm',	'browse'),
(2,	'cm',	'create'),
(2,	'cm',	'edit'),
(2,	'cm',	'report'),
(2,	'cm',	'view'),
(2,	'cmcl',	'browse'),
(2,	'company',	'browse'),
(2,	'company',	'dynamic'),
(2,	'company',	'edit'),
(2,	'company',	'effort'),
(2,	'company',	'index'),
(2,	'company',	'view'),
(2,	'custom',	'estimate'),
(2,	'custom',	'execution'),
(2,	'custom',	'flow'),
(2,	'custom',	'hours'),
(2,	'custom',	'index'),
(2,	'custom',	'product'),
(2,	'custom',	'restore'),
(2,	'custom',	'set'),
(2,	'custom',	'setPublic'),
(2,	'datatable',	'setGlobal'),
(2,	'deploy',	'activate'),
(2,	'deploy',	'assignTo'),
(2,	'deploy',	'batchUnlinkCases'),
(2,	'deploy',	'browse'),
(2,	'deploy',	'cases'),
(2,	'deploy',	'create'),
(2,	'deploy',	'delete'),
(2,	'deploy',	'deleteStep'),
(2,	'deploy',	'edit'),
(2,	'deploy',	'editStep'),
(2,	'deploy',	'finish'),
(2,	'deploy',	'finishStep'),
(2,	'deploy',	'linkCases'),
(2,	'deploy',	'manageScope'),
(2,	'deploy',	'manageStep'),
(2,	'deploy',	'scope'),
(2,	'deploy',	'steps'),
(2,	'deploy',	'unlinkCase'),
(2,	'deploy',	'view'),
(2,	'deploy',	'viewStep'),
(2,	'dept',	'browse'),
(2,	'dept',	'delete'),
(2,	'dept',	'edit'),
(2,	'dept',	'manageChild'),
(2,	'dept',	'updateOrder'),
(2,	'design',	'browse'),
(2,	'design',	'create'),
(2,	'design',	'delete'),
(2,	'design',	'edit'),
(2,	'design',	'view'),
(2,	'dev',	'api'),
(2,	'dev',	'db'),
(2,	'dev',	'editor'),
(2,	'doc',	'collect'),
(2,	'doc',	'create'),
(2,	'doc',	'createLib'),
(2,	'doc',	'delete'),
(2,	'doc',	'deleteFile'),
(2,	'doc',	'deleteLib'),
(2,	'doc',	'diff'),
(2,	'doc',	'edit'),
(2,	'doc',	'editLib'),
(2,	'doc',	'index'),
(2,	'doc',	'myCollection'),
(2,	'doc',	'myCreation'),
(2,	'doc',	'myEdited'),
(2,	'doc',	'mySpace'),
(2,	'doc',	'myView'),
(2,	'doc',	'productSpace'),
(2,	'doc',	'projectSpace'),
(2,	'doc',	'showFiles'),
(2,	'doc',	'teamSpace'),
(2,	'doc',	'view'),
(2,	'domain',	'browse'),
(2,	'domain',	'view'),
(2,	'durationestimation',	'create'),
(2,	'durationestimation',	'index'),
(2,	'effort',	'batchCreate'),
(2,	'effort',	'batchEdit'),
(2,	'effort',	'calendar'),
(2,	'effort',	'createForObject'),
(2,	'effort',	'delete'),
(2,	'effort',	'edit'),
(2,	'effort',	'export'),
(2,	'effort',	'view'),
(2,	'execution',	'all'),
(2,	'execution',	'browse'),
(2,	'execution',	'bug'),
(2,	'execution',	'build'),
(2,	'execution',	'burn'),
(2,	'execution',	'burnData'),
(2,	'execution',	'calendar'),
(2,	'execution',	'computeBurn'),
(2,	'execution',	'computeTaskEffort'),
(2,	'execution',	'deleterelation'),
(2,	'execution',	'doc'),
(2,	'execution',	'dynamic'),
(2,	'execution',	'effort'),
(2,	'execution',	'effortCalendar'),
(2,	'execution',	'executionkanban'),
(2,	'execution',	'fixFirst'),
(2,	'execution',	'gantt'),
(2,	'execution',	'grouptask'),
(2,	'execution',	'kanban'),
(2,	'execution',	'maintainrelation'),
(2,	'execution',	'manageMembers'),
(2,	'execution',	'printKanban'),
(2,	'execution',	'relation'),
(2,	'execution',	'story'),
(2,	'execution',	'storyEstimate'),
(2,	'execution',	'storyKanban'),
(2,	'execution',	'storyView'),
(2,	'execution',	'task'),
(2,	'execution',	'taskEffort'),
(2,	'execution',	'team'),
(2,	'execution',	'testcase'),
(2,	'execution',	'testreport'),
(2,	'execution',	'testtask'),
(2,	'execution',	'tree'),
(2,	'execution',	'treeStory'),
(2,	'execution',	'treeTask'),
(2,	'execution',	'view'),
(2,	'execution',	'whitelist'),
(2,	'feedback',	'admin'),
(2,	'feedback',	'adminView'),
(2,	'feedback',	'batchAssignTo'),
(2,	'feedback',	'batchClose'),
(2,	'feedback',	'batchEdit'),
(2,	'feedback',	'browse'),
(2,	'feedback',	'close'),
(2,	'feedback',	'comment'),
(2,	'feedback',	'create'),
(2,	'feedback',	'delete'),
(2,	'feedback',	'edit'),
(2,	'feedback',	'index'),
(2,	'feedback',	'view'),
(2,	'file',	'delete'),
(2,	'file',	'download'),
(2,	'file',	'edit'),
(2,	'file',	'setPublic'),
(2,	'file',	'uploadImages'),
(2,	'gapanalysis',	'batchCreate'),
(2,	'gapanalysis',	'browse'),
(2,	'gapanalysis',	'create'),
(2,	'gapanalysis',	'edit'),
(2,	'git',	'apiSync'),
(2,	'git',	'cat'),
(2,	'git',	'diff'),
(2,	'group',	'browse'),
(2,	'holiday',	'browse'),
(2,	'holiday',	'create'),
(2,	'holiday',	'delete'),
(2,	'holiday',	'edit'),
(2,	'host',	'browse'),
(2,	'host',	'changeStatus'),
(2,	'host',	'create'),
(2,	'host',	'delete'),
(2,	'host',	'edit'),
(2,	'host',	'treemap'),
(2,	'host',	'view'),
(2,	'index',	'index'),
(2,	'investigation',	'126'),
(2,	'investigation',	'analysis'),
(2,	'investigation',	'assign'),
(2,	'investigation',	'batchassign'),
(2,	'investigation',	'batchcreate'),
(2,	'investigation',	'batchedit'),
(2,	'investigation',	'browse'),
(2,	'investigation',	'create'),
(2,	'investigation',	'delete'),
(2,	'investigation',	'edit'),
(2,	'investigation',	'export'),
(2,	'investigation',	'exporttemplate'),
(2,	'investigation',	'import'),
(2,	'investigation',	'link'),
(2,	'investigation',	'report'),
(2,	'investigation',	'search'),
(2,	'investigation',	'showimport'),
(2,	'investigation',	'unlink'),
(2,	'investigation',	'view'),
(2,	'issue',	'activate'),
(2,	'issue',	'batchCreate'),
(2,	'issue',	'browse'),
(2,	'issue',	'cancel'),
(2,	'issue',	'close'),
(2,	'issue',	'create'),
(2,	'issue',	'delete'),
(2,	'issue',	'edit'),
(2,	'issue',	'resolve'),
(2,	'issue',	'view'),
(2,	'leave',	'back'),
(2,	'leave',	'create'),
(2,	'leave',	'delete'),
(2,	'leave',	'edit'),
(2,	'leave',	'export'),
(2,	'leave',	'personal'),
(2,	'leave',	'personalAnnual'),
(2,	'leave',	'switchstatus'),
(2,	'leave',	'view'),
(2,	'lieu',	'create'),
(2,	'lieu',	'delete'),
(2,	'lieu',	'edit'),
(2,	'lieu',	'personal'),
(2,	'lieu',	'switchstatus'),
(2,	'lieu',	'view'),
(2,	'makeup',	'create'),
(2,	'makeup',	'delete'),
(2,	'makeup',	'edit'),
(2,	'makeup',	'export'),
(2,	'makeup',	'personal'),
(2,	'makeup',	'switchstatus'),
(2,	'makeup',	'view'),
(2,	'meeting',	'browse'),
(2,	'meeting',	'create'),
(2,	'meeting',	'delete'),
(2,	'meeting',	'edit'),
(2,	'meeting',	'minutes'),
(2,	'meeting',	'view'),
(2,	'message',	'browser'),
(2,	'message',	'index'),
(2,	'message',	'setting'),
(2,	'milestone',	'index'),
(2,	'milestone',	'saveOtherProblem'),
(2,	'misc',	'ping'),
(2,	'my',	'bug'),
(2,	'my',	'calendar'),
(2,	'my',	'changePassword'),
(2,	'my',	'contribute'),
(2,	'my',	'deleteContacts'),
(2,	'my',	'doc'),
(2,	'my',	'dynamic'),
(2,	'my',	'editProfile'),
(2,	'my',	'effort'),
(2,	'my',	'execution'),
(2,	'my',	'index'),
(2,	'my',	'issue'),
(2,	'my',	'manageContacts'),
(2,	'my',	'meeting'),
(2,	'my',	'myMeeting'),
(2,	'my',	'nc'),
(2,	'my',	'preference'),
(2,	'my',	'profile'),
(2,	'my',	'project'),
(2,	'my',	'review'),
(2,	'my',	'risk'),
(2,	'my',	'score'),
(2,	'my',	'story'),
(2,	'my',	'task'),
(2,	'my',	'team'),
(2,	'my',	'testcase'),
(2,	'my',	'testtask'),
(2,	'my',	'todo'),
(2,	'my',	'uploadAvatar'),
(2,	'my',	'work'),
(2,	'nc',	'16'),
(2,	'nc',	'activate'),
(2,	'nc',	'assign'),
(2,	'nc',	'batchassign'),
(2,	'nc',	'batchcreate'),
(2,	'nc',	'batchedit'),
(2,	'nc',	'browse'),
(2,	'nc',	'close'),
(2,	'nc',	'create'),
(2,	'nc',	'delete'),
(2,	'nc',	'edit'),
(2,	'nc',	'export'),
(2,	'nc',	'exporttemplate'),
(2,	'nc',	'import'),
(2,	'nc',	'link'),
(2,	'nc',	'resolve'),
(2,	'nc',	'search'),
(2,	'nc',	'showimport'),
(2,	'nc',	'unlink'),
(2,	'nc',	'view'),
(2,	'opportunity',	'activate'),
(2,	'opportunity',	'assignTo'),
(2,	'opportunity',	'batchActivate'),
(2,	'opportunity',	'batchAssignTo'),
(2,	'opportunity',	'batchCancel'),
(2,	'opportunity',	'batchClose'),
(2,	'opportunity',	'batchCreate'),
(2,	'opportunity',	'batchEdit'),
(2,	'opportunity',	'batchHangup'),
(2,	'opportunity',	'browse'),
(2,	'opportunity',	'cancel'),
(2,	'opportunity',	'close'),
(2,	'opportunity',	'create'),
(2,	'opportunity',	'delete'),
(2,	'opportunity',	'edit'),
(2,	'opportunity',	'hangup'),
(2,	'opportunity',	'importFromLib'),
(2,	'opportunity',	'track'),
(2,	'opportunity',	'view'),
(2,	'ops',	'index'),
(2,	'ops',	'setting'),
(2,	'output',	'13'),
(2,	'output',	'assign'),
(2,	'output',	'batchassign'),
(2,	'output',	'batchcreate'),
(2,	'output',	'batchedit'),
(2,	'output',	'browse'),
(2,	'output',	'create'),
(2,	'output',	'delete'),
(2,	'output',	'edit'),
(2,	'output',	'export'),
(2,	'output',	'exporttemplate'),
(2,	'output',	'import'),
(2,	'output',	'link'),
(2,	'output',	'search'),
(2,	'output',	'showimport'),
(2,	'output',	'unlink'),
(2,	'output',	'view'),
(2,	'overtime',	'create'),
(2,	'overtime',	'delete'),
(2,	'overtime',	'edit'),
(2,	'overtime',	'export'),
(2,	'overtime',	'personal'),
(2,	'overtime',	'switchstatus'),
(2,	'overtime',	'view'),
(2,	'personnel',	'accessible'),
(2,	'personnel',	'invest'),
(2,	'personnel',	'whitelist'),
(2,	'pivot',	'bugAssign'),
(2,	'pivot',	'bugAssignSummary'),
(2,	'pivot',	'bugCreate'),
(2,	'pivot',	'bugSummary'),
(2,	'pivot',	'build'),
(2,	'pivot',	'casesrun'),
(2,	'pivot',	'preview'),
(2,	'pivot',	'productSummary'),
(2,	'pivot',	'projectDeviation'),
(2,	'pivot',	'projectSummary'),
(2,	'pivot',	'projectWorkload'),
(2,	'pivot',	'roadmap'),
(2,	'pivot',	'storyLinkedBug'),
(2,	'pivot',	'testcase'),
(2,	'pivot',	'workAssignSummary'),
(2,	'pivot',	'workload'),
(2,	'pivot',	'workSummary'),
(2,	'process',	'browse'),
(2,	'process',	'create'),
(2,	'process',	'delete'),
(2,	'process',	'edit'),
(2,	'process',	'view'),
(2,	'product',	'all'),
(2,	'product',	'browse'),
(2,	'product',	'build'),
(2,	'product',	'dashboard'),
(2,	'product',	'dynamic'),
(2,	'product',	'index'),
(2,	'product',	'kanban'),
(2,	'product',	'project'),
(2,	'product',	'roadmap'),
(2,	'product',	'track'),
(2,	'product',	'view'),
(2,	'product',	'whitelist'),
(2,	'productplan',	'browse'),
(2,	'productplan',	'view'),
(2,	'program',	'browse'),
(2,	'program',	'kanban'),
(2,	'program',	'product'),
(2,	'program',	'project'),
(2,	'program',	'stakeholder'),
(2,	'program',	'view'),
(2,	'project',	'browse'),
(2,	'project',	'bug'),
(2,	'project',	'build'),
(2,	'project',	'create'),
(2,	'project',	'dynamic'),
(2,	'project',	'edit'),
(2,	'project',	'execution'),
(2,	'project',	'index'),
(2,	'project',	'kanban'),
(2,	'project',	'manageMembers'),
(2,	'project',	'programTitle'),
(2,	'project',	'qa'),
(2,	'project',	'team'),
(2,	'project',	'testcase'),
(2,	'project',	'testreport'),
(2,	'project',	'testtask'),
(2,	'project',	'view'),
(2,	'project',	'whitelist'),
(2,	'projectbuild',	'browse'),
(2,	'projectrelease',	'browse'),
(2,	'projectrelease',	'view'),
(2,	'projectstory',	'story'),
(2,	'projectstory',	'track'),
(2,	'projectstory',	'view'),
(2,	'pssp',	'browse'),
(2,	'pssp',	'update'),
(2,	'qa',	'index'),
(2,	'release',	'browse'),
(2,	'release',	'view'),
(2,	'repo',	'blame'),
(2,	'repo',	'browse'),
(2,	'repo',	'create'),
(2,	'repo',	'delete'),
(2,	'repo',	'diff'),
(2,	'repo',	'download'),
(2,	'repo',	'edit'),
(2,	'repo',	'log'),
(2,	'repo',	'revision'),
(2,	'repo',	'showSyncCommit'),
(2,	'repo',	'view'),
(2,	'report',	'customeRedreport'),
(2,	'report',	'show'),
(2,	'requirement',	'report'),
(2,	'requirement',	'view'),
(2,	'review',	'assess'),
(2,	'review',	'audit'),
(2,	'review',	'browse'),
(2,	'review',	'create'),
(2,	'review',	'edit'),
(2,	'review',	'recall'),
(2,	'review',	'report'),
(2,	'review',	'result'),
(2,	'review',	'submit'),
(2,	'review',	'toAudit'),
(2,	'review',	'view'),
(2,	'reviewcl',	'browse'),
(2,	'reviewissue',	'create'),
(2,	'reviewissue',	'edit'),
(2,	'reviewissue',	'issue'),
(2,	'reviewissue',	'resolved'),
(2,	'reviewissue',	'updateStatus'),
(2,	'reviewissue',	'view'),
(2,	'reviewsetting',	'reviewer'),
(2,	'reviewsetting',	'version'),
(2,	'risk',	'activate'),
(2,	'risk',	'browse'),
(2,	'risk',	'cancel'),
(2,	'risk',	'close'),
(2,	'risk',	'create'),
(2,	'risk',	'delete'),
(2,	'risk',	'edit'),
(2,	'risk',	'hangup'),
(2,	'risk',	'view'),
(2,	'screen',	'annualData'),
(2,	'screen',	'browse'),
(2,	'screen',	'view'),
(2,	'search',	'buildForm'),
(2,	'search',	'buildIndex'),
(2,	'search',	'buildQuery'),
(2,	'search',	'deleteQuery'),
(2,	'search',	'index'),
(2,	'search',	'saveQuery'),
(2,	'search',	'select'),
(2,	'serverroom',	'browse'),
(2,	'serverroom',	'create'),
(2,	'serverroom',	'delete'),
(2,	'serverroom',	'edit'),
(2,	'serverroom',	'view'),
(2,	'service',	'browse'),
(2,	'service',	'create'),
(2,	'service',	'delete'),
(2,	'service',	'edit'),
(2,	'service',	'index'),
(2,	'service',	'manage'),
(2,	'service',	'view'),
(2,	'stage',	'batchCreate'),
(2,	'stage',	'browse'),
(2,	'stage',	'create'),
(2,	'stage',	'delete'),
(2,	'stage',	'edit'),
(2,	'story',	'browse'),
(2,	'story',	'bugs'),
(2,	'story',	'cases'),
(2,	'story',	'report'),
(2,	'story',	'tasks'),
(2,	'story',	'view'),
(2,	'subject',	'browse'),
(2,	'svn',	'apiSync'),
(2,	'svn',	'cat'),
(2,	'svn',	'diff'),
(2,	'task',	'activate'),
(2,	'task',	'assignTo'),
(2,	'task',	'batchAssignTo'),
(2,	'task',	'batchCancel'),
(2,	'task',	'batchChangeModule'),
(2,	'task',	'batchClose'),
(2,	'task',	'batchCreate'),
(2,	'task',	'batchEdit'),
(2,	'task',	'browse'),
(2,	'task',	'cancel'),
(2,	'task',	'close'),
(2,	'task',	'confirmdesignchange'),
(2,	'task',	'confirmStoryChange'),
(2,	'task',	'create'),
(2,	'task',	'delete'),
(2,	'task',	'deleteEstimate'),
(2,	'task',	'edit'),
(2,	'task',	'editEstimate'),
(2,	'task',	'export'),
(2,	'task',	'exportTemplet'),
(2,	'task',	'finish'),
(2,	'task',	'import'),
(2,	'task',	'pause'),
(2,	'task',	'recordEstimate'),
(2,	'task',	'report'),
(2,	'task',	'restart'),
(2,	'task',	'showImport'),
(2,	'task',	'start'),
(2,	'task',	'view'),
(2,	'testcase',	'browse'),
(2,	'testcase',	'bugs'),
(2,	'testcase',	'createBug'),
(2,	'testcase',	'export'),
(2,	'testcase',	'groupCase'),
(2,	'testcase',	'submit'),
(2,	'testcase',	'view'),
(2,	'testreport',	'browse'),
(2,	'testreport',	'create'),
(2,	'testreport',	'delete'),
(2,	'testreport',	'edit'),
(2,	'testreport',	'view'),
(2,	'testsuite',	'browse'),
(2,	'testsuite',	'index'),
(2,	'testsuite',	'test'),
(2,	'testsuite',	'view'),
(2,	'testtask',	'activate'),
(2,	'testtask',	'batchAssign'),
(2,	'testtask',	'batchRun'),
(2,	'testtask',	'batchUnlinkCases'),
(2,	'testtask',	'block'),
(2,	'testtask',	'browse'),
(2,	'testtask',	'browseUnits'),
(2,	'testtask',	'cases'),
(2,	'testtask',	'close'),
(2,	'testtask',	'create'),
(2,	'testtask',	'delete'),
(2,	'testtask',	'edit'),
(2,	'testtask',	'groupCase'),
(2,	'testtask',	'importUnitResult'),
(2,	'testtask',	'index'),
(2,	'testtask',	'linkcase'),
(2,	'testtask',	'report'),
(2,	'testtask',	'results'),
(2,	'testtask',	'runcase'),
(2,	'testtask',	'start'),
(2,	'testtask',	'unitCases'),
(2,	'testtask',	'unlinkcase'),
(2,	'testtask',	'view'),
(2,	'todo',	'activate'),
(2,	'todo',	'assignTo'),
(2,	'todo',	'batchClose'),
(2,	'todo',	'batchCreate'),
(2,	'todo',	'batchEdit'),
(2,	'todo',	'batchFinish'),
(2,	'todo',	'calendar'),
(2,	'todo',	'close'),
(2,	'todo',	'create'),
(2,	'todo',	'createcycle'),
(2,	'todo',	'delete'),
(2,	'todo',	'edit'),
(2,	'todo',	'export'),
(2,	'todo',	'finish'),
(2,	'todo',	'import2Today'),
(2,	'todo',	'start'),
(2,	'todo',	'view'),
(2,	'trainchapter',	'browse'),
(2,	'trainchapter',	'catalog'),
(2,	'trainchapter',	'delete'),
(2,	'trainchapter',	'edit'),
(2,	'trainchapter',	'manage'),
(2,	'trainchapter',	'showDocFiles'),
(2,	'trainchapter',	'sortChapterOrder'),
(2,	'trainchapter',	'view'),
(2,	'traincourse',	'browse'),
(2,	'traincourse',	'create'),
(2,	'traincourse',	'delete'),
(2,	'traincourse',	'edit'),
(2,	'traincourse',	'view'),
(2,	'traingoal',	'browse'),
(2,	'traingoal',	'create'),
(2,	'traingoal',	'delete'),
(2,	'traingoal',	'edit'),
(2,	'traingoal',	'review'),
(2,	'traingoal',	'submitReview'),
(2,	'traingoal',	'updateOrder'),
(2,	'traingoal',	'view'),
(2,	'trainplan',	'batchCreate'),
(2,	'trainplan',	'batchEdit'),
(2,	'trainplan',	'batchFinish'),
(2,	'trainplan',	'browse'),
(2,	'trainplan',	'create'),
(2,	'trainplan',	'delete'),
(2,	'trainplan',	'edit'),
(2,	'trainplan',	'finish'),
(2,	'trainplan',	'summary'),
(2,	'trainplan',	'view'),
(2,	'trainpost',	'browse'),
(2,	'trainpost',	'create'),
(2,	'trainpost',	'delete'),
(2,	'trainpost',	'edit'),
(2,	'trainpost',	'editGrade'),
(2,	'trainpost',	'gradeView'),
(2,	'trainpost',	'manageGrade'),
(2,	'trainpost',	'updateOrder'),
(2,	'trainpost',	'view'),
(2,	'trainskill',	'browse'),
(2,	'trainskill',	'create'),
(2,	'trainskill',	'createGrade'),
(2,	'trainskill',	'delete'),
(2,	'trainskill',	'deleteDesc'),
(2,	'trainskill',	'deleteGrade'),
(2,	'trainskill',	'edit'),
(2,	'trainskill',	'editGrade'),
(2,	'trainskill',	'view'),
(2,	'traintask',	'browse'),
(2,	'traintask',	'closed'),
(2,	'traintask',	'create'),
(2,	'traintask',	'delete'),
(2,	'traintask',	'edit'),
(2,	'traintask',	'finish'),
(2,	'traintask',	'import'),
(2,	'traintask',	'start'),
(2,	'traintask',	'view'),
(2,	'tree',	'browse'),
(2,	'tree',	'browseTask'),
(2,	'tree',	'delete'),
(2,	'tree',	'edit'),
(2,	'tree',	'fix'),
(2,	'tree',	'manageChild'),
(2,	'tree',	'updateOrder'),
(2,	'user',	'batchEdit'),
(2,	'user',	'bug'),
(2,	'user',	'cropAvatar'),
(2,	'user',	'dynamic'),
(2,	'user',	'effort'),
(2,	'user',	'effortcalendar'),
(2,	'user',	'execution'),
(2,	'user',	'issue'),
(2,	'user',	'profile'),
(2,	'user',	'risk'),
(2,	'user',	'story'),
(2,	'user',	'task'),
(2,	'user',	'testCase'),
(2,	'user',	'testTask'),
(2,	'user',	'todo'),
(2,	'user',	'todocalendar'),
(2,	'user',	'view'),
(2,	'weekly',	'index'),
(2,	'workestimation',	'index'),
(2,	'workloadbudget',	'27'),
(2,	'workloadbudget',	'assign'),
(2,	'workloadbudget',	'batchassign'),
(2,	'workloadbudget',	'batchcreate'),
(2,	'workloadbudget',	'batchedit'),
(2,	'workloadbudget',	'browse'),
(2,	'workloadbudget',	'create'),
(2,	'workloadbudget',	'delete'),
(2,	'workloadbudget',	'edit'),
(2,	'workloadbudget',	'export'),
(2,	'workloadbudget',	'exporttemplate'),
(2,	'workloadbudget',	'import'),
(2,	'workloadbudget',	'link'),
(2,	'workloadbudget',	'search'),
(2,	'workloadbudget',	'showimport'),
(2,	'workloadbudget',	'unlink'),
(2,	'workloadbudget',	'view'),
(3,	'action',	'comment'),
(3,	'action',	'editComment'),
(3,	'activity',	'browse'),
(3,	'activity',	'create'),
(3,	'activity',	'delete'),
(3,	'activity',	'edit'),
(3,	'activity',	'view'),
(3,	'admin',	'index'),
(3,	'attend',	'company'),
(3,	'attend',	'department'),
(3,	'attend',	'detail'),
(3,	'attend',	'edit'),
(3,	'attend',	'export'),
(3,	'attend',	'exportDetail'),
(3,	'attend',	'personal'),
(3,	'audit',	'8'),
(3,	'audit',	'assign'),
(3,	'audit',	'batchassign'),
(3,	'audit',	'batchcreate'),
(3,	'audit',	'batchedit'),
(3,	'audit',	'browse'),
(3,	'audit',	'create'),
(3,	'audit',	'delete'),
(3,	'audit',	'edit'),
(3,	'audit',	'export'),
(3,	'audit',	'exporttemplate'),
(3,	'audit',	'import'),
(3,	'audit',	'link'),
(3,	'audit',	'search'),
(3,	'audit',	'showimport'),
(3,	'audit',	'unlink'),
(3,	'audit',	'view'),
(3,	'auditcl',	'browse'),
(3,	'auditplan',	'browse'),
(3,	'auditplan',	'create'),
(3,	'auditplan',	'edit'),
(3,	'auditplan',	'nc'),
(3,	'auditplan',	'result'),
(3,	'auditresult',	'10'),
(3,	'auditresult',	'assign'),
(3,	'auditresult',	'batchassign'),
(3,	'auditresult',	'batchcreate'),
(3,	'auditresult',	'batchedit'),
(3,	'auditresult',	'browse'),
(3,	'auditresult',	'create'),
(3,	'auditresult',	'delete'),
(3,	'auditresult',	'edit'),
(3,	'auditresult',	'export'),
(3,	'auditresult',	'exporttemplate'),
(3,	'auditresult',	'import'),
(3,	'auditresult',	'link'),
(3,	'auditresult',	'search'),
(3,	'auditresult',	'showimport'),
(3,	'auditresult',	'unlink'),
(3,	'auditresult',	'view'),
(3,	'automation',	'browse'),
(3,	'baseline',	'articleview'),
(3,	'baseline',	'catalog'),
(3,	'baseline',	'createTemplate'),
(3,	'baseline',	'editBook'),
(3,	'baseline',	'editTemplate'),
(3,	'baseline',	'manageBook'),
(3,	'baseline',	'template'),
(3,	'baseline',	'view'),
(3,	'budget',	'batchCreate'),
(3,	'budget',	'browse'),
(3,	'budget',	'create'),
(3,	'budget',	'edit'),
(3,	'budget',	'summary'),
(3,	'budget',	'view'),
(3,	'bug',	'activate'),
(3,	'bug',	'assignTo'),
(3,	'bug',	'batchActivate'),
(3,	'bug',	'batchAssignTo'),
(3,	'bug',	'batchChangeBranch'),
(3,	'bug',	'batchChangeModule'),
(3,	'bug',	'batchClose'),
(3,	'bug',	'batchConfirm'),
(3,	'bug',	'batchCreate'),
(3,	'bug',	'batchEdit'),
(3,	'bug',	'batchResolve'),
(3,	'bug',	'browse'),
(3,	'bug',	'close'),
(3,	'bug',	'confirmBug'),
(3,	'bug',	'confirmStoryChange'),
(3,	'bug',	'create'),
(3,	'bug',	'delete'),
(3,	'bug',	'edit'),
(3,	'bug',	'export'),
(3,	'bug',	'exportTemplet'),
(3,	'bug',	'import'),
(3,	'bug',	'index'),
(3,	'bug',	'linkBugs'),
(3,	'bug',	'report'),
(3,	'bug',	'resolve'),
(3,	'bug',	'showImport'),
(3,	'bug',	'view'),
(3,	'build',	'create'),
(3,	'build',	'edit'),
(3,	'build',	'view'),
(3,	'caselib',	'batchCreateCase'),
(3,	'caselib',	'browse'),
(3,	'caselib',	'createCase'),
(3,	'caselib',	'exportTemplet'),
(3,	'caselib',	'import'),
(3,	'caselib',	'index'),
(3,	'caselib',	'justtest'),
(3,	'caselib',	'showImport'),
(3,	'caselib',	'view'),
(3,	'classify',	'browse'),
(3,	'cm',	'browse'),
(3,	'cm',	'create'),
(3,	'cm',	'edit'),
(3,	'cm',	'report'),
(3,	'cm',	'view'),
(3,	'cmcl',	'browse'),
(3,	'company',	'browse'),
(3,	'company',	'dynamic'),
(3,	'company',	'effort'),
(3,	'company',	'index'),
(3,	'company',	'view'),
(3,	'custom',	'estimate'),
(3,	'datatable',	'setGlobal'),
(3,	'design',	'browse'),
(3,	'design',	'create'),
(3,	'design',	'edit'),
(3,	'design',	'view'),
(3,	'doc',	'collect'),
(3,	'doc',	'create'),
(3,	'doc',	'diff'),
(3,	'doc',	'edit'),
(3,	'doc',	'index'),
(3,	'doc',	'myCollection'),
(3,	'doc',	'myCreation'),
(3,	'doc',	'myEdited'),
(3,	'doc',	'mySpace'),
(3,	'doc',	'myView'),
(3,	'doc',	'productSpace'),
(3,	'doc',	'projectSpace'),
(3,	'doc',	'showFiles'),
(3,	'doc',	'teamSpace'),
(3,	'doc',	'view'),
(3,	'durationestimation',	'create'),
(3,	'durationestimation',	'index'),
(3,	'effort',	'batchCreate'),
(3,	'effort',	'calendar'),
(3,	'effort',	'createForObject'),
(3,	'effort',	'delete'),
(3,	'effort',	'edit'),
(3,	'effort',	'export'),
(3,	'effort',	'view'),
(3,	'execution',	'all'),
(3,	'execution',	'browse'),
(3,	'execution',	'bug'),
(3,	'execution',	'build'),
(3,	'execution',	'burn'),
(3,	'execution',	'calendar'),
(3,	'execution',	'computeBurn'),
(3,	'execution',	'doc'),
(3,	'execution',	'dynamic'),
(3,	'execution',	'effort'),
(3,	'execution',	'executionkanban'),
(3,	'execution',	'grouptask'),
(3,	'execution',	'importBug'),
(3,	'execution',	'importtask'),
(3,	'execution',	'index'),
(3,	'execution',	'kanban'),
(3,	'execution',	'story'),
(3,	'execution',	'storyView'),
(3,	'execution',	'task'),
(3,	'execution',	'team'),
(3,	'execution',	'testcase'),
(3,	'execution',	'testreport'),
(3,	'execution',	'testtask'),
(3,	'execution',	'tree'),
(3,	'execution',	'treeStory'),
(3,	'execution',	'treeTask'),
(3,	'execution',	'view'),
(3,	'execution',	'whitelist'),
(3,	'file',	'delete'),
(3,	'file',	'download'),
(3,	'file',	'edit'),
(3,	'file',	'setPublic'),
(3,	'file',	'uploadImages'),
(3,	'gapanalysis',	'batchCreate'),
(3,	'gapanalysis',	'batchEdit'),
(3,	'gapanalysis',	'browse'),
(3,	'gapanalysis',	'create'),
(3,	'gapanalysis',	'delete'),
(3,	'gapanalysis',	'edit'),
(3,	'gapanalysis',	'view'),
(3,	'git',	'apiSync'),
(3,	'git',	'cat'),
(3,	'git',	'diff'),
(3,	'group',	'browse'),
(3,	'index',	'index'),
(3,	'issue',	'activate'),
(3,	'issue',	'browse'),
(3,	'issue',	'cancel'),
(3,	'issue',	'close'),
(3,	'issue',	'create'),
(3,	'issue',	'delete'),
(3,	'issue',	'edit'),
(3,	'issue',	'resolve'),
(3,	'issue',	'view'),
(3,	'leave',	'back'),
(3,	'leave',	'create'),
(3,	'leave',	'delete'),
(3,	'leave',	'edit'),
(3,	'leave',	'export'),
(3,	'leave',	'personal'),
(3,	'leave',	'personalAnnual'),
(3,	'leave',	'switchstatus'),
(3,	'leave',	'view'),
(3,	'lieu',	'create'),
(3,	'lieu',	'delete'),
(3,	'lieu',	'edit'),
(3,	'lieu',	'personal'),
(3,	'lieu',	'switchstatus'),
(3,	'lieu',	'view'),
(3,	'makeup',	'create'),
(3,	'makeup',	'delete'),
(3,	'makeup',	'edit'),
(3,	'makeup',	'personal'),
(3,	'makeup',	'switchstatus'),
(3,	'makeup',	'view'),
(3,	'meeting',	'browse'),
(3,	'meeting',	'create'),
(3,	'meeting',	'delete'),
(3,	'meeting',	'edit'),
(3,	'meeting',	'minutes'),
(3,	'meeting',	'view'),
(3,	'message',	'browser'),
(3,	'milestone',	'index'),
(3,	'milestone',	'saveOtherProblem'),
(3,	'misc',	'ping'),
(3,	'my',	'bug'),
(3,	'my',	'calendar'),
(3,	'my',	'changePassword'),
(3,	'my',	'contribute'),
(3,	'my',	'deleteContacts'),
(3,	'my',	'doc'),
(3,	'my',	'dynamic'),
(3,	'my',	'editProfile'),
(3,	'my',	'effort'),
(3,	'my',	'execution'),
(3,	'my',	'index'),
(3,	'my',	'issue'),
(3,	'my',	'manageContacts'),
(3,	'my',	'meeting'),
(3,	'my',	'myMeeting'),
(3,	'my',	'nc'),
(3,	'my',	'preference'),
(3,	'my',	'profile'),
(3,	'my',	'project'),
(3,	'my',	'review'),
(3,	'my',	'risk'),
(3,	'my',	'score'),
(3,	'my',	'story'),
(3,	'my',	'task'),
(3,	'my',	'team'),
(3,	'my',	'testcase'),
(3,	'my',	'testtask'),
(3,	'my',	'todo'),
(3,	'my',	'unbind'),
(3,	'my',	'uploadAvatar'),
(3,	'my',	'work'),
(3,	'nc',	'16'),
(3,	'nc',	'activate'),
(3,	'nc',	'assign'),
(3,	'nc',	'batchassign'),
(3,	'nc',	'batchcreate'),
(3,	'nc',	'batchedit'),
(3,	'nc',	'browse'),
(3,	'nc',	'close'),
(3,	'nc',	'create'),
(3,	'nc',	'delete'),
(3,	'nc',	'edit'),
(3,	'nc',	'export'),
(3,	'nc',	'exporttemplate'),
(3,	'nc',	'import'),
(3,	'nc',	'link'),
(3,	'nc',	'resolve'),
(3,	'nc',	'search'),
(3,	'nc',	'showimport'),
(3,	'nc',	'unlink'),
(3,	'nc',	'view'),
(3,	'opportunity',	'activate'),
(3,	'opportunity',	'assignTo'),
(3,	'opportunity',	'batchActivate'),
(3,	'opportunity',	'batchAssignTo'),
(3,	'opportunity',	'batchCancel'),
(3,	'opportunity',	'batchClose'),
(3,	'opportunity',	'batchCreate'),
(3,	'opportunity',	'batchEdit'),
(3,	'opportunity',	'batchHangup'),
(3,	'opportunity',	'browse'),
(3,	'opportunity',	'cancel'),
(3,	'opportunity',	'close'),
(3,	'opportunity',	'create'),
(3,	'opportunity',	'delete'),
(3,	'opportunity',	'edit'),
(3,	'opportunity',	'hangup'),
(3,	'opportunity',	'importFromLib'),
(3,	'opportunity',	'track'),
(3,	'opportunity',	'view'),
(3,	'output',	'13'),
(3,	'output',	'assign'),
(3,	'output',	'batchassign'),
(3,	'output',	'batchcreate'),
(3,	'output',	'batchedit'),
(3,	'output',	'browse'),
(3,	'output',	'create'),
(3,	'output',	'delete'),
(3,	'output',	'edit'),
(3,	'output',	'export'),
(3,	'output',	'exporttemplate'),
(3,	'output',	'import'),
(3,	'output',	'link'),
(3,	'output',	'search'),
(3,	'output',	'showimport'),
(3,	'output',	'unlink'),
(3,	'output',	'view'),
(3,	'overtime',	'create'),
(3,	'overtime',	'delete'),
(3,	'overtime',	'edit'),
(3,	'overtime',	'export'),
(3,	'overtime',	'personal'),
(3,	'overtime',	'switchstatus'),
(3,	'overtime',	'view'),
(3,	'personnel',	'accessible'),
(3,	'personnel',	'invest'),
(3,	'personnel',	'whitelist'),
(3,	'pivot',	'bugAssign'),
(3,	'pivot',	'bugAssignSummary'),
(3,	'pivot',	'bugCreate'),
(3,	'pivot',	'bugSummary'),
(3,	'pivot',	'build'),
(3,	'pivot',	'casesrun'),
(3,	'pivot',	'preview'),
(3,	'pivot',	'productSummary'),
(3,	'pivot',	'projectDeviation'),
(3,	'pivot',	'projectSummary'),
(3,	'pivot',	'projectWorkload'),
(3,	'pivot',	'roadmap'),
(3,	'pivot',	'storyLinkedBug'),
(3,	'pivot',	'testcase'),
(3,	'pivot',	'workAssignSummary'),
(3,	'pivot',	'workload'),
(3,	'pivot',	'workSummary'),
(3,	'process',	'browse'),
(3,	'process',	'create'),
(3,	'process',	'delete'),
(3,	'process',	'edit'),
(3,	'process',	'view'),
(3,	'product',	'all'),
(3,	'product',	'browse'),
(3,	'product',	'build'),
(3,	'product',	'dashboard'),
(3,	'product',	'doc'),
(3,	'product',	'dynamic'),
(3,	'product',	'index'),
(3,	'product',	'kanban'),
(3,	'product',	'manageLine'),
(3,	'product',	'project'),
(3,	'product',	'roadmap'),
(3,	'product',	'track'),
(3,	'product',	'view'),
(3,	'product',	'whitelist'),
(3,	'productplan',	'browse'),
(3,	'productplan',	'view'),
(3,	'program',	'browse'),
(3,	'program',	'kanban'),
(3,	'program',	'product'),
(3,	'program',	'project'),
(3,	'program',	'stakeholder'),
(3,	'program',	'view'),
(3,	'project',	'browse'),
(3,	'project',	'bug'),
(3,	'project',	'build'),
(3,	'project',	'dynamic'),
(3,	'project',	'execution'),
(3,	'project',	'group'),
(3,	'project',	'index'),
(3,	'project',	'kanban'),
(3,	'project',	'programTitle'),
(3,	'project',	'qa'),
(3,	'project',	'team'),
(3,	'project',	'testcase'),
(3,	'project',	'testreport'),
(3,	'project',	'testtask'),
(3,	'project',	'view'),
(3,	'project',	'whitelist'),
(3,	'projectbuild',	'browse'),
(3,	'projectrelease',	'browse'),
(3,	'projectrelease',	'view'),
(3,	'projectstory',	'story'),
(3,	'projectstory',	'track'),
(3,	'projectstory',	'view'),
(3,	'pssp',	'browse'),
(3,	'pssp',	'update'),
(3,	'qa',	'index'),
(3,	'release',	'browse'),
(3,	'release',	'export'),
(3,	'release',	'view'),
(3,	'repo',	'blame'),
(3,	'repo',	'browse'),
(3,	'repo',	'diff'),
(3,	'repo',	'download'),
(3,	'repo',	'log'),
(3,	'repo',	'revision'),
(3,	'repo',	'showSyncCommit'),
(3,	'repo',	'view'),
(3,	'report',	'customeRedreport'),
(3,	'report',	'show'),
(3,	'requirement',	'export'),
(3,	'requirement',	'report'),
(3,	'requirement',	'view'),
(3,	'review',	'assess'),
(3,	'review',	'audit'),
(3,	'review',	'browse'),
(3,	'review',	'create'),
(3,	'review',	'edit'),
(3,	'review',	'recall'),
(3,	'review',	'report'),
(3,	'review',	'result'),
(3,	'review',	'submit'),
(3,	'review',	'toAudit'),
(3,	'review',	'view'),
(3,	'reviewcl',	'browse'),
(3,	'reviewissue',	'create'),
(3,	'reviewissue',	'edit'),
(3,	'reviewissue',	'issue'),
(3,	'reviewissue',	'resolved'),
(3,	'reviewissue',	'updateStatus'),
(3,	'reviewissue',	'view'),
(3,	'reviewsetting',	'reviewer'),
(3,	'reviewsetting',	'version'),
(3,	'risk',	'activate'),
(3,	'risk',	'browse'),
(3,	'risk',	'cancel'),
(3,	'risk',	'close'),
(3,	'risk',	'create'),
(3,	'risk',	'edit'),
(3,	'risk',	'hangup'),
(3,	'risk',	'view'),
(3,	'screen',	'annualData'),
(3,	'screen',	'browse'),
(3,	'screen',	'view'),
(3,	'search',	'buildForm'),
(3,	'search',	'buildQuery'),
(3,	'search',	'deleteQuery'),
(3,	'search',	'index'),
(3,	'search',	'saveQuery'),
(3,	'search',	'select'),
(3,	'stage',	'batchCreate'),
(3,	'stage',	'browse'),
(3,	'stage',	'create'),
(3,	'stage',	'delete'),
(3,	'stage',	'edit'),
(3,	'story',	'batchToTask'),
(3,	'story',	'bugs'),
(3,	'story',	'cases'),
(3,	'story',	'export'),
(3,	'story',	'processStoryChange'),
(3,	'story',	'report'),
(3,	'story',	'tasks'),
(3,	'story',	'view'),
(3,	'subject',	'browse'),
(3,	'svn',	'apiSync'),
(3,	'svn',	'cat'),
(3,	'svn',	'diff'),
(3,	'task',	'activate'),
(3,	'task',	'assignTo'),
(3,	'task',	'batchAssignTo'),
(3,	'task',	'batchChangeModule'),
(3,	'task',	'batchClose'),
(3,	'task',	'batchCreate'),
(3,	'task',	'batchEdit'),
(3,	'task',	'cancel'),
(3,	'task',	'close'),
(3,	'task',	'confirmStoryChange'),
(3,	'task',	'create'),
(3,	'task',	'deleteEstimate'),
(3,	'task',	'edit'),
(3,	'task',	'editEstimate'),
(3,	'task',	'export'),
(3,	'task',	'finish'),
(3,	'task',	'pause'),
(3,	'task',	'recordEstimate'),
(3,	'task',	'report'),
(3,	'task',	'restart'),
(3,	'task',	'start'),
(3,	'task',	'view'),
(3,	'testcase',	'batchCaseTypeChange'),
(3,	'testcase',	'batchChangeBranch'),
(3,	'testcase',	'batchChangeModule'),
(3,	'testcase',	'batchConfirmStoryChange'),
(3,	'testcase',	'batchCreate'),
(3,	'testcase',	'batchDelete'),
(3,	'testcase',	'batchEdit'),
(3,	'testcase',	'batchReview'),
(3,	'testcase',	'browse'),
(3,	'testcase',	'bugs'),
(3,	'testcase',	'confirmChange'),
(3,	'testcase',	'confirmLibcaseChange'),
(3,	'testcase',	'confirmStoryChange'),
(3,	'testcase',	'create'),
(3,	'testcase',	'createBug'),
(3,	'testcase',	'delete'),
(3,	'testcase',	'edit'),
(3,	'testcase',	'export'),
(3,	'testcase',	'exportTemplet'),
(3,	'testcase',	'groupCase'),
(3,	'testcase',	'ignoreLibcaseChange'),
(3,	'testcase',	'import'),
(3,	'testcase',	'importFromLib'),
(3,	'testcase',	'index'),
(3,	'testcase',	'linkCases'),
(3,	'testcase',	'review'),
(3,	'testcase',	'showImport'),
(3,	'testcase',	'submit'),
(3,	'testcase',	'view'),
(3,	'testcase',	'zeroCase'),
(3,	'testreport',	'browse'),
(3,	'testreport',	'view'),
(3,	'testsuite',	'batchUnlinkCases'),
(3,	'testsuite',	'browse'),
(3,	'testsuite',	'create'),
(3,	'testsuite',	'delete'),
(3,	'testsuite',	'edit'),
(3,	'testsuite',	'index'),
(3,	'testsuite',	'linkCase'),
(3,	'testsuite',	'test'),
(3,	'testsuite',	'unlinkCase'),
(3,	'testsuite',	'view'),
(3,	'testtask',	'activate'),
(3,	'testtask',	'batchAssign'),
(3,	'testtask',	'batchRun'),
(3,	'testtask',	'batchUnlinkCases'),
(3,	'testtask',	'block'),
(3,	'testtask',	'browse'),
(3,	'testtask',	'browseUnits'),
(3,	'testtask',	'cases'),
(3,	'testtask',	'close'),
(3,	'testtask',	'create'),
(3,	'testtask',	'deployCaseResults'),
(3,	'testtask',	'edit'),
(3,	'testtask',	'groupCase'),
(3,	'testtask',	'importUnitResult'),
(3,	'testtask',	'index'),
(3,	'testtask',	'linkcase'),
(3,	'testtask',	'report'),
(3,	'testtask',	'results'),
(3,	'testtask',	'runcase'),
(3,	'testtask',	'runDeployCase'),
(3,	'testtask',	'start'),
(3,	'testtask',	'unitCases'),
(3,	'testtask',	'unlinkcase'),
(3,	'testtask',	'view'),
(3,	'todo',	'activate'),
(3,	'todo',	'assignTo'),
(3,	'todo',	'batchClose'),
(3,	'todo',	'batchCreate'),
(3,	'todo',	'batchEdit'),
(3,	'todo',	'batchFinish'),
(3,	'todo',	'calendar'),
(3,	'todo',	'close'),
(3,	'todo',	'create'),
(3,	'todo',	'createcycle'),
(3,	'todo',	'delete'),
(3,	'todo',	'edit'),
(3,	'todo',	'export'),
(3,	'todo',	'finish'),
(3,	'todo',	'import2Today'),
(3,	'todo',	'start'),
(3,	'todo',	'view'),
(3,	'trainbook',	'browse'),
(3,	'trainplan',	'browse'),
(3,	'trainplan',	'view'),
(3,	'user',	'bug'),
(3,	'user',	'cropAvatar'),
(3,	'user',	'dynamic'),
(3,	'user',	'effort'),
(3,	'user',	'effortcalendar'),
(3,	'user',	'execution'),
(3,	'user',	'issue'),
(3,	'user',	'profile'),
(3,	'user',	'risk'),
(3,	'user',	'story'),
(3,	'user',	'task'),
(3,	'user',	'testCase'),
(3,	'user',	'testTask'),
(3,	'user',	'todo'),
(3,	'user',	'todocalendar'),
(3,	'user',	'view'),
(3,	'weekly',	'index'),
(3,	'workestimation',	'index'),
(3,	'workloadbudget',	'27'),
(3,	'workloadbudget',	'assign'),
(3,	'workloadbudget',	'batchassign'),
(3,	'workloadbudget',	'batchcreate'),
(3,	'workloadbudget',	'batchedit'),
(3,	'workloadbudget',	'browse'),
(3,	'workloadbudget',	'create'),
(3,	'workloadbudget',	'delete'),
(3,	'workloadbudget',	'edit'),
(3,	'workloadbudget',	'export'),
(3,	'workloadbudget',	'exporttemplate'),
(3,	'workloadbudget',	'import'),
(3,	'workloadbudget',	'link'),
(3,	'workloadbudget',	'search'),
(3,	'workloadbudget',	'showimport'),
(3,	'workloadbudget',	'unlink'),
(3,	'workloadbudget',	'view'),
(4,	'account',	'browse'),
(4,	'account',	'create'),
(4,	'account',	'delete'),
(4,	'account',	'edit'),
(4,	'account',	'view'),
(4,	'action',	'comment'),
(4,	'action',	'editComment'),
(4,	'action',	'hideAll'),
(4,	'action',	'hideOne'),
(4,	'action',	'trash'),
(4,	'action',	'undelete'),
(4,	'activity',	'browse'),
(4,	'activity',	'create'),
(4,	'activity',	'delete'),
(4,	'activity',	'edit'),
(4,	'activity',	'view'),
(4,	'admin',	'checkWeak'),
(4,	'admin',	'index'),
(4,	'admin',	'safe'),
(4,	'attend',	'browseReview'),
(4,	'attend',	'company'),
(4,	'attend',	'department'),
(4,	'attend',	'detail'),
(4,	'attend',	'edit'),
(4,	'attend',	'export'),
(4,	'attend',	'exportDetail'),
(4,	'attend',	'exportStat'),
(4,	'attend',	'personal'),
(4,	'attend',	'review'),
(4,	'attend',	'saveStat'),
(4,	'attend',	'stat'),
(4,	'audit',	'8'),
(4,	'audit',	'assign'),
(4,	'audit',	'batchassign'),
(4,	'audit',	'batchcreate'),
(4,	'audit',	'batchedit'),
(4,	'audit',	'browse'),
(4,	'audit',	'create'),
(4,	'audit',	'delete'),
(4,	'audit',	'edit'),
(4,	'audit',	'export'),
(4,	'audit',	'exporttemplate'),
(4,	'audit',	'import'),
(4,	'audit',	'link'),
(4,	'audit',	'search'),
(4,	'audit',	'showimport'),
(4,	'audit',	'unlink'),
(4,	'audit',	'view'),
(4,	'auditcl',	'browse'),
(4,	'auditcl',	'delete'),
(4,	'auditcl',	'edit'),
(4,	'auditplan',	'browse'),
(4,	'auditplan',	'create'),
(4,	'auditplan',	'edit'),
(4,	'auditplan',	'nc'),
(4,	'auditplan',	'result'),
(4,	'auditresult',	'10'),
(4,	'auditresult',	'assign'),
(4,	'auditresult',	'batchassign'),
(4,	'auditresult',	'batchcreate'),
(4,	'auditresult',	'batchedit'),
(4,	'auditresult',	'browse'),
(4,	'auditresult',	'create'),
(4,	'auditresult',	'delete'),
(4,	'auditresult',	'edit'),
(4,	'auditresult',	'export'),
(4,	'auditresult',	'exporttemplate'),
(4,	'auditresult',	'import'),
(4,	'auditresult',	'link'),
(4,	'auditresult',	'search'),
(4,	'auditresult',	'showimport'),
(4,	'auditresult',	'unlink'),
(4,	'auditresult',	'view'),
(4,	'automation',	'browse'),
(4,	'baseline',	'articleview'),
(4,	'baseline',	'catalog'),
(4,	'baseline',	'createTemplate'),
(4,	'baseline',	'editBook'),
(4,	'baseline',	'editTemplate'),
(4,	'baseline',	'manageBook'),
(4,	'baseline',	'template'),
(4,	'baseline',	'view'),
(4,	'budget',	'batchCreate'),
(4,	'budget',	'browse'),
(4,	'budget',	'create'),
(4,	'budget',	'edit'),
(4,	'budget',	'summary'),
(4,	'budget',	'view'),
(4,	'bug',	'activate'),
(4,	'bug',	'assignTo'),
(4,	'bug',	'batchActivate'),
(4,	'bug',	'batchAssignTo'),
(4,	'bug',	'batchChangeBranch'),
(4,	'bug',	'batchChangeModule'),
(4,	'bug',	'batchClose'),
(4,	'bug',	'batchConfirm'),
(4,	'bug',	'batchCreate'),
(4,	'bug',	'batchEdit'),
(4,	'bug',	'batchResolve'),
(4,	'bug',	'browse'),
(4,	'bug',	'close'),
(4,	'bug',	'confirmBug'),
(4,	'bug',	'confirmStoryChange'),
(4,	'bug',	'create'),
(4,	'bug',	'delete'),
(4,	'bug',	'edit'),
(4,	'bug',	'export'),
(4,	'bug',	'exportTemplet'),
(4,	'bug',	'import'),
(4,	'bug',	'index'),
(4,	'bug',	'linkBugs'),
(4,	'bug',	'report'),
(4,	'bug',	'resolve'),
(4,	'bug',	'showImport'),
(4,	'bug',	'view'),
(4,	'build',	'batchUnlinkBug'),
(4,	'build',	'batchUnlinkStory'),
(4,	'build',	'browse'),
(4,	'build',	'create'),
(4,	'build',	'delete'),
(4,	'build',	'edit'),
(4,	'build',	'linkBug'),
(4,	'build',	'linkStory'),
(4,	'build',	'unlinkBug'),
(4,	'build',	'unlinkStory'),
(4,	'build',	'view'),
(4,	'caselib',	'batchCreateCase'),
(4,	'caselib',	'browse'),
(4,	'caselib',	'create'),
(4,	'caselib',	'createCase'),
(4,	'caselib',	'delete'),
(4,	'caselib',	'edit'),
(4,	'caselib',	'exportTemplet'),
(4,	'caselib',	'import'),
(4,	'caselib',	'index'),
(4,	'caselib',	'justtest'),
(4,	'caselib',	'showImport'),
(4,	'caselib',	'view'),
(4,	'ci',	'checkCompileStatus'),
(4,	'ci',	'commitResult'),
(4,	'classify',	'browse'),
(4,	'cm',	'browse'),
(4,	'cm',	'create'),
(4,	'cm',	'edit'),
(4,	'cm',	'report'),
(4,	'cm',	'view'),
(4,	'cmcl',	'browse'),
(4,	'cmcl',	'delete'),
(4,	'cmcl',	'edit'),
(4,	'cmcl',	'view'),
(4,	'company',	'browse'),
(4,	'company',	'dynamic'),
(4,	'company',	'edit'),
(4,	'company',	'effort'),
(4,	'company',	'index'),
(4,	'company',	'view'),
(4,	'compile',	'browse'),
(4,	'compile',	'logs'),
(4,	'datatable',	'setGlobal'),
(4,	'deploy',	'activate'),
(4,	'deploy',	'assignTo'),
(4,	'deploy',	'batchUnlinkCases'),
(4,	'deploy',	'browse'),
(4,	'deploy',	'cases'),
(4,	'deploy',	'create'),
(4,	'deploy',	'delete'),
(4,	'deploy',	'deleteStep'),
(4,	'deploy',	'edit'),
(4,	'deploy',	'editStep'),
(4,	'deploy',	'finish'),
(4,	'deploy',	'finishStep'),
(4,	'deploy',	'linkCases'),
(4,	'deploy',	'manageScope'),
(4,	'deploy',	'manageStep'),
(4,	'deploy',	'scope'),
(4,	'deploy',	'steps'),
(4,	'deploy',	'unlinkCase'),
(4,	'deploy',	'view'),
(4,	'deploy',	'viewStep'),
(4,	'design',	'browse'),
(4,	'design',	'create'),
(4,	'design',	'delete'),
(4,	'design',	'edit'),
(4,	'design',	'view'),
(4,	'doc',	'catalog'),
(4,	'doc',	'collect'),
(4,	'doc',	'create'),
(4,	'doc',	'createLib'),
(4,	'doc',	'delete'),
(4,	'doc',	'deleteFile'),
(4,	'doc',	'deleteLib'),
(4,	'doc',	'diff'),
(4,	'doc',	'edit'),
(4,	'doc',	'editLib'),
(4,	'doc',	'importToComponentLib'),
(4,	'doc',	'importToPracticeLib'),
(4,	'doc',	'index'),
(4,	'doc',	'manageBook'),
(4,	'doc',	'myCollection'),
(4,	'doc',	'myCreation'),
(4,	'doc',	'myEdited'),
(4,	'doc',	'mySpace'),
(4,	'doc',	'myView'),
(4,	'doc',	'productSpace'),
(4,	'doc',	'projectSpace'),
(4,	'doc',	'showFiles'),
(4,	'doc',	'teamSpace'),
(4,	'doc',	'view'),
(4,	'domain',	'browse'),
(4,	'domain',	'create'),
(4,	'domain',	'delete'),
(4,	'domain',	'edit'),
(4,	'domain',	'view'),
(4,	'durationestimation',	'create'),
(4,	'durationestimation',	'index'),
(4,	'effort',	'batchCreate'),
(4,	'effort',	'batchEdit'),
(4,	'effort',	'calendar'),
(4,	'effort',	'createForObject'),
(4,	'effort',	'delete'),
(4,	'effort',	'edit'),
(4,	'effort',	'export'),
(4,	'effort',	'view'),
(4,	'execution',	'activate'),
(4,	'execution',	'addWhitelist'),
(4,	'execution',	'all'),
(4,	'execution',	'batchedit'),
(4,	'execution',	'batchUnlinkStory'),
(4,	'execution',	'browse'),
(4,	'execution',	'bug'),
(4,	'execution',	'build'),
(4,	'execution',	'burn'),
(4,	'execution',	'burnData'),
(4,	'execution',	'calendar'),
(4,	'execution',	'close'),
(4,	'execution',	'computeBurn'),
(4,	'execution',	'computeTaskEffort'),
(4,	'execution',	'create'),
(4,	'execution',	'delete'),
(4,	'execution',	'deleterelation'),
(4,	'execution',	'doc'),
(4,	'execution',	'dynamic'),
(4,	'execution',	'edit'),
(4,	'execution',	'effort'),
(4,	'execution',	'effortCalendar'),
(4,	'execution',	'executionkanban'),
(4,	'execution',	'export'),
(4,	'execution',	'fixFirst'),
(4,	'execution',	'gantt'),
(4,	'execution',	'grouptask'),
(4,	'execution',	'importBug'),
(4,	'execution',	'importplanstories'),
(4,	'execution',	'importtask'),
(4,	'execution',	'index'),
(4,	'execution',	'kanban'),
(4,	'execution',	'linkStory'),
(4,	'execution',	'maintainrelation'),
(4,	'execution',	'manageMembers'),
(4,	'execution',	'manageProducts'),
(4,	'execution',	'printKanban'),
(4,	'execution',	'putoff'),
(4,	'execution',	'relation'),
(4,	'execution',	'start'),
(4,	'execution',	'story'),
(4,	'execution',	'storyEstimate'),
(4,	'execution',	'storyKanban'),
(4,	'execution',	'storySort'),
(4,	'execution',	'storyView'),
(4,	'execution',	'suspend'),
(4,	'execution',	'task'),
(4,	'execution',	'taskEffort'),
(4,	'execution',	'team'),
(4,	'execution',	'testcase'),
(4,	'execution',	'testreport'),
(4,	'execution',	'testtask'),
(4,	'execution',	'tree'),
(4,	'execution',	'treeStory'),
(4,	'execution',	'treeTask'),
(4,	'execution',	'unbindWhitelist'),
(4,	'execution',	'unlinkMember'),
(4,	'execution',	'unlinkStory'),
(4,	'execution',	'updateOrder'),
(4,	'execution',	'view'),
(4,	'execution',	'whitelist'),
(4,	'extension',	'browse'),
(4,	'extension',	'obtain'),
(4,	'extension',	'structure'),
(4,	'faq',	'browse'),
(4,	'feedback',	'admin'),
(4,	'feedback',	'adminView'),
(4,	'feedback',	'assignTo'),
(4,	'feedback',	'batchAssignTo'),
(4,	'feedback',	'batchChangeModule'),
(4,	'feedback',	'batchClose'),
(4,	'feedback',	'batchEdit'),
(4,	'feedback',	'batchReview'),
(4,	'feedback',	'browse'),
(4,	'feedback',	'close'),
(4,	'feedback',	'comment'),
(4,	'feedback',	'create'),
(4,	'feedback',	'delete'),
(4,	'feedback',	'edit'),
(4,	'feedback',	'export'),
(4,	'feedback',	'index'),
(4,	'feedback',	'manageProduct'),
(4,	'feedback',	'products'),
(4,	'feedback',	'review'),
(4,	'feedback',	'view'),
(4,	'file',	'delete'),
(4,	'file',	'download'),
(4,	'file',	'edit'),
(4,	'file',	'setPublic'),
(4,	'file',	'uploadImages'),
(4,	'gapanalysis',	'batchCreate'),
(4,	'gapanalysis',	'batchEdit'),
(4,	'gapanalysis',	'browse'),
(4,	'gapanalysis',	'create'),
(4,	'gapanalysis',	'delete'),
(4,	'gapanalysis',	'edit'),
(4,	'gapanalysis',	'view'),
(4,	'git',	'apiSync'),
(4,	'git',	'cat'),
(4,	'git',	'diff'),
(4,	'group',	'browse'),
(4,	'host',	'browse'),
(4,	'host',	'create'),
(4,	'host',	'delete'),
(4,	'host',	'edit'),
(4,	'host',	'treemap'),
(4,	'host',	'view'),
(4,	'index',	'index'),
(4,	'issue',	'activate'),
(4,	'issue',	'batchCreate'),
(4,	'issue',	'browse'),
(4,	'issue',	'cancel'),
(4,	'issue',	'close'),
(4,	'issue',	'create'),
(4,	'issue',	'delete'),
(4,	'issue',	'edit'),
(4,	'issue',	'resolve'),
(4,	'issue',	'view'),
(4,	'jenkins',	'browse'),
(4,	'jenkins',	'create'),
(4,	'jenkins',	'delete'),
(4,	'jenkins',	'edit'),
(4,	'job',	'browse'),
(4,	'job',	'create'),
(4,	'job',	'delete'),
(4,	'job',	'edit'),
(4,	'job',	'exec'),
(4,	'job',	'view'),
(4,	'leave',	'back'),
(4,	'leave',	'browseReview'),
(4,	'leave',	'company'),
(4,	'leave',	'create'),
(4,	'leave',	'delete'),
(4,	'leave',	'edit'),
(4,	'leave',	'export'),
(4,	'leave',	'personal'),
(4,	'leave',	'personalAnnual'),
(4,	'leave',	'review'),
(4,	'leave',	'setReviewer'),
(4,	'leave',	'switchstatus'),
(4,	'leave',	'view'),
(4,	'lieu',	'browseReview'),
(4,	'lieu',	'company'),
(4,	'lieu',	'create'),
(4,	'lieu',	'delete'),
(4,	'lieu',	'edit'),
(4,	'lieu',	'personal'),
(4,	'lieu',	'review'),
(4,	'lieu',	'setReviewer'),
(4,	'lieu',	'switchstatus'),
(4,	'lieu',	'view'),
(4,	'makeup',	'browseReview'),
(4,	'makeup',	'company'),
(4,	'makeup',	'create'),
(4,	'makeup',	'delete'),
(4,	'makeup',	'edit'),
(4,	'makeup',	'export'),
(4,	'makeup',	'personal'),
(4,	'makeup',	'review'),
(4,	'makeup',	'setReviewer'),
(4,	'makeup',	'switchstatus'),
(4,	'makeup',	'view'),
(4,	'meeting',	'browse'),
(4,	'meeting',	'create'),
(4,	'meeting',	'delete'),
(4,	'meeting',	'edit'),
(4,	'meeting',	'minutes'),
(4,	'meeting',	'view'),
(4,	'meetingroom',	'batchCreate'),
(4,	'meetingroom',	'batchEdit'),
(4,	'meetingroom',	'browse'),
(4,	'meetingroom',	'create'),
(4,	'meetingroom',	'delete'),
(4,	'meetingroom',	'edit'),
(4,	'meetingroom',	'view'),
(4,	'metting',	'127'),
(4,	'metting',	'assign'),
(4,	'metting',	'batchassign'),
(4,	'metting',	'batchcreate'),
(4,	'metting',	'batchedit'),
(4,	'metting',	'browse'),
(4,	'metting',	'create'),
(4,	'metting',	'delete'),
(4,	'metting',	'edit'),
(4,	'metting',	'export'),
(4,	'metting',	'exporttemplate'),
(4,	'metting',	'import'),
(4,	'metting',	'link'),
(4,	'metting',	'report'),
(4,	'metting',	'search'),
(4,	'metting',	'showimport'),
(4,	'metting',	'unlink'),
(4,	'metting',	'view'),
(4,	'milestone',	'index'),
(4,	'milestone',	'saveOtherProblem'),
(4,	'misc',	'ping'),
(4,	'my',	'bug'),
(4,	'my',	'calendar'),
(4,	'my',	'changePassword'),
(4,	'my',	'contribute'),
(4,	'my',	'deleteContacts'),
(4,	'my',	'doc'),
(4,	'my',	'dynamic'),
(4,	'my',	'editProfile'),
(4,	'my',	'effort'),
(4,	'my',	'execution'),
(4,	'my',	'index'),
(4,	'my',	'issue'),
(4,	'my',	'manageContacts'),
(4,	'my',	'meeting'),
(4,	'my',	'myMeeting'),
(4,	'my',	'nc'),
(4,	'my',	'preference'),
(4,	'my',	'profile'),
(4,	'my',	'project'),
(4,	'my',	'review'),
(4,	'my',	'risk'),
(4,	'my',	'score'),
(4,	'my',	'story'),
(4,	'my',	'task'),
(4,	'my',	'team'),
(4,	'my',	'testcase'),
(4,	'my',	'testtask'),
(4,	'my',	'todo'),
(4,	'my',	'unbind'),
(4,	'my',	'uploadAvatar'),
(4,	'my',	'work'),
(4,	'nc',	'16'),
(4,	'nc',	'activate'),
(4,	'nc',	'assign'),
(4,	'nc',	'batchassign'),
(4,	'nc',	'batchcreate'),
(4,	'nc',	'batchedit'),
(4,	'nc',	'browse'),
(4,	'nc',	'close'),
(4,	'nc',	'create'),
(4,	'nc',	'delete'),
(4,	'nc',	'edit'),
(4,	'nc',	'export'),
(4,	'nc',	'exporttemplate'),
(4,	'nc',	'import'),
(4,	'nc',	'link'),
(4,	'nc',	'resolve'),
(4,	'nc',	'search'),
(4,	'nc',	'showimport'),
(4,	'nc',	'unlink'),
(4,	'nc',	'view'),
(4,	'opportunity',	'activate'),
(4,	'opportunity',	'assignTo'),
(4,	'opportunity',	'batchActivate'),
(4,	'opportunity',	'batchAssignTo'),
(4,	'opportunity',	'batchCancel'),
(4,	'opportunity',	'batchClose'),
(4,	'opportunity',	'batchCreate'),
(4,	'opportunity',	'batchEdit'),
(4,	'opportunity',	'batchHangup'),
(4,	'opportunity',	'batchImportToLib'),
(4,	'opportunity',	'browse'),
(4,	'opportunity',	'cancel'),
(4,	'opportunity',	'close'),
(4,	'opportunity',	'create'),
(4,	'opportunity',	'delete'),
(4,	'opportunity',	'edit'),
(4,	'opportunity',	'hangup'),
(4,	'opportunity',	'importFromLib'),
(4,	'opportunity',	'importToLib'),
(4,	'opportunity',	'track'),
(4,	'opportunity',	'view'),
(4,	'ops',	'index'),
(4,	'ops',	'setting'),
(4,	'output',	'13'),
(4,	'output',	'assign'),
(4,	'output',	'batchassign'),
(4,	'output',	'batchcreate'),
(4,	'output',	'batchedit'),
(4,	'output',	'browse'),
(4,	'output',	'create'),
(4,	'output',	'delete'),
(4,	'output',	'edit'),
(4,	'output',	'export'),
(4,	'output',	'exporttemplate'),
(4,	'output',	'import'),
(4,	'output',	'link'),
(4,	'output',	'search'),
(4,	'output',	'showimport'),
(4,	'output',	'unlink'),
(4,	'output',	'view'),
(4,	'overtime',	'browseReview'),
(4,	'overtime',	'company'),
(4,	'overtime',	'create'),
(4,	'overtime',	'delete'),
(4,	'overtime',	'edit'),
(4,	'overtime',	'export'),
(4,	'overtime',	'personal'),
(4,	'overtime',	'review'),
(4,	'overtime',	'setReviewer'),
(4,	'overtime',	'switchstatus'),
(4,	'overtime',	'view'),
(4,	'personnel',	'accessible'),
(4,	'personnel',	'addWhitelist'),
(4,	'personnel',	'invest'),
(4,	'personnel',	'unbindWhitelist'),
(4,	'personnel',	'whitelist'),
(4,	'pivot',	'browse'),
(4,	'pivot',	'bugAssign'),
(4,	'pivot',	'bugAssignSummary'),
(4,	'pivot',	'bugCreate'),
(4,	'pivot',	'bugSummary'),
(4,	'pivot',	'build'),
(4,	'pivot',	'casesrun'),
(4,	'pivot',	'create'),
(4,	'pivot',	'delete'),
(4,	'pivot',	'design'),
(4,	'pivot',	'edit'),
(4,	'pivot',	'export'),
(4,	'pivot',	'preview'),
(4,	'pivot',	'productSummary'),
(4,	'pivot',	'projectDeviation'),
(4,	'pivot',	'projectSummary'),
(4,	'pivot',	'projectWorkload'),
(4,	'pivot',	'reportExport'),
(4,	'pivot',	'roadmap'),
(4,	'pivot',	'storyLinkedBug'),
(4,	'pivot',	'testcase'),
(4,	'pivot',	'workAssignSummary'),
(4,	'pivot',	'workload'),
(4,	'pivot',	'workSummary'),
(4,	'process',	'browse'),
(4,	'process',	'create'),
(4,	'process',	'delete'),
(4,	'process',	'edit'),
(4,	'process',	'view'),
(4,	'product',	'all'),
(4,	'product',	'batchEdit'),
(4,	'product',	'browse'),
(4,	'product',	'build'),
(4,	'product',	'close'),
(4,	'product',	'create'),
(4,	'product',	'dashboard'),
(4,	'product',	'delete'),
(4,	'product',	'doc'),
(4,	'product',	'dynamic'),
(4,	'product',	'edit'),
(4,	'product',	'index'),
(4,	'product',	'kanban'),
(4,	'product',	'manageLine'),
(4,	'product',	'project'),
(4,	'product',	'roadmap'),
(4,	'product',	'track'),
(4,	'product',	'view'),
(4,	'product',	'whitelist'),
(4,	'productplan',	'batchEdit'),
(4,	'productplan',	'batchUnlinkBug'),
(4,	'productplan',	'batchUnlinkStory'),
(4,	'productplan',	'browse'),
(4,	'productplan',	'create'),
(4,	'productplan',	'delete'),
(4,	'productplan',	'edit'),
(4,	'productplan',	'linkBug'),
(4,	'productplan',	'linkStory'),
(4,	'productplan',	'unlinkBug'),
(4,	'productplan',	'unlinkStory'),
(4,	'productplan',	'view'),
(4,	'program',	'activate'),
(4,	'program',	'browse'),
(4,	'program',	'close'),
(4,	'program',	'create'),
(4,	'program',	'createStakeholder'),
(4,	'program',	'delete'),
(4,	'program',	'edit'),
(4,	'program',	'export'),
(4,	'program',	'index'),
(4,	'program',	'kanban'),
(4,	'program',	'product'),
(4,	'program',	'project'),
(4,	'program',	'stakeholder'),
(4,	'program',	'start'),
(4,	'program',	'suspend'),
(4,	'program',	'unbindWhitelist'),
(4,	'program',	'unlinkStakeholder'),
(4,	'program',	'updateOrder'),
(4,	'program',	'view'),
(4,	'programplan',	'browse'),
(4,	'programplan',	'create'),
(4,	'programplan',	'edit'),
(4,	'project',	'activate'),
(4,	'project',	'addWhitelist'),
(4,	'project',	'batchEdit'),
(4,	'project',	'browse'),
(4,	'project',	'bug'),
(4,	'project',	'build'),
(4,	'project',	'close'),
(4,	'project',	'copyGroup'),
(4,	'project',	'create'),
(4,	'project',	'createGroup'),
(4,	'project',	'createGuide'),
(4,	'project',	'createStakeholder'),
(4,	'project',	'delete'),
(4,	'project',	'dynamic'),
(4,	'project',	'edit'),
(4,	'project',	'editGroup'),
(4,	'project',	'execution'),
(4,	'project',	'export'),
(4,	'project',	'group'),
(4,	'project',	'index'),
(4,	'project',	'kanban'),
(4,	'project',	'manageGroupMember'),
(4,	'project',	'manageMembers'),
(4,	'project',	'managePriv'),
(4,	'project',	'manageProducts'),
(4,	'project',	'manageView'),
(4,	'project',	'programTitle'),
(4,	'project',	'qa'),
(4,	'project',	'start'),
(4,	'project',	'suspend'),
(4,	'project',	'team'),
(4,	'project',	'testcase'),
(4,	'project',	'testreport'),
(4,	'project',	'testtask'),
(4,	'project',	'unbindWhitelist'),
(4,	'project',	'unlinkMember'),
(4,	'project',	'updateOrder'),
(4,	'project',	'view'),
(4,	'project',	'whitelist'),
(4,	'projectbuild',	'browse'),
(4,	'projectrelease',	'batchUnlinkBug'),
(4,	'projectrelease',	'batchUnlinkStory'),
(4,	'projectrelease',	'browse'),
(4,	'projectrelease',	'changeStatus'),
(4,	'projectrelease',	'create'),
(4,	'projectrelease',	'delete'),
(4,	'projectrelease',	'edit'),
(4,	'projectrelease',	'export'),
(4,	'projectrelease',	'linkBug'),
(4,	'projectrelease',	'linkStory'),
(4,	'projectrelease',	'unlinkBug'),
(4,	'projectrelease',	'unlinkStory'),
(4,	'projectrelease',	'view'),
(4,	'projectstory',	'batchUnlinkStory'),
(4,	'projectstory',	'importFromLib'),
(4,	'projectstory',	'importplanstories'),
(4,	'projectstory',	'linkStory'),
(4,	'projectstory',	'story'),
(4,	'projectstory',	'track'),
(4,	'projectstory',	'unlinkStory'),
(4,	'projectstory',	'view'),
(4,	'pssp',	'browse'),
(4,	'pssp',	'update'),
(4,	'qa',	'index'),
(4,	'release',	'batchUnlinkBug'),
(4,	'release',	'batchUnlinkStory'),
(4,	'release',	'browse'),
(4,	'release',	'changeStatus'),
(4,	'release',	'create'),
(4,	'release',	'delete'),
(4,	'release',	'edit'),
(4,	'release',	'export'),
(4,	'release',	'linkBug'),
(4,	'release',	'linkStory'),
(4,	'release',	'unlinkBug'),
(4,	'release',	'unlinkStory'),
(4,	'release',	'view'),
(4,	'repo',	'blame'),
(4,	'repo',	'browse'),
(4,	'repo',	'create'),
(4,	'repo',	'delete'),
(4,	'repo',	'diff'),
(4,	'repo',	'download'),
(4,	'repo',	'edit'),
(4,	'repo',	'log'),
(4,	'repo',	'maintain'),
(4,	'repo',	'revision'),
(4,	'repo',	'setRules'),
(4,	'repo',	'showSyncCommit'),
(4,	'repo',	'view'),
(4,	'report',	'crystalExport'),
(4,	'report',	'custom'),
(4,	'report',	'customeredReport'),
(4,	'report',	'deleteReport'),
(4,	'report',	'editReport'),
(4,	'report',	'export'),
(4,	'report',	'viewReport'),
(4,	'report',	'saveReport'),
(4,	'report',	'show'),
(4,	'report',	'useReport'),
(4,	'requirement',	'activate'),
(4,	'requirement',	'assignTo'),
(4,	'requirement',	'batchAssignTo'),
(4,	'requirement',	'batchChangeBranch'),
(4,	'requirement',	'batchChangeModule'),
(4,	'requirement',	'batchClose'),
(4,	'requirement',	'batchCreate'),
(4,	'requirement',	'batchEdit'),
(4,	'requirement',	'batchReview'),
(4,	'requirement',	'change'),
(4,	'requirement',	'close'),
(4,	'requirement',	'create'),
(4,	'requirement',	'delete'),
(4,	'requirement',	'edit'),
(4,	'requirement',	'export'),
(4,	'requirement',	'recall'),
(4,	'requirement',	'report'),
(4,	'requirement',	'review'),
(4,	'requirement',	'view'),
(4,	'review',	'assess'),
(4,	'review',	'audit'),
(4,	'review',	'browse'),
(4,	'review',	'create'),
(4,	'review',	'edit'),
(4,	'review',	'recall'),
(4,	'review',	'report'),
(4,	'review',	'result'),
(4,	'review',	'submit'),
(4,	'review',	'toAudit'),
(4,	'review',	'view'),
(4,	'reviewcl',	'browse'),
(4,	'reviewcl',	'create'),
(4,	'reviewcl',	'delete'),
(4,	'reviewcl',	'edit'),
(4,	'reviewcl',	'view'),
(4,	'reviewissue',	'create'),
(4,	'reviewissue',	'edit'),
(4,	'reviewissue',	'issue'),
(4,	'reviewissue',	'resolved'),
(4,	'reviewissue',	'updateStatus'),
(4,	'reviewissue',	'view'),
(4,	'reviewsetting',	'reviewer'),
(4,	'reviewsetting',	'version'),
(4,	'risk',	'activate'),
(4,	'risk',	'assignTo'),
(4,	'risk',	'batchCreate'),
(4,	'risk',	'browse'),
(4,	'risk',	'cancel'),
(4,	'risk',	'close'),
(4,	'risk',	'create'),
(4,	'risk',	'delete'),
(4,	'risk',	'edit'),
(4,	'risk',	'hangup'),
(4,	'risk',	'importFromLib'),
(4,	'risk',	'track'),
(4,	'risk',	'view'),
(4,	'screen',	'annualData'),
(4,	'screen',	'browse'),
(4,	'screen',	'view'),
(4,	'search',	'buildForm'),
(4,	'search',	'buildQuery'),
(4,	'search',	'deleteQuery'),
(4,	'search',	'index'),
(4,	'search',	'saveQuery'),
(4,	'search',	'select'),
(4,	'serverroom',	'browse'),
(4,	'serverroom',	'create'),
(4,	'serverroom',	'delete'),
(4,	'serverroom',	'edit'),
(4,	'serverroom',	'view'),
(4,	'service',	'browse'),
(4,	'service',	'create'),
(4,	'service',	'delete'),
(4,	'service',	'edit'),
(4,	'service',	'index'),
(4,	'service',	'manage'),
(4,	'service',	'view'),
(4,	'stage',	'batchCreate'),
(4,	'stage',	'browse'),
(4,	'stage',	'create'),
(4,	'stage',	'delete'),
(4,	'stage',	'edit'),
(4,	'stakeholder',	'batchCreate'),
(4,	'stakeholder',	'browse'),
(4,	'stakeholder',	'communicate'),
(4,	'stakeholder',	'create'),
(4,	'stakeholder',	'createExpect'),
(4,	'stakeholder',	'delete'),
(4,	'stakeholder',	'deleteExpect'),
(4,	'stakeholder',	'edit'),
(4,	'stakeholder',	'editExpect'),
(4,	'stakeholder',	'expect'),
(4,	'stakeholder',	'expectation'),
(4,	'stakeholder',	'issue'),
(4,	'stakeholder',	'plan'),
(4,	'stakeholder',	'userIssue'),
(4,	'stakeholder',	'view'),
(4,	'stakeholder',	'viewExpect'),
(4,	'stakeholder',	'viewIssue'),
(4,	'story',	'activate'),
(4,	'story',	'assignTo'),
(4,	'story',	'batchAssignTo'),
(4,	'story',	'batchChangeBranch'),
(4,	'story',	'batchChangeModule'),
(4,	'story',	'batchChangePlan'),
(4,	'story',	'batchChangeStage'),
(4,	'story',	'batchClose'),
(4,	'story',	'batchCreate'),
(4,	'story',	'batchEdit'),
(4,	'story',	'batchImportToLib'),
(4,	'story',	'batchReview'),
(4,	'story',	'batchToTask'),
(4,	'story',	'browse'),
(4,	'story',	'bugs'),
(4,	'story',	'cases'),
(4,	'story',	'change'),
(4,	'story',	'close'),
(4,	'story',	'create'),
(4,	'story',	'delete'),
(4,	'story',	'edit'),
(4,	'story',	'export'),
(4,	'story',	'exportTemplet'),
(4,	'story',	'import'),
(4,	'story',	'importToLib'),
(4,	'story',	'linkStory'),
(4,	'story',	'processStoryChange'),
(4,	'story',	'recall'),
(4,	'story',	'report'),
(4,	'story',	'review'),
(4,	'story',	'showImport'),
(4,	'story',	'tasks'),
(4,	'story',	'view'),
(4,	'subject',	'browse'),
(4,	'svn',	'apiSync'),
(4,	'svn',	'cat'),
(4,	'svn',	'diff'),
(4,	'task',	'activate'),
(4,	'task',	'assignTo'),
(4,	'task',	'batchAssignTo'),
(4,	'task',	'batchCancel'),
(4,	'task',	'batchChangeModule'),
(4,	'task',	'batchClose'),
(4,	'task',	'batchCreate'),
(4,	'task',	'batchEdit'),
(4,	'task',	'cancel'),
(4,	'task',	'close'),
(4,	'task',	'confirmdesignchange'),
(4,	'task',	'confirmStoryChange'),
(4,	'task',	'create'),
(4,	'task',	'delete'),
(4,	'task',	'deleteEstimate'),
(4,	'task',	'edit'),
(4,	'task',	'editEstimate'),
(4,	'task',	'export'),
(4,	'task',	'exportTemplet'),
(4,	'task',	'finish'),
(4,	'task',	'import'),
(4,	'task',	'pause'),
(4,	'task',	'recordEstimate'),
(4,	'task',	'report'),
(4,	'task',	'restart'),
(4,	'task',	'showImport'),
(4,	'task',	'start'),
(4,	'task',	'view'),
(4,	'testcase',	'batchCaseTypeChange'),
(4,	'testcase',	'batchChangeBranch'),
(4,	'testcase',	'batchChangeModule'),
(4,	'testcase',	'batchConfirmStoryChange'),
(4,	'testcase',	'batchCreate'),
(4,	'testcase',	'batchDelete'),
(4,	'testcase',	'batchEdit'),
(4,	'testcase',	'batchReview'),
(4,	'testcase',	'browse'),
(4,	'testcase',	'bugs'),
(4,	'testcase',	'confirmChange'),
(4,	'testcase',	'confirmLibcaseChange'),
(4,	'testcase',	'confirmStoryChange'),
(4,	'testcase',	'create'),
(4,	'testcase',	'createBug'),
(4,	'testcase',	'delete'),
(4,	'testcase',	'edit'),
(4,	'testcase',	'export'),
(4,	'testcase',	'exportTemplet'),
(4,	'testcase',	'groupCase'),
(4,	'testcase',	'ignoreLibcaseChange'),
(4,	'testcase',	'import'),
(4,	'testcase',	'importFromLib'),
(4,	'testcase',	'index'),
(4,	'testcase',	'linkCases'),
(4,	'testcase',	'review'),
(4,	'testcase',	'showImport'),
(4,	'testcase',	'submit'),
(4,	'testcase',	'view'),
(4,	'testcase',	'zeroCase'),
(4,	'testreport',	'browse'),
(4,	'testreport',	'create'),
(4,	'testreport',	'delete'),
(4,	'testreport',	'edit'),
(4,	'testreport',	'export'),
(4,	'testreport',	'view'),
(4,	'testsuite',	'batchUnlinkCases'),
(4,	'testsuite',	'browse'),
(4,	'testsuite',	'create'),
(4,	'testsuite',	'delete'),
(4,	'testsuite',	'edit'),
(4,	'testsuite',	'index'),
(4,	'testsuite',	'linkCase'),
(4,	'testsuite',	'test'),
(4,	'testsuite',	'unlinkCase'),
(4,	'testsuite',	'view'),
(4,	'testtask',	'activate'),
(4,	'testtask',	'batchAssign'),
(4,	'testtask',	'batchRun'),
(4,	'testtask',	'batchUnlinkCases'),
(4,	'testtask',	'block'),
(4,	'testtask',	'browse'),
(4,	'testtask',	'browseUnits'),
(4,	'testtask',	'cases'),
(4,	'testtask',	'close'),
(4,	'testtask',	'create'),
(4,	'testtask',	'delete'),
(4,	'testtask',	'deployCaseResults'),
(4,	'testtask',	'edit'),
(4,	'testtask',	'groupCase'),
(4,	'testtask',	'importUnitResult'),
(4,	'testtask',	'index'),
(4,	'testtask',	'linkcase'),
(4,	'testtask',	'report'),
(4,	'testtask',	'results'),
(4,	'testtask',	'runcase'),
(4,	'testtask',	'runDeployCase'),
(4,	'testtask',	'start'),
(4,	'testtask',	'unitCases'),
(4,	'testtask',	'unlinkcase'),
(4,	'testtask',	'view'),
(4,	'todo',	'activate'),
(4,	'todo',	'assignTo'),
(4,	'todo',	'batchClose'),
(4,	'todo',	'batchCreate'),
(4,	'todo',	'batchEdit'),
(4,	'todo',	'batchFinish'),
(4,	'todo',	'calendar'),
(4,	'todo',	'close'),
(4,	'todo',	'create'),
(4,	'todo',	'createcycle'),
(4,	'todo',	'delete'),
(4,	'todo',	'edit'),
(4,	'todo',	'export'),
(4,	'todo',	'finish'),
(4,	'todo',	'import2Today'),
(4,	'todo',	'start'),
(4,	'todo',	'view'),
(4,	'trainbook',	'ajaxgetbookbysn'),
(4,	'trainbook',	'borrow'),
(4,	'trainbook',	'borrowhistory'),
(4,	'trainbook',	'browse'),
(4,	'trainbook',	'returnbook'),
(4,	'trainbook',	'view'),
(4,	'traincareer',	'index'),
(4,	'trainchapter',	'browse'),
(4,	'trainchapter',	'download'),
(4,	'trainchapter',	'showDocFiles'),
(4,	'trainchapter',	'view'),
(4,	'traincourse',	'browse'),
(4,	'traincourse',	'collect'),
(4,	'traincourse',	'view'),
(4,	'trainexam',	'browse'),
(4,	'trainexam',	'choseExam'),
(4,	'trainexam',	'exam'),
(4,	'trainexam',	'myExams'),
(4,	'trainexam',	'scoreDetail'),
(4,	'traingoal',	'browse'),
(4,	'traingoal',	'create'),
(4,	'traingoal',	'delete'),
(4,	'traingoal',	'edit'),
(4,	'traingoal',	'recall'),
(4,	'traingoal',	'review'),
(4,	'traingoal',	'submitReview'),
(4,	'traingoal',	'updateOrder'),
(4,	'traingoal',	'view'),
(4,	'trainplan',	'batchCreate'),
(4,	'trainplan',	'batchEdit'),
(4,	'trainplan',	'batchFinish'),
(4,	'trainplan',	'browse'),
(4,	'trainplan',	'create'),
(4,	'trainplan',	'delete'),
(4,	'trainplan',	'edit'),
(4,	'trainplan',	'finish'),
(4,	'trainplan',	'summary'),
(4,	'trainplan',	'view'),
(4,	'trainpost',	'browse'),
(4,	'trainpost',	'gradeView'),
(4,	'trainpost',	'view'),
(4,	'trainskill',	'browse'),
(4,	'trainskill',	'editGrade'),
(4,	'trainskill',	'view'),
(4,	'traintask',	'browse'),
(4,	'traintask',	'browseDeptTasks'),
(4,	'traintask',	'close'),
(4,	'traintask',	'create'),
(4,	'traintask',	'createTask'),
(4,	'traintask',	'delete'),
(4,	'traintask',	'edit'),
(4,	'traintask',	'finish'),
(4,	'traintask',	'import'),
(4,	'traintask',	'start'),
(4,	'traintask',	'view'),
(4,	'tree',	'browse'),
(4,	'tree',	'browsehost'),
(4,	'tree',	'browseTask'),
(4,	'tree',	'delete'),
(4,	'tree',	'edit'),
(4,	'tree',	'fix'),
(4,	'tree',	'manageChild'),
(4,	'tree',	'updateOrder'),
(4,	'user',	'bug'),
(4,	'user',	'cropAvatar'),
(4,	'user',	'dynamic'),
(4,	'user',	'effort'),
(4,	'user',	'effortcalendar'),
(4,	'user',	'execution'),
(4,	'user',	'issue'),
(4,	'user',	'profile'),
(4,	'user',	'risk'),
(4,	'user',	'setPublicTemplate'),
(4,	'user',	'story'),
(4,	'user',	'task'),
(4,	'user',	'testCase'),
(4,	'user',	'testTask'),
(4,	'user',	'todo'),
(4,	'user',	'todocalendar'),
(4,	'user',	'view'),
(4,	'weekly',	'index'),
(4,	'workestimation',	'index'),
(4,	'workloadbudget',	'27'),
(4,	'workloadbudget',	'assign'),
(4,	'workloadbudget',	'batchassign'),
(4,	'workloadbudget',	'batchcreate'),
(4,	'workloadbudget',	'batchedit'),
(4,	'workloadbudget',	'browse'),
(4,	'workloadbudget',	'create'),
(4,	'workloadbudget',	'delete'),
(4,	'workloadbudget',	'edit'),
(4,	'workloadbudget',	'export'),
(4,	'workloadbudget',	'exporttemplate'),
(4,	'workloadbudget',	'import'),
(4,	'workloadbudget',	'link'),
(4,	'workloadbudget',	'search'),
(4,	'workloadbudget',	'showimport'),
(4,	'workloadbudget',	'unlink'),
(4,	'workloadbudget',	'view'),
(5,	'account',	'browse'),
(5,	'account',	'create'),
(5,	'account',	'delete'),
(5,	'account',	'edit'),
(5,	'account',	'view'),
(5,	'action',	'comment'),
(5,	'action',	'editComment'),
(5,	'action',	'hideAll'),
(5,	'action',	'hideOne'),
(5,	'action',	'trash'),
(5,	'action',	'undelete'),
(5,	'activity',	'browse'),
(5,	'activity',	'create'),
(5,	'activity',	'delete'),
(5,	'activity',	'edit'),
(5,	'activity',	'view'),
(5,	'admin',	'checkWeak'),
(5,	'admin',	'index'),
(5,	'admin',	'safe'),
(5,	'attend',	'company'),
(5,	'attend',	'department'),
(5,	'attend',	'edit'),
(5,	'attend',	'export'),
(5,	'attend',	'personal'),
(5,	'attend',	'review'),
(5,	'audit',	'8'),
(5,	'audit',	'assign'),
(5,	'audit',	'batchassign'),
(5,	'audit',	'batchcreate'),
(5,	'audit',	'batchedit'),
(5,	'audit',	'browse'),
(5,	'audit',	'create'),
(5,	'audit',	'delete'),
(5,	'audit',	'edit'),
(5,	'audit',	'export'),
(5,	'audit',	'exporttemplate'),
(5,	'audit',	'import'),
(5,	'audit',	'link'),
(5,	'audit',	'search'),
(5,	'audit',	'showimport'),
(5,	'audit',	'unlink'),
(5,	'audit',	'view'),
(5,	'auditcl',	'browse'),
(5,	'auditcl',	'delete'),
(5,	'auditcl',	'edit'),
(5,	'auditplan',	'browse'),
(5,	'auditplan',	'create'),
(5,	'auditplan',	'edit'),
(5,	'auditplan',	'nc'),
(5,	'auditplan',	'result'),
(5,	'auditresult',	'10'),
(5,	'auditresult',	'assign'),
(5,	'auditresult',	'batchassign'),
(5,	'auditresult',	'batchcreate'),
(5,	'auditresult',	'batchedit'),
(5,	'auditresult',	'browse'),
(5,	'auditresult',	'create'),
(5,	'auditresult',	'delete'),
(5,	'auditresult',	'edit'),
(5,	'auditresult',	'export'),
(5,	'auditresult',	'exporttemplate'),
(5,	'auditresult',	'import'),
(5,	'auditresult',	'link'),
(5,	'auditresult',	'search'),
(5,	'auditresult',	'showimport'),
(5,	'auditresult',	'unlink'),
(5,	'auditresult',	'view'),
(5,	'automation',	'browse'),
(5,	'baseline',	'articleview'),
(5,	'baseline',	'catalog'),
(5,	'baseline',	'createTemplate'),
(5,	'baseline',	'editBook'),
(5,	'baseline',	'editTemplate'),
(5,	'baseline',	'manageBook'),
(5,	'baseline',	'template'),
(5,	'baseline',	'view'),
(5,	'branch',	'delete'),
(5,	'branch',	'manage'),
(5,	'branch',	'sort'),
(5,	'budget',	'batchCreate'),
(5,	'budget',	'browse'),
(5,	'budget',	'create'),
(5,	'budget',	'edit'),
(5,	'budget',	'summary'),
(5,	'budget',	'view'),
(5,	'bug',	'activate'),
(5,	'bug',	'assignTo'),
(5,	'bug',	'batchActivate'),
(5,	'bug',	'batchAssignTo'),
(5,	'bug',	'batchChangeBranch'),
(5,	'bug',	'batchChangeModule'),
(5,	'bug',	'batchClose'),
(5,	'bug',	'batchConfirm'),
(5,	'bug',	'batchCreate'),
(5,	'bug',	'batchEdit'),
(5,	'bug',	'batchResolve'),
(5,	'bug',	'browse'),
(5,	'bug',	'close'),
(5,	'bug',	'confirmBug'),
(5,	'bug',	'confirmStoryChange'),
(5,	'bug',	'create'),
(5,	'bug',	'delete'),
(5,	'bug',	'edit'),
(5,	'bug',	'export'),
(5,	'bug',	'exportTemplet'),
(5,	'bug',	'import'),
(5,	'bug',	'index'),
(5,	'bug',	'linkBugs'),
(5,	'bug',	'report'),
(5,	'bug',	'resolve'),
(5,	'bug',	'showImport'),
(5,	'bug',	'view'),
(5,	'build',	'batchUnlinkBug'),
(5,	'build',	'batchUnlinkStory'),
(5,	'build',	'browse'),
(5,	'build',	'create'),
(5,	'build',	'delete'),
(5,	'build',	'edit'),
(5,	'build',	'linkBug'),
(5,	'build',	'linkStory'),
(5,	'build',	'unlinkBug'),
(5,	'build',	'unlinkStory'),
(5,	'build',	'view'),
(5,	'classify',	'browse'),
(5,	'cm',	'browse'),
(5,	'cm',	'create'),
(5,	'cm',	'edit'),
(5,	'cm',	'report'),
(5,	'cm',	'view'),
(5,	'cmcl',	'browse'),
(5,	'cmcl',	'delete'),
(5,	'cmcl',	'edit'),
(5,	'cmcl',	'view'),
(5,	'company',	'browse'),
(5,	'company',	'dynamic'),
(5,	'company',	'effort'),
(5,	'company',	'index'),
(5,	'company',	'view'),
(5,	'compile',	'browse'),
(5,	'compile',	'logs'),
(5,	'datatable',	'setGlobal'),
(5,	'deploy',	'activate'),
(5,	'deploy',	'assignTo'),
(5,	'deploy',	'batchUnlinkCases'),
(5,	'deploy',	'browse'),
(5,	'deploy',	'cases'),
(5,	'deploy',	'create'),
(5,	'deploy',	'delete'),
(5,	'deploy',	'deleteStep'),
(5,	'deploy',	'edit'),
(5,	'deploy',	'editStep'),
(5,	'deploy',	'finish'),
(5,	'deploy',	'finishStep'),
(5,	'deploy',	'linkCases'),
(5,	'deploy',	'manageScope'),
(5,	'deploy',	'manageStep'),
(5,	'deploy',	'scope'),
(5,	'deploy',	'steps'),
(5,	'deploy',	'unlinkCase'),
(5,	'deploy',	'view'),
(5,	'deploy',	'viewStep'),
(5,	'design',	'browse'),
(5,	'design',	'create'),
(5,	'design',	'delete'),
(5,	'design',	'edit'),
(5,	'design',	'view'),
(5,	'doc',	'collect'),
(5,	'doc',	'create'),
(5,	'doc',	'createLib'),
(5,	'doc',	'delete'),
(5,	'doc',	'deleteFile'),
(5,	'doc',	'deleteLib'),
(5,	'doc',	'edit'),
(5,	'doc',	'editLib'),
(5,	'doc',	'index'),
(5,	'doc',	'myCollection'),
(5,	'doc',	'myCreation'),
(5,	'doc',	'myEdited'),
(5,	'doc',	'mySpace'),
(5,	'doc',	'myView'),
(5,	'doc',	'productSpace'),
(5,	'doc',	'projectSpace'),
(5,	'doc',	'showFiles'),
(5,	'doc',	'teamSpace'),
(5,	'doc',	'view'),
(5,	'domain',	'browse'),
(5,	'domain',	'create'),
(5,	'domain',	'delete'),
(5,	'domain',	'edit'),
(5,	'domain',	'view'),
(5,	'durationestimation',	'create'),
(5,	'durationestimation',	'index'),
(5,	'effort',	'batchCreate'),
(5,	'effort',	'batchEdit'),
(5,	'effort',	'calendar'),
(5,	'effort',	'createForObject'),
(5,	'effort',	'delete'),
(5,	'effort',	'edit'),
(5,	'effort',	'export'),
(5,	'effort',	'view'),
(5,	'execution',	'activate'),
(5,	'execution',	'addWhitelist'),
(5,	'execution',	'all'),
(5,	'execution',	'batchedit'),
(5,	'execution',	'batchUnlinkStory'),
(5,	'execution',	'browse'),
(5,	'execution',	'bug'),
(5,	'execution',	'build'),
(5,	'execution',	'burn'),
(5,	'execution',	'burnData'),
(5,	'execution',	'calendar'),
(5,	'execution',	'close'),
(5,	'execution',	'computeBurn'),
(5,	'execution',	'computeTaskEffort'),
(5,	'execution',	'create'),
(5,	'execution',	'delete'),
(5,	'execution',	'deleterelation'),
(5,	'execution',	'doc'),
(5,	'execution',	'dynamic'),
(5,	'execution',	'edit'),
(5,	'execution',	'effort'),
(5,	'execution',	'effortCalendar'),
(5,	'execution',	'executionkanban'),
(5,	'execution',	'export'),
(5,	'execution',	'fixFirst'),
(5,	'execution',	'gantt'),
(5,	'execution',	'grouptask'),
(5,	'execution',	'importBug'),
(5,	'execution',	'importplanstories'),
(5,	'execution',	'importtask'),
(5,	'execution',	'index'),
(5,	'execution',	'kanban'),
(5,	'execution',	'linkStory'),
(5,	'execution',	'maintainrelation'),
(5,	'execution',	'manageMembers'),
(5,	'execution',	'manageProducts'),
(5,	'execution',	'printKanban'),
(5,	'execution',	'putoff'),
(5,	'execution',	'relation'),
(5,	'execution',	'start'),
(5,	'execution',	'story'),
(5,	'execution',	'storyEstimate'),
(5,	'execution',	'storyKanban'),
(5,	'execution',	'storySort'),
(5,	'execution',	'storyView'),
(5,	'execution',	'suspend'),
(5,	'execution',	'task'),
(5,	'execution',	'taskEffort'),
(5,	'execution',	'team'),
(5,	'execution',	'testcase'),
(5,	'execution',	'testreport'),
(5,	'execution',	'testtask'),
(5,	'execution',	'tree'),
(5,	'execution',	'treeStory'),
(5,	'execution',	'treeTask'),
(5,	'execution',	'unbindWhitelist'),
(5,	'execution',	'unlinkMember'),
(5,	'execution',	'unlinkStory'),
(5,	'execution',	'updateOrder'),
(5,	'execution',	'view'),
(5,	'execution',	'whitelist'),
(5,	'extension',	'browse'),
(5,	'extension',	'obtain'),
(5,	'extension',	'structure'),
(5,	'faq',	'browse'),
(5,	'faq',	'create'),
(5,	'faq',	'delete'),
(5,	'faq',	'edit'),
(5,	'feedback',	'admin'),
(5,	'feedback',	'adminView'),
(5,	'feedback',	'assignTo'),
(5,	'feedback',	'batchAssignTo'),
(5,	'feedback',	'batchChangeModule'),
(5,	'feedback',	'batchClose'),
(5,	'feedback',	'batchEdit'),
(5,	'feedback',	'batchReview'),
(5,	'feedback',	'browse'),
(5,	'feedback',	'close'),
(5,	'feedback',	'comment'),
(5,	'feedback',	'create'),
(5,	'feedback',	'delete'),
(5,	'feedback',	'edit'),
(5,	'feedback',	'export'),
(5,	'feedback',	'index'),
(5,	'feedback',	'manageProduct'),
(5,	'feedback',	'products'),
(5,	'feedback',	'review'),
(5,	'feedback',	'view'),
(5,	'file',	'delete'),
(5,	'file',	'download'),
(5,	'file',	'edit'),
(5,	'file',	'setPublic'),
(5,	'file',	'uploadImages'),
(5,	'git',	'apiSync'),
(5,	'git',	'cat'),
(5,	'git',	'diff'),
(5,	'group',	'browse'),
(5,	'holiday',	'browse'),
(5,	'host',	'browse'),
(5,	'host',	'changeStatus'),
(5,	'host',	'create'),
(5,	'host',	'delete'),
(5,	'host',	'edit'),
(5,	'host',	'treemap'),
(5,	'host',	'view'),
(5,	'index',	'index'),
(5,	'issue',	'activate'),
(5,	'issue',	'batchCreate'),
(5,	'issue',	'browse'),
(5,	'issue',	'cancel'),
(5,	'issue',	'close'),
(5,	'issue',	'create'),
(5,	'issue',	'delete'),
(5,	'issue',	'edit'),
(5,	'issue',	'resolve'),
(5,	'issue',	'view'),
(5,	'jenkins',	'browse'),
(5,	'jenkins',	'create'),
(5,	'jenkins',	'delete'),
(5,	'jenkins',	'edit'),
(5,	'job',	'browse'),
(5,	'job',	'create'),
(5,	'job',	'delete'),
(5,	'job',	'edit'),
(5,	'job',	'exec'),
(5,	'job',	'view'),
(5,	'leave',	'back'),
(5,	'leave',	'create'),
(5,	'leave',	'delete'),
(5,	'leave',	'edit'),
(5,	'leave',	'export'),
(5,	'leave',	'personal'),
(5,	'leave',	'personalAnnual'),
(5,	'leave',	'switchstatus'),
(5,	'leave',	'view'),
(5,	'lieu',	'create'),
(5,	'lieu',	'delete'),
(5,	'lieu',	'edit'),
(5,	'lieu',	'personal'),
(5,	'lieu',	'switchstatus'),
(5,	'lieu',	'view'),
(5,	'makeup',	'create'),
(5,	'makeup',	'delete'),
(5,	'makeup',	'edit'),
(5,	'makeup',	'export'),
(5,	'makeup',	'personal'),
(5,	'makeup',	'switchstatus'),
(5,	'makeup',	'view'),
(5,	'measrecord',	'browse'),
(5,	'measurement',	'batchEdit'),
(5,	'measurement',	'browse'),
(5,	'measurement',	'createBasic'),
(5,	'measurement',	'createTemplate'),
(5,	'measurement',	'delete'),
(5,	'measurement',	'design'),
(5,	'measurement',	'designPHP'),
(5,	'measurement',	'designSQL'),
(5,	'measurement',	'editBasic'),
(5,	'measurement',	'editDerivation'),
(5,	'measurement',	'editTemplate'),
(5,	'measurement',	'execCrontabQueue'),
(5,	'measurement',	'initCrontabQueue'),
(5,	'measurement',	'searchMeas'),
(5,	'measurement',	'template'),
(5,	'measurement',	'viewTemplate'),
(5,	'meeting',	'browse'),
(5,	'meeting',	'create'),
(5,	'meeting',	'delete'),
(5,	'meeting',	'edit'),
(5,	'meeting',	'minutes'),
(5,	'meeting',	'view'),
(5,	'meetingroom',	'batchCreate'),
(5,	'meetingroom',	'batchEdit'),
(5,	'meetingroom',	'browse'),
(5,	'meetingroom',	'create'),
(5,	'meetingroom',	'delete'),
(5,	'meetingroom',	'edit'),
(5,	'meetingroom',	'view'),
(5,	'milestone',	'index'),
(5,	'milestone',	'saveOtherProblem'),
(5,	'misc',	'ping'),
(5,	'my',	'bug'),
(5,	'my',	'calendar'),
(5,	'my',	'changePassword'),
(5,	'my',	'contribute'),
(5,	'my',	'deleteContacts'),
(5,	'my',	'doc'),
(5,	'my',	'dynamic'),
(5,	'my',	'editProfile'),
(5,	'my',	'effort'),
(5,	'my',	'execution'),
(5,	'my',	'index'),
(5,	'my',	'issue'),
(5,	'my',	'manageContacts'),
(5,	'my',	'meeting'),
(5,	'my',	'myMeeting'),
(5,	'my',	'nc'),
(5,	'my',	'preference'),
(5,	'my',	'profile'),
(5,	'my',	'project'),
(5,	'my',	'review'),
(5,	'my',	'risk'),
(5,	'my',	'score'),
(5,	'my',	'story'),
(5,	'my',	'task'),
(5,	'my',	'team'),
(5,	'my',	'testcase'),
(5,	'my',	'testtask'),
(5,	'my',	'todo'),
(5,	'my',	'unbind'),
(5,	'my',	'uploadAvatar'),
(5,	'my',	'work'),
(5,	'nc',	'16'),
(5,	'nc',	'activate'),
(5,	'nc',	'assign'),
(5,	'nc',	'batchassign'),
(5,	'nc',	'batchcreate'),
(5,	'nc',	'batchedit'),
(5,	'nc',	'browse'),
(5,	'nc',	'close'),
(5,	'nc',	'create'),
(5,	'nc',	'delete'),
(5,	'nc',	'edit'),
(5,	'nc',	'export'),
(5,	'nc',	'exporttemplate'),
(5,	'nc',	'import'),
(5,	'nc',	'link'),
(5,	'nc',	'resolve'),
(5,	'nc',	'search'),
(5,	'nc',	'showimport'),
(5,	'nc',	'unlink'),
(5,	'nc',	'view'),
(5,	'opportunity',	'activate'),
(5,	'opportunity',	'assignTo'),
(5,	'opportunity',	'batchActivate'),
(5,	'opportunity',	'batchAssignTo'),
(5,	'opportunity',	'batchCancel'),
(5,	'opportunity',	'batchClose'),
(5,	'opportunity',	'batchCreate'),
(5,	'opportunity',	'batchEdit'),
(5,	'opportunity',	'batchHangup'),
(5,	'opportunity',	'batchImportToLib'),
(5,	'opportunity',	'browse'),
(5,	'opportunity',	'cancel'),
(5,	'opportunity',	'close'),
(5,	'opportunity',	'create'),
(5,	'opportunity',	'delete'),
(5,	'opportunity',	'edit'),
(5,	'opportunity',	'hangup'),
(5,	'opportunity',	'importFromLib'),
(5,	'opportunity',	'importToLib'),
(5,	'opportunity',	'track'),
(5,	'opportunity',	'view'),
(5,	'ops',	'index'),
(5,	'ops',	'setting'),
(5,	'output',	'13'),
(5,	'output',	'assign'),
(5,	'output',	'batchassign'),
(5,	'output',	'batchcreate'),
(5,	'output',	'batchedit'),
(5,	'output',	'browse'),
(5,	'output',	'create'),
(5,	'output',	'delete'),
(5,	'output',	'edit'),
(5,	'output',	'export'),
(5,	'output',	'exporttemplate'),
(5,	'output',	'import'),
(5,	'output',	'link'),
(5,	'output',	'search'),
(5,	'output',	'showimport'),
(5,	'output',	'unlink'),
(5,	'output',	'view'),
(5,	'overtime',	'create'),
(5,	'overtime',	'delete'),
(5,	'overtime',	'edit'),
(5,	'overtime',	'export'),
(5,	'overtime',	'personal'),
(5,	'overtime',	'switchstatus'),
(5,	'overtime',	'view'),
(5,	'personnel',	'accessible'),
(5,	'personnel',	'addWhitelist'),
(5,	'personnel',	'invest'),
(5,	'personnel',	'unbindWhitelist'),
(5,	'personnel',	'whitelist'),
(5,	'pivot',	'bugAssign'),
(5,	'pivot',	'bugAssignSummary'),
(5,	'pivot',	'bugCreate'),
(5,	'pivot',	'bugSummary'),
(5,	'pivot',	'build'),
(5,	'pivot',	'casesrun'),
(5,	'pivot',	'export'),
(5,	'pivot',	'preview'),
(5,	'pivot',	'productSummary'),
(5,	'pivot',	'projectDeviation'),
(5,	'pivot',	'projectSummary'),
(5,	'pivot',	'projectWorkload'),
(5,	'pivot',	'reportExport'),
(5,	'pivot',	'roadmap'),
(5,	'pivot',	'storyLinkedBug'),
(5,	'pivot',	'testcase'),
(5,	'pivot',	'workAssignSummary'),
(5,	'pivot',	'workload'),
(5,	'pivot',	'workSummary'),
(5,	'process',	'browse'),
(5,	'process',	'create'),
(5,	'process',	'delete'),
(5,	'process',	'edit'),
(5,	'process',	'view'),
(5,	'product',	'addWhitelist'),
(5,	'product',	'all'),
(5,	'product',	'batchEdit'),
(5,	'product',	'browse'),
(5,	'product',	'build'),
(5,	'product',	'close'),
(5,	'product',	'create'),
(5,	'product',	'dashboard'),
(5,	'product',	'delete'),
(5,	'product',	'doc'),
(5,	'product',	'dynamic'),
(5,	'product',	'edit'),
(5,	'product',	'export'),
(5,	'product',	'index'),
(5,	'product',	'kanban'),
(5,	'product',	'manageLine'),
(5,	'product',	'project'),
(5,	'product',	'roadmap'),
(5,	'product',	'track'),
(5,	'product',	'unbindWhitelist'),
(5,	'product',	'updateOrder'),
(5,	'product',	'view'),
(5,	'product',	'whitelist'),
(5,	'productplan',	'batchEdit'),
(5,	'productplan',	'batchUnlinkBug'),
(5,	'productplan',	'batchUnlinkStory'),
(5,	'productplan',	'browse'),
(5,	'productplan',	'create'),
(5,	'productplan',	'delete'),
(5,	'productplan',	'edit'),
(5,	'productplan',	'linkBug'),
(5,	'productplan',	'linkStory'),
(5,	'productplan',	'unlinkBug'),
(5,	'productplan',	'unlinkStory'),
(5,	'productplan',	'view'),
(5,	'program',	'activate'),
(5,	'program',	'batchUnlinkStakeholders'),
(5,	'program',	'browse'),
(5,	'program',	'close'),
(5,	'program',	'create'),
(5,	'program',	'createStakeholder'),
(5,	'program',	'delete'),
(5,	'program',	'edit'),
(5,	'program',	'export'),
(5,	'program',	'index'),
(5,	'program',	'kanban'),
(5,	'program',	'product'),
(5,	'program',	'project'),
(5,	'program',	'stakeholder'),
(5,	'program',	'start'),
(5,	'program',	'suspend'),
(5,	'program',	'unbindWhitelist'),
(5,	'program',	'unlinkStakeholder'),
(5,	'program',	'updateOrder'),
(5,	'program',	'view'),
(5,	'programplan',	'browse'),
(5,	'programplan',	'create'),
(5,	'programplan',	'edit'),
(5,	'project',	'activate'),
(5,	'project',	'addWhitelist'),
(5,	'project',	'batchEdit'),
(5,	'project',	'browse'),
(5,	'project',	'bug'),
(5,	'project',	'build'),
(5,	'project',	'close'),
(5,	'project',	'copyGroup'),
(5,	'project',	'create'),
(5,	'project',	'createGroup'),
(5,	'project',	'createGuide'),
(5,	'project',	'delete'),
(5,	'project',	'dynamic'),
(5,	'project',	'edit'),
(5,	'project',	'editGroup'),
(5,	'project',	'execution'),
(5,	'project',	'export'),
(5,	'project',	'group'),
(5,	'project',	'index'),
(5,	'project',	'kanban'),
(5,	'project',	'manageGroupMember'),
(5,	'project',	'manageMembers'),
(5,	'project',	'managePriv'),
(5,	'project',	'manageProducts'),
(5,	'project',	'programTitle'),
(5,	'project',	'qa'),
(5,	'project',	'start'),
(5,	'project',	'suspend'),
(5,	'project',	'team'),
(5,	'project',	'testcase'),
(5,	'project',	'testreport'),
(5,	'project',	'testtask'),
(5,	'project',	'unbindWhitelist'),
(5,	'project',	'unlinkMember'),
(5,	'project',	'updateOrder'),
(5,	'project',	'view'),
(5,	'project',	'whitelist'),
(5,	'projectbuild',	'browse'),
(5,	'projectrelease',	'batchUnlinkBug'),
(5,	'projectrelease',	'batchUnlinkStory'),
(5,	'projectrelease',	'browse'),
(5,	'projectrelease',	'changeStatus'),
(5,	'projectrelease',	'create'),
(5,	'projectrelease',	'delete'),
(5,	'projectrelease',	'edit'),
(5,	'projectrelease',	'export'),
(5,	'projectrelease',	'linkBug'),
(5,	'projectrelease',	'linkStory'),
(5,	'projectrelease',	'unlinkBug'),
(5,	'projectrelease',	'unlinkStory'),
(5,	'projectrelease',	'view'),
(5,	'projectstory',	'batchUnlinkStory'),
(5,	'projectstory',	'importFromLib'),
(5,	'projectstory',	'importplanstories'),
(5,	'projectstory',	'linkStory'),
(5,	'projectstory',	'story'),
(5,	'projectstory',	'track'),
(5,	'projectstory',	'unlinkStory'),
(5,	'projectstory',	'view'),
(5,	'pssp',	'browse'),
(5,	'pssp',	'update'),
(5,	'qa',	'index'),
(5,	'release',	'batchUnlinkBug'),
(5,	'release',	'batchUnlinkStory'),
(5,	'release',	'browse'),
(5,	'release',	'changeStatus'),
(5,	'release',	'create'),
(5,	'release',	'delete'),
(5,	'release',	'edit'),
(5,	'release',	'export'),
(5,	'release',	'linkBug'),
(5,	'release',	'linkStory'),
(5,	'release',	'unlinkBug'),
(5,	'release',	'unlinkStory'),
(5,	'release',	'view'),
(5,	'repo',	'blame'),
(5,	'repo',	'browse'),
(5,	'repo',	'create'),
(5,	'repo',	'delete'),
(5,	'repo',	'diff'),
(5,	'repo',	'download'),
(5,	'repo',	'edit'),
(5,	'repo',	'log'),
(5,	'repo',	'maintain'),
(5,	'repo',	'revision'),
(5,	'repo',	'setRules'),
(5,	'repo',	'showSyncCommit'),
(5,	'repo',	'view'),
(5,	'report',	'crystalExport'),
(5,	'report',	'customeRedreport'),
(5,	'report',	'export'),
(5,	'report',	'show'),
(5,	'requirement',	'activate'),
(5,	'requirement',	'assignTo'),
(5,	'requirement',	'batchAssignTo'),
(5,	'requirement',	'batchChangeBranch'),
(5,	'requirement',	'batchChangeModule'),
(5,	'requirement',	'batchClose'),
(5,	'requirement',	'batchCreate'),
(5,	'requirement',	'batchEdit'),
(5,	'requirement',	'batchReview'),
(5,	'requirement',	'change'),
(5,	'requirement',	'close'),
(5,	'requirement',	'create'),
(5,	'requirement',	'delete'),
(5,	'requirement',	'edit'),
(5,	'requirement',	'export'),
(5,	'requirement',	'recall'),
(5,	'requirement',	'report'),
(5,	'requirement',	'review'),
(5,	'requirement',	'view'),
(5,	'researchplan',	'browse'),
(5,	'researchplan',	'create'),
(5,	'researchplan',	'delete'),
(5,	'researchplan',	'edit'),
(5,	'researchplan',	'view'),
(5,	'researchreport',	'browse'),
(5,	'researchreport',	'create'),
(5,	'researchreport',	'delete'),
(5,	'researchreport',	'edit'),
(5,	'researchreport',	'view'),
(5,	'review',	'assess'),
(5,	'review',	'audit'),
(5,	'review',	'browse'),
(5,	'review',	'create'),
(5,	'review',	'edit'),
(5,	'review',	'recall'),
(5,	'review',	'report'),
(5,	'review',	'result'),
(5,	'review',	'submit'),
(5,	'review',	'toAudit'),
(5,	'review',	'view'),
(5,	'reviewcl',	'browse'),
(5,	'reviewcl',	'create'),
(5,	'reviewcl',	'delete'),
(5,	'reviewcl',	'edit'),
(5,	'reviewcl',	'view'),
(5,	'reviewissue',	'create'),
(5,	'reviewissue',	'edit'),
(5,	'reviewissue',	'issue'),
(5,	'reviewissue',	'resolved'),
(5,	'reviewissue',	'updateStatus'),
(5,	'reviewissue',	'view'),
(5,	'reviewsetting',	'reviewer'),
(5,	'reviewsetting',	'version'),
(5,	'risk',	'activate'),
(5,	'risk',	'assignTo'),
(5,	'risk',	'batchCreate'),
(5,	'risk',	'batchImportToLib'),
(5,	'risk',	'browse'),
(5,	'risk',	'cancel'),
(5,	'risk',	'close'),
(5,	'risk',	'create'),
(5,	'risk',	'delete'),
(5,	'risk',	'edit'),
(5,	'risk',	'hangup'),
(5,	'risk',	'importFromLib'),
(5,	'risk',	'importToLib'),
(5,	'risk',	'track'),
(5,	'risk',	'view'),
(5,	'screen',	'annualData'),
(5,	'screen',	'browse'),
(5,	'screen',	'view'),
(5,	'search',	'buildForm'),
(5,	'search',	'buildQuery'),
(5,	'search',	'deleteQuery'),
(5,	'search',	'index'),
(5,	'search',	'saveQuery'),
(5,	'search',	'select'),
(5,	'serverroom',	'browse'),
(5,	'serverroom',	'create'),
(5,	'serverroom',	'delete'),
(5,	'serverroom',	'edit'),
(5,	'serverroom',	'view'),
(5,	'service',	'browse'),
(5,	'service',	'create'),
(5,	'service',	'delete'),
(5,	'service',	'edit'),
(5,	'service',	'index'),
(5,	'service',	'manage'),
(5,	'service',	'view'),
(5,	'stage',	'batchCreate'),
(5,	'stage',	'browse'),
(5,	'stage',	'create'),
(5,	'stage',	'delete'),
(5,	'stage',	'edit'),
(5,	'stage',	'setType'),
(5,	'stakeholder',	'batchCreate'),
(5,	'stakeholder',	'browse'),
(5,	'stakeholder',	'communicate'),
(5,	'stakeholder',	'create'),
(5,	'stakeholder',	'createExpect'),
(5,	'stakeholder',	'delete'),
(5,	'stakeholder',	'deleteExpect'),
(5,	'stakeholder',	'edit'),
(5,	'stakeholder',	'editExpect'),
(5,	'stakeholder',	'expect'),
(5,	'stakeholder',	'expectation'),
(5,	'stakeholder',	'issue'),
(5,	'stakeholder',	'plan'),
(5,	'stakeholder',	'userIssue'),
(5,	'stakeholder',	'view'),
(5,	'stakeholder',	'viewExpect'),
(5,	'stakeholder',	'viewIssue'),
(5,	'story',	'activate'),
(5,	'story',	'assignTo'),
(5,	'story',	'batchAssignTo'),
(5,	'story',	'batchChangeBranch'),
(5,	'story',	'batchChangeModule'),
(5,	'story',	'batchChangePlan'),
(5,	'story',	'batchChangeStage'),
(5,	'story',	'batchClose'),
(5,	'story',	'batchCreate'),
(5,	'story',	'batchEdit'),
(5,	'story',	'batchImportToLib'),
(5,	'story',	'batchReview'),
(5,	'story',	'batchToTask'),
(5,	'story',	'browse'),
(5,	'story',	'bugs'),
(5,	'story',	'cases'),
(5,	'story',	'change'),
(5,	'story',	'close'),
(5,	'story',	'create'),
(5,	'story',	'delete'),
(5,	'story',	'edit'),
(5,	'story',	'export'),
(5,	'story',	'exportTemplet'),
(5,	'story',	'import'),
(5,	'story',	'importToLib'),
(5,	'story',	'linkStory'),
(5,	'story',	'processStoryChange'),
(5,	'story',	'recall'),
(5,	'story',	'report'),
(5,	'story',	'review'),
(5,	'story',	'showImport'),
(5,	'story',	'tasks'),
(5,	'story',	'view'),
(5,	'subject',	'browse'),
(5,	'svn',	'apiSync'),
(5,	'svn',	'cat'),
(5,	'svn',	'diff'),
(5,	'task',	'activate'),
(5,	'task',	'assignTo'),
(5,	'task',	'batchAssignTo'),
(5,	'task',	'batchCancel'),
(5,	'task',	'batchChangeModule'),
(5,	'task',	'batchClose'),
(5,	'task',	'batchCreate'),
(5,	'task',	'batchEdit'),
(5,	'task',	'browse'),
(5,	'task',	'cancel'),
(5,	'task',	'close'),
(5,	'task',	'confirmdesignchange'),
(5,	'task',	'confirmStoryChange'),
(5,	'task',	'create'),
(5,	'task',	'delete'),
(5,	'task',	'deleteEstimate'),
(5,	'task',	'edit'),
(5,	'task',	'editEstimate'),
(5,	'task',	'export'),
(5,	'task',	'exportTemplet'),
(5,	'task',	'finish'),
(5,	'task',	'import'),
(5,	'task',	'pause'),
(5,	'task',	'recordEstimate'),
(5,	'task',	'report'),
(5,	'task',	'restart'),
(5,	'task',	'showImport'),
(5,	'task',	'start'),
(5,	'task',	'view'),
(5,	'testcase',	'browse'),
(5,	'testcase',	'bugs'),
(5,	'testcase',	'createBug'),
(5,	'testcase',	'export'),
(5,	'testcase',	'groupCase'),
(5,	'testcase',	'importFromLib'),
(5,	'testcase',	'index'),
(5,	'testcase',	'view'),
(5,	'testcase',	'zeroCase'),
(5,	'testreport',	'browse'),
(5,	'testreport',	'create'),
(5,	'testreport',	'delete'),
(5,	'testreport',	'edit'),
(5,	'testreport',	'export'),
(5,	'testreport',	'view'),
(5,	'testsuite',	'browse'),
(5,	'testsuite',	'index'),
(5,	'testsuite',	'view'),
(5,	'testtask',	'browse'),
(5,	'testtask',	'cases'),
(5,	'testtask',	'create'),
(5,	'testtask',	'edit'),
(5,	'testtask',	'groupCase'),
(5,	'testtask',	'index'),
(5,	'testtask',	'results'),
(5,	'testtask',	'view'),
(5,	'todo',	'activate'),
(5,	'todo',	'assignTo'),
(5,	'todo',	'batchClose'),
(5,	'todo',	'batchCreate'),
(5,	'todo',	'batchEdit'),
(5,	'todo',	'batchFinish'),
(5,	'todo',	'calendar'),
(5,	'todo',	'close'),
(5,	'todo',	'create'),
(5,	'todo',	'createcycle'),
(5,	'todo',	'delete'),
(5,	'todo',	'edit'),
(5,	'todo',	'export'),
(5,	'todo',	'finish'),
(5,	'todo',	'import2Today'),
(5,	'todo',	'start'),
(5,	'todo',	'view'),
(5,	'tree',	'browse'),
(5,	'tree',	'browseTask'),
(5,	'tree',	'delete'),
(5,	'tree',	'edit'),
(5,	'tree',	'fix'),
(5,	'tree',	'manageChild'),
(5,	'tree',	'updateOrder'),
(5,	'user',	'bug'),
(5,	'user',	'cropAvatar'),
(5,	'user',	'dynamic'),
(5,	'user',	'effort'),
(5,	'user',	'effortcalendar'),
(5,	'user',	'execution'),
(5,	'user',	'issue'),
(5,	'user',	'profile'),
(5,	'user',	'risk'),
(5,	'user',	'story'),
(5,	'user',	'task'),
(5,	'user',	'testCase'),
(5,	'user',	'testTask'),
(5,	'user',	'todo'),
(5,	'user',	'todocalendar'),
(5,	'user',	'view'),
(5,	'weekly',	'index'),
(5,	'workestimation',	'index'),
(5,	'workloadbudget',	'27'),
(5,	'workloadbudget',	'assign'),
(5,	'workloadbudget',	'batchassign'),
(5,	'workloadbudget',	'batchcreate'),
(5,	'workloadbudget',	'batchedit'),
(5,	'workloadbudget',	'browse'),
(5,	'workloadbudget',	'create'),
(5,	'workloadbudget',	'delete'),
(5,	'workloadbudget',	'edit'),
(5,	'workloadbudget',	'export'),
(5,	'workloadbudget',	'exporttemplate'),
(5,	'workloadbudget',	'import'),
(5,	'workloadbudget',	'link'),
(5,	'workloadbudget',	'search'),
(5,	'workloadbudget',	'showimport'),
(5,	'workloadbudget',	'unlink'),
(5,	'workloadbudget',	'view'),
(5,	'zoutput',	'batchCreate'),
(5,	'zoutput',	'batchEdit'),
(5,	'zoutput',	'browse'),
(5,	'zoutput',	'create'),
(5,	'zoutput',	'delete'),
(5,	'zoutput',	'edit'),
(5,	'zoutput',	'updateOrder'),
(5,	'zoutput',	'view'),
(6,	'account',	'browse'),
(6,	'account',	'create'),
(6,	'account',	'delete'),
(6,	'account',	'edit'),
(6,	'account',	'view'),
(6,	'action',	'comment'),
(6,	'action',	'editComment'),
(6,	'action',	'hideAll'),
(6,	'action',	'hideOne'),
(6,	'action',	'trash'),
(6,	'action',	'undelete'),
(6,	'activity',	'browse'),
(6,	'activity',	'create'),
(6,	'activity',	'delete'),
(6,	'activity',	'edit'),
(6,	'activity',	'view'),
(6,	'admin',	'index'),
(6,	'attend',	'company'),
(6,	'attend',	'department'),
(6,	'attend',	'detail'),
(6,	'attend',	'edit'),
(6,	'attend',	'export'),
(6,	'attend',	'exportDetail'),
(6,	'attend',	'exportStat'),
(6,	'attend',	'personal'),
(6,	'audit',	'8'),
(6,	'audit',	'assign'),
(6,	'audit',	'batchassign'),
(6,	'audit',	'batchcreate'),
(6,	'audit',	'batchedit'),
(6,	'audit',	'browse'),
(6,	'audit',	'create'),
(6,	'audit',	'delete'),
(6,	'audit',	'edit'),
(6,	'audit',	'export'),
(6,	'audit',	'exporttemplate'),
(6,	'audit',	'import'),
(6,	'audit',	'link'),
(6,	'audit',	'search'),
(6,	'audit',	'showimport'),
(6,	'audit',	'unlink'),
(6,	'audit',	'view'),
(6,	'auditcl',	'browse'),
(6,	'auditcl',	'delete'),
(6,	'auditcl',	'edit'),
(6,	'auditplan',	'browse'),
(6,	'auditplan',	'create'),
(6,	'auditplan',	'edit'),
(6,	'auditplan',	'nc'),
(6,	'auditplan',	'result'),
(6,	'auditresult',	'10'),
(6,	'auditresult',	'assign'),
(6,	'auditresult',	'batchassign'),
(6,	'auditresult',	'batchcreate'),
(6,	'auditresult',	'batchedit'),
(6,	'auditresult',	'browse'),
(6,	'auditresult',	'create'),
(6,	'auditresult',	'delete'),
(6,	'auditresult',	'edit'),
(6,	'auditresult',	'export'),
(6,	'auditresult',	'exporttemplate'),
(6,	'auditresult',	'import'),
(6,	'auditresult',	'link'),
(6,	'auditresult',	'search'),
(6,	'auditresult',	'showimport'),
(6,	'auditresult',	'unlink'),
(6,	'auditresult',	'view'),
(6,	'automation',	'browse'),
(6,	'baseline',	'articleview'),
(6,	'baseline',	'catalog'),
(6,	'baseline',	'createTemplate'),
(6,	'baseline',	'editBook'),
(6,	'baseline',	'editTemplate'),
(6,	'baseline',	'manageBook'),
(6,	'baseline',	'template'),
(6,	'baseline',	'view'),
(6,	'budget',	'batchCreate'),
(6,	'budget',	'browse'),
(6,	'budget',	'create'),
(6,	'budget',	'edit'),
(6,	'budget',	'summary'),
(6,	'budget',	'view'),
(6,	'bug',	'activate'),
(6,	'bug',	'assignTo'),
(6,	'bug',	'batchActivate'),
(6,	'bug',	'batchAssignTo'),
(6,	'bug',	'batchChangeModule'),
(6,	'bug',	'batchClose'),
(6,	'bug',	'batchConfirm'),
(6,	'bug',	'batchCreate'),
(6,	'bug',	'batchEdit'),
(6,	'bug',	'batchResolve'),
(6,	'bug',	'browse'),
(6,	'bug',	'close'),
(6,	'bug',	'confirmBug'),
(6,	'bug',	'confirmStoryChange'),
(6,	'bug',	'create'),
(6,	'bug',	'delete'),
(6,	'bug',	'edit'),
(6,	'bug',	'export'),
(6,	'bug',	'index'),
(6,	'bug',	'linkBugs'),
(6,	'bug',	'report'),
(6,	'bug',	'resolve'),
(6,	'bug',	'view'),
(6,	'build',	'batchUnlinkBug'),
(6,	'build',	'batchUnlinkStory'),
(6,	'build',	'create'),
(6,	'build',	'delete'),
(6,	'build',	'edit'),
(6,	'build',	'linkBug'),
(6,	'build',	'linkStory'),
(6,	'build',	'unlinkBug'),
(6,	'build',	'unlinkStory'),
(6,	'build',	'view'),
(6,	'classify',	'browse'),
(6,	'cm',	'browse'),
(6,	'cm',	'create'),
(6,	'cm',	'edit'),
(6,	'cm',	'report'),
(6,	'cm',	'view'),
(6,	'cmcl',	'browse'),
(6,	'cmcl',	'delete'),
(6,	'cmcl',	'edit'),
(6,	'cmcl',	'view'),
(6,	'company',	'browse'),
(6,	'company',	'dynamic'),
(6,	'company',	'effort'),
(6,	'company',	'index'),
(6,	'company',	'view'),
(6,	'custom',	'estimate'),
(6,	'datatable',	'setGlobal'),
(6,	'deploy',	'activate'),
(6,	'deploy',	'assignTo'),
(6,	'deploy',	'batchUnlinkCases'),
(6,	'deploy',	'browse'),
(6,	'deploy',	'cases'),
(6,	'deploy',	'create'),
(6,	'deploy',	'delete'),
(6,	'deploy',	'deleteStep'),
(6,	'deploy',	'edit'),
(6,	'deploy',	'editStep'),
(6,	'deploy',	'finish'),
(6,	'deploy',	'finishStep'),
(6,	'deploy',	'linkCases'),
(6,	'deploy',	'manageScope'),
(6,	'deploy',	'manageStep'),
(6,	'deploy',	'scope'),
(6,	'deploy',	'steps'),
(6,	'deploy',	'unlinkCase'),
(6,	'deploy',	'view'),
(6,	'deploy',	'viewStep'),
(6,	'design',	'browse'),
(6,	'design',	'create'),
(6,	'design',	'delete'),
(6,	'design',	'edit'),
(6,	'design',	'view'),
(6,	'doc',	'collect'),
(6,	'doc',	'create'),
(6,	'doc',	'createLib'),
(6,	'doc',	'delete'),
(6,	'doc',	'deleteFile'),
(6,	'doc',	'deleteLib'),
(6,	'doc',	'edit'),
(6,	'doc',	'editLib'),
(6,	'doc',	'index'),
(6,	'doc',	'myCollection'),
(6,	'doc',	'myCreation'),
(6,	'doc',	'myEdited'),
(6,	'doc',	'mySpace'),
(6,	'doc',	'myView'),
(6,	'doc',	'productSpace'),
(6,	'doc',	'projectSpace'),
(6,	'doc',	'showFiles'),
(6,	'doc',	'teamSpace'),
(6,	'doc',	'view'),
(6,	'domain',	'browse'),
(6,	'domain',	'create'),
(6,	'domain',	'delete'),
(6,	'domain',	'edit'),
(6,	'domain',	'view'),
(6,	'durationestimation',	'create'),
(6,	'durationestimation',	'index'),
(6,	'effort',	'batchCreate'),
(6,	'effort',	'calendar'),
(6,	'effort',	'createForObject'),
(6,	'effort',	'delete'),
(6,	'effort',	'edit'),
(6,	'effort',	'export'),
(6,	'effort',	'view'),
(6,	'execution',	'activate'),
(6,	'execution',	'addWhitelist'),
(6,	'execution',	'all'),
(6,	'execution',	'batchedit'),
(6,	'execution',	'batchUnlinkStory'),
(6,	'execution',	'browse'),
(6,	'execution',	'bug'),
(6,	'execution',	'build'),
(6,	'execution',	'burn'),
(6,	'execution',	'burnData'),
(6,	'execution',	'calendar'),
(6,	'execution',	'close'),
(6,	'execution',	'computeBurn'),
(6,	'execution',	'create'),
(6,	'execution',	'delete'),
(6,	'execution',	'doc'),
(6,	'execution',	'dynamic'),
(6,	'execution',	'edit'),
(6,	'execution',	'effort'),
(6,	'execution',	'executionkanban'),
(6,	'execution',	'export'),
(6,	'execution',	'fixFirst'),
(6,	'execution',	'grouptask'),
(6,	'execution',	'importBug'),
(6,	'execution',	'importplanstories'),
(6,	'execution',	'importtask'),
(6,	'execution',	'index'),
(6,	'execution',	'kanban'),
(6,	'execution',	'linkStory'),
(6,	'execution',	'manageMembers'),
(6,	'execution',	'manageProducts'),
(6,	'execution',	'printKanban'),
(6,	'execution',	'putoff'),
(6,	'execution',	'start'),
(6,	'execution',	'story'),
(6,	'execution',	'storyEstimate'),
(6,	'execution',	'storyKanban'),
(6,	'execution',	'storySort'),
(6,	'execution',	'storyView'),
(6,	'execution',	'suspend'),
(6,	'execution',	'task'),
(6,	'execution',	'team'),
(6,	'execution',	'testcase'),
(6,	'execution',	'testreport'),
(6,	'execution',	'testtask'),
(6,	'execution',	'tree'),
(6,	'execution',	'treeStory'),
(6,	'execution',	'treeTask'),
(6,	'execution',	'unbindWhitelist'),
(6,	'execution',	'unlinkMember'),
(6,	'execution',	'unlinkStory'),
(6,	'execution',	'updateOrder'),
(6,	'execution',	'view'),
(6,	'execution',	'whitelist'),
(6,	'extension',	'browse'),
(6,	'extension',	'obtain'),
(6,	'extension',	'structure'),
(6,	'faq',	'browse'),
(6,	'feedback',	'admin'),
(6,	'feedback',	'adminView'),
(6,	'feedback',	'assignTo'),
(6,	'feedback',	'batchAssignTo'),
(6,	'feedback',	'batchClose'),
(6,	'feedback',	'batchEdit'),
(6,	'feedback',	'batchReview'),
(6,	'feedback',	'close'),
(6,	'feedback',	'comment'),
(6,	'feedback',	'delete'),
(6,	'feedback',	'export'),
(6,	'feedback',	'index'),
(6,	'feedback',	'review'),
(6,	'feedback',	'view'),
(6,	'file',	'delete'),
(6,	'file',	'download'),
(6,	'file',	'edit'),
(6,	'file',	'setPublic'),
(6,	'file',	'uploadImages'),
(6,	'gapanalysis',	'batchCreate'),
(6,	'gapanalysis',	'batchEdit'),
(6,	'gapanalysis',	'browse'),
(6,	'gapanalysis',	'create'),
(6,	'gapanalysis',	'delete'),
(6,	'gapanalysis',	'edit'),
(6,	'gapanalysis',	'view'),
(6,	'git',	'apiSync'),
(6,	'git',	'cat'),
(6,	'git',	'diff'),
(6,	'group',	'browse'),
(6,	'host',	'browse'),
(6,	'host',	'changeStatus'),
(6,	'host',	'create'),
(6,	'host',	'delete'),
(6,	'host',	'edit'),
(6,	'host',	'treemap'),
(6,	'host',	'view'),
(6,	'index',	'index'),
(6,	'issue',	'activate'),
(6,	'issue',	'assignTo'),
(6,	'issue',	'batchCreate'),
(6,	'issue',	'browse'),
(6,	'issue',	'cancel'),
(6,	'issue',	'close'),
(6,	'issue',	'confirm'),
(6,	'issue',	'create'),
(6,	'issue',	'delete'),
(6,	'issue',	'edit'),
(6,	'issue',	'importFromLib'),
(6,	'issue',	'resolve'),
(6,	'issue',	'view'),
(6,	'leave',	'back'),
(6,	'leave',	'create'),
(6,	'leave',	'delete'),
(6,	'leave',	'edit'),
(6,	'leave',	'export'),
(6,	'leave',	'personal'),
(6,	'leave',	'personalAnnual'),
(6,	'leave',	'switchstatus'),
(6,	'leave',	'view'),
(6,	'lieu',	'create'),
(6,	'lieu',	'delete'),
(6,	'lieu',	'edit'),
(6,	'lieu',	'personal'),
(6,	'lieu',	'view'),
(6,	'makeup',	'create'),
(6,	'makeup',	'delete'),
(6,	'makeup',	'edit'),
(6,	'makeup',	'export'),
(6,	'makeup',	'personal'),
(6,	'makeup',	'switchstatus'),
(6,	'makeup',	'view'),
(6,	'meeting',	'browse'),
(6,	'meeting',	'create'),
(6,	'meeting',	'delete'),
(6,	'meeting',	'edit'),
(6,	'meeting',	'minutes'),
(6,	'meeting',	'view'),
(6,	'meetingroom',	'batchCreate'),
(6,	'meetingroom',	'batchEdit'),
(6,	'meetingroom',	'browse'),
(6,	'meetingroom',	'create'),
(6,	'meetingroom',	'delete'),
(6,	'meetingroom',	'edit'),
(6,	'meetingroom',	'view'),
(6,	'milestone',	'index'),
(6,	'milestone',	'saveOtherProblem'),
(6,	'misc',	'ping'),
(6,	'my',	'bug'),
(6,	'my',	'calendar'),
(6,	'my',	'changePassword'),
(6,	'my',	'contribute'),
(6,	'my',	'deleteContacts'),
(6,	'my',	'doc'),
(6,	'my',	'dynamic'),
(6,	'my',	'editProfile'),
(6,	'my',	'effort'),
(6,	'my',	'execution'),
(6,	'my',	'index'),
(6,	'my',	'issue'),
(6,	'my',	'manageContacts'),
(6,	'my',	'meeting'),
(6,	'my',	'myMeeting'),
(6,	'my',	'nc'),
(6,	'my',	'preference'),
(6,	'my',	'profile'),
(6,	'my',	'project'),
(6,	'my',	'review'),
(6,	'my',	'risk'),
(6,	'my',	'score'),
(6,	'my',	'story'),
(6,	'my',	'task'),
(6,	'my',	'team'),
(6,	'my',	'testcase'),
(6,	'my',	'testtask'),
(6,	'my',	'todo'),
(6,	'my',	'unbind'),
(6,	'my',	'uploadAvatar'),
(6,	'my',	'work'),
(6,	'nc',	'16'),
(6,	'nc',	'activate'),
(6,	'nc',	'assign'),
(6,	'nc',	'batchassign'),
(6,	'nc',	'batchcreate'),
(6,	'nc',	'batchedit'),
(6,	'nc',	'browse'),
(6,	'nc',	'close'),
(6,	'nc',	'create'),
(6,	'nc',	'delete'),
(6,	'nc',	'edit'),
(6,	'nc',	'export'),
(6,	'nc',	'exporttemplate'),
(6,	'nc',	'import'),
(6,	'nc',	'link'),
(6,	'nc',	'resolve'),
(6,	'nc',	'search'),
(6,	'nc',	'showimport'),
(6,	'nc',	'unlink'),
(6,	'nc',	'view'),
(6,	'opportunity',	'activate'),
(6,	'opportunity',	'assignTo'),
(6,	'opportunity',	'batchActivate'),
(6,	'opportunity',	'batchAssignTo'),
(6,	'opportunity',	'batchCancel'),
(6,	'opportunity',	'batchClose'),
(6,	'opportunity',	'batchCreate'),
(6,	'opportunity',	'batchEdit'),
(6,	'opportunity',	'batchHangup'),
(6,	'opportunity',	'batchImportToLib'),
(6,	'opportunity',	'browse'),
(6,	'opportunity',	'cancel'),
(6,	'opportunity',	'close'),
(6,	'opportunity',	'create'),
(6,	'opportunity',	'delete'),
(6,	'opportunity',	'edit'),
(6,	'opportunity',	'hangup'),
(6,	'opportunity',	'importFromLib'),
(6,	'opportunity',	'importToLib'),
(6,	'opportunity',	'track'),
(6,	'opportunity',	'view'),
(6,	'ops',	'index'),
(6,	'ops',	'setting'),
(6,	'output',	'13'),
(6,	'output',	'assign'),
(6,	'output',	'batchassign'),
(6,	'output',	'batchcreate'),
(6,	'output',	'batchedit'),
(6,	'output',	'browse'),
(6,	'output',	'create'),
(6,	'output',	'delete'),
(6,	'output',	'edit'),
(6,	'output',	'export'),
(6,	'output',	'exporttemplate'),
(6,	'output',	'import'),
(6,	'output',	'link'),
(6,	'output',	'search'),
(6,	'output',	'showimport'),
(6,	'output',	'unlink'),
(6,	'output',	'view'),
(6,	'overtime',	'create'),
(6,	'overtime',	'delete'),
(6,	'overtime',	'edit'),
(6,	'overtime',	'export'),
(6,	'overtime',	'personal'),
(6,	'overtime',	'switchstatus'),
(6,	'overtime',	'view'),
(6,	'personnel',	'accessible'),
(6,	'personnel',	'invest'),
(6,	'personnel',	'whitelist'),
(6,	'pivot',	'bugAssign'),
(6,	'pivot',	'bugAssignSummary'),
(6,	'pivot',	'bugCreate'),
(6,	'pivot',	'bugSummary'),
(6,	'pivot',	'build'),
(6,	'pivot',	'casesrun'),
(6,	'pivot',	'preview'),
(6,	'pivot',	'productSummary'),
(6,	'pivot',	'projectDeviation'),
(6,	'pivot',	'projectSummary'),
(6,	'pivot',	'projectWorkload'),
(6,	'pivot',	'roadmap'),
(6,	'pivot',	'storyLinkedBug'),
(6,	'pivot',	'testcase'),
(6,	'pivot',	'workAssignSummary'),
(6,	'pivot',	'workload'),
(6,	'pivot',	'workSummary'),
(6,	'process',	'browse'),
(6,	'process',	'create'),
(6,	'process',	'delete'),
(6,	'process',	'edit'),
(6,	'process',	'view'),
(6,	'product',	'all'),
(6,	'product',	'browse'),
(6,	'product',	'build'),
(6,	'product',	'dashboard'),
(6,	'product',	'doc'),
(6,	'product',	'dynamic'),
(6,	'product',	'index'),
(6,	'product',	'kanban'),
(6,	'product',	'manageLine'),
(6,	'product',	'project'),
(6,	'product',	'roadmap'),
(6,	'product',	'track'),
(6,	'product',	'view'),
(6,	'product',	'whitelist'),
(6,	'productplan',	'browse'),
(6,	'productplan',	'view'),
(6,	'program',	'activate'),
(6,	'program',	'browse'),
(6,	'program',	'close'),
(6,	'program',	'create'),
(6,	'program',	'delete'),
(6,	'program',	'edit'),
(6,	'program',	'index'),
(6,	'program',	'kanban'),
(6,	'program',	'product'),
(6,	'program',	'project'),
(6,	'program',	'stakeholder'),
(6,	'program',	'start'),
(6,	'program',	'suspend'),
(6,	'program',	'view'),
(6,	'programplan',	'browse'),
(6,	'programplan',	'create'),
(6,	'programplan',	'edit'),
(6,	'project',	'activate'),
(6,	'project',	'addWhitelist'),
(6,	'project',	'batchEdit'),
(6,	'project',	'browse'),
(6,	'project',	'bug'),
(6,	'project',	'build'),
(6,	'project',	'close'),
(6,	'project',	'copyGroup'),
(6,	'project',	'create'),
(6,	'project',	'createGroup'),
(6,	'project',	'createGuide'),
(6,	'project',	'delete'),
(6,	'project',	'dynamic'),
(6,	'project',	'edit'),
(6,	'project',	'editGroup'),
(6,	'project',	'execution'),
(6,	'project',	'export'),
(6,	'project',	'group'),
(6,	'project',	'index'),
(6,	'project',	'kanban'),
(6,	'project',	'manageGroupMember'),
(6,	'project',	'manageMembers'),
(6,	'project',	'managePriv'),
(6,	'project',	'manageProducts'),
(6,	'project',	'programTitle'),
(6,	'project',	'qa'),
(6,	'project',	'start'),
(6,	'project',	'suspend'),
(6,	'project',	'team'),
(6,	'project',	'testcase'),
(6,	'project',	'testreport'),
(6,	'project',	'testtask'),
(6,	'project',	'unbindWhitelist'),
(6,	'project',	'unlinkMember'),
(6,	'project',	'updateOrder'),
(6,	'project',	'view'),
(6,	'project',	'whitelist'),
(6,	'projectbuild',	'browse'),
(6,	'projectrelease',	'batchUnlinkBug'),
(6,	'projectrelease',	'batchUnlinkStory'),
(6,	'projectrelease',	'browse'),
(6,	'projectrelease',	'changeStatus'),
(6,	'projectrelease',	'create'),
(6,	'projectrelease',	'delete'),
(6,	'projectrelease',	'edit'),
(6,	'projectrelease',	'export'),
(6,	'projectrelease',	'linkBug'),
(6,	'projectrelease',	'linkStory'),
(6,	'projectrelease',	'unlinkBug'),
(6,	'projectrelease',	'unlinkStory'),
(6,	'projectrelease',	'view'),
(6,	'projectstory',	'batchUnlinkStory'),
(6,	'projectstory',	'importplanstories'),
(6,	'projectstory',	'linkStory'),
(6,	'projectstory',	'story'),
(6,	'projectstory',	'track'),
(6,	'projectstory',	'unlinkStory'),
(6,	'projectstory',	'view'),
(6,	'pssp',	'browse'),
(6,	'pssp',	'update'),
(6,	'qa',	'index'),
(6,	'release',	'browse'),
(6,	'release',	'export'),
(6,	'release',	'view'),
(6,	'repo',	'blame'),
(6,	'repo',	'browse'),
(6,	'repo',	'diff'),
(6,	'repo',	'download'),
(6,	'repo',	'log'),
(6,	'repo',	'revision'),
(6,	'repo',	'showSyncCommit'),
(6,	'repo',	'view'),
(6,	'report',	'customeRedreport'),
(6,	'report',	'export'),
(6,	'report',	'show'),
(6,	'requirement',	'export'),
(6,	'requirement',	'report'),
(6,	'requirement',	'view'),
(6,	'review',	'assess'),
(6,	'review',	'audit'),
(6,	'review',	'browse'),
(6,	'review',	'create'),
(6,	'review',	'edit'),
(6,	'review',	'recall'),
(6,	'review',	'report'),
(6,	'review',	'result'),
(6,	'review',	'submit'),
(6,	'review',	'toAudit'),
(6,	'review',	'view'),
(6,	'reviewcl',	'browse'),
(6,	'reviewcl',	'create'),
(6,	'reviewcl',	'delete'),
(6,	'reviewcl',	'edit'),
(6,	'reviewcl',	'view'),
(6,	'reviewissue',	'create'),
(6,	'reviewissue',	'edit'),
(6,	'reviewissue',	'issue'),
(6,	'reviewissue',	'resolved'),
(6,	'reviewissue',	'updateStatus'),
(6,	'reviewissue',	'view'),
(6,	'reviewsetting',	'reviewer'),
(6,	'reviewsetting',	'version'),
(6,	'risk',	'activate'),
(6,	'risk',	'assignTo'),
(6,	'risk',	'batchCreate'),
(6,	'risk',	'browse'),
(6,	'risk',	'cancel'),
(6,	'risk',	'close'),
(6,	'risk',	'create'),
(6,	'risk',	'delete'),
(6,	'risk',	'edit'),
(6,	'risk',	'hangup'),
(6,	'risk',	'importFromLib'),
(6,	'risk',	'view'),
(6,	'screen',	'annualData'),
(6,	'screen',	'browse'),
(6,	'screen',	'view'),
(6,	'search',	'buildForm'),
(6,	'search',	'buildQuery'),
(6,	'search',	'deleteQuery'),
(6,	'search',	'index'),
(6,	'search',	'saveQuery'),
(6,	'search',	'select'),
(6,	'serverroom',	'browse'),
(6,	'serverroom',	'create'),
(6,	'serverroom',	'delete'),
(6,	'serverroom',	'edit'),
(6,	'serverroom',	'view'),
(6,	'service',	'browse'),
(6,	'service',	'create'),
(6,	'service',	'delete'),
(6,	'service',	'edit'),
(6,	'service',	'index'),
(6,	'service',	'manage'),
(6,	'service',	'view'),
(6,	'stage',	'batchCreate'),
(6,	'stage',	'browse'),
(6,	'stage',	'create'),
(6,	'stage',	'delete'),
(6,	'stage',	'edit'),
(6,	'stakeholder',	'browse'),
(6,	'stakeholder',	'communicate'),
(6,	'stakeholder',	'createExpect'),
(6,	'stakeholder',	'deleteExpect'),
(6,	'stakeholder',	'editExpect'),
(6,	'stakeholder',	'expect'),
(6,	'stakeholder',	'expectation'),
(6,	'stakeholder',	'issue'),
(6,	'stakeholder',	'userIssue'),
(6,	'stakeholder',	'view'),
(6,	'stakeholder',	'viewExpect'),
(6,	'stakeholder',	'viewIssue'),
(6,	'story',	'batchToTask'),
(6,	'story',	'bugs'),
(6,	'story',	'cases'),
(6,	'story',	'export'),
(6,	'story',	'processStoryChange'),
(6,	'story',	'report'),
(6,	'story',	'tasks'),
(6,	'story',	'view'),
(6,	'subject',	'browse'),
(6,	'svn',	'apiSync'),
(6,	'svn',	'cat'),
(6,	'svn',	'diff'),
(6,	'task',	'activate'),
(6,	'task',	'assignTo'),
(6,	'task',	'batchAssignTo'),
(6,	'task',	'batchCancel'),
(6,	'task',	'batchChangeModule'),
(6,	'task',	'batchClose'),
(6,	'task',	'batchCreate'),
(6,	'task',	'batchEdit'),
(6,	'task',	'cancel'),
(6,	'task',	'close'),
(6,	'task',	'confirmStoryChange'),
(6,	'task',	'create'),
(6,	'task',	'delete'),
(6,	'task',	'deleteEstimate'),
(6,	'task',	'edit'),
(6,	'task',	'editEstimate'),
(6,	'task',	'export'),
(6,	'task',	'finish'),
(6,	'task',	'pause'),
(6,	'task',	'recordEstimate'),
(6,	'task',	'report'),
(6,	'task',	'restart'),
(6,	'task',	'start'),
(6,	'task',	'view'),
(6,	'testcase',	'browse'),
(6,	'testcase',	'bugs'),
(6,	'testcase',	'export'),
(6,	'testcase',	'groupCase'),
(6,	'testcase',	'index'),
(6,	'testcase',	'view'),
(6,	'testcase',	'zeroCase'),
(6,	'testreport',	'browse'),
(6,	'testreport',	'create'),
(6,	'testreport',	'delete'),
(6,	'testreport',	'edit'),
(6,	'testreport',	'view'),
(6,	'testsuite',	'browse'),
(6,	'testsuite',	'index'),
(6,	'testsuite',	'view'),
(6,	'testtask',	'activate'),
(6,	'testtask',	'batchAssign'),
(6,	'testtask',	'batchRun'),
(6,	'testtask',	'batchUnlinkCases'),
(6,	'testtask',	'block'),
(6,	'testtask',	'browse'),
(6,	'testtask',	'browseUnits'),
(6,	'testtask',	'cases'),
(6,	'testtask',	'close'),
(6,	'testtask',	'create'),
(6,	'testtask',	'delete'),
(6,	'testtask',	'edit'),
(6,	'testtask',	'groupCase'),
(6,	'testtask',	'importUnitResult'),
(6,	'testtask',	'index'),
(6,	'testtask',	'linkcase'),
(6,	'testtask',	'report'),
(6,	'testtask',	'results'),
(6,	'testtask',	'runcase'),
(6,	'testtask',	'start'),
(6,	'testtask',	'unitCases'),
(6,	'testtask',	'unlinkcase'),
(6,	'testtask',	'view'),
(6,	'todo',	'activate'),
(6,	'todo',	'assignTo'),
(6,	'todo',	'batchClose'),
(6,	'todo',	'batchCreate'),
(6,	'todo',	'batchEdit'),
(6,	'todo',	'batchFinish'),
(6,	'todo',	'calendar'),
(6,	'todo',	'close'),
(6,	'todo',	'create'),
(6,	'todo',	'createcycle'),
(6,	'todo',	'delete'),
(6,	'todo',	'edit'),
(6,	'todo',	'export'),
(6,	'todo',	'finish'),
(6,	'todo',	'import2Today'),
(6,	'todo',	'start'),
(6,	'todo',	'view'),
(6,	'trainplan',	'batchCreate'),
(6,	'trainplan',	'batchEdit'),
(6,	'trainplan',	'batchFinish'),
(6,	'trainplan',	'browse'),
(6,	'trainplan',	'create'),
(6,	'trainplan',	'delete'),
(6,	'trainplan',	'edit'),
(6,	'trainplan',	'finish'),
(6,	'trainplan',	'summary'),
(6,	'trainplan',	'view'),
(6,	'tree',	'browse'),
(6,	'tree',	'browsehost'),
(6,	'tree',	'browseTask'),
(6,	'tree',	'delete'),
(6,	'tree',	'edit'),
(6,	'tree',	'fix'),
(6,	'tree',	'manageChild'),
(6,	'tree',	'updateOrder'),
(6,	'user',	'bug'),
(6,	'user',	'cropAvatar'),
(6,	'user',	'dynamic'),
(6,	'user',	'effort'),
(6,	'user',	'effortcalendar'),
(6,	'user',	'execution'),
(6,	'user',	'issue'),
(6,	'user',	'profile'),
(6,	'user',	'risk'),
(6,	'user',	'setPublicTemplate'),
(6,	'user',	'story'),
(6,	'user',	'task'),
(6,	'user',	'testCase'),
(6,	'user',	'testTask'),
(6,	'user',	'todo'),
(6,	'user',	'todocalendar'),
(6,	'user',	'view'),
(6,	'weekly',	'index'),
(6,	'workestimation',	'index'),
(6,	'workloadbudget',	'27'),
(6,	'workloadbudget',	'assign'),
(6,	'workloadbudget',	'batchassign'),
(6,	'workloadbudget',	'batchcreate'),
(6,	'workloadbudget',	'batchedit'),
(6,	'workloadbudget',	'browse'),
(6,	'workloadbudget',	'create'),
(6,	'workloadbudget',	'delete'),
(6,	'workloadbudget',	'edit'),
(6,	'workloadbudget',	'export'),
(6,	'workloadbudget',	'exporttemplate'),
(6,	'workloadbudget',	'import'),
(6,	'workloadbudget',	'link'),
(6,	'workloadbudget',	'search'),
(6,	'workloadbudget',	'showimport'),
(6,	'workloadbudget',	'unlink'),
(6,	'workloadbudget',	'view'),
(6,	'zoutput',	'batchCreate'),
(6,	'zoutput',	'batchEdit'),
(6,	'zoutput',	'browse'),
(6,	'zoutput',	'create'),
(6,	'zoutput',	'delete'),
(6,	'zoutput',	'edit'),
(6,	'zoutput',	'updateOrder'),
(6,	'zoutput',	'view'),
(7,	'action',	'comment'),
(7,	'action',	'editComment'),
(7,	'action',	'hideAll'),
(7,	'action',	'hideOne'),
(7,	'action',	'trash'),
(7,	'action',	'undelete'),
(7,	'activity',	'browse'),
(7,	'activity',	'create'),
(7,	'activity',	'delete'),
(7,	'activity',	'edit'),
(7,	'activity',	'view'),
(7,	'admin',	'checkWeak'),
(7,	'admin',	'index'),
(7,	'admin',	'safe'),
(7,	'attend',	'company'),
(7,	'attend',	'department'),
(7,	'attend',	'edit'),
(7,	'attend',	'export'),
(7,	'attend',	'exportDetail'),
(7,	'attend',	'exportStat'),
(7,	'attend',	'personal'),
(7,	'audit',	'8'),
(7,	'audit',	'assign'),
(7,	'audit',	'batchassign'),
(7,	'audit',	'batchcreate'),
(7,	'audit',	'batchedit'),
(7,	'audit',	'browse'),
(7,	'audit',	'create'),
(7,	'audit',	'delete'),
(7,	'audit',	'edit'),
(7,	'audit',	'export'),
(7,	'audit',	'exporttemplate'),
(7,	'audit',	'import'),
(7,	'audit',	'link'),
(7,	'audit',	'search'),
(7,	'audit',	'showimport'),
(7,	'audit',	'unlink'),
(7,	'audit',	'view'),
(7,	'auditcl',	'browse'),
(7,	'auditcl',	'delete'),
(7,	'auditcl',	'edit'),
(7,	'auditplan',	'browse'),
(7,	'auditplan',	'create'),
(7,	'auditplan',	'edit'),
(7,	'auditplan',	'nc'),
(7,	'auditplan',	'result'),
(7,	'auditresult',	'10'),
(7,	'auditresult',	'assign'),
(7,	'auditresult',	'batchassign'),
(7,	'auditresult',	'batchcreate'),
(7,	'auditresult',	'batchedit'),
(7,	'auditresult',	'browse'),
(7,	'auditresult',	'create'),
(7,	'auditresult',	'delete'),
(7,	'auditresult',	'edit'),
(7,	'auditresult',	'export'),
(7,	'auditresult',	'exporttemplate'),
(7,	'auditresult',	'import'),
(7,	'auditresult',	'link'),
(7,	'auditresult',	'search'),
(7,	'auditresult',	'showimport'),
(7,	'auditresult',	'unlink'),
(7,	'auditresult',	'view'),
(7,	'automation',	'browse'),
(7,	'baseline',	'articleview'),
(7,	'baseline',	'catalog'),
(7,	'baseline',	'createTemplate'),
(7,	'baseline',	'editBook'),
(7,	'baseline',	'editTemplate'),
(7,	'baseline',	'manageBook'),
(7,	'baseline',	'template'),
(7,	'baseline',	'view'),
(7,	'branch',	'delete'),
(7,	'branch',	'manage'),
(7,	'branch',	'sort'),
(7,	'budget',	'batchCreate'),
(7,	'budget',	'browse'),
(7,	'budget',	'create'),
(7,	'budget',	'delete'),
(7,	'budget',	'edit'),
(7,	'budget',	'summary'),
(7,	'budget',	'view'),
(7,	'bug',	'activate'),
(7,	'bug',	'assignTo'),
(7,	'bug',	'batchActivate'),
(7,	'bug',	'batchAssignTo'),
(7,	'bug',	'batchChangeBranch'),
(7,	'bug',	'batchChangeModule'),
(7,	'bug',	'batchClose'),
(7,	'bug',	'batchConfirm'),
(7,	'bug',	'batchCreate'),
(7,	'bug',	'batchEdit'),
(7,	'bug',	'batchResolve'),
(7,	'bug',	'browse'),
(7,	'bug',	'close'),
(7,	'bug',	'confirmBug'),
(7,	'bug',	'confirmStoryChange'),
(7,	'bug',	'create'),
(7,	'bug',	'delete'),
(7,	'bug',	'edit'),
(7,	'bug',	'export'),
(7,	'bug',	'exportTemplet'),
(7,	'bug',	'import'),
(7,	'bug',	'index'),
(7,	'bug',	'linkBugs'),
(7,	'bug',	'report'),
(7,	'bug',	'resolve'),
(7,	'bug',	'showImport'),
(7,	'bug',	'view'),
(7,	'build',	'create'),
(7,	'build',	'delete'),
(7,	'build',	'edit'),
(7,	'build',	'view'),
(7,	'classify',	'browse'),
(7,	'cm',	'browse'),
(7,	'cm',	'create'),
(7,	'cm',	'edit'),
(7,	'cm',	'report'),
(7,	'cm',	'view'),
(7,	'cmcl',	'browse'),
(7,	'cmcl',	'delete'),
(7,	'cmcl',	'edit'),
(7,	'cmcl',	'view'),
(7,	'company',	'browse'),
(7,	'company',	'calendar'),
(7,	'company',	'dynamic'),
(7,	'company',	'effort'),
(7,	'company',	'index'),
(7,	'company',	'todo'),
(7,	'company',	'view'),
(7,	'custom',	'estimate'),
(7,	'datatable',	'setGlobal'),
(7,	'deploy',	'activate'),
(7,	'deploy',	'assignTo'),
(7,	'deploy',	'batchUnlinkCases'),
(7,	'deploy',	'browse'),
(7,	'deploy',	'cases'),
(7,	'deploy',	'create'),
(7,	'deploy',	'delete'),
(7,	'deploy',	'deleteStep'),
(7,	'deploy',	'edit'),
(7,	'deploy',	'editStep'),
(7,	'deploy',	'finish'),
(7,	'deploy',	'finishStep'),
(7,	'deploy',	'linkCases'),
(7,	'deploy',	'manageScope'),
(7,	'deploy',	'manageStep'),
(7,	'deploy',	'scope'),
(7,	'deploy',	'steps'),
(7,	'deploy',	'unlinkCase'),
(7,	'deploy',	'view'),
(7,	'deploy',	'viewStep'),
(7,	'design',	'browse'),
(7,	'design',	'create'),
(7,	'design',	'delete'),
(7,	'design',	'edit'),
(7,	'design',	'view'),
(7,	'doc',	'collect'),
(7,	'doc',	'create'),
(7,	'doc',	'createLib'),
(7,	'doc',	'delete'),
(7,	'doc',	'deleteFile'),
(7,	'doc',	'deleteLib'),
(7,	'doc',	'diff'),
(7,	'doc',	'edit'),
(7,	'doc',	'editLib'),
(7,	'doc',	'index'),
(7,	'doc',	'myCollection'),
(7,	'doc',	'myCreation'),
(7,	'doc',	'myEdited'),
(7,	'doc',	'mySpace'),
(7,	'doc',	'myView'),
(7,	'doc',	'productSpace'),
(7,	'doc',	'projectSpace'),
(7,	'doc',	'showFiles'),
(7,	'doc',	'teamSpace'),
(7,	'doc',	'view'),
(7,	'durationestimation',	'create'),
(7,	'durationestimation',	'index'),
(7,	'effort',	'batchCreate'),
(7,	'effort',	'calendar'),
(7,	'effort',	'createForObject'),
(7,	'effort',	'delete'),
(7,	'effort',	'edit'),
(7,	'effort',	'export'),
(7,	'effort',	'view'),
(7,	'execution',	'all'),
(7,	'execution',	'browse'),
(7,	'execution',	'bug'),
(7,	'execution',	'build'),
(7,	'execution',	'burn'),
(7,	'execution',	'calendar'),
(7,	'execution',	'doc'),
(7,	'execution',	'dynamic'),
(7,	'execution',	'effort'),
(7,	'execution',	'gantt'),
(7,	'execution',	'grouptask'),
(7,	'execution',	'index'),
(7,	'execution',	'kanban'),
(7,	'execution',	'linkStory'),
(7,	'execution',	'manageProducts'),
(7,	'execution',	'story'),
(7,	'execution',	'storyKanban'),
(7,	'execution',	'storySort'),
(7,	'execution',	'storyView'),
(7,	'execution',	'task'),
(7,	'execution',	'team'),
(7,	'execution',	'testtask'),
(7,	'execution',	'tree'),
(7,	'execution',	'treeStory'),
(7,	'execution',	'treeTask'),
(7,	'execution',	'unlinkStory'),
(7,	'execution',	'view'),
(7,	'extension',	'browse'),
(7,	'extension',	'obtain'),
(7,	'extension',	'structure'),
(7,	'faq',	'browse'),
(7,	'faq',	'create'),
(7,	'faq',	'delete'),
(7,	'faq',	'edit'),
(7,	'feedback',	'admin'),
(7,	'feedback',	'adminView'),
(7,	'feedback',	'close'),
(7,	'feedback',	'comment'),
(7,	'feedback',	'index'),
(7,	'file',	'delete'),
(7,	'file',	'download'),
(7,	'file',	'edit'),
(7,	'file',	'setPublic'),
(7,	'file',	'uploadImages'),
(7,	'gapanalysis',	'batchCreate'),
(7,	'gapanalysis',	'batchEdit'),
(7,	'gapanalysis',	'browse'),
(7,	'gapanalysis',	'create'),
(7,	'gapanalysis',	'delete'),
(7,	'gapanalysis',	'edit'),
(7,	'gapanalysis',	'view'),
(7,	'git',	'apiSync'),
(7,	'git',	'cat'),
(7,	'git',	'diff'),
(7,	'group',	'browse'),
(7,	'host',	'browse'),
(7,	'host',	'changeStatus'),
(7,	'host',	'create'),
(7,	'host',	'delete'),
(7,	'host',	'edit'),
(7,	'host',	'treemap'),
(7,	'host',	'view'),
(7,	'index',	'index'),
(7,	'issue',	'activate'),
(7,	'issue',	'assignTo'),
(7,	'issue',	'batchCreate'),
(7,	'issue',	'browse'),
(7,	'issue',	'cancel'),
(7,	'issue',	'close'),
(7,	'issue',	'confirm'),
(7,	'issue',	'create'),
(7,	'issue',	'delete'),
(7,	'issue',	'edit'),
(7,	'issue',	'importFromLib'),
(7,	'issue',	'resolve'),
(7,	'issue',	'view'),
(7,	'leave',	'back'),
(7,	'leave',	'create'),
(7,	'leave',	'delete'),
(7,	'leave',	'edit'),
(7,	'leave',	'export'),
(7,	'leave',	'personal'),
(7,	'leave',	'personalAnnual'),
(7,	'leave',	'switchstatus'),
(7,	'leave',	'view'),
(7,	'lieu',	'create'),
(7,	'lieu',	'delete'),
(7,	'lieu',	'edit'),
(7,	'lieu',	'personal'),
(7,	'lieu',	'switchstatus'),
(7,	'lieu',	'view'),
(7,	'makeup',	'create'),
(7,	'makeup',	'delete'),
(7,	'makeup',	'edit'),
(7,	'makeup',	'export'),
(7,	'makeup',	'personal'),
(7,	'makeup',	'switchstatus'),
(7,	'makeup',	'view'),
(7,	'measrecord',	'browse'),
(7,	'measurement',	'batchEdit'),
(7,	'measurement',	'browse'),
(7,	'measurement',	'createBasic'),
(7,	'measurement',	'createTemplate'),
(7,	'measurement',	'delete'),
(7,	'measurement',	'design'),
(7,	'measurement',	'designPHP'),
(7,	'measurement',	'designSQL'),
(7,	'measurement',	'editBasic'),
(7,	'measurement',	'editDerivation'),
(7,	'measurement',	'editTemplate'),
(7,	'measurement',	'execCrontabQueue'),
(7,	'measurement',	'initCrontabQueue'),
(7,	'measurement',	'searchMeas'),
(7,	'measurement',	'template'),
(7,	'measurement',	'viewTemplate'),
(7,	'meeting',	'browse'),
(7,	'meeting',	'create'),
(7,	'meeting',	'delete'),
(7,	'meeting',	'edit'),
(7,	'meeting',	'minutes'),
(7,	'meeting',	'view'),
(7,	'meetingroom',	'batchCreate'),
(7,	'meetingroom',	'batchEdit'),
(7,	'meetingroom',	'browse'),
(7,	'meetingroom',	'create'),
(7,	'meetingroom',	'delete'),
(7,	'meetingroom',	'edit'),
(7,	'meetingroom',	'view'),
(7,	'milestone',	'index'),
(7,	'misc',	'ping'),
(7,	'my',	'bug'),
(7,	'my',	'calendar'),
(7,	'my',	'changePassword'),
(7,	'my',	'contribute'),
(7,	'my',	'deleteContacts'),
(7,	'my',	'doc'),
(7,	'my',	'dynamic'),
(7,	'my',	'editProfile'),
(7,	'my',	'effort'),
(7,	'my',	'execution'),
(7,	'my',	'index'),
(7,	'my',	'issue'),
(7,	'my',	'manageContacts'),
(7,	'my',	'meeting'),
(7,	'my',	'myMeeting'),
(7,	'my',	'nc'),
(7,	'my',	'preference'),
(7,	'my',	'profile'),
(7,	'my',	'project'),
(7,	'my',	'review'),
(7,	'my',	'risk'),
(7,	'my',	'score'),
(7,	'my',	'story'),
(7,	'my',	'task'),
(7,	'my',	'team'),
(7,	'my',	'testcase'),
(7,	'my',	'testtask'),
(7,	'my',	'todo'),
(7,	'my',	'unbind'),
(7,	'my',	'uploadAvatar'),
(7,	'my',	'work'),
(7,	'nc',	'16'),
(7,	'nc',	'activate'),
(7,	'nc',	'assign'),
(7,	'nc',	'batchassign'),
(7,	'nc',	'batchcreate'),
(7,	'nc',	'batchedit'),
(7,	'nc',	'browse'),
(7,	'nc',	'close'),
(7,	'nc',	'create'),
(7,	'nc',	'delete'),
(7,	'nc',	'edit'),
(7,	'nc',	'export'),
(7,	'nc',	'exporttemplate'),
(7,	'nc',	'import'),
(7,	'nc',	'link'),
(7,	'nc',	'resolve'),
(7,	'nc',	'search'),
(7,	'nc',	'showimport'),
(7,	'nc',	'unlink'),
(7,	'nc',	'view'),
(7,	'opportunity',	'activate'),
(7,	'opportunity',	'assignTo'),
(7,	'opportunity',	'batchActivate'),
(7,	'opportunity',	'batchAssignTo'),
(7,	'opportunity',	'batchCancel'),
(7,	'opportunity',	'batchClose'),
(7,	'opportunity',	'batchCreate'),
(7,	'opportunity',	'batchEdit'),
(7,	'opportunity',	'batchHangup'),
(7,	'opportunity',	'batchImportToLib'),
(7,	'opportunity',	'browse'),
(7,	'opportunity',	'cancel'),
(7,	'opportunity',	'close'),
(7,	'opportunity',	'create'),
(7,	'opportunity',	'delete'),
(7,	'opportunity',	'edit'),
(7,	'opportunity',	'hangup'),
(7,	'opportunity',	'importFromLib'),
(7,	'opportunity',	'importToLib'),
(7,	'opportunity',	'track'),
(7,	'opportunity',	'view'),
(7,	'ops',	'index'),
(7,	'ops',	'setting'),
(7,	'output',	'13'),
(7,	'output',	'assign'),
(7,	'output',	'batchassign'),
(7,	'output',	'batchcreate'),
(7,	'output',	'batchedit'),
(7,	'output',	'browse'),
(7,	'output',	'create'),
(7,	'output',	'delete'),
(7,	'output',	'edit'),
(7,	'output',	'export'),
(7,	'output',	'exporttemplate'),
(7,	'output',	'import'),
(7,	'output',	'link'),
(7,	'output',	'search'),
(7,	'output',	'showimport'),
(7,	'output',	'unlink'),
(7,	'output',	'view'),
(7,	'overtime',	'create'),
(7,	'overtime',	'delete'),
(7,	'overtime',	'edit'),
(7,	'overtime',	'export'),
(7,	'overtime',	'personal'),
(7,	'overtime',	'switchstatus'),
(7,	'overtime',	'view'),
(7,	'personnel',	'accessible'),
(7,	'personnel',	'addWhitelist'),
(7,	'personnel',	'invest'),
(7,	'personnel',	'unbindWhitelist'),
(7,	'personnel',	'whitelist'),
(7,	'pivot',	'bugAssign'),
(7,	'pivot',	'bugAssignSummary'),
(7,	'pivot',	'bugCreate'),
(7,	'pivot',	'bugSummary'),
(7,	'pivot',	'build'),
(7,	'pivot',	'casesrun'),
(7,	'pivot',	'export'),
(7,	'pivot',	'preview'),
(7,	'pivot',	'productSummary'),
(7,	'pivot',	'projectDeviation'),
(7,	'pivot',	'projectSummary'),
(7,	'pivot',	'projectWorkload'),
(7,	'pivot',	'reportExport'),
(7,	'pivot',	'roadmap'),
(7,	'pivot',	'storyLinkedBug'),
(7,	'pivot',	'testcase'),
(7,	'pivot',	'workAssignSummary'),
(7,	'pivot',	'workload'),
(7,	'pivot',	'workSummary'),
(7,	'process',	'browse'),
(7,	'process',	'create'),
(7,	'process',	'delete'),
(7,	'process',	'edit'),
(7,	'process',	'view'),
(7,	'product',	'addWhitelist'),
(7,	'product',	'all'),
(7,	'product',	'batchEdit'),
(7,	'product',	'browse'),
(7,	'product',	'build'),
(7,	'product',	'close'),
(7,	'product',	'create'),
(7,	'product',	'dashboard'),
(7,	'product',	'delete'),
(7,	'product',	'doc'),
(7,	'product',	'dynamic'),
(7,	'product',	'edit'),
(7,	'product',	'export'),
(