<?php include $app->getModuleRoot() . 'common/view/header.html.php';?>
<?php if(isset($suhosinInfo)):?>
<div class='alert alert-info'><?php echo $suhosinInfo?></div>
<?php elseif(empty($maxImport) and $allCount > $this->config->file->maxImport):?>
<div id="mainContent" class="main-content">
  <div class="main-header">
    <h2><?php echo $lang->story->import;?></h2>
  </div>
  <p><?php echo sprintf($lang->file->importSummary, $allCount, html::input('maxImport', $config->file->maxImport, "style='width:50px'"), ceil($allCount / $config->file->maxImport));?></p>
  <p><?php echo html::commonButton($lang->import, "id='import'", 'btn btn-primary');?></p>
</div>
<script>
$(function()
{
    $('#maxImport').keyup(function()
    {
        if(parseInt($('#maxImport').val())) $('#times').html(Math.ceil(parseInt($('#allCount').html()) / parseInt($('#maxImport').val())));
    });
    $('#import').click(function(){location.href = createLink('story', 'showImport', "productID=<?php echo $productID;?>&branch=<?php echo $branch?>&type=<?php echo $type?>&pageID=1&maxImport=" + $('#maxImport').val())})
});
</script>
<?php else:?>
<?php js::set('requiredFields', $requiredFields);?>
<div id="mainContent" class="main-content">
  <div class="main-header clearfix">
    <h2><?php echo $lang->story->import;?></h2>
  </div>
  <form class='main-form' target='hiddenwin' method='post'>
    <div class="table-responsive">
      <table class='table table-form' id='showData'>
        <thead>
          <tr>
            <th class='w-60px'>                  <?php echo $lang->story->id?></th>
            <th class='w-150px' id='title'>      <?php echo $lang->story->title?></th>
            <?php if(!empty($branches)):?>
            <th class='w-150px' id='branch'>     <?php echo $lang->story->branch?></th>
            <?php endif;?>
            <th class='w-150px' id='module'>     <?php echo $lang->story->module?></th>
            <th class='w-150px' id='plan'>       <?php echo $lang->story->plan?></th>
            <th class='w-100px' id='source'>     <?php echo $lang->story->source?></th>
            <th class='w-100px' id='sourceNote'> <?php echo $lang->story->sourceNote?></th>
            <th class='w-70px'  id='pri'>        <?php echo $lang->story->pri?></th>
            <th class='w-80px'  id='estimate'>   <?php echo $lang->story->estimate?></th>
            <th class='w-80px'  id='keywords'>   <?php echo $lang->story->keywords?></th>
            <th class='w-100px' id='spec'>       <?php echo $lang->story->spec?></th>
            <th class='w-100px' id='verify'>     <?php echo $lang->story->verify?></th>
            <?php if(!$needReview):?>
            <th class='w-80px'  id='needReview'> <?php echo $lang->story->needReview;?></th>
            <?php endif;?>
            <th class="w-100px <?php echo $needReview ? ' required' : '';?>"><?php echo $lang->story->reviewedBy;?></th>
            <?php
            if(!empty($appendFields))
            {
                foreach($appendFields as $field)
                {
                    if(!$field->show) continue;

                    $width    = ($field->width && $field->width != 'auto' ? $field->width . 'px' : 'auto');
                    $required = strpos(",$field->rules,", ",$notEmptyRule->id,") !== false ? 'required' : '';
                    echo "<th class='$required' style='width: $width'>$field->name</th>";
                }
            }
            ?>
          </tr>
        </thead>
        <tbody>
          <?php
          $insert = true;
          $addID  = 1;
          ?>
          <?php foreach($storyData as $key => $story):?>
          <tr class='text-top'>
            <td>
              <?php
              if(!empty($story->id))
              {
                  echo $story->id . html::hidden("id[$key]", $story->id);
                  $insert = false;
              }
              else
              {
                  echo $addID++ . " <sub style='vertical-align:sub;color:gray'>{$lang->story->new}</sub>";
              }
              echo html::hidden("product[$key]", $productID);
              ?>
            </td>
            <td><?php echo html::input("title[$key]", htmlspecialchars($story->title, ENT_QUOTES), "class='form-control'")?></td>
            <?php if(!empty($branches)):?>
            <td style='overflow:visible'><?php echo html::select("branch[$key]", $branches, !empty($story->branch) ? $story->branch : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->branch : ''), "class='form-control chosen' onchange='setModuleAndPlan(this.value, $productID, $key)'")?></td>
            <?php endif;?>
            <?php
            if($product->type != 'normal')
            {
                if(empty($story->branch)) $story->branch = BRANCH_MAIN;
                $modules = isset($story->branch, $allModules[$story->branch]) ? $allModules[$story->branch] : '';
                $plans   = isset($story->branch, $allPlans[$story->branch]) ? array(0 => '') + $allPlans[$story->branch] : '';
            }
            else
            {
                $modules = $allModules;
                $plans   = $allPlans;
            }
            ?>
            <td style='overflow:visible'><?php echo html::select("module[$key]", $modules, !empty($story->module) ? $story->module : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->module : ''), "class='form-control chosen'")?></td>
            <td style='overflow:visible'><?php echo html::select("plan[$key]", $plans, !empty($story->plan) ? $story->plan : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->plan : ''), "class='form-control chosen'")?></td>
            <td><?php echo html::select("source[$key]", $lang->story->sourceList, !empty($story->source) ? $story->source : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->source : ''), "class='form-control'")?></td>
            <td><?php echo html::input("sourceNote[$key]", !empty($story->sourceNote) ? $story->sourceNote : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->sourceNote : ''), "class='form-control'")?></td>
            <td><?php echo html::select("pri[$key]", $lang->story->priList, !empty($story->pri) ? $story->pri : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->pri : ''), "class='form-control'")?></td>
            <td><?php echo html::input("estimate[$key]", !empty($story->estimate) ? $story->estimate : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->estimate : ''), "class='form-control' autocomplete='off'")?></td>
            <td><?php echo html::input("keywords[$key]", !empty($story->keywords) ? $story->keywords : ((!empty($story->id) and isset($stories[$story->id])) ? $stories[$story->id]->keywords : ''), "class='form-control'")?></td>
            <td><?php echo html::textarea("spec[$key]", $story->spec, "class='form-control' cols='35' rows='1'")?></td>
            <td><?php echo html::textarea("verify[$key]", $story->verify, "class='form-control' cols='35' rows='1'")?></td>
            <?php if(!$needReview):?>
            <td><?php echo html::select("needReview[$key]", $lang->story->reviewList, $needReview, "class='form-control'");?></td>
            <?php endif;?>
            <?php $isDisabled = $needReview ? '' : 'disabled';?>
            <td><?php echo html::select("reviewer[$key][]", $users, '', "class='form-control chosen' multiple $isDisabled");?></td>
            <?php
            if(!empty($appendFields))
            {
                $this->loadModel('flow');
                foreach($appendFields as $field)
                {
                    if(!$field->show) continue;
                    $value = $field->defaultValue ? $field->defaultValue : zget($story, $field->field, '');
                    echo '<td>' . $this->flow->buildControl($field, $value, "$field->field[$key]", true) . '</td>';
                }
            }
            ?>
          </tr>
          <?php endforeach;?>
        </tbody>
        <tfoot>
          <tr>
            <td colspan='<?php echo !empty($branches) ? 14 : 13;?>' class='text-center form-actions'>
              <?php
              $submitText = $isEndPage ? $this->lang->save : $this->lang->file->saveAndNext;
              if(!$insert and $dataInsert === '')
              {
                  echo "<button type='button' data-toggle='modal' data-target='#importNoticeModal' class='btn btn-primary btn-wide'>{$submitText}</button>";
              }
              else
              {
                  echo html::submitButton($submitText);
                  if($dataInsert !== '') echo html::hidden('insert', $dataInsert);
              }
              echo html::hidden('isEndPage', $isEndPage ? 1 : 0);
              echo html::hidden('pagerID', $pagerID);
              echo ' &nbsp; ' . $isEndPage ? html::a($this->createLink('product', 'browse', "productID=$productID"), $lang->goback, '', "class='btn btn-back btn-wide'") : html::backButton();
              echo ' &nbsp; ' . sprintf($lang->file->importPager, $allCount, $pagerID, $allPager);
              ?>
            </td>
          </tr>
        </tfoot>
      </table>
    </div>
    <?php if(!$insert and $dataInsert === '') include $app->getModuleRoot() . 'common/view/noticeimport.html.php';?>
  </form>
</div>
<?php endif;?>
<?php echo js::set('storyType', $type);?>
<script>
/**
 * Set modules and plans.
 *
 * @param  int     $branchID
 * @param  int     $productID
 * @param  int     $num
 * @access public
 * @return void
 */
function setModuleAndPlan(branchID, productID, num)
{
    moduleLink = createLink('tree', 'ajaxGetModules', 'productID=' + productID + '&viewType=story&branch=' + branchID + '&num=' + num);
    $.get(moduleLink, function(modules)
    {
        if(!modules) modules = '<select id="module' + num + '" name="module[' + num + ']" class="form-control"></select>';
        $('#module' + num).replaceWith(modules);
        $("#module" + num + "_chosen").remove();
        $("#module" + num).next('.picker').remove();
        $("#module" + num).chosen();
    });

    planLink = createLink('productPlan', 'ajaxGetProductPlans', 'productID=' + productID + '&branch=' + branchID + '&num=' + num + '&expired=unexpired');
    $.get(planLink, function(plans)
    {
        if(!plans) plans = '<select id="plan' + num + '" name="plan[' + num + ']" class="form-control"></select>';
        $('#plan' + num).replaceWith(plans);
        $("#plan" + num + "_chosen").remove();
        $("#plan" + num).next('.picker').remove();
        $("#plan" + num).chosen();
    });
}

$(function()
{
    $.fixedTableHead('#showData');
    $("#showData th").each(function()
    {
        if(requiredFields.indexOf(this.id) !== -1) $("#" + this.id).addClass('required');
    });
});

$(document).on('change', "#mainContent select[name^=needReview]", function()
{
    select = $(this).parent('td').next('td').children("select[name^=reviewer]");
    $(select).removeAttr('disabled');
    if($(this).val() == 0) $(select).attr('disabled', 'disabled');
    $(select).trigger("chosen:updated");
})
</script>
<?php include $app->getModuleRoot() . 'common/view/footer.html.php';?>
