<?php
$config->workflowaction->require = new stdclass();
$config->workflowaction->require->create = 'action, name';
$config->workflowaction->require->edit   = 'action, name';

$config->workflowaction->uniqueFields = 'action, name';

$config->workflowaction->operatorList['equal']    = '=';
$config->workflowaction->operatorList['notequal'] = '!=';
$config->workflowaction->operatorList['gt']       = '>';
$config->workflowaction->operatorList['ge']       = '>=';
$config->workflowaction->operatorList['lt']       = '<';
$config->workflowaction->operatorList['le']       = '<=';

$config->workflowaction->default = new stdclass();
$config->workflowaction->default->actions      = array('browse', 'create', 'batchcreate', 'edit', 'view', 'delete', 'link', 'unlink', 'export', 'exporttemplate', 'import', 'showimport', 'report');  // These actions are real methods in flow/control.php;
$config->workflowaction->default->extraActions = array('assign', 'batchedit', 'batchassign');   // These actions will be called by the operate method or the batchOperate method in flow/control.php.

$config->workflowaction->default->methods = array();
$config->workflowaction->default->methods['browse']         = 'browse';
$config->workflowaction->default->methods['create']         = 'create';
$config->workflowaction->default->methods['batchcreate']    = 'batchcreate';
$config->workflowaction->default->methods['edit']           = 'edit';
$config->workflowaction->default->methods['view']           = 'view';
$config->workflowaction->default->methods['delete']         = 'delete';
$config->workflowaction->default->methods['link']           = 'link';
$config->workflowaction->default->methods['unlink']         = 'unlink';
$config->workflowaction->default->methods['export']         = 'export';
$config->workflowaction->default->methods['exporttemplate'] = 'exporttemplate';
$config->workflowaction->default->methods['import']         = 'import';
$config->workflowaction->default->methods['showimport']     = 'showimport';
$config->workflowaction->default->methods['report']         = 'report';
$config->workflowaction->default->methods['batchedit']      = 'batchoperate';
$config->workflowaction->default->methods['batchassign']    = 'batchoperate';

$config->workflowaction->default->statuses = array();
$config->workflowaction->default->statuses['batchcreate']    = 'disable';
$config->workflowaction->default->statuses['batchedit']      = 'disable';
$config->workflowaction->default->statuses['batchassign']    = 'disable';
$config->workflowaction->default->statuses['assign']         = 'disable';
$config->workflowaction->default->statuses['link']           = 'disable';
$config->workflowaction->default->statuses['unlink']         = 'disable';
$config->workflowaction->default->statuses['export']         = 'disable';
$config->workflowaction->default->statuses['exporttemplate'] = 'disable';
$config->workflowaction->default->statuses['import']         = 'disable';
$config->workflowaction->default->statuses['showimport']     = 'disable';
$config->workflowaction->default->statuses['report']         = 'disable';

$config->workflowaction->default->types = array();
$config->workflowaction->default->types['batchcreate'] = 'batch';
$config->workflowaction->default->types['batchedit']   = 'batch';
$config->workflowaction->default->types['batchassign'] = 'batch';

$config->workflowaction->default->batchModes = array();
$config->workflowaction->default->batchModes['batchcreate'] = 'different';
$config->workflowaction->default->batchModes['batchedit']   = 'different';

$config->workflowaction->default->opens = array();
$config->workflowaction->default->opens['assign']         = 'modal';
$config->workflowaction->default->opens['delete']         = 'none';
$config->workflowaction->default->opens['link']           = 'none';
$config->workflowaction->default->opens['unlink']         = 'none';
$config->workflowaction->default->opens['export']         = 'none';
$config->workflowaction->default->opens['exporttemplate'] = 'none';
$config->workflowaction->default->opens['import']         = 'none';
$config->workflowaction->default->opens['showimport']     = 'none';
$config->workflowaction->default->opens['report']         = 'none';

$config->workflowaction->default->positions = array();
$config->workflowaction->default->positions['browse']         = 'menu';
$config->workflowaction->default->positions['create']         = 'menu';
$config->workflowaction->default->positions['batchcreate']    = 'menu';
$config->workflowaction->default->positions['batchedit']      = 'browse';
$config->workflowaction->default->positions['batchassign']    = 'browse';
$config->workflowaction->default->positions['view']           = 'browse';
$config->workflowaction->default->positions['link']           = 'view';
$config->workflowaction->default->positions['unlink']         = 'view';
$config->workflowaction->default->positions['export']         = 'menu';
$config->workflowaction->default->positions['exporttemplate'] = 'menu';
$config->workflowaction->default->positions['import']         = 'menu';
$config->workflowaction->default->positions['showimport']     = 'menu';
$config->workflowaction->default->positions['report']         = 'menu';

$config->workflowaction->default->shows      = array();
$config->workflowaction->default->buildin    = array();
$config->workflowaction->default->conditions = array();
$config->workflowaction->default->linkages   = array();

$config->workflowaction->approval = new stdclass();
$config->workflowaction->approval->actions = array('submit', 'cancel', 'review');   // These actions will be called by the operate method or the batchOperate method in flow/control.php.

$config->workflowaction->approval->updateActions = array();
$config->workflowaction->approval->updateActions['edit']   = array('conditions', 'hooks');
$config->workflowaction->approval->updateActions['delete'] = array('conditions');

$config->workflowaction->approval->methods    = array();
$config->workflowaction->approval->statuses   = array();
$config->workflowaction->approval->types      = array();
$config->workflowaction->approval->batchModes = array();

$config->workflowaction->approval->opens = array();
$config->workflowaction->approval->opens['submit'] = 'modal';
$config->workflowaction->approval->opens['cancel'] = 'none';
$config->workflowaction->approval->opens['review'] = 'modal';

$config->workflowaction->approval->positions = array();
$config->workflowaction->approval->shows     = array();
$config->workflowaction->approval->buildin   = array();

$config->workflowaction->approval->conditions = array();
$config->workflowaction->approval->conditions['submit'] = array();
$config->workflowaction->approval->conditions['submit'][0]['conditionType'] = 'data';
$config->workflowaction->approval->conditions['submit'][0]['fields']        = array();
$config->workflowaction->approval->conditions['submit'][0]['fields'][0]['field']    = 'deleted';
$config->workflowaction->approval->conditions['submit'][0]['fields'][0]['operator'] = 'equal';
$config->workflowaction->approval->conditions['submit'][0]['fields'][0]['param']    = '0';
$config->workflowaction->approval->conditions['submit'][0]['fields'][1]['field']    = 'reviewStatus';
$config->workflowaction->approval->conditions['submit'][0]['fields'][1]['operator'] = 'equal';
$config->workflowaction->approval->conditions['submit'][0]['fields'][1]['param']    = 'wait';
$config->workflowaction->approval->conditions['submit'][0]['fields'][2]['field']    = 'createdBy';
$config->workflowaction->approval->conditions['submit'][0]['fields'][2]['operator'] = 'equal';
$config->workflowaction->approval->conditions['submit'][0]['fields'][2]['param']    = 'currentUser';

$config->workflowaction->approval->conditions['cancel'] = array();
$config->workflowaction->approval->conditions['cancel'][0]['conditionType'] = 'data';
$config->workflowaction->approval->conditions['cancel'][0]['fields']        = array();
$config->workflowaction->approval->conditions['cancel'][0]['fields'][0]['field']    = 'deleted';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][0]['operator'] = 'equal';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][0]['param']    = '0';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][1]['field']    = 'reviewStatus';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][1]['operator'] = 'equal';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][1]['param']    = 'doing';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][2]['field']    = 'createdBy';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][2]['operator'] = 'equal';
$config->workflowaction->approval->conditions['cancel'][0]['fields'][2]['param']    = 'currentUser';

$config->workflowaction->approval->conditions['review'] = array();
$config->workflowaction->approval->conditions['review'][0]['conditionType'] = 'data';
$config->workflowaction->approval->conditions['review'][0]['fields']        = array();
$config->workflowaction->approval->conditions['review'][0]['fields'][0]['field']    = 'deleted';
$config->workflowaction->approval->conditions['review'][0]['fields'][0]['operator'] = 'equal';
$config->workflowaction->approval->conditions['review'][0]['fields'][0]['param']    = '0';
$config->workflowaction->approval->conditions['review'][0]['fields'][1]['field']    = 'reviewStatus';
$config->workflowaction->approval->conditions['review'][0]['fields'][1]['operator'] = 'equal';
$config->workflowaction->approval->conditions['review'][0]['fields'][1]['param']    = 'doing';
$config->workflowaction->approval->conditions['review'][0]['fields'][2]['field']    = 'reviewers';
$config->workflowaction->approval->conditions['review'][0]['fields'][2]['operator'] = 'include';
$config->workflowaction->approval->conditions['review'][0]['fields'][2]['param']    = 'currentUser';

$config->workflowaction->approval->conditions['edit'] = array();
$config->workflowaction->approval->conditions['edit'][0]['conditionType'] = 'data';
$config->workflowaction->approval->conditions['edit'][0]['fields'][0]['field']    = 'deleted';
$config->workflowaction->approval->conditions['edit'][0]['fields'][0]['operator'] = 'equal';
$config->workflowaction->approval->conditions['edit'][0]['fields'][0]['param']    = '0';
$config->workflowaction->approval->conditions['edit'][0]['fields'][1]['field']    = 'createdBy';
$config->workflowaction->approval->conditions['edit'][0]['fields'][1]['operator'] = 'equal';
$config->workflowaction->approval->conditions['edit'][0]['fields'][1]['param']    = 'currentUser';
$config->workflowaction->approval->conditions['edit'][0]['fields'][2]['field']    = 'reviewStatus';
$config->workflowaction->approval->conditions['edit'][0]['fields'][2]['operator'] = 'equal';
$config->workflowaction->approval->conditions['edit'][0]['fields'][2]['param']    = 'wait';
$config->workflowaction->approval->conditions['edit'][1]['conditionType'] = 'data';
$config->workflowaction->approval->conditions['edit'][1]['fields'][0]['field']    = 'deleted';
$config->workflowaction->approval->conditions['edit'][1]['fields'][0]['operator'] = 'equal';
$config->workflowaction->approval->conditions['edit'][1]['fields'][0]['param']    = '0';
$config->workflowaction->approval->conditions['edit'][1]['fields'][1]['field']    = 'createdBy';
$config->workflowaction->approval->conditions['edit'][1]['fields'][1]['operator'] = 'equal';
$config->workflowaction->approval->conditions['edit'][1]['fields'][1]['param']    = 'currentUser';
$config->workflowaction->approval->conditions['edit'][1]['fields'][2]['field']    = 'reviewStatus';
$config->workflowaction->approval->conditions['edit'][1]['fields'][2]['operator'] = 'equal';
$config->workflowaction->approval->conditions['edit'][1]['fields'][2]['param']    = 'reject';

$config->workflowaction->approval->conditions['delete'] = array();
$config->workflowaction->approval->conditions['delete'][0]['conditionType'] = 'data';
$config->workflowaction->approval->conditions['delete'][0]['fields'][0]['field']    = 'deleted';
$config->workflowaction->approval->conditions['delete'][0]['fields'][0]['operator'] = 'equal';
$config->workflowaction->approval->conditions['delete'][0]['fields'][0]['param']    = '0';
$config->workflowaction->approval->conditions['delete'][0]['fields'][1]['field']    = 'createdBy';
$config->workflowaction->approval->conditions['delete'][0]['fields'][1]['operator'] = 'equal';
$config->workflowaction->approval->conditions['delete'][0]['fields'][1]['param']    = 'currentUser';
$config->workflowaction->approval->conditions['delete'][0]['fields'][2]['field']    = 'reviewStatus';
$config->workflowaction->approval->conditions['delete'][0]['fields'][2]['operator'] = 'equal';
$config->workflowaction->approval->conditions['delete'][0]['fields'][2]['param']    = 'wait';

$config->workflowaction->approval->linkages = array();
$config->workflowaction->approval->linkages['review'] = array();
$config->workflowaction->approval->linkages['review'][0]['sources'][0]['field']    = 'reviewResult';
$config->workflowaction->approval->linkages['review'][0]['sources'][0]['operator'] = '==';
$config->workflowaction->approval->linkages['review'][0]['sources'][0]['value']    = 'reject';
$config->workflowaction->approval->linkages['review'][0]['targets'][0]['field']    = 'reviewOpinion';
$config->workflowaction->approval->linkages['review'][0]['targets'][0]['status']   = 'show';

$config->workflowaction->approval->hooks = array();
$config->workflowaction->approval->hooks['edit'] = array();
$config->workflowaction->approval->hooks['edit'][0]['action']                        = 'update';
$config->workflowaction->approval->hooks['edit'][0]['table' ]                        = '';
$config->workflowaction->approval->hooks['edit'][0]['conditionType' ]                = 'data';
$config->workflowaction->approval->hooks['edit'][0]['message' ]                      = '';
$config->workflowaction->approval->hooks['edit'][0]['comment' ]                      = '';
$config->workflowaction->approval->hooks['edit'][0]['conditions' ]                   = array();
$config->workflowaction->approval->hooks['edit'][0]['fields' ][0]['field']           = 'reviewStatus';
$config->workflowaction->approval->hooks['edit'][0]['fields' ][0]['paramType']       = 'custom';
$config->workflowaction->approval->hooks['edit'][0]['fields' ][0]['param']           = 'wait';
$config->workflowaction->approval->hooks['edit'][0]['wheres' ][0]['field']           = 'id';
$config->workflowaction->approval->hooks['edit'][0]['wheres' ][0]['logicalOperator'] = 'and';
$config->workflowaction->approval->hooks['edit'][0]['wheres' ][0]['operator']        = 'equal';
$config->workflowaction->approval->hooks['edit'][0]['wheres' ][0]['paramType']       = 'record';
$config->workflowaction->approval->hooks['edit'][0]['wheres' ][0]['param']           = 'id';
$config->workflowaction->approval->hooks['edit'][0]['sql' ]                          = "UPDATE `%s` SET `reviewStatus` = 'wait' WHERE 1 AND (1 AND `id` = '@id')";
$config->workflowaction->approval->hooks['edit'][0]['recordVars' ][0]                = 'id';
$config->workflowaction->approval->hooks['edit'][0]['sqlVars' ]                      = array();
$config->workflowaction->approval->hooks['edit'][0]['formVars' ]                     = array();
$config->workflowaction->approval->hooks['edit'][0]['formulaVars' ]                  = array();

$config->workflowaction->defaultActions        = array_merge($config->workflowaction->default->actions, $config->workflowaction->default->extraActions, $config->workflowaction->approval->actions);
$config->workflowaction->noDisableActions      = array('browse', 'create', 'edit', 'view', 'delete');
$config->workflowaction->noShowActions         = array('browse', 'create', 'export', 'exporttemplate', 'import', 'showimport', 'link', 'unlink', 'report', 'batchcreate', 'batchedit', 'batchassign');
$config->workflowaction->readonlyActions       = array('browse', 'view',   'export', 'exporttemplate', 'import', 'showimport', 'link', 'unlink', 'report', 'delete');
$config->workflowaction->noLinkageActions      = array('browse', 'view',   'export', 'exporttemplate', 'import', 'showimport', 'link', 'unlink', 'report', 'delete');
$config->workflowaction->noConditionActions    = array('browse', 'view',   'export', 'exporttemplate', 'import', 'showimport', 'report', 'create', 'batchcreate');
$config->workflowaction->noVerificationActions = array('browse', 'view',   'export', 'exporttemplate', 'import', 'showimport', 'link', 'unlink', 'report', 'delete');
$config->workflowaction->noHookActions         = array('browse', 'view',   'export', 'exporttemplate', 'import', 'showimport', 'link', 'unlink', 'report');
$config->workflowaction->noNoticeActions       = array('browse', 'view',   'export', 'exporttemplate', 'import', 'showimport', 'link', 'unlink', 'report', 'delete');
$config->workflowaction->noJSActions           = array('export', 'exporttemplate', 'import', 'showimport', 'unlink', 'delete');
$config->workflowaction->noCSSActions          = array('export', 'exporttemplate', 'import', 'showimport', 'unlink', 'delete');

$config->workflowaction->buildin = new stdclass();
$config->workflowaction->buildin->actions['crm']['order']            = array('browse', 'create', 'edit', 'view', 'assign', 'close', 'activate', 'delete');
$config->workflowaction->buildin->actions['crm']['contract']         = array('browse', 'create', 'edit', 'view', 'delivery', 'receive', 'finish', 'cancel', 'delete');
$config->workflowaction->buildin->actions['crm']['purchasecontract'] = array('browse', 'create', 'edit', 'view', 'finish', 'pay', 'cancel', 'delete');
$config->workflowaction->buildin->actions['crm']['customer']         = array('browse', 'create', 'edit', 'view', 'assign', 'delete', 'showImport');
$config->workflowaction->buildin->actions['crm']['provider']         = array('browse', 'create', 'edit', 'view', 'delete');
$config->workflowaction->buildin->actions['crm']['contact']          = array('browse', 'create', 'edit', 'view', 'delete');
$config->workflowaction->buildin->actions['crm']['leads']            = array('browse', 'assignedToNull', 'create', 'edit', 'view', 'assign', 'transform', 'ignore', 'delete');
$config->workflowaction->buildin->actions['crm']['product']          = array('browse', 'create', 'edit', 'view', 'delete');
$config->workflowaction->buildin->actions['crm']['invoice']          = array('browseSale', 'browsePurchase', 'createSale', 'createPurchase', 'edit', 'view', 'drawn', 'express', 'taxRefund', 'delete');
$config->workflowaction->buildin->actions['crm']['feedback']         = array('company', 'personal', 'createdBy', 'create', 'edit', 'view', 'assign', 'doubt', 'reply', 'close', 'activate', 'delete');

$config->workflowaction->buildin->options['crm']['contact']['browse']           = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['contact']['create']           = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['contact']['delete']           = array('open' => 'none', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['contact']['export']           = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['contact']['view']             = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['contract']['browse']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['contract']['cancel']          = array('open' => 'modal', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['contract']['create']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['contract']['delete']          = array('open' => 'none', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['contract']['delivery']        = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['contract']['edit']            = array('layout' => 'side');
$config->workflowaction->buildin->options['crm']['contract']['export']          = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['contract']['finish']          = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['contract']['receive']         = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['contract']['view']            = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['customer']['assign']          = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['customer']['batchAssign']     = array('open' => 'normal', 'position' => 'browse', 'type' => 'batch');
$config->workflowaction->buildin->options['crm']['customer']['browse']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['customer']['create']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['customer']['delete']          = array('open' => 'none', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['customer']['edit']            = array('layout' => 'side');
$config->workflowaction->buildin->options['crm']['customer']['export']          = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['customer']['exportTemplate']  = array('open' => 'modal', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['customer']['import']          = array('open' => 'modal', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['customer']['showImport']      = array('open' => 'normal');
$config->workflowaction->buildin->options['crm']['customer']['view']            = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['feedback']['activate']        = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['feedback']['assign']          = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['feedback']['close']           = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['feedback']['company']         = array('method' => 'browse', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['feedback']['createdBy']       = array('method' => 'browse', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['feedback']['create']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['feedback']['delete']          = array('open' => 'none');
$config->workflowaction->buildin->options['crm']['feedback']['doubt']           = array('open' => 'modal', 'position' => 'view');
$config->workflowaction->buildin->options['crm']['feedback']['personal']        = array('method' => 'browse', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['feedback']['reply']           = array('open' => 'modal', 'position' => 'view');
$config->workflowaction->buildin->options['crm']['feedback']['view']            = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['invoice']['browsePurchase']   = array('method' => 'browse', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['invoice']['browseSale']       = array('method' => 'browse', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['invoice']['createPurchase']   = array('method' => 'create', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['invoice']['createSale']       = array('method' => 'create', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['invoice']['delete']           = array('open' => 'none');
$config->workflowaction->buildin->options['crm']['invoice']['drawn']            = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['invoice']['edit']             = array('layout' => 'side');
$config->workflowaction->buildin->options['crm']['invoice']['export']           = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['invoice']['express']          = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['invoice']['taxRefund']        = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['invoice']['view']             = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['leads']['assign']             = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['leads']['assignedToNull']     = array('method' => 'browse', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['leads']['batchAssign']        = array('open' => 'normal', 'position' => 'browse', 'type' => 'batch');
$config->workflowaction->buildin->options['crm']['leads']['batchIgnore']        = array('open' => 'normal', 'position' => 'browse', 'type' => 'batch');
$config->workflowaction->buildin->options['crm']['leads']['browse']             = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['leads']['create']             = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['leads']['delete']             = array('open' => 'none');
$config->workflowaction->buildin->options['crm']['leads']['export']             = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['leads']['exportTemplate']     = array('open' => 'modal', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['leads']['ignore']             = array('open' => 'normal');
$config->workflowaction->buildin->options['crm']['leads']['import']             = array('open' => 'modal', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['leads']['showImport']         = array('open' => 'normal');
$config->workflowaction->buildin->options['crm']['leads']['transform']          = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['leads']['view']               = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['order']['activate']           = array('open' => 'modal', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['order']['assign']             = array('open' => 'modal', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['order']['batchAssign']        = array('open' => 'normal', 'position' => 'browse', 'type' => 'batch');
$config->workflowaction->buildin->options['crm']['order']['browse']             = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['order']['close']              = array('open' => 'modal', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['order']['create']             = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['order']['delete']             = array('open' => 'none', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['order']['edit']               = array('layout' => 'side');
$config->workflowaction->buildin->options['crm']['order']['export']             = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['order']['view']               = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['product']['batchCreate']      = array('position' => 'menu', 'type' => 'batch', 'batchMode' => 'different');
$config->workflowaction->buildin->options['crm']['product']['browse']           = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['product']['create']           = array('open' => 'modal', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['product']['delete']           = array('open' => 'none', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['product']['edit']             = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['product']['view']             = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['provider']['browse']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['provider']['create']          = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['provider']['delete']          = array('open' => 'none');
$config->workflowaction->buildin->options['crm']['provider']['view']            = array('position' => 'browse', 'layout' => 'side');
$config->workflowaction->buildin->options['crm']['purchasecontract']['browse']  = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['purchasecontract']['cancel']  = array('open' => 'modal', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['purchasecontract']['create']  = array('position' => 'menu');
$config->workflowaction->buildin->options['crm']['purchasecontract']['delete']  = array('open' => 'none', 'show' => 'dropdownlist');
$config->workflowaction->buildin->options['crm']['purchasecontract']['edit']    = array('layout' => 'side');
$config->workflowaction->buildin->options['crm']['purchasecontract']['export']  = array('open' => 'none', 'position' => 'menu');
$config->workflowaction->buildin->options['crm']['purchasecontract']['finish']  = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['purchasecontract']['pay']     = array('open' => 'modal');
$config->workflowaction->buildin->options['crm']['purchasecontract']['view']    = array('position' => 'browse', 'layout' => 'side');
