<?php include $app->getModuleRoot() . 'common/view/header.html.php';?>
<?php include $app->getModuleRoot() . 'common/view/kindeditor.html.php';?>
<?php js::set('template', $review->template);?>
<?php js::set('doc', $review->doc);?>
<div id="mainContent" class="main-content fade">
  <div class="center-block">
    <div class="main-header">
      <h2><?php echo $lang->review->edit;?></h2>
    </div>
    <form class="load-indicator main-form form-ajax" method='post' enctype='multipart/form-data' id='dataform'>
      <table class="table table-form">
        <tbody>
          <tr>
            <th><?php echo $lang->review->product;?></th>
            <td><?php echo html::select('product', $products, $review->product, "class='form-control chosen'");?></td>
          </tr>
          <tr>
            <th class='w-120px'><?php echo $lang->review->object;?></th>
            <td><?php echo html::select('object', $lang->baseline->objectList, $review->category, "class='form-control chosen'");?></td>
            <td></td>
          </tr>
          <tr <?php if($review->category == 'PP') echo "class='hide'";?>>
            <th><?php echo $lang->review->template;?></th>
            <td><?php echo html::select('template', '', '', "class='form-control chosen'");?></td>
          </tr>
          <tr <?php if($review->category == 'PP') echo "class='hide'";?>>
            <th><?php echo $lang->review->doc;?></th>
            <td><?php echo html::select('doc', '', '', "class='form-control chosen'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->title;?></th>
            <td><?php echo html::input('title', $review->title, "class='form-control'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->reviewedBy;?></th>
            <td><?php echo html::select('reviewedBy[]', $members, $review->reviewedBy, "class='form-control chosen' multiple");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->deadline;?></th>
            <td><?php echo html::input('deadline', helper::isZeroDate($review->deadline) ? '' : $review->deadline, "class='form-date form-control'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->comment;?></th>
            <td colspan='2'><?php echo html::textarea('comment', '', "class='form-control'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->files;?></th>
            <td colspan='2'><?php echo $this->fetch('file', 'buildform');?></div>
          </tr>
          <tr>
            <td colspan='3' class='form-actions text-center'><?php echo html::submitButton() . html::backButton();?></td>
          </tr>
        </tbody>
      </table>
    </form>
  </div>
</div>
<?php js::set('projectID', $review->project)?>
<script>
$('#object').change(function()
{
    var type = $(this).val();
    if(type == 'PP')
    {
        $('#template').closest('tr').addClass('hide');
        $('#doc').closest('tr').addClass('hide');
    }
    else
    {
        $('#template').closest('tr').removeClass('hide');
        $('#doc').closest('tr').removeClass('hide');
    }

    var link = createLink('baseline', 'ajaxGetTemplates', 'type=' + type);
    $.post(link, function(data)
    {
        $('#template').replaceWith(data);
        $('#template_chosen').remove();
        $('#template').val(template);
        $('#template').chosen();

        var link = createLink('baseline', 'ajaxGetDocs', 'template=' + template + '&from=review&project=' + projectID);
        $.post(link, function(data)
        {
            $('#doc').replaceWith(data);
            $('#doc_chosen').remove();
            $('#doc').val(doc);
            $('#doc').chosen();
        })

        $('#template').on('change', function()
        {
            var template = $(this).val();
            var link = createLink('baseline', 'ajaxGetDocs', 'template=' + template + '&from=review&project=' + projectID);
            $.post(link, function(data)
            {
                $('#doc').replaceWith(data);
                $('#doc_chosen').remove();
                $('#doc').val(doc);
                $('#doc').chosen();
            })
        })
    })
})

$('#object').change();
$('#template').change();
</script>
<?php include $app->getModuleRoot() . 'common/view/footer.html.php';?>
