<?php include $app->getModuleRoot() . 'common/view/header.html.php';?>
<?php include $app->getModuleRoot() . 'common/view/kindeditor.html.php';?>
<style>
.checkbox-primary {display: inline-block; line-height: 20px;}
.review-result {white-space: nowrap;}
</style>
<div id="mainMenu" class="clearfix">
  <div class="btn-toolbar pull-left">
    <?php $browseLink = $app->session->reviewList != false ? $app->session->reviewList : inlink('browse', "project=$review->project");?>
    <?php echo html::a($browseLink, '<i class="icon icon-back icon-sm"></i> ' . $lang->goback, '', "class='btn btn-secondary'");?>
    <div class="divider"></div>
    <div class="page-title">
      <span class="label label-id"><?php echo $review->id?></span>
      <span class="text"><?php echo $review->title . $lang->arrow . zget($lang->baseline->objectList, $review->category);?></span>
    </div>
  </div>
</div>
<form class='form-ajax' method='post' id="assessForm">
  <div id='reviewRow' class='main-row fade split-row in'>
    <div class='side-col' data-min-width='550'>
      <div class='cell scrollbar-hover'>
      <?php if($review->category == 'PP') include $app->getModuleRoot() . 'programplan/view/gantt.html.php';?>
      <?php
      if(isset($bookID) and $bookID)
      {
          echo '<div class="tab-pane active" id="book">';
          echo '<ul data-name="docsTree" data-ride="tree" data-initial-state="preserve" class="tree no-margin" data-idx="0">';
          include './book.html.php';
          echo '</ul>';
          echo '</div>';
      }
      else
      {
          if(isset($template))
          {
              if(isset($doc))
              {
                  echo "<div class='detail-title'>" . $doc->title . "</div>";
                  echo "<div class='detail-content article-content'>$doc->content</div>";
              }
              else
              {
                  echo "<div class='detail-title'>" . zget($lang->baseline->objectList, $review->category) . "</div>";
                  echo "<div class='detail-content article-content'>$template->content</div>";
              }
          }
      }
      ?>
      </div>
    </div>
    <div class='col-spliter' id="splitLine"></div>
    <div class='main-col' data-min-width='600' id="issueList">
      <div class='cell scrollbar-hover' id='reviewcl'>
        <div class="detail-title"><?php echo (!empty($issues) && !empty($result) && $result->remainIssue == 0) ? $lang->review->lastIssue : $lang->review->reviewcl;?></div>
        <div class="detail-content article-content">
          <?php if(!empty($issues) && !empty($result) && $result->remainIssue == 0):?>
          <table class='table reviewcl'>
            <thead>
              <tr>
                 <th class='text-center'><?php echo $lang->reviewissue->title;?></th>
                 <th><?php echo $lang->reviewissue->opinion;?></th>
                 <th><?php echo $lang->reviewissue->status;?></th>
                 <th><?php echo $lang->reviewissue->hasResolved;?></th>
                 <th><?php echo $lang->review->opinion;?></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($issues as $issue):?>
              <tr>
                 <td class='text-center'><strong><?php echo html::a($this->createLink('reviewissue', 'view', "id=$issue->id"), $issue->title);?></strong></td>
                 <td><?php echo $issue->opinion;?></td>
                 <td><?php echo zget($lang->reviewissue->statusList, $issue->status);?></td>
                 <td><?php echo html::radio("resolved[$issue->id]", $lang->review->resolvedList, 1, "class='resolved'");?></td>
                 <td><?php echo html::input("opinion[$issue->id]", '', "class='form-control opinion' readonly");?></td>
              </tr>
              <?php endforeach;?>
            </tbody>
          </table>
          <?php else:?>
          <table class='table reviewcl'>
            <thead>
              <tr>
                 <th class='text-center'><?php echo $lang->review->listCategory;?></th>
                 <th><?php echo $lang->review->listTitle;?></th>
                 <th><?php echo $lang->review->listResult;?></th>
                 <th><?php echo $lang->review->opinion;?></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($reviewcl as $category => $list):?>
              <tr>
                 <td rowspan=<?php echo count($list);?> class='text-center'><strong><?php echo zget($categoryList, $category);?></strong></td>
                 <?php $i = 0 ;?>
                 <?php foreach($list as $data):?>
                 <?php $i++ ;?>
                 <?php if($i != 1) echo "<tr>"?>
                 <td><?php echo html::a($this->createLink('reviewcl', 'view', "id=$data->id"), $data->title, '', "title=$data->title");?></td>
                 <td><?php echo html::radio("issueResult[$data->id]", $lang->review->checkList, '1', "class='issueResult'", 'block');?></td>
                 <td><?php echo html::input("issueOpinion[$data->id]", isset($data->opinion) ? $data->opinion : '', "class='form-control opinion' readonly");?></td>
                 <?php if($i != 1) echo "</tr>"?>
                 <?php endforeach;?>
              </tr>
              <?php endforeach;?>
            </tbody>
          </table>
          <?php endif;?>
        </div>
      </div>
      <div class='cell review-footer'>
        <table class='table table-borderless'>
          <tr>
            <th class='w-80px'><?php echo $lang->review->result;?></th>
            <td class='review-result'><?php echo html::radio('result', $lang->review->resultList, isset($result->result) ? $result->result : 'pass');?></td>
          </tr>
          <tr>
            <th class='text-nowrap'><?php echo $lang->review->reviewedDate;?></th>
            <td><?php echo html::input('createdDate', helper::today(), 'class="form-control form-date"');?></td>
            <td>
              <div class='input-group'>
              <span class='input-group-addon'><?php echo $lang->review->consumed;?></span>
              <?php echo html::input('consumed', isset($result->consumed) ? $result->consumed : 0, "class='form-control'");?>
              <span class='input-group-addon'>h</span>
              </div>
            </td>
          </tr>
          <tr>
            <td colspan='5'>
              <div class='input-group'>
              <span class='input-group-addon'><?php echo $lang->review->finalOpinion;?></span>
              <?php echo html::textarea('opinion', isset($result->opinion) ? $result->opinion : '', "class='form-control'");?>
              </div>
            </td>
          </tr>
          <tr>
            <th></th>
            <td colspan='5' class='text-center'>
            <?php echo html::submitButton();?>
            </td>
          </tr>
        </table>
      </div>
    </div>
  </div>
</form>
<style>
.review-footer{margin-top: 10px; height: 260px;}
.review-footer table th{vertical-align: middle}
.reviewcl td{padding: 4px 10px !important;}
</style>
<?php js::set('stopSubmit', $lang->review->stopSubmit);?>
<script>
$(function()
{
    var mainHeight = $(window).height() - $('#footer').outerHeight() - $('#header').outerHeight() - 350;
    var sideHeight = mainHeight + 275;
    $('.main-col #reviewcl').css('height', mainHeight);
    $('.side-col .cell').css('height', sideHeight);
    $('table.reviewcl .issueResult, table.reviewcl .resolved').change(function()
    {
        var result = $(this).val();
        if(result == 1)
        {
            $(this).closest('tr').find('.opinion').attr('readonly', true);
        }
        else
        {
            $(this).closest('tr').find('.opinion').attr('readonly', false);
        }
    })

    $(".issueResult").on("click", function()
    {
        var issueResult  = [];
        var reviewStatus = '';
        $("input[name^='issueResult']:checked").each(function(i, el)
        {
            var choose = $(el).attr("name");
            var userChoose = [];
            userChoose['issue']  = choose;
            userChoose['result'] = $(el).attr("value");
            issueResult.push(userChoose);
        })

        var success = 1;
        for(var i = 0; i < issueResult.length; i++)
        {
            if( issueResult[i]['result'] == "0")
            {
                $("input[name='result'][value='pass']").removeAttr('checked').attr('disabled','disabled');
                if(!$("input[name='result'][value='fail']").attr('checked')){$("input[name='result'][value='needfix']").attr('checked', true);}
                success = 0;
            }
        }

        if(success)
        {
            $("input[name='result'][value='pass']").removeAttr('disabled').attr('checked',true);
            $("input[name='result'][value='fail']").attr('checked', false);
            $("input[name='result'][value='needfix']").attr('checked', false);
        }
    })
})
</script>
<?php include $app->getModuleRoot() . 'common/view/footer.html.php';?>
