<?php
/**
 * The caselib of assetlib module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2021 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/page/zplv12.html)
 * @author      Liyuchun <liyuchun@easycorp.ltd>
 * @package     assetlib
 * @version     $Id: caselib.html.php 4903 2021-06-24 08:54:59Z $
 * @link        https://www.zentao.net
 */
?>
<?php include $app->getModuleRoot() . "common/view/header.html.php"?>
<div id="mainMenu" class="clearfix">
  <div class="btn-toobar pull-left">
    <?php echo html::a($this->createLink('assetlib', 'caseLib'), "<span class='text'>{$lang->assetlib->all}</span>", '', "class='btn btn-link btn-active-text'");?>
  </div>
</div>
<div id="mainContent" class="main-table">
  <?php if(empty($libs)):?>
  <div class="table-empty-tip">
    <p><span class="text-muted"><?php echo $lang->noData;?></span></p>
  </div>
  <?php else:?>
  <table class="table has-sort-head" id='libList'>
    <?php $vars = "orderBy=%s&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}"; ?>
    <thead>
      <tr>
        <th class='text-left w-60px'><?php common::printOrderLink('id', $orderBy, $vars, $lang->assetlib->id);?></th>
        <th><?php common::printOrderLink('name', $orderBy, $vars, $lang->assetlib->name);?></th>
        <th class='w-300px'><?php echo $lang->assetlib->desc;?></th>
        <th class='w-120px'><?php common::printOrderLink('addedBy', $orderBy, $vars, $lang->assetlib->createdBy);?></th>
      </tr>
    </thead>
    <tbody>
      <?php $this->loadModel('file');?>
      <?php foreach($libs as $lib):?>
      <?php $lib = $this->file->replaceImgURL($lib, 'desc');?>
      <tr>
        <td><?php echo sprintf('%03d',$lib->id);?></td>
        <td class='c-name' title="<?php echo $lib->name;?>"><?php echo html::a($this->createLink('caselib', 'browse', "libID=$lib->id"), $lib->name);?></td>
        <td  class='text-left content'>
          <?php $desc = trim(strip_tags(str_replace(array('</p>', '<br />', '<br>', '<br/>'), "\n", str_replace(array("\n    ", "\r"), '', $lib->desc)), '<img>'));?>
          <div title='<?php echo $desc;?>'><?php echo nl2br($desc);?></div>
        </td>
        <td><?php echo zget($users, $lib->addedBy);?></td>
      </tr>
      <?php endforeach;?>
    </tbody>
  </table>
  <div class='table-footer'>
    <?php $pager->show('right', 'pagerjs');?>
  </div>
  <?php endif;?>
</div>
<?php include $app->getModuleRoot() . "common/view/footer.html.php"?>
