<?php
/**
 * The myMeeting  of my module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2021 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/page/zplv12.html)
 * @author      Shujie Tian <tianshujie@easycorp.ltd>
 * @package     my
 * @version     $Id: myMeeing.html.php 4903 2021-06-12 18:48:59Z $
 * @link        https://www.zentao.net
 */
?>
<?php include $app->getModuleRoot() . 'common/view/header.html.php'?>
<?php js::set('browseType', $browseType);?>
<?php js::set('mode', $mode);?>
<?php js::set('total', $pager->recTotal);?>
<?php js::set('rawMethod', $app->rawMethod);?>
<div id="mainContent" class="main-table">
  <?php if(empty($meetings)):?>
  <div class="table-empty-tip">
    <p>
      <span class="text-muted"><?php echo $lang->noData;?></span>
    </p>
  </div>
  <?php else:?>
  <table class="table has-sort-head" id='meetingList'>
    <?php $vars = "mode=$mode&type=$browseType&orderBy=%s&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}";?>
    <thead>
      <tr>
        <th class='text-left w-60px'><?php common::printOrderLink('id', $orderBy, $vars, $lang->meeting->id);?></th>
        <th class='w-100px'><?php common::printOrderLink('date', $orderBy, $vars, $lang->meeting->date);?></th>
        <th class='text-left'><?php common::printOrderLink('name', $orderBy, $vars, $lang->meeting->name);?></th>
        <th class='w-100px'><?php common::printOrderLink('dept', $orderBy, $vars, $lang->meeting->dept);?></th>
        <th class='w-120px'><?php common::printOrderLink('mode', $orderBy, $vars, $lang->meeting->mode);?></th>
        <th class='w-80px'><?php common::printOrderLink('host', $orderBy, $vars, $lang->meeting->host);?></th>
        <th class='w-80px'><?php common::printOrderLink('minutedBy', $orderBy, $vars, $lang->meeting->minutedBy);?></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($meetings as $meeting):?>
      <tr>
        <td><?php echo sprintf('%03d',$meeting->id);?></td>
        <td><?php echo $meeting->date;?></td>
        <td class='c-name' title="<?php echo $meeting->name;?>"><?php echo html::a($this->createLink('meeting', 'view', "meetingID=$meeting->id"), $meeting->name, '', "data-app='{$app->tab}'");?></td>
        <td class='dept' title="<?php echo zget($depts, $meeting->dept);?>"><?php echo zget($depts, $meeting->dept);?></td>
        <td><?php echo zget($lang->meeting->modeList, $meeting->mode);?></td>
        <td><?php echo zget($users, $meeting->host);?></td>
        <td><?php echo zget($users, $meeting->minutedBy);?></td>
      </tr>
      <?php endforeach;?>
    </tbody>
  </table>
  <div class='table-footer'>
    <?php $pager->show('right', 'pagerjs');?>
  </div>
  <?php endif;?>
</div>
<?php include $app->getModuleRoot() . 'common/view/footer.html.php'?>
