<?php
/**
 * The browse view file of vm module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2015 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/page/zplv12.html)
 * @author      xiawenlong <xiawenlong@cnezsoft.com>
 * @package     vm
 * @version     $Id$
 * @link        http://www.zentao.net
 */
?>
<?php include $app->getModuleRoot() . 'common/view/header.html.php';?>
<?php js::set('confirmDelete', $lang->vm->confirmDelete)?>
<?php js::set('confirmBoot', $lang->vm->confirmBoot)?>
<?php js::set('confirmReboot', $lang->vm->confirmReboot)?>
<?php js::set('confirmShutdown', $lang->vm->confirmShutdown)?>
<?php js::set('actionSuccess', $lang->vm->actionSuccess)?>
<div id='mainMenu' class='clearfix'>
  <div class='pull-left btn-toolbar'>
    <?php echo html::a($this->createLink('vm', 'browse'), "<span class='text'>{$lang->vm->all}</span>", '', "class='btn btn-link btn-active-text'");?>
    <a href='#' id='bysearchTab' class='btn btn-link querybox-toggle'><i class='icon-search icon'></i>&nbsp;<?php echo $lang->vm->byQuery;?></a>
  </div>

  <?php if(common::hasPriv('vm', 'create')):?>
  <div class="btn-toolbar pull-right" id='createActionMenu'>
    <?php
    $misc = "class='btn btn-primary iframe'";
    $link = $this->createLink('vm', 'create', '', '', true);
    echo html::a($link, "<i class='icon icon-plus'></i>" . $lang->vm->create, '', $misc);
    ?>
  </div>
  <?php endif;?>
</div>
<div id='queryBox' class='cell <?php if($browseType =='bysearch') echo 'show';?>' data-module='vm'></div>
<div id='mainContent' class='main-table'>
<?php $vars = "browseType=$browseType&param=$param&orderBy=%s&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}";?>
  <table class='table has-sort-head' id='vmList'>
    <thead>
      <tr>
        <th class='w-80px'><?php common::printOrderLink('id', $orderBy, $vars, $lang->idAB);?></th>
        <th class='w-200px'><?php common::printOrderLink('name', $orderBy, $vars, $lang->vm->name);?></th>
        <th class='w-100px'><?php echo $lang->vm->hostName;?></th>
        <th class='w-100px'><?php common::printOrderLink('ip', $orderBy, $vars, $lang->vm->ip);?></th>
        <th class='w-80px'><?php common::printOrderLink('osType', $orderBy, $vars, $lang->vm->osType);?></th>
        <th class='w-80px'><?php common::printOrderLink('osCategory', $orderBy, $vars, $lang->vm->osCategory);?></th>
        <th class='w-80px'><?php common::printOrderLink('osArch', $orderBy, $vars, $lang->vm->osArch);?></th>
        <th class='w-80px'><?php common::printOrderLink('osLang', $orderBy, $vars, $lang->vm->osLang);?></th>
        <th class='w-100px'><?php common::printOrderLink('status', $orderBy, $vars, $lang->vm->status);?></th>
        <th class='w-100px'><?php common::printOrderLink('createdBy', $orderBy, $vars, $lang->vm->creater);?></th>
        <th class='w-150px'><?php common::printOrderLink('createdDate', $orderBy, $vars, $lang->vm->createdDate);?></th>
        <th class='w-120px'><?php echo $lang->actions?></th>
      </tr>
    </thead>
    <?php if(!empty($vmList)):?>
    <tbody>
      <?php foreach($vmList as $vm):?>
      <tr>
        <td><?php echo $vm->id;?></td>
        <td title="<?php echo $vm->name;?>"><?php echo html::a($this->inlink('view', "id=$vm->id", 'html', true), $vm->name, '',"class='iframe'");?></td>
        <td><?php echo $vm->hostName;?></td>
        <td><?php echo $vm->ip;?></td>
        <td><?php echo $vm->osCategory;?></td>
        <td><?php echo $vm->osType;?></td>
        <td><?php echo $vm->osArch;?></td>
        <td><?php echo $vm->osLang;?></td>
        <td><?php echo zget($lang->vm->statusList, $vm->status);?></td>
        <td><?php echo zget($users, $vm->createdBy);?></td>
        <td><?php echo $vm->createdDate;?></td>
        <td class='c-actions'>
        <?php
        // if(common::hasPriv('vm', 'boot'))
        // {
        //     $url = $this->createLink('vm', 'handleVM', "vmID=$vm->id&type=boot");
        //     echo html::a("javascript:ajaxAction(\"$url\", \"mainContent\", confirmBoot)", '<i class="icon-play"></i>', '', "class='btn' title='{$lang->vm->boot}'");

        // }
        if(common::hasPriv('vm', 'handleVM'))
        {
            $url = $this->createLink('vm', 'handleVM', "vmID=$vm->id&type=reboot");
            echo html::a("javascript:ajaxAction(\"$url\", \"mainContent\", confirmReboot)", '<i class="icon-refresh"></i>', '', "class='btn' title='{$lang->vm->reboot}'");

        }
        // if(common::hasPriv('vm', 'shutdown'))
        // {
        //     $url = $this->createLink('vm', 'handleVM', "vmID=$vm->id&type=shutdown");
        //     echo html::a("javascript:ajaxAction(\"$url\", \"mainContent\", confirmShutdown)", '<i class="icon-off"></i>', '', "class='btn' title='{$lang->vm->shutdown}'");

        // }
        if(common::hasPriv('vm', 'destroy'))
        {
            $deleteURL = $this->createLink('vm', 'destroy', "vmID=$vm->id");
            echo html::a("javascript:ajaxDelete(\"$deleteURL\", \"mainContent\", confirmDelete)", '<i class="icon-trash"></i>', '', "class='btn' title='{$lang->vm->destroy}'");
        }
        ?>
        </td>
      </tr>
      <?php endforeach;?>
    </tbody>
    <?php endif;?>
  </table>
  <div class='table-footer'>
    <?php $pager->show('right', 'pagerjs');?>
  </div>
</div>

<?php include $app->getModuleRoot() . 'common/view/footer.html.php';?>
