-- DROP TABLE IF EXISTS `zt_feedback`;
CREATE TABLE IF NOT EXISTS `zt_feedback` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `module` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `solution` char(30) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `subStatus` varchar(30) NOT NULL default '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `notifyEmail` varchar(100) NOT NULL,
  `likes` text NOT NULL,
  `result` mediumint(8) unsigned NOT NULL,
  `faq` mediumint(8) unsigned NOT NULL,
  `openedBy` char(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `processedBy` char(30) NOT NULL,
  `processedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(255) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `feedbackBy` varchar(100) NOT NULL,
  `mailto` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`   ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `caseVersion`;
ALTER TABLE `zt_story` ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `fromBug`;
ALTER TABLE `zt_user`  ADD `feedback` enum('0', '1') NOT NULL DEFAULT '0' AFTER `locked`;
ALTER TABLE `zt_group` ADD `developer` enum('0', '1') NOT NULL DEFAULT '1' AFTER `acl`;

INSERT INTO `zt_group` (`name`, `role`, `desc`, `acl`, `developer`) VALUES ('FEEDBACK', 'feedback', 'Feedback', '', '0');

-- DROP TABLE IF EXISTS `zt_feedbackproduct`;
CREATE TABLE IF NOT EXISTS `zt_feedbackview` (
  `account` char(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_serverroom`;
CREATE TABLE IF NOT EXISTS `zt_serverroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `city` varchar(128) NOT NULL,
  `line` varchar(20) NOT NULL,
  `bandwidth` varchar(128) NOT NULL,
  `provider` varchar(128) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_account`;
CREATE TABLE IF NOT EXISTS `zt_account` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `provider` varchar(255) NOT NULL,
  `adminURI` varchar(255) NOT NULL,
  `account` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobile` varchar(255) NOT NULL,
  `extra` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `status` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `name` (`name`),
  key `provider` (`provider`),
  key `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_asset`;
CREATE TABLE IF NOT EXISTS `zt_asset` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `group` varchar(128) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_host`;
CREATE TABLE IF NOT EXISTS `zt_host` (
  `id` mediumint(8) unsigned  NOT NULL AUTO_INCREMENT,
  `assetID`      mediumint(8) UNSIGNED NOT NULL,
  `admin`        smallint(5)  UNSIGNED NOT NULL DEFAULT 0,
  `serverRoom`   mediumint(8) UNSIGNED NOT NULL,
  `cabinet`      varchar(128) NOT NULL,
  `serverModel`  varchar(256) NOT NULL,
  `hardwareType` varchar(64)  NOT NULL,
  `hostType`     enum('physical','virtual') NOT NULL,
  `cpuBrand`     varchar(128) NOT NULL,
  `cpuModel`     varchar(128) NOT NULL,
  `cpuNumber`    varchar(16)  NOT NULL,
  `cpuCores`     varchar(30)  NOT NULL,
  `cpuRate`      varchar(30)  NOT NULL,
  `memory`       varchar(30)  NOT NULL,
  `diskType`     varchar(30)  NOT NULL,
  `diskSize`     varchar(30)  NOT NULL,
  `unit`         enum('GB','TB') NOT NULL DEFAULT 'GB',
  `privateIP`    varchar(128) NOT NULL,
  `publicIP`     varchar(128) NOT NULL,
  `nic`          varchar(128) NOT NULL,
  `mac`          varchar(128) NOT NULL,
  `osName`       varchar(64)  NOT NULL,
  `osVersion`    varchar(64)  NOT NULL,
  `webserver`    varchar(128) NOT NULL,
  `database`     varchar(128) NOT NULL,
  `language`     varchar(16)  NOT NULL,
  `status`       varchar(50)  NOT NULL,
  `agentPort` varchar(10) NOT NULL,
  `instanceNum` tinyint(0) NOT NULL DEFAULT 0,
  `pri` smallint(5) unsigned NOT NULL DEFAULT 0,
  `heartbeatTime` datetime NOT NULL,
  `tags` varchar(50)  NOT NULL DEFAULT '',
  `provider` varchar(255) NOT NULL DEFAULT '',
  `bridgeID` varchar(255) NOT NULL DEFAULT '',
  `cloudKey` varchar(255) NOT NULL DEFAULT '',
  `cloudSecret` varchar(255) NOT NULL DEFAULT '',
  `cloudRegion` varchar(255) NOT NULL DEFAULT '',
  `cloudNamespace` varchar(255) NOT NULL DEFAULT '',
  `cloudUser` varchar(255) NOT NULL DEFAULT '',
  `cloudAccount` varchar(255) NOT NULL DEFAULT '',
  `cloudPassword` varchar(255) NOT NULL DEFAULT '',
  `couldVPC` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_service`;
CREATE TABLE IF NOT EXISTS `zt_service` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `external` enum('0','1') NOT NULL DEFAULT '0',
  `port` smallint(5) unsigned NOT NULL,
  `entry` varchar(255) NOT NULL,
  `deploy` varchar(255) NOT NULL,
  `version` varchar(64) NOT NULL,
  `color` char(7) NOT NULL,
  `desc` text,
  `dept` varchar(128) NOT NULL,
  `devel` varchar(30) NOT NULL,
  `qa` varchar(30) NOT NULL,
  `ops` varchar(30) NOT NULL,
  `hosts` text,
  `softName` varchar(128) NOT NULL,
  `softVersion` varchar(128) NOT NULL,
  `type` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES (1, 'tree', 'editHost');

-- DROP TABLE IF EXISTS `zt_attend`;
CREATE TABLE IF NOT EXISTS `zt_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `signIn` time NOT NULL,
  `signOut` time NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL,
  `device` varchar(30) NOT NULL,
  `client` varchar(20) NOT NULL,
  `manualIn` time NOT NULL,
  `manualOut` time NOT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`),
  UNIQUE KEY `attend` (`date`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_attendstat`;
CREATE TABLE IF NOT EXISTS `zt_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`),
  UNIQUE KEY `attend` (`month`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_overtime`;
CREATE TABLE IF NOT EXISTS `zt_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_leave`;
CREATE TABLE IF NOT EXISTS `zt_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lieu`;
CREATE TABLE IF NOT EXISTS `zt_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL,
  `trip` char(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_trip`;
CREATE TABLE IF NOT EXISTS `zt_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip', 'egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL,
  `name` char(30) NOT NULL,
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `from` char(50) NOT NULL,
  `to` char(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_deploy`;
CREATE TABLE IF NOT EXISTS `zt_deploy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(20) NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `notify` text NOT NULL,
  `cases` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `result` varchar(20) NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deployproduct`;
CREATE TABLE IF NOT EXISTS `zt_deployproduct` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `release` mediumint(8) unsigned NOT NULL,
  `package` varchar(255) NOT NULL,
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deploystep`;
CREATE TABLE IF NOT EXISTS `zt_deploystep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `stage` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `finishedBy` char(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `zt_testresult` ADD `deploy` mediumint(8) unsigned NOT NULL;
-- DROP TABLE IF EXISTS `zt_deployscope`;
CREATE TABLE IF NOT EXISTS `zt_deployscope` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `service` mediumint(8) unsigned NOT NULL,
  `hosts` text NOT NULL,
  `remove` text NOT NULL,
  `add` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_vm`;
CREATE TABLE IF NOT EXISTS `zt_vm` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostID` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `osCategory` varchar(50) NOT NULL DEFAULT '',
  `osType` varchar(50) NOT NULL DEFAULT '',
  `osArch` varchar(50) NOT NULL DEFAULT '',
  `osLang` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT '',
  `destroyAt` datetime NULL,
  `ip` varchar(200) NOT NULL DEFAULT '',
  `agentPort` varchar(255) NOT NULL DEFAULT '',
  `macAddress` varchar(255) NOT NULL DEFAULT '',
  `workspace` varchar(255) NOT NULL DEFAULT '',
  `templateID` int(10) unsigned NOT NULL DEFAULT 0,
  `baseImageID` int(10) unsigned NOT NULL DEFAULT 0,
  `baseImagePath` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `heatbeat` datetime NULL,
  `vnc` varchar(255) NOT NULL DEFAULT '',
  `instance` varchar(255) NOT NULL DEFAULT '',
  `eip` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `public` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_baseimage`;
CREATE TABLE IF NOT EXISTS `zt_baseimage` (
  `id` SMALLINT(7) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `osType` varchar(50) NOT NULL DEFAULT '',
  `os` varchar(50) NOT NULL DEFAULT '',
  `osCategory` varchar(50) NOT NULL DEFAULT '',
  `osArch` varchar(50) NOT NULL DEFAULT '',
  `osLang` varchar(50) NOT NULL DEFAULT '',
  `suggestCore` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `suggestMemory` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `suggestVolume` mediumint(6) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_vmtemplate`;
CREATE TABLE IF NOT EXISTS `zt_vmtemplate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostID` int(10) unsigned NOT NULL DEFAULT 0,
  `templateName` varchar(255) NOT NULL DEFAULT '',
  `osType` varchar(50) NOT NULL DEFAULT '',
  `osCategory` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_browser`;
CREATE TABLE IF NOT EXISTS `zt_browser` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `lang` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_baseimagebrowser`;
CREATE TABLE IF NOT EXISTS `zt_baseimagebrowser` (
  `vmBackingID` int(10) NOT NULL,
  `browserID` int(10) NOT NULL,
  PRIMARY KEY (`vmBackingID`, `browserID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincourse`;
CREATE TABLE `zt_traincourse` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `category` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` varchar(10) NOT NULL,
  `teacher` varchar(30) NOT NULL default '',
  `desc` text NOT NULL,
  `createdBy` varchar(255) NOT NULL,
  `createdDate` date NOT NULL,
  `editedBy` varchar(255) NOT NULL,
  `editedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincontents`;
CREATE TABLE IF NOT EXISTS `zt_traincontents` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `course` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `order` mediumint(8) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincategory`;
CREATE TABLE IF NOT EXISTS `zt_traincategory` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) NOT NULL,
  `order` mediumint(8) NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_trainrecords`;
CREATE TABLE IF NOT EXISTS `zt_trainrecords` (
  `user` char(30) NOT NULL,
  `objectId` mediumint(8) unsigned NOT NULL,
  `objectType` varchar(10) NOT NULL,
  `status` varchar(10) NOT NULL,
  PRIMARY KEY (`user`, `objectId`, `objectType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_doc`
ADD `parent` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `type`,
ADD `path` char(255) COLLATE 'utf8_general_ci' NOT NULL DEFAULT '' AFTER `parent`,
ADD `grade` tinyint(3) unsigned NOT NULL DEFAULT '0' AFTER `path`,
ADD `order` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `grade`;

ALTER TABLE `zt_product` ADD `feedback` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `RD`;

ALTER TABLE `zt_leave`       ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_leave`       ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_leave`       ADD `reviewers` text NOT NULL;
ALTER TABLE `zt_leave`       ADD `backReviewers` text NOT NULL;
ALTER TABLE `zt_lieu`        ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `reviewers` text NOT NULL;
ALTER TABLE `zt_overtime`    ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `reviewers` text NOT NULL;

-- DROP TABLE IF EXISTS `zt_faq`;
CREATE TABLE IF NOT EXISTS `zt_faq` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
`module` mediumint(9) NOT NULL,
`product` mediumint(9) NOT NULL,
`question` varchar(255) NOT NULL,
`answer` text NOT NULL,
`addedtime` datetime NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_task` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `fromBug`;
ALTER TABLE `zt_todo` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `end`;

-- DROP TABLE IF EXISTS `zt_domain`;
CREATE TABLE IF NOT EXISTS `zt_domain`(
  `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `adminURI` varchar(255) NOT NULL,
  `resolverURI` varchar(255) NOT NULL,
  `register` varchar(255) NOT NULL,
  `expiredDate` datetime NOT NULL,
  `renew` varchar(255) NOT NULL,
  `account` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `domain` (`domain`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP VIEW IF EXISTS `view_datasource_5`;
CREATE VIEW `view_datasource_5`  AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'rnd';

DROP VIEW IF EXISTS `view_datasource_46`;
CREATE VIEW `view_datasource_46` AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'lite';

UPDATE `zt_user` SET `visions` = 'lite' WHERE `feedback` = '1';

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'account','browse'),
(1,'account','create'),
(1,'account','delete'),
(1,'account','edit'),
(1,'account','view'),
(1,'attend','browseReview'),
(1,'attend','company'),
(1,'attend','department'),
(1,'attend','detail'),
(1,'attend','edit'),
(1,'attend','export'),
(1,'attend','exportDetail'),
(1,'attend','exportStat'),
(1,'attend','personal'),
(1,'attend','personalSettings'),
(1,'attend','review'),
(1,'attend','saveStat'),
(1,'attend','setManager'),
(1,'attend','settings'),
(1,'attend','stat'),
(1,'build','browse'),
(1,'custom','feedback'),
(1,'custom','libreoffice'),
(1,'deploy','activate'),
(1,'deploy','assignTo'),
(1,'deploy','batchUnlinkCases'),
(1,'deploy','browse'),
(1,'deploy','cases'),
(1,'deploy','create'),
(1,'deploy','delete'),
(1,'deploy','deleteStep'),
(1,'deploy','edit'),
(1,'deploy','editStep'),
(1,'deploy','finish'),
(1,'deploy','finishStep'),
(1,'deploy','linkCases'),
(1,'deploy','manageScope'),
(1,'deploy','manageStep'),
(1,'deploy','scope'),
(1,'deploy','steps'),
(1,'deploy','unlinkCase'),
(1,'deploy','view'),
(1,'deploy','viewStep'),
(1,'doc','catalog'),
(1,'doc','diff'),
(1,'doc','manageBook'),
(1,'domain','browse'),
(1,'domain','create'),
(1,'domain','delete'),
(1,'domain','edit'),
(1,'domain','view'),
(1,'faq','browse'),
(1,'faq','create'),
(1,'faq','delete'),
(1,'faq','edit'),
(1,'feedback','admin'),
(1,'feedback','adminView'),
(1,'feedback','assignTo'),
(1,'feedback','batchAssignTo'),
(1,'feedback','batchChangeModule'),
(1,'feedback','batchClose'),
(1,'feedback','batchEdit'),
(1,'feedback','batchReview'),
(1,'feedback','browse'),
(1,'feedback','close'),
(1,'feedback','comment'),
(1,'feedback','create'),
(1,'feedback','delete'),
(1,'feedback','edit'),
(1,'feedback','export'),
(1,'feedback','index'),
(1,'feedback','manageProduct'),
(1,'feedback','products'),
(1,'feedback','review'),
(1,'feedback','view'),
(1,'holiday','browse'),
(1,'holiday','create'),
(1,'holiday','delete'),
(1,'holiday','edit'),
(1,'host','browse'),
(1,'host','changeStatus'),
(1,'host','create'),
(1,'host','delete'),
(1,'host','edit'),
(1,'host','treemap'),
(1,'host','view'),
(1,'leave','back'),
(1,'leave','browseReview'),
(1,'leave','company'),
(1,'leave','create'),
(1,'leave','delete'),
(1,'leave','edit'),
(1,'leave','export'),
(1,'leave','personal'),
(1,'leave','personalAnnual'),
(1,'leave','review'),
(1,'leave','setReviewer'),
(1,'leave','switchstatus'),
(1,'leave','view'),
(1,'lieu','browseReview'),
(1,'lieu','company'),
(1,'lieu','create'),
(1,'lieu','delete'),
(1,'lieu','edit'),
(1,'lieu','personal'),
(1,'lieu','review'),
(1,'lieu','setReviewer'),
(1,'lieu','switchstatus'),
(1,'lieu','view'),
(1,'makeup','browseReview'),
(1,'makeup','company'),
(1,'makeup','create'),
(1,'makeup','delete'),
(1,'makeup','edit'),
(1,'makeup','export'),
(1,'makeup','personal'),
(1,'makeup','review'),
(1,'makeup','setReviewer'),
(1,'makeup','switchstatus'),
(1,'makeup','view'),
(1,'my','review'),
(1,'ops','index'),
(1,'ops','setting'),
(1,'overtime','browseReview'),
(1,'overtime','company'),
(1,'overtime','create'),
(1,'overtime','delete'),
(1,'overtime','edit'),
(1,'overtime','export'),
(1,'overtime','personal'),
(1,'overtime','review'),
(1,'overtime','setReviewer'),
(1,'overtime','switchstatus'),
(1,'overtime','view'),
(1,'serverroom','browse'),
(1,'serverroom','create'),
(1,'serverroom','delete'),
(1,'serverroom','edit'),
(1,'serverroom','view'),
(1,'service','browse'),
(1,'service','create'),
(1,'service','delete'),
(1,'service','edit'),
(1,'service','index'),
(1,'service','manage'),
(1,'service','view'),
(1,'story','browse'),
(1,'task','browse'),
(1,'testtask','deployCaseResults'),
(1,'testtask','runDeployCase'),
(1,'tree','browsehost'),
(1,'tree','editHost'),
(1,'workflow','activate'),
(1,'workflow','backup'),
(1,'workflow','browse'),
(1,'workflow','browseDB'),
(1,'workflow','browseFlow'),
(1,'workflow','copy'),
(1,'workflow','create'),
(1,'workflow','deactivate'),
(1,'workflow','delete'),
(1,'workflow','edit'),
(1,'workflow','flowchart'),
(1,'workflow','release'),
(1,'workflow','setCSS'),
(1,'workflow','setJS'),
(1,'workflow','ui'),
(1,'workflow','upgrade'),
(1,'workflow','view'),
(1,'workflowaction','browse'),
(1,'workflowaction','create'),
(1,'workflowaction','delete'),
(1,'workflowaction','edit'),
(1,'workflowaction','setCSS'),
(1,'workflowaction','setJS'),
(1,'workflowaction','setNotice'),
(1,'workflowaction','setVerification'),
(1,'workflowaction','sort'),
(1,'workflowaction','view'),
(1,'workflowcondition','browse'),
(1,'workflowcondition','create'),
(1,'workflowcondition','delete'),
(1,'workflowcondition','edit'),
(1,'workflowdatasource','browse'),
(1,'workflowdatasource','create'),
(1,'workflowdatasource','delete'),
(1,'workflowdatasource','edit'),
(1,'workflowfield','browse'),
(1,'workflowfield','create'),
(1,'workflowfield','delete'),
(1,'workflowfield','edit'),
(1,'workflowfield','exportTemplate'),
(1,'workflowfield','import'),
(1,'workflowfield','setExport'),
(1,'workflowfield','setSearch'),
(1,'workflowfield','setValue'),
(1,'workflowfield','showImport'),
(1,'workflowfield','sort'),
(1,'workflowhook','browse'),
(1,'workflowhook','create'),
(1,'workflowhook','delete'),
(1,'workflowhook','edit'),
(1,'workflowlabel','browse'),
(1,'workflowlabel','create'),
(1,'workflowlabel','delete'),
(1,'workflowlabel','edit'),
(1,'workflowlabel','sort'),
(1,'workflowlayout','admin'),
(1,'workflowlayout','block'),
(1,'workflowlinkage','browse'),
(1,'workflowlinkage','create'),
(1,'workflowlinkage','delete'),
(1,'workflowlinkage','edit'),
(1,'workflowrelation','admin'),
(1,'workflowreport','browse'),
(1,'workflowreport','create'),
(1,'workflowreport','delete'),
(1,'workflowreport','edit'),
(1,'workflowreport','sort'),
(1,'workflowrule','browse'),
(1,'workflowrule','create'),
(1,'workflowrule','delete'),
(1,'workflowrule','edit'),
(1,'workflowrule','view'),
(2,'account','browse'),
(2,'account','view'),
(2,'attend','company'),
(2,'attend','department'),
(2,'attend','detail'),
(2,'attend','edit'),
(2,'attend','export'),
(2,'attend','exportDetail'),
(2,'attend','exportStat'),
(2,'attend','personal'),
(2,'build','browse'),
(2,'deploy','activate'),
(2,'deploy','assignTo'),
(2,'deploy','batchUnlinkCases'),
(2,'deploy','browse'),
(2,'deploy','cases'),
(2,'deploy','create'),
(2,'deploy','delete'),
(2,'deploy','deleteStep'),
(2,'deploy','edit'),
(2,'deploy','editStep'),
(2,'deploy','finish'),
(2,'deploy','finishStep'),
(2,'deploy','linkCases'),
(2,'deploy','manageScope'),
(2,'deploy','manageStep'),
(2,'deploy','scope'),
(2,'deploy','steps'),
(2,'deploy','unlinkCase'),
(2,'deploy','view'),
(2,'deploy','viewStep'),
(2,'doc','diff'),
(2,'domain','browse'),
(2,'domain','view'),
(2,'feedback','admin'),
(2,'feedback','adminView'),
(2,'feedback','batchAssignTo'),
(2,'feedback','batchClose'),
(2,'feedback','batchEdit'),
(2,'feedback','browse'),
(2,'feedback','close'),
(2,'feedback','comment'),
(2,'feedback','create'),
(2,'feedback','delete'),
(2,'feedback','edit'),
(2,'feedback','index'),
(2,'feedback','view'),
(2,'holiday','browse'),
(2,'holiday','create'),
(2,'holiday','delete'),
(2,'holiday','edit'),
(2,'host','browse'),
(2,'host','changeStatus'),
(2,'host','create'),
(2,'host','delete'),
(2,'host','edit'),
(2,'host','treemap'),
(2,'host','view'),
(2,'leave','create'),
(2,'leave','delete'),
(2,'leave','edit'),
(2,'leave','export'),
(2,'leave','personal'),
(2,'leave','personalAnnual'),
(2,'leave','switchstatus'),
(2,'leave','view'),
(2,'lieu','create'),
(2,'lieu','delete'),
(2,'lieu','edit'),
(2,'lieu','personal'),
(2,'lieu','switchstatus'),
(2,'lieu','view'),
(2,'makeup','create'),
(2,'makeup','delete'),
(2,'makeup','edit'),
(2,'makeup','export'),
(2,'makeup','personal'),
(2,'makeup','switchstatus'),
(2,'makeup','view'),
(2,'my','review'),
(2,'ops','index'),
(2,'ops','setting'),
(2,'overtime','create'),
(2,'overtime','delete'),
(2,'overtime','edit'),
(2,'overtime','export'),
(2,'overtime','personal'),
(2,'overtime','switchstatus'),
(2,'overtime','view'),
(2,'serverroom','browse'),
(2,'serverroom','create'),
(2,'serverroom','delete'),
(2,'serverroom','edit'),
(2,'serverroom','view'),
(2,'service','browse'),
(2,'service','create'),
(2,'service','delete'),
(2,'service','edit'),
(2,'service','index'),
(2,'service','manage'),
(2,'service','view'),
(2,'story','browse'),
(2,'task','browse'),
(3,'attend','company'),
(3,'attend','department'),
(3,'attend','detail'),
(3,'attend','edit'),
(3,'attend','export'),
(3,'attend','exportDetail'),
(3,'attend','personal'),
(3,'doc','diff'),
(3,'leave','back'),
(3,'leave','create'),
(3,'leave','delete'),
(3,'leave','edit'),
(3,'leave','export'),
(3,'leave','personal'),
(3,'leave','personalAnnual'),
(3,'leave','switchstatus'),
(3,'leave','view'),
(3,'lieu','create'),
(3,'lieu','delete'),
(3,'lieu','edit'),
(3,'lieu','personal'),
(3,'lieu','switchstatus'),
(3,'lieu','view'),
(3,'makeup','create'),
(3,'makeup','delete'),
(3,'makeup','edit'),
(3,'makeup','personal'),
(3,'makeup','switchstatus'),
(3,'makeup','view'),
(3,'my','review'),
(3,'overtime','create'),
(3,'overtime','delete'),
(3,'overtime','edit'),
(3,'overtime','export'),
(3,'overtime','personal'),
(3,'overtime','switchstatus'),
(3,'overtime','view'),
(3,'testtask','deployCaseResults'),
(3,'testtask','runDeployCase'),
(4,'account','browse'),
(4,'account','create'),
(4,'account','delete'),
(4,'account','edit'),
(4,'account','view'),
(4,'attend','browseReview'),
(4,'attend','company'),
(4,'attend','department'),
(4,'attend','detail'),
(4,'attend','edit'),
(4,'attend','export'),
(4,'attend','exportDetail'),
(4,'attend','exportStat'),
(4,'attend','personal'),
(4,'attend','review'),
(4,'attend','saveStat'),
(4,'attend','stat'),
(4,'deploy','activate'),
(4,'deploy','assignTo'),
(4,'deploy','batchUnlinkCases'),
(4,'deploy','browse'),
(4,'deploy','cases'),
(4,'deploy','create'),
(4,'deploy','delete'),
(4,'deploy','deleteStep'),
(4,'deploy','edit'),
(4,'deploy','editStep'),
(4,'deploy','finish'),
(4,'deploy','finishStep'),
(4,'deploy','linkCases'),
(4,'deploy','manageScope'),
(4,'deploy','manageStep'),
(4,'deploy','scope'),
(4,'deploy','steps'),
(4,'deploy','unlinkCase'),
(4,'deploy','view'),
(4,'deploy','viewStep'),
(4,'doc','catalog'),
(4,'doc','diff'),
(4,'doc','manageBook'),
(4,'domain','browse'),
(4,'domain','create'),
(4,'domain','delete'),
(4,'domain','edit'),
(4,'domain','view'),
(4,'faq','browse'),
(4,'feedback','admin'),
(4,'feedback','adminView'),
(4,'feedback','assignTo'),
(4,'feedback','batchAssignTo'),
(4,'feedback','batchChangeModule'),
(4,'feedback','batchClose'),
(4,'feedback','batchEdit'),
(4,'feedback','batchReview'),
(4,'feedback','browse'),
(4,'feedback','close'),
(4,'feedback','comment'),
(4,'feedback','create'),
(4,'feedback','delete'),
(4,'feedback','edit'),
(4,'feedback','export'),
(4,'feedback','index'),
(4,'feedback','manageProduct'),
(4,'feedback','products'),
(4,'feedback','review'),
(4,'feedback','view'),
(4,'host','browse'),
(4,'host','create'),
(4,'host','delete'),
(4,'host','edit'),
(4,'host','treemap'),
(4,'host','view'),
(4,'leave','back'),
(4,'leave','browseReview'),
(4,'leave','company'),
(4,'leave','create'),
(4,'leave','delete'),
(4,'leave','edit'),
(4,'leave','export'),
(4,'leave','personal'),
(4,'leave','personalAnnual'),
(4,'leave','review'),
(4,'leave','setReviewer'),
(4,'leave','switchstatus'),
(4,'leave','view'),
(4,'lieu','browseReview'),
(4,'lieu','company'),
(4,'lieu','create'),
(4,'lieu','delete'),
(4,'lieu','edit'),
(4,'lieu','personal'),
(4,'lieu','review'),
(4,'lieu','setReviewer'),
(4,'lieu','switchstatus'),
(4,'lieu','view'),
(4,'makeup','browseReview'),
(4,'makeup','company'),
(4,'makeup','create'),
(4,'makeup','delete'),
(4,'makeup','edit'),
(4,'makeup','export'),
(4,'makeup','personal'),
(4,'makeup','review'),
(4,'makeup','setReviewer'),
(4,'makeup','switchstatus'),
(4,'makeup','view'),
(4,'my','review'),
(4,'ops','index'),
(4,'ops','setting'),
(4,'overtime','browseReview'),
(4,'overtime','company'),
(4,'overtime','create'),
(4,'overtime','delete'),
(4,'overtime','edit'),
(4,'overtime','export'),
(4,'overtime','personal'),
(4,'overtime','review'),
(4,'overtime','setReviewer'),
(4,'overtime','switchstatus'),
(4,'overtime','view'),
(4,'serverroom','browse'),
(4,'serverroom','create'),
(4,'serverroom','delete'),
(4,'serverroom','edit'),
(4,'serverroom','view'),
(4,'service','browse'),
(4,'service','create'),
(4,'service','delete'),
(4,'service','edit'),
(4,'service','index'),
(4,'service','manage'),
(4,'service','view'),
(4,'story','browse'),
(4,'testtask','deployCaseResults'),
(4,'testtask','runDeployCase'),
(4,'tree','browsehost'),
(5,'account','browse'),
(5,'account','create'),
(5,'account','delete'),
(5,'account','edit'),
(5,'account','view'),
(5,'attend','company'),
(5,'attend','department'),
(5,'attend','edit'),
(5,'attend','export'),
(5,'attend','personal'),
(5,'attend','review'),
(5,'build','browse'),
(5,'deploy','activate'),
(5,'deploy','assignTo'),
(5,'deploy','batchUnlinkCases'),
(5,'deploy','browse'),
(5,'deploy','cases'),
(5,'deploy','create'),
(5,'deploy','delete'),
(5,'deploy','deleteStep'),
(5,'deploy','edit'),
(5,'deploy','editStep'),
(5,'deploy','finish'),
(5,'deploy','finishStep'),
(5,'deploy','linkCases'),
(5,'deploy','manageScope'),
(5,'deploy','manageStep'),
(5,'deploy','scope'),
(5,'deploy','steps'),
(5,'deploy','unlinkCase'),
(5,'deploy','view'),
(5,'deploy','viewStep'),
(5,'domain','browse'),
(5,'domain','create'),
(5,'domain','delete'),
(5,'domain','edit'),
(5,'domain','view'),
(5,'faq','browse'),
(5,'faq','create'),
(5,'faq','delete'),
(5,'faq','edit'),
(5,'feedback','admin'),
(5,'feedback','adminView'),
(5,'feedback','assignTo'),
(5,'feedback','batchAssignTo'),
(5,'feedback','batchChangeModule'),
(5,'feedback','batchClose'),
(5,'feedback','batchEdit'),
(5,'feedback','batchReview'),
(5,'feedback','browse'),
(5,'feedback','close'),
(5,'feedback','comment'),
(5,'feedback','create'),
(5,'feedback','delete'),
(5,'feedback','edit'),
(5,'feedback','export'),
(5,'feedback','index'),
(5,'feedback','manageProduct'),
(5,'feedback','products'),
(5,'feedback','review'),
(5,'feedback','view'),
(5,'holiday','browse'),
(5,'host','browse'),
(5,'host','changeStatus'),
(5,'host','create'),
(5,'host','delete'),
(5,'host','edit'),
(5,'host','treemap'),
(5,'host','view'),
(5,'leave','back'),
(5,'leave','create'),
(5,'leave','delete'),
(5,'leave','edit'),
(5,'leave','export'),
(5,'leave','personal'),
(5,'leave','personalAnnual'),
(5,'leave','switchstatus'),
(5,'leave','view'),
(5,'lieu','create'),
(5,'lieu','delete'),
(5,'lieu','edit'),
(5,'lieu','personal'),
(5,'lieu','switchstatus'),
(5,'lieu','view'),
(5,'makeup','create'),
(5,'makeup','delete'),
(5,'makeup','edit'),
(5,'makeup','export'),
(5,'makeup','personal'),
(5,'makeup','switchstatus'),
(5,'makeup','view'),
(5,'my','review'),
(5,'ops','index'),
(5,'ops','setting'),
(5,'overtime','create'),
(5,'overtime','delete'),
(5,'overtime','edit'),
(5,'overtime','export'),
(5,'overtime','personal'),
(5,'overtime','switchstatus'),
(5,'overtime','view'),
(5,'serverroom','browse'),
(5,'serverroom','create'),
(5,'serverroom','delete'),
(5,'serverroom','edit'),
(5,'serverroom','view'),
(5,'service','browse'),
(5,'service','create'),
(5,'service','delete'),
(5,'service','edit'),
(5,'service','index'),
(5,'service','manage'),
(5,'service','view'),
(5,'story','browse'),
(5,'task','browse'),
(6,'account','browse'),
(6,'account','create'),
(6,'account','delete'),
(6,'account','edit'),
(6,'account','view'),
(6,'attend','company'),
(6,'attend','department'),
(6,'attend','detail'),
(6,'attend','edit'),
(6,'attend','export'),
(6,'attend','exportDetail'),
(6,'attend','exportStat'),
(6,'attend','personal'),
(6,'deploy','activate'),
(6,'deploy','assignTo'),
(6,'deploy','batchUnlinkCases'),
(6,'deploy','browse'),
(6,'deploy','cases'),
(6,'deploy','create'),
(6,'deploy','delete'),
(6,'deploy','deleteStep'),
(6,'deploy','edit'),
(6,'deploy','editStep'),
(6,'deploy','finish'),
(6,'deploy','finishStep'),
(6,'deploy','linkCases'),
(6,'deploy','manageScope'),
(6,'deploy','manageStep'),
(6,'deploy','scope'),
(6,'deploy','steps'),
(6,'deploy','unlinkCase'),
(6,'deploy','view'),
(6,'deploy','viewStep'),
(6,'domain','browse'),
(6,'domain','create'),
(6,'domain','delete'),
(6,'domain','edit'),
(6,'domain','view'),
(6,'faq','browse'),
(6,'feedback','admin'),
(6,'feedback','adminView'),
(6,'feedback','assignTo'),
(6,'feedback','batchAssignTo'),
(6,'feedback','batchClose'),
(6,'feedback','batchEdit'),
(6,'feedback','batchReview'),
(6,'feedback','close'),
(6,'feedback','comment'),
(6,'feedback','delete'),
(6,'feedback','export'),
(6,'feedback','index'),
(6,'feedback','review'),
(6,'feedback','view'),
(6,'host','browse'),
(6,'host','changeStatus'),
(6,'host','create'),
(6,'host','delete'),
(6,'host','edit'),
(6,'host','treemap'),
(6,'host','view'),
(6,'leave','back'),
(6,'leave','create'),
(6,'leave','delete'),
(6,'leave','edit'),
(6,'leave','export'),
(6,'leave','personal'),
(6,'leave','personalAnnual'),
(6,'leave','switchstatus'),
(6,'leave','view'),
(6,'lieu','create'),
(6,'lieu','delete'),
(6,'lieu','edit'),
(6,'lieu','personal'),
(6,'lieu','view'),
(6,'makeup','create'),
(6,'makeup','delete'),
(6,'makeup','edit'),
(6,'makeup','export'),
(6,'makeup','personal'),
(6,'makeup','switchstatus'),
(6,'makeup','view'),
(6,'my','review'),
(6,'ops','index'),
(6,'ops','setting'),
(6,'overtime','create'),
(6,'overtime','delete'),
(6,'overtime','edit'),
(6,'overtime','export'),
(6,'overtime','personal'),
(6,'overtime','switchstatus'),
(6,'overtime','view'),
(6,'serverroom','browse'),
(6,'serverroom','create'),
(6,'serverroom','delete'),
(6,'serverroom','edit'),
(6,'serverroom','view'),
(6,'service','browse'),
(6,'service','create'),
(6,'service','delete'),
(6,'service','edit'),
(6,'service','index'),
(6,'service','manage'),
(6,'service','view'),
(6,'tree','browsehost'),
(7,'attend','company'),
(7,'deploy','activate'),
(7,'deploy','assignTo'),
(7,'deploy','batchUnlinkCases'),
(7,'deploy','browse'),
(7,'deploy','cases'),
(7,'deploy','create'),
(7,'deploy','delete'),
(7,'deploy','deleteStep'),
(7,'deploy','edit'),
(7,'deploy','editStep'),
(7,'deploy','finish'),
(7,'deploy','finishStep'),
(7,'deploy','linkCases'),
(7,'deploy','manageScope'),
(7,'deploy','manageStep'),
(7,'deploy','scope'),
(7,'deploy','steps'),
(7,'deploy','unlinkCase'),
(7,'deploy','view'),
(7,'deploy','viewStep'),
(7,'attend','department'),
(7,'attend','edit'),
(7,'attend','export'),
(7,'attend','exportDetail'),
(7,'attend','exportStat'),
(7,'attend','personal'),
(7,'doc','diff'),
(7,'faq','browse'),
(7,'faq','create'),
(7,'faq','delete'),
(7,'faq','edit'),
(7,'feedback','admin'),
(7,'feedback','adminView'),
(7,'feedback','close'),
(7,'feedback','comment'),
(7,'feedback','index'),
(7,'host','browse'),
(7,'host','changeStatus'),
(7,'host','create'),
(7,'host','delete'),
(7,'host','edit'),
(7,'host','treemap'),
(7,'host','view'),
(7,'leave','back'),
(7,'leave','create'),
(7,'leave','delete'),
(7,'leave','edit'),
(7,'leave','export'),
(7,'leave','personal'),
(7,'leave','personalAnnual'),
(7,'leave','switchstatus'),
(7,'leave','view'),
(7,'lieu','create'),
(7,'lieu','delete'),
(7,'lieu','edit'),
(7,'lieu','personal'),
(7,'lieu','switchstatus'),
(7,'lieu','view'),
(7,'makeup','create'),
(7,'makeup','delete'),
(7,'makeup','edit'),
(7,'makeup','export'),
(7,'makeup','personal'),
(7,'makeup','switchstatus'),
(7,'makeup','view'),
(7,'my','review'),
(7,'ops','index'),
(7,'ops','setting'),
(7,'overtime','create'),
(7,'overtime','delete'),
(7,'overtime','edit'),
(7,'overtime','export'),
(7,'overtime','personal'),
(7,'overtime','switchstatus'),
(7,'overtime','view'),
(7,'serverroom','browse'),
(7,'serverroom','create'),
(7,'serverroom','delete'),
(7,'serverroom','edit'),
(7,'serverroom','view'),
(7,'service','browse'),
(7,'service','create'),
(7,'service','delete'),
(7,'service','edit'),
(7,'service','index'),
(7,'service','manage'),
(7,'service','view'),
(7,'story','browse'),
(8,'attend','company'),
(8,'attend','department'),
(8,'attend','edit'),
(8,'attend','export'),
(8,'attend','exportStat'),
(8,'attend','personal'),
(8,'doc','diff'),
(8,'faq','browse'),
(8,'feedback','admin'),
(8,'feedback','close'),
(8,'feedback','index'),
(8,'host','browse'),
(8,'host','create'),
(8,'host','delete'),
(8,'host','edit'),
(8,'host','treemap'),
(8,'host','view'),
(8,'leave','back'),
(8,'leave','create'),
(8,'leave','delete'),
(8,'leave','edit'),
(8,'leave','export'),
(8,'leave','personal'),
(8,'leave','personalAnnual'),
(8,'leave','switchstatus'),
(8,'leave','view'),
(8,'lieu','create'),
(8,'lieu','delete'),
(8,'lieu','edit'),
(8,'lieu','personal'),
(8,'lieu','switchstatus'),
(8,'lieu','view'),
(8,'makeup','create'),
(8,'makeup','delete'),
(8,'makeup','edit'),
(8,'makeup','export'),
(8,'makeup','personal'),
(8,'makeup','switchstatus'),
(8,'makeup','view'),
(8,'my','review'),
(8,'ops','index'),
(8,'overtime','create'),
(8,'overtime','delete'),
(8,'overtime','edit'),
(8,'overtime','export'),
(8,'overtime','personal'),
(8,'overtime','switchstatus'),
(8,'overtime','view'),
(8,'testtask','deployCaseResults'),
(8,'testtask','runDeployCase'),
(8,'tree','browsehost'),
(9,'account','browse'),
(9,'account','view'),
(9,'attend','browseReview'),
(9,'attend','company'),
(9,'attend','department'),
(9,'attend','detail'),
(9,'attend','edit'),
(9,'attend','export'),
(9,'attend','exportDetail'),
(9,'attend','exportStat'),
(9,'attend','personal'),
(9,'attend','personalSettings'),
(9,'attend','review'),
(9,'attend','saveStat'),
(9,'attend','setManager'),
(9,'attend','settings'),
(9,'attend','stat'),
(9,'deploy','browse'),
(9,'deploy','view'),
(9,'deploy','viewStep'),
(9,'doc','diff'),
(9,'domain','browse'),
(9,'domain','view'),
(9,'faq','browse'),
(9,'feedback','admin'),
(9,'feedback','adminView'),
(9,'feedback','index'),
(9,'feedback','view'),
(9,'holiday','browse'),
(9,'holiday','create'),
(9,'holiday','delete'),
(9,'holiday','edit'),
(9,'host','browse'),
(9,'host','treemap'),
(9,'host','view'),
(9,'leave','back'),
(9,'leave','browseReview'),
(9,'leave','company'),
(9,'leave','create'),
(9,'leave','delete'),
(9,'leave','edit'),
(9,'leave','export'),
(9,'leave','personal'),
(9,'leave','personalAnnual'),
(9,'leave','review'),
(9,'leave','setReviewer'),
(9,'leave','switchstatus'),
(9,'leave','view'),
(9,'lieu','browseReview'),
(9,'lieu','company'),
(9,'lieu','create'),
(9,'lieu','delete'),
(9,'lieu','edit'),
(9,'lieu','personal'),
(9,'lieu','review'),
(9,'lieu','setReviewer'),
(9,'lieu','switchstatus'),
(9,'lieu','view'),
(9,'makeup','browseReview'),
(9,'makeup','company'),
(9,'makeup','create'),
(9,'makeup','delete'),
(9,'makeup','edit'),
(9,'makeup','export'),
(9,'makeup','personal'),
(9,'makeup','review'),
(9,'makeup','setReviewer'),
(9,'makeup','switchstatus'),
(9,'makeup','view'),
(9,'my','review'),
(9,'ops','index'),
(9,'overtime','browseReview'),
(9,'overtime','company'),
(9,'overtime','create'),
(9,'overtime','delete'),
(9,'overtime','edit'),
(9,'overtime','export'),
(9,'overtime','personal'),
(9,'overtime','review'),
(9,'overtime','setReviewer'),
(9,'overtime','switchstatus'),
(9,'overtime','view'),
(9,'serverroom','browse'),
(9,'serverroom','view'),
(9,'service','browse'),
(9,'service','index'),
(9,'service','view'),
(10,'attend','company'),
(10,'attend','department'),
(10,'attend','edit'),
(10,'attend','export'),
(10,'attend','personal'),
(10,'doc','diff'),
(10,'holiday','browse'),
(10,'holiday','create'),
(10,'holiday','delete'),
(10,'holiday','edit'),
(10,'leave','back'),
(10,'leave','create'),
(10,'leave','delete'),
(10,'leave','edit'),
(10,'leave','export'),
(10,'leave','personal'),
(10,'leave','personalAnnual'),
(10,'leave','switchstatus'),
(10,'leave','view'),
(10,'lieu','create'),
(10,'lieu','delete'),
(10,'lieu','edit'),
(10,'lieu','personal'),
(10,'lieu','switchstatus'),
(10,'lieu','view'),
(10,'makeup','create'),
(10,'makeup','delete'),
(10,'makeup','edit'),
(10,'makeup','export'),
(10,'makeup','personal'),
(10,'makeup','switchstatus'),
(10,'makeup','view'),
(10,'my','review'),
(10,'overtime','create'),
(10,'overtime','delete'),
(10,'overtime','edit'),
(10,'overtime','export'),
(10,'overtime','personal'),
(10,'overtime','switchstatus'),
(10,'overtime','view'),
(11,'holiday','browse'),
(11,'holiday','create'),
(11,'holiday','delete'),
(11,'holiday','edit');
-- DROP TABLE IF EXISTS `zt_workflow`;
CREATE TABLE IF NOT EXISTS `zt_workflow` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` varchar(30) NOT NULL,
  `child` varchar(30) NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `app` varchar(20) NOT NULL,
  `position` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `table` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  `titleField` varchar(30) NOT NULL,
  `contentField` text NOT NULL,
  `flowchart` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `administrator` text NOT NULL,
  `desc` text NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`app`, `module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowaction`;
CREATE TABLE IF NOT EXISTS `zt_workflowaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` enum('single', 'batch') NOT NULL DEFAULT 'single',
  `batchMode` enum('same', 'different') NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override' COMMENT 'none | extend | override',
  `open` varchar(20) NOT NULL,
  `position` enum('menu', 'browseandview', 'browse', 'view') NOT NULL DEFAULT 'browseandview',
  `layout` char(20) NOT NULL,
  `show` enum('dropdownlist', 'direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `virtual` tinyint(1) unsigned NOT NULL,
  `conditions` text NOT NULL,
  `verifications` text NOT NULL,
  `hooks` text NOT NULL,
  `linkages` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `toList` char(255) NOT NULL,
  `blocks` text NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'enable',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowdatasource`;
CREATE TABLE IF NOT EXISTS `zt_workflowdatasource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'sql', 'func', 'option', 'lang', 'category') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL,
  `code` varchar(30) NOT NULL,
  `datasource` text NOT NULL,
  `view` varchar(20) NOT NULL,
  `keyField` varchar(50) NOT NULL,
  `valueField` varchar(50) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowfield`;
CREATE TABLE IF NOT EXISTS `zt_workflowfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  `control` varchar(20) NOT NULL,
  `expression` text NOT NULL,
  `options` text NOT NULL,
  `default` varchar(100) NOT NULL,
  `rules` varchar(255) NOT NULL,
  `placeholder` varchar(100) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `searchOrder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `exportOrder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `canExport` enum('0', '1') NOT NULL DEFAULT '0',
  `canSearch` enum('0', '1') NOT NULL DEFAULT '0',
  `isValue` enum('0', '1') NOT NULL DEFAULT '0',
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `buildin` tinyint(1) unsigned NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `width` smallint(5) NOT NULL,
  `position` text NOT NULL,
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `mobileShow` enum('0', '1') NOT NULL DEFAULT '1',
  `summary` varchar(20) NOT NULL,
  `defaultValue` text NOT NULL,
  `layoutRules` varchar(255) NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlabel`;
CREATE TABLE IF NOT EXISTS `zt_workflowlabel` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(30) NOT NULL DEFAULT 'browse',
  `code` varchar(30) NOT NULL,
  `label` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `orderBy` text NOT NULL,
  `order` tinyint(3) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlinkdata`;
CREATE TABLE IF NOT EXISTS `zt_workflowlinkdata` (
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `linkedType` varchar(30) NOT NULL,
  `linkedID` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  UNIQUE KEY `unique` (`objectType`, `objectID`, `linkedType`, `linkedID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelation`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL,
  `next` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `actions` varchar(20) NOT NULL,
  `actionCodes` text NOT NULL,
  `buildin` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelationlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelationlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL,
  `next` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field` varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`prev`, `next`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrule`;
CREATE TABLE IF NOT EXISTS `zt_workflowrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'regex', 'func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL,
  `rule` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowsql`;
CREATE TABLE IF NOT EXISTS `zt_workflowsql` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowversion`;
CREATE TABLE IF NOT EXISTS `zt_workflowversion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `version` varchar(10) NOT NULL,
  `fields` text NOT NULL,
  `actions` text NOT NULL,
  `layouts` text NOT NULL,
  `sqls` text NOT NULL,
  `labels` text NOT NULL,
  `table` text NOT NULL,
  `datas` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`, `version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowreport`;
CREATE TABLE IF NOT EXISTS `zt_workflowreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL COMMENT 'module name',
  `name` varchar(100) NOT NULL COMMENT 'report name',
  `type` enum('pie', 'line', 'bar') NOT NULL DEFAULT 'pie' COMMENT 'report type',
  `countType` enum('sum', 'count') NOT NULL DEFAULT 'sum' COMMENT 'report count method',
  `displayType` enum('value', 'percent') NOT NULL DEFAULT 'value' COMMENT 'report display method',
  `dimension` varchar(130) NOT NULL COMMENT 'dimension field code of zt_workflowfield',
  `fields` text NOT NULL COMMENT 'count fileds code of zt_workflowfield,use comma split',
  `order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_action` CHANGE `action` `action` varchar(80) NOT NULL DEFAULT '';
ALTER TABLE `zt_action` CHANGE `extra` `extra` text;
ALTER TABLE `zt_file` CHANGE `objectType` `objectType` char(30) NOT NULL;

INSERT INTO `zt_workflowrule` VALUES (1,'system','必填','notempty','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(2,'system','唯一','unique','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(3,'system','日期','date','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(4,'system','email','email','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(5,'system','数字','float','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(6,'system','电话','phone','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(7,'system','IP','ip','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00');

REPLACE INTO `zt_grouppriv` VALUES
(1,'apppriv','flow'),
(1,'workflow','activate'),
(1,'workflow','backup'),
(1,'workflow','browseDB'),
(1,'workflow','browseFlow'),
(1,'workflow','copy'),
(1,'workflow','create'),
(1,'workflow','deactivate'),
(1,'workflow','delete'),
(1,'workflow','edit'),
(1,'workflow','flowchart'),
(1,'workflow','setCSS'),
(1,'workflow','setJS'),
(1,'workflow','release'),
(1,'workflow','ui'),
(1,'workflow','upgrade'),
(1,'workflow','view'),
(1,'workflowaction','browse'),
(1,'workflowaction','create'),
(1,'workflowaction','delete'),
(1,'workflowaction','edit'),
(1,'workflowaction','setCSS'),
(1,'workflowaction','setJS'),
(1,'workflowaction','setNotice'),
(1,'workflowaction','setVerification'),
(1,'workflowaction','sort'),
(1,'workflowaction','view'),
(1,'workflowcondition','browse'),
(1,'workflowcondition','create'),
(1,'workflowcondition','delete'),
(1,'workflowcondition','edit'),
(1,'workflowdatasource','browse'),
(1,'workflowdatasource','create'),
(1,'workflowdatasource','delete'),
(1,'workflowdatasource','edit'),
(1,'workflowfield','browse'),
(1,'workflowfield','create'),
(1,'workflowfield','delete'),
(1,'workflowfield','edit'),
(1,'workflowfield','export'),
(1,'workflowfield','exportTemplate'),
(1,'workflowfield','setValue'),
(1,'workflowfield','setExport'),
(1,'workflowfield','setSearch'),
(1,'workflowfield','showImport'),
(1,'workflowfield','sort'),
(1,'workflowfield','import'),
(1,'workflowhook','browse'),
(1,'workflowhook','create'),
(1,'workflowhook','delete'),
(1,'workflowhook','edit'),
(1,'workflowlabel','browse'),
(1,'workflowlabel','create'),
(1,'workflowlabel','delete'),
(1,'workflowlabel','edit'),
(1,'workflowlabel','sort'),
(1,'workflowlayout','admin'),
(1,'workflowlayout','block'),
(1,'workflowlinkage','browse'),
(1,'workflowlinkage','create'),
(1,'workflowlinkage','delete'),
(1,'workflowlinkage','edit'),
(1,'workflowrelation','admin'),
(1,'workflowreport','browse'),
(1,'workflowreport','create'),
(1,'workflowreport','edit'),
(1,'workflowreport','delete'),
(1,'workflowreport','sort'),
(1,'workflowrule','browse'),
(1,'workflowrule','create'),
(1,'workflowrule','delete'),
(1,'workflowrule','edit'),
(1,'workflowrule','view');

ALTER TABLE `zt_workflow` ADD `navigator` varchar(10) NOT NULL AFTER `type`;
ALTER TABLE `zt_workflow` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `status`;
ALTER TABLE `zt_workflowdatasource` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `buildin`;
ALTER TABLE `zt_workflowaction` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `status`;
ALTER TABLE `zt_workflowlayout` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd';

ALTER TABLE `zt_workflow` DROP INDEX `unique`;
ALTER TABLE `zt_workflow` ADD UNIQUE `unique` (`app`, `module`, `vision`);
ALTER TABLE `zt_workflowaction` DROP INDEX `unique`;
ALTER TABLE `zt_workflowaction` ADD UNIQUE `unique` (`module`, `action`, `vision`);
ALTER TABLE `zt_workflowlayout` DROP INDEX `unique`;
ALTER TABLE `zt_workflowlayout` ADD UNIQUE `unique` (`module`, `action`, `field`, `vision`);

INSERT INTO `zt_workflowdatasource` (`type`, `name`, `code`, `buildin`, `datasource`, `view`, `keyField`, `valueField`) VALUES
('system',      '产品',           'products',        '1', '{\"app\":\"system\",\"module\":\"product\",\"method\":\"getPairs\",\"methodDesc\":\"Get product pairs.\",\"params\":[{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"\",\"value\":\"all\"}]}',       '',     '',     ''),
('system',      '项目',           'projects',        '1', '{\"app\":\"system\",\"module\":\"project\",\"method\":\"getPairsByModel\",\"methodDesc\":\"Get project pairs by model and project.\",\"params\":[{\"name\":\"model\",\"type\":\"string\",\"desc\":\"all|scrum|waterfall\",\"value\":\"all\"},{\"name\":\"programID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"param\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('system',      '产品线',         'productLines',    '1', '{\"app\":\"system\",\"module\":\"product\",\"method\":\"getLinePairs\",\"methodDesc\":\"Get line pairs.\",\"params\":[{\"name\":\"useShort\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('sql',         '需求',           'stories',         '1', 'select id,title from zt_story where deleted=\"0\"',    'view_datasource_4',    'id',   'title'),
('sql',         '任务',           'tasks',           '1', 'select id,name from zt_task where deleted=\"0\" and vision=\"rnd\"',      'view_datasource_5',    'id',   'name'),
('sql',         'Bug',            'bugs',            '1', 'select id,title from zt_bug where deleted=\"0\"',      'view_datasource_6',    'id',   'title'),
('system',      '权限分组',       'groups',          '1', '{\"app\":\"system\",\"module\":\"group\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[]}',  '',     '',     ''),
('system',      '用户',           'users',           '1', '{\"app\":\"system\",\"module\":\"user\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[{\"name\":\"params\",\"type\":\"\",\"desc\":\"\",\"value\":\"noclosed|noletter\"},{\"name\":\"usersToAppended\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',        '',     '',     ''),
('system',      '产品分支',       'branches',        '1', '{\"app\":\"system\",\"module\":\"branch\",\"method\":\"getAllPairs\",\"methodDesc\":\"Get pairs.\",\"params\":[{\"name\":\"params\",\"type\":\"string\",\"desc\":\"\",\"value\":\"\"}]}',      '',     '',     ''),
('sql',         '版本',           'builds',          '1', 'select id,name from zt_build where deleted=\"0\"',     'view_datasource_10',   'id',   'name'),
('sql',         '模块',           'modules',         '1', 'select id,name from zt_module where deleted=\"0\"',    'view_datasource_11',   'id',   'name'),
('sql',         '计划',           'plans',           '1', 'select id,title from zt_productplan where deleted=\"0\"',      'view_datasource_12',   'id',   'title'),
('lang',        '产品类型',       'productType',     '1', 'productType',    '',     '',     ''),
('lang',        '产品状态',       'productStatus',   '1', 'productStatus',  '',     '',     ''),
('lang',        '产品访问控制',   'productAcl',      '1', 'productAcl',     '',     '',     ''),
('lang',        '项目类型',       'projectType',     '1', 'projectType',    '',     '',     ''),
('lang',        '项目状态',       'projectStatus',   '1', 'projectStatus',  '',     '',     ''),
('lang',        '项目访问控制',   'projectAcl',      '1', 'projectAcl',     '',     '',     ''),
('lang',        '发布状态',       'releaseStatus',   '1', 'releaseStatus',  '',     '',     ''),
('lang',        '需求来源',       'storySource',     '1', 'storySource',    '',     '',     ''),
('lang',        '需求优先级',     'storyPri',        '1', 'storyPri',       '',     '',     ''),
('lang',        '需求状态',       'storyStatus',     '1', 'storyStatus',    '',     '',     ''),
('lang',        '需求阶段',       'storyStage',      '1', 'storyStage',     '',     '',     ''),
('lang',        'Bug严重程度',    'bugSeverity',     '1', 'bugSeverity',    '',     '',     ''),
('lang',        'Bug优先级',      'bugPri',          '1', 'bugPri',         '',     '',     ''),
('lang',        'Bug类型',        'bugType',         '1', 'bugType',        '',     '',     ''),
('lang',        'Bug操作系统',    'bugOs',           '1', 'bugOs',          '',     '',     ''),
('lang',        'Bug浏览器',      'bugBrowser',      '1', 'bugBrowser',     '',     '',     ''),
('lang',        'Bug状态',        'bugStatus',       '1', 'bugStatus',      '',     '',     ''),
('lang',        '任务类型',       'taskType',        '1', 'taskType',       '',     '',     ''),
('lang',        '任务优先级',     'taskPri',         '1', 'taskPri',        '',     '',     ''),
('lang',        '任务状态',       'taskStatus',      '1', 'taskStatus',     '',     '',     ''),
('lang',        '测试用例优先级', 'testcasePri',     '1', 'testcasePri',    '',     '',     ''),
('lang',        '测试用例类型',   'testcaseType',    '1', 'testcaseType',   '',     '',     ''),
('lang',        '测试用例阶段',   'testcaseStage',   '1', 'testcaseStage',  '',     '',     ''),
('lang',        '测试用例状态',   'testcaseStatus',  '1', 'testcaseStatus', '',     '',     ''),
('lang',        '测试单优先级',   'testtaskPri',     '1', 'testtaskPri',    '',     '',     ''),
('lang',        '测试单状态',     'testtaskStatus',  '1', 'testtaskStatus', '',     '',     ''),
('lang',        '反馈状态',       'feedbackStatus',  '1', 'feedbackStatus', '',     '',     ''),
('lang',        'Bug解决方案',    'bugResolution',   '1', 'bugResolution',  '',     '',     ''),
('sql',         '用例',           'cases',           '1', 'select id,title from zt_case where deleted=\"0\"',     'view_datasource_41',   'id',   'title'),
('system',      '反馈分支',       'feedbackModules', '1', '{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getOptionMenu\",\"methodDesc\":\"Create an option menu in html.\",\"params\":[{\"name\":\"rootID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"\",\"value\":\"feedback\"},{\"name\":\"startModule\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"branch\",\"type\":\"\",\"desc\":\"\",\"value\":\"0\"}]}',   '',     '',     ''),
('lang',        '需求类型',       'storyType',       '1', 'storyType',    '',     '',     ''),
('system',	'执行',	          'executions',      '1', '{\"app\":\"system\",\"module\":\"execution\",\"method\":\"getPairs\",\"methodDesc\":\"Get execution pairs.\",\"params\":[{\"name\":\"projectID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"all|sprint|stage|kanban\",\"value\":\"all\"},{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"all|noclosed|stagefilter or empty\",\"value\":\"\"}]}',  '',     '',     '');

INSERT INTO `zt_workflowdatasource` (`type`, `name`, `code`, `buildin`, `vision`, `datasource`, `view`, `keyField`, `valueField`) VALUES
('system',      '项目',           'liteprojects',        '1', 'lite', '{\"app\":\"system\",\"module\":\"project\",\"method\":\"getPairsByModel\",\"methodDesc\":\"Get project pairs by model and project.\",\"params\":[{\"name\":\"model\",\"type\":\"string\",\"desc\":\"all|scrum|waterfall\",\"value\":\"all\"},{\"name\":\"programID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"param\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('sql',         '任务',           'litetasks',           '1', 'lite', 'select id,name from zt_task where deleted=\"0\" and vision=\"lite\"',      'view_datasource_46',    'id',   'name'),
('system',      '权限分组',       'litegroups',          '1', 'lite', '{\"app\":\"system\",\"module\":\"group\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[]}',  '',     '',     ''),
('system',      '用户',           'liteusers',           '1', 'lite', '{\"app\":\"system\",\"module\":\"user\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[{\"name\":\"params\",\"type\":\"\",\"desc\":\"\",\"value\":\"noclosed|noletter\"},{\"name\":\"usersToAppended\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',        '',     '',     ''),
('sql',         '模块',           'litemodules',         '1', 'lite', 'select id,name from zt_module where deleted=\"0\"',    'view_datasource_11',   'id',   'name'),
('lang',        '项目类型',       'liteprojectType',     '1', 'lite', 'projectType',    '',     '',     ''),
('lang',        '项目状态',       'liteprojectStatus',   '1', 'lite', 'projectStatus',  '',     '',     ''),
('lang',        '项目访问控制',   'liteprojectAcl',      '1', 'lite', 'projectAcl',     '',     '',     ''),
('lang',        '任务类型',       'litetaskType',        '1', 'lite', 'taskType',       '',     '',     ''),
('lang',        '任务优先级',     'litetaskPri',         '1', 'lite', 'taskPri',        '',     '',     ''),
('lang',        '任务状态',       'litetaskStatus',      '1', 'lite', 'taskStatus',     '',     '',     ''),
('lang',        '反馈状态',       'litefeedbackStatus',  '1', 'lite', 'feedbackStatus', '',     '',     ''),
('system',      '反馈分支',       'litefeedbackModules', '1', 'lite', '{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getOptionMenu\",\"methodDesc\":\"Create an option menu in html.\",\"params\":[{\"name\":\"rootID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"\",\"value\":\"feedback\"},{\"name\":\"startModule\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"branch\",\"type\":\"\",\"desc\":\"\",\"value\":\"0\"}]}',   '',     '',     '');

DROP VIEW IF EXISTS `view_datasource_4`;
DROP VIEW IF EXISTS `view_datasource_5`;
DROP VIEW IF EXISTS `view_datasource_6`;
DROP VIEW IF EXISTS `view_datasource_10`;
DROP VIEW IF EXISTS `view_datasource_11`;
DROP VIEW IF EXISTS `view_datasource_12`;
DROP VIEW IF EXISTS `view_datasource_41`;
DROP VIEW IF EXISTS `view_datasource_46`;

CREATE VIEW `view_datasource_4`  AS select `id`,`title` from `zt_story` where `deleted` = '0';
CREATE VIEW `view_datasource_5`  AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'rnd';
CREATE VIEW `view_datasource_6`  AS select `id`,`title` from `zt_bug` where `deleted` = '0';
CREATE VIEW `view_datasource_10` AS select `id`,`name` from `zt_build` where `deleted` = '0';
CREATE VIEW `view_datasource_11` AS select `id`,`name` from `zt_module` where `deleted` = '0';
CREATE VIEW `view_datasource_12` AS select `id`,`title` from `zt_productplan` where `deleted` = '0';
CREATE VIEW `view_datasource_41` AS select `id`,`title` from `zt_case` where `deleted` = '0';
CREATE VIEW `view_datasource_46` AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'lite';
