<?php include '../../common/view/header.html.php';?>
<?php include '../../common/view/kindeditor.html.php';?>
<div id="mainContent" class="main-content fade">
  <div class="center-block">
    <div class="main-header">
      <h2><?php echo $lang->review->create;?></h2>
    </div>
    <form class="load-indicator main-form form-ajax" method='post' enctype='multipart/form-data' id='dataform'>
      <table class="table table-form">
        <tbody>
          <tr>
            <th><?php echo $lang->review->product;?></th>
            <td class="required"><?php echo html::select('product', $products, $productID, "class='form-control chosen'");?></td>
          </tr>
          <tr>
            <th class='w-120px'><?php echo $lang->review->object;?></th>
            <td><?php echo html::select('object', $lang->baseline->objectList, $object, "class='form-control chosen'");?></td>
            <td></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->template;?></th>
            <td><?php echo html::select('template', '', '', "class='form-control chosen'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->title;?></th>
            <td><?php echo html::input('title', '', "class='form-control'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->reviewedBy;?></th>
            <td><?php echo html::select('reviewedBy[]', $reviewers, '', "class='form-control chosen' multiple");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->deadline;?></th>
            <td><?php echo html::input('deadline', '', "class='form-date form-control'");?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->file;?></th>
            <td colspan='2'><?php echo $this->fetch('file', 'buildform', 'fileCount=1&percent=0.85');?></td>
          </tr>
          <tr>
            <th><?php echo $lang->review->comment;?></th>
            <td colspan='2'><?php echo html::textarea('comment', '', "class='form-control'");?></td>
          </tr>
          <tr>
            <td colspan='3' class='form-actions text-center'><?php echo html::submitButton() . html::a($backLink, $lang->goback, '', "class='btn btn-wide'");?></td>
          </tr>
        </tbody>
      </table>
    </form>
  </div>
</div>
<?php js::set('projectID', $projectID)?>
<?php js::set('reviewText', $lang->review->common)?>
<script>
$('#object').change(function()
{
    var text = reviewText + $(this).find("option:selected").text();
    $('#title').val(text);

    var type = $(this).val();
    if(type == 'PP')
    {
        $('#template').closest('tr').addClass('hide');
    }
    else
    {
        $('#template').closest('tr').removeClass('hide');
    }

    var link = createLink('review', 'ajaxGetRole', "project=" + projectID + '&object=' + type);
    $.post(link, function(data)
    {
        $('#reviewedBy').replaceWith(data);
        $('#reviewedBy_chosen').remove();
        $('#reviewedBy').chosen();
    })

    var link = createLink('baseline', 'ajaxGetTemplates', 'type=' + type);
    $.post(link, function(data)
    {
        $('#template').replaceWith(data);
        $('#template_chosen').remove();
        $('#template').chosen();
    })
})

$('#object').change();
</script>
<?php include '../../common/view/footer.html.php';?>
