<?php if(isset($from) and $from == 'template'):?>
<?php
$html  = '<tr>';
$html .= '<th>';
$html .= $lang->doc->templateType;
$html .= '</th>';
$html .= '<td>';
$html .= html::select('templateType', $lang->baseline->objectList, '', "class='form-control chosen' onchange=loadTemplates(this.value)");
$html .= '</td>';
$html .= '</tr>';

$html .= '<tr>';
$html .= '<th>';
$html .= $lang->doc->template;
$html .= '</th>';
$html .= '<td>';
$html .= html::select('template', '', '', "class='form-control chosen' onchange=loadContent(this.value)");
$html .= '</td>';
$html .= '</tr>';
?>

<script>
$('#module').closest('tr').after(<?php echo json_encode($html)?>);
$('#templateType').chosen();
$('#template').chosen();

function loadTemplates(type)
{
    var link = createLink('baseline', 'ajaxGetTemplates', 'type=' + type + '&from=doc');
    $.post(link, function(data)
    {
        $('#template').replaceWith(data); 
        $('#template_chosen').remove();
        $('#template').chosen();
    })

    $('#contentType').val('text');
    editor['content'].html('');
    $('#contentBox').removeClass('hidden');
    $('.contenthtml').removeClass('hidden');
    $('.contentmarkdown').addClass('hidden');
    $('#urlBox').addClass('hidden');
}

function loadContent(templateID)
{
    var link = createLink('baseline', 'ajaxGetContent', 'templateID=' + templateID);
    $.post(link, function(data)
    {
        data = JSON.parse(data);    
        var type = data.type;
        if(type == 'html') type = 'text';
        $('input[id*=' + type + ']').attr('checked', 'checked');
        toggleEditor(data.type);

        if(data.type == 'html')
        {   
            var cmd = editor['content'].edit.cmd;
            editor['content'].html('');
            cmd.inserthtml(data.content);
        }   
        else if(data.type == 'markdown')
        {   
            markdownEditor['contentMarkdown'].value(data.content); 
        }   
        else if(data.type == 'url')
        {   
            $('#url').val(data.content); 
        }   
    })
}

function toggleEditor(type)
{   
    $('#contentType').val(type);
    if(type == 'html')
    {   
        $('#contentBox').removeClass('hidden');
        $('.contenthtml').removeClass('hidden');
        $('.contentmarkdown').addClass('hidden');
        $('#urlBox').addClass('hidden');
    }
    else if(type == 'markdown')
    {   
        $('.contentmarkdown').removeClass('hidden');
        $('.contenthtml').addClass('hidden');
        $('#urlBox').addClass('hidden');
    }
    else if(type == 'url')
    {   
        $('#urlBox').removeClass('hidden');
        $('#contentBox').addClass('hidden');
    }
    return false;
}
</script>
<?php endif;?>
